
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTextBrowser.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QTextBrowser>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QColor>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEnterEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMenu>
#include <QMetaMethod>
#include <QMimeData>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPagedPaintDevice>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QPointF>
#include <QRect>
#include <QRegion>
#include <QRegularExpression>
#include <QResizeEvent>
#include <QScreen>
#include <QScrollBar>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QStyleOptionFrame>
#include <QTabletEvent>
#include <QTextCharFormat>
#include <QTextCursor>
#include <QTextDocument>
#include <QThread>
#include <QTimerEvent>
#include <QUrl>
#include <QWheelEvent>
#include <QWidget>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTextBrowser

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QTextBrowser::staticMetaObject);
}


// void QTextBrowser::backward()


static void _init_f_backward_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_backward_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser *)cls)->backward ();
}


// int QTextBrowser::backwardHistoryCount()


static void _init_f_backwardHistoryCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_backwardHistoryCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextBrowser *)cls)->backwardHistoryCount ());
}


// void QTextBrowser::clearHistory()


static void _init_f_clearHistory_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearHistory_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser *)cls)->clearHistory ();
}


// void QTextBrowser::forward()


static void _init_f_forward_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_forward_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser *)cls)->forward ();
}


// int QTextBrowser::forwardHistoryCount()


static void _init_f_forwardHistoryCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_forwardHistoryCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextBrowser *)cls)->forwardHistoryCount ());
}


// QString QTextBrowser::historyTitle(int)


static void _init_f_historyTitle_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_historyTitle_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)((QTextBrowser *)cls)->historyTitle (arg1));
}


// QUrl QTextBrowser::historyUrl(int)


static void _init_f_historyUrl_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QUrl > ();
}

static void _call_f_historyUrl_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QUrl > ((QUrl)((QTextBrowser *)cls)->historyUrl (arg1));
}


// void QTextBrowser::home()


static void _init_f_home_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_home_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser *)cls)->home ();
}


// bool QTextBrowser::isBackwardAvailable()


static void _init_f_isBackwardAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isBackwardAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextBrowser *)cls)->isBackwardAvailable ());
}


// bool QTextBrowser::isForwardAvailable()


static void _init_f_isForwardAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isForwardAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextBrowser *)cls)->isForwardAvailable ());
}


// QVariant QTextBrowser::loadResource(int type, const QUrl &name)


static void _init_f_loadResource_2360 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name");
  decl->add_arg<const QUrl & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_loadResource_2360 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QUrl &arg2 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QTextBrowser *)cls)->loadResource (arg1, arg2));
}


// bool QTextBrowser::openExternalLinks()


static void _init_f_openExternalLinks_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_openExternalLinks_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextBrowser *)cls)->openExternalLinks ());
}


// bool QTextBrowser::openLinks()


static void _init_f_openLinks_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_openLinks_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextBrowser *)cls)->openLinks ());
}


// void QTextBrowser::reload()


static void _init_f_reload_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_reload_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser *)cls)->reload ();
}


// QStringList QTextBrowser::searchPaths()


static void _init_f_searchPaths_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_searchPaths_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QTextBrowser *)cls)->searchPaths ());
}


// void QTextBrowser::setOpenExternalLinks(bool open)


static void _init_f_setOpenExternalLinks_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("open");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOpenExternalLinks_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser *)cls)->setOpenExternalLinks (arg1);
}


// void QTextBrowser::setOpenLinks(bool open)


static void _init_f_setOpenLinks_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("open");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOpenLinks_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser *)cls)->setOpenLinks (arg1);
}


// void QTextBrowser::setSearchPaths(const QStringList &paths)


static void _init_f_setSearchPaths_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("paths");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSearchPaths_2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser *)cls)->setSearchPaths (arg1);
}


// void QTextBrowser::setSource(const QUrl &name, QTextDocument::ResourceType type)


static void _init_f_setSource_4736 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QUrl & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type", true, "QTextDocument::UnknownResource");
  decl->add_arg<const qt_gsi::Converter<QTextDocument::ResourceType>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSource_4736 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  const qt_gsi::Converter<QTextDocument::ResourceType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QTextDocument::ResourceType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QTextDocument::ResourceType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QTextDocument::ResourceType>(heap, QTextDocument::UnknownResource), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser *)cls)->setSource (arg1, qt_gsi::QtToCppAdaptor<QTextDocument::ResourceType>(arg2).cref());
}


// QUrl QTextBrowser::source()


static void _init_f_source_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QUrl > ();
}

static void _call_f_source_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QUrl > ((QUrl)((QTextBrowser *)cls)->source ());
}


// QTextDocument::ResourceType QTextBrowser::sourceType()


static void _init_f_sourceType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTextDocument::ResourceType>::target_type > ();
}

static void _call_f_sourceType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QTextDocument::ResourceType>::target_type > ((qt_gsi::Converter<QTextDocument::ResourceType>::target_type)qt_gsi::CppToQtAdaptor<QTextDocument::ResourceType>(((QTextBrowser *)cls)->sourceType ()));
}


// static QString QTextBrowser::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QTextBrowser::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QTextBrowser () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("backward", "@brief Method void QTextBrowser::backward()\n", false, &_init_f_backward_0, &_call_f_backward_0);
  methods += new qt_gsi::GenericMethod ("backwardHistoryCount", "@brief Method int QTextBrowser::backwardHistoryCount()\n", true, &_init_f_backwardHistoryCount_c0, &_call_f_backwardHistoryCount_c0);
  methods += new qt_gsi::GenericMethod ("clearHistory", "@brief Method void QTextBrowser::clearHistory()\n", false, &_init_f_clearHistory_0, &_call_f_clearHistory_0);
  methods += new qt_gsi::GenericMethod ("forward", "@brief Method void QTextBrowser::forward()\n", false, &_init_f_forward_0, &_call_f_forward_0);
  methods += new qt_gsi::GenericMethod ("forwardHistoryCount", "@brief Method int QTextBrowser::forwardHistoryCount()\n", true, &_init_f_forwardHistoryCount_c0, &_call_f_forwardHistoryCount_c0);
  methods += new qt_gsi::GenericMethod ("historyTitle", "@brief Method QString QTextBrowser::historyTitle(int)\n", true, &_init_f_historyTitle_c767, &_call_f_historyTitle_c767);
  methods += new qt_gsi::GenericMethod ("historyUrl", "@brief Method QUrl QTextBrowser::historyUrl(int)\n", true, &_init_f_historyUrl_c767, &_call_f_historyUrl_c767);
  methods += new qt_gsi::GenericMethod ("home", "@brief Method void QTextBrowser::home()\n", false, &_init_f_home_0, &_call_f_home_0);
  methods += new qt_gsi::GenericMethod ("isBackwardAvailable?", "@brief Method bool QTextBrowser::isBackwardAvailable()\n", true, &_init_f_isBackwardAvailable_c0, &_call_f_isBackwardAvailable_c0);
  methods += new qt_gsi::GenericMethod ("isForwardAvailable?", "@brief Method bool QTextBrowser::isForwardAvailable()\n", true, &_init_f_isForwardAvailable_c0, &_call_f_isForwardAvailable_c0);
  methods += new qt_gsi::GenericMethod ("loadResource", "@brief Method QVariant QTextBrowser::loadResource(int type, const QUrl &name)\nThis is a reimplementation of QTextEdit::loadResource", false, &_init_f_loadResource_2360, &_call_f_loadResource_2360);
  methods += new qt_gsi::GenericMethod (":openExternalLinks", "@brief Method bool QTextBrowser::openExternalLinks()\n", true, &_init_f_openExternalLinks_c0, &_call_f_openExternalLinks_c0);
  methods += new qt_gsi::GenericMethod (":openLinks", "@brief Method bool QTextBrowser::openLinks()\n", true, &_init_f_openLinks_c0, &_call_f_openLinks_c0);
  methods += new qt_gsi::GenericMethod ("reload", "@brief Method void QTextBrowser::reload()\n", false, &_init_f_reload_0, &_call_f_reload_0);
  methods += new qt_gsi::GenericMethod (":searchPaths", "@brief Method QStringList QTextBrowser::searchPaths()\n", true, &_init_f_searchPaths_c0, &_call_f_searchPaths_c0);
  methods += new qt_gsi::GenericMethod ("setOpenExternalLinks|openExternalLinks=", "@brief Method void QTextBrowser::setOpenExternalLinks(bool open)\n", false, &_init_f_setOpenExternalLinks_864, &_call_f_setOpenExternalLinks_864);
  methods += new qt_gsi::GenericMethod ("setOpenLinks|openLinks=", "@brief Method void QTextBrowser::setOpenLinks(bool open)\n", false, &_init_f_setOpenLinks_864, &_call_f_setOpenLinks_864);
  methods += new qt_gsi::GenericMethod ("setSearchPaths|searchPaths=", "@brief Method void QTextBrowser::setSearchPaths(const QStringList &paths)\n", false, &_init_f_setSearchPaths_2437, &_call_f_setSearchPaths_2437);
  methods += new qt_gsi::GenericMethod ("setSource", "@brief Method void QTextBrowser::setSource(const QUrl &name, QTextDocument::ResourceType type)\n", false, &_init_f_setSource_4736, &_call_f_setSource_4736);
  methods += new qt_gsi::GenericMethod (":source", "@brief Method QUrl QTextBrowser::source()\n", true, &_init_f_source_c0, &_call_f_source_c0);
  methods += new qt_gsi::GenericMethod (":sourceType", "@brief Method QTextDocument::ResourceType QTextBrowser::sourceType()\n", true, &_init_f_sourceType_c0, &_call_f_sourceType_c0);
  methods += gsi::qt_signal<const QUrl & > ("anchorClicked(const QUrl &)", "anchorClicked", gsi::arg("arg1"), "@brief Signal declaration for QTextBrowser::anchorClicked(const QUrl &)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("backwardAvailable(bool)", "backwardAvailable", gsi::arg("arg1"), "@brief Signal declaration for QTextBrowser::backwardAvailable(bool)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("copyAvailable(bool)", "copyAvailable", gsi::arg("b"), "@brief Signal declaration for QTextBrowser::copyAvailable(bool b)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QTextCharFormat & > ("currentCharFormatChanged(const QTextCharFormat &)", "currentCharFormatChanged", gsi::arg("format"), "@brief Signal declaration for QTextBrowser::currentCharFormatChanged(const QTextCharFormat &format)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("cursorPositionChanged()", "cursorPositionChanged", "@brief Signal declaration for QTextBrowser::cursorPositionChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QTextBrowser::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QTextBrowser::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("forwardAvailable(bool)", "forwardAvailable", gsi::arg("arg1"), "@brief Signal declaration for QTextBrowser::forwardAvailable(bool)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QUrl & > ("highlighted(const QUrl &)", "highlighted", gsi::arg("arg1"), "@brief Signal declaration for QTextBrowser::highlighted(const QUrl &)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("historyChanged()", "historyChanged", "@brief Signal declaration for QTextBrowser::historyChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QTextBrowser::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("redoAvailable(bool)", "redoAvailable", gsi::arg("b"), "@brief Signal declaration for QTextBrowser::redoAvailable(bool b)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("selectionChanged()", "selectionChanged", "@brief Signal declaration for QTextBrowser::selectionChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QUrl & > ("sourceChanged(const QUrl &)", "sourceChanged", gsi::arg("arg1"), "@brief Signal declaration for QTextBrowser::sourceChanged(const QUrl &)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("textChanged()", "textChanged", "@brief Signal declaration for QTextBrowser::textChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("undoAvailable(bool)", "undoAvailable", gsi::arg("b"), "@brief Signal declaration for QTextBrowser::undoAvailable(bool b)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QTextBrowser::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QTextBrowser::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QTextBrowser::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTextBrowser::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QTextEdit> &qtdecl_QTextEdit ();

qt_gsi::QtNativeClass<QTextBrowser> decl_QTextBrowser (qtdecl_QTextEdit (), "QtWidgets", "QTextBrowser_Native",
  methods_QTextBrowser (),
  "@hide\n@alias QTextBrowser");

GSI_QTWIDGETS_PUBLIC gsi::Class<QTextBrowser> &qtdecl_QTextBrowser () { return decl_QTextBrowser; }

}


class QTextBrowser_Adaptor : public QTextBrowser, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTextBrowser_Adaptor();

  //  [adaptor ctor] QTextBrowser::QTextBrowser(QWidget *parent)
  QTextBrowser_Adaptor() : QTextBrowser()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTextBrowser::QTextBrowser(QWidget *parent)
  QTextBrowser_Adaptor(QWidget *parent) : QTextBrowser(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QTextBrowser::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QTextBrowser_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QTextBrowser::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QTextBrowser::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QTextBrowser_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QTextBrowser::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] void QTextBrowser::drawFrame(QPainter *)
  void fp_QTextBrowser_drawFrame_1426 (QPainter *arg1) {
    QTextBrowser::drawFrame(arg1);
  }

  //  [expose] bool QTextBrowser::focusNextChild()
  bool fp_QTextBrowser_focusNextChild_0 () {
    return QTextBrowser::focusNextChild();
  }

  //  [expose] bool QTextBrowser::focusPreviousChild()
  bool fp_QTextBrowser_focusPreviousChild_0 () {
    return QTextBrowser::focusPreviousChild();
  }

  //  [expose] bool QTextBrowser::isSignalConnected(const QMetaMethod &signal)
  bool fp_QTextBrowser_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QTextBrowser::isSignalConnected(signal);
  }

  //  [expose] int QTextBrowser::receivers(const char *signal)
  int fp_QTextBrowser_receivers_c1731 (const char *signal) const {
    return QTextBrowser::receivers(signal);
  }

  //  [expose] QObject *QTextBrowser::sender()
  QObject * fp_QTextBrowser_sender_c0 () const {
    return QTextBrowser::sender();
  }

  //  [expose] int QTextBrowser::senderSignalIndex()
  int fp_QTextBrowser_senderSignalIndex_c0 () const {
    return QTextBrowser::senderSignalIndex();
  }

  //  [expose] void QTextBrowser::setViewportMargins(int left, int top, int right, int bottom)
  void fp_QTextBrowser_setViewportMargins_2744 (int left, int top, int right, int bottom) {
    QTextBrowser::setViewportMargins(left, top, right, bottom);
  }

  //  [expose] void QTextBrowser::setViewportMargins(const QMargins &margins)
  void fp_QTextBrowser_setViewportMargins_2115 (const QMargins &margins) {
    QTextBrowser::setViewportMargins(margins);
  }

  //  [expose] void QTextBrowser::updateMicroFocus(Qt::InputMethodQuery query)
  void fp_QTextBrowser_updateMicroFocus_2420 (const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) {
    QTextBrowser::updateMicroFocus(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  //  [expose] QMargins QTextBrowser::viewportMargins()
  QMargins fp_QTextBrowser_viewportMargins_c0 () const {
    return QTextBrowser::viewportMargins();
  }

  //  [expose] void QTextBrowser::zoomInF(float range)
  void fp_QTextBrowser_zoomInF_970 (float range) {
    QTextBrowser::zoomInF(range);
  }

  //  [emitter impl] void QTextBrowser::anchorClicked(const QUrl &)
  void emitter_QTextBrowser_anchorClicked_1701(const QUrl &arg1)
  {
    emit QTextBrowser::anchorClicked(arg1);
  }

  //  [adaptor impl] void QTextBrowser::backward()
  void cbs_backward_0_0()
  {
    QTextBrowser::backward();
  }

  virtual void backward()
  {
    if (cb_backward_0_0.can_issue()) {
      cb_backward_0_0.issue<QTextBrowser_Adaptor>(&QTextBrowser_Adaptor::cbs_backward_0_0);
    } else {
      QTextBrowser::backward();
    }
  }

  //  [emitter impl] void QTextBrowser::backwardAvailable(bool)
  void emitter_QTextBrowser_backwardAvailable_864(bool arg1)
  {
    emit QTextBrowser::backwardAvailable(arg1);
  }

  //  [emitter impl] void QTextBrowser::copyAvailable(bool b)
  void emitter_QTextBrowser_copyAvailable_864(bool b)
  {
    emit QTextBrowser::copyAvailable(b);
  }

  //  [emitter impl] void QTextBrowser::currentCharFormatChanged(const QTextCharFormat &format)
  void emitter_QTextBrowser_currentCharFormatChanged_2814(const QTextCharFormat &format)
  {
    emit QTextBrowser::currentCharFormatChanged(format);
  }

  //  [emitter impl] void QTextBrowser::cursorPositionChanged()
  void emitter_QTextBrowser_cursorPositionChanged_0()
  {
    emit QTextBrowser::cursorPositionChanged();
  }

  //  [emitter impl] void QTextBrowser::customContextMenuRequested(const QPoint &pos)
  void emitter_QTextBrowser_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QTextBrowser::customContextMenuRequested(pos);
  }

  //  [emitter impl] void QTextBrowser::destroyed(QObject *)
  void emitter_QTextBrowser_destroyed_1302(QObject *arg1)
  {
    emit QTextBrowser::destroyed(arg1);
  }

  //  [adaptor impl] void QTextBrowser::forward()
  void cbs_forward_0_0()
  {
    QTextBrowser::forward();
  }

  virtual void forward()
  {
    if (cb_forward_0_0.can_issue()) {
      cb_forward_0_0.issue<QTextBrowser_Adaptor>(&QTextBrowser_Adaptor::cbs_forward_0_0);
    } else {
      QTextBrowser::forward();
    }
  }

  //  [emitter impl] void QTextBrowser::forwardAvailable(bool)
  void emitter_QTextBrowser_forwardAvailable_864(bool arg1)
  {
    emit QTextBrowser::forwardAvailable(arg1);
  }

  //  [adaptor impl] bool QTextBrowser::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QTextBrowser::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QTextBrowser_Adaptor, bool>(&QTextBrowser_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QTextBrowser::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QTextBrowser::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QTextBrowser::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QTextBrowser_Adaptor, int, int>(&QTextBrowser_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QTextBrowser::heightForWidth(arg1);
    }
  }

  //  [emitter impl] void QTextBrowser::highlighted(const QUrl &)
  void emitter_QTextBrowser_highlighted_1701(const QUrl &arg1)
  {
    emit QTextBrowser::highlighted(arg1);
  }

  //  [emitter impl] void QTextBrowser::historyChanged()
  void emitter_QTextBrowser_historyChanged_0()
  {
    emit QTextBrowser::historyChanged();
  }

  //  [adaptor impl] void QTextBrowser::home()
  void cbs_home_0_0()
  {
    QTextBrowser::home();
  }

  virtual void home()
  {
    if (cb_home_0_0.can_issue()) {
      cb_home_0_0.issue<QTextBrowser_Adaptor>(&QTextBrowser_Adaptor::cbs_home_0_0);
    } else {
      QTextBrowser::home();
    }
  }

  //  [adaptor impl] QVariant QTextBrowser::inputMethodQuery(Qt::InputMethodQuery property)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & property) const
  {
    return QTextBrowser::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(property).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery property) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QTextBrowser_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QTextBrowser_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(property));
    } else {
      return QTextBrowser::inputMethodQuery(property);
    }
  }

  //  [adaptor impl] QVariant QTextBrowser::loadResource(int type, const QUrl &name)
  QVariant cbs_loadResource_2360_0(int type, const QUrl &name)
  {
    return QTextBrowser::loadResource(type, name);
  }

  virtual QVariant loadResource(int type, const QUrl &name)
  {
    if (cb_loadResource_2360_0.can_issue()) {
      return cb_loadResource_2360_0.issue<QTextBrowser_Adaptor, QVariant, int, const QUrl &>(&QTextBrowser_Adaptor::cbs_loadResource_2360_0, type, name);
    } else {
      return QTextBrowser::loadResource(type, name);
    }
  }

  //  [adaptor impl] QSize QTextBrowser::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QTextBrowser::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QTextBrowser_Adaptor, QSize>(&QTextBrowser_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QTextBrowser::minimumSizeHint();
    }
  }

  //  [emitter impl] void QTextBrowser::objectNameChanged(const QString &objectName)
  void emitter_QTextBrowser_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QTextBrowser::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QPaintEngine *QTextBrowser::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QTextBrowser::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QTextBrowser_Adaptor, QPaintEngine *>(&QTextBrowser_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QTextBrowser::paintEngine();
    }
  }

  //  [emitter impl] void QTextBrowser::redoAvailable(bool b)
  void emitter_QTextBrowser_redoAvailable_864(bool b)
  {
    emit QTextBrowser::redoAvailable(b);
  }

  //  [adaptor impl] void QTextBrowser::reload()
  void cbs_reload_0_0()
  {
    QTextBrowser::reload();
  }

  virtual void reload()
  {
    if (cb_reload_0_0.can_issue()) {
      cb_reload_0_0.issue<QTextBrowser_Adaptor>(&QTextBrowser_Adaptor::cbs_reload_0_0);
    } else {
      QTextBrowser::reload();
    }
  }

  //  [emitter impl] void QTextBrowser::selectionChanged()
  void emitter_QTextBrowser_selectionChanged_0()
  {
    emit QTextBrowser::selectionChanged();
  }

  //  [adaptor impl] void QTextBrowser::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QTextBrowser::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QTextBrowser_Adaptor, bool>(&QTextBrowser_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QTextBrowser::setVisible(visible);
    }
  }

  //  [adaptor impl] void QTextBrowser::setupViewport(QWidget *viewport)
  void cbs_setupViewport_1315_0(QWidget *viewport)
  {
    QTextBrowser::setupViewport(viewport);
  }

  virtual void setupViewport(QWidget *viewport)
  {
    if (cb_setupViewport_1315_0.can_issue()) {
      cb_setupViewport_1315_0.issue<QTextBrowser_Adaptor, QWidget *>(&QTextBrowser_Adaptor::cbs_setupViewport_1315_0, viewport);
    } else {
      QTextBrowser::setupViewport(viewport);
    }
  }

  //  [adaptor impl] QSize QTextBrowser::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QTextBrowser::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QTextBrowser_Adaptor, QSize>(&QTextBrowser_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QTextBrowser::sizeHint();
    }
  }

  //  [emitter impl] void QTextBrowser::sourceChanged(const QUrl &)
  void emitter_QTextBrowser_sourceChanged_1701(const QUrl &arg1)
  {
    emit QTextBrowser::sourceChanged(arg1);
  }

  //  [emitter impl] void QTextBrowser::textChanged()
  void emitter_QTextBrowser_textChanged_0()
  {
    emit QTextBrowser::textChanged();
  }

  //  [emitter impl] void QTextBrowser::undoAvailable(bool b)
  void emitter_QTextBrowser_undoAvailable_864(bool b)
  {
    emit QTextBrowser::undoAvailable(b);
  }

  //  [emitter impl] void QTextBrowser::windowIconChanged(const QIcon &icon)
  void emitter_QTextBrowser_windowIconChanged_1787(const QIcon &icon)
  {
    emit QTextBrowser::windowIconChanged(icon);
  }

  //  [emitter impl] void QTextBrowser::windowIconTextChanged(const QString &iconText)
  void emitter_QTextBrowser_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QTextBrowser::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QTextBrowser::windowTitleChanged(const QString &title)
  void emitter_QTextBrowser_windowTitleChanged_2025(const QString &title)
  {
    emit QTextBrowser::windowTitleChanged(title);
  }

  //  [adaptor impl] void QTextBrowser::actionEvent(QActionEvent *event)
  void cbs_actionEvent_1823_0(QActionEvent *event)
  {
    QTextBrowser::actionEvent(event);
  }

  virtual void actionEvent(QActionEvent *event)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QTextBrowser_Adaptor, QActionEvent *>(&QTextBrowser_Adaptor::cbs_actionEvent_1823_0, event);
    } else {
      QTextBrowser::actionEvent(event);
    }
  }

  //  [adaptor impl] bool QTextBrowser::canInsertFromMimeData(const QMimeData *source)
  bool cbs_canInsertFromMimeData_c2168_0(const QMimeData *source) const
  {
    return QTextBrowser::canInsertFromMimeData(source);
  }

  virtual bool canInsertFromMimeData(const QMimeData *source) const
  {
    if (cb_canInsertFromMimeData_c2168_0.can_issue()) {
      return cb_canInsertFromMimeData_c2168_0.issue<QTextBrowser_Adaptor, bool, const QMimeData *>(&QTextBrowser_Adaptor::cbs_canInsertFromMimeData_c2168_0, source);
    } else {
      return QTextBrowser::canInsertFromMimeData(source);
    }
  }

  //  [adaptor impl] void QTextBrowser::changeEvent(QEvent *e)
  void cbs_changeEvent_1217_0(QEvent *e)
  {
    QTextBrowser::changeEvent(e);
  }

  virtual void changeEvent(QEvent *e)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QTextBrowser_Adaptor, QEvent *>(&QTextBrowser_Adaptor::cbs_changeEvent_1217_0, e);
    } else {
      QTextBrowser::changeEvent(e);
    }
  }

  //  [adaptor impl] void QTextBrowser::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QTextBrowser::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QTextBrowser_Adaptor, QChildEvent *>(&QTextBrowser_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QTextBrowser::childEvent(event);
    }
  }

  //  [adaptor impl] void QTextBrowser::closeEvent(QCloseEvent *event)
  void cbs_closeEvent_1719_0(QCloseEvent *event)
  {
    QTextBrowser::closeEvent(event);
  }

  virtual void closeEvent(QCloseEvent *event)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QTextBrowser_Adaptor, QCloseEvent *>(&QTextBrowser_Adaptor::cbs_closeEvent_1719_0, event);
    } else {
      QTextBrowser::closeEvent(event);
    }
  }

  //  [adaptor impl] void QTextBrowser::contextMenuEvent(QContextMenuEvent *e)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *e)
  {
    QTextBrowser::contextMenuEvent(e);
  }

  virtual void contextMenuEvent(QContextMenuEvent *e)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QTextBrowser_Adaptor, QContextMenuEvent *>(&QTextBrowser_Adaptor::cbs_contextMenuEvent_2363_0, e);
    } else {
      QTextBrowser::contextMenuEvent(e);
    }
  }

  //  [adaptor impl] QMimeData *QTextBrowser::createMimeDataFromSelection()
  QMimeData * cbs_createMimeDataFromSelection_c0_0() const
  {
    return QTextBrowser::createMimeDataFromSelection();
  }

  virtual QMimeData * createMimeDataFromSelection() const
  {
    if (cb_createMimeDataFromSelection_c0_0.can_issue()) {
      return cb_createMimeDataFromSelection_c0_0.issue<QTextBrowser_Adaptor, QMimeData *>(&QTextBrowser_Adaptor::cbs_createMimeDataFromSelection_c0_0);
    } else {
      return QTextBrowser::createMimeDataFromSelection();
    }
  }

  //  [adaptor impl] void QTextBrowser::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QTextBrowser::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QTextBrowser_Adaptor, QEvent *>(&QTextBrowser_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QTextBrowser::customEvent(event);
    }
  }

  //  [adaptor impl] void QTextBrowser::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QTextBrowser::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QTextBrowser_Adaptor, const QMetaMethod &>(&QTextBrowser_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QTextBrowser::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QTextBrowser::doSetSource(const QUrl &name, QTextDocument::ResourceType type)
  void cbs_doSetSource_4736_1(const QUrl &name, const qt_gsi::Converter<QTextDocument::ResourceType>::target_type & type)
  {
    QTextBrowser::doSetSource(name, qt_gsi::QtToCppAdaptor<QTextDocument::ResourceType>(type).cref());
  }

  virtual void doSetSource(const QUrl &name, QTextDocument::ResourceType type)
  {
    if (cb_doSetSource_4736_1.can_issue()) {
      cb_doSetSource_4736_1.issue<QTextBrowser_Adaptor, const QUrl &, const qt_gsi::Converter<QTextDocument::ResourceType>::target_type &>(&QTextBrowser_Adaptor::cbs_doSetSource_4736_1, name, qt_gsi::CppToQtAdaptor<QTextDocument::ResourceType>(type));
    } else {
      QTextBrowser::doSetSource(name, type);
    }
  }

  //  [adaptor impl] void QTextBrowser::doSetTextCursor(const QTextCursor &cursor)
  void cbs_doSetTextCursor_2453_0(const QTextCursor &cursor)
  {
    QTextBrowser::doSetTextCursor(cursor);
  }

  virtual void doSetTextCursor(const QTextCursor &cursor)
  {
    if (cb_doSetTextCursor_2453_0.can_issue()) {
      cb_doSetTextCursor_2453_0.issue<QTextBrowser_Adaptor, const QTextCursor &>(&QTextBrowser_Adaptor::cbs_doSetTextCursor_2453_0, cursor);
    } else {
      QTextBrowser::doSetTextCursor(cursor);
    }
  }

  //  [adaptor impl] void QTextBrowser::dragEnterEvent(QDragEnterEvent *e)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *e)
  {
    QTextBrowser::dragEnterEvent(e);
  }

  virtual void dragEnterEvent(QDragEnterEvent *e)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QTextBrowser_Adaptor, QDragEnterEvent *>(&QTextBrowser_Adaptor::cbs_dragEnterEvent_2109_0, e);
    } else {
      QTextBrowser::dragEnterEvent(e);
    }
  }

  //  [adaptor impl] void QTextBrowser::dragLeaveEvent(QDragLeaveEvent *e)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *e)
  {
    QTextBrowser::dragLeaveEvent(e);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *e)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QTextBrowser_Adaptor, QDragLeaveEvent *>(&QTextBrowser_Adaptor::cbs_dragLeaveEvent_2092_0, e);
    } else {
      QTextBrowser::dragLeaveEvent(e);
    }
  }

  //  [adaptor impl] void QTextBrowser::dragMoveEvent(QDragMoveEvent *e)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *e)
  {
    QTextBrowser::dragMoveEvent(e);
  }

  virtual void dragMoveEvent(QDragMoveEvent *e)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QTextBrowser_Adaptor, QDragMoveEvent *>(&QTextBrowser_Adaptor::cbs_dragMoveEvent_2006_0, e);
    } else {
      QTextBrowser::dragMoveEvent(e);
    }
  }

  //  [adaptor impl] void QTextBrowser::dropEvent(QDropEvent *e)
  void cbs_dropEvent_1622_0(QDropEvent *e)
  {
    QTextBrowser::dropEvent(e);
  }

  virtual void dropEvent(QDropEvent *e)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QTextBrowser_Adaptor, QDropEvent *>(&QTextBrowser_Adaptor::cbs_dropEvent_1622_0, e);
    } else {
      QTextBrowser::dropEvent(e);
    }
  }

  //  [adaptor impl] void QTextBrowser::enterEvent(QEnterEvent *event)
  void cbs_enterEvent_1727_0(QEnterEvent *event)
  {
    QTextBrowser::enterEvent(event);
  }

  virtual void enterEvent(QEnterEvent *event)
  {
    if (cb_enterEvent_1727_0.can_issue()) {
      cb_enterEvent_1727_0.issue<QTextBrowser_Adaptor, QEnterEvent *>(&QTextBrowser_Adaptor::cbs_enterEvent_1727_0, event);
    } else {
      QTextBrowser::enterEvent(event);
    }
  }

  //  [adaptor impl] bool QTextBrowser::event(QEvent *e)
  bool cbs_event_1217_0(QEvent *e)
  {
    return QTextBrowser::event(e);
  }

  virtual bool event(QEvent *e)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QTextBrowser_Adaptor, bool, QEvent *>(&QTextBrowser_Adaptor::cbs_event_1217_0, e);
    } else {
      return QTextBrowser::event(e);
    }
  }

  //  [adaptor impl] bool QTextBrowser::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QTextBrowser::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QTextBrowser_Adaptor, bool, QObject *, QEvent *>(&QTextBrowser_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QTextBrowser::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QTextBrowser::focusInEvent(QFocusEvent *e)
  void cbs_focusInEvent_1729_0(QFocusEvent *e)
  {
    QTextBrowser::focusInEvent(e);
  }

  virtual void focusInEvent(QFocusEvent *e)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QTextBrowser_Adaptor, QFocusEvent *>(&QTextBrowser_Adaptor::cbs_focusInEvent_1729_0, e);
    } else {
      QTextBrowser::focusInEvent(e);
    }
  }

  //  [adaptor impl] bool QTextBrowser::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QTextBrowser::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QTextBrowser_Adaptor, bool, bool>(&QTextBrowser_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QTextBrowser::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QTextBrowser::focusOutEvent(QFocusEvent *ev)
  void cbs_focusOutEvent_1729_0(QFocusEvent *ev)
  {
    QTextBrowser::focusOutEvent(ev);
  }

  virtual void focusOutEvent(QFocusEvent *ev)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QTextBrowser_Adaptor, QFocusEvent *>(&QTextBrowser_Adaptor::cbs_focusOutEvent_1729_0, ev);
    } else {
      QTextBrowser::focusOutEvent(ev);
    }
  }

  //  [adaptor impl] void QTextBrowser::hideEvent(QHideEvent *event)
  void cbs_hideEvent_1595_0(QHideEvent *event)
  {
    QTextBrowser::hideEvent(event);
  }

  virtual void hideEvent(QHideEvent *event)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QTextBrowser_Adaptor, QHideEvent *>(&QTextBrowser_Adaptor::cbs_hideEvent_1595_0, event);
    } else {
      QTextBrowser::hideEvent(event);
    }
  }

  //  [adaptor impl] void QTextBrowser::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QTextBrowser::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QTextBrowser_Adaptor, QPainter *>(&QTextBrowser_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QTextBrowser::initPainter(painter);
    }
  }

  //  [adaptor impl] void QTextBrowser::initStyleOption(QStyleOptionFrame *option)
  void cbs_initStyleOption_c2356_0(QStyleOptionFrame *option) const
  {
    QTextBrowser::initStyleOption(option);
  }

  virtual void initStyleOption(QStyleOptionFrame *option) const
  {
    if (cb_initStyleOption_c2356_0.can_issue()) {
      cb_initStyleOption_c2356_0.issue<QTextBrowser_Adaptor, QStyleOptionFrame *>(&QTextBrowser_Adaptor::cbs_initStyleOption_c2356_0, option);
    } else {
      QTextBrowser::initStyleOption(option);
    }
  }

  //  [adaptor impl] void QTextBrowser::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QTextBrowser::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QTextBrowser_Adaptor, QInputMethodEvent *>(&QTextBrowser_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QTextBrowser::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QTextBrowser::insertFromMimeData(const QMimeData *source)
  void cbs_insertFromMimeData_2168_0(const QMimeData *source)
  {
    QTextBrowser::insertFromMimeData(source);
  }

  virtual void insertFromMimeData(const QMimeData *source)
  {
    if (cb_insertFromMimeData_2168_0.can_issue()) {
      cb_insertFromMimeData_2168_0.issue<QTextBrowser_Adaptor, const QMimeData *>(&QTextBrowser_Adaptor::cbs_insertFromMimeData_2168_0, source);
    } else {
      QTextBrowser::insertFromMimeData(source);
    }
  }

  //  [adaptor impl] void QTextBrowser::keyPressEvent(QKeyEvent *ev)
  void cbs_keyPressEvent_1514_0(QKeyEvent *ev)
  {
    QTextBrowser::keyPressEvent(ev);
  }

  virtual void keyPressEvent(QKeyEvent *ev)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QTextBrowser_Adaptor, QKeyEvent *>(&QTextBrowser_Adaptor::cbs_keyPressEvent_1514_0, ev);
    } else {
      QTextBrowser::keyPressEvent(ev);
    }
  }

  //  [adaptor impl] void QTextBrowser::keyReleaseEvent(QKeyEvent *e)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *e)
  {
    QTextBrowser::keyReleaseEvent(e);
  }

  virtual void keyReleaseEvent(QKeyEvent *e)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QTextBrowser_Adaptor, QKeyEvent *>(&QTextBrowser_Adaptor::cbs_keyReleaseEvent_1514_0, e);
    } else {
      QTextBrowser::keyReleaseEvent(e);
    }
  }

  //  [adaptor impl] void QTextBrowser::leaveEvent(QEvent *event)
  void cbs_leaveEvent_1217_0(QEvent *event)
  {
    QTextBrowser::leaveEvent(event);
  }

  virtual void leaveEvent(QEvent *event)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QTextBrowser_Adaptor, QEvent *>(&QTextBrowser_Adaptor::cbs_leaveEvent_1217_0, event);
    } else {
      QTextBrowser::leaveEvent(event);
    }
  }

  //  [adaptor impl] int QTextBrowser::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QTextBrowser::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QTextBrowser_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QTextBrowser_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QTextBrowser::metric(arg1);
    }
  }

  //  [adaptor impl] void QTextBrowser::mouseDoubleClickEvent(QMouseEvent *e)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *e)
  {
    QTextBrowser::mouseDoubleClickEvent(e);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *e)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QTextBrowser_Adaptor, QMouseEvent *>(&QTextBrowser_Adaptor::cbs_mouseDoubleClickEvent_1738_0, e);
    } else {
      QTextBrowser::mouseDoubleClickEvent(e);
    }
  }

  //  [adaptor impl] void QTextBrowser::mouseMoveEvent(QMouseEvent *ev)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *ev)
  {
    QTextBrowser::mouseMoveEvent(ev);
  }

  virtual void mouseMoveEvent(QMouseEvent *ev)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QTextBrowser_Adaptor, QMouseEvent *>(&QTextBrowser_Adaptor::cbs_mouseMoveEvent_1738_0, ev);
    } else {
      QTextBrowser::mouseMoveEvent(ev);
    }
  }

  //  [adaptor impl] void QTextBrowser::mousePressEvent(QMouseEvent *ev)
  void cbs_mousePressEvent_1738_0(QMouseEvent *ev)
  {
    QTextBrowser::mousePressEvent(ev);
  }

  virtual void mousePressEvent(QMouseEvent *ev)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QTextBrowser_Adaptor, QMouseEvent *>(&QTextBrowser_Adaptor::cbs_mousePressEvent_1738_0, ev);
    } else {
      QTextBrowser::mousePressEvent(ev);
    }
  }

  //  [adaptor impl] void QTextBrowser::mouseReleaseEvent(QMouseEvent *ev)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *ev)
  {
    QTextBrowser::mouseReleaseEvent(ev);
  }

  virtual void mouseReleaseEvent(QMouseEvent *ev)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QTextBrowser_Adaptor, QMouseEvent *>(&QTextBrowser_Adaptor::cbs_mouseReleaseEvent_1738_0, ev);
    } else {
      QTextBrowser::mouseReleaseEvent(ev);
    }
  }

  //  [adaptor impl] void QTextBrowser::moveEvent(QMoveEvent *event)
  void cbs_moveEvent_1624_0(QMoveEvent *event)
  {
    QTextBrowser::moveEvent(event);
  }

  virtual void moveEvent(QMoveEvent *event)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QTextBrowser_Adaptor, QMoveEvent *>(&QTextBrowser_Adaptor::cbs_moveEvent_1624_0, event);
    } else {
      QTextBrowser::moveEvent(event);
    }
  }

  //  [adaptor impl] bool QTextBrowser::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  bool cbs_nativeEvent_6949_0(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    return QTextBrowser::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    if (cb_nativeEvent_6949_0.can_issue()) {
      return cb_nativeEvent_6949_0.issue<QTextBrowser_Adaptor, bool, const QByteArray &, void *, QIntegerForSizeof<void *>::Signed *>(&QTextBrowser_Adaptor::cbs_nativeEvent_6949_0, eventType, message, result);
    } else {
      return QTextBrowser::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QTextBrowser::paintEvent(QPaintEvent *e)
  void cbs_paintEvent_1725_0(QPaintEvent *e)
  {
    QTextBrowser::paintEvent(e);
  }

  virtual void paintEvent(QPaintEvent *e)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QTextBrowser_Adaptor, QPaintEvent *>(&QTextBrowser_Adaptor::cbs_paintEvent_1725_0, e);
    } else {
      QTextBrowser::paintEvent(e);
    }
  }

  //  [adaptor impl] QPaintDevice *QTextBrowser::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QTextBrowser::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QTextBrowser_Adaptor, QPaintDevice *, QPoint *>(&QTextBrowser_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QTextBrowser::redirected(offset);
    }
  }

  //  [adaptor impl] void QTextBrowser::resizeEvent(QResizeEvent *e)
  void cbs_resizeEvent_1843_0(QResizeEvent *e)
  {
    QTextBrowser::resizeEvent(e);
  }

  virtual void resizeEvent(QResizeEvent *e)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QTextBrowser_Adaptor, QResizeEvent *>(&QTextBrowser_Adaptor::cbs_resizeEvent_1843_0, e);
    } else {
      QTextBrowser::resizeEvent(e);
    }
  }

  //  [adaptor impl] void QTextBrowser::scrollContentsBy(int dx, int dy)
  void cbs_scrollContentsBy_1426_0(int dx, int dy)
  {
    QTextBrowser::scrollContentsBy(dx, dy);
  }

  virtual void scrollContentsBy(int dx, int dy)
  {
    if (cb_scrollContentsBy_1426_0.can_issue()) {
      cb_scrollContentsBy_1426_0.issue<QTextBrowser_Adaptor, int, int>(&QTextBrowser_Adaptor::cbs_scrollContentsBy_1426_0, dx, dy);
    } else {
      QTextBrowser::scrollContentsBy(dx, dy);
    }
  }

  //  [adaptor impl] QPainter *QTextBrowser::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QTextBrowser::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QTextBrowser_Adaptor, QPainter *>(&QTextBrowser_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QTextBrowser::sharedPainter();
    }
  }

  //  [adaptor impl] void QTextBrowser::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QTextBrowser::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QTextBrowser_Adaptor, QShowEvent *>(&QTextBrowser_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QTextBrowser::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QTextBrowser::tabletEvent(QTabletEvent *event)
  void cbs_tabletEvent_1821_0(QTabletEvent *event)
  {
    QTextBrowser::tabletEvent(event);
  }

  virtual void tabletEvent(QTabletEvent *event)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QTextBrowser_Adaptor, QTabletEvent *>(&QTextBrowser_Adaptor::cbs_tabletEvent_1821_0, event);
    } else {
      QTextBrowser::tabletEvent(event);
    }
  }

  //  [adaptor impl] void QTextBrowser::timerEvent(QTimerEvent *e)
  void cbs_timerEvent_1730_0(QTimerEvent *e)
  {
    QTextBrowser::timerEvent(e);
  }

  virtual void timerEvent(QTimerEvent *e)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QTextBrowser_Adaptor, QTimerEvent *>(&QTextBrowser_Adaptor::cbs_timerEvent_1730_0, e);
    } else {
      QTextBrowser::timerEvent(e);
    }
  }

  //  [adaptor impl] bool QTextBrowser::viewportEvent(QEvent *)
  bool cbs_viewportEvent_1217_0(QEvent *arg1)
  {
    return QTextBrowser::viewportEvent(arg1);
  }

  virtual bool viewportEvent(QEvent *arg1)
  {
    if (cb_viewportEvent_1217_0.can_issue()) {
      return cb_viewportEvent_1217_0.issue<QTextBrowser_Adaptor, bool, QEvent *>(&QTextBrowser_Adaptor::cbs_viewportEvent_1217_0, arg1);
    } else {
      return QTextBrowser::viewportEvent(arg1);
    }
  }

  //  [adaptor impl] QSize QTextBrowser::viewportSizeHint()
  QSize cbs_viewportSizeHint_c0_0() const
  {
    return QTextBrowser::viewportSizeHint();
  }

  virtual QSize viewportSizeHint() const
  {
    if (cb_viewportSizeHint_c0_0.can_issue()) {
      return cb_viewportSizeHint_c0_0.issue<QTextBrowser_Adaptor, QSize>(&QTextBrowser_Adaptor::cbs_viewportSizeHint_c0_0);
    } else {
      return QTextBrowser::viewportSizeHint();
    }
  }

  //  [adaptor impl] void QTextBrowser::wheelEvent(QWheelEvent *e)
  void cbs_wheelEvent_1718_0(QWheelEvent *e)
  {
    QTextBrowser::wheelEvent(e);
  }

  virtual void wheelEvent(QWheelEvent *e)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QTextBrowser_Adaptor, QWheelEvent *>(&QTextBrowser_Adaptor::cbs_wheelEvent_1718_0, e);
    } else {
      QTextBrowser::wheelEvent(e);
    }
  }

  gsi::Callback cb_backward_0_0;
  gsi::Callback cb_forward_0_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_home_0_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_loadResource_2360_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reload_0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_setupViewport_1315_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_canInsertFromMimeData_c2168_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_createMimeDataFromSelection_c0_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_doSetSource_4736_1;
  gsi::Callback cb_doSetTextCursor_2453_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enterEvent_1727_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_initStyleOption_c2356_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_insertFromMimeData_2168_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_6949_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_scrollContentsBy_1426_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_viewportEvent_1217_0;
  gsi::Callback cb_viewportSizeHint_c0_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QTextBrowser_Adaptor::~QTextBrowser_Adaptor() { }

//  Constructor QTextBrowser::QTextBrowser(QWidget *parent) (adaptor class)

static void _init_ctor_QTextBrowser_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QTextBrowser_Adaptor> ();
}

static void _call_ctor_QTextBrowser_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  ret.write<QTextBrowser_Adaptor *> (new QTextBrowser_Adaptor (arg1));
}


// void QTextBrowser::actionEvent(QActionEvent *event)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// emitter void QTextBrowser::anchorClicked(const QUrl &)

static void _init_emitter_anchorClicked_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_anchorClicked_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_anchorClicked_1701 (arg1);
}


// void QTextBrowser::backward()

static void _init_cbs_backward_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_backward_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_backward_0_0 ();
}

static void _set_callback_cbs_backward_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_backward_0_0 = cb;
}


// emitter void QTextBrowser::backwardAvailable(bool)

static void _init_emitter_backwardAvailable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_backwardAvailable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_backwardAvailable_864 (arg1);
}


// bool QTextBrowser::canInsertFromMimeData(const QMimeData *source)

static void _init_cbs_canInsertFromMimeData_c2168_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("source");
  decl->add_arg<const QMimeData * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_canInsertFromMimeData_c2168_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  ret.write<bool > ((bool)((QTextBrowser_Adaptor *)cls)->cbs_canInsertFromMimeData_c2168_0 (arg1));
}

static void _set_callback_cbs_canInsertFromMimeData_c2168_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_canInsertFromMimeData_c2168_0 = cb;
}


// void QTextBrowser::changeEvent(QEvent *e)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QTextBrowser::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QTextBrowser::closeEvent(QCloseEvent *event)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QTextBrowser::contextMenuEvent(QContextMenuEvent *e)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// emitter void QTextBrowser::copyAvailable(bool b)

static void _init_emitter_copyAvailable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_copyAvailable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_copyAvailable_864 (arg1);
}


// exposed void QTextBrowser::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->fp_QTextBrowser_create_2208 (arg1, arg2, arg3);
}


// QMimeData *QTextBrowser::createMimeDataFromSelection()

static void _init_cbs_createMimeDataFromSelection_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_createMimeDataFromSelection_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMimeData * > ((QMimeData *)((QTextBrowser_Adaptor *)cls)->cbs_createMimeDataFromSelection_c0_0 ());
}

static void _set_callback_cbs_createMimeDataFromSelection_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_createMimeDataFromSelection_c0_0 = cb;
}


// emitter void QTextBrowser::currentCharFormatChanged(const QTextCharFormat &format)

static void _init_emitter_currentCharFormatChanged_2814 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextCharFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentCharFormatChanged_2814 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCharFormat &arg1 = gsi::arg_reader<const QTextCharFormat & >() (args, heap);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_currentCharFormatChanged_2814 (arg1);
}


// emitter void QTextBrowser::cursorPositionChanged()

static void _init_emitter_cursorPositionChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_cursorPositionChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_cursorPositionChanged_0 ();
}


// emitter void QTextBrowser::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_customContextMenuRequested_1916 (arg1);
}


// void QTextBrowser::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QTextBrowser::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->fp_QTextBrowser_destroy_1620 (arg1, arg2);
}


// emitter void QTextBrowser::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_destroyed_1302 (arg1);
}


// void QTextBrowser::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QTextBrowser::doSetSource(const QUrl &name, QTextDocument::ResourceType type)

static void _init_cbs_doSetSource_4736_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QUrl & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<const qt_gsi::Converter<QTextDocument::ResourceType>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_doSetSource_4736_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = args.read<const QUrl & > (heap);
  const qt_gsi::Converter<QTextDocument::ResourceType>::target_type & arg2 = args.read<const qt_gsi::Converter<QTextDocument::ResourceType>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_doSetSource_4736_1 (arg1, arg2);
}

static void _set_callback_cbs_doSetSource_4736_1 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_doSetSource_4736_1 = cb;
}


// void QTextBrowser::doSetTextCursor(const QTextCursor &cursor)

static void _init_cbs_doSetTextCursor_2453_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_doSetTextCursor_2453_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = args.read<const QTextCursor & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_doSetTextCursor_2453_0 (arg1);
}

static void _set_callback_cbs_doSetTextCursor_2453_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_doSetTextCursor_2453_0 = cb;
}


// void QTextBrowser::dragEnterEvent(QDragEnterEvent *e)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QTextBrowser::dragLeaveEvent(QDragLeaveEvent *e)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QTextBrowser::dragMoveEvent(QDragMoveEvent *e)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// exposed void QTextBrowser::drawFrame(QPainter *)

static void _init_fp_drawFrame_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawFrame_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->fp_QTextBrowser_drawFrame_1426 (arg1);
}


// void QTextBrowser::dropEvent(QDropEvent *e)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QTextBrowser::enterEvent(QEnterEvent *event)

static void _init_cbs_enterEvent_1727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEnterEvent *arg1 = args.read<QEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_enterEvent_1727_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1727_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_enterEvent_1727_0 = cb;
}


// bool QTextBrowser::event(QEvent *e)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTextBrowser_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QTextBrowser::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTextBrowser_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QTextBrowser::focusInEvent(QFocusEvent *e)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QTextBrowser::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextBrowser_Adaptor *)cls)->fp_QTextBrowser_focusNextChild_0 ());
}


// bool QTextBrowser::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QTextBrowser_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QTextBrowser::focusOutEvent(QFocusEvent *ev)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ev");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QTextBrowser::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextBrowser_Adaptor *)cls)->fp_QTextBrowser_focusPreviousChild_0 ());
}


// void QTextBrowser::forward()

static void _init_cbs_forward_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_forward_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_forward_0_0 ();
}

static void _set_callback_cbs_forward_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_forward_0_0 = cb;
}


// emitter void QTextBrowser::forwardAvailable(bool)

static void _init_emitter_forwardAvailable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_forwardAvailable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_forwardAvailable_864 (arg1);
}


// bool QTextBrowser::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextBrowser_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QTextBrowser::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QTextBrowser_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QTextBrowser::hideEvent(QHideEvent *event)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// emitter void QTextBrowser::highlighted(const QUrl &)

static void _init_emitter_highlighted_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_highlighted_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_highlighted_1701 (arg1);
}


// emitter void QTextBrowser::historyChanged()

static void _init_emitter_historyChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_historyChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_historyChanged_0 ();
}


// void QTextBrowser::home()

static void _init_cbs_home_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_home_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_home_0_0 ();
}

static void _set_callback_cbs_home_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_home_0_0 = cb;
}


// void QTextBrowser::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// void QTextBrowser::initStyleOption(QStyleOptionFrame *option)

static void _init_cbs_initStyleOption_c2356_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionFrame * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initStyleOption_c2356_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyleOptionFrame *arg1 = args.read<QStyleOptionFrame * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_initStyleOption_c2356_0 (arg1);
}

static void _set_callback_cbs_initStyleOption_c2356_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_initStyleOption_c2356_0 = cb;
}


// void QTextBrowser::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QTextBrowser::inputMethodQuery(Qt::InputMethodQuery property)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("property");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QTextBrowser_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// void QTextBrowser::insertFromMimeData(const QMimeData *source)

static void _init_cbs_insertFromMimeData_2168_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("source");
  decl->add_arg<const QMimeData * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_insertFromMimeData_2168_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_insertFromMimeData_2168_0 (arg1);
}

static void _set_callback_cbs_insertFromMimeData_2168_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_insertFromMimeData_2168_0 = cb;
}


// exposed bool QTextBrowser::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QTextBrowser_Adaptor *)cls)->fp_QTextBrowser_isSignalConnected_c2394 (arg1));
}


// void QTextBrowser::keyPressEvent(QKeyEvent *ev)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ev");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QTextBrowser::keyReleaseEvent(QKeyEvent *e)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QTextBrowser::leaveEvent(QEvent *event)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// QVariant QTextBrowser::loadResource(int type, const QUrl &name)

static void _init_cbs_loadResource_2360_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name");
  decl->add_arg<const QUrl & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_loadResource_2360_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const QUrl &arg2 = args.read<const QUrl & > (heap);
  ret.write<QVariant > ((QVariant)((QTextBrowser_Adaptor *)cls)->cbs_loadResource_2360_0 (arg1, arg2));
}

static void _set_callback_cbs_loadResource_2360_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_loadResource_2360_0 = cb;
}


// int QTextBrowser::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QTextBrowser_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QTextBrowser::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QTextBrowser_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QTextBrowser::mouseDoubleClickEvent(QMouseEvent *e)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QTextBrowser::mouseMoveEvent(QMouseEvent *ev)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ev");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QTextBrowser::mousePressEvent(QMouseEvent *ev)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ev");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QTextBrowser::mouseReleaseEvent(QMouseEvent *ev)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ev");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QTextBrowser::moveEvent(QMoveEvent *event)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QTextBrowser::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)

static void _init_cbs_nativeEvent_6949_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<QIntegerForSizeof<void *>::Signed * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_6949_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  QIntegerForSizeof<void *>::Signed *arg3 = args.read<QIntegerForSizeof<void *>::Signed * > (heap);
  ret.write<bool > ((bool)((QTextBrowser_Adaptor *)cls)->cbs_nativeEvent_6949_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_6949_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_nativeEvent_6949_0 = cb;
}


// emitter void QTextBrowser::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_objectNameChanged_4567 (arg1);
}


// QPaintEngine *QTextBrowser::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QTextBrowser_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QTextBrowser::paintEvent(QPaintEvent *e)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QTextBrowser::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QTextBrowser_Adaptor *)cls)->fp_QTextBrowser_receivers_c1731 (arg1));
}


// QPaintDevice *QTextBrowser::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QTextBrowser_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// emitter void QTextBrowser::redoAvailable(bool b)

static void _init_emitter_redoAvailable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_redoAvailable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_redoAvailable_864 (arg1);
}


// void QTextBrowser::reload()

static void _init_cbs_reload_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reload_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_reload_0_0 ();
}

static void _set_callback_cbs_reload_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_reload_0_0 = cb;
}


// void QTextBrowser::resizeEvent(QResizeEvent *e)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// void QTextBrowser::scrollContentsBy(int dx, int dy)

static void _init_cbs_scrollContentsBy_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollContentsBy_1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_scrollContentsBy_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollContentsBy_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_scrollContentsBy_1426_0 = cb;
}


// emitter void QTextBrowser::selectionChanged()

static void _init_emitter_selectionChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_selectionChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_selectionChanged_0 ();
}


// exposed QObject *QTextBrowser::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QTextBrowser_Adaptor *)cls)->fp_QTextBrowser_sender_c0 ());
}


// exposed int QTextBrowser::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextBrowser_Adaptor *)cls)->fp_QTextBrowser_senderSignalIndex_c0 ());
}


// exposed void QTextBrowser::setViewportMargins(int left, int top, int right, int bottom)

static void _init_fp_setViewportMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->fp_QTextBrowser_setViewportMargins_2744 (arg1, arg2, arg3, arg4);
}


// exposed void QTextBrowser::setViewportMargins(const QMargins &margins)

static void _init_fp_setViewportMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2115 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMargins &arg1 = gsi::arg_reader<const QMargins & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->fp_QTextBrowser_setViewportMargins_2115 (arg1);
}


// void QTextBrowser::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// void QTextBrowser::setupViewport(QWidget *viewport)

static void _init_cbs_setupViewport_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setupViewport_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_setupViewport_1315_0 (arg1);
}

static void _set_callback_cbs_setupViewport_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_setupViewport_1315_0 = cb;
}


// QPainter *QTextBrowser::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QTextBrowser_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QTextBrowser::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QTextBrowser::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QTextBrowser_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// emitter void QTextBrowser::sourceChanged(const QUrl &)

static void _init_emitter_sourceChanged_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_sourceChanged_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_sourceChanged_1701 (arg1);
}


// void QTextBrowser::tabletEvent(QTabletEvent *event)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// emitter void QTextBrowser::textChanged()

static void _init_emitter_textChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_textChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_textChanged_0 ();
}


// void QTextBrowser::timerEvent(QTimerEvent *e)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QTextBrowser::undoAvailable(bool b)

static void _init_emitter_undoAvailable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_undoAvailable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_undoAvailable_864 (arg1);
}


// exposed void QTextBrowser::updateMicroFocus(Qt::InputMethodQuery query)

static void _init_fp_updateMicroFocus_2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query", true, "Qt::ImQueryAll");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::InputMethodQuery>(heap, Qt::ImQueryAll), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->fp_QTextBrowser_updateMicroFocus_2420 (arg1);
}


// bool QTextBrowser::viewportEvent(QEvent *)

static void _init_cbs_viewportEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_viewportEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTextBrowser_Adaptor *)cls)->cbs_viewportEvent_1217_0 (arg1));
}

static void _set_callback_cbs_viewportEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_viewportEvent_1217_0 = cb;
}


// exposed QMargins QTextBrowser::viewportMargins()

static void _init_fp_viewportMargins_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMargins > ();
}

static void _call_fp_viewportMargins_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMargins > ((QMargins)((QTextBrowser_Adaptor *)cls)->fp_QTextBrowser_viewportMargins_c0 ());
}


// QSize QTextBrowser::viewportSizeHint()

static void _init_cbs_viewportSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_viewportSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QTextBrowser_Adaptor *)cls)->cbs_viewportSizeHint_c0_0 ());
}

static void _set_callback_cbs_viewportSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_viewportSizeHint_c0_0 = cb;
}


// void QTextBrowser::wheelEvent(QWheelEvent *e)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextBrowser_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QTextBrowser::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_windowIconChanged_1787 (arg1);
}


// emitter void QTextBrowser::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_windowIconTextChanged_2025 (arg1);
}


// emitter void QTextBrowser::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QTextBrowser_Adaptor *)cls)->emitter_QTextBrowser_windowTitleChanged_2025 (arg1);
}


// exposed void QTextBrowser::zoomInF(float range)

static void _init_fp_zoomInF_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("range");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_zoomInF_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextBrowser_Adaptor *)cls)->fp_QTextBrowser_zoomInF_970 (arg1);
}


namespace gsi
{

gsi::Class<QTextBrowser> &qtdecl_QTextBrowser ();

static gsi::Methods methods_QTextBrowser_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextBrowser::QTextBrowser(QWidget *parent)\nThis method creates an object of class QTextBrowser.", &_init_ctor_QTextBrowser_Adaptor_1315, &_call_ctor_QTextBrowser_Adaptor_1315);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QTextBrowser::actionEvent(QActionEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("emit_anchorClicked", "@brief Emitter for signal void QTextBrowser::anchorClicked(const QUrl &)\nCall this method to emit this signal.", false, &_init_emitter_anchorClicked_1701, &_call_emitter_anchorClicked_1701);
  methods += new qt_gsi::GenericMethod ("backward", "@brief Virtual method void QTextBrowser::backward()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_backward_0_0, &_call_cbs_backward_0_0);
  methods += new qt_gsi::GenericMethod ("backward", "@hide", false, &_init_cbs_backward_0_0, &_call_cbs_backward_0_0, &_set_callback_cbs_backward_0_0);
  methods += new qt_gsi::GenericMethod ("emit_backwardAvailable", "@brief Emitter for signal void QTextBrowser::backwardAvailable(bool)\nCall this method to emit this signal.", false, &_init_emitter_backwardAvailable_864, &_call_emitter_backwardAvailable_864);
  methods += new qt_gsi::GenericMethod ("*canInsertFromMimeData", "@brief Virtual method bool QTextBrowser::canInsertFromMimeData(const QMimeData *source)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canInsertFromMimeData_c2168_0, &_call_cbs_canInsertFromMimeData_c2168_0);
  methods += new qt_gsi::GenericMethod ("*canInsertFromMimeData", "@hide", true, &_init_cbs_canInsertFromMimeData_c2168_0, &_call_cbs_canInsertFromMimeData_c2168_0, &_set_callback_cbs_canInsertFromMimeData_c2168_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QTextBrowser::changeEvent(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QTextBrowser::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QTextBrowser::closeEvent(QCloseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QTextBrowser::contextMenuEvent(QContextMenuEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("emit_copyAvailable", "@brief Emitter for signal void QTextBrowser::copyAvailable(bool b)\nCall this method to emit this signal.", false, &_init_emitter_copyAvailable_864, &_call_emitter_copyAvailable_864);
  methods += new qt_gsi::GenericMethod ("*create|qt_create", "@brief Method void QTextBrowser::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("*createMimeDataFromSelection", "@brief Virtual method QMimeData *QTextBrowser::createMimeDataFromSelection()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_createMimeDataFromSelection_c0_0, &_call_cbs_createMimeDataFromSelection_c0_0);
  methods += new qt_gsi::GenericMethod ("*createMimeDataFromSelection", "@hide", true, &_init_cbs_createMimeDataFromSelection_c0_0, &_call_cbs_createMimeDataFromSelection_c0_0, &_set_callback_cbs_createMimeDataFromSelection_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_currentCharFormatChanged", "@brief Emitter for signal void QTextBrowser::currentCharFormatChanged(const QTextCharFormat &format)\nCall this method to emit this signal.", false, &_init_emitter_currentCharFormatChanged_2814, &_call_emitter_currentCharFormatChanged_2814);
  methods += new qt_gsi::GenericMethod ("emit_cursorPositionChanged", "@brief Emitter for signal void QTextBrowser::cursorPositionChanged()\nCall this method to emit this signal.", false, &_init_emitter_cursorPositionChanged_0, &_call_emitter_cursorPositionChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QTextBrowser::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QTextBrowser::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*destroy|qt_destroy", "@brief Method void QTextBrowser::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QTextBrowser::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QTextBrowser::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*doSetSource", "@brief Virtual method void QTextBrowser::doSetSource(const QUrl &name, QTextDocument::ResourceType type)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_doSetSource_4736_1, &_call_cbs_doSetSource_4736_1);
  methods += new qt_gsi::GenericMethod ("*doSetSource", "@hide", false, &_init_cbs_doSetSource_4736_1, &_call_cbs_doSetSource_4736_1, &_set_callback_cbs_doSetSource_4736_1);
  methods += new qt_gsi::GenericMethod ("*doSetTextCursor", "@brief Virtual method void QTextBrowser::doSetTextCursor(const QTextCursor &cursor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_doSetTextCursor_2453_0, &_call_cbs_doSetTextCursor_2453_0);
  methods += new qt_gsi::GenericMethod ("*doSetTextCursor", "@hide", false, &_init_cbs_doSetTextCursor_2453_0, &_call_cbs_doSetTextCursor_2453_0, &_set_callback_cbs_doSetTextCursor_2453_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QTextBrowser::dragEnterEvent(QDragEnterEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QTextBrowser::dragLeaveEvent(QDragLeaveEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QTextBrowser::dragMoveEvent(QDragMoveEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*drawFrame", "@brief Method void QTextBrowser::drawFrame(QPainter *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawFrame_1426, &_call_fp_drawFrame_1426);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QTextBrowser::dropEvent(QDropEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QTextBrowser::enterEvent(QEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0, &_set_callback_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QTextBrowser::event(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QTextBrowser::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QTextBrowser::focusInEvent(QFocusEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QTextBrowser::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QTextBrowser::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QTextBrowser::focusOutEvent(QFocusEvent *ev)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QTextBrowser::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("forward", "@brief Virtual method void QTextBrowser::forward()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_forward_0_0, &_call_cbs_forward_0_0);
  methods += new qt_gsi::GenericMethod ("forward", "@hide", false, &_init_cbs_forward_0_0, &_call_cbs_forward_0_0, &_set_callback_cbs_forward_0_0);
  methods += new qt_gsi::GenericMethod ("emit_forwardAvailable", "@brief Emitter for signal void QTextBrowser::forwardAvailable(bool)\nCall this method to emit this signal.", false, &_init_emitter_forwardAvailable_864, &_call_emitter_forwardAvailable_864);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QTextBrowser::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QTextBrowser::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QTextBrowser::hideEvent(QHideEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("emit_highlighted", "@brief Emitter for signal void QTextBrowser::highlighted(const QUrl &)\nCall this method to emit this signal.", false, &_init_emitter_highlighted_1701, &_call_emitter_highlighted_1701);
  methods += new qt_gsi::GenericMethod ("emit_historyChanged", "@brief Emitter for signal void QTextBrowser::historyChanged()\nCall this method to emit this signal.", false, &_init_emitter_historyChanged_0, &_call_emitter_historyChanged_0);
  methods += new qt_gsi::GenericMethod ("home", "@brief Virtual method void QTextBrowser::home()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_home_0_0, &_call_cbs_home_0_0);
  methods += new qt_gsi::GenericMethod ("home", "@hide", false, &_init_cbs_home_0_0, &_call_cbs_home_0_0, &_set_callback_cbs_home_0_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QTextBrowser::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@brief Virtual method void QTextBrowser::initStyleOption(QStyleOptionFrame *option)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initStyleOption_c2356_0, &_call_cbs_initStyleOption_c2356_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@hide", true, &_init_cbs_initStyleOption_c2356_0, &_call_cbs_initStyleOption_c2356_0, &_set_callback_cbs_initStyleOption_c2356_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QTextBrowser::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QTextBrowser::inputMethodQuery(Qt::InputMethodQuery property)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*insertFromMimeData", "@brief Virtual method void QTextBrowser::insertFromMimeData(const QMimeData *source)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertFromMimeData_2168_0, &_call_cbs_insertFromMimeData_2168_0);
  methods += new qt_gsi::GenericMethod ("*insertFromMimeData", "@hide", false, &_init_cbs_insertFromMimeData_2168_0, &_call_cbs_insertFromMimeData_2168_0, &_set_callback_cbs_insertFromMimeData_2168_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QTextBrowser::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QTextBrowser::keyPressEvent(QKeyEvent *ev)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QTextBrowser::keyReleaseEvent(QKeyEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QTextBrowser::leaveEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("loadResource", "@brief Virtual method QVariant QTextBrowser::loadResource(int type, const QUrl &name)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_loadResource_2360_0, &_call_cbs_loadResource_2360_0);
  methods += new qt_gsi::GenericMethod ("loadResource", "@hide", false, &_init_cbs_loadResource_2360_0, &_call_cbs_loadResource_2360_0, &_set_callback_cbs_loadResource_2360_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QTextBrowser::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QTextBrowser::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QTextBrowser::mouseDoubleClickEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QTextBrowser::mouseMoveEvent(QMouseEvent *ev)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QTextBrowser::mousePressEvent(QMouseEvent *ev)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QTextBrowser::mouseReleaseEvent(QMouseEvent *ev)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QTextBrowser::moveEvent(QMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QTextBrowser::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0, &_set_callback_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QTextBrowser::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QTextBrowser::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QTextBrowser::paintEvent(QPaintEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QTextBrowser::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QTextBrowser::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("emit_redoAvailable", "@brief Emitter for signal void QTextBrowser::redoAvailable(bool b)\nCall this method to emit this signal.", false, &_init_emitter_redoAvailable_864, &_call_emitter_redoAvailable_864);
  methods += new qt_gsi::GenericMethod ("reload", "@brief Virtual method void QTextBrowser::reload()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reload_0_0, &_call_cbs_reload_0_0);
  methods += new qt_gsi::GenericMethod ("reload", "@hide", false, &_init_cbs_reload_0_0, &_call_cbs_reload_0_0, &_set_callback_cbs_reload_0_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QTextBrowser::resizeEvent(QResizeEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@brief Virtual method void QTextBrowser::scrollContentsBy(int dx, int dy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@hide", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0, &_set_callback_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("emit_selectionChanged", "@brief Emitter for signal void QTextBrowser::selectionChanged()\nCall this method to emit this signal.", false, &_init_emitter_selectionChanged_0, &_call_emitter_selectionChanged_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QTextBrowser::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QTextBrowser::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QTextBrowser::setViewportMargins(int left, int top, int right, int bottom)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2744, &_call_fp_setViewportMargins_2744);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QTextBrowser::setViewportMargins(const QMargins &margins)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2115, &_call_fp_setViewportMargins_2115);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QTextBrowser::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setupViewport", "@brief Virtual method void QTextBrowser::setupViewport(QWidget *viewport)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setupViewport_1315_0, &_call_cbs_setupViewport_1315_0);
  methods += new qt_gsi::GenericMethod ("setupViewport", "@hide", false, &_init_cbs_setupViewport_1315_0, &_call_cbs_setupViewport_1315_0, &_set_callback_cbs_setupViewport_1315_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QTextBrowser::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QTextBrowser::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QTextBrowser::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_sourceChanged", "@brief Emitter for signal void QTextBrowser::sourceChanged(const QUrl &)\nCall this method to emit this signal.", false, &_init_emitter_sourceChanged_1701, &_call_emitter_sourceChanged_1701);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QTextBrowser::tabletEvent(QTabletEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("emit_textChanged", "@brief Emitter for signal void QTextBrowser::textChanged()\nCall this method to emit this signal.", false, &_init_emitter_textChanged_0, &_call_emitter_textChanged_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QTextBrowser::timerEvent(QTimerEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_undoAvailable", "@brief Emitter for signal void QTextBrowser::undoAvailable(bool b)\nCall this method to emit this signal.", false, &_init_emitter_undoAvailable_864, &_call_emitter_undoAvailable_864);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QTextBrowser::updateMicroFocus(Qt::InputMethodQuery query)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_2420, &_call_fp_updateMicroFocus_2420);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@brief Virtual method bool QTextBrowser::viewportEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@hide", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0, &_set_callback_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*viewportMargins", "@brief Method QMargins QTextBrowser::viewportMargins()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_viewportMargins_c0, &_call_fp_viewportMargins_c0);
  methods += new qt_gsi::GenericMethod ("*viewportSizeHint", "@brief Virtual method QSize QTextBrowser::viewportSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_viewportSizeHint_c0_0, &_call_cbs_viewportSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*viewportSizeHint", "@hide", true, &_init_cbs_viewportSizeHint_c0_0, &_call_cbs_viewportSizeHint_c0_0, &_set_callback_cbs_viewportSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QTextBrowser::wheelEvent(QWheelEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QTextBrowser::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QTextBrowser::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QTextBrowser::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  methods += new qt_gsi::GenericMethod ("*zoomInF", "@brief Method void QTextBrowser::zoomInF(float range)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_zoomInF_970, &_call_fp_zoomInF_970);
  return methods;
}

gsi::Class<QTextBrowser_Adaptor> decl_QTextBrowser_Adaptor (qtdecl_QTextBrowser (), "QtWidgets", "QTextBrowser",
  methods_QTextBrowser_Adaptor (),
  "@qt\n@brief Binding of QTextBrowser");

}

