
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsScene.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QGraphicsScene>
#include <QGraphicsView>
#include <QGraphicsItem>
#include <QGraphicsWidget>
#include <QGraphicsEllipseItem>
#include <QGraphicsLineItem>
#include <QGraphicsPathItem>
#include <QGraphicsPixmapItem>
#include <QGraphicsPolygonItem>
#include <QGraphicsRectItem>
#include <QGraphicsSimpleTextItem>
#include <QGraphicsTextItem>
#include <QGraphicsProxyWidget>
#include <QGraphicsItemGroup>
#include <QStyle>
#include <QGraphicsSceneContextMenuEvent>
#include <QGraphicsSceneDragDropEvent>
#include <QGraphicsSceneHelpEvent>
#include <QGraphicsSceneMouseEvent>
#include <QGraphicsSceneWheelEvent>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsScene

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsScene::staticMetaObject);
}


// QGraphicsItem *QGraphicsScene::activePanel()


static void _init_f_activePanel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_activePanel_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsScene *)cls)->activePanel ());
}


// QGraphicsWidget *QGraphicsScene::activeWindow()


static void _init_f_activeWindow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsWidget * > ();
}

static void _call_f_activeWindow_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsWidget * > ((QGraphicsWidget *)((QGraphicsScene *)cls)->activeWindow ());
}


// QGraphicsEllipseItem *QGraphicsScene::addEllipse(const QRectF &rect, const QPen &pen, const QBrush &brush)


static void _init_f_addEllipse_5241 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pen", true, "QPen()");
  decl->add_arg<const QPen & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("brush", true, "QBrush()");
  decl->add_arg<const QBrush & > (argspec_2);
  decl->set_return<QGraphicsEllipseItem * > ();
}

static void _call_f_addEllipse_5241 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  const QPen &arg2 = args ? gsi::arg_reader<const QPen & >() (args, heap) : gsi::arg_maker<const QPen & >() (QPen(), heap);
  const QBrush &arg3 = args ? gsi::arg_reader<const QBrush & >() (args, heap) : gsi::arg_maker<const QBrush & >() (QBrush(), heap);
  ret.write<QGraphicsEllipseItem * > ((QGraphicsEllipseItem *)((QGraphicsScene *)cls)->addEllipse (arg1, arg2, arg3));
}


// QGraphicsEllipseItem *QGraphicsScene::addEllipse(double x, double y, double w, double h, const QPen &pen, const QBrush &brush)


static void _init_f_addEllipse_7339 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("pen", true, "QPen()");
  decl->add_arg<const QPen & > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("brush", true, "QBrush()");
  decl->add_arg<const QBrush & > (argspec_5);
  decl->set_return<QGraphicsEllipseItem * > ();
}

static void _call_f_addEllipse_7339 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  const QPen &arg5 = args ? gsi::arg_reader<const QPen & >() (args, heap) : gsi::arg_maker<const QPen & >() (QPen(), heap);
  const QBrush &arg6 = args ? gsi::arg_reader<const QBrush & >() (args, heap) : gsi::arg_maker<const QBrush & >() (QBrush(), heap);
  ret.write<QGraphicsEllipseItem * > ((QGraphicsEllipseItem *)((QGraphicsScene *)cls)->addEllipse (arg1, arg2, arg3, arg4, arg5, arg6));
}


// void QGraphicsScene::addItem(QGraphicsItem *item)


static void _init_f_addItem_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addItem_1919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = gsi::arg_reader<QGraphicsItem * >() (args, heap);
  qt_gsi::qt_keep (arg1);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->addItem (arg1);
}


// QGraphicsLineItem *QGraphicsScene::addLine(const QLineF &line, const QPen &pen)


static void _init_f_addLine_3433 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("line");
  decl->add_arg<const QLineF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pen", true, "QPen()");
  decl->add_arg<const QPen & > (argspec_1);
  decl->set_return<QGraphicsLineItem * > ();
}

static void _call_f_addLine_3433 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLineF &arg1 = gsi::arg_reader<const QLineF & >() (args, heap);
  const QPen &arg2 = args ? gsi::arg_reader<const QPen & >() (args, heap) : gsi::arg_maker<const QPen & >() (QPen(), heap);
  ret.write<QGraphicsLineItem * > ((QGraphicsLineItem *)((QGraphicsScene *)cls)->addLine (arg1, arg2));
}


// QGraphicsLineItem *QGraphicsScene::addLine(double x1, double y1, double x2, double y2, const QPen &pen)


static void _init_f_addLine_5537 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x1");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y1");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("x2");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("y2");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("pen", true, "QPen()");
  decl->add_arg<const QPen & > (argspec_4);
  decl->set_return<QGraphicsLineItem * > ();
}

static void _call_f_addLine_5537 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  const QPen &arg5 = args ? gsi::arg_reader<const QPen & >() (args, heap) : gsi::arg_maker<const QPen & >() (QPen(), heap);
  ret.write<QGraphicsLineItem * > ((QGraphicsLineItem *)((QGraphicsScene *)cls)->addLine (arg1, arg2, arg3, arg4, arg5));
}


// QGraphicsPathItem *QGraphicsScene::addPath(const QPainterPath &path, const QPen &pen, const QBrush &brush)


static void _init_f_addPath_5893 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pen", true, "QPen()");
  decl->add_arg<const QPen & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("brush", true, "QBrush()");
  decl->add_arg<const QBrush & > (argspec_2);
  decl->set_return<QGraphicsPathItem * > ();
}

static void _call_f_addPath_5893 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  const QPen &arg2 = args ? gsi::arg_reader<const QPen & >() (args, heap) : gsi::arg_maker<const QPen & >() (QPen(), heap);
  const QBrush &arg3 = args ? gsi::arg_reader<const QBrush & >() (args, heap) : gsi::arg_maker<const QBrush & >() (QBrush(), heap);
  ret.write<QGraphicsPathItem * > ((QGraphicsPathItem *)((QGraphicsScene *)cls)->addPath (arg1, arg2, arg3));
}


// QGraphicsPixmapItem *QGraphicsScene::addPixmap(const QPixmap &pixmap)


static void _init_f_addPixmap_2017 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_0);
  decl->set_return<QGraphicsPixmapItem * > ();
}

static void _call_f_addPixmap_2017 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPixmap &arg1 = gsi::arg_reader<const QPixmap & >() (args, heap);
  ret.write<QGraphicsPixmapItem * > ((QGraphicsPixmapItem *)((QGraphicsScene *)cls)->addPixmap (arg1));
}


// QGraphicsPolygonItem *QGraphicsScene::addPolygon(const QPolygonF &polygon, const QPen &pen, const QBrush &brush)


static void _init_f_addPolygon_5587 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pen", true, "QPen()");
  decl->add_arg<const QPen & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("brush", true, "QBrush()");
  decl->add_arg<const QBrush & > (argspec_2);
  decl->set_return<QGraphicsPolygonItem * > ();
}

static void _call_f_addPolygon_5587 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygonF &arg1 = gsi::arg_reader<const QPolygonF & >() (args, heap);
  const QPen &arg2 = args ? gsi::arg_reader<const QPen & >() (args, heap) : gsi::arg_maker<const QPen & >() (QPen(), heap);
  const QBrush &arg3 = args ? gsi::arg_reader<const QBrush & >() (args, heap) : gsi::arg_maker<const QBrush & >() (QBrush(), heap);
  ret.write<QGraphicsPolygonItem * > ((QGraphicsPolygonItem *)((QGraphicsScene *)cls)->addPolygon (arg1, arg2, arg3));
}


// QGraphicsRectItem *QGraphicsScene::addRect(const QRectF &rect, const QPen &pen, const QBrush &brush)


static void _init_f_addRect_5241 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pen", true, "QPen()");
  decl->add_arg<const QPen & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("brush", true, "QBrush()");
  decl->add_arg<const QBrush & > (argspec_2);
  decl->set_return<QGraphicsRectItem * > ();
}

static void _call_f_addRect_5241 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  const QPen &arg2 = args ? gsi::arg_reader<const QPen & >() (args, heap) : gsi::arg_maker<const QPen & >() (QPen(), heap);
  const QBrush &arg3 = args ? gsi::arg_reader<const QBrush & >() (args, heap) : gsi::arg_maker<const QBrush & >() (QBrush(), heap);
  ret.write<QGraphicsRectItem * > ((QGraphicsRectItem *)((QGraphicsScene *)cls)->addRect (arg1, arg2, arg3));
}


// QGraphicsRectItem *QGraphicsScene::addRect(double x, double y, double w, double h, const QPen &pen, const QBrush &brush)


static void _init_f_addRect_7339 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("pen", true, "QPen()");
  decl->add_arg<const QPen & > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("brush", true, "QBrush()");
  decl->add_arg<const QBrush & > (argspec_5);
  decl->set_return<QGraphicsRectItem * > ();
}

static void _call_f_addRect_7339 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  const QPen &arg5 = args ? gsi::arg_reader<const QPen & >() (args, heap) : gsi::arg_maker<const QPen & >() (QPen(), heap);
  const QBrush &arg6 = args ? gsi::arg_reader<const QBrush & >() (args, heap) : gsi::arg_maker<const QBrush & >() (QBrush(), heap);
  ret.write<QGraphicsRectItem * > ((QGraphicsRectItem *)((QGraphicsScene *)cls)->addRect (arg1, arg2, arg3, arg4, arg5, arg6));
}


// QGraphicsSimpleTextItem *QGraphicsScene::addSimpleText(const QString &text, const QFont &font)


static void _init_f_addSimpleText_3718 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("font", true, "QFont()");
  decl->add_arg<const QFont & > (argspec_1);
  decl->set_return<QGraphicsSimpleTextItem * > ();
}

static void _call_f_addSimpleText_3718 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QFont &arg2 = args ? gsi::arg_reader<const QFont & >() (args, heap) : gsi::arg_maker<const QFont & >() (QFont(), heap);
  ret.write<QGraphicsSimpleTextItem * > ((QGraphicsSimpleTextItem *)((QGraphicsScene *)cls)->addSimpleText (arg1, arg2));
}


// QGraphicsTextItem *QGraphicsScene::addText(const QString &text, const QFont &font)


static void _init_f_addText_3718 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("font", true, "QFont()");
  decl->add_arg<const QFont & > (argspec_1);
  decl->set_return<QGraphicsTextItem * > ();
}

static void _call_f_addText_3718 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QFont &arg2 = args ? gsi::arg_reader<const QFont & >() (args, heap) : gsi::arg_maker<const QFont & >() (QFont(), heap);
  ret.write<QGraphicsTextItem * > ((QGraphicsTextItem *)((QGraphicsScene *)cls)->addText (arg1, arg2));
}


// QGraphicsProxyWidget *QGraphicsScene::addWidget(QWidget *widget, QFlags<Qt::WindowType> wFlags)


static void _init_f_addWidget_3702 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("wFlags", true, "Qt::WindowFlags()");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_1);
  decl->set_return<QGraphicsProxyWidget * > ();
}

static void _call_f_addWidget_3702 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  QFlags<Qt::WindowType> arg2 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (Qt::WindowFlags(), heap);
  ret.write<QGraphicsProxyWidget * > ((QGraphicsProxyWidget *)((QGraphicsScene *)cls)->addWidget (arg1, arg2));
}


// void QGraphicsScene::advance()


static void _init_f_advance_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_advance_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->advance ();
}


// QBrush QGraphicsScene::backgroundBrush()


static void _init_f_backgroundBrush_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_backgroundBrush_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QBrush > ((QBrush)((QGraphicsScene *)cls)->backgroundBrush ());
}


// int QGraphicsScene::bspTreeDepth()


static void _init_f_bspTreeDepth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_bspTreeDepth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsScene *)cls)->bspTreeDepth ());
}


// void QGraphicsScene::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->clear ();
}


// void QGraphicsScene::clearFocus()


static void _init_f_clearFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->clearFocus ();
}


// void QGraphicsScene::clearSelection()


static void _init_f_clearSelection_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearSelection_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->clearSelection ();
}


// QList<QGraphicsItem *> QGraphicsScene::collidingItems(const QGraphicsItem *item, Qt::ItemSelectionMode mode)


static void _init_f_collidingItems_c4977 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<QList<QGraphicsItem *> > ();
}

static void _call_f_collidingItems_c4977 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape), heap);
  ret.write<QList<QGraphicsItem *> > ((QList<QGraphicsItem *>)((QGraphicsScene *)cls)->collidingItems (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref()));
}


// QGraphicsItemGroup *QGraphicsScene::createItemGroup(const QList<QGraphicsItem *> &items)


static void _init_f_createItemGroup_3411 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("items");
  decl->add_arg<const QList<QGraphicsItem *> & > (argspec_0);
  decl->set_return<QGraphicsItemGroup * > ();
}

static void _call_f_createItemGroup_3411 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QGraphicsItem *> &arg1 = gsi::arg_reader<const QList<QGraphicsItem *> & >() (args, heap);
  ret.write<QGraphicsItemGroup * > ((QGraphicsItemGroup *)((QGraphicsScene *)cls)->createItemGroup (arg1));
}


// void QGraphicsScene::destroyItemGroup(QGraphicsItemGroup *group)


static void _init_f_destroyItemGroup_2444 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("group");
  decl->add_arg<QGraphicsItemGroup * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_destroyItemGroup_2444 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItemGroup *arg1 = gsi::arg_reader<QGraphicsItemGroup * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->destroyItemGroup (arg1);
}


// QGraphicsItem *QGraphicsScene::focusItem()


static void _init_f_focusItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_focusItem_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsScene *)cls)->focusItem ());
}


// bool QGraphicsScene::focusOnTouch()


static void _init_f_focusOnTouch_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_focusOnTouch_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsScene *)cls)->focusOnTouch ());
}


// QFont QGraphicsScene::font()


static void _init_f_font_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_font_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFont > ((QFont)((QGraphicsScene *)cls)->font ());
}


// QBrush QGraphicsScene::foregroundBrush()


static void _init_f_foregroundBrush_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_foregroundBrush_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QBrush > ((QBrush)((QGraphicsScene *)cls)->foregroundBrush ());
}


// bool QGraphicsScene::hasFocus()


static void _init_f_hasFocus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasFocus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsScene *)cls)->hasFocus ());
}


// double QGraphicsScene::height()


static void _init_f_height_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_height_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsScene *)cls)->height ());
}


// QVariant QGraphicsScene::inputMethodQuery(Qt::InputMethodQuery query)


static void _init_f_inputMethodQuery_c2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_inputMethodQuery_c2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QGraphicsScene *)cls)->inputMethodQuery (qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref()));
}


// void QGraphicsScene::invalidate(double x, double y, double w, double h, QFlags<QGraphicsScene::SceneLayer> layers)


static void _init_f_invalidate_7495 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("layers", true, "QGraphicsScene::AllLayers");
  decl->add_arg<QFlags<QGraphicsScene::SceneLayer> > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_invalidate_7495 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  QFlags<QGraphicsScene::SceneLayer> arg5 = args ? gsi::arg_reader<QFlags<QGraphicsScene::SceneLayer> >() (args, heap) : gsi::arg_maker<QFlags<QGraphicsScene::SceneLayer> >() (QGraphicsScene::AllLayers, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->invalidate (arg1, arg2, arg3, arg4, arg5);
}


// void QGraphicsScene::invalidate(const QRectF &rect, QFlags<QGraphicsScene::SceneLayer> layers)


static void _init_f_invalidate_5397 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("layers", true, "QGraphicsScene::AllLayers");
  decl->add_arg<QFlags<QGraphicsScene::SceneLayer> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_invalidate_5397 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args ? gsi::arg_reader<const QRectF & >() (args, heap) : gsi::arg_maker<const QRectF & >() (QRectF(), heap);
  QFlags<QGraphicsScene::SceneLayer> arg2 = args ? gsi::arg_reader<QFlags<QGraphicsScene::SceneLayer> >() (args, heap) : gsi::arg_maker<QFlags<QGraphicsScene::SceneLayer> >() (QGraphicsScene::AllLayers, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->invalidate (arg1, arg2);
}


// bool QGraphicsScene::isActive()


static void _init_f_isActive_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActive_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsScene *)cls)->isActive ());
}


// QGraphicsItem *QGraphicsScene::itemAt(const QPointF &pos, const QTransform &deviceTransform)


static void _init_f_itemAt_c4228 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("deviceTransform");
  decl->add_arg<const QTransform & > (argspec_1);
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_itemAt_c4228 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  const QTransform &arg2 = gsi::arg_reader<const QTransform & >() (args, heap);
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsScene *)cls)->itemAt (arg1, arg2));
}


// QGraphicsItem *QGraphicsScene::itemAt(double x, double y, const QTransform &deviceTransform)


static void _init_f_itemAt_c4276 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("deviceTransform");
  decl->add_arg<const QTransform & > (argspec_2);
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_itemAt_c4276 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  const QTransform &arg3 = gsi::arg_reader<const QTransform & >() (args, heap);
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsScene *)cls)->itemAt (arg1, arg2, arg3));
}


// QGraphicsScene::ItemIndexMethod QGraphicsScene::itemIndexMethod()


static void _init_f_itemIndexMethod_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QGraphicsScene::ItemIndexMethod>::target_type > ();
}

static void _call_f_itemIndexMethod_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QGraphicsScene::ItemIndexMethod>::target_type > ((qt_gsi::Converter<QGraphicsScene::ItemIndexMethod>::target_type)qt_gsi::CppToQtAdaptor<QGraphicsScene::ItemIndexMethod>(((QGraphicsScene *)cls)->itemIndexMethod ()));
}


// QList<QGraphicsItem *> QGraphicsScene::items(Qt::SortOrder order)


static void _init_f_items_c1681 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("order", true, "Qt::DescendingOrder");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_0);
  decl->set_return<QList<QGraphicsItem *> > ();
}

static void _call_f_items_c1681 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::SortOrder>(heap, Qt::DescendingOrder), heap);
  ret.write<QList<QGraphicsItem *> > ((QList<QGraphicsItem *>)((QGraphicsScene *)cls)->items (qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg1).cref()));
}


// QList<QGraphicsItem *> QGraphicsScene::items(const QPointF &pos, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)


static void _init_f_items_c8164 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("order", true, "Qt::DescendingOrder");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("deviceTransform", true, "QTransform()");
  decl->add_arg<const QTransform & > (argspec_3);
  decl->set_return<QList<QGraphicsItem *> > ();
}

static void _call_f_items_c8164 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape), heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::SortOrder>(heap, Qt::DescendingOrder), heap);
  const QTransform &arg4 = args ? gsi::arg_reader<const QTransform & >() (args, heap) : gsi::arg_maker<const QTransform & >() (QTransform(), heap);
  ret.write<QList<QGraphicsItem *> > ((QList<QGraphicsItem *>)((QGraphicsScene *)cls)->items (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref(), qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg3).cref(), arg4));
}


// QList<QGraphicsItem *> QGraphicsScene::items(const QRectF &rect, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)


static void _init_f_items_c8040 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("order", true, "Qt::DescendingOrder");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("deviceTransform", true, "QTransform()");
  decl->add_arg<const QTransform & > (argspec_3);
  decl->set_return<QList<QGraphicsItem *> > ();
}

static void _call_f_items_c8040 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape), heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::SortOrder>(heap, Qt::DescendingOrder), heap);
  const QTransform &arg4 = args ? gsi::arg_reader<const QTransform & >() (args, heap) : gsi::arg_maker<const QTransform & >() (QTransform(), heap);
  ret.write<QList<QGraphicsItem *> > ((QList<QGraphicsItem *>)((QGraphicsScene *)cls)->items (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref(), qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg3).cref(), arg4));
}


// QList<QGraphicsItem *> QGraphicsScene::items(const QPolygonF &polygon, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)


static void _init_f_items_c8386 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("order", true, "Qt::DescendingOrder");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("deviceTransform", true, "QTransform()");
  decl->add_arg<const QTransform & > (argspec_3);
  decl->set_return<QList<QGraphicsItem *> > ();
}

static void _call_f_items_c8386 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygonF &arg1 = gsi::arg_reader<const QPolygonF & >() (args, heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape), heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::SortOrder>(heap, Qt::DescendingOrder), heap);
  const QTransform &arg4 = args ? gsi::arg_reader<const QTransform & >() (args, heap) : gsi::arg_maker<const QTransform & >() (QTransform(), heap);
  ret.write<QList<QGraphicsItem *> > ((QList<QGraphicsItem *>)((QGraphicsScene *)cls)->items (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref(), qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg3).cref(), arg4));
}


// QList<QGraphicsItem *> QGraphicsScene::items(const QPainterPath &path, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)


static void _init_f_items_c8692 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("order", true, "Qt::DescendingOrder");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("deviceTransform", true, "QTransform()");
  decl->add_arg<const QTransform & > (argspec_3);
  decl->set_return<QList<QGraphicsItem *> > ();
}

static void _call_f_items_c8692 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape), heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::SortOrder>(heap, Qt::DescendingOrder), heap);
  const QTransform &arg4 = args ? gsi::arg_reader<const QTransform & >() (args, heap) : gsi::arg_maker<const QTransform & >() (QTransform(), heap);
  ret.write<QList<QGraphicsItem *> > ((QList<QGraphicsItem *>)((QGraphicsScene *)cls)->items (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref(), qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg3).cref(), arg4));
}


// QList<QGraphicsItem *> QGraphicsScene::items(double x, double y, double w, double h, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)


static void _init_f_items_c10138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("deviceTransform", true, "QTransform()");
  decl->add_arg<const QTransform & > (argspec_6);
  decl->set_return<QList<QGraphicsItem *> > ();
}

static void _call_f_items_c10138 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg5 = gsi::arg_reader<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (args, heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg6 = gsi::arg_reader<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (args, heap);
  const QTransform &arg7 = args ? gsi::arg_reader<const QTransform & >() (args, heap) : gsi::arg_maker<const QTransform & >() (QTransform(), heap);
  ret.write<QList<QGraphicsItem *> > ((QList<QGraphicsItem *>)((QGraphicsScene *)cls)->items (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg5).cref(), qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg6).cref(), arg7));
}


// QRectF QGraphicsScene::itemsBoundingRect()


static void _init_f_itemsBoundingRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_itemsBoundingRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QGraphicsScene *)cls)->itemsBoundingRect ());
}


// double QGraphicsScene::minimumRenderSize()


static void _init_f_minimumRenderSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_minimumRenderSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsScene *)cls)->minimumRenderSize ());
}


// QGraphicsItem *QGraphicsScene::mouseGrabberItem()


static void _init_f_mouseGrabberItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_mouseGrabberItem_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsScene *)cls)->mouseGrabberItem ());
}


// QPalette QGraphicsScene::palette()


static void _init_f_palette_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPalette > ();
}

static void _call_f_palette_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPalette > ((QPalette)((QGraphicsScene *)cls)->palette ());
}


// void QGraphicsScene::removeItem(QGraphicsItem *item)


static void _init_f_removeItem_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeItem_1919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = gsi::arg_reader<QGraphicsItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->removeItem (arg1);
}


// void QGraphicsScene::render(QPainter *painter, const QRectF &target, const QRectF &source, Qt::AspectRatioMode aspectRatioMode)


static void _init_f_render_7083 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("target", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("source", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("aspectRatioMode", true, "Qt::KeepAspectRatio");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_render_7083 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  const QRectF &arg2 = args ? gsi::arg_reader<const QRectF & >() (args, heap) : gsi::arg_maker<const QRectF & >() (QRectF(), heap);
  const QRectF &arg3 = args ? gsi::arg_reader<const QRectF & >() (args, heap) : gsi::arg_maker<const QRectF & >() (QRectF(), heap);
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg4 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::AspectRatioMode>(heap, Qt::KeepAspectRatio), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->render (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg4).cref());
}


// QRectF QGraphicsScene::sceneRect()


static void _init_f_sceneRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_sceneRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QGraphicsScene *)cls)->sceneRect ());
}


// QList<QGraphicsItem *> QGraphicsScene::selectedItems()


static void _init_f_selectedItems_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QGraphicsItem *> > ();
}

static void _call_f_selectedItems_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QGraphicsItem *> > ((QList<QGraphicsItem *>)((QGraphicsScene *)cls)->selectedItems ());
}


// QPainterPath QGraphicsScene::selectionArea()


static void _init_f_selectionArea_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_f_selectionArea_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsScene *)cls)->selectionArea ());
}


// bool QGraphicsScene::sendEvent(QGraphicsItem *item, QEvent *event)


static void _init_f_sendEvent_3028 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_sendEvent_3028 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = gsi::arg_reader<QGraphicsItem * >() (args, heap);
  QEvent *arg2 = gsi::arg_reader<QEvent * >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsScene *)cls)->sendEvent (arg1, arg2));
}


// void QGraphicsScene::setActivePanel(QGraphicsItem *item)


static void _init_f_setActivePanel_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActivePanel_1919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = gsi::arg_reader<QGraphicsItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->setActivePanel (arg1);
}


// void QGraphicsScene::setActiveWindow(QGraphicsWidget *widget)


static void _init_f_setActiveWindow_2132 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QGraphicsWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActiveWindow_2132 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsWidget *arg1 = gsi::arg_reader<QGraphicsWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->setActiveWindow (arg1);
}


// void QGraphicsScene::setBackgroundBrush(const QBrush &brush)


static void _init_f_setBackgroundBrush_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brush");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackgroundBrush_1910 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QBrush &arg1 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->setBackgroundBrush (arg1);
}


// void QGraphicsScene::setBspTreeDepth(int depth)


static void _init_f_setBspTreeDepth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("depth");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBspTreeDepth_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->setBspTreeDepth (arg1);
}


// void QGraphicsScene::setFocus(Qt::FocusReason focusReason)


static void _init_f_setFocus_1877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("focusReason", true, "Qt::OtherFocusReason");
  decl->add_arg<const qt_gsi::Converter<Qt::FocusReason>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocus_1877 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::FocusReason>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::FocusReason>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::FocusReason>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::FocusReason>(heap, Qt::OtherFocusReason), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->setFocus (qt_gsi::QtToCppAdaptor<Qt::FocusReason>(arg1).cref());
}


// void QGraphicsScene::setFocusItem(QGraphicsItem *item, Qt::FocusReason focusReason)


static void _init_f_setFocusItem_3688 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("focusReason", true, "Qt::OtherFocusReason");
  decl->add_arg<const qt_gsi::Converter<Qt::FocusReason>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFocusItem_3688 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = gsi::arg_reader<QGraphicsItem * >() (args, heap);
  const qt_gsi::Converter<Qt::FocusReason>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::FocusReason>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::FocusReason>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::FocusReason>(heap, Qt::OtherFocusReason), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->setFocusItem (arg1, qt_gsi::QtToCppAdaptor<Qt::FocusReason>(arg2).cref());
}


// void QGraphicsScene::setFocusOnTouch(bool enabled)


static void _init_f_setFocusOnTouch_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocusOnTouch_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->setFocusOnTouch (arg1);
}


// void QGraphicsScene::setFont(const QFont &font)


static void _init_f_setFont_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("font");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFont_1801 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->setFont (arg1);
}


// void QGraphicsScene::setForegroundBrush(const QBrush &brush)


static void _init_f_setForegroundBrush_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brush");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setForegroundBrush_1910 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QBrush &arg1 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->setForegroundBrush (arg1);
}


// void QGraphicsScene::setItemIndexMethod(QGraphicsScene::ItemIndexMethod method)


static void _init_f_setItemIndexMethod_3456 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("method");
  decl->add_arg<const qt_gsi::Converter<QGraphicsScene::ItemIndexMethod>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItemIndexMethod_3456 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QGraphicsScene::ItemIndexMethod>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QGraphicsScene::ItemIndexMethod>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->setItemIndexMethod (qt_gsi::QtToCppAdaptor<QGraphicsScene::ItemIndexMethod>(arg1).cref());
}


// void QGraphicsScene::setMinimumRenderSize(double minSize)


static void _init_f_setMinimumRenderSize_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("minSize");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimumRenderSize_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->setMinimumRenderSize (arg1);
}


// void QGraphicsScene::setPalette(const QPalette &palette)


static void _init_f_setPalette_2113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("palette");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPalette_2113 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = gsi::arg_reader<const QPalette & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->setPalette (arg1);
}


// void QGraphicsScene::setSceneRect(const QRectF &rect)


static void _init_f_setSceneRect_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSceneRect_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->setSceneRect (arg1);
}


// void QGraphicsScene::setSceneRect(double x, double y, double w, double h)


static void _init_f_setSceneRect_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setSceneRect_3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->setSceneRect (arg1, arg2, arg3, arg4);
}


// void QGraphicsScene::setSelectionArea(const QPainterPath &path, const QTransform &deviceTransform)


static void _init_f_setSelectionArea_4756 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("deviceTransform");
  decl->add_arg<const QTransform & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSelectionArea_4756 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  const QTransform &arg2 = gsi::arg_reader<const QTransform & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->setSelectionArea (arg1, arg2);
}


// void QGraphicsScene::setSelectionArea(const QPainterPath &path, Qt::ItemSelectionOperation selectionOperation, Qt::ItemSelectionMode mode, const QTransform &deviceTransform)


static void _init_f_setSelectionArea_10038 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("selectionOperation", true, "Qt::ReplaceSelection");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionOperation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("deviceTransform", true, "QTransform()");
  decl->add_arg<const QTransform & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setSelectionArea_10038 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  const qt_gsi::Converter<Qt::ItemSelectionOperation>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ItemSelectionOperation>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ItemSelectionOperation>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionOperation>(heap, Qt::ReplaceSelection), heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape), heap);
  const QTransform &arg4 = args ? gsi::arg_reader<const QTransform & >() (args, heap) : gsi::arg_maker<const QTransform & >() (QTransform(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->setSelectionArea (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionOperation>(arg2).cref(), qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg3).cref(), arg4);
}


// void QGraphicsScene::setStickyFocus(bool enabled)


static void _init_f_setStickyFocus_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStickyFocus_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->setStickyFocus (arg1);
}


// void QGraphicsScene::setStyle(QStyle *style)


static void _init_f_setStyle_1232 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("style");
  decl->add_arg<QStyle * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStyle_1232 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyle *arg1 = gsi::arg_reader<QStyle * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->setStyle (arg1);
}


// bool QGraphicsScene::stickyFocus()


static void _init_f_stickyFocus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_stickyFocus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsScene *)cls)->stickyFocus ());
}


// QStyle *QGraphicsScene::style()


static void _init_f_style_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStyle * > ();
}

static void _call_f_style_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStyle * > ((QStyle *)((QGraphicsScene *)cls)->style ());
}


// void QGraphicsScene::update(double x, double y, double w, double h)


static void _init_f_update_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_update_3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->update (arg1, arg2, arg3, arg4);
}


// void QGraphicsScene::update(const QRectF &rect)


static void _init_f_update_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_update_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args ? gsi::arg_reader<const QRectF & >() (args, heap) : gsi::arg_maker<const QRectF & >() (QRectF(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene *)cls)->update (arg1);
}


// QList<QGraphicsView *> QGraphicsScene::views()


static void _init_f_views_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QGraphicsView *> > ();
}

static void _call_f_views_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QGraphicsView *> > ((QList<QGraphicsView *>)((QGraphicsScene *)cls)->views ());
}


// double QGraphicsScene::width()


static void _init_f_width_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_width_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsScene *)cls)->width ());
}


// static QString QGraphicsScene::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QGraphicsScene::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QGraphicsScene () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":activePanel", "@brief Method QGraphicsItem *QGraphicsScene::activePanel()\n", true, &_init_f_activePanel_c0, &_call_f_activePanel_c0);
  methods += new qt_gsi::GenericMethod (":activeWindow", "@brief Method QGraphicsWidget *QGraphicsScene::activeWindow()\n", true, &_init_f_activeWindow_c0, &_call_f_activeWindow_c0);
  methods += new qt_gsi::GenericMethod ("addEllipse", "@brief Method QGraphicsEllipseItem *QGraphicsScene::addEllipse(const QRectF &rect, const QPen &pen, const QBrush &brush)\n", false, &_init_f_addEllipse_5241, &_call_f_addEllipse_5241);
  methods += new qt_gsi::GenericMethod ("addEllipse", "@brief Method QGraphicsEllipseItem *QGraphicsScene::addEllipse(double x, double y, double w, double h, const QPen &pen, const QBrush &brush)\n", false, &_init_f_addEllipse_7339, &_call_f_addEllipse_7339);
  methods += new qt_gsi::GenericMethod ("addItem", "@brief Method void QGraphicsScene::addItem(QGraphicsItem *item)\n", false, &_init_f_addItem_1919, &_call_f_addItem_1919);
  methods += new qt_gsi::GenericMethod ("addLine", "@brief Method QGraphicsLineItem *QGraphicsScene::addLine(const QLineF &line, const QPen &pen)\n", false, &_init_f_addLine_3433, &_call_f_addLine_3433);
  methods += new qt_gsi::GenericMethod ("addLine", "@brief Method QGraphicsLineItem *QGraphicsScene::addLine(double x1, double y1, double x2, double y2, const QPen &pen)\n", false, &_init_f_addLine_5537, &_call_f_addLine_5537);
  methods += new qt_gsi::GenericMethod ("addPath", "@brief Method QGraphicsPathItem *QGraphicsScene::addPath(const QPainterPath &path, const QPen &pen, const QBrush &brush)\n", false, &_init_f_addPath_5893, &_call_f_addPath_5893);
  methods += new qt_gsi::GenericMethod ("addPixmap", "@brief Method QGraphicsPixmapItem *QGraphicsScene::addPixmap(const QPixmap &pixmap)\n", false, &_init_f_addPixmap_2017, &_call_f_addPixmap_2017);
  methods += new qt_gsi::GenericMethod ("addPolygon", "@brief Method QGraphicsPolygonItem *QGraphicsScene::addPolygon(const QPolygonF &polygon, const QPen &pen, const QBrush &brush)\n", false, &_init_f_addPolygon_5587, &_call_f_addPolygon_5587);
  methods += new qt_gsi::GenericMethod ("addRect", "@brief Method QGraphicsRectItem *QGraphicsScene::addRect(const QRectF &rect, const QPen &pen, const QBrush &brush)\n", false, &_init_f_addRect_5241, &_call_f_addRect_5241);
  methods += new qt_gsi::GenericMethod ("addRect", "@brief Method QGraphicsRectItem *QGraphicsScene::addRect(double x, double y, double w, double h, const QPen &pen, const QBrush &brush)\n", false, &_init_f_addRect_7339, &_call_f_addRect_7339);
  methods += new qt_gsi::GenericMethod ("addSimpleText", "@brief Method QGraphicsSimpleTextItem *QGraphicsScene::addSimpleText(const QString &text, const QFont &font)\n", false, &_init_f_addSimpleText_3718, &_call_f_addSimpleText_3718);
  methods += new qt_gsi::GenericMethod ("addText", "@brief Method QGraphicsTextItem *QGraphicsScene::addText(const QString &text, const QFont &font)\n", false, &_init_f_addText_3718, &_call_f_addText_3718);
  methods += new qt_gsi::GenericMethod ("addWidget", "@brief Method QGraphicsProxyWidget *QGraphicsScene::addWidget(QWidget *widget, QFlags<Qt::WindowType> wFlags)\n", false, &_init_f_addWidget_3702, &_call_f_addWidget_3702);
  methods += new qt_gsi::GenericMethod ("advance", "@brief Method void QGraphicsScene::advance()\n", false, &_init_f_advance_0, &_call_f_advance_0);
  methods += new qt_gsi::GenericMethod (":backgroundBrush", "@brief Method QBrush QGraphicsScene::backgroundBrush()\n", true, &_init_f_backgroundBrush_c0, &_call_f_backgroundBrush_c0);
  methods += new qt_gsi::GenericMethod (":bspTreeDepth", "@brief Method int QGraphicsScene::bspTreeDepth()\n", true, &_init_f_bspTreeDepth_c0, &_call_f_bspTreeDepth_c0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QGraphicsScene::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("clearFocus", "@brief Method void QGraphicsScene::clearFocus()\n", false, &_init_f_clearFocus_0, &_call_f_clearFocus_0);
  methods += new qt_gsi::GenericMethod ("clearSelection", "@brief Method void QGraphicsScene::clearSelection()\n", false, &_init_f_clearSelection_0, &_call_f_clearSelection_0);
  methods += new qt_gsi::GenericMethod ("collidingItems", "@brief Method QList<QGraphicsItem *> QGraphicsScene::collidingItems(const QGraphicsItem *item, Qt::ItemSelectionMode mode)\n", true, &_init_f_collidingItems_c4977, &_call_f_collidingItems_c4977);
  methods += new qt_gsi::GenericMethod ("createItemGroup", "@brief Method QGraphicsItemGroup *QGraphicsScene::createItemGroup(const QList<QGraphicsItem *> &items)\n", false, &_init_f_createItemGroup_3411, &_call_f_createItemGroup_3411);
  methods += new qt_gsi::GenericMethod ("destroyItemGroup", "@brief Method void QGraphicsScene::destroyItemGroup(QGraphicsItemGroup *group)\n", false, &_init_f_destroyItemGroup_2444, &_call_f_destroyItemGroup_2444);
  methods += new qt_gsi::GenericMethod (":focusItem", "@brief Method QGraphicsItem *QGraphicsScene::focusItem()\n", true, &_init_f_focusItem_c0, &_call_f_focusItem_c0);
  methods += new qt_gsi::GenericMethod (":focusOnTouch", "@brief Method bool QGraphicsScene::focusOnTouch()\n", true, &_init_f_focusOnTouch_c0, &_call_f_focusOnTouch_c0);
  methods += new qt_gsi::GenericMethod (":font", "@brief Method QFont QGraphicsScene::font()\n", true, &_init_f_font_c0, &_call_f_font_c0);
  methods += new qt_gsi::GenericMethod (":foregroundBrush", "@brief Method QBrush QGraphicsScene::foregroundBrush()\n", true, &_init_f_foregroundBrush_c0, &_call_f_foregroundBrush_c0);
  methods += new qt_gsi::GenericMethod ("hasFocus", "@brief Method bool QGraphicsScene::hasFocus()\n", true, &_init_f_hasFocus_c0, &_call_f_hasFocus_c0);
  methods += new qt_gsi::GenericMethod ("height", "@brief Method double QGraphicsScene::height()\n", true, &_init_f_height_c0, &_call_f_height_c0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Method QVariant QGraphicsScene::inputMethodQuery(Qt::InputMethodQuery query)\n", true, &_init_f_inputMethodQuery_c2420, &_call_f_inputMethodQuery_c2420);
  methods += new qt_gsi::GenericMethod ("invalidate", "@brief Method void QGraphicsScene::invalidate(double x, double y, double w, double h, QFlags<QGraphicsScene::SceneLayer> layers)\n", false, &_init_f_invalidate_7495, &_call_f_invalidate_7495);
  methods += new qt_gsi::GenericMethod ("invalidate", "@brief Method void QGraphicsScene::invalidate(const QRectF &rect, QFlags<QGraphicsScene::SceneLayer> layers)\n", false, &_init_f_invalidate_5397, &_call_f_invalidate_5397);
  methods += new qt_gsi::GenericMethod ("isActive?", "@brief Method bool QGraphicsScene::isActive()\n", true, &_init_f_isActive_c0, &_call_f_isActive_c0);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Method QGraphicsItem *QGraphicsScene::itemAt(const QPointF &pos, const QTransform &deviceTransform)\n", true, &_init_f_itemAt_c4228, &_call_f_itemAt_c4228);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Method QGraphicsItem *QGraphicsScene::itemAt(double x, double y, const QTransform &deviceTransform)\n", true, &_init_f_itemAt_c4276, &_call_f_itemAt_c4276);
  methods += new qt_gsi::GenericMethod (":itemIndexMethod", "@brief Method QGraphicsScene::ItemIndexMethod QGraphicsScene::itemIndexMethod()\n", true, &_init_f_itemIndexMethod_c0, &_call_f_itemIndexMethod_c0);
  methods += new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsScene::items(Qt::SortOrder order)\n", true, &_init_f_items_c1681, &_call_f_items_c1681);
  methods += new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsScene::items(const QPointF &pos, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)\n", true, &_init_f_items_c8164, &_call_f_items_c8164);
  methods += new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsScene::items(const QRectF &rect, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)\n", true, &_init_f_items_c8040, &_call_f_items_c8040);
  methods += new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsScene::items(const QPolygonF &polygon, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)\n", true, &_init_f_items_c8386, &_call_f_items_c8386);
  methods += new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsScene::items(const QPainterPath &path, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)\n", true, &_init_f_items_c8692, &_call_f_items_c8692);
  methods += new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsScene::items(double x, double y, double w, double h, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)\n", true, &_init_f_items_c10138, &_call_f_items_c10138);
  methods += new qt_gsi::GenericMethod ("itemsBoundingRect", "@brief Method QRectF QGraphicsScene::itemsBoundingRect()\n", true, &_init_f_itemsBoundingRect_c0, &_call_f_itemsBoundingRect_c0);
  methods += new qt_gsi::GenericMethod (":minimumRenderSize", "@brief Method double QGraphicsScene::minimumRenderSize()\n", true, &_init_f_minimumRenderSize_c0, &_call_f_minimumRenderSize_c0);
  methods += new qt_gsi::GenericMethod ("mouseGrabberItem", "@brief Method QGraphicsItem *QGraphicsScene::mouseGrabberItem()\n", true, &_init_f_mouseGrabberItem_c0, &_call_f_mouseGrabberItem_c0);
  methods += new qt_gsi::GenericMethod (":palette", "@brief Method QPalette QGraphicsScene::palette()\n", true, &_init_f_palette_c0, &_call_f_palette_c0);
  methods += new qt_gsi::GenericMethod ("removeItem", "@brief Method void QGraphicsScene::removeItem(QGraphicsItem *item)\n", false, &_init_f_removeItem_1919, &_call_f_removeItem_1919);
  methods += new qt_gsi::GenericMethod ("render", "@brief Method void QGraphicsScene::render(QPainter *painter, const QRectF &target, const QRectF &source, Qt::AspectRatioMode aspectRatioMode)\n", false, &_init_f_render_7083, &_call_f_render_7083);
  methods += new qt_gsi::GenericMethod (":sceneRect", "@brief Method QRectF QGraphicsScene::sceneRect()\n", true, &_init_f_sceneRect_c0, &_call_f_sceneRect_c0);
  methods += new qt_gsi::GenericMethod ("selectedItems", "@brief Method QList<QGraphicsItem *> QGraphicsScene::selectedItems()\n", true, &_init_f_selectedItems_c0, &_call_f_selectedItems_c0);
  methods += new qt_gsi::GenericMethod (":selectionArea", "@brief Method QPainterPath QGraphicsScene::selectionArea()\n", true, &_init_f_selectionArea_c0, &_call_f_selectionArea_c0);
  methods += new qt_gsi::GenericMethod ("sendEvent", "@brief Method bool QGraphicsScene::sendEvent(QGraphicsItem *item, QEvent *event)\n", false, &_init_f_sendEvent_3028, &_call_f_sendEvent_3028);
  methods += new qt_gsi::GenericMethod ("setActivePanel|activePanel=", "@brief Method void QGraphicsScene::setActivePanel(QGraphicsItem *item)\n", false, &_init_f_setActivePanel_1919, &_call_f_setActivePanel_1919);
  methods += new qt_gsi::GenericMethod ("setActiveWindow|activeWindow=", "@brief Method void QGraphicsScene::setActiveWindow(QGraphicsWidget *widget)\n", false, &_init_f_setActiveWindow_2132, &_call_f_setActiveWindow_2132);
  methods += new qt_gsi::GenericMethod ("setBackgroundBrush|backgroundBrush=", "@brief Method void QGraphicsScene::setBackgroundBrush(const QBrush &brush)\n", false, &_init_f_setBackgroundBrush_1910, &_call_f_setBackgroundBrush_1910);
  methods += new qt_gsi::GenericMethod ("setBspTreeDepth|bspTreeDepth=", "@brief Method void QGraphicsScene::setBspTreeDepth(int depth)\n", false, &_init_f_setBspTreeDepth_767, &_call_f_setBspTreeDepth_767);
  methods += new qt_gsi::GenericMethod ("setFocus", "@brief Method void QGraphicsScene::setFocus(Qt::FocusReason focusReason)\n", false, &_init_f_setFocus_1877, &_call_f_setFocus_1877);
  methods += new qt_gsi::GenericMethod ("setFocusItem", "@brief Method void QGraphicsScene::setFocusItem(QGraphicsItem *item, Qt::FocusReason focusReason)\n", false, &_init_f_setFocusItem_3688, &_call_f_setFocusItem_3688);
  methods += new qt_gsi::GenericMethod ("setFocusOnTouch|focusOnTouch=", "@brief Method void QGraphicsScene::setFocusOnTouch(bool enabled)\n", false, &_init_f_setFocusOnTouch_864, &_call_f_setFocusOnTouch_864);
  methods += new qt_gsi::GenericMethod ("setFont|font=", "@brief Method void QGraphicsScene::setFont(const QFont &font)\n", false, &_init_f_setFont_1801, &_call_f_setFont_1801);
  methods += new qt_gsi::GenericMethod ("setForegroundBrush|foregroundBrush=", "@brief Method void QGraphicsScene::setForegroundBrush(const QBrush &brush)\n", false, &_init_f_setForegroundBrush_1910, &_call_f_setForegroundBrush_1910);
  methods += new qt_gsi::GenericMethod ("setItemIndexMethod|itemIndexMethod=", "@brief Method void QGraphicsScene::setItemIndexMethod(QGraphicsScene::ItemIndexMethod method)\n", false, &_init_f_setItemIndexMethod_3456, &_call_f_setItemIndexMethod_3456);
  methods += new qt_gsi::GenericMethod ("setMinimumRenderSize|minimumRenderSize=", "@brief Method void QGraphicsScene::setMinimumRenderSize(double minSize)\n", false, &_init_f_setMinimumRenderSize_1071, &_call_f_setMinimumRenderSize_1071);
  methods += new qt_gsi::GenericMethod ("setPalette|palette=", "@brief Method void QGraphicsScene::setPalette(const QPalette &palette)\n", false, &_init_f_setPalette_2113, &_call_f_setPalette_2113);
  methods += new qt_gsi::GenericMethod ("setSceneRect|sceneRect=", "@brief Method void QGraphicsScene::setSceneRect(const QRectF &rect)\n", false, &_init_f_setSceneRect_1862, &_call_f_setSceneRect_1862);
  methods += new qt_gsi::GenericMethod ("setSceneRect", "@brief Method void QGraphicsScene::setSceneRect(double x, double y, double w, double h)\n", false, &_init_f_setSceneRect_3960, &_call_f_setSceneRect_3960);
  methods += new qt_gsi::GenericMethod ("setSelectionArea", "@brief Method void QGraphicsScene::setSelectionArea(const QPainterPath &path, const QTransform &deviceTransform)\n", false, &_init_f_setSelectionArea_4756, &_call_f_setSelectionArea_4756);
  methods += new qt_gsi::GenericMethod ("setSelectionArea", "@brief Method void QGraphicsScene::setSelectionArea(const QPainterPath &path, Qt::ItemSelectionOperation selectionOperation, Qt::ItemSelectionMode mode, const QTransform &deviceTransform)\n", false, &_init_f_setSelectionArea_10038, &_call_f_setSelectionArea_10038);
  methods += new qt_gsi::GenericMethod ("setStickyFocus|stickyFocus=", "@brief Method void QGraphicsScene::setStickyFocus(bool enabled)\n", false, &_init_f_setStickyFocus_864, &_call_f_setStickyFocus_864);
  methods += new qt_gsi::GenericMethod ("setStyle|style=", "@brief Method void QGraphicsScene::setStyle(QStyle *style)\n", false, &_init_f_setStyle_1232, &_call_f_setStyle_1232);
  methods += new qt_gsi::GenericMethod (":stickyFocus", "@brief Method bool QGraphicsScene::stickyFocus()\n", true, &_init_f_stickyFocus_c0, &_call_f_stickyFocus_c0);
  methods += new qt_gsi::GenericMethod (":style", "@brief Method QStyle *QGraphicsScene::style()\n", true, &_init_f_style_c0, &_call_f_style_c0);
  methods += new qt_gsi::GenericMethod ("update", "@brief Method void QGraphicsScene::update(double x, double y, double w, double h)\n", false, &_init_f_update_3960, &_call_f_update_3960);
  methods += new qt_gsi::GenericMethod ("update", "@brief Method void QGraphicsScene::update(const QRectF &rect)\n", false, &_init_f_update_1862, &_call_f_update_1862);
  methods += new qt_gsi::GenericMethod ("views", "@brief Method QList<QGraphicsView *> QGraphicsScene::views()\n", true, &_init_f_views_c0, &_call_f_views_c0);
  methods += new qt_gsi::GenericMethod ("width", "@brief Method double QGraphicsScene::width()\n", true, &_init_f_width_c0, &_call_f_width_c0);
  methods += gsi::qt_signal<const QList<QRectF> & > ("changed(const QList<QRectF> &)", "changed", gsi::arg("region"), "@brief Signal declaration for QGraphicsScene::changed(const QList<QRectF> &region)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QGraphicsScene::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QGraphicsItem *, QGraphicsItem *, const qt_gsi::Converter<Qt::FocusReason>::target_type & > ("focusItemChanged(QGraphicsItem *, QGraphicsItem *, Qt::FocusReason)", "focusItemChanged", gsi::arg("newFocus"), gsi::arg("oldFocus"), gsi::arg("reason"), "@brief Signal declaration for QGraphicsScene::focusItemChanged(QGraphicsItem *newFocus, QGraphicsItem *oldFocus, Qt::FocusReason reason)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QGraphicsScene::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QRectF & > ("sceneRectChanged(const QRectF &)", "sceneRectChanged", gsi::arg("rect"), "@brief Signal declaration for QGraphicsScene::sceneRectChanged(const QRectF &rect)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("selectionChanged()", "selectionChanged", "@brief Signal declaration for QGraphicsScene::selectionChanged()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsScene::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QGraphicsScene> decl_QGraphicsScene (qtdecl_QObject (), "QtWidgets", "QGraphicsScene_Native",
  methods_QGraphicsScene (),
  "@hide\n@alias QGraphicsScene");

GSI_QTWIDGETS_PUBLIC gsi::Class<QGraphicsScene> &qtdecl_QGraphicsScene () { return decl_QGraphicsScene; }

}


class QGraphicsScene_Adaptor : public QGraphicsScene, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsScene_Adaptor();

  //  [adaptor ctor] QGraphicsScene::QGraphicsScene(QObject *parent)
  QGraphicsScene_Adaptor() : QGraphicsScene()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsScene::QGraphicsScene(QObject *parent)
  QGraphicsScene_Adaptor(QObject *parent) : QGraphicsScene(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsScene::QGraphicsScene(const QRectF &sceneRect, QObject *parent)
  QGraphicsScene_Adaptor(const QRectF &sceneRect) : QGraphicsScene(sceneRect)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsScene::QGraphicsScene(const QRectF &sceneRect, QObject *parent)
  QGraphicsScene_Adaptor(const QRectF &sceneRect, QObject *parent) : QGraphicsScene(sceneRect, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsScene::QGraphicsScene(double x, double y, double width, double height, QObject *parent)
  QGraphicsScene_Adaptor(double x, double y, double width, double height) : QGraphicsScene(x, y, width, height)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsScene::QGraphicsScene(double x, double y, double width, double height, QObject *parent)
  QGraphicsScene_Adaptor(double x, double y, double width, double height, QObject *parent) : QGraphicsScene(x, y, width, height, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QGraphicsScene::isSignalConnected(const QMetaMethod &signal)
  bool fp_QGraphicsScene_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QGraphicsScene::isSignalConnected(signal);
  }

  //  [expose] int QGraphicsScene::receivers(const char *signal)
  int fp_QGraphicsScene_receivers_c1731 (const char *signal) const {
    return QGraphicsScene::receivers(signal);
  }

  //  [expose] QObject *QGraphicsScene::sender()
  QObject * fp_QGraphicsScene_sender_c0 () const {
    return QGraphicsScene::sender();
  }

  //  [expose] int QGraphicsScene::senderSignalIndex()
  int fp_QGraphicsScene_senderSignalIndex_c0 () const {
    return QGraphicsScene::senderSignalIndex();
  }

  //  [emitter impl] void QGraphicsScene::changed(const QList<QRectF> &region)
  void emitter_QGraphicsScene_changed_2477(const QList<QRectF> &region)
  {
    emit QGraphicsScene::changed(region);
  }

  //  [emitter impl] void QGraphicsScene::destroyed(QObject *)
  void emitter_QGraphicsScene_destroyed_1302(QObject *arg1)
  {
    emit QGraphicsScene::destroyed(arg1);
  }

  //  [emitter impl] void QGraphicsScene::focusItemChanged(QGraphicsItem *newFocus, QGraphicsItem *oldFocus, Qt::FocusReason reason)
  void emitter_QGraphicsScene_focusItemChanged_5499(QGraphicsItem *newFocus, QGraphicsItem *oldFocus, Qt::FocusReason reason)
  {
    emit QGraphicsScene::focusItemChanged(newFocus, oldFocus, reason);
  }

  //  [adaptor impl] QVariant QGraphicsScene::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QGraphicsScene::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QGraphicsScene_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QGraphicsScene_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QGraphicsScene::inputMethodQuery(query);
    }
  }

  //  [emitter impl] void QGraphicsScene::objectNameChanged(const QString &objectName)
  void emitter_QGraphicsScene_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QGraphicsScene::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QGraphicsScene::sceneRectChanged(const QRectF &rect)
  void emitter_QGraphicsScene_sceneRectChanged_1862(const QRectF &rect)
  {
    emit QGraphicsScene::sceneRectChanged(rect);
  }

  //  [emitter impl] void QGraphicsScene::selectionChanged()
  void emitter_QGraphicsScene_selectionChanged_0()
  {
    emit QGraphicsScene::selectionChanged();
  }

  //  [adaptor impl] void QGraphicsScene::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QGraphicsScene::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsScene_Adaptor, QChildEvent *>(&QGraphicsScene_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QGraphicsScene::childEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  void cbs_contextMenuEvent_3674_0(QGraphicsSceneContextMenuEvent *event)
  {
    QGraphicsScene::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_3674_0.can_issue()) {
      cb_contextMenuEvent_3674_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneContextMenuEvent *>(&QGraphicsScene_Adaptor::cbs_contextMenuEvent_3674_0, event);
    } else {
      QGraphicsScene::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QGraphicsScene::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsScene_Adaptor, QEvent *>(&QGraphicsScene_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QGraphicsScene::customEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QGraphicsScene::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QGraphicsScene_Adaptor, const QMetaMethod &>(&QGraphicsScene_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QGraphicsScene::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsScene::dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragEnterEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsScene::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragEnterEvent_3315_0.can_issue()) {
      cb_dragEnterEvent_3315_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsScene_Adaptor::cbs_dragEnterEvent_3315_0, event);
    } else {
      QGraphicsScene::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragLeaveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsScene::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragLeaveEvent_3315_0.can_issue()) {
      cb_dragLeaveEvent_3315_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsScene_Adaptor::cbs_dragLeaveEvent_3315_0, event);
    } else {
      QGraphicsScene::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragMoveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsScene::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragMoveEvent_3315_0.can_issue()) {
      cb_dragMoveEvent_3315_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsScene_Adaptor::cbs_dragMoveEvent_3315_0, event);
    } else {
      QGraphicsScene::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::drawBackground(QPainter *painter, const QRectF &rect)
  void cbs_drawBackground_3180_0(QPainter *painter, const QRectF &rect)
  {
    QGraphicsScene::drawBackground(painter, rect);
  }

  virtual void drawBackground(QPainter *painter, const QRectF &rect)
  {
    if (cb_drawBackground_3180_0.can_issue()) {
      cb_drawBackground_3180_0.issue<QGraphicsScene_Adaptor, QPainter *, const QRectF &>(&QGraphicsScene_Adaptor::cbs_drawBackground_3180_0, painter, rect);
    } else {
      QGraphicsScene::drawBackground(painter, rect);
    }
  }

  //  [adaptor impl] void QGraphicsScene::drawForeground(QPainter *painter, const QRectF &rect)
  void cbs_drawForeground_3180_0(QPainter *painter, const QRectF &rect)
  {
    QGraphicsScene::drawForeground(painter, rect);
  }

  virtual void drawForeground(QPainter *painter, const QRectF &rect)
  {
    if (cb_drawForeground_3180_0.can_issue()) {
      cb_drawForeground_3180_0.issue<QGraphicsScene_Adaptor, QPainter *, const QRectF &>(&QGraphicsScene_Adaptor::cbs_drawForeground_3180_0, painter, rect);
    } else {
      QGraphicsScene::drawForeground(painter, rect);
    }
  }

  //  [adaptor impl] void QGraphicsScene::dropEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dropEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsScene::dropEvent(event);
  }

  virtual void dropEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dropEvent_3315_0.can_issue()) {
      cb_dropEvent_3315_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsScene_Adaptor::cbs_dropEvent_3315_0, event);
    } else {
      QGraphicsScene::dropEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsScene::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QGraphicsScene::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsScene_Adaptor, bool, QEvent *>(&QGraphicsScene_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QGraphicsScene::event(_event);
    }
  }

  //  [adaptor impl] bool QGraphicsScene::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QGraphicsScene::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsScene_Adaptor, bool, QObject *, QEvent *>(&QGraphicsScene_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QGraphicsScene::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsScene::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QGraphicsScene_Adaptor, QFocusEvent *>(&QGraphicsScene_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QGraphicsScene::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsScene::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QGraphicsScene::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QGraphicsScene_Adaptor, bool, bool>(&QGraphicsScene_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QGraphicsScene::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QGraphicsScene::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsScene::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QGraphicsScene_Adaptor, QFocusEvent *>(&QGraphicsScene_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QGraphicsScene::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::helpEvent(QGraphicsSceneHelpEvent *event)
  void cbs_helpEvent_2921_0(QGraphicsSceneHelpEvent *event)
  {
    QGraphicsScene::helpEvent(event);
  }

  virtual void helpEvent(QGraphicsSceneHelpEvent *event)
  {
    if (cb_helpEvent_2921_0.can_issue()) {
      cb_helpEvent_2921_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneHelpEvent *>(&QGraphicsScene_Adaptor::cbs_helpEvent_2921_0, event);
    } else {
      QGraphicsScene::helpEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QGraphicsScene::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QGraphicsScene_Adaptor, QInputMethodEvent *>(&QGraphicsScene_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QGraphicsScene::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsScene::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QGraphicsScene_Adaptor, QKeyEvent *>(&QGraphicsScene_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QGraphicsScene::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsScene::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QGraphicsScene_Adaptor, QKeyEvent *>(&QGraphicsScene_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QGraphicsScene::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseDoubleClickEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsScene::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_3049_0.can_issue()) {
      cb_mouseDoubleClickEvent_3049_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsScene_Adaptor::cbs_mouseDoubleClickEvent_3049_0, event);
    } else {
      QGraphicsScene::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseMoveEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsScene::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseMoveEvent_3049_0.can_issue()) {
      cb_mouseMoveEvent_3049_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsScene_Adaptor::cbs_mouseMoveEvent_3049_0, event);
    } else {
      QGraphicsScene::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::mousePressEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mousePressEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsScene::mousePressEvent(event);
  }

  virtual void mousePressEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mousePressEvent_3049_0.can_issue()) {
      cb_mousePressEvent_3049_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsScene_Adaptor::cbs_mousePressEvent_3049_0, event);
    } else {
      QGraphicsScene::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseReleaseEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsScene::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_3049_0.can_issue()) {
      cb_mouseReleaseEvent_3049_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsScene_Adaptor::cbs_mouseReleaseEvent_3049_0, event);
    } else {
      QGraphicsScene::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QGraphicsScene::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsScene_Adaptor, QTimerEvent *>(&QGraphicsScene_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QGraphicsScene::timerEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::wheelEvent(QGraphicsSceneWheelEvent *event)
  void cbs_wheelEvent_3029_0(QGraphicsSceneWheelEvent *event)
  {
    QGraphicsScene::wheelEvent(event);
  }

  virtual void wheelEvent(QGraphicsSceneWheelEvent *event)
  {
    if (cb_wheelEvent_3029_0.can_issue()) {
      cb_wheelEvent_3029_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneWheelEvent *>(&QGraphicsScene_Adaptor::cbs_wheelEvent_3029_0, event);
    } else {
      QGraphicsScene::wheelEvent(event);
    }
  }

  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_contextMenuEvent_3674_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_dragEnterEvent_3315_0;
  gsi::Callback cb_dragLeaveEvent_3315_0;
  gsi::Callback cb_dragMoveEvent_3315_0;
  gsi::Callback cb_drawBackground_3180_0;
  gsi::Callback cb_drawForeground_3180_0;
  gsi::Callback cb_dropEvent_3315_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_helpEvent_2921_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_mouseDoubleClickEvent_3049_0;
  gsi::Callback cb_mouseMoveEvent_3049_0;
  gsi::Callback cb_mousePressEvent_3049_0;
  gsi::Callback cb_mouseReleaseEvent_3049_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_3029_0;
};

QGraphicsScene_Adaptor::~QGraphicsScene_Adaptor() { }

//  Constructor QGraphicsScene::QGraphicsScene(QObject *parent) (adaptor class)

static void _init_ctor_QGraphicsScene_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QGraphicsScene_Adaptor> ();
}

static void _call_ctor_QGraphicsScene_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QGraphicsScene_Adaptor *> (new QGraphicsScene_Adaptor (arg1));
}


//  Constructor QGraphicsScene::QGraphicsScene(const QRectF &sceneRect, QObject *parent) (adaptor class)

static void _init_ctor_QGraphicsScene_Adaptor_3056 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sceneRect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QGraphicsScene_Adaptor> ();
}

static void _call_ctor_QGraphicsScene_Adaptor_3056 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QGraphicsScene_Adaptor *> (new QGraphicsScene_Adaptor (arg1, arg2));
}


//  Constructor QGraphicsScene::QGraphicsScene(double x, double y, double width, double height, QObject *parent) (adaptor class)

static void _init_ctor_QGraphicsScene_Adaptor_5154 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("width");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("height");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_4);
  decl->set_return_new<QGraphicsScene_Adaptor> ();
}

static void _call_ctor_QGraphicsScene_Adaptor_5154 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  QObject *arg5 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QGraphicsScene_Adaptor *> (new QGraphicsScene_Adaptor (arg1, arg2, arg3, arg4, arg5));
}


// emitter void QGraphicsScene::changed(const QList<QRectF> &region)

static void _init_emitter_changed_2477 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("region");
  decl->add_arg<const QList<QRectF> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_changed_2477 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QRectF> &arg1 = gsi::arg_reader<const QList<QRectF> & >() (args, heap);
  ((QGraphicsScene_Adaptor *)cls)->emitter_QGraphicsScene_changed_2477 (arg1);
}


// void QGraphicsScene::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QGraphicsScene::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_3674_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_3674_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneContextMenuEvent *arg1 = args.read<QGraphicsSceneContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_contextMenuEvent_3674_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_3674_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_contextMenuEvent_3674_0 = cb;
}


// void QGraphicsScene::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QGraphicsScene::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QGraphicsScene_Adaptor *)cls)->emitter_QGraphicsScene_destroyed_1302 (arg1);
}


// void QGraphicsScene::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QGraphicsScene::dragEnterEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragEnterEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_dragEnterEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_dragEnterEvent_3315_0 = cb;
}


// void QGraphicsScene::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragLeaveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_dragLeaveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_dragLeaveEvent_3315_0 = cb;
}


// void QGraphicsScene::dragMoveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragMoveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_dragMoveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_dragMoveEvent_3315_0 = cb;
}


// void QGraphicsScene::drawBackground(QPainter *painter, const QRectF &rect)

static void _init_cbs_drawBackground_3180_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_drawBackground_3180_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QRectF &arg2 = args.read<const QRectF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_drawBackground_3180_0 (arg1, arg2);
}

static void _set_callback_cbs_drawBackground_3180_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_drawBackground_3180_0 = cb;
}


// void QGraphicsScene::drawForeground(QPainter *painter, const QRectF &rect)

static void _init_cbs_drawForeground_3180_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_drawForeground_3180_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QRectF &arg2 = args.read<const QRectF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_drawForeground_3180_0 (arg1, arg2);
}

static void _set_callback_cbs_drawForeground_3180_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_drawForeground_3180_0 = cb;
}


// void QGraphicsScene::dropEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dropEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_dropEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dropEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_dropEvent_3315_0 = cb;
}


// bool QGraphicsScene::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsScene_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QGraphicsScene::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsScene_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QGraphicsScene::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// emitter void QGraphicsScene::focusItemChanged(QGraphicsItem *newFocus, QGraphicsItem *oldFocus, Qt::FocusReason reason)

static void _init_emitter_focusItemChanged_5499 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newFocus");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldFocus");
  decl->add_arg<QGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("reason");
  decl->add_arg<const qt_gsi::Converter<Qt::FocusReason>::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_focusItemChanged_5499 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = gsi::arg_reader<QGraphicsItem * >() (args, heap);
  QGraphicsItem *arg2 = gsi::arg_reader<QGraphicsItem * >() (args, heap);
  const qt_gsi::Converter<Qt::FocusReason>::target_type & arg3 = gsi::arg_reader<const qt_gsi::Converter<Qt::FocusReason>::target_type & >() (args, heap);
  ((QGraphicsScene_Adaptor *)cls)->emitter_QGraphicsScene_focusItemChanged_5499 (arg1, arg2, arg3);
}


// bool QGraphicsScene::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QGraphicsScene_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QGraphicsScene::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// void QGraphicsScene::helpEvent(QGraphicsSceneHelpEvent *event)

static void _init_cbs_helpEvent_2921_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHelpEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_helpEvent_2921_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneHelpEvent *arg1 = args.read<QGraphicsSceneHelpEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_helpEvent_2921_0 (arg1);
}

static void _set_callback_cbs_helpEvent_2921_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_helpEvent_2921_0 = cb;
}


// void QGraphicsScene::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QGraphicsScene::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QGraphicsScene_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// exposed bool QGraphicsScene::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsScene_Adaptor *)cls)->fp_QGraphicsScene_isSignalConnected_c2394 (arg1));
}


// void QGraphicsScene::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QGraphicsScene::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QGraphicsScene::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_mouseDoubleClickEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_mouseDoubleClickEvent_3049_0 = cb;
}


// void QGraphicsScene::mouseMoveEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseMoveEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_mouseMoveEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_mouseMoveEvent_3049_0 = cb;
}


// void QGraphicsScene::mousePressEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mousePressEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_mousePressEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_mousePressEvent_3049_0 = cb;
}


// void QGraphicsScene::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_mouseReleaseEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_mouseReleaseEvent_3049_0 = cb;
}


// emitter void QGraphicsScene::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QGraphicsScene_Adaptor *)cls)->emitter_QGraphicsScene_objectNameChanged_4567 (arg1);
}


// exposed int QGraphicsScene::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QGraphicsScene_Adaptor *)cls)->fp_QGraphicsScene_receivers_c1731 (arg1));
}


// emitter void QGraphicsScene::sceneRectChanged(const QRectF &rect)

static void _init_emitter_sceneRectChanged_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_sceneRectChanged_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ((QGraphicsScene_Adaptor *)cls)->emitter_QGraphicsScene_sceneRectChanged_1862 (arg1);
}


// emitter void QGraphicsScene::selectionChanged()

static void _init_emitter_selectionChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_selectionChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsScene_Adaptor *)cls)->emitter_QGraphicsScene_selectionChanged_0 ();
}


// exposed QObject *QGraphicsScene::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QGraphicsScene_Adaptor *)cls)->fp_QGraphicsScene_sender_c0 ());
}


// exposed int QGraphicsScene::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsScene_Adaptor *)cls)->fp_QGraphicsScene_senderSignalIndex_c0 ());
}


// void QGraphicsScene::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QGraphicsScene::wheelEvent(QGraphicsSceneWheelEvent *event)

static void _init_cbs_wheelEvent_3029_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_3029_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneWheelEvent *arg1 = args.read<QGraphicsSceneWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsScene_Adaptor *)cls)->cbs_wheelEvent_3029_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_3029_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_wheelEvent_3029_0 = cb;
}


namespace gsi
{

gsi::Class<QGraphicsScene> &qtdecl_QGraphicsScene ();

static gsi::Methods methods_QGraphicsScene_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsScene::QGraphicsScene(QObject *parent)\nThis method creates an object of class QGraphicsScene.", &_init_ctor_QGraphicsScene_Adaptor_1302, &_call_ctor_QGraphicsScene_Adaptor_1302);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsScene::QGraphicsScene(const QRectF &sceneRect, QObject *parent)\nThis method creates an object of class QGraphicsScene.", &_init_ctor_QGraphicsScene_Adaptor_3056, &_call_ctor_QGraphicsScene_Adaptor_3056);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsScene::QGraphicsScene(double x, double y, double width, double height, QObject *parent)\nThis method creates an object of class QGraphicsScene.", &_init_ctor_QGraphicsScene_Adaptor_5154, &_call_ctor_QGraphicsScene_Adaptor_5154);
  methods += new qt_gsi::GenericMethod ("emit_changed", "@brief Emitter for signal void QGraphicsScene::changed(const QList<QRectF> &region)\nCall this method to emit this signal.", false, &_init_emitter_changed_2477, &_call_emitter_changed_2477);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsScene::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QGraphicsScene::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0, &_set_callback_cbs_contextMenuEvent_3674_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsScene::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QGraphicsScene::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsScene::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QGraphicsScene::dragEnterEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0, &_set_callback_cbs_dragEnterEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QGraphicsScene::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0, &_set_callback_cbs_dragLeaveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QGraphicsScene::dragMoveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0, &_set_callback_cbs_dragMoveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*drawBackground", "@brief Virtual method void QGraphicsScene::drawBackground(QPainter *painter, const QRectF &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawBackground_3180_0, &_call_cbs_drawBackground_3180_0);
  methods += new qt_gsi::GenericMethod ("*drawBackground", "@hide", false, &_init_cbs_drawBackground_3180_0, &_call_cbs_drawBackground_3180_0, &_set_callback_cbs_drawBackground_3180_0);
  methods += new qt_gsi::GenericMethod ("*drawForeground", "@brief Virtual method void QGraphicsScene::drawForeground(QPainter *painter, const QRectF &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawForeground_3180_0, &_call_cbs_drawForeground_3180_0);
  methods += new qt_gsi::GenericMethod ("*drawForeground", "@hide", false, &_init_cbs_drawForeground_3180_0, &_call_cbs_drawForeground_3180_0, &_set_callback_cbs_drawForeground_3180_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QGraphicsScene::dropEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0, &_set_callback_cbs_dropEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QGraphicsScene::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QGraphicsScene::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QGraphicsScene::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("emit_focusItemChanged", "@brief Emitter for signal void QGraphicsScene::focusItemChanged(QGraphicsItem *newFocus, QGraphicsItem *oldFocus, Qt::FocusReason reason)\nCall this method to emit this signal.", false, &_init_emitter_focusItemChanged_5499, &_call_emitter_focusItemChanged_5499);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QGraphicsScene::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QGraphicsScene::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*helpEvent", "@brief Virtual method void QGraphicsScene::helpEvent(QGraphicsSceneHelpEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_helpEvent_2921_0, &_call_cbs_helpEvent_2921_0);
  methods += new qt_gsi::GenericMethod ("*helpEvent", "@hide", false, &_init_cbs_helpEvent_2921_0, &_call_cbs_helpEvent_2921_0, &_set_callback_cbs_helpEvent_2921_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QGraphicsScene::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QGraphicsScene::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QGraphicsScene::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QGraphicsScene::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QGraphicsScene::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QGraphicsScene::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0, &_set_callback_cbs_mouseDoubleClickEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QGraphicsScene::mouseMoveEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0, &_set_callback_cbs_mouseMoveEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QGraphicsScene::mousePressEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0, &_set_callback_cbs_mousePressEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QGraphicsScene::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0, &_set_callback_cbs_mouseReleaseEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QGraphicsScene::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QGraphicsScene::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("emit_sceneRectChanged", "@brief Emitter for signal void QGraphicsScene::sceneRectChanged(const QRectF &rect)\nCall this method to emit this signal.", false, &_init_emitter_sceneRectChanged_1862, &_call_emitter_sceneRectChanged_1862);
  methods += new qt_gsi::GenericMethod ("emit_selectionChanged", "@brief Emitter for signal void QGraphicsScene::selectionChanged()\nCall this method to emit this signal.", false, &_init_emitter_selectionChanged_0, &_call_emitter_selectionChanged_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QGraphicsScene::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QGraphicsScene::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsScene::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QGraphicsScene::wheelEvent(QGraphicsSceneWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0, &_set_callback_cbs_wheelEvent_3029_0);
  return methods;
}

gsi::Class<QGraphicsScene_Adaptor> decl_QGraphicsScene_Adaptor (qtdecl_QGraphicsScene (), "QtWidgets", "QGraphicsScene",
  methods_QGraphicsScene_Adaptor (),
  "@qt\n@brief Binding of QGraphicsScene");

}


//  Implementation of the enum wrapper class for QGraphicsScene::ItemIndexMethod
namespace qt_gsi
{

static gsi::Enum<QGraphicsScene::ItemIndexMethod> decl_QGraphicsScene_ItemIndexMethod_Enum ("QtWidgets", "QGraphicsScene_ItemIndexMethod",
    gsi::enum_const ("BspTreeIndex", QGraphicsScene::BspTreeIndex, "@brief Enum constant QGraphicsScene::BspTreeIndex") +
    gsi::enum_const ("NoIndex", QGraphicsScene::NoIndex, "@brief Enum constant QGraphicsScene::NoIndex"),
  "@qt\n@brief This class represents the QGraphicsScene::ItemIndexMethod enum");

static gsi::QFlagsClass<QGraphicsScene::ItemIndexMethod > decl_QGraphicsScene_ItemIndexMethod_Enums ("QtWidgets", "QGraphicsScene_QFlags_ItemIndexMethod",
  "@qt\n@brief This class represents the QFlags<QGraphicsScene::ItemIndexMethod> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsScene> inject_QGraphicsScene_ItemIndexMethod_Enum_in_parent (decl_QGraphicsScene_ItemIndexMethod_Enum.defs ());
static gsi::ClassExt<QGraphicsScene> decl_QGraphicsScene_ItemIndexMethod_Enum_as_child (decl_QGraphicsScene_ItemIndexMethod_Enum, "ItemIndexMethod");
static gsi::ClassExt<QGraphicsScene> decl_QGraphicsScene_ItemIndexMethod_Enums_as_child (decl_QGraphicsScene_ItemIndexMethod_Enums, "QFlags_ItemIndexMethod");

}


//  Implementation of the enum wrapper class for QGraphicsScene::SceneLayer
namespace qt_gsi
{

static gsi::Enum<QGraphicsScene::SceneLayer> decl_QGraphicsScene_SceneLayer_Enum ("QtWidgets", "QGraphicsScene_SceneLayer",
    gsi::enum_const ("ItemLayer", QGraphicsScene::ItemLayer, "@brief Enum constant QGraphicsScene::ItemLayer") +
    gsi::enum_const ("BackgroundLayer", QGraphicsScene::BackgroundLayer, "@brief Enum constant QGraphicsScene::BackgroundLayer") +
    gsi::enum_const ("ForegroundLayer", QGraphicsScene::ForegroundLayer, "@brief Enum constant QGraphicsScene::ForegroundLayer") +
    gsi::enum_const ("AllLayers", QGraphicsScene::AllLayers, "@brief Enum constant QGraphicsScene::AllLayers"),
  "@qt\n@brief This class represents the QGraphicsScene::SceneLayer enum");

static gsi::QFlagsClass<QGraphicsScene::SceneLayer > decl_QGraphicsScene_SceneLayer_Enums ("QtWidgets", "QGraphicsScene_QFlags_SceneLayer",
  "@qt\n@brief This class represents the QFlags<QGraphicsScene::SceneLayer> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsScene> inject_QGraphicsScene_SceneLayer_Enum_in_parent (decl_QGraphicsScene_SceneLayer_Enum.defs ());
static gsi::ClassExt<QGraphicsScene> decl_QGraphicsScene_SceneLayer_Enum_as_child (decl_QGraphicsScene_SceneLayer_Enum, "SceneLayer");
static gsi::ClassExt<QGraphicsScene> decl_QGraphicsScene_SceneLayer_Enums_as_child (decl_QGraphicsScene_SceneLayer_Enums, "QFlags_SceneLayer");

}

