
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMediaFormat.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMediaFormat>
#include <QMimeType>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMediaFormat

//  Constructor QMediaFormat::QMediaFormat(QMediaFormat::FileFormat format)


static void _init_ctor_QMediaFormat_2731 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format", true, "QMediaFormat::UnspecifiedFormat");
  decl->add_arg<const qt_gsi::Converter<QMediaFormat::FileFormat>::target_type & > (argspec_0);
  decl->set_return_new<QMediaFormat> ();
}

static void _call_ctor_QMediaFormat_2731 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaFormat::FileFormat>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<QMediaFormat::FileFormat>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QMediaFormat::FileFormat>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QMediaFormat::FileFormat>(heap, QMediaFormat::UnspecifiedFormat), heap);
  ret.write<QMediaFormat *> (new QMediaFormat (qt_gsi::QtToCppAdaptor<QMediaFormat::FileFormat>(arg1).cref()));
}


//  Constructor QMediaFormat::QMediaFormat(const QMediaFormat &other)


static void _init_ctor_QMediaFormat_2491 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QMediaFormat & > (argspec_0);
  decl->set_return_new<QMediaFormat> ();
}

static void _call_ctor_QMediaFormat_2491 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaFormat &arg1 = gsi::arg_reader<const QMediaFormat & >() (args, heap);
  ret.write<QMediaFormat *> (new QMediaFormat (arg1));
}


// QMediaFormat::AudioCodec QMediaFormat::audioCodec()


static void _init_f_audioCodec_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaFormat::AudioCodec>::target_type > ();
}

static void _call_f_audioCodec_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaFormat::AudioCodec>::target_type > ((qt_gsi::Converter<QMediaFormat::AudioCodec>::target_type)qt_gsi::CppToQtAdaptor<QMediaFormat::AudioCodec>(((QMediaFormat *)cls)->audioCodec ()));
}


// QMediaFormat::FileFormat QMediaFormat::fileFormat()


static void _init_f_fileFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaFormat::FileFormat>::target_type > ();
}

static void _call_f_fileFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaFormat::FileFormat>::target_type > ((qt_gsi::Converter<QMediaFormat::FileFormat>::target_type)qt_gsi::CppToQtAdaptor<QMediaFormat::FileFormat>(((QMediaFormat *)cls)->fileFormat ()));
}


// bool QMediaFormat::isSupported(QMediaFormat::ConversionMode mode)


static void _init_f_isSupported_c3181 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QMediaFormat::ConversionMode>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isSupported_c3181 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaFormat::ConversionMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaFormat::ConversionMode>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QMediaFormat *)cls)->isSupported (qt_gsi::QtToCppAdaptor<QMediaFormat::ConversionMode>(arg1).cref()));
}


// QMimeType QMediaFormat::mimeType()


static void _init_f_mimeType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMimeType > ();
}

static void _call_f_mimeType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMimeType > ((QMimeType)((QMediaFormat *)cls)->mimeType ());
}


// bool QMediaFormat::operator!=(const QMediaFormat &other)


static void _init_f_operator_excl__eq__c2491 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QMediaFormat & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2491 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaFormat &arg1 = gsi::arg_reader<const QMediaFormat & >() (args, heap);
  ret.write<bool > ((bool)((QMediaFormat *)cls)->operator!= (arg1));
}


// QMediaFormat &QMediaFormat::operator=(const QMediaFormat &other)


static void _init_f_operator_eq__2491 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QMediaFormat & > (argspec_0);
  decl->set_return<QMediaFormat & > ();
}

static void _call_f_operator_eq__2491 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaFormat &arg1 = gsi::arg_reader<const QMediaFormat & >() (args, heap);
  ret.write<QMediaFormat & > ((QMediaFormat &)((QMediaFormat *)cls)->operator= (arg1));
}


// bool QMediaFormat::operator==(const QMediaFormat &other)


static void _init_f_operator_eq__eq__c2491 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QMediaFormat & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2491 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaFormat &arg1 = gsi::arg_reader<const QMediaFormat & >() (args, heap);
  ret.write<bool > ((bool)((QMediaFormat *)cls)->operator== (arg1));
}


// void QMediaFormat::resolveForEncoding(QMediaFormat::ResolveFlags flags)


static void _init_f_resolveForEncoding_2959 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<const qt_gsi::Converter<QMediaFormat::ResolveFlags>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_resolveForEncoding_2959 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaFormat::ResolveFlags>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaFormat::ResolveFlags>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaFormat *)cls)->resolveForEncoding (qt_gsi::QtToCppAdaptor<QMediaFormat::ResolveFlags>(arg1).cref());
}


// void QMediaFormat::setAudioCodec(QMediaFormat::AudioCodec codec)


static void _init_f_setAudioCodec_2706 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("codec");
  decl->add_arg<const qt_gsi::Converter<QMediaFormat::AudioCodec>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAudioCodec_2706 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaFormat::AudioCodec>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaFormat::AudioCodec>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaFormat *)cls)->setAudioCodec (qt_gsi::QtToCppAdaptor<QMediaFormat::AudioCodec>(arg1).cref());
}


// void QMediaFormat::setFileFormat(QMediaFormat::FileFormat f)


static void _init_f_setFileFormat_2731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f");
  decl->add_arg<const qt_gsi::Converter<QMediaFormat::FileFormat>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFileFormat_2731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaFormat::FileFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaFormat::FileFormat>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaFormat *)cls)->setFileFormat (qt_gsi::QtToCppAdaptor<QMediaFormat::FileFormat>(arg1).cref());
}


// void QMediaFormat::setVideoCodec(QMediaFormat::VideoCodec codec)


static void _init_f_setVideoCodec_2711 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("codec");
  decl->add_arg<const qt_gsi::Converter<QMediaFormat::VideoCodec>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVideoCodec_2711 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaFormat::VideoCodec>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaFormat::VideoCodec>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaFormat *)cls)->setVideoCodec (qt_gsi::QtToCppAdaptor<QMediaFormat::VideoCodec>(arg1).cref());
}


// QList<QMediaFormat::AudioCodec> QMediaFormat::supportedAudioCodecs(QMediaFormat::ConversionMode m)


static void _init_f_supportedAudioCodecs_3181 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("m");
  decl->add_arg<const qt_gsi::Converter<QMediaFormat::ConversionMode>::target_type & > (argspec_0);
  decl->set_return<QList<QMediaFormat::AudioCodec> > ();
}

static void _call_f_supportedAudioCodecs_3181 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaFormat::ConversionMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaFormat::ConversionMode>::target_type & >() (args, heap);
  ret.write<QList<QMediaFormat::AudioCodec> > ((QList<QMediaFormat::AudioCodec>)((QMediaFormat *)cls)->supportedAudioCodecs (qt_gsi::QtToCppAdaptor<QMediaFormat::ConversionMode>(arg1).cref()));
}


// QList<QMediaFormat::FileFormat> QMediaFormat::supportedFileFormats(QMediaFormat::ConversionMode m)


static void _init_f_supportedFileFormats_3181 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("m");
  decl->add_arg<const qt_gsi::Converter<QMediaFormat::ConversionMode>::target_type & > (argspec_0);
  decl->set_return<QList<QMediaFormat::FileFormat> > ();
}

static void _call_f_supportedFileFormats_3181 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaFormat::ConversionMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaFormat::ConversionMode>::target_type & >() (args, heap);
  ret.write<QList<QMediaFormat::FileFormat> > ((QList<QMediaFormat::FileFormat>)((QMediaFormat *)cls)->supportedFileFormats (qt_gsi::QtToCppAdaptor<QMediaFormat::ConversionMode>(arg1).cref()));
}


// QList<QMediaFormat::VideoCodec> QMediaFormat::supportedVideoCodecs(QMediaFormat::ConversionMode m)


static void _init_f_supportedVideoCodecs_3181 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("m");
  decl->add_arg<const qt_gsi::Converter<QMediaFormat::ConversionMode>::target_type & > (argspec_0);
  decl->set_return<QList<QMediaFormat::VideoCodec> > ();
}

static void _call_f_supportedVideoCodecs_3181 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaFormat::ConversionMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaFormat::ConversionMode>::target_type & >() (args, heap);
  ret.write<QList<QMediaFormat::VideoCodec> > ((QList<QMediaFormat::VideoCodec>)((QMediaFormat *)cls)->supportedVideoCodecs (qt_gsi::QtToCppAdaptor<QMediaFormat::ConversionMode>(arg1).cref()));
}


// void QMediaFormat::swap(QMediaFormat &other)


static void _init_f_swap_1796 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<QMediaFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_swap_1796 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMediaFormat &arg1 = gsi::arg_reader<QMediaFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaFormat *)cls)->swap (arg1);
}


// QMediaFormat::VideoCodec QMediaFormat::videoCodec()


static void _init_f_videoCodec_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaFormat::VideoCodec>::target_type > ();
}

static void _call_f_videoCodec_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaFormat::VideoCodec>::target_type > ((qt_gsi::Converter<QMediaFormat::VideoCodec>::target_type)qt_gsi::CppToQtAdaptor<QMediaFormat::VideoCodec>(((QMediaFormat *)cls)->videoCodec ()));
}


// static QString QMediaFormat::audioCodecDescription(QMediaFormat::AudioCodec codec)


static void _init_f_audioCodecDescription_2706 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("codec");
  decl->add_arg<const qt_gsi::Converter<QMediaFormat::AudioCodec>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_audioCodecDescription_2706 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaFormat::AudioCodec>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaFormat::AudioCodec>::target_type & >() (args, heap);
  ret.write<QString > ((QString)QMediaFormat::audioCodecDescription (qt_gsi::QtToCppAdaptor<QMediaFormat::AudioCodec>(arg1).cref()));
}


// static QString QMediaFormat::audioCodecName(QMediaFormat::AudioCodec codec)


static void _init_f_audioCodecName_2706 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("codec");
  decl->add_arg<const qt_gsi::Converter<QMediaFormat::AudioCodec>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_audioCodecName_2706 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaFormat::AudioCodec>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaFormat::AudioCodec>::target_type & >() (args, heap);
  ret.write<QString > ((QString)QMediaFormat::audioCodecName (qt_gsi::QtToCppAdaptor<QMediaFormat::AudioCodec>(arg1).cref()));
}


// static QString QMediaFormat::fileFormatDescription(QMediaFormat::FileFormat fileFormat)


static void _init_f_fileFormatDescription_2731 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileFormat");
  decl->add_arg<const qt_gsi::Converter<QMediaFormat::FileFormat>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_fileFormatDescription_2731 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaFormat::FileFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaFormat::FileFormat>::target_type & >() (args, heap);
  ret.write<QString > ((QString)QMediaFormat::fileFormatDescription (qt_gsi::QtToCppAdaptor<QMediaFormat::FileFormat>(arg1).cref()));
}


// static QString QMediaFormat::fileFormatName(QMediaFormat::FileFormat fileFormat)


static void _init_f_fileFormatName_2731 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileFormat");
  decl->add_arg<const qt_gsi::Converter<QMediaFormat::FileFormat>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_fileFormatName_2731 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaFormat::FileFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaFormat::FileFormat>::target_type & >() (args, heap);
  ret.write<QString > ((QString)QMediaFormat::fileFormatName (qt_gsi::QtToCppAdaptor<QMediaFormat::FileFormat>(arg1).cref()));
}


// static QString QMediaFormat::videoCodecDescription(QMediaFormat::VideoCodec codec)


static void _init_f_videoCodecDescription_2711 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("codec");
  decl->add_arg<const qt_gsi::Converter<QMediaFormat::VideoCodec>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_videoCodecDescription_2711 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaFormat::VideoCodec>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaFormat::VideoCodec>::target_type & >() (args, heap);
  ret.write<QString > ((QString)QMediaFormat::videoCodecDescription (qt_gsi::QtToCppAdaptor<QMediaFormat::VideoCodec>(arg1).cref()));
}


// static QString QMediaFormat::videoCodecName(QMediaFormat::VideoCodec codec)


static void _init_f_videoCodecName_2711 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("codec");
  decl->add_arg<const qt_gsi::Converter<QMediaFormat::VideoCodec>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_videoCodecName_2711 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaFormat::VideoCodec>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaFormat::VideoCodec>::target_type & >() (args, heap);
  ret.write<QString > ((QString)QMediaFormat::videoCodecName (qt_gsi::QtToCppAdaptor<QMediaFormat::VideoCodec>(arg1).cref()));
}



namespace gsi
{

static gsi::Methods methods_QMediaFormat () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMediaFormat::QMediaFormat(QMediaFormat::FileFormat format)\nThis method creates an object of class QMediaFormat.", &_init_ctor_QMediaFormat_2731, &_call_ctor_QMediaFormat_2731);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMediaFormat::QMediaFormat(const QMediaFormat &other)\nThis method creates an object of class QMediaFormat.", &_init_ctor_QMediaFormat_2491, &_call_ctor_QMediaFormat_2491);
  methods += new qt_gsi::GenericMethod (":audioCodec", "@brief Method QMediaFormat::AudioCodec QMediaFormat::audioCodec()\n", true, &_init_f_audioCodec_c0, &_call_f_audioCodec_c0);
  methods += new qt_gsi::GenericMethod (":fileFormat", "@brief Method QMediaFormat::FileFormat QMediaFormat::fileFormat()\n", true, &_init_f_fileFormat_c0, &_call_f_fileFormat_c0);
  methods += new qt_gsi::GenericMethod ("isSupported?", "@brief Method bool QMediaFormat::isSupported(QMediaFormat::ConversionMode mode)\n", true, &_init_f_isSupported_c3181, &_call_f_isSupported_c3181);
  methods += new qt_gsi::GenericMethod ("mimeType", "@brief Method QMimeType QMediaFormat::mimeType()\n", true, &_init_f_mimeType_c0, &_call_f_mimeType_c0);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QMediaFormat::operator!=(const QMediaFormat &other)\n", true, &_init_f_operator_excl__eq__c2491, &_call_f_operator_excl__eq__c2491);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QMediaFormat &QMediaFormat::operator=(const QMediaFormat &other)\n", false, &_init_f_operator_eq__2491, &_call_f_operator_eq__2491);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QMediaFormat::operator==(const QMediaFormat &other)\n", true, &_init_f_operator_eq__eq__c2491, &_call_f_operator_eq__eq__c2491);
  methods += new qt_gsi::GenericMethod ("resolveForEncoding", "@brief Method void QMediaFormat::resolveForEncoding(QMediaFormat::ResolveFlags flags)\n", false, &_init_f_resolveForEncoding_2959, &_call_f_resolveForEncoding_2959);
  methods += new qt_gsi::GenericMethod ("setAudioCodec|audioCodec=", "@brief Method void QMediaFormat::setAudioCodec(QMediaFormat::AudioCodec codec)\n", false, &_init_f_setAudioCodec_2706, &_call_f_setAudioCodec_2706);
  methods += new qt_gsi::GenericMethod ("setFileFormat|fileFormat=", "@brief Method void QMediaFormat::setFileFormat(QMediaFormat::FileFormat f)\n", false, &_init_f_setFileFormat_2731, &_call_f_setFileFormat_2731);
  methods += new qt_gsi::GenericMethod ("setVideoCodec|videoCodec=", "@brief Method void QMediaFormat::setVideoCodec(QMediaFormat::VideoCodec codec)\n", false, &_init_f_setVideoCodec_2711, &_call_f_setVideoCodec_2711);
  methods += new qt_gsi::GenericMethod ("supportedAudioCodecs", "@brief Method QList<QMediaFormat::AudioCodec> QMediaFormat::supportedAudioCodecs(QMediaFormat::ConversionMode m)\n", false, &_init_f_supportedAudioCodecs_3181, &_call_f_supportedAudioCodecs_3181);
  methods += new qt_gsi::GenericMethod ("supportedFileFormats", "@brief Method QList<QMediaFormat::FileFormat> QMediaFormat::supportedFileFormats(QMediaFormat::ConversionMode m)\n", false, &_init_f_supportedFileFormats_3181, &_call_f_supportedFileFormats_3181);
  methods += new qt_gsi::GenericMethod ("supportedVideoCodecs", "@brief Method QList<QMediaFormat::VideoCodec> QMediaFormat::supportedVideoCodecs(QMediaFormat::ConversionMode m)\n", false, &_init_f_supportedVideoCodecs_3181, &_call_f_supportedVideoCodecs_3181);
  methods += new qt_gsi::GenericMethod ("swap", "@brief Method void QMediaFormat::swap(QMediaFormat &other)\n", false, &_init_f_swap_1796, &_call_f_swap_1796);
  methods += new qt_gsi::GenericMethod (":videoCodec", "@brief Method QMediaFormat::VideoCodec QMediaFormat::videoCodec()\n", true, &_init_f_videoCodec_c0, &_call_f_videoCodec_c0);
  methods += new qt_gsi::GenericStaticMethod ("audioCodecDescription", "@brief Static method QString QMediaFormat::audioCodecDescription(QMediaFormat::AudioCodec codec)\nThis method is static and can be called without an instance.", &_init_f_audioCodecDescription_2706, &_call_f_audioCodecDescription_2706);
  methods += new qt_gsi::GenericStaticMethod ("audioCodecName", "@brief Static method QString QMediaFormat::audioCodecName(QMediaFormat::AudioCodec codec)\nThis method is static and can be called without an instance.", &_init_f_audioCodecName_2706, &_call_f_audioCodecName_2706);
  methods += new qt_gsi::GenericStaticMethod ("fileFormatDescription", "@brief Static method QString QMediaFormat::fileFormatDescription(QMediaFormat::FileFormat fileFormat)\nThis method is static and can be called without an instance.", &_init_f_fileFormatDescription_2731, &_call_f_fileFormatDescription_2731);
  methods += new qt_gsi::GenericStaticMethod ("fileFormatName", "@brief Static method QString QMediaFormat::fileFormatName(QMediaFormat::FileFormat fileFormat)\nThis method is static and can be called without an instance.", &_init_f_fileFormatName_2731, &_call_f_fileFormatName_2731);
  methods += new qt_gsi::GenericStaticMethod ("videoCodecDescription", "@brief Static method QString QMediaFormat::videoCodecDescription(QMediaFormat::VideoCodec codec)\nThis method is static and can be called without an instance.", &_init_f_videoCodecDescription_2711, &_call_f_videoCodecDescription_2711);
  methods += new qt_gsi::GenericStaticMethod ("videoCodecName", "@brief Static method QString QMediaFormat::videoCodecName(QMediaFormat::VideoCodec codec)\nThis method is static and can be called without an instance.", &_init_f_videoCodecName_2711, &_call_f_videoCodecName_2711);
  return methods;
}

gsi::Class<QMediaFormat> decl_QMediaFormat ("QtMultimedia", "QMediaFormat",
  methods_QMediaFormat (),
  "@qt\n@brief Binding of QMediaFormat");


GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QMediaFormat> &qtdecl_QMediaFormat () { return decl_QMediaFormat; }

}


//  Implementation of the enum wrapper class for QMediaFormat::AudioCodec
namespace qt_gsi
{

static gsi::Enum<QMediaFormat::AudioCodec> decl_QMediaFormat_AudioCodec_Enum ("QtMultimedia", "QMediaFormat_AudioCodec",
    gsi::enum_const ("Unspecified", QMediaFormat::AudioCodec::Unspecified, "@brief Enum constant QMediaFormat::AudioCodec::Unspecified") +
    gsi::enum_const ("MP3", QMediaFormat::AudioCodec::MP3, "@brief Enum constant QMediaFormat::AudioCodec::MP3") +
    gsi::enum_const ("AAC", QMediaFormat::AudioCodec::AAC, "@brief Enum constant QMediaFormat::AudioCodec::AAC") +
    gsi::enum_const ("AC3", QMediaFormat::AudioCodec::AC3, "@brief Enum constant QMediaFormat::AudioCodec::AC3") +
    gsi::enum_const ("EAC3", QMediaFormat::AudioCodec::EAC3, "@brief Enum constant QMediaFormat::AudioCodec::EAC3") +
    gsi::enum_const ("FLAC", QMediaFormat::AudioCodec::FLAC, "@brief Enum constant QMediaFormat::AudioCodec::FLAC") +
    gsi::enum_const ("DolbyTrueHD", QMediaFormat::AudioCodec::DolbyTrueHD, "@brief Enum constant QMediaFormat::AudioCodec::DolbyTrueHD") +
    gsi::enum_const ("Opus", QMediaFormat::AudioCodec::Opus, "@brief Enum constant QMediaFormat::AudioCodec::Opus") +
    gsi::enum_const ("Vorbis", QMediaFormat::AudioCodec::Vorbis, "@brief Enum constant QMediaFormat::AudioCodec::Vorbis") +
    gsi::enum_const ("Wave", QMediaFormat::AudioCodec::Wave, "@brief Enum constant QMediaFormat::AudioCodec::Wave") +
    gsi::enum_const ("WMA", QMediaFormat::AudioCodec::WMA, "@brief Enum constant QMediaFormat::AudioCodec::WMA") +
    gsi::enum_const ("ALAC", QMediaFormat::AudioCodec::ALAC, "@brief Enum constant QMediaFormat::AudioCodec::ALAC") +
    gsi::enum_const ("LastAudioCodec", QMediaFormat::AudioCodec::LastAudioCodec, "@brief Enum constant QMediaFormat::AudioCodec::LastAudioCodec"),
  "@qt\n@brief This class represents the QMediaFormat::AudioCodec enum");

static gsi::QFlagsClass<QMediaFormat::AudioCodec > decl_QMediaFormat_AudioCodec_Enums ("QtMultimedia", "QMediaFormat_QFlags_AudioCodec",
  "@qt\n@brief This class represents the QFlags<QMediaFormat::AudioCodec> flag set");

static gsi::ClassExt<QMediaFormat> decl_QMediaFormat_AudioCodec_Enum_as_child (decl_QMediaFormat_AudioCodec_Enum, "AudioCodec");
static gsi::ClassExt<QMediaFormat> decl_QMediaFormat_AudioCodec_Enums_as_child (decl_QMediaFormat_AudioCodec_Enums, "QFlags_AudioCodec");

}


//  Implementation of the enum wrapper class for QMediaFormat::ConversionMode
namespace qt_gsi
{

static gsi::Enum<QMediaFormat::ConversionMode> decl_QMediaFormat_ConversionMode_Enum ("QtMultimedia", "QMediaFormat_ConversionMode",
    gsi::enum_const ("Encode", QMediaFormat::Encode, "@brief Enum constant QMediaFormat::Encode") +
    gsi::enum_const ("Decode", QMediaFormat::Decode, "@brief Enum constant QMediaFormat::Decode"),
  "@qt\n@brief This class represents the QMediaFormat::ConversionMode enum");

static gsi::QFlagsClass<QMediaFormat::ConversionMode > decl_QMediaFormat_ConversionMode_Enums ("QtMultimedia", "QMediaFormat_QFlags_ConversionMode",
  "@qt\n@brief This class represents the QFlags<QMediaFormat::ConversionMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaFormat> inject_QMediaFormat_ConversionMode_Enum_in_parent (decl_QMediaFormat_ConversionMode_Enum.defs ());
static gsi::ClassExt<QMediaFormat> decl_QMediaFormat_ConversionMode_Enum_as_child (decl_QMediaFormat_ConversionMode_Enum, "ConversionMode");
static gsi::ClassExt<QMediaFormat> decl_QMediaFormat_ConversionMode_Enums_as_child (decl_QMediaFormat_ConversionMode_Enums, "QFlags_ConversionMode");

}


//  Implementation of the enum wrapper class for QMediaFormat::FileFormat
namespace qt_gsi
{

static gsi::Enum<QMediaFormat::FileFormat> decl_QMediaFormat_FileFormat_Enum ("QtMultimedia", "QMediaFormat_FileFormat",
    gsi::enum_const ("UnspecifiedFormat", QMediaFormat::UnspecifiedFormat, "@brief Enum constant QMediaFormat::UnspecifiedFormat") +
    gsi::enum_const ("WMV", QMediaFormat::WMV, "@brief Enum constant QMediaFormat::WMV") +
    gsi::enum_const ("AVI", QMediaFormat::AVI, "@brief Enum constant QMediaFormat::AVI") +
    gsi::enum_const ("Matroska", QMediaFormat::Matroska, "@brief Enum constant QMediaFormat::Matroska") +
    gsi::enum_const ("MPEG4", QMediaFormat::MPEG4, "@brief Enum constant QMediaFormat::MPEG4") +
    gsi::enum_const ("Ogg", QMediaFormat::Ogg, "@brief Enum constant QMediaFormat::Ogg") +
    gsi::enum_const ("QuickTime", QMediaFormat::QuickTime, "@brief Enum constant QMediaFormat::QuickTime") +
    gsi::enum_const ("WebM", QMediaFormat::WebM, "@brief Enum constant QMediaFormat::WebM") +
    gsi::enum_const ("Mpeg4Audio", QMediaFormat::Mpeg4Audio, "@brief Enum constant QMediaFormat::Mpeg4Audio") +
    gsi::enum_const ("AAC", QMediaFormat::AAC, "@brief Enum constant QMediaFormat::AAC") +
    gsi::enum_const ("WMA", QMediaFormat::WMA, "@brief Enum constant QMediaFormat::WMA") +
    gsi::enum_const ("MP3", QMediaFormat::MP3, "@brief Enum constant QMediaFormat::MP3") +
    gsi::enum_const ("FLAC", QMediaFormat::FLAC, "@brief Enum constant QMediaFormat::FLAC") +
    gsi::enum_const ("Wave", QMediaFormat::Wave, "@brief Enum constant QMediaFormat::Wave") +
    gsi::enum_const ("LastFileFormat", QMediaFormat::LastFileFormat, "@brief Enum constant QMediaFormat::LastFileFormat"),
  "@qt\n@brief This class represents the QMediaFormat::FileFormat enum");

static gsi::QFlagsClass<QMediaFormat::FileFormat > decl_QMediaFormat_FileFormat_Enums ("QtMultimedia", "QMediaFormat_QFlags_FileFormat",
  "@qt\n@brief This class represents the QFlags<QMediaFormat::FileFormat> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaFormat> inject_QMediaFormat_FileFormat_Enum_in_parent (decl_QMediaFormat_FileFormat_Enum.defs ());
static gsi::ClassExt<QMediaFormat> decl_QMediaFormat_FileFormat_Enum_as_child (decl_QMediaFormat_FileFormat_Enum, "FileFormat");
static gsi::ClassExt<QMediaFormat> decl_QMediaFormat_FileFormat_Enums_as_child (decl_QMediaFormat_FileFormat_Enums, "QFlags_FileFormat");

}


//  Implementation of the enum wrapper class for QMediaFormat::ResolveFlags
namespace qt_gsi
{

static gsi::Enum<QMediaFormat::ResolveFlags> decl_QMediaFormat_ResolveFlags_Enum ("QtMultimedia", "QMediaFormat_ResolveFlags",
    gsi::enum_const ("NoFlags", QMediaFormat::NoFlags, "@brief Enum constant QMediaFormat::NoFlags") +
    gsi::enum_const ("RequiresVideo", QMediaFormat::RequiresVideo, "@brief Enum constant QMediaFormat::RequiresVideo"),
  "@qt\n@brief This class represents the QMediaFormat::ResolveFlags enum");

static gsi::QFlagsClass<QMediaFormat::ResolveFlags > decl_QMediaFormat_ResolveFlags_Enums ("QtMultimedia", "QMediaFormat_QFlags_ResolveFlags",
  "@qt\n@brief This class represents the QFlags<QMediaFormat::ResolveFlags> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaFormat> inject_QMediaFormat_ResolveFlags_Enum_in_parent (decl_QMediaFormat_ResolveFlags_Enum.defs ());
static gsi::ClassExt<QMediaFormat> decl_QMediaFormat_ResolveFlags_Enum_as_child (decl_QMediaFormat_ResolveFlags_Enum, "ResolveFlags");
static gsi::ClassExt<QMediaFormat> decl_QMediaFormat_ResolveFlags_Enums_as_child (decl_QMediaFormat_ResolveFlags_Enums, "QFlags_ResolveFlags");

}


//  Implementation of the enum wrapper class for QMediaFormat::VideoCodec
namespace qt_gsi
{

static gsi::Enum<QMediaFormat::VideoCodec> decl_QMediaFormat_VideoCodec_Enum ("QtMultimedia", "QMediaFormat_VideoCodec",
    gsi::enum_const ("Unspecified", QMediaFormat::VideoCodec::Unspecified, "@brief Enum constant QMediaFormat::VideoCodec::Unspecified") +
    gsi::enum_const ("MPEG1", QMediaFormat::VideoCodec::MPEG1, "@brief Enum constant QMediaFormat::VideoCodec::MPEG1") +
    gsi::enum_const ("MPEG2", QMediaFormat::VideoCodec::MPEG2, "@brief Enum constant QMediaFormat::VideoCodec::MPEG2") +
    gsi::enum_const ("MPEG4", QMediaFormat::VideoCodec::MPEG4, "@brief Enum constant QMediaFormat::VideoCodec::MPEG4") +
    gsi::enum_const ("H264", QMediaFormat::VideoCodec::H264, "@brief Enum constant QMediaFormat::VideoCodec::H264") +
    gsi::enum_const ("H265", QMediaFormat::VideoCodec::H265, "@brief Enum constant QMediaFormat::VideoCodec::H265") +
    gsi::enum_const ("VP8", QMediaFormat::VideoCodec::VP8, "@brief Enum constant QMediaFormat::VideoCodec::VP8") +
    gsi::enum_const ("VP9", QMediaFormat::VideoCodec::VP9, "@brief Enum constant QMediaFormat::VideoCodec::VP9") +
    gsi::enum_const ("AV1", QMediaFormat::VideoCodec::AV1, "@brief Enum constant QMediaFormat::VideoCodec::AV1") +
    gsi::enum_const ("Theora", QMediaFormat::VideoCodec::Theora, "@brief Enum constant QMediaFormat::VideoCodec::Theora") +
    gsi::enum_const ("WMV", QMediaFormat::VideoCodec::WMV, "@brief Enum constant QMediaFormat::VideoCodec::WMV") +
    gsi::enum_const ("MotionJPEG", QMediaFormat::VideoCodec::MotionJPEG, "@brief Enum constant QMediaFormat::VideoCodec::MotionJPEG") +
    gsi::enum_const ("LastVideoCodec", QMediaFormat::VideoCodec::LastVideoCodec, "@brief Enum constant QMediaFormat::VideoCodec::LastVideoCodec"),
  "@qt\n@brief This class represents the QMediaFormat::VideoCodec enum");

static gsi::QFlagsClass<QMediaFormat::VideoCodec > decl_QMediaFormat_VideoCodec_Enums ("QtMultimedia", "QMediaFormat_QFlags_VideoCodec",
  "@qt\n@brief This class represents the QFlags<QMediaFormat::VideoCodec> flag set");

static gsi::ClassExt<QMediaFormat> decl_QMediaFormat_VideoCodec_Enum_as_child (decl_QMediaFormat_VideoCodec_Enum, "VideoCodec");
static gsi::ClassExt<QMediaFormat> decl_QMediaFormat_VideoCodec_Enums_as_child (decl_QMediaFormat_VideoCodec_Enums, "QFlags_VideoCodec");

}

