
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTransposeProxyModel.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QTransposeProxyModel>
#include <QAbstractItemModel>
#include <QChildEvent>
#include <QDataStream>
#include <QEvent>
#include <QItemSelection>
#include <QMetaMethod>
#include <QMimeData>
#include <QModelIndex>
#include <QModelRoleDataSpan>
#include <QObject>
#include <QPersistentModelIndex>
#include <QSize>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTransposeProxyModel

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QTransposeProxyModel::staticMetaObject);
}


// int QTransposeProxyModel::columnCount(const QModelIndex &parent)


static void _init_f_columnCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_columnCount_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<int > ((int)((QTransposeProxyModel *)cls)->columnCount (arg1));
}


// QVariant QTransposeProxyModel::headerData(int section, Qt::Orientation orientation, int role)


static void _init_f_headerData_c3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_f_headerData_c3231 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::DisplayRole, heap);
  ret.write<QVariant > ((QVariant)((QTransposeProxyModel *)cls)->headerData (arg1, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg2).cref(), arg3));
}


// QModelIndex QTransposeProxyModel::index(int row, int column, const QModelIndex &parent)


static void _init_f_index_c3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_f_index_c3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<QModelIndex > ((QModelIndex)((QTransposeProxyModel *)cls)->index (arg1, arg2, arg3));
}


// bool QTransposeProxyModel::insertColumns(int column, int count, const QModelIndex &parent)


static void _init_f_insertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_insertColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QTransposeProxyModel *)cls)->insertColumns (arg1, arg2, arg3));
}


// bool QTransposeProxyModel::insertRows(int row, int count, const QModelIndex &parent)


static void _init_f_insertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_insertRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QTransposeProxyModel *)cls)->insertRows (arg1, arg2, arg3));
}


// QMap<int, QVariant> QTransposeProxyModel::itemData(const QModelIndex &index)


static void _init_f_itemData_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QMap<int, QVariant> > ();
}

static void _call_f_itemData_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QMap<int, QVariant> > ((QMap<int, QVariant>)((QTransposeProxyModel *)cls)->itemData (arg1));
}


// QModelIndex QTransposeProxyModel::mapFromSource(const QModelIndex &sourceIndex)


static void _init_f_mapFromSource_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_mapFromSource_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QTransposeProxyModel *)cls)->mapFromSource (arg1));
}


// QModelIndex QTransposeProxyModel::mapToSource(const QModelIndex &proxyIndex)


static void _init_f_mapToSource_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("proxyIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_mapToSource_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QTransposeProxyModel *)cls)->mapToSource (arg1));
}


// bool QTransposeProxyModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)


static void _init_f_moveColumns_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceColumn");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("count");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationChild");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_f_moveColumns_6659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QTransposeProxyModel *)cls)->moveColumns (arg1, arg2, arg3, arg4, arg5));
}


// bool QTransposeProxyModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)


static void _init_f_moveRows_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceRow");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("count");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationChild");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_f_moveRows_6659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QTransposeProxyModel *)cls)->moveRows (arg1, arg2, arg3, arg4, arg5));
}


// QModelIndex QTransposeProxyModel::parent(const QModelIndex &index)


static void _init_f_parent_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_parent_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QTransposeProxyModel *)cls)->parent (arg1));
}


// bool QTransposeProxyModel::removeColumns(int column, int count, const QModelIndex &parent)


static void _init_f_removeColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_removeColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QTransposeProxyModel *)cls)->removeColumns (arg1, arg2, arg3));
}


// bool QTransposeProxyModel::removeRows(int row, int count, const QModelIndex &parent)


static void _init_f_removeRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_removeRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QTransposeProxyModel *)cls)->removeRows (arg1, arg2, arg3));
}


// int QTransposeProxyModel::rowCount(const QModelIndex &parent)


static void _init_f_rowCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_rowCount_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<int > ((int)((QTransposeProxyModel *)cls)->rowCount (arg1));
}


// bool QTransposeProxyModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)


static void _init_f_setHeaderData_5242 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("role", true, "Qt::EditRole");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_setHeaderData_5242 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  const QVariant &arg3 = gsi::arg_reader<const QVariant & >() (args, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::EditRole, heap);
  ret.write<bool > ((bool)((QTransposeProxyModel *)cls)->setHeaderData (arg1, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg2).cref(), arg3, arg4));
}


// bool QTransposeProxyModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)


static void _init_f_setItemData_5414 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("roles");
  decl->add_arg<const QMap<int, QVariant> & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_setItemData_5414 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QMap<int, QVariant> &arg2 = gsi::arg_reader<const QMap<int, QVariant> & >() (args, heap);
  ret.write<bool > ((bool)((QTransposeProxyModel *)cls)->setItemData (arg1, arg2));
}


// void QTransposeProxyModel::setSourceModel(QAbstractItemModel *newSourceModel)


static void _init_f_setSourceModel_2419 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newSourceModel");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSourceModel_2419 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = gsi::arg_reader<QAbstractItemModel * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel *)cls)->setSourceModel (arg1);
}


// void QTransposeProxyModel::sort(int column, Qt::SortOrder order)


static void _init_f_sort_2340 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order", true, "Qt::AscendingOrder");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_sort_2340 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::SortOrder>(heap, Qt::AscendingOrder), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel *)cls)->sort (arg1, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg2).cref());
}


// QSize QTransposeProxyModel::span(const QModelIndex &index)


static void _init_f_span_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_f_span_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QSize > ((QSize)((QTransposeProxyModel *)cls)->span (arg1));
}


// static QString QTransposeProxyModel::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QTransposeProxyModel::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QTransposeProxyModel () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("columnCount", "@brief Method int QTransposeProxyModel::columnCount(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::columnCount", true, &_init_f_columnCount_c2395, &_call_f_columnCount_c2395);
  methods += new qt_gsi::GenericMethod ("headerData", "@brief Method QVariant QTransposeProxyModel::headerData(int section, Qt::Orientation orientation, int role)\nThis is a reimplementation of QAbstractProxyModel::headerData", true, &_init_f_headerData_c3231, &_call_f_headerData_c3231);
  methods += new qt_gsi::GenericMethod ("index", "@brief Method QModelIndex QTransposeProxyModel::index(int row, int column, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::index", true, &_init_f_index_c3713, &_call_f_index_c3713);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@brief Method bool QTransposeProxyModel::insertColumns(int column, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::insertColumns", false, &_init_f_insertColumns_3713, &_call_f_insertColumns_3713);
  methods += new qt_gsi::GenericMethod ("insertRows", "@brief Method bool QTransposeProxyModel::insertRows(int row, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::insertRows", false, &_init_f_insertRows_3713, &_call_f_insertRows_3713);
  methods += new qt_gsi::GenericMethod ("itemData", "@brief Method QMap<int, QVariant> QTransposeProxyModel::itemData(const QModelIndex &index)\nThis is a reimplementation of QAbstractProxyModel::itemData", true, &_init_f_itemData_c2395, &_call_f_itemData_c2395);
  methods += new qt_gsi::GenericMethod ("mapFromSource", "@brief Method QModelIndex QTransposeProxyModel::mapFromSource(const QModelIndex &sourceIndex)\nThis is a reimplementation of QAbstractProxyModel::mapFromSource", true, &_init_f_mapFromSource_c2395, &_call_f_mapFromSource_c2395);
  methods += new qt_gsi::GenericMethod ("mapToSource", "@brief Method QModelIndex QTransposeProxyModel::mapToSource(const QModelIndex &proxyIndex)\nThis is a reimplementation of QAbstractProxyModel::mapToSource", true, &_init_f_mapToSource_c2395, &_call_f_mapToSource_c2395);
  methods += new qt_gsi::GenericMethod ("moveColumns", "@brief Method bool QTransposeProxyModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)\nThis is a reimplementation of QAbstractItemModel::moveColumns", false, &_init_f_moveColumns_6659, &_call_f_moveColumns_6659);
  methods += new qt_gsi::GenericMethod ("moveRows", "@brief Method bool QTransposeProxyModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)\nThis is a reimplementation of QAbstractItemModel::moveRows", false, &_init_f_moveRows_6659, &_call_f_moveRows_6659);
  methods += new qt_gsi::GenericMethod ("parent", "@brief Method QModelIndex QTransposeProxyModel::parent(const QModelIndex &index)\nThis is a reimplementation of QAbstractItemModel::parent", true, &_init_f_parent_c2395, &_call_f_parent_c2395);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@brief Method bool QTransposeProxyModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::removeColumns", false, &_init_f_removeColumns_3713, &_call_f_removeColumns_3713);
  methods += new qt_gsi::GenericMethod ("removeRows", "@brief Method bool QTransposeProxyModel::removeRows(int row, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::removeRows", false, &_init_f_removeRows_3713, &_call_f_removeRows_3713);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Method int QTransposeProxyModel::rowCount(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::rowCount", true, &_init_f_rowCount_c2395, &_call_f_rowCount_c2395);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@brief Method bool QTransposeProxyModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)\nThis is a reimplementation of QAbstractProxyModel::setHeaderData", false, &_init_f_setHeaderData_5242, &_call_f_setHeaderData_5242);
  methods += new qt_gsi::GenericMethod ("setItemData", "@brief Method bool QTransposeProxyModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)\nThis is a reimplementation of QAbstractProxyModel::setItemData", false, &_init_f_setItemData_5414, &_call_f_setItemData_5414);
  methods += new qt_gsi::GenericMethod ("setSourceModel|sourceModel=", "@brief Method void QTransposeProxyModel::setSourceModel(QAbstractItemModel *newSourceModel)\nThis is a reimplementation of QAbstractProxyModel::setSourceModel", false, &_init_f_setSourceModel_2419, &_call_f_setSourceModel_2419);
  methods += new qt_gsi::GenericMethod ("sort", "@brief Method void QTransposeProxyModel::sort(int column, Qt::SortOrder order)\nThis is a reimplementation of QAbstractProxyModel::sort", false, &_init_f_sort_2340, &_call_f_sort_2340);
  methods += new qt_gsi::GenericMethod ("span", "@brief Method QSize QTransposeProxyModel::span(const QModelIndex &index)\nThis is a reimplementation of QAbstractProxyModel::span", true, &_init_f_span_c2395, &_call_f_span_c2395);
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsAboutToBeInserted(const QModelIndex &, int, int)", "columnsAboutToBeInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QTransposeProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("columnsAboutToBeMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "columnsAboutToBeMoved", gsi::arg("sourceParent"), gsi::arg("sourceStart"), gsi::arg("sourceEnd"), gsi::arg("destinationParent"), gsi::arg("destinationColumn"), "@brief Signal declaration for QTransposeProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsAboutToBeRemoved(const QModelIndex &, int, int)", "columnsAboutToBeRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QTransposeProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsInserted(const QModelIndex &, int, int)", "columnsInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QTransposeProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("columnsMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "columnsMoved", gsi::arg("parent"), gsi::arg("start"), gsi::arg("end"), gsi::arg("destination"), gsi::arg("column"), "@brief Signal declaration for QTransposeProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsRemoved(const QModelIndex &, int, int)", "columnsRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QTransposeProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, const QModelIndex &, const QList<int> & > ("dataChanged(const QModelIndex &, const QModelIndex &, const QList<int> &)", "dataChanged", gsi::arg("topLeft"), gsi::arg("bottomRight"), gsi::arg("roles"), "@brief Signal declaration for QTransposeProxyModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QTransposeProxyModel::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::Orientation>::target_type &, int, int > ("headerDataChanged(Qt::Orientation, int, int)", "headerDataChanged", gsi::arg("orientation"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QTransposeProxyModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QList<QPersistentModelIndex> &, const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > ("layoutAboutToBeChanged(const QList<QPersistentModelIndex> &, QAbstractItemModel::LayoutChangeHint)", "layoutAboutToBeChanged", gsi::arg("parents"), gsi::arg("hint"), "@brief Signal declaration for QTransposeProxyModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QList<QPersistentModelIndex> &, const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > ("layoutChanged(const QList<QPersistentModelIndex> &, QAbstractItemModel::LayoutChangeHint)", "layoutChanged", gsi::arg("parents"), gsi::arg("hint"), "@brief Signal declaration for QTransposeProxyModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("modelAboutToBeReset()", "modelAboutToBeReset", "@brief Signal declaration for QTransposeProxyModel::modelAboutToBeReset()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("modelReset()", "modelReset", "@brief Signal declaration for QTransposeProxyModel::modelReset()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QTransposeProxyModel::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsAboutToBeInserted(const QModelIndex &, int, int)", "rowsAboutToBeInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QTransposeProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("rowsAboutToBeMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "rowsAboutToBeMoved", gsi::arg("sourceParent"), gsi::arg("sourceStart"), gsi::arg("sourceEnd"), gsi::arg("destinationParent"), gsi::arg("destinationRow"), "@brief Signal declaration for QTransposeProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsAboutToBeRemoved(const QModelIndex &, int, int)", "rowsAboutToBeRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QTransposeProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsInserted(const QModelIndex &, int, int)", "rowsInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QTransposeProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("rowsMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "rowsMoved", gsi::arg("parent"), gsi::arg("start"), gsi::arg("end"), gsi::arg("destination"), gsi::arg("row"), "@brief Signal declaration for QTransposeProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsRemoved(const QModelIndex &, int, int)", "rowsRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QTransposeProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("sourceModelChanged()", "sourceModelChanged", "@brief Signal declaration for QTransposeProxyModel::sourceModelChanged()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTransposeProxyModel::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QAbstractProxyModel> &qtdecl_QAbstractProxyModel ();

qt_gsi::QtNativeClass<QTransposeProxyModel> decl_QTransposeProxyModel (qtdecl_QAbstractProxyModel (), "QtCore", "QTransposeProxyModel_Native",
  methods_QTransposeProxyModel (),
  "@hide\n@alias QTransposeProxyModel");

GSI_QTCORE_PUBLIC gsi::Class<QTransposeProxyModel> &qtdecl_QTransposeProxyModel () { return decl_QTransposeProxyModel; }

}


class QTransposeProxyModel_Adaptor : public QTransposeProxyModel, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTransposeProxyModel_Adaptor();

  //  [adaptor ctor] QTransposeProxyModel::QTransposeProxyModel(QObject *parent)
  QTransposeProxyModel_Adaptor() : QTransposeProxyModel()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTransposeProxyModel::QTransposeProxyModel(QObject *parent)
  QTransposeProxyModel_Adaptor(QObject *parent) : QTransposeProxyModel(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QTransposeProxyModel::beginInsertColumns(const QModelIndex &parent, int first, int last)
  void fp_QTransposeProxyModel_beginInsertColumns_3713 (const QModelIndex &parent, int first, int last) {
    QTransposeProxyModel::beginInsertColumns(parent, first, last);
  }

  //  [expose] void QTransposeProxyModel::beginInsertRows(const QModelIndex &parent, int first, int last)
  void fp_QTransposeProxyModel_beginInsertRows_3713 (const QModelIndex &parent, int first, int last) {
    QTransposeProxyModel::beginInsertRows(parent, first, last);
  }

  //  [expose] bool QTransposeProxyModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)
  bool fp_QTransposeProxyModel_beginMoveColumns_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn) {
    return QTransposeProxyModel::beginMoveColumns(sourceParent, sourceFirst, sourceLast, destinationParent, destinationColumn);
  }

  //  [expose] bool QTransposeProxyModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)
  bool fp_QTransposeProxyModel_beginMoveRows_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow) {
    return QTransposeProxyModel::beginMoveRows(sourceParent, sourceFirst, sourceLast, destinationParent, destinationRow);
  }

  //  [expose] void QTransposeProxyModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)
  void fp_QTransposeProxyModel_beginRemoveColumns_3713 (const QModelIndex &parent, int first, int last) {
    QTransposeProxyModel::beginRemoveColumns(parent, first, last);
  }

  //  [expose] void QTransposeProxyModel::beginRemoveRows(const QModelIndex &parent, int first, int last)
  void fp_QTransposeProxyModel_beginRemoveRows_3713 (const QModelIndex &parent, int first, int last) {
    QTransposeProxyModel::beginRemoveRows(parent, first, last);
  }

  //  [expose] void QTransposeProxyModel::beginResetModel()
  void fp_QTransposeProxyModel_beginResetModel_0 () {
    QTransposeProxyModel::beginResetModel();
  }

  //  [expose] void QTransposeProxyModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)
  void fp_QTransposeProxyModel_changePersistentIndex_4682 (const QModelIndex &from, const QModelIndex &to) {
    QTransposeProxyModel::changePersistentIndex(from, to);
  }

  //  [expose] void QTransposeProxyModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)
  void fp_QTransposeProxyModel_changePersistentIndexList_5912 (const QList<QModelIndex> &from, const QList<QModelIndex> &to) {
    QTransposeProxyModel::changePersistentIndexList(from, to);
  }

  //  [expose] QModelIndex QTransposeProxyModel::createIndex(int row, int column, const void *data)
  QModelIndex fp_QTransposeProxyModel_createIndex_c3069 (int row, int column, const void *data) const {
    return QTransposeProxyModel::createIndex(row, column, data);
  }

  //  [expose] QModelIndex QTransposeProxyModel::createIndex(int row, int column, quintptr id)
  QModelIndex fp_QTransposeProxyModel_createIndex_c2657 (int row, int column, quintptr id) const {
    return QTransposeProxyModel::createIndex(row, column, id);
  }

  //  [expose] QModelIndex QTransposeProxyModel::createSourceIndex(int row, int col, void *internalPtr)
  QModelIndex fp_QTransposeProxyModel_createSourceIndex_c2374 (int row, int col, void *internalPtr) const {
    return QTransposeProxyModel::createSourceIndex(row, col, internalPtr);
  }

  //  [expose] bool QTransposeProxyModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)
  bool fp_QTransposeProxyModel_decodeData_5302 (int row, int column, const QModelIndex &parent, QDataStream &stream) {
    return QTransposeProxyModel::decodeData(row, column, parent, stream);
  }

  //  [expose] void QTransposeProxyModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)
  void fp_QTransposeProxyModel_encodeData_c4599 (const QList<QModelIndex> &indexes, QDataStream &stream) const {
    QTransposeProxyModel::encodeData(indexes, stream);
  }

  //  [expose] void QTransposeProxyModel::endInsertColumns()
  void fp_QTransposeProxyModel_endInsertColumns_0 () {
    QTransposeProxyModel::endInsertColumns();
  }

  //  [expose] void QTransposeProxyModel::endInsertRows()
  void fp_QTransposeProxyModel_endInsertRows_0 () {
    QTransposeProxyModel::endInsertRows();
  }

  //  [expose] void QTransposeProxyModel::endMoveColumns()
  void fp_QTransposeProxyModel_endMoveColumns_0 () {
    QTransposeProxyModel::endMoveColumns();
  }

  //  [expose] void QTransposeProxyModel::endMoveRows()
  void fp_QTransposeProxyModel_endMoveRows_0 () {
    QTransposeProxyModel::endMoveRows();
  }

  //  [expose] void QTransposeProxyModel::endRemoveColumns()
  void fp_QTransposeProxyModel_endRemoveColumns_0 () {
    QTransposeProxyModel::endRemoveColumns();
  }

  //  [expose] void QTransposeProxyModel::endRemoveRows()
  void fp_QTransposeProxyModel_endRemoveRows_0 () {
    QTransposeProxyModel::endRemoveRows();
  }

  //  [expose] void QTransposeProxyModel::endResetModel()
  void fp_QTransposeProxyModel_endResetModel_0 () {
    QTransposeProxyModel::endResetModel();
  }

  //  [expose] bool QTransposeProxyModel::isSignalConnected(const QMetaMethod &signal)
  bool fp_QTransposeProxyModel_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QTransposeProxyModel::isSignalConnected(signal);
  }

  //  [expose] QList<QModelIndex> QTransposeProxyModel::persistentIndexList()
  QList<QModelIndex> fp_QTransposeProxyModel_persistentIndexList_c0 () const {
    return QTransposeProxyModel::persistentIndexList();
  }

  //  [expose] int QTransposeProxyModel::receivers(const char *signal)
  int fp_QTransposeProxyModel_receivers_c1731 (const char *signal) const {
    return QTransposeProxyModel::receivers(signal);
  }

  //  [expose] QObject *QTransposeProxyModel::sender()
  QObject * fp_QTransposeProxyModel_sender_c0 () const {
    return QTransposeProxyModel::sender();
  }

  //  [expose] int QTransposeProxyModel::senderSignalIndex()
  int fp_QTransposeProxyModel_senderSignalIndex_c0 () const {
    return QTransposeProxyModel::senderSignalIndex();
  }

  //  [adaptor impl] QModelIndex QTransposeProxyModel::buddy(const QModelIndex &index)
  QModelIndex cbs_buddy_c2395_0(const QModelIndex &index) const
  {
    return QTransposeProxyModel::buddy(index);
  }

  virtual QModelIndex buddy(const QModelIndex &index) const
  {
    if (cb_buddy_c2395_0.can_issue()) {
      return cb_buddy_c2395_0.issue<QTransposeProxyModel_Adaptor, QModelIndex, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_buddy_c2395_0, index);
    } else {
      return QTransposeProxyModel::buddy(index);
    }
  }

  //  [adaptor impl] bool QTransposeProxyModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_canDropMimeData_c7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent) const
  {
    return QTransposeProxyModel::canDropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent) const
  {
    if (cb_canDropMimeData_c7425_0.can_issue()) {
      return cb_canDropMimeData_c7425_0.issue<QTransposeProxyModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_canDropMimeData_c7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QTransposeProxyModel::canDropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QTransposeProxyModel::canFetchMore(const QModelIndex &parent)
  bool cbs_canFetchMore_c2395_0(const QModelIndex &parent) const
  {
    return QTransposeProxyModel::canFetchMore(parent);
  }

  virtual bool canFetchMore(const QModelIndex &parent) const
  {
    if (cb_canFetchMore_c2395_0.can_issue()) {
      return cb_canFetchMore_c2395_0.issue<QTransposeProxyModel_Adaptor, bool, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_canFetchMore_c2395_0, parent);
    } else {
      return QTransposeProxyModel::canFetchMore(parent);
    }
  }

  //  [adaptor impl] bool QTransposeProxyModel::clearItemData(const QModelIndex &index)
  bool cbs_clearItemData_2395_0(const QModelIndex &index)
  {
    return QTransposeProxyModel::clearItemData(index);
  }

  virtual bool clearItemData(const QModelIndex &index)
  {
    if (cb_clearItemData_2395_0.can_issue()) {
      return cb_clearItemData_2395_0.issue<QTransposeProxyModel_Adaptor, bool, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_clearItemData_2395_0, index);
    } else {
      return QTransposeProxyModel::clearItemData(index);
    }
  }

  //  [adaptor impl] int QTransposeProxyModel::columnCount(const QModelIndex &parent)
  int cbs_columnCount_c2395_1(const QModelIndex &parent) const
  {
    return QTransposeProxyModel::columnCount(parent);
  }

  virtual int columnCount(const QModelIndex &parent) const
  {
    if (cb_columnCount_c2395_1.can_issue()) {
      return cb_columnCount_c2395_1.issue<QTransposeProxyModel_Adaptor, int, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_columnCount_c2395_1, parent);
    } else {
      return QTransposeProxyModel::columnCount(parent);
    }
  }

  //  [emitter impl] void QTransposeProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)
  void emitter_QTransposeProxyModel_columnsAboutToBeInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QTransposeProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QTransposeProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)
  void emitter_QTransposeProxyModel_columnsAboutToBeMoved_10318(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)
  {
    __SUPPRESS_UNUSED_WARNING (sourceParent);
    __SUPPRESS_UNUSED_WARNING (sourceStart);
    __SUPPRESS_UNUSED_WARNING (sourceEnd);
    __SUPPRESS_UNUSED_WARNING (destinationParent);
    __SUPPRESS_UNUSED_WARNING (destinationColumn);
    throw tl::Exception ("Can't emit private signal 'void QTransposeProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)'");
  }

  //  [emitter impl] void QTransposeProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QTransposeProxyModel_columnsAboutToBeRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QTransposeProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QTransposeProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)
  void emitter_QTransposeProxyModel_columnsInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QTransposeProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QTransposeProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)
  void emitter_QTransposeProxyModel_columnsMoved_10318(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (start);
    __SUPPRESS_UNUSED_WARNING (end);
    __SUPPRESS_UNUSED_WARNING (destination);
    __SUPPRESS_UNUSED_WARNING (column);
    throw tl::Exception ("Can't emit private signal 'void QTransposeProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)'");
  }

  //  [emitter impl] void QTransposeProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QTransposeProxyModel_columnsRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QTransposeProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [adaptor impl] QVariant QTransposeProxyModel::data(const QModelIndex &proxyIndex, int role)
  QVariant cbs_data_c3054_1(const QModelIndex &proxyIndex, int role) const
  {
    return QTransposeProxyModel::data(proxyIndex, role);
  }

  virtual QVariant data(const QModelIndex &proxyIndex, int role) const
  {
    if (cb_data_c3054_1.can_issue()) {
      return cb_data_c3054_1.issue<QTransposeProxyModel_Adaptor, QVariant, const QModelIndex &, int>(&QTransposeProxyModel_Adaptor::cbs_data_c3054_1, proxyIndex, role);
    } else {
      return QTransposeProxyModel::data(proxyIndex, role);
    }
  }

  //  [emitter impl] void QTransposeProxyModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)
  void emitter_QTransposeProxyModel_dataChanged_6833(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)
  {
    emit QTransposeProxyModel::dataChanged(topLeft, bottomRight, roles);
  }

  //  [emitter impl] void QTransposeProxyModel::destroyed(QObject *)
  void emitter_QTransposeProxyModel_destroyed_1302(QObject *arg1)
  {
    emit QTransposeProxyModel::destroyed(arg1);
  }

  //  [adaptor impl] bool QTransposeProxyModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_dropMimeData_7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent)
  {
    return QTransposeProxyModel::dropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  {
    if (cb_dropMimeData_7425_0.can_issue()) {
      return cb_dropMimeData_7425_0.issue<QTransposeProxyModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_dropMimeData_7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QTransposeProxyModel::dropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QTransposeProxyModel::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QTransposeProxyModel::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QTransposeProxyModel_Adaptor, bool, QEvent *>(&QTransposeProxyModel_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QTransposeProxyModel::event(_event);
    }
  }

  //  [adaptor impl] bool QTransposeProxyModel::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QTransposeProxyModel::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QTransposeProxyModel_Adaptor, bool, QObject *, QEvent *>(&QTransposeProxyModel_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QTransposeProxyModel::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QTransposeProxyModel::fetchMore(const QModelIndex &parent)
  void cbs_fetchMore_2395_0(const QModelIndex &parent)
  {
    QTransposeProxyModel::fetchMore(parent);
  }

  virtual void fetchMore(const QModelIndex &parent)
  {
    if (cb_fetchMore_2395_0.can_issue()) {
      cb_fetchMore_2395_0.issue<QTransposeProxyModel_Adaptor, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_fetchMore_2395_0, parent);
    } else {
      QTransposeProxyModel::fetchMore(parent);
    }
  }

  //  [adaptor impl] QFlags<Qt::ItemFlag> QTransposeProxyModel::flags(const QModelIndex &index)
  QFlags<Qt::ItemFlag> cbs_flags_c2395_0(const QModelIndex &index) const
  {
    return QTransposeProxyModel::flags(index);
  }

  virtual QFlags<Qt::ItemFlag> flags(const QModelIndex &index) const
  {
    if (cb_flags_c2395_0.can_issue()) {
      return cb_flags_c2395_0.issue<QTransposeProxyModel_Adaptor, QFlags<Qt::ItemFlag>, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_flags_c2395_0, index);
    } else {
      return QTransposeProxyModel::flags(index);
    }
  }

  //  [adaptor impl] bool QTransposeProxyModel::hasChildren(const QModelIndex &parent)
  bool cbs_hasChildren_c2395_1(const QModelIndex &parent) const
  {
    return QTransposeProxyModel::hasChildren(parent);
  }

  virtual bool hasChildren(const QModelIndex &parent) const
  {
    if (cb_hasChildren_c2395_1.can_issue()) {
      return cb_hasChildren_c2395_1.issue<QTransposeProxyModel_Adaptor, bool, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_hasChildren_c2395_1, parent);
    } else {
      return QTransposeProxyModel::hasChildren(parent);
    }
  }

  //  [adaptor impl] QVariant QTransposeProxyModel::headerData(int section, Qt::Orientation orientation, int role)
  QVariant cbs_headerData_c3231_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, int role) const
  {
    return QTransposeProxyModel::headerData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), role);
  }

  virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const
  {
    if (cb_headerData_c3231_1.can_issue()) {
      return cb_headerData_c3231_1.issue<QTransposeProxyModel_Adaptor, QVariant, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, int>(&QTransposeProxyModel_Adaptor::cbs_headerData_c3231_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), role);
    } else {
      return QTransposeProxyModel::headerData(section, orientation, role);
    }
  }

  //  [emitter impl] void QTransposeProxyModel::headerDataChanged(Qt::Orientation orientation, int first, int last)
  void emitter_QTransposeProxyModel_headerDataChanged_3231(Qt::Orientation orientation, int first, int last)
  {
    emit QTransposeProxyModel::headerDataChanged(orientation, first, last);
  }

  //  [adaptor impl] QModelIndex QTransposeProxyModel::index(int row, int column, const QModelIndex &parent)
  QModelIndex cbs_index_c3713_1(int row, int column, const QModelIndex &parent) const
  {
    return QTransposeProxyModel::index(row, column, parent);
  }

  virtual QModelIndex index(int row, int column, const QModelIndex &parent) const
  {
    if (cb_index_c3713_1.can_issue()) {
      return cb_index_c3713_1.issue<QTransposeProxyModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_index_c3713_1, row, column, parent);
    } else {
      return QTransposeProxyModel::index(row, column, parent);
    }
  }

  //  [adaptor impl] bool QTransposeProxyModel::insertColumns(int column, int count, const QModelIndex &parent)
  bool cbs_insertColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QTransposeProxyModel::insertColumns(column, count, parent);
  }

  virtual bool insertColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_insertColumns_3713_1.can_issue()) {
      return cb_insertColumns_3713_1.issue<QTransposeProxyModel_Adaptor, bool, int, int, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_insertColumns_3713_1, column, count, parent);
    } else {
      return QTransposeProxyModel::insertColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QTransposeProxyModel::insertRows(int row, int count, const QModelIndex &parent)
  bool cbs_insertRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QTransposeProxyModel::insertRows(row, count, parent);
  }

  virtual bool insertRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_insertRows_3713_1.can_issue()) {
      return cb_insertRows_3713_1.issue<QTransposeProxyModel_Adaptor, bool, int, int, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_insertRows_3713_1, row, count, parent);
    } else {
      return QTransposeProxyModel::insertRows(row, count, parent);
    }
  }

  //  [adaptor impl] QMap<int, QVariant> QTransposeProxyModel::itemData(const QModelIndex &index)
  QMap<int, QVariant> cbs_itemData_c2395_0(const QModelIndex &index) const
  {
    return QTransposeProxyModel::itemData(index);
  }

  virtual QMap<int, QVariant> itemData(const QModelIndex &index) const
  {
    if (cb_itemData_c2395_0.can_issue()) {
      return cb_itemData_c2395_0.issue<QTransposeProxyModel_Adaptor, QMap<int, QVariant>, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_itemData_c2395_0, index);
    } else {
      return QTransposeProxyModel::itemData(index);
    }
  }

  //  [emitter impl] void QTransposeProxyModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  void emitter_QTransposeProxyModel_layoutAboutToBeChanged_7947(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  {
    emit QTransposeProxyModel::layoutAboutToBeChanged(parents, hint);
  }

  //  [emitter impl] void QTransposeProxyModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  void emitter_QTransposeProxyModel_layoutChanged_7947(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  {
    emit QTransposeProxyModel::layoutChanged(parents, hint);
  }

  //  [adaptor impl] QModelIndex QTransposeProxyModel::mapFromSource(const QModelIndex &sourceIndex)
  QModelIndex cbs_mapFromSource_c2395_0(const QModelIndex &sourceIndex) const
  {
    return QTransposeProxyModel::mapFromSource(sourceIndex);
  }

  virtual QModelIndex mapFromSource(const QModelIndex &sourceIndex) const
  {
    if (cb_mapFromSource_c2395_0.can_issue()) {
      return cb_mapFromSource_c2395_0.issue<QTransposeProxyModel_Adaptor, QModelIndex, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_mapFromSource_c2395_0, sourceIndex);
    } else {
      return QTransposeProxyModel::mapFromSource(sourceIndex);
    }
  }

  //  [adaptor impl] QItemSelection QTransposeProxyModel::mapSelectionFromSource(const QItemSelection &selection)
  QItemSelection cbs_mapSelectionFromSource_c2727_0(const QItemSelection &selection) const
  {
    return QTransposeProxyModel::mapSelectionFromSource(selection);
  }

  virtual QItemSelection mapSelectionFromSource(const QItemSelection &selection) const
  {
    if (cb_mapSelectionFromSource_c2727_0.can_issue()) {
      return cb_mapSelectionFromSource_c2727_0.issue<QTransposeProxyModel_Adaptor, QItemSelection, const QItemSelection &>(&QTransposeProxyModel_Adaptor::cbs_mapSelectionFromSource_c2727_0, selection);
    } else {
      return QTransposeProxyModel::mapSelectionFromSource(selection);
    }
  }

  //  [adaptor impl] QItemSelection QTransposeProxyModel::mapSelectionToSource(const QItemSelection &selection)
  QItemSelection cbs_mapSelectionToSource_c2727_0(const QItemSelection &selection) const
  {
    return QTransposeProxyModel::mapSelectionToSource(selection);
  }

  virtual QItemSelection mapSelectionToSource(const QItemSelection &selection) const
  {
    if (cb_mapSelectionToSource_c2727_0.can_issue()) {
      return cb_mapSelectionToSource_c2727_0.issue<QTransposeProxyModel_Adaptor, QItemSelection, const QItemSelection &>(&QTransposeProxyModel_Adaptor::cbs_mapSelectionToSource_c2727_0, selection);
    } else {
      return QTransposeProxyModel::mapSelectionToSource(selection);
    }
  }

  //  [adaptor impl] QModelIndex QTransposeProxyModel::mapToSource(const QModelIndex &proxyIndex)
  QModelIndex cbs_mapToSource_c2395_0(const QModelIndex &proxyIndex) const
  {
    return QTransposeProxyModel::mapToSource(proxyIndex);
  }

  virtual QModelIndex mapToSource(const QModelIndex &proxyIndex) const
  {
    if (cb_mapToSource_c2395_0.can_issue()) {
      return cb_mapToSource_c2395_0.issue<QTransposeProxyModel_Adaptor, QModelIndex, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_mapToSource_c2395_0, proxyIndex);
    } else {
      return QTransposeProxyModel::mapToSource(proxyIndex);
    }
  }

  //  [adaptor impl] QList<QModelIndex> QTransposeProxyModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)
  QList<QModelIndex> cbs_match_c7932_2(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    return QTransposeProxyModel::match(start, role, value, hits, flags);
  }

  virtual QList<QModelIndex> match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    if (cb_match_c7932_2.can_issue()) {
      return cb_match_c7932_2.issue<QTransposeProxyModel_Adaptor, QList<QModelIndex>, const QModelIndex &, int, const QVariant &, int, QFlags<Qt::MatchFlag> >(&QTransposeProxyModel_Adaptor::cbs_match_c7932_2, start, role, value, hits, flags);
    } else {
      return QTransposeProxyModel::match(start, role, value, hits, flags);
    }
  }

  //  [adaptor impl] QMimeData *QTransposeProxyModel::mimeData(const QList<QModelIndex> &indexes)
  QMimeData * cbs_mimeData_c3010_0(const QList<QModelIndex> &indexes) const
  {
    return QTransposeProxyModel::mimeData(indexes);
  }

  virtual QMimeData * mimeData(const QList<QModelIndex> &indexes) const
  {
    if (cb_mimeData_c3010_0.can_issue()) {
      return cb_mimeData_c3010_0.issue<QTransposeProxyModel_Adaptor, QMimeData *, const QList<QModelIndex> &>(&QTransposeProxyModel_Adaptor::cbs_mimeData_c3010_0, indexes);
    } else {
      return QTransposeProxyModel::mimeData(indexes);
    }
  }

  //  [adaptor impl] QStringList QTransposeProxyModel::mimeTypes()
  QStringList cbs_mimeTypes_c0_0() const
  {
    return QTransposeProxyModel::mimeTypes();
  }

  virtual QStringList mimeTypes() const
  {
    if (cb_mimeTypes_c0_0.can_issue()) {
      return cb_mimeTypes_c0_0.issue<QTransposeProxyModel_Adaptor, QStringList>(&QTransposeProxyModel_Adaptor::cbs_mimeTypes_c0_0);
    } else {
      return QTransposeProxyModel::mimeTypes();
    }
  }

  //  [emitter impl] void QTransposeProxyModel::modelAboutToBeReset()
  void emitter_QTransposeProxyModel_modelAboutToBeReset_3767()
  {
    throw tl::Exception ("Can't emit private signal 'void QTransposeProxyModel::modelAboutToBeReset()'");
  }

  //  [emitter impl] void QTransposeProxyModel::modelReset()
  void emitter_QTransposeProxyModel_modelReset_3767()
  {
    throw tl::Exception ("Can't emit private signal 'void QTransposeProxyModel::modelReset()'");
  }

  //  [adaptor impl] bool QTransposeProxyModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  bool cbs_moveColumns_6659_0(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    return QTransposeProxyModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
  }

  virtual bool moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    if (cb_moveColumns_6659_0.can_issue()) {
      return cb_moveColumns_6659_0.issue<QTransposeProxyModel_Adaptor, bool, const QModelIndex &, int, int, const QModelIndex &, int>(&QTransposeProxyModel_Adaptor::cbs_moveColumns_6659_0, sourceParent, sourceColumn, count, destinationParent, destinationChild);
    } else {
      return QTransposeProxyModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
    }
  }

  //  [adaptor impl] bool QTransposeProxyModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  bool cbs_moveRows_6659_0(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    return QTransposeProxyModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
  }

  virtual bool moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    if (cb_moveRows_6659_0.can_issue()) {
      return cb_moveRows_6659_0.issue<QTransposeProxyModel_Adaptor, bool, const QModelIndex &, int, int, const QModelIndex &, int>(&QTransposeProxyModel_Adaptor::cbs_moveRows_6659_0, sourceParent, sourceRow, count, destinationParent, destinationChild);
    } else {
      return QTransposeProxyModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
    }
  }

  //  [adaptor impl] void QTransposeProxyModel::multiData(const QModelIndex &index, QModelRoleDataSpan roleDataSpan)
  void cbs_multiData_c4483_0(const QModelIndex &index, QModelRoleDataSpan roleDataSpan) const
  {
    QTransposeProxyModel::multiData(index, roleDataSpan);
  }

  virtual void multiData(const QModelIndex &index, QModelRoleDataSpan roleDataSpan) const
  {
    if (cb_multiData_c4483_0.can_issue()) {
      cb_multiData_c4483_0.issue<QTransposeProxyModel_Adaptor, const QModelIndex &, QModelRoleDataSpan>(&QTransposeProxyModel_Adaptor::cbs_multiData_c4483_0, index, roleDataSpan);
    } else {
      QTransposeProxyModel::multiData(index, roleDataSpan);
    }
  }

  //  [emitter impl] void QTransposeProxyModel::objectNameChanged(const QString &objectName)
  void emitter_QTransposeProxyModel_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QTransposeProxyModel::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QModelIndex QTransposeProxyModel::parent(const QModelIndex &index)
  QModelIndex cbs_parent_c2395_0(const QModelIndex &index) const
  {
    return QTransposeProxyModel::parent(index);
  }

  virtual QModelIndex parent(const QModelIndex &index) const
  {
    if (cb_parent_c2395_0.can_issue()) {
      return cb_parent_c2395_0.issue<QTransposeProxyModel_Adaptor, QModelIndex, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_parent_c2395_0, index);
    } else {
      return QTransposeProxyModel::parent(index);
    }
  }

  //  [adaptor impl] bool QTransposeProxyModel::removeColumns(int column, int count, const QModelIndex &parent)
  bool cbs_removeColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QTransposeProxyModel::removeColumns(column, count, parent);
  }

  virtual bool removeColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_removeColumns_3713_1.can_issue()) {
      return cb_removeColumns_3713_1.issue<QTransposeProxyModel_Adaptor, bool, int, int, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_removeColumns_3713_1, column, count, parent);
    } else {
      return QTransposeProxyModel::removeColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QTransposeProxyModel::removeRows(int row, int count, const QModelIndex &parent)
  bool cbs_removeRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QTransposeProxyModel::removeRows(row, count, parent);
  }

  virtual bool removeRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_removeRows_3713_1.can_issue()) {
      return cb_removeRows_3713_1.issue<QTransposeProxyModel_Adaptor, bool, int, int, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_removeRows_3713_1, row, count, parent);
    } else {
      return QTransposeProxyModel::removeRows(row, count, parent);
    }
  }

  //  [adaptor impl] void QTransposeProxyModel::revert()
  void cbs_revert_0_0()
  {
    QTransposeProxyModel::revert();
  }

  virtual void revert()
  {
    if (cb_revert_0_0.can_issue()) {
      cb_revert_0_0.issue<QTransposeProxyModel_Adaptor>(&QTransposeProxyModel_Adaptor::cbs_revert_0_0);
    } else {
      QTransposeProxyModel::revert();
    }
  }

  //  [adaptor impl] QHash<int, QByteArray> QTransposeProxyModel::roleNames()
  QHash<int, QByteArray> cbs_roleNames_c0_0() const
  {
    return QTransposeProxyModel::roleNames();
  }

  virtual QHash<int, QByteArray> roleNames() const
  {
    if (cb_roleNames_c0_0.can_issue()) {
      return cb_roleNames_c0_0.issue<QTransposeProxyModel_Adaptor, QHash<int, QByteArray> >(&QTransposeProxyModel_Adaptor::cbs_roleNames_c0_0);
    } else {
      return QTransposeProxyModel::roleNames();
    }
  }

  //  [adaptor impl] int QTransposeProxyModel::rowCount(const QModelIndex &parent)
  int cbs_rowCount_c2395_1(const QModelIndex &parent) const
  {
    return QTransposeProxyModel::rowCount(parent);
  }

  virtual int rowCount(const QModelIndex &parent) const
  {
    if (cb_rowCount_c2395_1.can_issue()) {
      return cb_rowCount_c2395_1.issue<QTransposeProxyModel_Adaptor, int, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_rowCount_c2395_1, parent);
    } else {
      return QTransposeProxyModel::rowCount(parent);
    }
  }

  //  [emitter impl] void QTransposeProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)
  void emitter_QTransposeProxyModel_rowsAboutToBeInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QTransposeProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QTransposeProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)
  void emitter_QTransposeProxyModel_rowsAboutToBeMoved_10318(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)
  {
    __SUPPRESS_UNUSED_WARNING (sourceParent);
    __SUPPRESS_UNUSED_WARNING (sourceStart);
    __SUPPRESS_UNUSED_WARNING (sourceEnd);
    __SUPPRESS_UNUSED_WARNING (destinationParent);
    __SUPPRESS_UNUSED_WARNING (destinationRow);
    throw tl::Exception ("Can't emit private signal 'void QTransposeProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)'");
  }

  //  [emitter impl] void QTransposeProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QTransposeProxyModel_rowsAboutToBeRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QTransposeProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QTransposeProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)
  void emitter_QTransposeProxyModel_rowsInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QTransposeProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QTransposeProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)
  void emitter_QTransposeProxyModel_rowsMoved_10318(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (start);
    __SUPPRESS_UNUSED_WARNING (end);
    __SUPPRESS_UNUSED_WARNING (destination);
    __SUPPRESS_UNUSED_WARNING (row);
    throw tl::Exception ("Can't emit private signal 'void QTransposeProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)'");
  }

  //  [emitter impl] void QTransposeProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QTransposeProxyModel_rowsRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QTransposeProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [adaptor impl] bool QTransposeProxyModel::setData(const QModelIndex &index, const QVariant &value, int role)
  bool cbs_setData_5065_1(const QModelIndex &index, const QVariant &value, int role)
  {
    return QTransposeProxyModel::setData(index, value, role);
  }

  virtual bool setData(const QModelIndex &index, const QVariant &value, int role)
  {
    if (cb_setData_5065_1.can_issue()) {
      return cb_setData_5065_1.issue<QTransposeProxyModel_Adaptor, bool, const QModelIndex &, const QVariant &, int>(&QTransposeProxyModel_Adaptor::cbs_setData_5065_1, index, value, role);
    } else {
      return QTransposeProxyModel::setData(index, value, role);
    }
  }

  //  [adaptor impl] bool QTransposeProxyModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  bool cbs_setHeaderData_5242_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, const QVariant &value, int role)
  {
    return QTransposeProxyModel::setHeaderData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), value, role);
  }

  virtual bool setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  {
    if (cb_setHeaderData_5242_1.can_issue()) {
      return cb_setHeaderData_5242_1.issue<QTransposeProxyModel_Adaptor, bool, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, const QVariant &, int>(&QTransposeProxyModel_Adaptor::cbs_setHeaderData_5242_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), value, role);
    } else {
      return QTransposeProxyModel::setHeaderData(section, orientation, value, role);
    }
  }

  //  [adaptor impl] bool QTransposeProxyModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)
  bool cbs_setItemData_5414_0(const QModelIndex &index, const QMap<int, QVariant> &roles)
  {
    return QTransposeProxyModel::setItemData(index, roles);
  }

  virtual bool setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)
  {
    if (cb_setItemData_5414_0.can_issue()) {
      return cb_setItemData_5414_0.issue<QTransposeProxyModel_Adaptor, bool, const QModelIndex &, const QMap<int, QVariant> &>(&QTransposeProxyModel_Adaptor::cbs_setItemData_5414_0, index, roles);
    } else {
      return QTransposeProxyModel::setItemData(index, roles);
    }
  }

  //  [adaptor impl] void QTransposeProxyModel::setSourceModel(QAbstractItemModel *newSourceModel)
  void cbs_setSourceModel_2419_0(QAbstractItemModel *newSourceModel)
  {
    QTransposeProxyModel::setSourceModel(newSourceModel);
  }

  virtual void setSourceModel(QAbstractItemModel *newSourceModel)
  {
    if (cb_setSourceModel_2419_0.can_issue()) {
      cb_setSourceModel_2419_0.issue<QTransposeProxyModel_Adaptor, QAbstractItemModel *>(&QTransposeProxyModel_Adaptor::cbs_setSourceModel_2419_0, newSourceModel);
    } else {
      QTransposeProxyModel::setSourceModel(newSourceModel);
    }
  }

  //  [adaptor impl] QModelIndex QTransposeProxyModel::sibling(int row, int column, const QModelIndex &idx)
  QModelIndex cbs_sibling_c3713_0(int row, int column, const QModelIndex &idx) const
  {
    return QTransposeProxyModel::sibling(row, column, idx);
  }

  virtual QModelIndex sibling(int row, int column, const QModelIndex &idx) const
  {
    if (cb_sibling_c3713_0.can_issue()) {
      return cb_sibling_c3713_0.issue<QTransposeProxyModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_sibling_c3713_0, row, column, idx);
    } else {
      return QTransposeProxyModel::sibling(row, column, idx);
    }
  }

  //  [adaptor impl] void QTransposeProxyModel::sort(int column, Qt::SortOrder order)
  void cbs_sort_2340_1(int column, const qt_gsi::Converter<Qt::SortOrder>::target_type & order)
  {
    QTransposeProxyModel::sort(column, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(order).cref());
  }

  virtual void sort(int column, Qt::SortOrder order)
  {
    if (cb_sort_2340_1.can_issue()) {
      cb_sort_2340_1.issue<QTransposeProxyModel_Adaptor, int, const qt_gsi::Converter<Qt::SortOrder>::target_type &>(&QTransposeProxyModel_Adaptor::cbs_sort_2340_1, column, qt_gsi::CppToQtAdaptor<Qt::SortOrder>(order));
    } else {
      QTransposeProxyModel::sort(column, order);
    }
  }

  //  [emitter impl] void QTransposeProxyModel::sourceModelChanged()
  void emitter_QTransposeProxyModel_sourceModelChanged_3914()
  {
    throw tl::Exception ("Can't emit private signal 'void QTransposeProxyModel::sourceModelChanged()'");
  }

  //  [adaptor impl] QSize QTransposeProxyModel::span(const QModelIndex &index)
  QSize cbs_span_c2395_0(const QModelIndex &index) const
  {
    return QTransposeProxyModel::span(index);
  }

  virtual QSize span(const QModelIndex &index) const
  {
    if (cb_span_c2395_0.can_issue()) {
      return cb_span_c2395_0.issue<QTransposeProxyModel_Adaptor, QSize, const QModelIndex &>(&QTransposeProxyModel_Adaptor::cbs_span_c2395_0, index);
    } else {
      return QTransposeProxyModel::span(index);
    }
  }

  //  [adaptor impl] bool QTransposeProxyModel::submit()
  bool cbs_submit_0_0()
  {
    return QTransposeProxyModel::submit();
  }

  virtual bool submit()
  {
    if (cb_submit_0_0.can_issue()) {
      return cb_submit_0_0.issue<QTransposeProxyModel_Adaptor, bool>(&QTransposeProxyModel_Adaptor::cbs_submit_0_0);
    } else {
      return QTransposeProxyModel::submit();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QTransposeProxyModel::supportedDragActions()
  QFlags<Qt::DropAction> cbs_supportedDragActions_c0_0() const
  {
    return QTransposeProxyModel::supportedDragActions();
  }

  virtual QFlags<Qt::DropAction> supportedDragActions() const
  {
    if (cb_supportedDragActions_c0_0.can_issue()) {
      return cb_supportedDragActions_c0_0.issue<QTransposeProxyModel_Adaptor, QFlags<Qt::DropAction> >(&QTransposeProxyModel_Adaptor::cbs_supportedDragActions_c0_0);
    } else {
      return QTransposeProxyModel::supportedDragActions();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QTransposeProxyModel::supportedDropActions()
  QFlags<Qt::DropAction> cbs_supportedDropActions_c0_0() const
  {
    return QTransposeProxyModel::supportedDropActions();
  }

  virtual QFlags<Qt::DropAction> supportedDropActions() const
  {
    if (cb_supportedDropActions_c0_0.can_issue()) {
      return cb_supportedDropActions_c0_0.issue<QTransposeProxyModel_Adaptor, QFlags<Qt::DropAction> >(&QTransposeProxyModel_Adaptor::cbs_supportedDropActions_c0_0);
    } else {
      return QTransposeProxyModel::supportedDropActions();
    }
  }

  //  [adaptor impl] void QTransposeProxyModel::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QTransposeProxyModel::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QTransposeProxyModel_Adaptor, QChildEvent *>(&QTransposeProxyModel_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QTransposeProxyModel::childEvent(event);
    }
  }

  //  [adaptor impl] void QTransposeProxyModel::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QTransposeProxyModel::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QTransposeProxyModel_Adaptor, QEvent *>(&QTransposeProxyModel_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QTransposeProxyModel::customEvent(event);
    }
  }

  //  [adaptor impl] void QTransposeProxyModel::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QTransposeProxyModel::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QTransposeProxyModel_Adaptor, const QMetaMethod &>(&QTransposeProxyModel_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QTransposeProxyModel::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QTransposeProxyModel::resetInternalData()
  void cbs_resetInternalData_0_0()
  {
    QTransposeProxyModel::resetInternalData();
  }

  virtual void resetInternalData()
  {
    if (cb_resetInternalData_0_0.can_issue()) {
      cb_resetInternalData_0_0.issue<QTransposeProxyModel_Adaptor>(&QTransposeProxyModel_Adaptor::cbs_resetInternalData_0_0);
    } else {
      QTransposeProxyModel::resetInternalData();
    }
  }

  //  [adaptor impl] void QTransposeProxyModel::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QTransposeProxyModel::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QTransposeProxyModel_Adaptor, QTimerEvent *>(&QTransposeProxyModel_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QTransposeProxyModel::timerEvent(event);
    }
  }

  gsi::Callback cb_buddy_c2395_0;
  gsi::Callback cb_canDropMimeData_c7425_0;
  gsi::Callback cb_canFetchMore_c2395_0;
  gsi::Callback cb_clearItemData_2395_0;
  gsi::Callback cb_columnCount_c2395_1;
  gsi::Callback cb_data_c3054_1;
  gsi::Callback cb_dropMimeData_7425_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_fetchMore_2395_0;
  gsi::Callback cb_flags_c2395_0;
  gsi::Callback cb_hasChildren_c2395_1;
  gsi::Callback cb_headerData_c3231_1;
  gsi::Callback cb_index_c3713_1;
  gsi::Callback cb_insertColumns_3713_1;
  gsi::Callback cb_insertRows_3713_1;
  gsi::Callback cb_itemData_c2395_0;
  gsi::Callback cb_mapFromSource_c2395_0;
  gsi::Callback cb_mapSelectionFromSource_c2727_0;
  gsi::Callback cb_mapSelectionToSource_c2727_0;
  gsi::Callback cb_mapToSource_c2395_0;
  gsi::Callback cb_match_c7932_2;
  gsi::Callback cb_mimeData_c3010_0;
  gsi::Callback cb_mimeTypes_c0_0;
  gsi::Callback cb_moveColumns_6659_0;
  gsi::Callback cb_moveRows_6659_0;
  gsi::Callback cb_multiData_c4483_0;
  gsi::Callback cb_parent_c2395_0;
  gsi::Callback cb_removeColumns_3713_1;
  gsi::Callback cb_removeRows_3713_1;
  gsi::Callback cb_revert_0_0;
  gsi::Callback cb_roleNames_c0_0;
  gsi::Callback cb_rowCount_c2395_1;
  gsi::Callback cb_setData_5065_1;
  gsi::Callback cb_setHeaderData_5242_1;
  gsi::Callback cb_setItemData_5414_0;
  gsi::Callback cb_setSourceModel_2419_0;
  gsi::Callback cb_sibling_c3713_0;
  gsi::Callback cb_sort_2340_1;
  gsi::Callback cb_span_c2395_0;
  gsi::Callback cb_submit_0_0;
  gsi::Callback cb_supportedDragActions_c0_0;
  gsi::Callback cb_supportedDropActions_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_resetInternalData_0_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QTransposeProxyModel_Adaptor::~QTransposeProxyModel_Adaptor() { }

//  Constructor QTransposeProxyModel::QTransposeProxyModel(QObject *parent) (adaptor class)

static void _init_ctor_QTransposeProxyModel_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QTransposeProxyModel_Adaptor> ();
}

static void _call_ctor_QTransposeProxyModel_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QTransposeProxyModel_Adaptor *> (new QTransposeProxyModel_Adaptor (arg1));
}


// exposed void QTransposeProxyModel::beginInsertColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_beginInsertColumns_3713 (arg1, arg2, arg3);
}


// exposed void QTransposeProxyModel::beginInsertRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_beginInsertRows_3713 (arg1, arg2, arg3);
}


// exposed bool QTransposeProxyModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)

static void _init_fp_beginMoveColumns_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationColumn");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveColumns_6659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_beginMoveColumns_6659 (arg1, arg2, arg3, arg4, arg5));
}


// exposed bool QTransposeProxyModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)

static void _init_fp_beginMoveRows_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationRow");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveRows_6659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_beginMoveRows_6659 (arg1, arg2, arg3, arg4, arg5));
}


// exposed void QTransposeProxyModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_beginRemoveColumns_3713 (arg1, arg2, arg3);
}


// exposed void QTransposeProxyModel::beginRemoveRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_beginRemoveRows_3713 (arg1, arg2, arg3);
}


// exposed void QTransposeProxyModel::beginResetModel()

static void _init_fp_beginResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_beginResetModel_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_beginResetModel_0 ();
}


// QModelIndex QTransposeProxyModel::buddy(const QModelIndex &index)

static void _init_cbs_buddy_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_buddy_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QTransposeProxyModel_Adaptor *)cls)->cbs_buddy_c2395_0 (arg1));
}

static void _set_callback_cbs_buddy_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_buddy_c2395_0 = cb;
}


// bool QTransposeProxyModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_canDropMimeData_c7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_canDropMimeData_c7425_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  const QModelIndex &arg5 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->cbs_canDropMimeData_c7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_canDropMimeData_c7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_canDropMimeData_c7425_0 = cb;
}


// bool QTransposeProxyModel::canFetchMore(const QModelIndex &parent)

static void _init_cbs_canFetchMore_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_canFetchMore_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->cbs_canFetchMore_c2395_0 (arg1));
}

static void _set_callback_cbs_canFetchMore_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_canFetchMore_c2395_0 = cb;
}


// exposed void QTransposeProxyModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)

static void _init_fp_changePersistentIndex_4682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndex_4682 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_changePersistentIndex_4682 (arg1, arg2);
}


// exposed void QTransposeProxyModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)

static void _init_fp_changePersistentIndexList_5912 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QList<QModelIndex> & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndexList_5912 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  const QList<QModelIndex> &arg2 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_changePersistentIndexList_5912 (arg1, arg2);
}


// void QTransposeProxyModel::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// bool QTransposeProxyModel::clearItemData(const QModelIndex &index)

static void _init_cbs_clearItemData_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_clearItemData_2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->cbs_clearItemData_2395_0 (arg1));
}

static void _set_callback_cbs_clearItemData_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_clearItemData_2395_0 = cb;
}


// int QTransposeProxyModel::columnCount(const QModelIndex &parent)

static void _init_cbs_columnCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_columnCount_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<int > ((int)((QTransposeProxyModel_Adaptor *)cls)->cbs_columnCount_c2395_1 (arg1));
}

static void _set_callback_cbs_columnCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_columnCount_c2395_1 = cb;
}


// emitter void QTransposeProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsAboutToBeInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsAboutToBeInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_columnsAboutToBeInserted_7372 (arg1, arg2, arg3);
}


// emitter void QTransposeProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)

static void _init_emitter_columnsAboutToBeMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceStart");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceEnd");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationColumn");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_columnsAboutToBeMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_columnsAboutToBeMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QTransposeProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsAboutToBeRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsAboutToBeRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_columnsAboutToBeRemoved_7372 (arg1, arg2, arg3);
}


// emitter void QTransposeProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_columnsInserted_7372 (arg1, arg2, arg3);
}


// emitter void QTransposeProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)

static void _init_emitter_columnsMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destination");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("column");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_columnsMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_columnsMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QTransposeProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_columnsRemoved_7372 (arg1, arg2, arg3);
}


// exposed QModelIndex QTransposeProxyModel::createIndex(int row, int column, const void *data)

static void _init_fp_createIndex_c3069 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data", true, "nullptr");
  decl->add_arg<const void * > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c3069 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const void *arg3 = args ? gsi::arg_reader<const void * >() (args, heap) : gsi::arg_maker<const void * >() (nullptr, heap);
  ret.write<QModelIndex > ((QModelIndex)((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_createIndex_c3069 (arg1, arg2, arg3));
}


// exposed QModelIndex QTransposeProxyModel::createIndex(int row, int column, quintptr id)

static void _init_fp_createIndex_c2657 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<quintptr > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2657 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  quintptr arg3 = gsi::arg_reader<quintptr >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_createIndex_c2657 (arg1, arg2, arg3));
}


// exposed QModelIndex QTransposeProxyModel::createSourceIndex(int row, int col, void *internalPtr)

static void _init_fp_createSourceIndex_c2374 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("col");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("internalPtr");
  decl->add_arg<void * > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createSourceIndex_c2374 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  void *arg3 = gsi::arg_reader<void * >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_createSourceIndex_c2374 (arg1, arg2, arg3));
}


// void QTransposeProxyModel::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// QVariant QTransposeProxyModel::data(const QModelIndex &proxyIndex, int role)

static void _init_cbs_data_c3054_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("proxyIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_data_c3054_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QTransposeProxyModel_Adaptor *)cls)->cbs_data_c3054_1 (arg1, arg2));
}

static void _set_callback_cbs_data_c3054_1 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_data_c3054_1 = cb;
}


// emitter void QTransposeProxyModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)

static void _init_emitter_dataChanged_6833 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeft");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomRight");
  decl->add_arg<const QModelIndex & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("roles", true, "QList<int>()");
  decl->add_arg<const QList<int> & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_dataChanged_6833 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QList<int> &arg3 = args ? gsi::arg_reader<const QList<int> & >() (args, heap) : gsi::arg_maker<const QList<int> & >() (QList<int>(), heap);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_dataChanged_6833 (arg1, arg2, arg3);
}


// exposed bool QTransposeProxyModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)

static void _init_fp_decodeData_5302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("stream");
  decl->add_arg<QDataStream & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_fp_decodeData_5302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  QDataStream &arg4 = gsi::arg_reader<QDataStream & >() (args, heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_decodeData_5302 (arg1, arg2, arg3, arg4));
}


// emitter void QTransposeProxyModel::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_destroyed_1302 (arg1);
}


// void QTransposeProxyModel::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QTransposeProxyModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_dropMimeData_7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_dropMimeData_7425_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  const QModelIndex &arg5 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->cbs_dropMimeData_7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_dropMimeData_7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_dropMimeData_7425_0 = cb;
}


// exposed void QTransposeProxyModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)

static void _init_fp_encodeData_c4599 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream");
  decl->add_arg<QDataStream & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_encodeData_c4599 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  QDataStream &arg2 = gsi::arg_reader<QDataStream & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_encodeData_c4599 (arg1, arg2);
}


// exposed void QTransposeProxyModel::endInsertColumns()

static void _init_fp_endInsertColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_endInsertColumns_0 ();
}


// exposed void QTransposeProxyModel::endInsertRows()

static void _init_fp_endInsertRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_endInsertRows_0 ();
}


// exposed void QTransposeProxyModel::endMoveColumns()

static void _init_fp_endMoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_endMoveColumns_0 ();
}


// exposed void QTransposeProxyModel::endMoveRows()

static void _init_fp_endMoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_endMoveRows_0 ();
}


// exposed void QTransposeProxyModel::endRemoveColumns()

static void _init_fp_endRemoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_endRemoveColumns_0 ();
}


// exposed void QTransposeProxyModel::endRemoveRows()

static void _init_fp_endRemoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_endRemoveRows_0 ();
}


// exposed void QTransposeProxyModel::endResetModel()

static void _init_fp_endResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endResetModel_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_endResetModel_0 ();
}


// bool QTransposeProxyModel::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QTransposeProxyModel::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QTransposeProxyModel::fetchMore(const QModelIndex &parent)

static void _init_cbs_fetchMore_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fetchMore_2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->cbs_fetchMore_2395_0 (arg1);
}

static void _set_callback_cbs_fetchMore_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_fetchMore_2395_0 = cb;
}


// QFlags<Qt::ItemFlag> QTransposeProxyModel::flags(const QModelIndex &index)

static void _init_cbs_flags_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QFlags<Qt::ItemFlag> > ();
}

static void _call_cbs_flags_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QFlags<Qt::ItemFlag> > ((QFlags<Qt::ItemFlag>)((QTransposeProxyModel_Adaptor *)cls)->cbs_flags_c2395_0 (arg1));
}

static void _set_callback_cbs_flags_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_flags_c2395_0 = cb;
}


// bool QTransposeProxyModel::hasChildren(const QModelIndex &parent)

static void _init_cbs_hasChildren_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_hasChildren_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->cbs_hasChildren_c2395_1 (arg1));
}

static void _set_callback_cbs_hasChildren_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_hasChildren_c2395_1 = cb;
}


// QVariant QTransposeProxyModel::headerData(int section, Qt::Orientation orientation, int role)

static void _init_cbs_headerData_c3231_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_cbs_headerData_c3231_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QTransposeProxyModel_Adaptor *)cls)->cbs_headerData_c3231_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_headerData_c3231_1 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_headerData_c3231_1 = cb;
}


// emitter void QTransposeProxyModel::headerDataChanged(Qt::Orientation orientation, int first, int last)

static void _init_emitter_headerDataChanged_3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_headerDataChanged_3231 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_headerDataChanged_3231 (arg1, arg2, arg3);
}


// QModelIndex QTransposeProxyModel::index(int row, int column, const QModelIndex &parent)

static void _init_cbs_index_c3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_index_c3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QTransposeProxyModel_Adaptor *)cls)->cbs_index_c3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_index_c3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_index_c3713_1 = cb;
}


// bool QTransposeProxyModel::insertColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_insertColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertColumns_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->cbs_insertColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_insertColumns_3713_1 = cb;
}


// bool QTransposeProxyModel::insertRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_insertRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertRows_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->cbs_insertRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_insertRows_3713_1 = cb;
}


// exposed bool QTransposeProxyModel::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_isSignalConnected_c2394 (arg1));
}


// QMap<int, QVariant> QTransposeProxyModel::itemData(const QModelIndex &index)

static void _init_cbs_itemData_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QMap<int, QVariant> > ();
}

static void _call_cbs_itemData_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QMap<int, QVariant> > ((QMap<int, QVariant>)((QTransposeProxyModel_Adaptor *)cls)->cbs_itemData_c2395_0 (arg1));
}

static void _set_callback_cbs_itemData_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_itemData_c2395_0 = cb;
}


// emitter void QTransposeProxyModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)

static void _init_emitter_layoutAboutToBeChanged_7947 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parents", true, "QList<QPersistentModelIndex>()");
  decl->add_arg<const QList<QPersistentModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemModel::NoLayoutChangeHint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_layoutAboutToBeChanged_7947 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QPersistentModelIndex> &arg1 = args ? gsi::arg_reader<const QList<QPersistentModelIndex> & >() (args, heap) : gsi::arg_maker<const QList<QPersistentModelIndex> & >() (QList<QPersistentModelIndex>(), heap);
  const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemModel::LayoutChangeHint>(heap, QAbstractItemModel::NoLayoutChangeHint), heap);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_layoutAboutToBeChanged_7947 (arg1, arg2);
}


// emitter void QTransposeProxyModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)

static void _init_emitter_layoutChanged_7947 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parents", true, "QList<QPersistentModelIndex>()");
  decl->add_arg<const QList<QPersistentModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemModel::NoLayoutChangeHint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_layoutChanged_7947 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QPersistentModelIndex> &arg1 = args ? gsi::arg_reader<const QList<QPersistentModelIndex> & >() (args, heap) : gsi::arg_maker<const QList<QPersistentModelIndex> & >() (QList<QPersistentModelIndex>(), heap);
  const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemModel::LayoutChangeHint>(heap, QAbstractItemModel::NoLayoutChangeHint), heap);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_layoutChanged_7947 (arg1, arg2);
}


// QModelIndex QTransposeProxyModel::mapFromSource(const QModelIndex &sourceIndex)

static void _init_cbs_mapFromSource_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_mapFromSource_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QTransposeProxyModel_Adaptor *)cls)->cbs_mapFromSource_c2395_0 (arg1));
}

static void _set_callback_cbs_mapFromSource_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_mapFromSource_c2395_0 = cb;
}


// QItemSelection QTransposeProxyModel::mapSelectionFromSource(const QItemSelection &selection)

static void _init_cbs_mapSelectionFromSource_c2727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  decl->set_return<QItemSelection > ();
}

static void _call_cbs_mapSelectionFromSource_c2727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = args.read<const QItemSelection & > (heap);
  ret.write<QItemSelection > ((QItemSelection)((QTransposeProxyModel_Adaptor *)cls)->cbs_mapSelectionFromSource_c2727_0 (arg1));
}

static void _set_callback_cbs_mapSelectionFromSource_c2727_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_mapSelectionFromSource_c2727_0 = cb;
}


// QItemSelection QTransposeProxyModel::mapSelectionToSource(const QItemSelection &selection)

static void _init_cbs_mapSelectionToSource_c2727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  decl->set_return<QItemSelection > ();
}

static void _call_cbs_mapSelectionToSource_c2727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = args.read<const QItemSelection & > (heap);
  ret.write<QItemSelection > ((QItemSelection)((QTransposeProxyModel_Adaptor *)cls)->cbs_mapSelectionToSource_c2727_0 (arg1));
}

static void _set_callback_cbs_mapSelectionToSource_c2727_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_mapSelectionToSource_c2727_0 = cb;
}


// QModelIndex QTransposeProxyModel::mapToSource(const QModelIndex &proxyIndex)

static void _init_cbs_mapToSource_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("proxyIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_mapToSource_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QTransposeProxyModel_Adaptor *)cls)->cbs_mapToSource_c2395_0 (arg1));
}

static void _set_callback_cbs_mapToSource_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_mapToSource_c2395_0 = cb;
}


// QList<QModelIndex> QTransposeProxyModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)

static void _init_cbs_match_c7932_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("hits");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags");
  decl->add_arg<QFlags<Qt::MatchFlag> > (argspec_4);
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_cbs_match_c7932_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  const QVariant &arg3 = args.read<const QVariant & > (heap);
  int arg4 = args.read<int > (heap);
  QFlags<Qt::MatchFlag> arg5 = args.read<QFlags<Qt::MatchFlag> > (heap);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QTransposeProxyModel_Adaptor *)cls)->cbs_match_c7932_2 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_match_c7932_2 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_match_c7932_2 = cb;
}


// QMimeData *QTransposeProxyModel::mimeData(const QList<QModelIndex> &indexes)

static void _init_cbs_mimeData_c3010_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_mimeData_c3010_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = args.read<const QList<QModelIndex> & > (heap);
  ret.write<QMimeData * > ((QMimeData *)((QTransposeProxyModel_Adaptor *)cls)->cbs_mimeData_c3010_0 (arg1));
}

static void _set_callback_cbs_mimeData_c3010_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_mimeData_c3010_0 = cb;
}


// QStringList QTransposeProxyModel::mimeTypes()

static void _init_cbs_mimeTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_cbs_mimeTypes_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QTransposeProxyModel_Adaptor *)cls)->cbs_mimeTypes_c0_0 ());
}

static void _set_callback_cbs_mimeTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_mimeTypes_c0_0 = cb;
}


// emitter void QTransposeProxyModel::modelAboutToBeReset()

static void _init_emitter_modelAboutToBeReset_3767 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_modelAboutToBeReset_3767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_modelAboutToBeReset_3767 ();
}


// emitter void QTransposeProxyModel::modelReset()

static void _init_emitter_modelReset_3767 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_modelReset_3767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_modelReset_3767 ();
}


// bool QTransposeProxyModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)

static void _init_cbs_moveColumns_6659_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceColumn");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("count");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationChild");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_moveColumns_6659_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  int arg5 = args.read<int > (heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->cbs_moveColumns_6659_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_moveColumns_6659_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_moveColumns_6659_0 = cb;
}


// bool QTransposeProxyModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)

static void _init_cbs_moveRows_6659_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceRow");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("count");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationChild");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_moveRows_6659_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  int arg5 = args.read<int > (heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->cbs_moveRows_6659_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_moveRows_6659_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_moveRows_6659_0 = cb;
}


// void QTransposeProxyModel::multiData(const QModelIndex &index, QModelRoleDataSpan roleDataSpan)

static void _init_cbs_multiData_c4483_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("roleDataSpan");
  decl->add_arg<QModelRoleDataSpan > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_multiData_c4483_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  QModelRoleDataSpan arg2 = args.read<QModelRoleDataSpan > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->cbs_multiData_c4483_0 (arg1, arg2);
}

static void _set_callback_cbs_multiData_c4483_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_multiData_c4483_0 = cb;
}


// emitter void QTransposeProxyModel::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_objectNameChanged_4567 (arg1);
}


// QModelIndex QTransposeProxyModel::parent(const QModelIndex &index)

static void _init_cbs_parent_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_parent_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QTransposeProxyModel_Adaptor *)cls)->cbs_parent_c2395_0 (arg1));
}

static void _set_callback_cbs_parent_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_parent_c2395_0 = cb;
}


// exposed QList<QModelIndex> QTransposeProxyModel::persistentIndexList()

static void _init_fp_persistentIndexList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_fp_persistentIndexList_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_persistentIndexList_c0 ());
}


// exposed int QTransposeProxyModel::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_receivers_c1731 (arg1));
}


// bool QTransposeProxyModel::removeColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_removeColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeColumns_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->cbs_removeColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_removeColumns_3713_1 = cb;
}


// bool QTransposeProxyModel::removeRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_removeRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeRows_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->cbs_removeRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_removeRows_3713_1 = cb;
}


// void QTransposeProxyModel::resetInternalData()

static void _init_cbs_resetInternalData_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_resetInternalData_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->cbs_resetInternalData_0_0 ();
}

static void _set_callback_cbs_resetInternalData_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_resetInternalData_0_0 = cb;
}


// void QTransposeProxyModel::revert()

static void _init_cbs_revert_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_revert_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->cbs_revert_0_0 ();
}

static void _set_callback_cbs_revert_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_revert_0_0 = cb;
}


// QHash<int, QByteArray> QTransposeProxyModel::roleNames()

static void _init_cbs_roleNames_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QHash<int, QByteArray> > ();
}

static void _call_cbs_roleNames_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QHash<int, QByteArray> > ((QHash<int, QByteArray>)((QTransposeProxyModel_Adaptor *)cls)->cbs_roleNames_c0_0 ());
}

static void _set_callback_cbs_roleNames_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_roleNames_c0_0 = cb;
}


// int QTransposeProxyModel::rowCount(const QModelIndex &parent)

static void _init_cbs_rowCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_rowCount_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<int > ((int)((QTransposeProxyModel_Adaptor *)cls)->cbs_rowCount_c2395_1 (arg1));
}

static void _set_callback_cbs_rowCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_rowCount_c2395_1 = cb;
}


// emitter void QTransposeProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsAboutToBeInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsAboutToBeInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_rowsAboutToBeInserted_7372 (arg1, arg2, arg3);
}


// emitter void QTransposeProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)

static void _init_emitter_rowsAboutToBeMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceStart");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceEnd");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationRow");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_rowsAboutToBeMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_rowsAboutToBeMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QTransposeProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsAboutToBeRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsAboutToBeRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_rowsAboutToBeRemoved_7372 (arg1, arg2, arg3);
}


// emitter void QTransposeProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_rowsInserted_7372 (arg1, arg2, arg3);
}


// emitter void QTransposeProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)

static void _init_emitter_rowsMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destination");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("row");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_rowsMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_rowsMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QTransposeProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_rowsRemoved_7372 (arg1, arg2, arg3);
}


// exposed QObject *QTransposeProxyModel::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_sender_c0 ());
}


// exposed int QTransposeProxyModel::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTransposeProxyModel_Adaptor *)cls)->fp_QTransposeProxyModel_senderSignalIndex_c0 ());
}


// bool QTransposeProxyModel::setData(const QModelIndex &index, const QVariant &value, int role)

static void _init_cbs_setData_5065_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_setData_5065_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->cbs_setData_5065_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_setData_5065_1 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_setData_5065_1 = cb;
}


// bool QTransposeProxyModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)

static void _init_cbs_setHeaderData_5242_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("role");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_setHeaderData_5242_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  const QVariant &arg3 = args.read<const QVariant & > (heap);
  int arg4 = args.read<int > (heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->cbs_setHeaderData_5242_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_setHeaderData_5242_1 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_setHeaderData_5242_1 = cb;
}


// bool QTransposeProxyModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)

static void _init_cbs_setItemData_5414_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("roles");
  decl->add_arg<const QMap<int, QVariant> & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_setItemData_5414_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QMap<int, QVariant> &arg2 = args.read<const QMap<int, QVariant> & > (heap);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->cbs_setItemData_5414_0 (arg1, arg2));
}

static void _set_callback_cbs_setItemData_5414_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_setItemData_5414_0 = cb;
}


// void QTransposeProxyModel::setSourceModel(QAbstractItemModel *newSourceModel)

static void _init_cbs_setSourceModel_2419_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newSourceModel");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSourceModel_2419_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = args.read<QAbstractItemModel * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->cbs_setSourceModel_2419_0 (arg1);
}

static void _set_callback_cbs_setSourceModel_2419_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_setSourceModel_2419_0 = cb;
}


// QModelIndex QTransposeProxyModel::sibling(int row, int column, const QModelIndex &idx)

static void _init_cbs_sibling_c3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("idx");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_sibling_c3713_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QTransposeProxyModel_Adaptor *)cls)->cbs_sibling_c3713_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_sibling_c3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_sibling_c3713_0 = cb;
}


// void QTransposeProxyModel::sort(int column, Qt::SortOrder order)

static void _init_cbs_sort_2340_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_sort_2340_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->cbs_sort_2340_1 (arg1, arg2);
}

static void _set_callback_cbs_sort_2340_1 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_sort_2340_1 = cb;
}


// emitter void QTransposeProxyModel::sourceModelChanged()

static void _init_emitter_sourceModelChanged_3914 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_sourceModelChanged_3914 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTransposeProxyModel_Adaptor *)cls)->emitter_QTransposeProxyModel_sourceModelChanged_3914 ();
}


// QSize QTransposeProxyModel::span(const QModelIndex &index)

static void _init_cbs_span_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_cbs_span_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QSize > ((QSize)((QTransposeProxyModel_Adaptor *)cls)->cbs_span_c2395_0 (arg1));
}

static void _set_callback_cbs_span_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_span_c2395_0 = cb;
}


// bool QTransposeProxyModel::submit()

static void _init_cbs_submit_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_submit_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTransposeProxyModel_Adaptor *)cls)->cbs_submit_0_0 ());
}

static void _set_callback_cbs_submit_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_submit_0_0 = cb;
}


// QFlags<Qt::DropAction> QTransposeProxyModel::supportedDragActions()

static void _init_cbs_supportedDragActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::DropAction> > ();
}

static void _call_cbs_supportedDragActions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::DropAction> > ((QFlags<Qt::DropAction>)((QTransposeProxyModel_Adaptor *)cls)->cbs_supportedDragActions_c0_0 ());
}

static void _set_callback_cbs_supportedDragActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_supportedDragActions_c0_0 = cb;
}


// QFlags<Qt::DropAction> QTransposeProxyModel::supportedDropActions()

static void _init_cbs_supportedDropActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::DropAction> > ();
}

static void _call_cbs_supportedDropActions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::DropAction> > ((QFlags<Qt::DropAction>)((QTransposeProxyModel_Adaptor *)cls)->cbs_supportedDropActions_c0_0 ());
}

static void _set_callback_cbs_supportedDropActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_supportedDropActions_c0_0 = cb;
}


// void QTransposeProxyModel::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransposeProxyModel_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QTransposeProxyModel_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QTransposeProxyModel> &qtdecl_QTransposeProxyModel ();

static gsi::Methods methods_QTransposeProxyModel_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTransposeProxyModel::QTransposeProxyModel(QObject *parent)\nThis method creates an object of class QTransposeProxyModel.", &_init_ctor_QTransposeProxyModel_Adaptor_1302, &_call_ctor_QTransposeProxyModel_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*beginInsertColumns", "@brief Method void QTransposeProxyModel::beginInsertColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertColumns_3713, &_call_fp_beginInsertColumns_3713);
  methods += new qt_gsi::GenericMethod ("*beginInsertRows", "@brief Method void QTransposeProxyModel::beginInsertRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertRows_3713, &_call_fp_beginInsertRows_3713);
  methods += new qt_gsi::GenericMethod ("*beginMoveColumns", "@brief Method bool QTransposeProxyModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveColumns_6659, &_call_fp_beginMoveColumns_6659);
  methods += new qt_gsi::GenericMethod ("*beginMoveRows", "@brief Method bool QTransposeProxyModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveRows_6659, &_call_fp_beginMoveRows_6659);
  methods += new qt_gsi::GenericMethod ("*beginRemoveColumns", "@brief Method void QTransposeProxyModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveColumns_3713, &_call_fp_beginRemoveColumns_3713);
  methods += new qt_gsi::GenericMethod ("*beginRemoveRows", "@brief Method void QTransposeProxyModel::beginRemoveRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveRows_3713, &_call_fp_beginRemoveRows_3713);
  methods += new qt_gsi::GenericMethod ("*beginResetModel", "@brief Method void QTransposeProxyModel::beginResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginResetModel_0, &_call_fp_beginResetModel_0);
  methods += new qt_gsi::GenericMethod ("buddy", "@brief Virtual method QModelIndex QTransposeProxyModel::buddy(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0);
  methods += new qt_gsi::GenericMethod ("buddy", "@hide", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0, &_set_callback_cbs_buddy_c2395_0);
  methods += new qt_gsi::GenericMethod ("canDropMimeData", "@brief Virtual method bool QTransposeProxyModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canDropMimeData_c7425_0, &_call_cbs_canDropMimeData_c7425_0);
  methods += new qt_gsi::GenericMethod ("canDropMimeData", "@hide", true, &_init_cbs_canDropMimeData_c7425_0, &_call_cbs_canDropMimeData_c7425_0, &_set_callback_cbs_canDropMimeData_c7425_0);
  methods += new qt_gsi::GenericMethod ("canFetchMore", "@brief Virtual method bool QTransposeProxyModel::canFetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0);
  methods += new qt_gsi::GenericMethod ("canFetchMore", "@hide", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0, &_set_callback_cbs_canFetchMore_c2395_0);
  methods += new qt_gsi::GenericMethod ("*changePersistentIndex", "@brief Method void QTransposeProxyModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndex_4682, &_call_fp_changePersistentIndex_4682);
  methods += new qt_gsi::GenericMethod ("*changePersistentIndexList", "@brief Method void QTransposeProxyModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndexList_5912, &_call_fp_changePersistentIndexList_5912);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QTransposeProxyModel::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("clearItemData", "@brief Virtual method bool QTransposeProxyModel::clearItemData(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_clearItemData_2395_0, &_call_cbs_clearItemData_2395_0);
  methods += new qt_gsi::GenericMethod ("clearItemData", "@hide", false, &_init_cbs_clearItemData_2395_0, &_call_cbs_clearItemData_2395_0, &_set_callback_cbs_clearItemData_2395_0);
  methods += new qt_gsi::GenericMethod ("columnCount", "@brief Virtual method int QTransposeProxyModel::columnCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("columnCount", "@hide", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1, &_set_callback_cbs_columnCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("emit_columnsAboutToBeInserted", "@brief Emitter for signal void QTransposeProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsAboutToBeInserted_7372, &_call_emitter_columnsAboutToBeInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_columnsAboutToBeMoved", "@brief Emitter for signal void QTransposeProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)\nCall this method to emit this signal.", false, &_init_emitter_columnsAboutToBeMoved_10318, &_call_emitter_columnsAboutToBeMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_columnsAboutToBeRemoved", "@brief Emitter for signal void QTransposeProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsAboutToBeRemoved_7372, &_call_emitter_columnsAboutToBeRemoved_7372);
  methods += new qt_gsi::GenericMethod ("emit_columnsInserted", "@brief Emitter for signal void QTransposeProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsInserted_7372, &_call_emitter_columnsInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_columnsMoved", "@brief Emitter for signal void QTransposeProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)\nCall this method to emit this signal.", false, &_init_emitter_columnsMoved_10318, &_call_emitter_columnsMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_columnsRemoved", "@brief Emitter for signal void QTransposeProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsRemoved_7372, &_call_emitter_columnsRemoved_7372);
  methods += new qt_gsi::GenericMethod ("*createIndex", "@brief Method QModelIndex QTransposeProxyModel::createIndex(int row, int column, const void *data)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c3069, &_call_fp_createIndex_c3069);
  methods += new qt_gsi::GenericMethod ("*createIndex", "@brief Method QModelIndex QTransposeProxyModel::createIndex(int row, int column, quintptr id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2657, &_call_fp_createIndex_c2657);
  methods += new qt_gsi::GenericMethod ("*createSourceIndex", "@brief Method QModelIndex QTransposeProxyModel::createSourceIndex(int row, int col, void *internalPtr)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createSourceIndex_c2374, &_call_fp_createSourceIndex_c2374);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QTransposeProxyModel::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("data", "@brief Virtual method QVariant QTransposeProxyModel::data(const QModelIndex &proxyIndex, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1);
  methods += new qt_gsi::GenericMethod ("data", "@hide", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1, &_set_callback_cbs_data_c3054_1);
  methods += new qt_gsi::GenericMethod ("emit_dataChanged", "@brief Emitter for signal void QTransposeProxyModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)\nCall this method to emit this signal.", false, &_init_emitter_dataChanged_6833, &_call_emitter_dataChanged_6833);
  methods += new qt_gsi::GenericMethod ("*decodeData", "@brief Method bool QTransposeProxyModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_decodeData_5302, &_call_fp_decodeData_5302);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QTransposeProxyModel::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QTransposeProxyModel::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@brief Virtual method bool QTransposeProxyModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@hide", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0, &_set_callback_cbs_dropMimeData_7425_0);
  methods += new qt_gsi::GenericMethod ("*encodeData", "@brief Method void QTransposeProxyModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_encodeData_c4599, &_call_fp_encodeData_c4599);
  methods += new qt_gsi::GenericMethod ("*endInsertColumns", "@brief Method void QTransposeProxyModel::endInsertColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertColumns_0, &_call_fp_endInsertColumns_0);
  methods += new qt_gsi::GenericMethod ("*endInsertRows", "@brief Method void QTransposeProxyModel::endInsertRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertRows_0, &_call_fp_endInsertRows_0);
  methods += new qt_gsi::GenericMethod ("*endMoveColumns", "@brief Method void QTransposeProxyModel::endMoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveColumns_0, &_call_fp_endMoveColumns_0);
  methods += new qt_gsi::GenericMethod ("*endMoveRows", "@brief Method void QTransposeProxyModel::endMoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveRows_0, &_call_fp_endMoveRows_0);
  methods += new qt_gsi::GenericMethod ("*endRemoveColumns", "@brief Method void QTransposeProxyModel::endRemoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveColumns_0, &_call_fp_endRemoveColumns_0);
  methods += new qt_gsi::GenericMethod ("*endRemoveRows", "@brief Method void QTransposeProxyModel::endRemoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveRows_0, &_call_fp_endRemoveRows_0);
  methods += new qt_gsi::GenericMethod ("*endResetModel", "@brief Method void QTransposeProxyModel::endResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endResetModel_0, &_call_fp_endResetModel_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QTransposeProxyModel::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QTransposeProxyModel::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("fetchMore", "@brief Virtual method void QTransposeProxyModel::fetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0);
  methods += new qt_gsi::GenericMethod ("fetchMore", "@hide", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0, &_set_callback_cbs_fetchMore_2395_0);
  methods += new qt_gsi::GenericMethod ("flags", "@brief Virtual method QFlags<Qt::ItemFlag> QTransposeProxyModel::flags(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0);
  methods += new qt_gsi::GenericMethod ("flags", "@hide", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0, &_set_callback_cbs_flags_c2395_0);
  methods += new qt_gsi::GenericMethod ("hasChildren", "@brief Virtual method bool QTransposeProxyModel::hasChildren(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasChildren_c2395_1, &_call_cbs_hasChildren_c2395_1);
  methods += new qt_gsi::GenericMethod ("hasChildren", "@hide", true, &_init_cbs_hasChildren_c2395_1, &_call_cbs_hasChildren_c2395_1, &_set_callback_cbs_hasChildren_c2395_1);
  methods += new qt_gsi::GenericMethod ("headerData", "@brief Virtual method QVariant QTransposeProxyModel::headerData(int section, Qt::Orientation orientation, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1);
  methods += new qt_gsi::GenericMethod ("headerData", "@hide", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1, &_set_callback_cbs_headerData_c3231_1);
  methods += new qt_gsi::GenericMethod ("emit_headerDataChanged", "@brief Emitter for signal void QTransposeProxyModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_headerDataChanged_3231, &_call_emitter_headerDataChanged_3231);
  methods += new qt_gsi::GenericMethod ("index", "@brief Virtual method QModelIndex QTransposeProxyModel::index(int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1);
  methods += new qt_gsi::GenericMethod ("index", "@hide", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1, &_set_callback_cbs_index_c3713_1);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@brief Virtual method bool QTransposeProxyModel::insertColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@hide", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1, &_set_callback_cbs_insertColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("insertRows", "@brief Virtual method bool QTransposeProxyModel::insertRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1);
  methods += new qt_gsi::GenericMethod ("insertRows", "@hide", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1, &_set_callback_cbs_insertRows_3713_1);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QTransposeProxyModel::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("itemData", "@brief Virtual method QMap<int, QVariant> QTransposeProxyModel::itemData(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemData_c2395_0, &_call_cbs_itemData_c2395_0);
  methods += new qt_gsi::GenericMethod ("itemData", "@hide", true, &_init_cbs_itemData_c2395_0, &_call_cbs_itemData_c2395_0, &_set_callback_cbs_itemData_c2395_0);
  methods += new qt_gsi::GenericMethod ("emit_layoutAboutToBeChanged", "@brief Emitter for signal void QTransposeProxyModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nCall this method to emit this signal.", false, &_init_emitter_layoutAboutToBeChanged_7947, &_call_emitter_layoutAboutToBeChanged_7947);
  methods += new qt_gsi::GenericMethod ("emit_layoutChanged", "@brief Emitter for signal void QTransposeProxyModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nCall this method to emit this signal.", false, &_init_emitter_layoutChanged_7947, &_call_emitter_layoutChanged_7947);
  methods += new qt_gsi::GenericMethod ("mapFromSource", "@brief Virtual method QModelIndex QTransposeProxyModel::mapFromSource(const QModelIndex &sourceIndex)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mapFromSource_c2395_0, &_call_cbs_mapFromSource_c2395_0);
  methods += new qt_gsi::GenericMethod ("mapFromSource", "@hide", true, &_init_cbs_mapFromSource_c2395_0, &_call_cbs_mapFromSource_c2395_0, &_set_callback_cbs_mapFromSource_c2395_0);
  methods += new qt_gsi::GenericMethod ("mapSelectionFromSource", "@brief Virtual method QItemSelection QTransposeProxyModel::mapSelectionFromSource(const QItemSelection &selection)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mapSelectionFromSource_c2727_0, &_call_cbs_mapSelectionFromSource_c2727_0);
  methods += new qt_gsi::GenericMethod ("mapSelectionFromSource", "@hide", true, &_init_cbs_mapSelectionFromSource_c2727_0, &_call_cbs_mapSelectionFromSource_c2727_0, &_set_callback_cbs_mapSelectionFromSource_c2727_0);
  methods += new qt_gsi::GenericMethod ("mapSelectionToSource", "@brief Virtual method QItemSelection QTransposeProxyModel::mapSelectionToSource(const QItemSelection &selection)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mapSelectionToSource_c2727_0, &_call_cbs_mapSelectionToSource_c2727_0);
  methods += new qt_gsi::GenericMethod ("mapSelectionToSource", "@hide", true, &_init_cbs_mapSelectionToSource_c2727_0, &_call_cbs_mapSelectionToSource_c2727_0, &_set_callback_cbs_mapSelectionToSource_c2727_0);
  methods += new qt_gsi::GenericMethod ("mapToSource", "@brief Virtual method QModelIndex QTransposeProxyModel::mapToSource(const QModelIndex &proxyIndex)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mapToSource_c2395_0, &_call_cbs_mapToSource_c2395_0);
  methods += new qt_gsi::GenericMethod ("mapToSource", "@hide", true, &_init_cbs_mapToSource_c2395_0, &_call_cbs_mapToSource_c2395_0, &_set_callback_cbs_mapToSource_c2395_0);
  methods += new qt_gsi::GenericMethod ("match", "@brief Virtual method QList<QModelIndex> QTransposeProxyModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2);
  methods += new qt_gsi::GenericMethod ("match", "@hide", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2, &_set_callback_cbs_match_c7932_2);
  methods += new qt_gsi::GenericMethod ("mimeData", "@brief Virtual method QMimeData *QTransposeProxyModel::mimeData(const QList<QModelIndex> &indexes)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0);
  methods += new qt_gsi::GenericMethod ("mimeData", "@hide", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0, &_set_callback_cbs_mimeData_c3010_0);
  methods += new qt_gsi::GenericMethod ("mimeTypes", "@brief Virtual method QStringList QTransposeProxyModel::mimeTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("mimeTypes", "@hide", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0, &_set_callback_cbs_mimeTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_modelAboutToBeReset", "@brief Emitter for signal void QTransposeProxyModel::modelAboutToBeReset()\nCall this method to emit this signal.", false, &_init_emitter_modelAboutToBeReset_3767, &_call_emitter_modelAboutToBeReset_3767);
  methods += new qt_gsi::GenericMethod ("emit_modelReset", "@brief Emitter for signal void QTransposeProxyModel::modelReset()\nCall this method to emit this signal.", false, &_init_emitter_modelReset_3767, &_call_emitter_modelReset_3767);
  methods += new qt_gsi::GenericMethod ("moveColumns", "@brief Virtual method bool QTransposeProxyModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveColumns_6659_0, &_call_cbs_moveColumns_6659_0);
  methods += new qt_gsi::GenericMethod ("moveColumns", "@hide", false, &_init_cbs_moveColumns_6659_0, &_call_cbs_moveColumns_6659_0, &_set_callback_cbs_moveColumns_6659_0);
  methods += new qt_gsi::GenericMethod ("moveRows", "@brief Virtual method bool QTransposeProxyModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveRows_6659_0, &_call_cbs_moveRows_6659_0);
  methods += new qt_gsi::GenericMethod ("moveRows", "@hide", false, &_init_cbs_moveRows_6659_0, &_call_cbs_moveRows_6659_0, &_set_callback_cbs_moveRows_6659_0);
  methods += new qt_gsi::GenericMethod ("multiData", "@brief Virtual method void QTransposeProxyModel::multiData(const QModelIndex &index, QModelRoleDataSpan roleDataSpan)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_multiData_c4483_0, &_call_cbs_multiData_c4483_0);
  methods += new qt_gsi::GenericMethod ("multiData", "@hide", true, &_init_cbs_multiData_c4483_0, &_call_cbs_multiData_c4483_0, &_set_callback_cbs_multiData_c4483_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QTransposeProxyModel::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("parent", "@brief Virtual method QModelIndex QTransposeProxyModel::parent(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_parent_c2395_0, &_call_cbs_parent_c2395_0);
  methods += new qt_gsi::GenericMethod ("parent", "@hide", true, &_init_cbs_parent_c2395_0, &_call_cbs_parent_c2395_0, &_set_callback_cbs_parent_c2395_0);
  methods += new qt_gsi::GenericMethod ("*persistentIndexList", "@brief Method QList<QModelIndex> QTransposeProxyModel::persistentIndexList()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_persistentIndexList_c0, &_call_fp_persistentIndexList_c0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QTransposeProxyModel::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@brief Virtual method bool QTransposeProxyModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@hide", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1, &_set_callback_cbs_removeColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("removeRows", "@brief Virtual method bool QTransposeProxyModel::removeRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1);
  methods += new qt_gsi::GenericMethod ("removeRows", "@hide", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1, &_set_callback_cbs_removeRows_3713_1);
  methods += new qt_gsi::GenericMethod ("*resetInternalData", "@brief Virtual method void QTransposeProxyModel::resetInternalData()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resetInternalData_0_0, &_call_cbs_resetInternalData_0_0);
  methods += new qt_gsi::GenericMethod ("*resetInternalData", "@hide", false, &_init_cbs_resetInternalData_0_0, &_call_cbs_resetInternalData_0_0, &_set_callback_cbs_resetInternalData_0_0);
  methods += new qt_gsi::GenericMethod ("revert", "@brief Virtual method void QTransposeProxyModel::revert()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0);
  methods += new qt_gsi::GenericMethod ("revert", "@hide", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0, &_set_callback_cbs_revert_0_0);
  methods += new qt_gsi::GenericMethod ("roleNames", "@brief Virtual method QHash<int, QByteArray> QTransposeProxyModel::roleNames()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_roleNames_c0_0, &_call_cbs_roleNames_c0_0);
  methods += new qt_gsi::GenericMethod ("roleNames", "@hide", true, &_init_cbs_roleNames_c0_0, &_call_cbs_roleNames_c0_0, &_set_callback_cbs_roleNames_c0_0);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Virtual method int QTransposeProxyModel::rowCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("rowCount", "@hide", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1, &_set_callback_cbs_rowCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("emit_rowsAboutToBeInserted", "@brief Emitter for signal void QTransposeProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsAboutToBeInserted_7372, &_call_emitter_rowsAboutToBeInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_rowsAboutToBeMoved", "@brief Emitter for signal void QTransposeProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)\nCall this method to emit this signal.", false, &_init_emitter_rowsAboutToBeMoved_10318, &_call_emitter_rowsAboutToBeMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_rowsAboutToBeRemoved", "@brief Emitter for signal void QTransposeProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsAboutToBeRemoved_7372, &_call_emitter_rowsAboutToBeRemoved_7372);
  methods += new qt_gsi::GenericMethod ("emit_rowsInserted", "@brief Emitter for signal void QTransposeProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsInserted_7372, &_call_emitter_rowsInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_rowsMoved", "@brief Emitter for signal void QTransposeProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)\nCall this method to emit this signal.", false, &_init_emitter_rowsMoved_10318, &_call_emitter_rowsMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_rowsRemoved", "@brief Emitter for signal void QTransposeProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsRemoved_7372, &_call_emitter_rowsRemoved_7372);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QTransposeProxyModel::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QTransposeProxyModel::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setData", "@brief Virtual method bool QTransposeProxyModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1);
  methods += new qt_gsi::GenericMethod ("setData", "@hide", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1, &_set_callback_cbs_setData_5065_1);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@brief Virtual method bool QTransposeProxyModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@hide", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1, &_set_callback_cbs_setHeaderData_5242_1);
  methods += new qt_gsi::GenericMethod ("setItemData", "@brief Virtual method bool QTransposeProxyModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setItemData_5414_0, &_call_cbs_setItemData_5414_0);
  methods += new qt_gsi::GenericMethod ("setItemData", "@hide", false, &_init_cbs_setItemData_5414_0, &_call_cbs_setItemData_5414_0, &_set_callback_cbs_setItemData_5414_0);
  methods += new qt_gsi::GenericMethod ("setSourceModel", "@brief Virtual method void QTransposeProxyModel::setSourceModel(QAbstractItemModel *newSourceModel)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSourceModel_2419_0, &_call_cbs_setSourceModel_2419_0);
  methods += new qt_gsi::GenericMethod ("setSourceModel", "@hide", false, &_init_cbs_setSourceModel_2419_0, &_call_cbs_setSourceModel_2419_0, &_set_callback_cbs_setSourceModel_2419_0);
  methods += new qt_gsi::GenericMethod ("sibling", "@brief Virtual method QModelIndex QTransposeProxyModel::sibling(int row, int column, const QModelIndex &idx)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sibling_c3713_0, &_call_cbs_sibling_c3713_0);
  methods += new qt_gsi::GenericMethod ("sibling", "@hide", true, &_init_cbs_sibling_c3713_0, &_call_cbs_sibling_c3713_0, &_set_callback_cbs_sibling_c3713_0);
  methods += new qt_gsi::GenericMethod ("sort", "@brief Virtual method void QTransposeProxyModel::sort(int column, Qt::SortOrder order)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1);
  methods += new qt_gsi::GenericMethod ("sort", "@hide", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1, &_set_callback_cbs_sort_2340_1);
  methods += new qt_gsi::GenericMethod ("emit_sourceModelChanged", "@brief Emitter for signal void QTransposeProxyModel::sourceModelChanged()\nCall this method to emit this signal.", false, &_init_emitter_sourceModelChanged_3914, &_call_emitter_sourceModelChanged_3914);
  methods += new qt_gsi::GenericMethod ("span", "@brief Virtual method QSize QTransposeProxyModel::span(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0);
  methods += new qt_gsi::GenericMethod ("span", "@hide", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0, &_set_callback_cbs_span_c2395_0);
  methods += new qt_gsi::GenericMethod ("submit", "@brief Virtual method bool QTransposeProxyModel::submit()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0);
  methods += new qt_gsi::GenericMethod ("submit", "@hide", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0, &_set_callback_cbs_submit_0_0);
  methods += new qt_gsi::GenericMethod ("supportedDragActions", "@brief Virtual method QFlags<Qt::DropAction> QTransposeProxyModel::supportedDragActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDragActions_c0_0, &_call_cbs_supportedDragActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDragActions", "@hide", true, &_init_cbs_supportedDragActions_c0_0, &_call_cbs_supportedDragActions_c0_0, &_set_callback_cbs_supportedDragActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDropActions", "@brief Virtual method QFlags<Qt::DropAction> QTransposeProxyModel::supportedDropActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDropActions", "@hide", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0, &_set_callback_cbs_supportedDropActions_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QTransposeProxyModel::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QTransposeProxyModel_Adaptor> decl_QTransposeProxyModel_Adaptor (qtdecl_QTransposeProxyModel (), "QtCore", "QTransposeProxyModel",
  methods_QTransposeProxyModel_Adaptor (),
  "@qt\n@brief Binding of QTransposeProxyModel");

}

