
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractEventDispatcher.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAbstractEventDispatcher>
#include <QAbstractNativeEventFilter>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QSocketNotifier>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractEventDispatcher

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAbstractEventDispatcher::staticMetaObject);
}


// void QAbstractEventDispatcher::closingDown()


static void _init_f_closingDown_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_closingDown_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher *)cls)->closingDown ();
}


// bool QAbstractEventDispatcher::filterNativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)


static void _init_f_filterNativeEvent_6949 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<QIntegerForSizeof<void *>::Signed * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_filterNativeEvent_6949 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  void *arg2 = gsi::arg_reader<void * >() (args, heap);
  QIntegerForSizeof<void *>::Signed *arg3 = gsi::arg_reader<QIntegerForSizeof<void *>::Signed * >() (args, heap);
  ret.write<bool > ((bool)((QAbstractEventDispatcher *)cls)->filterNativeEvent (arg1, arg2, arg3));
}


// void QAbstractEventDispatcher::installNativeEventFilter(QAbstractNativeEventFilter *filterObj)


static void _init_f_installNativeEventFilter_3266 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filterObj");
  decl->add_arg<QAbstractNativeEventFilter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_installNativeEventFilter_3266 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractNativeEventFilter *arg1 = gsi::arg_reader<QAbstractNativeEventFilter * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher *)cls)->installNativeEventFilter (arg1);
}


// void QAbstractEventDispatcher::interrupt()


static void _init_f_interrupt_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_interrupt_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher *)cls)->interrupt ();
}


// bool QAbstractEventDispatcher::processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags)


static void _init_f_processEvents_3995 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<QEventLoop::ProcessEventsFlag> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_processEvents_3995 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QEventLoop::ProcessEventsFlag> arg1 = gsi::arg_reader<QFlags<QEventLoop::ProcessEventsFlag> >() (args, heap);
  ret.write<bool > ((bool)((QAbstractEventDispatcher *)cls)->processEvents (arg1));
}


// void QAbstractEventDispatcher::registerSocketNotifier(QSocketNotifier *notifier)


static void _init_f_registerSocketNotifier_2152 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("notifier");
  decl->add_arg<QSocketNotifier * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_registerSocketNotifier_2152 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QSocketNotifier *arg1 = gsi::arg_reader<QSocketNotifier * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher *)cls)->registerSocketNotifier (arg1);
}


// int QAbstractEventDispatcher::registerTimer(qint64 interval, Qt::TimerType timerType, QObject *object)


static void _init_f_registerTimer_3752 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("interval");
  decl->add_arg<qint64 > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("timerType");
  decl->add_arg<const qt_gsi::Converter<Qt::TimerType>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("object");
  decl->add_arg<QObject * > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_registerTimer_3752 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  const qt_gsi::Converter<Qt::TimerType>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::TimerType>::target_type & >() (args, heap);
  QObject *arg3 = gsi::arg_reader<QObject * >() (args, heap);
  ret.write<int > ((int)((QAbstractEventDispatcher *)cls)->registerTimer (arg1, qt_gsi::QtToCppAdaptor<Qt::TimerType>(arg2).cref(), arg3));
}


// void QAbstractEventDispatcher::registerTimer(int timerId, qint64 interval, Qt::TimerType timerType, QObject *object)


static void _init_f_registerTimer_4411 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("timerId");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("interval");
  decl->add_arg<qint64 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("timerType");
  decl->add_arg<const qt_gsi::Converter<Qt::TimerType>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("object");
  decl->add_arg<QObject * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_registerTimer_4411 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  qint64 arg2 = gsi::arg_reader<qint64 >() (args, heap);
  const qt_gsi::Converter<Qt::TimerType>::target_type & arg3 = gsi::arg_reader<const qt_gsi::Converter<Qt::TimerType>::target_type & >() (args, heap);
  QObject *arg4 = gsi::arg_reader<QObject * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher *)cls)->registerTimer (arg1, arg2, qt_gsi::QtToCppAdaptor<Qt::TimerType>(arg3).cref(), arg4);
}


// QList<QAbstractEventDispatcher::TimerInfo> QAbstractEventDispatcher::registeredTimers(QObject *object)


static void _init_f_registeredTimers_c1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<QList<QAbstractEventDispatcher::TimerInfo> > ();
}

static void _call_f_registeredTimers_c1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  ret.write<QList<QAbstractEventDispatcher::TimerInfo> > ((QList<QAbstractEventDispatcher::TimerInfo>)((QAbstractEventDispatcher *)cls)->registeredTimers (arg1));
}


// int QAbstractEventDispatcher::remainingTime(int timerId)


static void _init_f_remainingTime_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("timerId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_remainingTime_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QAbstractEventDispatcher *)cls)->remainingTime (arg1));
}


// void QAbstractEventDispatcher::removeNativeEventFilter(QAbstractNativeEventFilter *filterObj)


static void _init_f_removeNativeEventFilter_3266 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filterObj");
  decl->add_arg<QAbstractNativeEventFilter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeNativeEventFilter_3266 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractNativeEventFilter *arg1 = gsi::arg_reader<QAbstractNativeEventFilter * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher *)cls)->removeNativeEventFilter (arg1);
}


// void QAbstractEventDispatcher::startingUp()


static void _init_f_startingUp_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_startingUp_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher *)cls)->startingUp ();
}


// void QAbstractEventDispatcher::unregisterSocketNotifier(QSocketNotifier *notifier)


static void _init_f_unregisterSocketNotifier_2152 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("notifier");
  decl->add_arg<QSocketNotifier * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_unregisterSocketNotifier_2152 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QSocketNotifier *arg1 = gsi::arg_reader<QSocketNotifier * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher *)cls)->unregisterSocketNotifier (arg1);
}


// bool QAbstractEventDispatcher::unregisterTimer(int timerId)


static void _init_f_unregisterTimer_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("timerId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_unregisterTimer_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QAbstractEventDispatcher *)cls)->unregisterTimer (arg1));
}


// bool QAbstractEventDispatcher::unregisterTimers(QObject *object)


static void _init_f_unregisterTimers_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_unregisterTimers_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  ret.write<bool > ((bool)((QAbstractEventDispatcher *)cls)->unregisterTimers (arg1));
}


// void QAbstractEventDispatcher::wakeUp()


static void _init_f_wakeUp_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_wakeUp_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher *)cls)->wakeUp ();
}


// static QAbstractEventDispatcher *QAbstractEventDispatcher::instance(QThread *thread)


static void _init_f_instance_1303 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("thread", true, "nullptr");
  decl->add_arg<QThread * > (argspec_0);
  decl->set_return<QAbstractEventDispatcher * > ();
}

static void _call_f_instance_1303 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QThread *arg1 = args ? gsi::arg_reader<QThread * >() (args, heap) : gsi::arg_maker<QThread * >() (nullptr, heap);
  ret.write<QAbstractEventDispatcher * > ((QAbstractEventDispatcher *)QAbstractEventDispatcher::instance (arg1));
}


// static QString QAbstractEventDispatcher::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractEventDispatcher::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QAbstractEventDispatcher () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("closingDown", "@brief Method void QAbstractEventDispatcher::closingDown()\n", false, &_init_f_closingDown_0, &_call_f_closingDown_0);
  methods += new qt_gsi::GenericMethod ("filterNativeEvent", "@brief Method bool QAbstractEventDispatcher::filterNativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)\n", false, &_init_f_filterNativeEvent_6949, &_call_f_filterNativeEvent_6949);
  methods += new qt_gsi::GenericMethod ("installNativeEventFilter", "@brief Method void QAbstractEventDispatcher::installNativeEventFilter(QAbstractNativeEventFilter *filterObj)\n", false, &_init_f_installNativeEventFilter_3266, &_call_f_installNativeEventFilter_3266);
  methods += new qt_gsi::GenericMethod ("interrupt", "@brief Method void QAbstractEventDispatcher::interrupt()\n", false, &_init_f_interrupt_0, &_call_f_interrupt_0);
  methods += new qt_gsi::GenericMethod ("processEvents", "@brief Method bool QAbstractEventDispatcher::processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags)\n", false, &_init_f_processEvents_3995, &_call_f_processEvents_3995);
  methods += new qt_gsi::GenericMethod ("registerSocketNotifier", "@brief Method void QAbstractEventDispatcher::registerSocketNotifier(QSocketNotifier *notifier)\n", false, &_init_f_registerSocketNotifier_2152, &_call_f_registerSocketNotifier_2152);
  methods += new qt_gsi::GenericMethod ("registerTimer", "@brief Method int QAbstractEventDispatcher::registerTimer(qint64 interval, Qt::TimerType timerType, QObject *object)\n", false, &_init_f_registerTimer_3752, &_call_f_registerTimer_3752);
  methods += new qt_gsi::GenericMethod ("registerTimer", "@brief Method void QAbstractEventDispatcher::registerTimer(int timerId, qint64 interval, Qt::TimerType timerType, QObject *object)\n", false, &_init_f_registerTimer_4411, &_call_f_registerTimer_4411);
  methods += new qt_gsi::GenericMethod ("registeredTimers", "@brief Method QList<QAbstractEventDispatcher::TimerInfo> QAbstractEventDispatcher::registeredTimers(QObject *object)\n", true, &_init_f_registeredTimers_c1302, &_call_f_registeredTimers_c1302);
  methods += new qt_gsi::GenericMethod ("remainingTime", "@brief Method int QAbstractEventDispatcher::remainingTime(int timerId)\n", false, &_init_f_remainingTime_767, &_call_f_remainingTime_767);
  methods += new qt_gsi::GenericMethod ("removeNativeEventFilter", "@brief Method void QAbstractEventDispatcher::removeNativeEventFilter(QAbstractNativeEventFilter *filterObj)\n", false, &_init_f_removeNativeEventFilter_3266, &_call_f_removeNativeEventFilter_3266);
  methods += new qt_gsi::GenericMethod ("startingUp", "@brief Method void QAbstractEventDispatcher::startingUp()\n", false, &_init_f_startingUp_0, &_call_f_startingUp_0);
  methods += new qt_gsi::GenericMethod ("unregisterSocketNotifier", "@brief Method void QAbstractEventDispatcher::unregisterSocketNotifier(QSocketNotifier *notifier)\n", false, &_init_f_unregisterSocketNotifier_2152, &_call_f_unregisterSocketNotifier_2152);
  methods += new qt_gsi::GenericMethod ("unregisterTimer", "@brief Method bool QAbstractEventDispatcher::unregisterTimer(int timerId)\n", false, &_init_f_unregisterTimer_767, &_call_f_unregisterTimer_767);
  methods += new qt_gsi::GenericMethod ("unregisterTimers", "@brief Method bool QAbstractEventDispatcher::unregisterTimers(QObject *object)\n", false, &_init_f_unregisterTimers_1302, &_call_f_unregisterTimers_1302);
  methods += new qt_gsi::GenericMethod ("wakeUp", "@brief Method void QAbstractEventDispatcher::wakeUp()\n", false, &_init_f_wakeUp_0, &_call_f_wakeUp_0);
  methods += gsi::qt_signal ("aboutToBlock()", "aboutToBlock", "@brief Signal declaration for QAbstractEventDispatcher::aboutToBlock()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("awake()", "awake", "@brief Signal declaration for QAbstractEventDispatcher::awake()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QAbstractEventDispatcher::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QAbstractEventDispatcher::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("instance", "@brief Static method QAbstractEventDispatcher *QAbstractEventDispatcher::instance(QThread *thread)\nThis method is static and can be called without an instance.", &_init_f_instance_1303, &_call_f_instance_1303);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractEventDispatcher::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QAbstractEventDispatcher> decl_QAbstractEventDispatcher (qtdecl_QObject (), "QtCore", "QAbstractEventDispatcher_Native",
  methods_QAbstractEventDispatcher (),
  "@hide\n@alias QAbstractEventDispatcher");

GSI_QTCORE_PUBLIC gsi::Class<QAbstractEventDispatcher> &qtdecl_QAbstractEventDispatcher () { return decl_QAbstractEventDispatcher; }

}


class QAbstractEventDispatcher_Adaptor : public QAbstractEventDispatcher, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAbstractEventDispatcher_Adaptor();

  //  [adaptor ctor] QAbstractEventDispatcher::QAbstractEventDispatcher(QObject *parent)
  QAbstractEventDispatcher_Adaptor() : QAbstractEventDispatcher()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAbstractEventDispatcher::QAbstractEventDispatcher(QObject *parent)
  QAbstractEventDispatcher_Adaptor(QObject *parent) : QAbstractEventDispatcher(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QAbstractEventDispatcher::isSignalConnected(const QMetaMethod &signal)
  bool fp_QAbstractEventDispatcher_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QAbstractEventDispatcher::isSignalConnected(signal);
  }

  //  [expose] int QAbstractEventDispatcher::receivers(const char *signal)
  int fp_QAbstractEventDispatcher_receivers_c1731 (const char *signal) const {
    return QAbstractEventDispatcher::receivers(signal);
  }

  //  [expose] QObject *QAbstractEventDispatcher::sender()
  QObject * fp_QAbstractEventDispatcher_sender_c0 () const {
    return QAbstractEventDispatcher::sender();
  }

  //  [expose] int QAbstractEventDispatcher::senderSignalIndex()
  int fp_QAbstractEventDispatcher_senderSignalIndex_c0 () const {
    return QAbstractEventDispatcher::senderSignalIndex();
  }

  //  [emitter impl] void QAbstractEventDispatcher::aboutToBlock()
  void emitter_QAbstractEventDispatcher_aboutToBlock_0()
  {
    emit QAbstractEventDispatcher::aboutToBlock();
  }

  //  [emitter impl] void QAbstractEventDispatcher::awake()
  void emitter_QAbstractEventDispatcher_awake_0()
  {
    emit QAbstractEventDispatcher::awake();
  }

  //  [adaptor impl] void QAbstractEventDispatcher::closingDown()
  void cbs_closingDown_0_0()
  {
    QAbstractEventDispatcher::closingDown();
  }

  virtual void closingDown()
  {
    if (cb_closingDown_0_0.can_issue()) {
      cb_closingDown_0_0.issue<QAbstractEventDispatcher_Adaptor>(&QAbstractEventDispatcher_Adaptor::cbs_closingDown_0_0);
    } else {
      QAbstractEventDispatcher::closingDown();
    }
  }

  //  [emitter impl] void QAbstractEventDispatcher::destroyed(QObject *)
  void emitter_QAbstractEventDispatcher_destroyed_1302(QObject *arg1)
  {
    emit QAbstractEventDispatcher::destroyed(arg1);
  }

  //  [adaptor impl] bool QAbstractEventDispatcher::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QAbstractEventDispatcher::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAbstractEventDispatcher_Adaptor, bool, QEvent *>(&QAbstractEventDispatcher_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QAbstractEventDispatcher::event(_event);
    }
  }

  //  [adaptor impl] bool QAbstractEventDispatcher::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QAbstractEventDispatcher::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAbstractEventDispatcher_Adaptor, bool, QObject *, QEvent *>(&QAbstractEventDispatcher_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QAbstractEventDispatcher::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QAbstractEventDispatcher::interrupt()
  void cbs_interrupt_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("interrupt");
  }

  virtual void interrupt()
  {
    if (cb_interrupt_0_0.can_issue()) {
      cb_interrupt_0_0.issue<QAbstractEventDispatcher_Adaptor>(&QAbstractEventDispatcher_Adaptor::cbs_interrupt_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("interrupt");
    }
  }

  //  [emitter impl] void QAbstractEventDispatcher::objectNameChanged(const QString &objectName)
  void emitter_QAbstractEventDispatcher_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QAbstractEventDispatcher::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] bool QAbstractEventDispatcher::processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags)
  bool cbs_processEvents_3995_0(QFlags<QEventLoop::ProcessEventsFlag> flags)
  {
    __SUPPRESS_UNUSED_WARNING (flags);
    throw qt_gsi::AbstractMethodCalledException("processEvents");
  }

  virtual bool processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags)
  {
    if (cb_processEvents_3995_0.can_issue()) {
      return cb_processEvents_3995_0.issue<QAbstractEventDispatcher_Adaptor, bool, QFlags<QEventLoop::ProcessEventsFlag> >(&QAbstractEventDispatcher_Adaptor::cbs_processEvents_3995_0, flags);
    } else {
      throw qt_gsi::AbstractMethodCalledException("processEvents");
    }
  }

  //  [adaptor impl] void QAbstractEventDispatcher::registerSocketNotifier(QSocketNotifier *notifier)
  void cbs_registerSocketNotifier_2152_0(QSocketNotifier *notifier)
  {
    __SUPPRESS_UNUSED_WARNING (notifier);
    throw qt_gsi::AbstractMethodCalledException("registerSocketNotifier");
  }

  virtual void registerSocketNotifier(QSocketNotifier *notifier)
  {
    if (cb_registerSocketNotifier_2152_0.can_issue()) {
      cb_registerSocketNotifier_2152_0.issue<QAbstractEventDispatcher_Adaptor, QSocketNotifier *>(&QAbstractEventDispatcher_Adaptor::cbs_registerSocketNotifier_2152_0, notifier);
    } else {
      throw qt_gsi::AbstractMethodCalledException("registerSocketNotifier");
    }
  }

  //  [adaptor impl] void QAbstractEventDispatcher::registerTimer(int timerId, qint64 interval, Qt::TimerType timerType, QObject *object)
  void cbs_registerTimer_4411_0(int timerId, qint64 interval, const qt_gsi::Converter<Qt::TimerType>::target_type & timerType, QObject *object)
  {
    __SUPPRESS_UNUSED_WARNING (timerId);
    __SUPPRESS_UNUSED_WARNING (interval);
    __SUPPRESS_UNUSED_WARNING (timerType);
    __SUPPRESS_UNUSED_WARNING (object);
    throw qt_gsi::AbstractMethodCalledException("registerTimer");
  }

  virtual void registerTimer(int timerId, qint64 interval, Qt::TimerType timerType, QObject *object)
  {
    if (cb_registerTimer_4411_0.can_issue()) {
      cb_registerTimer_4411_0.issue<QAbstractEventDispatcher_Adaptor, int, qint64, const qt_gsi::Converter<Qt::TimerType>::target_type &, QObject *>(&QAbstractEventDispatcher_Adaptor::cbs_registerTimer_4411_0, timerId, interval, qt_gsi::CppToQtAdaptor<Qt::TimerType>(timerType), object);
    } else {
      throw qt_gsi::AbstractMethodCalledException("registerTimer");
    }
  }

  //  [adaptor impl] QList<QAbstractEventDispatcher::TimerInfo> QAbstractEventDispatcher::registeredTimers(QObject *object)
  QList<QAbstractEventDispatcher::TimerInfo> cbs_registeredTimers_c1302_0(QObject *object) const
  {
    __SUPPRESS_UNUSED_WARNING (object);
    throw qt_gsi::AbstractMethodCalledException("registeredTimers");
  }

  virtual QList<QAbstractEventDispatcher::TimerInfo> registeredTimers(QObject *object) const
  {
    if (cb_registeredTimers_c1302_0.can_issue()) {
      return cb_registeredTimers_c1302_0.issue<QAbstractEventDispatcher_Adaptor, QList<QAbstractEventDispatcher::TimerInfo>, QObject *>(&QAbstractEventDispatcher_Adaptor::cbs_registeredTimers_c1302_0, object);
    } else {
      throw qt_gsi::AbstractMethodCalledException("registeredTimers");
    }
  }

  //  [adaptor impl] int QAbstractEventDispatcher::remainingTime(int timerId)
  int cbs_remainingTime_767_0(int timerId)
  {
    __SUPPRESS_UNUSED_WARNING (timerId);
    throw qt_gsi::AbstractMethodCalledException("remainingTime");
  }

  virtual int remainingTime(int timerId)
  {
    if (cb_remainingTime_767_0.can_issue()) {
      return cb_remainingTime_767_0.issue<QAbstractEventDispatcher_Adaptor, int, int>(&QAbstractEventDispatcher_Adaptor::cbs_remainingTime_767_0, timerId);
    } else {
      throw qt_gsi::AbstractMethodCalledException("remainingTime");
    }
  }

  //  [adaptor impl] void QAbstractEventDispatcher::startingUp()
  void cbs_startingUp_0_0()
  {
    QAbstractEventDispatcher::startingUp();
  }

  virtual void startingUp()
  {
    if (cb_startingUp_0_0.can_issue()) {
      cb_startingUp_0_0.issue<QAbstractEventDispatcher_Adaptor>(&QAbstractEventDispatcher_Adaptor::cbs_startingUp_0_0);
    } else {
      QAbstractEventDispatcher::startingUp();
    }
  }

  //  [adaptor impl] void QAbstractEventDispatcher::unregisterSocketNotifier(QSocketNotifier *notifier)
  void cbs_unregisterSocketNotifier_2152_0(QSocketNotifier *notifier)
  {
    __SUPPRESS_UNUSED_WARNING (notifier);
    throw qt_gsi::AbstractMethodCalledException("unregisterSocketNotifier");
  }

  virtual void unregisterSocketNotifier(QSocketNotifier *notifier)
  {
    if (cb_unregisterSocketNotifier_2152_0.can_issue()) {
      cb_unregisterSocketNotifier_2152_0.issue<QAbstractEventDispatcher_Adaptor, QSocketNotifier *>(&QAbstractEventDispatcher_Adaptor::cbs_unregisterSocketNotifier_2152_0, notifier);
    } else {
      throw qt_gsi::AbstractMethodCalledException("unregisterSocketNotifier");
    }
  }

  //  [adaptor impl] bool QAbstractEventDispatcher::unregisterTimer(int timerId)
  bool cbs_unregisterTimer_767_0(int timerId)
  {
    __SUPPRESS_UNUSED_WARNING (timerId);
    throw qt_gsi::AbstractMethodCalledException("unregisterTimer");
  }

  virtual bool unregisterTimer(int timerId)
  {
    if (cb_unregisterTimer_767_0.can_issue()) {
      return cb_unregisterTimer_767_0.issue<QAbstractEventDispatcher_Adaptor, bool, int>(&QAbstractEventDispatcher_Adaptor::cbs_unregisterTimer_767_0, timerId);
    } else {
      throw qt_gsi::AbstractMethodCalledException("unregisterTimer");
    }
  }

  //  [adaptor impl] bool QAbstractEventDispatcher::unregisterTimers(QObject *object)
  bool cbs_unregisterTimers_1302_0(QObject *object)
  {
    __SUPPRESS_UNUSED_WARNING (object);
    throw qt_gsi::AbstractMethodCalledException("unregisterTimers");
  }

  virtual bool unregisterTimers(QObject *object)
  {
    if (cb_unregisterTimers_1302_0.can_issue()) {
      return cb_unregisterTimers_1302_0.issue<QAbstractEventDispatcher_Adaptor, bool, QObject *>(&QAbstractEventDispatcher_Adaptor::cbs_unregisterTimers_1302_0, object);
    } else {
      throw qt_gsi::AbstractMethodCalledException("unregisterTimers");
    }
  }

  //  [adaptor impl] void QAbstractEventDispatcher::wakeUp()
  void cbs_wakeUp_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("wakeUp");
  }

  virtual void wakeUp()
  {
    if (cb_wakeUp_0_0.can_issue()) {
      cb_wakeUp_0_0.issue<QAbstractEventDispatcher_Adaptor>(&QAbstractEventDispatcher_Adaptor::cbs_wakeUp_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("wakeUp");
    }
  }

  //  [adaptor impl] void QAbstractEventDispatcher::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QAbstractEventDispatcher::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAbstractEventDispatcher_Adaptor, QChildEvent *>(&QAbstractEventDispatcher_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QAbstractEventDispatcher::childEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractEventDispatcher::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QAbstractEventDispatcher::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAbstractEventDispatcher_Adaptor, QEvent *>(&QAbstractEventDispatcher_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QAbstractEventDispatcher::customEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractEventDispatcher::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QAbstractEventDispatcher::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QAbstractEventDispatcher_Adaptor, const QMetaMethod &>(&QAbstractEventDispatcher_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QAbstractEventDispatcher::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAbstractEventDispatcher::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QAbstractEventDispatcher::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAbstractEventDispatcher_Adaptor, QTimerEvent *>(&QAbstractEventDispatcher_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QAbstractEventDispatcher::timerEvent(event);
    }
  }

  gsi::Callback cb_closingDown_0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_interrupt_0_0;
  gsi::Callback cb_processEvents_3995_0;
  gsi::Callback cb_registerSocketNotifier_2152_0;
  gsi::Callback cb_registerTimer_4411_0;
  gsi::Callback cb_registeredTimers_c1302_0;
  gsi::Callback cb_remainingTime_767_0;
  gsi::Callback cb_startingUp_0_0;
  gsi::Callback cb_unregisterSocketNotifier_2152_0;
  gsi::Callback cb_unregisterTimer_767_0;
  gsi::Callback cb_unregisterTimers_1302_0;
  gsi::Callback cb_wakeUp_0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAbstractEventDispatcher_Adaptor::~QAbstractEventDispatcher_Adaptor() { }

//  Constructor QAbstractEventDispatcher::QAbstractEventDispatcher(QObject *parent) (adaptor class)

static void _init_ctor_QAbstractEventDispatcher_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QAbstractEventDispatcher_Adaptor> ();
}

static void _call_ctor_QAbstractEventDispatcher_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QAbstractEventDispatcher_Adaptor *> (new QAbstractEventDispatcher_Adaptor (arg1));
}


// emitter void QAbstractEventDispatcher::aboutToBlock()

static void _init_emitter_aboutToBlock_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_aboutToBlock_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QAbstractEventDispatcher_Adaptor *)cls)->emitter_QAbstractEventDispatcher_aboutToBlock_0 ();
}


// emitter void QAbstractEventDispatcher::awake()

static void _init_emitter_awake_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_awake_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QAbstractEventDispatcher_Adaptor *)cls)->emitter_QAbstractEventDispatcher_awake_0 ();
}


// void QAbstractEventDispatcher::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractEventDispatcher_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QAbstractEventDispatcher::closingDown()

static void _init_cbs_closingDown_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_closingDown_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher_Adaptor *)cls)->cbs_closingDown_0_0 ();
}

static void _set_callback_cbs_closingDown_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractEventDispatcher_Adaptor *)cls)->cb_closingDown_0_0 = cb;
}


// void QAbstractEventDispatcher::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractEventDispatcher_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QAbstractEventDispatcher::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QAbstractEventDispatcher_Adaptor *)cls)->emitter_QAbstractEventDispatcher_destroyed_1302 (arg1);
}


// void QAbstractEventDispatcher::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractEventDispatcher_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QAbstractEventDispatcher::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractEventDispatcher_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractEventDispatcher_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QAbstractEventDispatcher::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractEventDispatcher_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractEventDispatcher_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QAbstractEventDispatcher::interrupt()

static void _init_cbs_interrupt_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_interrupt_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher_Adaptor *)cls)->cbs_interrupt_0_0 ();
}

static void _set_callback_cbs_interrupt_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractEventDispatcher_Adaptor *)cls)->cb_interrupt_0_0 = cb;
}


// exposed bool QAbstractEventDispatcher::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractEventDispatcher_Adaptor *)cls)->fp_QAbstractEventDispatcher_isSignalConnected_c2394 (arg1));
}


// emitter void QAbstractEventDispatcher::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QAbstractEventDispatcher_Adaptor *)cls)->emitter_QAbstractEventDispatcher_objectNameChanged_4567 (arg1);
}


// bool QAbstractEventDispatcher::processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags)

static void _init_cbs_processEvents_3995_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<QEventLoop::ProcessEventsFlag> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_processEvents_3995_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QEventLoop::ProcessEventsFlag> arg1 = args.read<QFlags<QEventLoop::ProcessEventsFlag> > (heap);
  ret.write<bool > ((bool)((QAbstractEventDispatcher_Adaptor *)cls)->cbs_processEvents_3995_0 (arg1));
}

static void _set_callback_cbs_processEvents_3995_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractEventDispatcher_Adaptor *)cls)->cb_processEvents_3995_0 = cb;
}


// exposed int QAbstractEventDispatcher::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QAbstractEventDispatcher_Adaptor *)cls)->fp_QAbstractEventDispatcher_receivers_c1731 (arg1));
}


// void QAbstractEventDispatcher::registerSocketNotifier(QSocketNotifier *notifier)

static void _init_cbs_registerSocketNotifier_2152_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("notifier");
  decl->add_arg<QSocketNotifier * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_registerSocketNotifier_2152_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QSocketNotifier *arg1 = args.read<QSocketNotifier * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher_Adaptor *)cls)->cbs_registerSocketNotifier_2152_0 (arg1);
}

static void _set_callback_cbs_registerSocketNotifier_2152_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractEventDispatcher_Adaptor *)cls)->cb_registerSocketNotifier_2152_0 = cb;
}


// void QAbstractEventDispatcher::registerTimer(int timerId, qint64 interval, Qt::TimerType timerType, QObject *object)

static void _init_cbs_registerTimer_4411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("timerId");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("interval");
  decl->add_arg<qint64 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("timerType");
  decl->add_arg<const qt_gsi::Converter<Qt::TimerType>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("object");
  decl->add_arg<QObject * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_registerTimer_4411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  qint64 arg2 = args.read<qint64 > (heap);
  const qt_gsi::Converter<Qt::TimerType>::target_type & arg3 = args.read<const qt_gsi::Converter<Qt::TimerType>::target_type & > (heap);
  QObject *arg4 = args.read<QObject * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher_Adaptor *)cls)->cbs_registerTimer_4411_0 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_registerTimer_4411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractEventDispatcher_Adaptor *)cls)->cb_registerTimer_4411_0 = cb;
}


// QList<QAbstractEventDispatcher::TimerInfo> QAbstractEventDispatcher::registeredTimers(QObject *object)

static void _init_cbs_registeredTimers_c1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<QList<QAbstractEventDispatcher::TimerInfo> > ();
}

static void _call_cbs_registeredTimers_c1302_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  ret.write<QList<QAbstractEventDispatcher::TimerInfo> > ((QList<QAbstractEventDispatcher::TimerInfo>)((QAbstractEventDispatcher_Adaptor *)cls)->cbs_registeredTimers_c1302_0 (arg1));
}

static void _set_callback_cbs_registeredTimers_c1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractEventDispatcher_Adaptor *)cls)->cb_registeredTimers_c1302_0 = cb;
}


// int QAbstractEventDispatcher::remainingTime(int timerId)

static void _init_cbs_remainingTime_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("timerId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_remainingTime_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QAbstractEventDispatcher_Adaptor *)cls)->cbs_remainingTime_767_0 (arg1));
}

static void _set_callback_cbs_remainingTime_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractEventDispatcher_Adaptor *)cls)->cb_remainingTime_767_0 = cb;
}


// exposed QObject *QAbstractEventDispatcher::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAbstractEventDispatcher_Adaptor *)cls)->fp_QAbstractEventDispatcher_sender_c0 ());
}


// exposed int QAbstractEventDispatcher::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractEventDispatcher_Adaptor *)cls)->fp_QAbstractEventDispatcher_senderSignalIndex_c0 ());
}


// void QAbstractEventDispatcher::startingUp()

static void _init_cbs_startingUp_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_startingUp_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher_Adaptor *)cls)->cbs_startingUp_0_0 ();
}

static void _set_callback_cbs_startingUp_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractEventDispatcher_Adaptor *)cls)->cb_startingUp_0_0 = cb;
}


// void QAbstractEventDispatcher::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractEventDispatcher_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QAbstractEventDispatcher::unregisterSocketNotifier(QSocketNotifier *notifier)

static void _init_cbs_unregisterSocketNotifier_2152_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("notifier");
  decl->add_arg<QSocketNotifier * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_unregisterSocketNotifier_2152_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QSocketNotifier *arg1 = args.read<QSocketNotifier * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher_Adaptor *)cls)->cbs_unregisterSocketNotifier_2152_0 (arg1);
}

static void _set_callback_cbs_unregisterSocketNotifier_2152_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractEventDispatcher_Adaptor *)cls)->cb_unregisterSocketNotifier_2152_0 = cb;
}


// bool QAbstractEventDispatcher::unregisterTimer(int timerId)

static void _init_cbs_unregisterTimer_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("timerId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_unregisterTimer_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QAbstractEventDispatcher_Adaptor *)cls)->cbs_unregisterTimer_767_0 (arg1));
}

static void _set_callback_cbs_unregisterTimer_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractEventDispatcher_Adaptor *)cls)->cb_unregisterTimer_767_0 = cb;
}


// bool QAbstractEventDispatcher::unregisterTimers(QObject *object)

static void _init_cbs_unregisterTimers_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_unregisterTimers_1302_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  ret.write<bool > ((bool)((QAbstractEventDispatcher_Adaptor *)cls)->cbs_unregisterTimers_1302_0 (arg1));
}

static void _set_callback_cbs_unregisterTimers_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractEventDispatcher_Adaptor *)cls)->cb_unregisterTimers_1302_0 = cb;
}


// void QAbstractEventDispatcher::wakeUp()

static void _init_cbs_wakeUp_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_wakeUp_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractEventDispatcher_Adaptor *)cls)->cbs_wakeUp_0_0 ();
}

static void _set_callback_cbs_wakeUp_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractEventDispatcher_Adaptor *)cls)->cb_wakeUp_0_0 = cb;
}


namespace gsi
{

gsi::Class<QAbstractEventDispatcher> &qtdecl_QAbstractEventDispatcher ();

static gsi::Methods methods_QAbstractEventDispatcher_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractEventDispatcher::QAbstractEventDispatcher(QObject *parent)\nThis method creates an object of class QAbstractEventDispatcher.", &_init_ctor_QAbstractEventDispatcher_Adaptor_1302, &_call_ctor_QAbstractEventDispatcher_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("emit_aboutToBlock", "@brief Emitter for signal void QAbstractEventDispatcher::aboutToBlock()\nCall this method to emit this signal.", false, &_init_emitter_aboutToBlock_0, &_call_emitter_aboutToBlock_0);
  methods += new qt_gsi::GenericMethod ("emit_awake", "@brief Emitter for signal void QAbstractEventDispatcher::awake()\nCall this method to emit this signal.", false, &_init_emitter_awake_0, &_call_emitter_awake_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAbstractEventDispatcher::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("closingDown", "@brief Virtual method void QAbstractEventDispatcher::closingDown()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closingDown_0_0, &_call_cbs_closingDown_0_0);
  methods += new qt_gsi::GenericMethod ("closingDown", "@hide", false, &_init_cbs_closingDown_0_0, &_call_cbs_closingDown_0_0, &_set_callback_cbs_closingDown_0_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAbstractEventDispatcher::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QAbstractEventDispatcher::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAbstractEventDispatcher::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QAbstractEventDispatcher::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAbstractEventDispatcher::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("interrupt", "@brief Virtual method void QAbstractEventDispatcher::interrupt()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_interrupt_0_0, &_call_cbs_interrupt_0_0);
  methods += new qt_gsi::GenericMethod ("interrupt", "@hide", false, &_init_cbs_interrupt_0_0, &_call_cbs_interrupt_0_0, &_set_callback_cbs_interrupt_0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QAbstractEventDispatcher::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QAbstractEventDispatcher::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("processEvents", "@brief Virtual method bool QAbstractEventDispatcher::processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_processEvents_3995_0, &_call_cbs_processEvents_3995_0);
  methods += new qt_gsi::GenericMethod ("processEvents", "@hide", false, &_init_cbs_processEvents_3995_0, &_call_cbs_processEvents_3995_0, &_set_callback_cbs_processEvents_3995_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QAbstractEventDispatcher::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("registerSocketNotifier", "@brief Virtual method void QAbstractEventDispatcher::registerSocketNotifier(QSocketNotifier *notifier)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_registerSocketNotifier_2152_0, &_call_cbs_registerSocketNotifier_2152_0);
  methods += new qt_gsi::GenericMethod ("registerSocketNotifier", "@hide", false, &_init_cbs_registerSocketNotifier_2152_0, &_call_cbs_registerSocketNotifier_2152_0, &_set_callback_cbs_registerSocketNotifier_2152_0);
  methods += new qt_gsi::GenericMethod ("registerTimer", "@brief Virtual method void QAbstractEventDispatcher::registerTimer(int timerId, qint64 interval, Qt::TimerType timerType, QObject *object)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_registerTimer_4411_0, &_call_cbs_registerTimer_4411_0);
  methods += new qt_gsi::GenericMethod ("registerTimer", "@hide", false, &_init_cbs_registerTimer_4411_0, &_call_cbs_registerTimer_4411_0, &_set_callback_cbs_registerTimer_4411_0);
  methods += new qt_gsi::GenericMethod ("registeredTimers", "@brief Virtual method QList<QAbstractEventDispatcher::TimerInfo> QAbstractEventDispatcher::registeredTimers(QObject *object)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_registeredTimers_c1302_0, &_call_cbs_registeredTimers_c1302_0);
  methods += new qt_gsi::GenericMethod ("registeredTimers", "@hide", true, &_init_cbs_registeredTimers_c1302_0, &_call_cbs_registeredTimers_c1302_0, &_set_callback_cbs_registeredTimers_c1302_0);
  methods += new qt_gsi::GenericMethod ("remainingTime", "@brief Virtual method int QAbstractEventDispatcher::remainingTime(int timerId)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_remainingTime_767_0, &_call_cbs_remainingTime_767_0);
  methods += new qt_gsi::GenericMethod ("remainingTime", "@hide", false, &_init_cbs_remainingTime_767_0, &_call_cbs_remainingTime_767_0, &_set_callback_cbs_remainingTime_767_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QAbstractEventDispatcher::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QAbstractEventDispatcher::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("startingUp", "@brief Virtual method void QAbstractEventDispatcher::startingUp()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_startingUp_0_0, &_call_cbs_startingUp_0_0);
  methods += new qt_gsi::GenericMethod ("startingUp", "@hide", false, &_init_cbs_startingUp_0_0, &_call_cbs_startingUp_0_0, &_set_callback_cbs_startingUp_0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAbstractEventDispatcher::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("unregisterSocketNotifier", "@brief Virtual method void QAbstractEventDispatcher::unregisterSocketNotifier(QSocketNotifier *notifier)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unregisterSocketNotifier_2152_0, &_call_cbs_unregisterSocketNotifier_2152_0);
  methods += new qt_gsi::GenericMethod ("unregisterSocketNotifier", "@hide", false, &_init_cbs_unregisterSocketNotifier_2152_0, &_call_cbs_unregisterSocketNotifier_2152_0, &_set_callback_cbs_unregisterSocketNotifier_2152_0);
  methods += new qt_gsi::GenericMethod ("unregisterTimer", "@brief Virtual method bool QAbstractEventDispatcher::unregisterTimer(int timerId)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unregisterTimer_767_0, &_call_cbs_unregisterTimer_767_0);
  methods += new qt_gsi::GenericMethod ("unregisterTimer", "@hide", false, &_init_cbs_unregisterTimer_767_0, &_call_cbs_unregisterTimer_767_0, &_set_callback_cbs_unregisterTimer_767_0);
  methods += new qt_gsi::GenericMethod ("unregisterTimers", "@brief Virtual method bool QAbstractEventDispatcher::unregisterTimers(QObject *object)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unregisterTimers_1302_0, &_call_cbs_unregisterTimers_1302_0);
  methods += new qt_gsi::GenericMethod ("unregisterTimers", "@hide", false, &_init_cbs_unregisterTimers_1302_0, &_call_cbs_unregisterTimers_1302_0, &_set_callback_cbs_unregisterTimers_1302_0);
  methods += new qt_gsi::GenericMethod ("wakeUp", "@brief Virtual method void QAbstractEventDispatcher::wakeUp()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wakeUp_0_0, &_call_cbs_wakeUp_0_0);
  methods += new qt_gsi::GenericMethod ("wakeUp", "@hide", false, &_init_cbs_wakeUp_0_0, &_call_cbs_wakeUp_0_0, &_set_callback_cbs_wakeUp_0_0);
  return methods;
}

gsi::Class<QAbstractEventDispatcher_Adaptor> decl_QAbstractEventDispatcher_Adaptor (qtdecl_QAbstractEventDispatcher (), "QtCore", "QAbstractEventDispatcher",
  methods_QAbstractEventDispatcher_Adaptor (),
  "@qt\n@brief Binding of QAbstractEventDispatcher");

}

