
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsBlurEffect.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QGraphicsBlurEffect>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QPainter>
#include <QPixmap>
#include <QPoint>
#include <QRectF>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsBlurEffect

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsBlurEffect::staticMetaObject);
}


// QFlags<QGraphicsBlurEffect::BlurHint> QGraphicsBlurEffect::blurHints()


static void _init_f_blurHints_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QGraphicsBlurEffect::BlurHint> > ();
}

static void _call_f_blurHints_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QGraphicsBlurEffect::BlurHint> > ((QFlags<QGraphicsBlurEffect::BlurHint>)((QGraphicsBlurEffect *)cls)->blurHints ());
}


// double QGraphicsBlurEffect::blurRadius()


static void _init_f_blurRadius_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_blurRadius_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsBlurEffect *)cls)->blurRadius ());
}


// QRectF QGraphicsBlurEffect::boundingRectFor(const QRectF &rect)


static void _init_f_boundingRectFor_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRectFor_c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QGraphicsBlurEffect *)cls)->boundingRectFor (arg1));
}


// void QGraphicsBlurEffect::setBlurHints(QFlags<QGraphicsBlurEffect::BlurHint> hints)


static void _init_f_setBlurHints_3948 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hints");
  decl->add_arg<QFlags<QGraphicsBlurEffect::BlurHint> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBlurHints_3948 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QGraphicsBlurEffect::BlurHint> arg1 = gsi::arg_reader<QFlags<QGraphicsBlurEffect::BlurHint> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsBlurEffect *)cls)->setBlurHints (arg1);
}


// void QGraphicsBlurEffect::setBlurRadius(double blurRadius)


static void _init_f_setBlurRadius_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("blurRadius");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBlurRadius_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsBlurEffect *)cls)->setBlurRadius (arg1);
}


// static QString QGraphicsBlurEffect::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QGraphicsBlurEffect::tr (arg1, arg2, arg3));
}


// static QString QGraphicsBlurEffect::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QGraphicsBlurEffect::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QGraphicsBlurEffect () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":blurHints", "@brief Method QFlags<QGraphicsBlurEffect::BlurHint> QGraphicsBlurEffect::blurHints()\n", true, &_init_f_blurHints_c0, &_call_f_blurHints_c0);
  methods += new qt_gsi::GenericMethod (":blurRadius", "@brief Method double QGraphicsBlurEffect::blurRadius()\n", true, &_init_f_blurRadius_c0, &_call_f_blurRadius_c0);
  methods += new qt_gsi::GenericMethod ("boundingRectFor", "@brief Method QRectF QGraphicsBlurEffect::boundingRectFor(const QRectF &rect)\nThis is a reimplementation of QGraphicsEffect::boundingRectFor", true, &_init_f_boundingRectFor_c1862, &_call_f_boundingRectFor_c1862);
  methods += new qt_gsi::GenericMethod ("setBlurHints|blurHints=", "@brief Method void QGraphicsBlurEffect::setBlurHints(QFlags<QGraphicsBlurEffect::BlurHint> hints)\n", false, &_init_f_setBlurHints_3948, &_call_f_setBlurHints_3948);
  methods += new qt_gsi::GenericMethod ("setBlurRadius|blurRadius=", "@brief Method void QGraphicsBlurEffect::setBlurRadius(double blurRadius)\n", false, &_init_f_setBlurRadius_1071, &_call_f_setBlurRadius_1071);
  methods += gsi::qt_signal<QFlags<QGraphicsBlurEffect::BlurHint> > ("blurHintsChanged(QFlags<QGraphicsBlurEffect::BlurHint>)", "blurHintsChanged", gsi::arg("hints"), "@brief Signal declaration for QGraphicsBlurEffect::blurHintsChanged(QFlags<QGraphicsBlurEffect::BlurHint> hints)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("blurRadiusChanged(double)", "blurRadiusChanged", gsi::arg("blurRadius"), "@brief Signal declaration for QGraphicsBlurEffect::blurRadiusChanged(double blurRadius)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QGraphicsBlurEffect::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("enabledChanged(bool)", "enabledChanged", gsi::arg("enabled"), "@brief Signal declaration for QGraphicsBlurEffect::enabledChanged(bool enabled)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QGraphicsBlurEffect::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsBlurEffect::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsBlurEffect::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QGraphicsEffect> &qtdecl_QGraphicsEffect ();

qt_gsi::QtNativeClass<QGraphicsBlurEffect> decl_QGraphicsBlurEffect (qtdecl_QGraphicsEffect (), "QtWidgets", "QGraphicsBlurEffect_Native",
  methods_QGraphicsBlurEffect (),
  "@hide\n@alias QGraphicsBlurEffect");

GSI_QTWIDGETS_PUBLIC gsi::Class<QGraphicsBlurEffect> &qtdecl_QGraphicsBlurEffect () { return decl_QGraphicsBlurEffect; }

}


class QGraphicsBlurEffect_Adaptor : public QGraphicsBlurEffect, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsBlurEffect_Adaptor();

  //  [adaptor ctor] QGraphicsBlurEffect::QGraphicsBlurEffect(QObject *parent)
  QGraphicsBlurEffect_Adaptor() : QGraphicsBlurEffect()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsBlurEffect::QGraphicsBlurEffect(QObject *parent)
  QGraphicsBlurEffect_Adaptor(QObject *parent) : QGraphicsBlurEffect(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QGraphicsBlurEffect::drawSource(QPainter *painter)
  void fp_QGraphicsBlurEffect_drawSource_1426 (QPainter *painter) {
    QGraphicsBlurEffect::drawSource(painter);
  }

  //  [expose] bool QGraphicsBlurEffect::isSignalConnected(const QMetaMethod &signal)
  bool fp_QGraphicsBlurEffect_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QGraphicsBlurEffect::isSignalConnected(signal);
  }

  //  [expose] int QGraphicsBlurEffect::receivers(const char *signal)
  int fp_QGraphicsBlurEffect_receivers_c1731 (const char *signal) const {
    return QGraphicsBlurEffect::receivers(signal);
  }

  //  [expose] QObject *QGraphicsBlurEffect::sender()
  QObject * fp_QGraphicsBlurEffect_sender_c0 () const {
    return QGraphicsBlurEffect::sender();
  }

  //  [expose] int QGraphicsBlurEffect::senderSignalIndex()
  int fp_QGraphicsBlurEffect_senderSignalIndex_c0 () const {
    return QGraphicsBlurEffect::senderSignalIndex();
  }

  //  [expose] QRectF QGraphicsBlurEffect::sourceBoundingRect(Qt::CoordinateSystem system)
  QRectF fp_QGraphicsBlurEffect_sourceBoundingRect_c2426 (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & system) const {
    return QGraphicsBlurEffect::sourceBoundingRect(qt_gsi::QtToCppAdaptor<Qt::CoordinateSystem>(system).cref());
  }

  //  [expose] bool QGraphicsBlurEffect::sourceIsPixmap()
  bool fp_QGraphicsBlurEffect_sourceIsPixmap_c0 () const {
    return QGraphicsBlurEffect::sourceIsPixmap();
  }

  //  [expose] QPixmap QGraphicsBlurEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)
  QPixmap fp_QGraphicsBlurEffect_sourcePixmap_c6763 (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & system, QPoint *offset, const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & mode) const {
    return QGraphicsBlurEffect::sourcePixmap(qt_gsi::QtToCppAdaptor<Qt::CoordinateSystem>(system).cref(), offset, qt_gsi::QtToCppAdaptor<QGraphicsEffect::PixmapPadMode>(mode).cref());
  }

  //  [expose] void QGraphicsBlurEffect::updateBoundingRect()
  void fp_QGraphicsBlurEffect_updateBoundingRect_0 () {
    QGraphicsBlurEffect::updateBoundingRect();
  }

  //  [emitter impl] void QGraphicsBlurEffect::blurHintsChanged(QFlags<QGraphicsBlurEffect::BlurHint> hints)
  void emitter_QGraphicsBlurEffect_blurHintsChanged_3948(QFlags<QGraphicsBlurEffect::BlurHint> hints)
  {
    emit QGraphicsBlurEffect::blurHintsChanged(hints);
  }

  //  [emitter impl] void QGraphicsBlurEffect::blurRadiusChanged(double blurRadius)
  void emitter_QGraphicsBlurEffect_blurRadiusChanged_1071(double blurRadius)
  {
    emit QGraphicsBlurEffect::blurRadiusChanged(blurRadius);
  }

  //  [adaptor impl] QRectF QGraphicsBlurEffect::boundingRectFor(const QRectF &rect)
  QRectF cbs_boundingRectFor_c1862_0(const QRectF &rect) const
  {
    return QGraphicsBlurEffect::boundingRectFor(rect);
  }

  virtual QRectF boundingRectFor(const QRectF &rect) const
  {
    if (cb_boundingRectFor_c1862_0.can_issue()) {
      return cb_boundingRectFor_c1862_0.issue<QGraphicsBlurEffect_Adaptor, QRectF, const QRectF &>(&QGraphicsBlurEffect_Adaptor::cbs_boundingRectFor_c1862_0, rect);
    } else {
      return QGraphicsBlurEffect::boundingRectFor(rect);
    }
  }

  //  [emitter impl] void QGraphicsBlurEffect::destroyed(QObject *)
  void emitter_QGraphicsBlurEffect_destroyed_1302(QObject *arg1)
  {
    emit QGraphicsBlurEffect::destroyed(arg1);
  }

  //  [emitter impl] void QGraphicsBlurEffect::enabledChanged(bool enabled)
  void emitter_QGraphicsBlurEffect_enabledChanged_864(bool enabled)
  {
    emit QGraphicsBlurEffect::enabledChanged(enabled);
  }

  //  [adaptor impl] bool QGraphicsBlurEffect::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QGraphicsBlurEffect::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsBlurEffect_Adaptor, bool, QEvent *>(&QGraphicsBlurEffect_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QGraphicsBlurEffect::event(_event);
    }
  }

  //  [adaptor impl] bool QGraphicsBlurEffect::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QGraphicsBlurEffect::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsBlurEffect_Adaptor, bool, QObject *, QEvent *>(&QGraphicsBlurEffect_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QGraphicsBlurEffect::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QGraphicsBlurEffect::objectNameChanged(const QString &objectName)
  void emitter_QGraphicsBlurEffect_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QGraphicsBlurEffect::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QGraphicsBlurEffect::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QGraphicsBlurEffect::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsBlurEffect_Adaptor, QChildEvent *>(&QGraphicsBlurEffect_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QGraphicsBlurEffect::childEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsBlurEffect::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QGraphicsBlurEffect::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsBlurEffect_Adaptor, QEvent *>(&QGraphicsBlurEffect_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QGraphicsBlurEffect::customEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsBlurEffect::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QGraphicsBlurEffect::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QGraphicsBlurEffect_Adaptor, const QMetaMethod &>(&QGraphicsBlurEffect_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QGraphicsBlurEffect::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsBlurEffect::draw(QPainter *painter)
  void cbs_draw_1426_0(QPainter *painter)
  {
    QGraphicsBlurEffect::draw(painter);
  }

  virtual void draw(QPainter *painter)
  {
    if (cb_draw_1426_0.can_issue()) {
      cb_draw_1426_0.issue<QGraphicsBlurEffect_Adaptor, QPainter *>(&QGraphicsBlurEffect_Adaptor::cbs_draw_1426_0, painter);
    } else {
      QGraphicsBlurEffect::draw(painter);
    }
  }

  //  [adaptor impl] void QGraphicsBlurEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
  void cbs_sourceChanged_3695_0(QFlags<QGraphicsEffect::ChangeFlag> flags)
  {
    QGraphicsBlurEffect::sourceChanged(flags);
  }

  virtual void sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
  {
    if (cb_sourceChanged_3695_0.can_issue()) {
      cb_sourceChanged_3695_0.issue<QGraphicsBlurEffect_Adaptor, QFlags<QGraphicsEffect::ChangeFlag> >(&QGraphicsBlurEffect_Adaptor::cbs_sourceChanged_3695_0, flags);
    } else {
      QGraphicsBlurEffect::sourceChanged(flags);
    }
  }

  //  [adaptor impl] void QGraphicsBlurEffect::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QGraphicsBlurEffect::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsBlurEffect_Adaptor, QTimerEvent *>(&QGraphicsBlurEffect_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QGraphicsBlurEffect::timerEvent(event);
    }
  }

  gsi::Callback cb_boundingRectFor_c1862_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_draw_1426_0;
  gsi::Callback cb_sourceChanged_3695_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QGraphicsBlurEffect_Adaptor::~QGraphicsBlurEffect_Adaptor() { }

//  Constructor QGraphicsBlurEffect::QGraphicsBlurEffect(QObject *parent) (adaptor class)

static void _init_ctor_QGraphicsBlurEffect_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QGraphicsBlurEffect_Adaptor> ();
}

static void _call_ctor_QGraphicsBlurEffect_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QGraphicsBlurEffect_Adaptor *> (new QGraphicsBlurEffect_Adaptor (arg1));
}


// emitter void QGraphicsBlurEffect::blurHintsChanged(QFlags<QGraphicsBlurEffect::BlurHint> hints)

static void _init_emitter_blurHintsChanged_3948 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hints");
  decl->add_arg<QFlags<QGraphicsBlurEffect::BlurHint> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_blurHintsChanged_3948 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QGraphicsBlurEffect::BlurHint> arg1 = gsi::arg_reader<QFlags<QGraphicsBlurEffect::BlurHint> >() (args, heap);
  ((QGraphicsBlurEffect_Adaptor *)cls)->emitter_QGraphicsBlurEffect_blurHintsChanged_3948 (arg1);
}


// emitter void QGraphicsBlurEffect::blurRadiusChanged(double blurRadius)

static void _init_emitter_blurRadiusChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("blurRadius");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_blurRadiusChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QGraphicsBlurEffect_Adaptor *)cls)->emitter_QGraphicsBlurEffect_blurRadiusChanged_1071 (arg1);
}


// QRectF QGraphicsBlurEffect::boundingRectFor(const QRectF &rect)

static void _init_cbs_boundingRectFor_c1862_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_cbs_boundingRectFor_c1862_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args.read<const QRectF & > (heap);
  ret.write<QRectF > ((QRectF)((QGraphicsBlurEffect_Adaptor *)cls)->cbs_boundingRectFor_c1862_0 (arg1));
}

static void _set_callback_cbs_boundingRectFor_c1862_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->cb_boundingRectFor_c1862_0 = cb;
}


// void QGraphicsBlurEffect::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsBlurEffect_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QGraphicsBlurEffect::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsBlurEffect_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QGraphicsBlurEffect::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QGraphicsBlurEffect_Adaptor *)cls)->emitter_QGraphicsBlurEffect_destroyed_1302 (arg1);
}


// void QGraphicsBlurEffect::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsBlurEffect_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QGraphicsBlurEffect::draw(QPainter *painter)

static void _init_cbs_draw_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_draw_1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsBlurEffect_Adaptor *)cls)->cbs_draw_1426_0 (arg1);
}

static void _set_callback_cbs_draw_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->cb_draw_1426_0 = cb;
}


// exposed void QGraphicsBlurEffect::drawSource(QPainter *painter)

static void _init_fp_drawSource_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawSource_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsBlurEffect_Adaptor *)cls)->fp_QGraphicsBlurEffect_drawSource_1426 (arg1);
}


// emitter void QGraphicsBlurEffect::enabledChanged(bool enabled)

static void _init_emitter_enabledChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_enabledChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QGraphicsBlurEffect_Adaptor *)cls)->emitter_QGraphicsBlurEffect_enabledChanged_864 (arg1);
}


// bool QGraphicsBlurEffect::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsBlurEffect_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QGraphicsBlurEffect::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsBlurEffect_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QGraphicsBlurEffect::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsBlurEffect_Adaptor *)cls)->fp_QGraphicsBlurEffect_isSignalConnected_c2394 (arg1));
}


// emitter void QGraphicsBlurEffect::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QGraphicsBlurEffect_Adaptor *)cls)->emitter_QGraphicsBlurEffect_objectNameChanged_4567 (arg1);
}


// exposed int QGraphicsBlurEffect::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QGraphicsBlurEffect_Adaptor *)cls)->fp_QGraphicsBlurEffect_receivers_c1731 (arg1));
}


// exposed QObject *QGraphicsBlurEffect::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QGraphicsBlurEffect_Adaptor *)cls)->fp_QGraphicsBlurEffect_sender_c0 ());
}


// exposed int QGraphicsBlurEffect::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsBlurEffect_Adaptor *)cls)->fp_QGraphicsBlurEffect_senderSignalIndex_c0 ());
}


// exposed QRectF QGraphicsBlurEffect::sourceBoundingRect(Qt::CoordinateSystem system)

static void _init_fp_sourceBoundingRect_c2426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("system", true, "Qt::LogicalCoordinates");
  decl->add_arg<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_fp_sourceBoundingRect_c2426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::CoordinateSystem>(heap, Qt::LogicalCoordinates), heap);
  ret.write<QRectF > ((QRectF)((QGraphicsBlurEffect_Adaptor *)cls)->fp_QGraphicsBlurEffect_sourceBoundingRect_c2426 (arg1));
}


// void QGraphicsBlurEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)

static void _init_cbs_sourceChanged_3695_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<QGraphicsEffect::ChangeFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_sourceChanged_3695_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QGraphicsEffect::ChangeFlag> arg1 = args.read<QFlags<QGraphicsEffect::ChangeFlag> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsBlurEffect_Adaptor *)cls)->cbs_sourceChanged_3695_0 (arg1);
}

static void _set_callback_cbs_sourceChanged_3695_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->cb_sourceChanged_3695_0 = cb;
}


// exposed bool QGraphicsBlurEffect::sourceIsPixmap()

static void _init_fp_sourceIsPixmap_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_sourceIsPixmap_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsBlurEffect_Adaptor *)cls)->fp_QGraphicsBlurEffect_sourceIsPixmap_c0 ());
}


// exposed QPixmap QGraphicsBlurEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)

static void _init_fp_sourcePixmap_c6763 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("system", true, "Qt::LogicalCoordinates");
  decl->add_arg<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("offset", true, "nullptr");
  decl->add_arg<QPoint * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QGraphicsEffect::PadToEffectiveBoundingRect");
  decl->add_arg<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_fp_sourcePixmap_c6763 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::CoordinateSystem>(heap, Qt::LogicalCoordinates), heap);
  QPoint *arg2 = args ? gsi::arg_reader<QPoint * >() (args, heap) : gsi::arg_maker<QPoint * >() (nullptr, heap);
  const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QGraphicsEffect::PixmapPadMode>(heap, QGraphicsEffect::PadToEffectiveBoundingRect), heap);
  ret.write<QPixmap > ((QPixmap)((QGraphicsBlurEffect_Adaptor *)cls)->fp_QGraphicsBlurEffect_sourcePixmap_c6763 (arg1, arg2, arg3));
}


// void QGraphicsBlurEffect::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsBlurEffect_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsBlurEffect_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QGraphicsBlurEffect::updateBoundingRect()

static void _init_fp_updateBoundingRect_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateBoundingRect_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsBlurEffect_Adaptor *)cls)->fp_QGraphicsBlurEffect_updateBoundingRect_0 ();
}


namespace gsi
{

gsi::Class<QGraphicsBlurEffect> &qtdecl_QGraphicsBlurEffect ();

static gsi::Methods methods_QGraphicsBlurEffect_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsBlurEffect::QGraphicsBlurEffect(QObject *parent)\nThis method creates an object of class QGraphicsBlurEffect.", &_init_ctor_QGraphicsBlurEffect_Adaptor_1302, &_call_ctor_QGraphicsBlurEffect_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("emit_blurHintsChanged", "@brief Emitter for signal void QGraphicsBlurEffect::blurHintsChanged(QFlags<QGraphicsBlurEffect::BlurHint> hints)\nCall this method to emit this signal.", false, &_init_emitter_blurHintsChanged_3948, &_call_emitter_blurHintsChanged_3948);
  methods += new qt_gsi::GenericMethod ("emit_blurRadiusChanged", "@brief Emitter for signal void QGraphicsBlurEffect::blurRadiusChanged(double blurRadius)\nCall this method to emit this signal.", false, &_init_emitter_blurRadiusChanged_1071, &_call_emitter_blurRadiusChanged_1071);
  methods += new qt_gsi::GenericMethod ("boundingRectFor", "@brief Virtual method QRectF QGraphicsBlurEffect::boundingRectFor(const QRectF &rect)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_boundingRectFor_c1862_0, &_call_cbs_boundingRectFor_c1862_0);
  methods += new qt_gsi::GenericMethod ("boundingRectFor", "@hide", true, &_init_cbs_boundingRectFor_c1862_0, &_call_cbs_boundingRectFor_c1862_0, &_set_callback_cbs_boundingRectFor_c1862_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsBlurEffect::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsBlurEffect::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QGraphicsBlurEffect::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsBlurEffect::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*draw", "@brief Virtual method void QGraphicsBlurEffect::draw(QPainter *painter)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_draw_1426_0, &_call_cbs_draw_1426_0);
  methods += new qt_gsi::GenericMethod ("*draw", "@hide", false, &_init_cbs_draw_1426_0, &_call_cbs_draw_1426_0, &_set_callback_cbs_draw_1426_0);
  methods += new qt_gsi::GenericMethod ("*drawSource", "@brief Method void QGraphicsBlurEffect::drawSource(QPainter *painter)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawSource_1426, &_call_fp_drawSource_1426);
  methods += new qt_gsi::GenericMethod ("emit_enabledChanged", "@brief Emitter for signal void QGraphicsBlurEffect::enabledChanged(bool enabled)\nCall this method to emit this signal.", false, &_init_emitter_enabledChanged_864, &_call_emitter_enabledChanged_864);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QGraphicsBlurEffect::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QGraphicsBlurEffect::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QGraphicsBlurEffect::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QGraphicsBlurEffect::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QGraphicsBlurEffect::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QGraphicsBlurEffect::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QGraphicsBlurEffect::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*sourceBoundingRect", "@brief Method QRectF QGraphicsBlurEffect::sourceBoundingRect(Qt::CoordinateSystem system)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourceBoundingRect_c2426, &_call_fp_sourceBoundingRect_c2426);
  methods += new qt_gsi::GenericMethod ("*sourceChanged", "@brief Virtual method void QGraphicsBlurEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sourceChanged_3695_0, &_call_cbs_sourceChanged_3695_0);
  methods += new qt_gsi::GenericMethod ("*sourceChanged", "@hide", false, &_init_cbs_sourceChanged_3695_0, &_call_cbs_sourceChanged_3695_0, &_set_callback_cbs_sourceChanged_3695_0);
  methods += new qt_gsi::GenericMethod ("*sourceIsPixmap", "@brief Method bool QGraphicsBlurEffect::sourceIsPixmap()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourceIsPixmap_c0, &_call_fp_sourceIsPixmap_c0);
  methods += new qt_gsi::GenericMethod ("*sourcePixmap", "@brief Method QPixmap QGraphicsBlurEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourcePixmap_c6763, &_call_fp_sourcePixmap_c6763);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsBlurEffect::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateBoundingRect", "@brief Method void QGraphicsBlurEffect::updateBoundingRect()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateBoundingRect_0, &_call_fp_updateBoundingRect_0);
  return methods;
}

gsi::Class<QGraphicsBlurEffect_Adaptor> decl_QGraphicsBlurEffect_Adaptor (qtdecl_QGraphicsBlurEffect (), "QtWidgets", "QGraphicsBlurEffect",
  methods_QGraphicsBlurEffect_Adaptor (),
  "@qt\n@brief Binding of QGraphicsBlurEffect");

}


//  Implementation of the enum wrapper class for QGraphicsBlurEffect::BlurHint
namespace qt_gsi
{

static gsi::Enum<QGraphicsBlurEffect::BlurHint> decl_QGraphicsBlurEffect_BlurHint_Enum ("QtWidgets", "QGraphicsBlurEffect_BlurHint",
    gsi::enum_const ("PerformanceHint", QGraphicsBlurEffect::PerformanceHint, "@brief Enum constant QGraphicsBlurEffect::PerformanceHint") +
    gsi::enum_const ("QualityHint", QGraphicsBlurEffect::QualityHint, "@brief Enum constant QGraphicsBlurEffect::QualityHint") +
    gsi::enum_const ("AnimationHint", QGraphicsBlurEffect::AnimationHint, "@brief Enum constant QGraphicsBlurEffect::AnimationHint"),
  "@qt\n@brief This class represents the QGraphicsBlurEffect::BlurHint enum");

static gsi::QFlagsClass<QGraphicsBlurEffect::BlurHint > decl_QGraphicsBlurEffect_BlurHint_Enums ("QtWidgets", "QGraphicsBlurEffect_QFlags_BlurHint",
  "@qt\n@brief This class represents the QFlags<QGraphicsBlurEffect::BlurHint> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsBlurEffect> inject_QGraphicsBlurEffect_BlurHint_Enum_in_parent (decl_QGraphicsBlurEffect_BlurHint_Enum.defs ());
static gsi::ClassExt<QGraphicsBlurEffect> decl_QGraphicsBlurEffect_BlurHint_Enum_as_child (decl_QGraphicsBlurEffect_BlurHint_Enum, "BlurHint");
static gsi::ClassExt<QGraphicsBlurEffect> decl_QGraphicsBlurEffect_BlurHint_Enums_as_child (decl_QGraphicsBlurEffect_BlurHint_Enums, "QFlags_BlurHint");

}

