
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMetaDataWriterControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMetaDataWriterControl>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMetaDataWriterControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMetaDataWriterControl::staticMetaObject);
}


// QStringList QMetaDataWriterControl::availableMetaData()


static void _init_f_availableMetaData_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_availableMetaData_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QMetaDataWriterControl *)cls)->availableMetaData ());
}


// bool QMetaDataWriterControl::isMetaDataAvailable()


static void _init_f_isMetaDataAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMetaDataAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMetaDataWriterControl *)cls)->isMetaDataAvailable ());
}


// bool QMetaDataWriterControl::isWritable()


static void _init_f_isWritable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWritable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMetaDataWriterControl *)cls)->isWritable ());
}


// QVariant QMetaDataWriterControl::metaData(const QString &key)


static void _init_f_metaData_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_metaData_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QMetaDataWriterControl *)cls)->metaData (arg1));
}


// void QMetaDataWriterControl::setMetaData(const QString &key, const QVariant &value)


static void _init_f_setMetaData_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMetaData_4036 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMetaDataWriterControl *)cls)->setMetaData (arg1, arg2);
}


// static QString QMetaDataWriterControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMetaDataWriterControl::tr (arg1, arg2, arg3));
}


// static QString QMetaDataWriterControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMetaDataWriterControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QMetaDataWriterControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("availableMetaData", "@brief Method QStringList QMetaDataWriterControl::availableMetaData()\n", true, &_init_f_availableMetaData_c0, &_call_f_availableMetaData_c0);
  methods += new qt_gsi::GenericMethod ("isMetaDataAvailable?", "@brief Method bool QMetaDataWriterControl::isMetaDataAvailable()\n", true, &_init_f_isMetaDataAvailable_c0, &_call_f_isMetaDataAvailable_c0);
  methods += new qt_gsi::GenericMethod ("isWritable?", "@brief Method bool QMetaDataWriterControl::isWritable()\n", true, &_init_f_isWritable_c0, &_call_f_isWritable_c0);
  methods += new qt_gsi::GenericMethod ("metaData", "@brief Method QVariant QMetaDataWriterControl::metaData(const QString &key)\n", true, &_init_f_metaData_c2025, &_call_f_metaData_c2025);
  methods += new qt_gsi::GenericMethod ("setMetaData", "@brief Method void QMetaDataWriterControl::setMetaData(const QString &key, const QVariant &value)\n", false, &_init_f_setMetaData_4036, &_call_f_setMetaData_4036);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QMetaDataWriterControl::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("metaDataAvailableChanged(bool)", "metaDataAvailableChanged", gsi::arg("available"), "@brief Signal declaration for QMetaDataWriterControl::metaDataAvailableChanged(bool available)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("metaDataChanged()", "metaDataChanged", "@brief Signal declaration for QMetaDataWriterControl::metaDataChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString &, const QVariant & > ("metaDataChanged(const QString &, const QVariant &)", "metaDataChanged_kv", gsi::arg("key"), gsi::arg("value"), "@brief Signal declaration for QMetaDataWriterControl::metaDataChanged(const QString &key, const QVariant &value)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QMetaDataWriterControl::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("writableChanged(bool)", "writableChanged", gsi::arg("writable"), "@brief Signal declaration for QMetaDataWriterControl::writableChanged(bool writable)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMetaDataWriterControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMetaDataWriterControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QMetaDataWriterControl> decl_QMetaDataWriterControl (qtdecl_QMediaControl (), "QtMultimedia", "QMetaDataWriterControl_Native",
  methods_QMetaDataWriterControl (),
  "@hide\n@alias QMetaDataWriterControl");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QMetaDataWriterControl> &qtdecl_QMetaDataWriterControl () { return decl_QMetaDataWriterControl; }

}


class QMetaDataWriterControl_Adaptor : public QMetaDataWriterControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMetaDataWriterControl_Adaptor();

  //  [adaptor ctor] QMetaDataWriterControl::QMetaDataWriterControl()
  QMetaDataWriterControl_Adaptor() : QMetaDataWriterControl()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QMetaDataWriterControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QMetaDataWriterControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QMetaDataWriterControl::isSignalConnected(signal);
  }

  //  [expose] int QMetaDataWriterControl::receivers(const char *signal)
  int fp_QMetaDataWriterControl_receivers_c1731 (const char *signal) const {
    return QMetaDataWriterControl::receivers(signal);
  }

  //  [expose] QObject *QMetaDataWriterControl::sender()
  QObject * fp_QMetaDataWriterControl_sender_c0 () const {
    return QMetaDataWriterControl::sender();
  }

  //  [expose] int QMetaDataWriterControl::senderSignalIndex()
  int fp_QMetaDataWriterControl_senderSignalIndex_c0 () const {
    return QMetaDataWriterControl::senderSignalIndex();
  }

  //  [adaptor impl] QStringList QMetaDataWriterControl::availableMetaData()
  QStringList cbs_availableMetaData_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("availableMetaData");
  }

  virtual QStringList availableMetaData() const
  {
    if (cb_availableMetaData_c0_0.can_issue()) {
      return cb_availableMetaData_c0_0.issue<QMetaDataWriterControl_Adaptor, QStringList>(&QMetaDataWriterControl_Adaptor::cbs_availableMetaData_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("availableMetaData");
    }
  }

  //  [emitter impl] void QMetaDataWriterControl::destroyed(QObject *)
  void emitter_QMetaDataWriterControl_destroyed_1302(QObject *arg1)
  {
    emit QMetaDataWriterControl::destroyed(arg1);
  }

  //  [adaptor impl] bool QMetaDataWriterControl::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QMetaDataWriterControl::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMetaDataWriterControl_Adaptor, bool, QEvent *>(&QMetaDataWriterControl_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QMetaDataWriterControl::event(_event);
    }
  }

  //  [adaptor impl] bool QMetaDataWriterControl::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QMetaDataWriterControl::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMetaDataWriterControl_Adaptor, bool, QObject *, QEvent *>(&QMetaDataWriterControl_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QMetaDataWriterControl::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] bool QMetaDataWriterControl::isMetaDataAvailable()
  bool cbs_isMetaDataAvailable_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isMetaDataAvailable");
  }

  virtual bool isMetaDataAvailable() const
  {
    if (cb_isMetaDataAvailable_c0_0.can_issue()) {
      return cb_isMetaDataAvailable_c0_0.issue<QMetaDataWriterControl_Adaptor, bool>(&QMetaDataWriterControl_Adaptor::cbs_isMetaDataAvailable_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isMetaDataAvailable");
    }
  }

  //  [adaptor impl] bool QMetaDataWriterControl::isWritable()
  bool cbs_isWritable_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isWritable");
  }

  virtual bool isWritable() const
  {
    if (cb_isWritable_c0_0.can_issue()) {
      return cb_isWritable_c0_0.issue<QMetaDataWriterControl_Adaptor, bool>(&QMetaDataWriterControl_Adaptor::cbs_isWritable_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isWritable");
    }
  }

  //  [adaptor impl] QVariant QMetaDataWriterControl::metaData(const QString &key)
  QVariant cbs_metaData_c2025_0(const QString &key) const
  {
    __SUPPRESS_UNUSED_WARNING (key);
    throw qt_gsi::AbstractMethodCalledException("metaData");
  }

  virtual QVariant metaData(const QString &key) const
  {
    if (cb_metaData_c2025_0.can_issue()) {
      return cb_metaData_c2025_0.issue<QMetaDataWriterControl_Adaptor, QVariant, const QString &>(&QMetaDataWriterControl_Adaptor::cbs_metaData_c2025_0, key);
    } else {
      throw qt_gsi::AbstractMethodCalledException("metaData");
    }
  }

  //  [emitter impl] void QMetaDataWriterControl::metaDataAvailableChanged(bool available)
  void emitter_QMetaDataWriterControl_metaDataAvailableChanged_864(bool available)
  {
    emit QMetaDataWriterControl::metaDataAvailableChanged(available);
  }

  //  [emitter impl] void QMetaDataWriterControl::metaDataChanged()
  void emitter_QMetaDataWriterControl_metaDataChanged_0()
  {
    emit QMetaDataWriterControl::metaDataChanged();
  }

  //  [emitter impl] void QMetaDataWriterControl::metaDataChanged(const QString &key, const QVariant &value)
  void emitter_QMetaDataWriterControl_metaDataChanged_4036(const QString &key, const QVariant &value)
  {
    emit QMetaDataWriterControl::metaDataChanged(key, value);
  }

  //  [emitter impl] void QMetaDataWriterControl::objectNameChanged(const QString &objectName)
  void emitter_QMetaDataWriterControl_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QMetaDataWriterControl::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QMetaDataWriterControl::setMetaData(const QString &key, const QVariant &value)
  void cbs_setMetaData_4036_0(const QString &key, const QVariant &value)
  {
    __SUPPRESS_UNUSED_WARNING (key);
    __SUPPRESS_UNUSED_WARNING (value);
    throw qt_gsi::AbstractMethodCalledException("setMetaData");
  }

  virtual void setMetaData(const QString &key, const QVariant &value)
  {
    if (cb_setMetaData_4036_0.can_issue()) {
      cb_setMetaData_4036_0.issue<QMetaDataWriterControl_Adaptor, const QString &, const QVariant &>(&QMetaDataWriterControl_Adaptor::cbs_setMetaData_4036_0, key, value);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setMetaData");
    }
  }

  //  [emitter impl] void QMetaDataWriterControl::writableChanged(bool writable)
  void emitter_QMetaDataWriterControl_writableChanged_864(bool writable)
  {
    emit QMetaDataWriterControl::writableChanged(writable);
  }

  //  [adaptor impl] void QMetaDataWriterControl::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QMetaDataWriterControl::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMetaDataWriterControl_Adaptor, QChildEvent *>(&QMetaDataWriterControl_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QMetaDataWriterControl::childEvent(event);
    }
  }

  //  [adaptor impl] void QMetaDataWriterControl::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QMetaDataWriterControl::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMetaDataWriterControl_Adaptor, QEvent *>(&QMetaDataWriterControl_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QMetaDataWriterControl::customEvent(event);
    }
  }

  //  [adaptor impl] void QMetaDataWriterControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QMetaDataWriterControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QMetaDataWriterControl_Adaptor, const QMetaMethod &>(&QMetaDataWriterControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QMetaDataWriterControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMetaDataWriterControl::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QMetaDataWriterControl::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMetaDataWriterControl_Adaptor, QTimerEvent *>(&QMetaDataWriterControl_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QMetaDataWriterControl::timerEvent(event);
    }
  }

  gsi::Callback cb_availableMetaData_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isMetaDataAvailable_c0_0;
  gsi::Callback cb_isWritable_c0_0;
  gsi::Callback cb_metaData_c2025_0;
  gsi::Callback cb_setMetaData_4036_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QMetaDataWriterControl_Adaptor::~QMetaDataWriterControl_Adaptor() { }

//  Constructor QMetaDataWriterControl::QMetaDataWriterControl() (adaptor class)

static void _init_ctor_QMetaDataWriterControl_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QMetaDataWriterControl_Adaptor> ();
}

static void _call_ctor_QMetaDataWriterControl_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMetaDataWriterControl_Adaptor *> (new QMetaDataWriterControl_Adaptor ());
}


// QStringList QMetaDataWriterControl::availableMetaData()

static void _init_cbs_availableMetaData_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_cbs_availableMetaData_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QMetaDataWriterControl_Adaptor *)cls)->cbs_availableMetaData_c0_0 ());
}

static void _set_callback_cbs_availableMetaData_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMetaDataWriterControl_Adaptor *)cls)->cb_availableMetaData_c0_0 = cb;
}


// void QMetaDataWriterControl::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMetaDataWriterControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMetaDataWriterControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QMetaDataWriterControl::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMetaDataWriterControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMetaDataWriterControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QMetaDataWriterControl::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QMetaDataWriterControl_Adaptor *)cls)->emitter_QMetaDataWriterControl_destroyed_1302 (arg1);
}


// void QMetaDataWriterControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMetaDataWriterControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QMetaDataWriterControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QMetaDataWriterControl::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMetaDataWriterControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMetaDataWriterControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QMetaDataWriterControl::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMetaDataWriterControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMetaDataWriterControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QMetaDataWriterControl::isMetaDataAvailable()

static void _init_cbs_isMetaDataAvailable_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isMetaDataAvailable_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMetaDataWriterControl_Adaptor *)cls)->cbs_isMetaDataAvailable_c0_0 ());
}

static void _set_callback_cbs_isMetaDataAvailable_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMetaDataWriterControl_Adaptor *)cls)->cb_isMetaDataAvailable_c0_0 = cb;
}


// exposed bool QMetaDataWriterControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QMetaDataWriterControl_Adaptor *)cls)->fp_QMetaDataWriterControl_isSignalConnected_c2394 (arg1));
}


// bool QMetaDataWriterControl::isWritable()

static void _init_cbs_isWritable_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isWritable_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMetaDataWriterControl_Adaptor *)cls)->cbs_isWritable_c0_0 ());
}

static void _set_callback_cbs_isWritable_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMetaDataWriterControl_Adaptor *)cls)->cb_isWritable_c0_0 = cb;
}


// QVariant QMetaDataWriterControl::metaData(const QString &key)

static void _init_cbs_metaData_c2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_metaData_c2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<QVariant > ((QVariant)((QMetaDataWriterControl_Adaptor *)cls)->cbs_metaData_c2025_0 (arg1));
}

static void _set_callback_cbs_metaData_c2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QMetaDataWriterControl_Adaptor *)cls)->cb_metaData_c2025_0 = cb;
}


// emitter void QMetaDataWriterControl::metaDataAvailableChanged(bool available)

static void _init_emitter_metaDataAvailableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("available");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_metaDataAvailableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QMetaDataWriterControl_Adaptor *)cls)->emitter_QMetaDataWriterControl_metaDataAvailableChanged_864 (arg1);
}


// emitter void QMetaDataWriterControl::metaDataChanged()

static void _init_emitter_metaDataChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_metaDataChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMetaDataWriterControl_Adaptor *)cls)->emitter_QMetaDataWriterControl_metaDataChanged_0 ();
}


// emitter void QMetaDataWriterControl::metaDataChanged(const QString &key, const QVariant &value)

static void _init_emitter_metaDataChanged_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_metaDataChanged_4036 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  ((QMetaDataWriterControl_Adaptor *)cls)->emitter_QMetaDataWriterControl_metaDataChanged_4036 (arg1, arg2);
}


// emitter void QMetaDataWriterControl::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMetaDataWriterControl_Adaptor *)cls)->emitter_QMetaDataWriterControl_objectNameChanged_4567 (arg1);
}


// exposed int QMetaDataWriterControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QMetaDataWriterControl_Adaptor *)cls)->fp_QMetaDataWriterControl_receivers_c1731 (arg1));
}


// exposed QObject *QMetaDataWriterControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMetaDataWriterControl_Adaptor *)cls)->fp_QMetaDataWriterControl_sender_c0 ());
}


// exposed int QMetaDataWriterControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMetaDataWriterControl_Adaptor *)cls)->fp_QMetaDataWriterControl_senderSignalIndex_c0 ());
}


// void QMetaDataWriterControl::setMetaData(const QString &key, const QVariant &value)

static void _init_cbs_setMetaData_4036_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setMetaData_4036_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMetaDataWriterControl_Adaptor *)cls)->cbs_setMetaData_4036_0 (arg1, arg2);
}

static void _set_callback_cbs_setMetaData_4036_0 (void *cls, const gsi::Callback &cb)
{
  ((QMetaDataWriterControl_Adaptor *)cls)->cb_setMetaData_4036_0 = cb;
}


// void QMetaDataWriterControl::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMetaDataWriterControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMetaDataWriterControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QMetaDataWriterControl::writableChanged(bool writable)

static void _init_emitter_writableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("writable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_writableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QMetaDataWriterControl_Adaptor *)cls)->emitter_QMetaDataWriterControl_writableChanged_864 (arg1);
}


namespace gsi
{

gsi::Class<QMetaDataWriterControl> &qtdecl_QMetaDataWriterControl ();

static gsi::Methods methods_QMetaDataWriterControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMetaDataWriterControl::QMetaDataWriterControl()\nThis method creates an object of class QMetaDataWriterControl.", &_init_ctor_QMetaDataWriterControl_Adaptor_0, &_call_ctor_QMetaDataWriterControl_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("availableMetaData", "@brief Virtual method QStringList QMetaDataWriterControl::availableMetaData()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_availableMetaData_c0_0, &_call_cbs_availableMetaData_c0_0);
  methods += new qt_gsi::GenericMethod ("availableMetaData", "@hide", true, &_init_cbs_availableMetaData_c0_0, &_call_cbs_availableMetaData_c0_0, &_set_callback_cbs_availableMetaData_c0_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMetaDataWriterControl::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMetaDataWriterControl::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QMetaDataWriterControl::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMetaDataWriterControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QMetaDataWriterControl::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QMetaDataWriterControl::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("isMetaDataAvailable", "@brief Virtual method bool QMetaDataWriterControl::isMetaDataAvailable()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isMetaDataAvailable_c0_0, &_call_cbs_isMetaDataAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("isMetaDataAvailable", "@hide", true, &_init_cbs_isMetaDataAvailable_c0_0, &_call_cbs_isMetaDataAvailable_c0_0, &_set_callback_cbs_isMetaDataAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QMetaDataWriterControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("isWritable", "@brief Virtual method bool QMetaDataWriterControl::isWritable()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isWritable_c0_0, &_call_cbs_isWritable_c0_0);
  methods += new qt_gsi::GenericMethod ("isWritable", "@hide", true, &_init_cbs_isWritable_c0_0, &_call_cbs_isWritable_c0_0, &_set_callback_cbs_isWritable_c0_0);
  methods += new qt_gsi::GenericMethod ("metaData", "@brief Virtual method QVariant QMetaDataWriterControl::metaData(const QString &key)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metaData_c2025_0, &_call_cbs_metaData_c2025_0);
  methods += new qt_gsi::GenericMethod ("metaData", "@hide", true, &_init_cbs_metaData_c2025_0, &_call_cbs_metaData_c2025_0, &_set_callback_cbs_metaData_c2025_0);
  methods += new qt_gsi::GenericMethod ("emit_metaDataAvailableChanged", "@brief Emitter for signal void QMetaDataWriterControl::metaDataAvailableChanged(bool available)\nCall this method to emit this signal.", false, &_init_emitter_metaDataAvailableChanged_864, &_call_emitter_metaDataAvailableChanged_864);
  methods += new qt_gsi::GenericMethod ("emit_metaDataChanged", "@brief Emitter for signal void QMetaDataWriterControl::metaDataChanged()\nCall this method to emit this signal.", false, &_init_emitter_metaDataChanged_0, &_call_emitter_metaDataChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_metaDataChanged_kv", "@brief Emitter for signal void QMetaDataWriterControl::metaDataChanged(const QString &key, const QVariant &value)\nCall this method to emit this signal.", false, &_init_emitter_metaDataChanged_4036, &_call_emitter_metaDataChanged_4036);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QMetaDataWriterControl::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QMetaDataWriterControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QMetaDataWriterControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QMetaDataWriterControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setMetaData", "@brief Virtual method void QMetaDataWriterControl::setMetaData(const QString &key, const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setMetaData_4036_0, &_call_cbs_setMetaData_4036_0);
  methods += new qt_gsi::GenericMethod ("setMetaData", "@hide", false, &_init_cbs_setMetaData_4036_0, &_call_cbs_setMetaData_4036_0, &_set_callback_cbs_setMetaData_4036_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMetaDataWriterControl::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_writableChanged", "@brief Emitter for signal void QMetaDataWriterControl::writableChanged(bool writable)\nCall this method to emit this signal.", false, &_init_emitter_writableChanged_864, &_call_emitter_writableChanged_864);
  return methods;
}

gsi::Class<QMetaDataWriterControl_Adaptor> decl_QMetaDataWriterControl_Adaptor (qtdecl_QMetaDataWriterControl (), "QtMultimedia", "QMetaDataWriterControl",
  methods_QMetaDataWriterControl_Adaptor (),
  "@qt\n@brief Binding of QMetaDataWriterControl");

}

