
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPictureFormatPlugin.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QPictureFormatPlugin>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QPicture>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPictureFormatPlugin

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QPictureFormatPlugin::staticMetaObject);
}


// bool QPictureFormatPlugin::installIOHandler(const QString &format)


static void _init_f_installIOHandler_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_installIOHandler_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QPictureFormatPlugin *)cls)->installIOHandler (arg1));
}


// bool QPictureFormatPlugin::loadPicture(const QString &format, const QString &filename, QPicture *pic)


static void _init_f_loadPicture_5269 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("filename");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pic");
  decl->add_arg<QPicture * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_loadPicture_5269 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  QPicture *arg3 = gsi::arg_reader<QPicture * >() (args, heap);
  ret.write<bool > ((bool)((QPictureFormatPlugin *)cls)->loadPicture (arg1, arg2, arg3));
}


// bool QPictureFormatPlugin::savePicture(const QString &format, const QString &filename, const QPicture &pic)


static void _init_f_savePicture_5960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("filename");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pic");
  decl->add_arg<const QPicture & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_savePicture_5960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QPicture &arg3 = gsi::arg_reader<const QPicture & >() (args, heap);
  ret.write<bool > ((bool)((QPictureFormatPlugin *)cls)->savePicture (arg1, arg2, arg3));
}


// static QString QPictureFormatPlugin::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QPictureFormatPlugin::tr (arg1, arg2, arg3));
}


// static QString QPictureFormatPlugin::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QPictureFormatPlugin::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QPictureFormatPlugin () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("installIOHandler", "@brief Method bool QPictureFormatPlugin::installIOHandler(const QString &format)\n", false, &_init_f_installIOHandler_2025, &_call_f_installIOHandler_2025);
  methods += new qt_gsi::GenericMethod ("loadPicture", "@brief Method bool QPictureFormatPlugin::loadPicture(const QString &format, const QString &filename, QPicture *pic)\n", false, &_init_f_loadPicture_5269, &_call_f_loadPicture_5269);
  methods += new qt_gsi::GenericMethod ("savePicture", "@brief Method bool QPictureFormatPlugin::savePicture(const QString &format, const QString &filename, const QPicture &pic)\n", false, &_init_f_savePicture_5960, &_call_f_savePicture_5960);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QPictureFormatPlugin::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QPictureFormatPlugin::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPictureFormatPlugin::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPictureFormatPlugin::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QPictureFormatPlugin> decl_QPictureFormatPlugin (qtdecl_QObject (), "QtGui", "QPictureFormatPlugin_Native",
  methods_QPictureFormatPlugin (),
  "@hide\n@alias QPictureFormatPlugin");

GSI_QTGUI_PUBLIC gsi::Class<QPictureFormatPlugin> &qtdecl_QPictureFormatPlugin () { return decl_QPictureFormatPlugin; }

}


class QPictureFormatPlugin_Adaptor : public QPictureFormatPlugin, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPictureFormatPlugin_Adaptor();

  //  [adaptor ctor] QPictureFormatPlugin::QPictureFormatPlugin(QObject *parent)
  QPictureFormatPlugin_Adaptor() : QPictureFormatPlugin()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPictureFormatPlugin::QPictureFormatPlugin(QObject *parent)
  QPictureFormatPlugin_Adaptor(QObject *parent) : QPictureFormatPlugin(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QPictureFormatPlugin::isSignalConnected(const QMetaMethod &signal)
  bool fp_QPictureFormatPlugin_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QPictureFormatPlugin::isSignalConnected(signal);
  }

  //  [expose] int QPictureFormatPlugin::receivers(const char *signal)
  int fp_QPictureFormatPlugin_receivers_c1731 (const char *signal) const {
    return QPictureFormatPlugin::receivers(signal);
  }

  //  [expose] QObject *QPictureFormatPlugin::sender()
  QObject * fp_QPictureFormatPlugin_sender_c0 () const {
    return QPictureFormatPlugin::sender();
  }

  //  [expose] int QPictureFormatPlugin::senderSignalIndex()
  int fp_QPictureFormatPlugin_senderSignalIndex_c0 () const {
    return QPictureFormatPlugin::senderSignalIndex();
  }

  //  [emitter impl] void QPictureFormatPlugin::destroyed(QObject *)
  void emitter_QPictureFormatPlugin_destroyed_1302(QObject *arg1)
  {
    emit QPictureFormatPlugin::destroyed(arg1);
  }

  //  [adaptor impl] bool QPictureFormatPlugin::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QPictureFormatPlugin::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QPictureFormatPlugin_Adaptor, bool, QEvent *>(&QPictureFormatPlugin_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QPictureFormatPlugin::event(_event);
    }
  }

  //  [adaptor impl] bool QPictureFormatPlugin::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QPictureFormatPlugin::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QPictureFormatPlugin_Adaptor, bool, QObject *, QEvent *>(&QPictureFormatPlugin_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QPictureFormatPlugin::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] bool QPictureFormatPlugin::installIOHandler(const QString &format)
  bool cbs_installIOHandler_2025_0(const QString &format)
  {
    __SUPPRESS_UNUSED_WARNING (format);
    throw qt_gsi::AbstractMethodCalledException("installIOHandler");
  }

  virtual bool installIOHandler(const QString &format)
  {
    if (cb_installIOHandler_2025_0.can_issue()) {
      return cb_installIOHandler_2025_0.issue<QPictureFormatPlugin_Adaptor, bool, const QString &>(&QPictureFormatPlugin_Adaptor::cbs_installIOHandler_2025_0, format);
    } else {
      throw qt_gsi::AbstractMethodCalledException("installIOHandler");
    }
  }

  //  [adaptor impl] bool QPictureFormatPlugin::loadPicture(const QString &format, const QString &filename, QPicture *pic)
  bool cbs_loadPicture_5269_0(const QString &format, const QString &filename, QPicture *pic)
  {
    return QPictureFormatPlugin::loadPicture(format, filename, pic);
  }

  virtual bool loadPicture(const QString &format, const QString &filename, QPicture *pic)
  {
    if (cb_loadPicture_5269_0.can_issue()) {
      return cb_loadPicture_5269_0.issue<QPictureFormatPlugin_Adaptor, bool, const QString &, const QString &, QPicture *>(&QPictureFormatPlugin_Adaptor::cbs_loadPicture_5269_0, format, filename, pic);
    } else {
      return QPictureFormatPlugin::loadPicture(format, filename, pic);
    }
  }

  //  [emitter impl] void QPictureFormatPlugin::objectNameChanged(const QString &objectName)
  void emitter_QPictureFormatPlugin_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QPictureFormatPlugin::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] bool QPictureFormatPlugin::savePicture(const QString &format, const QString &filename, const QPicture &pic)
  bool cbs_savePicture_5960_0(const QString &format, const QString &filename, const QPicture &pic)
  {
    return QPictureFormatPlugin::savePicture(format, filename, pic);
  }

  virtual bool savePicture(const QString &format, const QString &filename, const QPicture &pic)
  {
    if (cb_savePicture_5960_0.can_issue()) {
      return cb_savePicture_5960_0.issue<QPictureFormatPlugin_Adaptor, bool, const QString &, const QString &, const QPicture &>(&QPictureFormatPlugin_Adaptor::cbs_savePicture_5960_0, format, filename, pic);
    } else {
      return QPictureFormatPlugin::savePicture(format, filename, pic);
    }
  }

  //  [adaptor impl] void QPictureFormatPlugin::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QPictureFormatPlugin::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QPictureFormatPlugin_Adaptor, QChildEvent *>(&QPictureFormatPlugin_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QPictureFormatPlugin::childEvent(event);
    }
  }

  //  [adaptor impl] void QPictureFormatPlugin::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QPictureFormatPlugin::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QPictureFormatPlugin_Adaptor, QEvent *>(&QPictureFormatPlugin_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QPictureFormatPlugin::customEvent(event);
    }
  }

  //  [adaptor impl] void QPictureFormatPlugin::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QPictureFormatPlugin::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QPictureFormatPlugin_Adaptor, const QMetaMethod &>(&QPictureFormatPlugin_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QPictureFormatPlugin::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QPictureFormatPlugin::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QPictureFormatPlugin::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QPictureFormatPlugin_Adaptor, QTimerEvent *>(&QPictureFormatPlugin_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QPictureFormatPlugin::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_installIOHandler_2025_0;
  gsi::Callback cb_loadPicture_5269_0;
  gsi::Callback cb_savePicture_5960_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QPictureFormatPlugin_Adaptor::~QPictureFormatPlugin_Adaptor() { }

//  Constructor QPictureFormatPlugin::QPictureFormatPlugin(QObject *parent) (adaptor class)

static void _init_ctor_QPictureFormatPlugin_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QPictureFormatPlugin_Adaptor> ();
}

static void _call_ctor_QPictureFormatPlugin_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QPictureFormatPlugin_Adaptor *> (new QPictureFormatPlugin_Adaptor (arg1));
}


// void QPictureFormatPlugin::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPictureFormatPlugin_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QPictureFormatPlugin_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QPictureFormatPlugin::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPictureFormatPlugin_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPictureFormatPlugin_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QPictureFormatPlugin::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QPictureFormatPlugin_Adaptor *)cls)->emitter_QPictureFormatPlugin_destroyed_1302 (arg1);
}


// void QPictureFormatPlugin::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPictureFormatPlugin_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QPictureFormatPlugin_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QPictureFormatPlugin::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPictureFormatPlugin_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPictureFormatPlugin_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QPictureFormatPlugin::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPictureFormatPlugin_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QPictureFormatPlugin_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QPictureFormatPlugin::installIOHandler(const QString &format)

static void _init_cbs_installIOHandler_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_installIOHandler_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<bool > ((bool)((QPictureFormatPlugin_Adaptor *)cls)->cbs_installIOHandler_2025_0 (arg1));
}

static void _set_callback_cbs_installIOHandler_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QPictureFormatPlugin_Adaptor *)cls)->cb_installIOHandler_2025_0 = cb;
}


// exposed bool QPictureFormatPlugin::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QPictureFormatPlugin_Adaptor *)cls)->fp_QPictureFormatPlugin_isSignalConnected_c2394 (arg1));
}


// bool QPictureFormatPlugin::loadPicture(const QString &format, const QString &filename, QPicture *pic)

static void _init_cbs_loadPicture_5269_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("filename");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pic");
  decl->add_arg<QPicture * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_loadPicture_5269_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  const QString &arg2 = args.read<const QString & > (heap);
  QPicture *arg3 = args.read<QPicture * > (heap);
  ret.write<bool > ((bool)((QPictureFormatPlugin_Adaptor *)cls)->cbs_loadPicture_5269_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_loadPicture_5269_0 (void *cls, const gsi::Callback &cb)
{
  ((QPictureFormatPlugin_Adaptor *)cls)->cb_loadPicture_5269_0 = cb;
}


// emitter void QPictureFormatPlugin::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QPictureFormatPlugin_Adaptor *)cls)->emitter_QPictureFormatPlugin_objectNameChanged_4567 (arg1);
}


// exposed int QPictureFormatPlugin::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QPictureFormatPlugin_Adaptor *)cls)->fp_QPictureFormatPlugin_receivers_c1731 (arg1));
}


// bool QPictureFormatPlugin::savePicture(const QString &format, const QString &filename, const QPicture &pic)

static void _init_cbs_savePicture_5960_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("filename");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pic");
  decl->add_arg<const QPicture & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_savePicture_5960_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  const QString &arg2 = args.read<const QString & > (heap);
  const QPicture &arg3 = args.read<const QPicture & > (heap);
  ret.write<bool > ((bool)((QPictureFormatPlugin_Adaptor *)cls)->cbs_savePicture_5960_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_savePicture_5960_0 (void *cls, const gsi::Callback &cb)
{
  ((QPictureFormatPlugin_Adaptor *)cls)->cb_savePicture_5960_0 = cb;
}


// exposed QObject *QPictureFormatPlugin::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QPictureFormatPlugin_Adaptor *)cls)->fp_QPictureFormatPlugin_sender_c0 ());
}


// exposed int QPictureFormatPlugin::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPictureFormatPlugin_Adaptor *)cls)->fp_QPictureFormatPlugin_senderSignalIndex_c0 ());
}


// void QPictureFormatPlugin::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPictureFormatPlugin_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QPictureFormatPlugin_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QPictureFormatPlugin> &qtdecl_QPictureFormatPlugin ();

static gsi::Methods methods_QPictureFormatPlugin_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPictureFormatPlugin::QPictureFormatPlugin(QObject *parent)\nThis method creates an object of class QPictureFormatPlugin.", &_init_ctor_QPictureFormatPlugin_Adaptor_1302, &_call_ctor_QPictureFormatPlugin_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QPictureFormatPlugin::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QPictureFormatPlugin::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QPictureFormatPlugin::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QPictureFormatPlugin::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QPictureFormatPlugin::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QPictureFormatPlugin::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("installIOHandler", "@brief Virtual method bool QPictureFormatPlugin::installIOHandler(const QString &format)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_installIOHandler_2025_0, &_call_cbs_installIOHandler_2025_0);
  methods += new qt_gsi::GenericMethod ("installIOHandler", "@hide", false, &_init_cbs_installIOHandler_2025_0, &_call_cbs_installIOHandler_2025_0, &_set_callback_cbs_installIOHandler_2025_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QPictureFormatPlugin::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("loadPicture", "@brief Virtual method bool QPictureFormatPlugin::loadPicture(const QString &format, const QString &filename, QPicture *pic)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_loadPicture_5269_0, &_call_cbs_loadPicture_5269_0);
  methods += new qt_gsi::GenericMethod ("loadPicture", "@hide", false, &_init_cbs_loadPicture_5269_0, &_call_cbs_loadPicture_5269_0, &_set_callback_cbs_loadPicture_5269_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QPictureFormatPlugin::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QPictureFormatPlugin::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("savePicture", "@brief Virtual method bool QPictureFormatPlugin::savePicture(const QString &format, const QString &filename, const QPicture &pic)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_savePicture_5960_0, &_call_cbs_savePicture_5960_0);
  methods += new qt_gsi::GenericMethod ("savePicture", "@hide", false, &_init_cbs_savePicture_5960_0, &_call_cbs_savePicture_5960_0, &_set_callback_cbs_savePicture_5960_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QPictureFormatPlugin::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QPictureFormatPlugin::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QPictureFormatPlugin::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QPictureFormatPlugin_Adaptor> decl_QPictureFormatPlugin_Adaptor (qtdecl_QPictureFormatPlugin (), "QtGui", "QPictureFormatPlugin",
  methods_QPictureFormatPlugin_Adaptor (),
  "@qt\n@brief Binding of QPictureFormatPlugin");

}

