
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQScrollArea.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QScrollArea>
#include <QAction>
#include <QActionEvent>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputContext>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPoint>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QScrollBar>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QScrollArea

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QScrollArea::staticMetaObject);
}


// QFlags<Qt::AlignmentFlag> QScrollArea::alignment()


static void _init_f_alignment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::AlignmentFlag> > ();
}

static void _call_f_alignment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::AlignmentFlag> > ((QFlags<Qt::AlignmentFlag>)((QScrollArea *)cls)->alignment ());
}


// void QScrollArea::ensureVisible(int x, int y, int xmargin, int ymargin)


static void _init_f_ensureVisible_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("xmargin", true, "50");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("ymargin", true, "50");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_ensureVisible_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (50, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (50, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea *)cls)->ensureVisible (arg1, arg2, arg3, arg4);
}


// void QScrollArea::ensureWidgetVisible(QWidget *childWidget, int xmargin, int ymargin)


static void _init_f_ensureWidgetVisible_2633 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("childWidget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xmargin", true, "50");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("ymargin", true, "50");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_ensureWidgetVisible_2633 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (50, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (50, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea *)cls)->ensureWidgetVisible (arg1, arg2, arg3);
}


// bool QScrollArea::focusNextPrevChild(bool next)


static void _init_f_focusNextPrevChild_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_focusNextPrevChild_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ret.write<bool > ((bool)((QScrollArea *)cls)->focusNextPrevChild (arg1));
}


// void QScrollArea::setAlignment(QFlags<Qt::AlignmentFlag>)


static void _init_f_setAlignment_2750 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAlignment_2750 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::AlignmentFlag> arg1 = gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea *)cls)->setAlignment (arg1);
}


// void QScrollArea::setWidget(QWidget *widget)


static void _init_f_setWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWidget_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea *)cls)->setWidget (arg1);
}


// void QScrollArea::setWidgetResizable(bool resizable)


static void _init_f_setWidgetResizable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("resizable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWidgetResizable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea *)cls)->setWidgetResizable (arg1);
}


// QSize QScrollArea::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QScrollArea *)cls)->sizeHint ());
}


// QWidget *QScrollArea::takeWidget()


static void _init_f_takeWidget_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return_new<QWidget * > ();
}

static void _call_f_takeWidget_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QScrollArea *)cls)->takeWidget ());
}


// QWidget *QScrollArea::widget()


static void _init_f_widget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_widget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QScrollArea *)cls)->widget ());
}


// bool QScrollArea::widgetResizable()


static void _init_f_widgetResizable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_widgetResizable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QScrollArea *)cls)->widgetResizable ());
}


// static QString QScrollArea::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QScrollArea::tr (arg1, arg2));
}


// static QString QScrollArea::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QScrollArea::tr (arg1, arg2, arg3));
}


// static QString QScrollArea::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QScrollArea::trUtf8 (arg1, arg2));
}


// static QString QScrollArea::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QScrollArea::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QScrollArea () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":alignment", "@brief Method QFlags<Qt::AlignmentFlag> QScrollArea::alignment()\n", true, &_init_f_alignment_c0, &_call_f_alignment_c0);
  methods += new qt_gsi::GenericMethod ("ensureVisible", "@brief Method void QScrollArea::ensureVisible(int x, int y, int xmargin, int ymargin)\n", false, &_init_f_ensureVisible_2744, &_call_f_ensureVisible_2744);
  methods += new qt_gsi::GenericMethod ("ensureWidgetVisible", "@brief Method void QScrollArea::ensureWidgetVisible(QWidget *childWidget, int xmargin, int ymargin)\n", false, &_init_f_ensureWidgetVisible_2633, &_call_f_ensureWidgetVisible_2633);
  methods += new qt_gsi::GenericMethod ("focusNextPrevChild", "@brief Method bool QScrollArea::focusNextPrevChild(bool next)\nThis is a reimplementation of QWidget::focusNextPrevChild", false, &_init_f_focusNextPrevChild_864, &_call_f_focusNextPrevChild_864);
  methods += new qt_gsi::GenericMethod ("setAlignment|alignment=", "@brief Method void QScrollArea::setAlignment(QFlags<Qt::AlignmentFlag>)\n", false, &_init_f_setAlignment_2750, &_call_f_setAlignment_2750);
  methods += new qt_gsi::GenericMethod ("setWidget|widget=", "@brief Method void QScrollArea::setWidget(QWidget *widget)\n", false, &_init_f_setWidget_1315, &_call_f_setWidget_1315);
  methods += new qt_gsi::GenericMethod ("setWidgetResizable|widgetResizable=", "@brief Method void QScrollArea::setWidgetResizable(bool resizable)\n", false, &_init_f_setWidgetResizable_864, &_call_f_setWidgetResizable_864);
  methods += new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QScrollArea::sizeHint()\nThis is a reimplementation of QAbstractScrollArea::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod ("takeWidget", "@brief Method QWidget *QScrollArea::takeWidget()\n", false, &_init_f_takeWidget_0, &_call_f_takeWidget_0);
  methods += new qt_gsi::GenericMethod (":widget", "@brief Method QWidget *QScrollArea::widget()\n", true, &_init_f_widget_c0, &_call_f_widget_c0);
  methods += new qt_gsi::GenericMethod (":widgetResizable", "@brief Method bool QScrollArea::widgetResizable()\n", true, &_init_f_widgetResizable_c0, &_call_f_widgetResizable_c0);
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QScrollArea::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QScrollArea::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QScrollArea::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QScrollArea::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QScrollArea::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QScrollArea::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QAbstractScrollArea> &qtdecl_QAbstractScrollArea ();

qt_gsi::QtNativeClass<QScrollArea> decl_QScrollArea (qtdecl_QAbstractScrollArea (), "QtGui", "QScrollArea_Native",
  methods_QScrollArea (),
  "@hide\n@alias QScrollArea");

GSI_QTGUI_PUBLIC gsi::Class<QScrollArea> &qtdecl_QScrollArea () { return decl_QScrollArea; }

}


class QScrollArea_Adaptor : public QScrollArea, public qt_gsi::QtObjectBase
{
public:

  virtual ~QScrollArea_Adaptor();

  //  [adaptor ctor] QScrollArea::QScrollArea(QWidget *parent)
  QScrollArea_Adaptor() : QScrollArea()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QScrollArea::QScrollArea(QWidget *parent)
  QScrollArea_Adaptor(QWidget *parent) : QScrollArea(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QScrollArea::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QScrollArea_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QScrollArea::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QScrollArea::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QScrollArea_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QScrollArea::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] void QScrollArea::drawFrame(QPainter *)
  void fp_QScrollArea_drawFrame_1426 (QPainter *arg1) {
    QScrollArea::drawFrame(arg1);
  }

  //  [expose] bool QScrollArea::focusNextChild()
  bool fp_QScrollArea_focusNextChild_0 () {
    return QScrollArea::focusNextChild();
  }

  //  [expose] bool QScrollArea::focusPreviousChild()
  bool fp_QScrollArea_focusPreviousChild_0 () {
    return QScrollArea::focusPreviousChild();
  }

  //  [expose] int QScrollArea::receivers(const char *signal)
  int fp_QScrollArea_receivers_c1731 (const char *signal) const {
    return QScrollArea::receivers(signal);
  }

  //  [expose] void QScrollArea::resetInputContext()
  void fp_QScrollArea_resetInputContext_0 () {
    QScrollArea::resetInputContext();
  }

  //  [expose] QObject *QScrollArea::sender()
  QObject * fp_QScrollArea_sender_c0 () const {
    return QScrollArea::sender();
  }

  //  [expose] void QScrollArea::setViewportMargins(int left, int top, int right, int bottom)
  void fp_QScrollArea_setViewportMargins_2744 (int left, int top, int right, int bottom) {
    QScrollArea::setViewportMargins(left, top, right, bottom);
  }

  //  [expose] void QScrollArea::setViewportMargins(const QMargins &margins)
  void fp_QScrollArea_setViewportMargins_2115 (const QMargins &margins) {
    QScrollArea::setViewportMargins(margins);
  }

  //  [expose] void QScrollArea::setupViewport(QWidget *viewport)
  void fp_QScrollArea_setupViewport_1315 (QWidget *viewport) {
    QScrollArea::setupViewport(viewport);
  }

  //  [expose] void QScrollArea::updateMicroFocus()
  void fp_QScrollArea_updateMicroFocus_0 () {
    QScrollArea::updateMicroFocus();
  }

  //  [adaptor impl] bool QScrollArea::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QScrollArea::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QScrollArea_Adaptor, bool, bool>(&QScrollArea_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QScrollArea::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] int QScrollArea::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QScrollArea::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QScrollArea_Adaptor, int, int>(&QScrollArea_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QScrollArea::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QScrollArea::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QScrollArea::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QScrollArea_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QScrollArea_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QScrollArea::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QScrollArea::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QScrollArea::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QScrollArea_Adaptor, QSize>(&QScrollArea_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QScrollArea::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QScrollArea::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QScrollArea::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QScrollArea_Adaptor, QPaintEngine *>(&QScrollArea_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QScrollArea::paintEngine();
    }
  }

  //  [adaptor impl] void QScrollArea::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QScrollArea::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QScrollArea_Adaptor, bool>(&QScrollArea_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QScrollArea::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QScrollArea::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QScrollArea::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QScrollArea_Adaptor, QSize>(&QScrollArea_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QScrollArea::sizeHint();
    }
  }

  //  [adaptor impl] void QScrollArea::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QScrollArea::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QScrollArea_Adaptor, QActionEvent *>(&QScrollArea_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QScrollArea::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QScrollArea::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QScrollArea_Adaptor, QEvent *>(&QScrollArea_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QScrollArea::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QScrollArea::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QScrollArea_Adaptor, QChildEvent *>(&QScrollArea_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QScrollArea::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QScrollArea::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QScrollArea_Adaptor, QCloseEvent *>(&QScrollArea_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QScrollArea::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QScrollArea::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QScrollArea_Adaptor, QContextMenuEvent *>(&QScrollArea_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QScrollArea::contextMenuEvent(arg1);
    }
  }

  //  [emitter impl] void QScrollArea::customContextMenuRequested(const QPoint &pos)
  void emitter_QScrollArea_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QScrollArea::customContextMenuRequested(pos);
  }

  //  [adaptor impl] void QScrollArea::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QScrollArea::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QScrollArea_Adaptor, QEvent *>(&QScrollArea_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QScrollArea::customEvent(arg1);
    }
  }

  //  [emitter impl] void QScrollArea::destroyed(QObject *)
  void emitter_QScrollArea_destroyed_1302(QObject *arg1)
  {
    emit QScrollArea::destroyed(arg1);
  }

  //  [adaptor impl] void QScrollArea::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QScrollArea::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QScrollArea_Adaptor, const char *>(&QScrollArea_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QScrollArea::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QScrollArea::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QScrollArea::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QScrollArea_Adaptor, QDragEnterEvent *>(&QScrollArea_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QScrollArea::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QScrollArea::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QScrollArea_Adaptor, QDragLeaveEvent *>(&QScrollArea_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QScrollArea::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QScrollArea::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QScrollArea_Adaptor, QDragMoveEvent *>(&QScrollArea_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QScrollArea::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QScrollArea::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QScrollArea_Adaptor, QDropEvent *>(&QScrollArea_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QScrollArea::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QScrollArea::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QScrollArea_Adaptor, bool>(&QScrollArea_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QScrollArea::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QScrollArea::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QScrollArea_Adaptor, QEvent *>(&QScrollArea_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QScrollArea::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QScrollArea::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QScrollArea::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QScrollArea_Adaptor, bool, QEvent *>(&QScrollArea_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QScrollArea::event(arg1);
    }
  }

  //  [adaptor impl] bool QScrollArea::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QScrollArea::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QScrollArea_Adaptor, bool, QObject *, QEvent *>(&QScrollArea_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QScrollArea::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QScrollArea::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QScrollArea::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QScrollArea_Adaptor, QFocusEvent *>(&QScrollArea_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QScrollArea::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QScrollArea::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QScrollArea_Adaptor, QFocusEvent *>(&QScrollArea_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QScrollArea::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QScrollArea::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QScrollArea_Adaptor, const QFont &>(&QScrollArea_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QScrollArea::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QScrollArea::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QScrollArea_Adaptor, QHideEvent *>(&QScrollArea_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QScrollArea::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QScrollArea::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QScrollArea_Adaptor, QInputMethodEvent *>(&QScrollArea_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QScrollArea::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QScrollArea::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QScrollArea_Adaptor, QKeyEvent *>(&QScrollArea_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QScrollArea::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QScrollArea::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QScrollArea_Adaptor, QKeyEvent *>(&QScrollArea_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QScrollArea::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::languageChange()
  void cbs_languageChange_0_0()
  {
    QScrollArea::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QScrollArea_Adaptor>(&QScrollArea_Adaptor::cbs_languageChange_0_0);
    } else {
      QScrollArea::languageChange();
    }
  }

  //  [adaptor impl] void QScrollArea::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QScrollArea::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QScrollArea_Adaptor, QEvent *>(&QScrollArea_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QScrollArea::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QScrollArea::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QScrollArea::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QScrollArea_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QScrollArea_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QScrollArea::metric(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QScrollArea::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QScrollArea_Adaptor, QMouseEvent *>(&QScrollArea_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QScrollArea::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QScrollArea::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QScrollArea_Adaptor, QMouseEvent *>(&QScrollArea_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QScrollArea::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QScrollArea::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QScrollArea_Adaptor, QMouseEvent *>(&QScrollArea_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QScrollArea::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QScrollArea::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QScrollArea_Adaptor, QMouseEvent *>(&QScrollArea_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QScrollArea::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QScrollArea::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QScrollArea_Adaptor, QMoveEvent *>(&QScrollArea_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QScrollArea::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QScrollArea::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QScrollArea_Adaptor, QPaintEvent *>(&QScrollArea_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QScrollArea::paintEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QScrollArea::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QScrollArea_Adaptor, const QPalette &>(&QScrollArea_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QScrollArea::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QScrollArea::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QScrollArea_Adaptor, QResizeEvent *>(&QScrollArea_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QScrollArea::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::scrollContentsBy(int dx, int dy)
  void cbs_scrollContentsBy_1426_0(int dx, int dy)
  {
    QScrollArea::scrollContentsBy(dx, dy);
  }

  virtual void scrollContentsBy(int dx, int dy)
  {
    if (cb_scrollContentsBy_1426_0.can_issue()) {
      cb_scrollContentsBy_1426_0.issue<QScrollArea_Adaptor, int, int>(&QScrollArea_Adaptor::cbs_scrollContentsBy_1426_0, dx, dy);
    } else {
      QScrollArea::scrollContentsBy(dx, dy);
    }
  }

  //  [adaptor impl] void QScrollArea::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QScrollArea::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QScrollArea_Adaptor, QShowEvent *>(&QScrollArea_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QScrollArea::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QScrollArea::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QScrollArea_Adaptor, QStyle &>(&QScrollArea_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QScrollArea::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QScrollArea::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QScrollArea_Adaptor, QTabletEvent *>(&QScrollArea_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QScrollArea::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QScrollArea::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QScrollArea_Adaptor, QTimerEvent *>(&QScrollArea_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QScrollArea::timerEvent(arg1);
    }
  }

  //  [adaptor impl] bool QScrollArea::viewportEvent(QEvent *)
  bool cbs_viewportEvent_1217_0(QEvent *arg1)
  {
    return QScrollArea::viewportEvent(arg1);
  }

  virtual bool viewportEvent(QEvent *arg1)
  {
    if (cb_viewportEvent_1217_0.can_issue()) {
      return cb_viewportEvent_1217_0.issue<QScrollArea_Adaptor, bool, QEvent *>(&QScrollArea_Adaptor::cbs_viewportEvent_1217_0, arg1);
    } else {
      return QScrollArea::viewportEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QScrollArea::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QScrollArea_Adaptor, QWheelEvent *>(&QScrollArea_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QScrollArea::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QScrollArea::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QScrollArea::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QScrollArea_Adaptor, bool>(&QScrollArea_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QScrollArea::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_scrollContentsBy_1426_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_viewportEvent_1217_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QScrollArea_Adaptor::~QScrollArea_Adaptor() { }

//  Constructor QScrollArea::QScrollArea(QWidget *parent) (adaptor class)

static void _init_ctor_QScrollArea_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QScrollArea_Adaptor> ();
}

static void _call_ctor_QScrollArea_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  ret.write<QScrollArea_Adaptor *> (new QScrollArea_Adaptor (arg1));
}


// void QScrollArea::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// void QScrollArea::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QScrollArea::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QScrollArea::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QScrollArea::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QScrollArea::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->fp_QScrollArea_create_2208 (arg1, arg2, arg3);
}


// emitter void QScrollArea::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QScrollArea_Adaptor *)cls)->emitter_QScrollArea_customContextMenuRequested_1916 (arg1);
}


// void QScrollArea::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QScrollArea::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->fp_QScrollArea_destroy_1620 (arg1, arg2);
}


// emitter void QScrollArea::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QScrollArea_Adaptor *)cls)->emitter_QScrollArea_destroyed_1302 (arg1);
}


// void QScrollArea::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// void QScrollArea::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QScrollArea::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QScrollArea::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// exposed void QScrollArea::drawFrame(QPainter *)

static void _init_fp_drawFrame_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawFrame_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->fp_QScrollArea_drawFrame_1426 (arg1);
}


// void QScrollArea::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QScrollArea::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}


// void QScrollArea::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}


// bool QScrollArea::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QScrollArea_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QScrollArea::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QScrollArea_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QScrollArea::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QScrollArea::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QScrollArea_Adaptor *)cls)->fp_QScrollArea_focusNextChild_0 ());
}


// bool QScrollArea::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QScrollArea_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QScrollArea::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QScrollArea::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QScrollArea_Adaptor *)cls)->fp_QScrollArea_focusPreviousChild_0 ());
}


// void QScrollArea::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = args.read<const QFont & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}


// int QScrollArea::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QScrollArea_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QScrollArea::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QScrollArea::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QScrollArea::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QScrollArea_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// void QScrollArea::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QScrollArea::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QScrollArea::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}


// void QScrollArea::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QScrollArea::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QScrollArea_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QScrollArea::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QScrollArea_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QScrollArea::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QScrollArea::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QScrollArea::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QScrollArea::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QScrollArea::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// QPaintEngine *QScrollArea::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QScrollArea_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QScrollArea::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// void QScrollArea::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = args.read<const QPalette & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}


// exposed int QScrollArea::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QScrollArea_Adaptor *)cls)->fp_QScrollArea_receivers_c1731 (arg1));
}


// exposed void QScrollArea::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->fp_QScrollArea_resetInputContext_0 ();
}


// void QScrollArea::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// void QScrollArea::scrollContentsBy(int dx, int dy)

static void _init_cbs_scrollContentsBy_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollContentsBy_1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_scrollContentsBy_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollContentsBy_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_scrollContentsBy_1426_0 = cb;
}


// exposed QObject *QScrollArea::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QScrollArea_Adaptor *)cls)->fp_QScrollArea_sender_c0 ());
}


// exposed void QScrollArea::setViewportMargins(int left, int top, int right, int bottom)

static void _init_fp_setViewportMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->fp_QScrollArea_setViewportMargins_2744 (arg1, arg2, arg3, arg4);
}


// exposed void QScrollArea::setViewportMargins(const QMargins &margins)

static void _init_fp_setViewportMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2115 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMargins &arg1 = gsi::arg_reader<const QMargins & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->fp_QScrollArea_setViewportMargins_2115 (arg1);
}


// void QScrollArea::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// exposed void QScrollArea::setupViewport(QWidget *viewport)

static void _init_fp_setupViewport_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setupViewport_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->fp_QScrollArea_setupViewport_1315 (arg1);
}


// void QScrollArea::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QScrollArea::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QScrollArea_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QScrollArea::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyle &arg1 = args.read<QStyle & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}


// void QScrollArea::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QScrollArea::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QScrollArea::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->fp_QScrollArea_updateMicroFocus_0 ();
}


// bool QScrollArea::viewportEvent(QEvent *)

static void _init_cbs_viewportEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_viewportEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QScrollArea_Adaptor *)cls)->cbs_viewportEvent_1217_0 (arg1));
}

static void _set_callback_cbs_viewportEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_viewportEvent_1217_0 = cb;
}


// void QScrollArea::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// void QScrollArea::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScrollArea_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QScrollArea_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}


namespace gsi
{

gsi::Class<QScrollArea> &qtdecl_QScrollArea ();

static gsi::Methods methods_QScrollArea_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QScrollArea::QScrollArea(QWidget *parent)\nThis method creates an object of class QScrollArea.", &_init_ctor_QScrollArea_Adaptor_1315, &_call_ctor_QScrollArea_Adaptor_1315);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QScrollArea::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QScrollArea::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QScrollArea::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QScrollArea::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QScrollArea::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*qt_create", "@brief Method void QScrollArea::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QScrollArea::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QScrollArea::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*qt_destroy", "@brief Method void QScrollArea::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QScrollArea::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QScrollArea::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QScrollArea::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QScrollArea::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QScrollArea::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*drawFrame", "@brief Method void QScrollArea::drawFrame(QPainter *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawFrame_1426, &_call_fp_drawFrame_1426);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QScrollArea::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QScrollArea::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
  methods += new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QScrollArea::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QScrollArea::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QScrollArea::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QScrollArea::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QScrollArea::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("focusNextPrevChild", "@brief Virtual method bool QScrollArea::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QScrollArea::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QScrollArea::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QScrollArea::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
  methods += new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QScrollArea::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QScrollArea::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QScrollArea::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QScrollArea::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QScrollArea::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QScrollArea::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QScrollArea::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
  methods += new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QScrollArea::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QScrollArea::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QScrollArea::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QScrollArea::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QScrollArea::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QScrollArea::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QScrollArea::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QScrollArea::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QScrollArea::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QScrollArea::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QScrollArea::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
  methods += new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QScrollArea::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*resetInputContext", "@brief Method void QScrollArea::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QScrollArea::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@brief Virtual method void QScrollArea::scrollContentsBy(int dx, int dy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@hide", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0, &_set_callback_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QScrollArea::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QScrollArea::setViewportMargins(int left, int top, int right, int bottom)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2744, &_call_fp_setViewportMargins_2744);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QScrollArea::setViewportMargins(const QMargins &margins)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2115, &_call_fp_setViewportMargins_2115);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QScrollArea::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*setupViewport", "@brief Method void QScrollArea::setupViewport(QWidget *viewport)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setupViewport_1315, &_call_fp_setupViewport_1315);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QScrollArea::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QScrollArea::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QScrollArea::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
  methods += new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QScrollArea::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QScrollArea::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QScrollArea::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@brief Virtual method bool QScrollArea::viewportEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@hide", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0, &_set_callback_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QScrollArea::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QScrollArea::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
  methods += new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
  return methods;
}

gsi::Class<QScrollArea_Adaptor> decl_QScrollArea_Adaptor (qtdecl_QScrollArea (), "QtGui", "QScrollArea",
  methods_QScrollArea_Adaptor (),
  "@qt\n@brief Binding of QScrollArea");

}

