
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPrintPreviewDialog.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QPrintPreviewDialog>
#include <QAction>
#include <QActionEvent>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputContext>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPoint>
#include <QPrinter>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPrintPreviewDialog

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QPrintPreviewDialog::staticMetaObject);
}


// void QPrintPreviewDialog::done(int result)


static void _init_f_done_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("result");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_done_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog *)cls)->done (arg1);
}


// void QPrintPreviewDialog::open()


static void _init_f_open_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_open_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog *)cls)->open ();
}


// void QPrintPreviewDialog::open(QObject *receiver, const char *member)


static void _init_f_open_2925 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("member");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_open_2925 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog *)cls)->open (arg1, arg2);
}


// QPrinter *QPrintPreviewDialog::printer()


static void _init_f_printer_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPrinter * > ();
}

static void _call_f_printer_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPrinter * > ((QPrinter *)((QPrintPreviewDialog *)cls)->printer ());
}


// void QPrintPreviewDialog::setVisible(bool visible)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog *)cls)->setVisible (arg1);
}


// static QString QPrintPreviewDialog::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QPrintPreviewDialog::tr (arg1, arg2));
}


// static QString QPrintPreviewDialog::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QPrintPreviewDialog::tr (arg1, arg2, arg3));
}


// static QString QPrintPreviewDialog::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QPrintPreviewDialog::trUtf8 (arg1, arg2));
}


// static QString QPrintPreviewDialog::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QPrintPreviewDialog::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QPrintPreviewDialog () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("done", "@brief Method void QPrintPreviewDialog::done(int result)\nThis is a reimplementation of QDialog::done", false, &_init_f_done_767, &_call_f_done_767);
  methods += new qt_gsi::GenericMethod ("open", "@brief Method void QPrintPreviewDialog::open()\n", false, &_init_f_open_0, &_call_f_open_0);
  methods += new qt_gsi::GenericMethod ("open", "@brief Method void QPrintPreviewDialog::open(QObject *receiver, const char *member)\n", false, &_init_f_open_2925, &_call_f_open_2925);
  methods += new qt_gsi::GenericMethod ("printer", "@brief Method QPrinter *QPrintPreviewDialog::printer()\n", false, &_init_f_printer_0, &_call_f_printer_0);
  methods += new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QPrintPreviewDialog::setVisible(bool visible)\nThis is a reimplementation of QDialog::setVisible", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
  methods += gsi::qt_signal ("accepted()", "accepted", "@brief Signal declaration for QPrintPreviewDialog::accepted()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QPrintPreviewDialog::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QPrintPreviewDialog::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("finished(int)", "finished", gsi::arg("result"), "@brief Signal declaration for QPrintPreviewDialog::finished(int result)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QPrinter * > ("paintRequested(QPrinter *)", "paintRequested", gsi::arg("printer"), "@brief Signal declaration for QPrintPreviewDialog::paintRequested(QPrinter *printer)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("rejected()", "rejected", "@brief Signal declaration for QPrintPreviewDialog::rejected()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPrintPreviewDialog::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPrintPreviewDialog::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPrintPreviewDialog::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPrintPreviewDialog::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QDialog> &qtdecl_QDialog ();

qt_gsi::QtNativeClass<QPrintPreviewDialog> decl_QPrintPreviewDialog (qtdecl_QDialog (), "QtGui", "QPrintPreviewDialog_Native",
  methods_QPrintPreviewDialog (),
  "@hide\n@alias QPrintPreviewDialog");

GSI_QTGUI_PUBLIC gsi::Class<QPrintPreviewDialog> &qtdecl_QPrintPreviewDialog () { return decl_QPrintPreviewDialog; }

}


class QPrintPreviewDialog_Adaptor : public QPrintPreviewDialog, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPrintPreviewDialog_Adaptor();

  //  [adaptor ctor] QPrintPreviewDialog::QPrintPreviewDialog(QWidget *parent, QFlags<Qt::WindowType> flags)
  QPrintPreviewDialog_Adaptor() : QPrintPreviewDialog()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPrintPreviewDialog::QPrintPreviewDialog(QWidget *parent, QFlags<Qt::WindowType> flags)
  QPrintPreviewDialog_Adaptor(QWidget *parent) : QPrintPreviewDialog(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPrintPreviewDialog::QPrintPreviewDialog(QWidget *parent, QFlags<Qt::WindowType> flags)
  QPrintPreviewDialog_Adaptor(QWidget *parent, QFlags<Qt::WindowType> flags) : QPrintPreviewDialog(parent, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPrintPreviewDialog::QPrintPreviewDialog(QPrinter *printer, QWidget *parent, QFlags<Qt::WindowType> flags)
  QPrintPreviewDialog_Adaptor(QPrinter *printer) : QPrintPreviewDialog(printer)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPrintPreviewDialog::QPrintPreviewDialog(QPrinter *printer, QWidget *parent, QFlags<Qt::WindowType> flags)
  QPrintPreviewDialog_Adaptor(QPrinter *printer, QWidget *parent) : QPrintPreviewDialog(printer, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPrintPreviewDialog::QPrintPreviewDialog(QPrinter *printer, QWidget *parent, QFlags<Qt::WindowType> flags)
  QPrintPreviewDialog_Adaptor(QPrinter *printer, QWidget *parent, QFlags<Qt::WindowType> flags) : QPrintPreviewDialog(printer, parent, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QPrintPreviewDialog::adjustPosition(QWidget *)
  void fp_QPrintPreviewDialog_adjustPosition_1315 (QWidget *arg1) {
    QPrintPreviewDialog::adjustPosition(arg1);
  }

  //  [expose] void QPrintPreviewDialog::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QPrintPreviewDialog_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QPrintPreviewDialog::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QPrintPreviewDialog::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QPrintPreviewDialog_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QPrintPreviewDialog::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] bool QPrintPreviewDialog::focusNextChild()
  bool fp_QPrintPreviewDialog_focusNextChild_0 () {
    return QPrintPreviewDialog::focusNextChild();
  }

  //  [expose] bool QPrintPreviewDialog::focusPreviousChild()
  bool fp_QPrintPreviewDialog_focusPreviousChild_0 () {
    return QPrintPreviewDialog::focusPreviousChild();
  }

  //  [expose] int QPrintPreviewDialog::receivers(const char *signal)
  int fp_QPrintPreviewDialog_receivers_c1731 (const char *signal) const {
    return QPrintPreviewDialog::receivers(signal);
  }

  //  [expose] void QPrintPreviewDialog::resetInputContext()
  void fp_QPrintPreviewDialog_resetInputContext_0 () {
    QPrintPreviewDialog::resetInputContext();
  }

  //  [expose] QObject *QPrintPreviewDialog::sender()
  QObject * fp_QPrintPreviewDialog_sender_c0 () const {
    return QPrintPreviewDialog::sender();
  }

  //  [expose] void QPrintPreviewDialog::updateMicroFocus()
  void fp_QPrintPreviewDialog_updateMicroFocus_0 () {
    QPrintPreviewDialog::updateMicroFocus();
  }

  //  [adaptor impl] void QPrintPreviewDialog::accept()
  void cbs_accept_0_0()
  {
    QPrintPreviewDialog::accept();
  }

  virtual void accept()
  {
    if (cb_accept_0_0.can_issue()) {
      cb_accept_0_0.issue<QPrintPreviewDialog_Adaptor>(&QPrintPreviewDialog_Adaptor::cbs_accept_0_0);
    } else {
      QPrintPreviewDialog::accept();
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::done(int result)
  void cbs_done_767_0(int result)
  {
    QPrintPreviewDialog::done(result);
  }

  virtual void done(int result)
  {
    if (cb_done_767_0.can_issue()) {
      cb_done_767_0.issue<QPrintPreviewDialog_Adaptor, int>(&QPrintPreviewDialog_Adaptor::cbs_done_767_0, result);
    } else {
      QPrintPreviewDialog::done(result);
    }
  }

  //  [adaptor impl] int QPrintPreviewDialog::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QPrintPreviewDialog::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QPrintPreviewDialog_Adaptor, int, int>(&QPrintPreviewDialog_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QPrintPreviewDialog::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QPrintPreviewDialog::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QPrintPreviewDialog::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QPrintPreviewDialog_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QPrintPreviewDialog_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QPrintPreviewDialog::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QPrintPreviewDialog::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QPrintPreviewDialog::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QPrintPreviewDialog_Adaptor, QSize>(&QPrintPreviewDialog_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QPrintPreviewDialog::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QPrintPreviewDialog::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QPrintPreviewDialog::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QPrintPreviewDialog_Adaptor, QPaintEngine *>(&QPrintPreviewDialog_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QPrintPreviewDialog::paintEngine();
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::reject()
  void cbs_reject_0_0()
  {
    QPrintPreviewDialog::reject();
  }

  virtual void reject()
  {
    if (cb_reject_0_0.can_issue()) {
      cb_reject_0_0.issue<QPrintPreviewDialog_Adaptor>(&QPrintPreviewDialog_Adaptor::cbs_reject_0_0);
    } else {
      QPrintPreviewDialog::reject();
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QPrintPreviewDialog::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QPrintPreviewDialog_Adaptor, bool>(&QPrintPreviewDialog_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QPrintPreviewDialog::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QPrintPreviewDialog::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QPrintPreviewDialog::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QPrintPreviewDialog_Adaptor, QSize>(&QPrintPreviewDialog_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QPrintPreviewDialog::sizeHint();
    }
  }

  //  [emitter impl] void QPrintPreviewDialog::accepted()
  void emitter_QPrintPreviewDialog_accepted_0()
  {
    emit QPrintPreviewDialog::accepted();
  }

  //  [adaptor impl] void QPrintPreviewDialog::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QPrintPreviewDialog::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QPrintPreviewDialog_Adaptor, QActionEvent *>(&QPrintPreviewDialog_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QPrintPreviewDialog::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QPrintPreviewDialog::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QPrintPreviewDialog_Adaptor, QEvent *>(&QPrintPreviewDialog_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QPrintPreviewDialog::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QPrintPreviewDialog::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QPrintPreviewDialog_Adaptor, QChildEvent *>(&QPrintPreviewDialog_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QPrintPreviewDialog::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QPrintPreviewDialog::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QPrintPreviewDialog_Adaptor, QCloseEvent *>(&QPrintPreviewDialog_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QPrintPreviewDialog::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QPrintPreviewDialog::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QPrintPreviewDialog_Adaptor, QContextMenuEvent *>(&QPrintPreviewDialog_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QPrintPreviewDialog::contextMenuEvent(arg1);
    }
  }

  //  [emitter impl] void QPrintPreviewDialog::customContextMenuRequested(const QPoint &pos)
  void emitter_QPrintPreviewDialog_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QPrintPreviewDialog::customContextMenuRequested(pos);
  }

  //  [adaptor impl] void QPrintPreviewDialog::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QPrintPreviewDialog::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QPrintPreviewDialog_Adaptor, QEvent *>(&QPrintPreviewDialog_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QPrintPreviewDialog::customEvent(arg1);
    }
  }

  //  [emitter impl] void QPrintPreviewDialog::destroyed(QObject *)
  void emitter_QPrintPreviewDialog_destroyed_1302(QObject *arg1)
  {
    emit QPrintPreviewDialog::destroyed(arg1);
  }

  //  [adaptor impl] void QPrintPreviewDialog::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QPrintPreviewDialog::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QPrintPreviewDialog_Adaptor, const char *>(&QPrintPreviewDialog_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QPrintPreviewDialog::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QPrintPreviewDialog::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QPrintPreviewDialog_Adaptor, QDragEnterEvent *>(&QPrintPreviewDialog_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QPrintPreviewDialog::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QPrintPreviewDialog::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QPrintPreviewDialog_Adaptor, QDragLeaveEvent *>(&QPrintPreviewDialog_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QPrintPreviewDialog::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QPrintPreviewDialog::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QPrintPreviewDialog_Adaptor, QDragMoveEvent *>(&QPrintPreviewDialog_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QPrintPreviewDialog::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QPrintPreviewDialog::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QPrintPreviewDialog_Adaptor, QDropEvent *>(&QPrintPreviewDialog_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QPrintPreviewDialog::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QPrintPreviewDialog::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QPrintPreviewDialog_Adaptor, bool>(&QPrintPreviewDialog_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QPrintPreviewDialog::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QPrintPreviewDialog::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QPrintPreviewDialog_Adaptor, QEvent *>(&QPrintPreviewDialog_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QPrintPreviewDialog::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QPrintPreviewDialog::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QPrintPreviewDialog::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QPrintPreviewDialog_Adaptor, bool, QEvent *>(&QPrintPreviewDialog_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QPrintPreviewDialog::event(arg1);
    }
  }

  //  [adaptor impl] bool QPrintPreviewDialog::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QPrintPreviewDialog::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QPrintPreviewDialog_Adaptor, bool, QObject *, QEvent *>(&QPrintPreviewDialog_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QPrintPreviewDialog::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QPrintPreviewDialog::finished(int result)
  void emitter_QPrintPreviewDialog_finished_767(int result)
  {
    emit QPrintPreviewDialog::finished(result);
  }

  //  [adaptor impl] void QPrintPreviewDialog::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QPrintPreviewDialog::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QPrintPreviewDialog_Adaptor, QFocusEvent *>(&QPrintPreviewDialog_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QPrintPreviewDialog::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QPrintPreviewDialog::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QPrintPreviewDialog::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QPrintPreviewDialog_Adaptor, bool, bool>(&QPrintPreviewDialog_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QPrintPreviewDialog::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QPrintPreviewDialog::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QPrintPreviewDialog_Adaptor, QFocusEvent *>(&QPrintPreviewDialog_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QPrintPreviewDialog::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QPrintPreviewDialog::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QPrintPreviewDialog_Adaptor, const QFont &>(&QPrintPreviewDialog_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QPrintPreviewDialog::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QPrintPreviewDialog::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QPrintPreviewDialog_Adaptor, QHideEvent *>(&QPrintPreviewDialog_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QPrintPreviewDialog::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QPrintPreviewDialog::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QPrintPreviewDialog_Adaptor, QInputMethodEvent *>(&QPrintPreviewDialog_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QPrintPreviewDialog::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QPrintPreviewDialog::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QPrintPreviewDialog_Adaptor, QKeyEvent *>(&QPrintPreviewDialog_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QPrintPreviewDialog::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QPrintPreviewDialog::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QPrintPreviewDialog_Adaptor, QKeyEvent *>(&QPrintPreviewDialog_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QPrintPreviewDialog::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::languageChange()
  void cbs_languageChange_0_0()
  {
    QPrintPreviewDialog::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QPrintPreviewDialog_Adaptor>(&QPrintPreviewDialog_Adaptor::cbs_languageChange_0_0);
    } else {
      QPrintPreviewDialog::languageChange();
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QPrintPreviewDialog::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QPrintPreviewDialog_Adaptor, QEvent *>(&QPrintPreviewDialog_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QPrintPreviewDialog::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QPrintPreviewDialog::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QPrintPreviewDialog::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QPrintPreviewDialog_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QPrintPreviewDialog_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QPrintPreviewDialog::metric(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QPrintPreviewDialog::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QPrintPreviewDialog_Adaptor, QMouseEvent *>(&QPrintPreviewDialog_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QPrintPreviewDialog::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QPrintPreviewDialog::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QPrintPreviewDialog_Adaptor, QMouseEvent *>(&QPrintPreviewDialog_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QPrintPreviewDialog::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QPrintPreviewDialog::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QPrintPreviewDialog_Adaptor, QMouseEvent *>(&QPrintPreviewDialog_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QPrintPreviewDialog::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QPrintPreviewDialog::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QPrintPreviewDialog_Adaptor, QMouseEvent *>(&QPrintPreviewDialog_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QPrintPreviewDialog::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QPrintPreviewDialog::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QPrintPreviewDialog_Adaptor, QMoveEvent *>(&QPrintPreviewDialog_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QPrintPreviewDialog::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QPrintPreviewDialog::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QPrintPreviewDialog_Adaptor, QPaintEvent *>(&QPrintPreviewDialog_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QPrintPreviewDialog::paintEvent(arg1);
    }
  }

  //  [emitter impl] void QPrintPreviewDialog::paintRequested(QPrinter *printer)
  void emitter_QPrintPreviewDialog_paintRequested_1443(QPrinter *printer)
  {
    emit QPrintPreviewDialog::paintRequested(printer);
  }

  //  [adaptor impl] void QPrintPreviewDialog::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QPrintPreviewDialog::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QPrintPreviewDialog_Adaptor, const QPalette &>(&QPrintPreviewDialog_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QPrintPreviewDialog::paletteChange(arg1);
    }
  }

  //  [emitter impl] void QPrintPreviewDialog::rejected()
  void emitter_QPrintPreviewDialog_rejected_0()
  {
    emit QPrintPreviewDialog::rejected();
  }

  //  [adaptor impl] void QPrintPreviewDialog::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QPrintPreviewDialog::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QPrintPreviewDialog_Adaptor, QResizeEvent *>(&QPrintPreviewDialog_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QPrintPreviewDialog::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QPrintPreviewDialog::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QPrintPreviewDialog_Adaptor, QShowEvent *>(&QPrintPreviewDialog_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QPrintPreviewDialog::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QPrintPreviewDialog::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QPrintPreviewDialog_Adaptor, QStyle &>(&QPrintPreviewDialog_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QPrintPreviewDialog::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QPrintPreviewDialog::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QPrintPreviewDialog_Adaptor, QTabletEvent *>(&QPrintPreviewDialog_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QPrintPreviewDialog::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QPrintPreviewDialog::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QPrintPreviewDialog_Adaptor, QTimerEvent *>(&QPrintPreviewDialog_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QPrintPreviewDialog::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QPrintPreviewDialog::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QPrintPreviewDialog_Adaptor, QWheelEvent *>(&QPrintPreviewDialog_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QPrintPreviewDialog::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewDialog::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QPrintPreviewDialog::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QPrintPreviewDialog_Adaptor, bool>(&QPrintPreviewDialog_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QPrintPreviewDialog::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_accept_0_0;
  gsi::Callback cb_done_767_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reject_0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QPrintPreviewDialog_Adaptor::~QPrintPreviewDialog_Adaptor() { }

//  Constructor QPrintPreviewDialog::QPrintPreviewDialog(QWidget *parent, QFlags<Qt::WindowType> flags) (adaptor class)

static void _init_ctor_QPrintPreviewDialog_Adaptor_3702 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "0");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_1);
  decl->set_return_new<QPrintPreviewDialog_Adaptor> ();
}

static void _call_ctor_QPrintPreviewDialog_Adaptor_3702 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  QFlags<Qt::WindowType> arg2 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (0, heap);
  ret.write<QPrintPreviewDialog_Adaptor *> (new QPrintPreviewDialog_Adaptor (arg1, arg2));
}


//  Constructor QPrintPreviewDialog::QPrintPreviewDialog(QPrinter *printer, QWidget *parent, QFlags<Qt::WindowType> flags) (adaptor class)

static void _init_ctor_QPrintPreviewDialog_Adaptor_5037 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("printer");
  decl->add_arg<QPrinter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags", true, "0");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_2);
  decl->set_return_new<QPrintPreviewDialog_Adaptor> ();
}

static void _call_ctor_QPrintPreviewDialog_Adaptor_5037 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPrinter *arg1 = gsi::arg_reader<QPrinter * >() (args, heap);
  QWidget *arg2 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  QFlags<Qt::WindowType> arg3 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (0, heap);
  ret.write<QPrintPreviewDialog_Adaptor *> (new QPrintPreviewDialog_Adaptor (arg1, arg2, arg3));
}


// void QPrintPreviewDialog::accept()

static void _init_cbs_accept_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_accept_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_accept_0_0 ();
}

static void _set_callback_cbs_accept_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_accept_0_0 = cb;
}


// emitter void QPrintPreviewDialog::accepted()

static void _init_emitter_accepted_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_accepted_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QPrintPreviewDialog_Adaptor *)cls)->emitter_QPrintPreviewDialog_accepted_0 ();
}


// void QPrintPreviewDialog::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// exposed void QPrintPreviewDialog::adjustPosition(QWidget *)

static void _init_fp_adjustPosition_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_adjustPosition_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->fp_QPrintPreviewDialog_adjustPosition_1315 (arg1);
}


// void QPrintPreviewDialog::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QPrintPreviewDialog::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QPrintPreviewDialog::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QPrintPreviewDialog::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QPrintPreviewDialog::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->fp_QPrintPreviewDialog_create_2208 (arg1, arg2, arg3);
}


// emitter void QPrintPreviewDialog::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QPrintPreviewDialog_Adaptor *)cls)->emitter_QPrintPreviewDialog_customContextMenuRequested_1916 (arg1);
}


// void QPrintPreviewDialog::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QPrintPreviewDialog::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->fp_QPrintPreviewDialog_destroy_1620 (arg1, arg2);
}


// emitter void QPrintPreviewDialog::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QPrintPreviewDialog_Adaptor *)cls)->emitter_QPrintPreviewDialog_destroyed_1302 (arg1);
}


// void QPrintPreviewDialog::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// void QPrintPreviewDialog::done(int result)

static void _init_cbs_done_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("result");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_done_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_done_767_0 (arg1);
}

static void _set_callback_cbs_done_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_done_767_0 = cb;
}


// void QPrintPreviewDialog::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QPrintPreviewDialog::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QPrintPreviewDialog::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QPrintPreviewDialog::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QPrintPreviewDialog::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}


// void QPrintPreviewDialog::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}


// bool QPrintPreviewDialog::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPrintPreviewDialog_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QPrintPreviewDialog::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPrintPreviewDialog_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QPrintPreviewDialog::finished(int result)

static void _init_emitter_finished_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("result");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_finished_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QPrintPreviewDialog_Adaptor *)cls)->emitter_QPrintPreviewDialog_finished_767 (arg1);
}


// void QPrintPreviewDialog::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QPrintPreviewDialog::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPrintPreviewDialog_Adaptor *)cls)->fp_QPrintPreviewDialog_focusNextChild_0 ());
}


// bool QPrintPreviewDialog::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QPrintPreviewDialog_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QPrintPreviewDialog::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QPrintPreviewDialog::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPrintPreviewDialog_Adaptor *)cls)->fp_QPrintPreviewDialog_focusPreviousChild_0 ());
}


// void QPrintPreviewDialog::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = args.read<const QFont & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}


// int QPrintPreviewDialog::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QPrintPreviewDialog_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QPrintPreviewDialog::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QPrintPreviewDialog::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QPrintPreviewDialog::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QPrintPreviewDialog_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// void QPrintPreviewDialog::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QPrintPreviewDialog::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QPrintPreviewDialog::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}


// void QPrintPreviewDialog::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QPrintPreviewDialog::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QPrintPreviewDialog_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QPrintPreviewDialog::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QPrintPreviewDialog_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QPrintPreviewDialog::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QPrintPreviewDialog::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QPrintPreviewDialog::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QPrintPreviewDialog::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QPrintPreviewDialog::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// QPaintEngine *QPrintPreviewDialog::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QPrintPreviewDialog_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QPrintPreviewDialog::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// emitter void QPrintPreviewDialog::paintRequested(QPrinter *printer)

static void _init_emitter_paintRequested_1443 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("printer");
  decl->add_arg<QPrinter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_paintRequested_1443 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPrinter *arg1 = gsi::arg_reader<QPrinter * >() (args, heap);
  ((QPrintPreviewDialog_Adaptor *)cls)->emitter_QPrintPreviewDialog_paintRequested_1443 (arg1);
}


// void QPrintPreviewDialog::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = args.read<const QPalette & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}


// exposed int QPrintPreviewDialog::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QPrintPreviewDialog_Adaptor *)cls)->fp_QPrintPreviewDialog_receivers_c1731 (arg1));
}


// void QPrintPreviewDialog::reject()

static void _init_cbs_reject_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reject_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_reject_0_0 ();
}

static void _set_callback_cbs_reject_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_reject_0_0 = cb;
}


// emitter void QPrintPreviewDialog::rejected()

static void _init_emitter_rejected_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_rejected_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QPrintPreviewDialog_Adaptor *)cls)->emitter_QPrintPreviewDialog_rejected_0 ();
}


// exposed void QPrintPreviewDialog::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->fp_QPrintPreviewDialog_resetInputContext_0 ();
}


// void QPrintPreviewDialog::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed QObject *QPrintPreviewDialog::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QPrintPreviewDialog_Adaptor *)cls)->fp_QPrintPreviewDialog_sender_c0 ());
}


// void QPrintPreviewDialog::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// void QPrintPreviewDialog::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QPrintPreviewDialog::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QPrintPreviewDialog_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QPrintPreviewDialog::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyle &arg1 = args.read<QStyle & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}


// void QPrintPreviewDialog::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QPrintPreviewDialog::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QPrintPreviewDialog::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->fp_QPrintPreviewDialog_updateMicroFocus_0 ();
}


// void QPrintPreviewDialog::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// void QPrintPreviewDialog::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewDialog_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewDialog_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}


namespace gsi
{

gsi::Class<QPrintPreviewDialog> &qtdecl_QPrintPreviewDialog ();

static gsi::Methods methods_QPrintPreviewDialog_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPrintPreviewDialog::QPrintPreviewDialog(QWidget *parent, QFlags<Qt::WindowType> flags)\nThis method creates an object of class QPrintPreviewDialog.", &_init_ctor_QPrintPreviewDialog_Adaptor_3702, &_call_ctor_QPrintPreviewDialog_Adaptor_3702);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPrintPreviewDialog::QPrintPreviewDialog(QPrinter *printer, QWidget *parent, QFlags<Qt::WindowType> flags)\nThis method creates an object of class QPrintPreviewDialog.", &_init_ctor_QPrintPreviewDialog_Adaptor_5037, &_call_ctor_QPrintPreviewDialog_Adaptor_5037);
  methods += new qt_gsi::GenericMethod ("accept", "@brief Virtual method void QPrintPreviewDialog::accept()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0);
  methods += new qt_gsi::GenericMethod ("accept", "@hide", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0, &_set_callback_cbs_accept_0_0);
  methods += new qt_gsi::GenericMethod ("emit_accepted", "@brief Emitter for signal void QPrintPreviewDialog::accepted()\nCall this method to emit this signal.", false, &_init_emitter_accepted_0, &_call_emitter_accepted_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QPrintPreviewDialog::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*adjustPosition", "@brief Method void QPrintPreviewDialog::adjustPosition(QWidget *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_adjustPosition_1315, &_call_fp_adjustPosition_1315);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QPrintPreviewDialog::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QPrintPreviewDialog::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QPrintPreviewDialog::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QPrintPreviewDialog::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*qt_create", "@brief Method void QPrintPreviewDialog::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QPrintPreviewDialog::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QPrintPreviewDialog::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*qt_destroy", "@brief Method void QPrintPreviewDialog::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QPrintPreviewDialog::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QPrintPreviewDialog::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("done", "@brief Virtual method void QPrintPreviewDialog::done(int result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0);
  methods += new qt_gsi::GenericMethod ("done", "@hide", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0, &_set_callback_cbs_done_767_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QPrintPreviewDialog::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QPrintPreviewDialog::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QPrintPreviewDialog::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QPrintPreviewDialog::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QPrintPreviewDialog::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
  methods += new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QPrintPreviewDialog::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QPrintPreviewDialog::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QPrintPreviewDialog::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_finished", "@brief Emitter for signal void QPrintPreviewDialog::finished(int result)\nCall this method to emit this signal.", false, &_init_emitter_finished_767, &_call_emitter_finished_767);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QPrintPreviewDialog::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QPrintPreviewDialog::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QPrintPreviewDialog::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QPrintPreviewDialog::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QPrintPreviewDialog::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QPrintPreviewDialog::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
  methods += new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QPrintPreviewDialog::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QPrintPreviewDialog::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QPrintPreviewDialog::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QPrintPreviewDialog::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QPrintPreviewDialog::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QPrintPreviewDialog::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QPrintPreviewDialog::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
  methods += new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QPrintPreviewDialog::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QPrintPreviewDialog::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QPrintPreviewDialog::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QPrintPreviewDialog::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QPrintPreviewDialog::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QPrintPreviewDialog::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QPrintPreviewDialog::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QPrintPreviewDialog::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QPrintPreviewDialog::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QPrintPreviewDialog::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("emit_paintRequested", "@brief Emitter for signal void QPrintPreviewDialog::paintRequested(QPrinter *printer)\nCall this method to emit this signal.", false, &_init_emitter_paintRequested_1443, &_call_emitter_paintRequested_1443);
  methods += new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QPrintPreviewDialog::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
  methods += new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QPrintPreviewDialog::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("reject", "@brief Virtual method void QPrintPreviewDialog::reject()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0);
  methods += new qt_gsi::GenericMethod ("reject", "@hide", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0, &_set_callback_cbs_reject_0_0);
  methods += new qt_gsi::GenericMethod ("emit_rejected", "@brief Emitter for signal void QPrintPreviewDialog::rejected()\nCall this method to emit this signal.", false, &_init_emitter_rejected_0, &_call_emitter_rejected_0);
  methods += new qt_gsi::GenericMethod ("*resetInputContext", "@brief Method void QPrintPreviewDialog::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QPrintPreviewDialog::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QPrintPreviewDialog::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QPrintPreviewDialog::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QPrintPreviewDialog::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QPrintPreviewDialog::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QPrintPreviewDialog::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
  methods += new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QPrintPreviewDialog::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QPrintPreviewDialog::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QPrintPreviewDialog::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QPrintPreviewDialog::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QPrintPreviewDialog::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
  methods += new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
  return methods;
}

gsi::Class<QPrintPreviewDialog_Adaptor> decl_QPrintPreviewDialog_Adaptor (qtdecl_QPrintPreviewDialog (), "QtGui", "QPrintPreviewDialog",
  methods_QPrintPreviewDialog_Adaptor (),
  "@qt\n@brief Binding of QPrintPreviewDialog");

}

