
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQLocale.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QLocale>
#include <QDate>
#include <QDateTime>
#include <QTime>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QLocale

//  Constructor QLocale::QLocale()


static void _init_ctor_QLocale_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QLocale> ();
}

static void _call_ctor_QLocale_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLocale *> (new QLocale ());
}


//  Constructor QLocale::QLocale(const QString &name)


static void _init_ctor_QLocale_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QLocale> ();
}

static void _call_ctor_QLocale_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QLocale *> (new QLocale (arg1));
}


//  Constructor QLocale::QLocale(QLocale::Language language, QLocale::Country country)


static void _init_ctor_QLocale_3902 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("language");
  decl->add_arg<const qt_gsi::Converter<QLocale::Language>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("country", true, "QLocale::AnyCountry");
  decl->add_arg<const qt_gsi::Converter<QLocale::Country>::target_type & > (argspec_1);
  decl->set_return_new<QLocale> ();
}

static void _call_ctor_QLocale_3902 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::Language>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QLocale::Language>::target_type & >() (args, heap);
  const qt_gsi::Converter<QLocale::Country>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::Country>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::Country>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::Country>(heap, QLocale::AnyCountry), heap);
  ret.write<QLocale *> (new QLocale (qt_gsi::QtToCppAdaptor<QLocale::Language>(arg1).cref(), qt_gsi::QtToCppAdaptor<QLocale::Country>(arg2).cref()));
}


//  Constructor QLocale::QLocale(const QLocale &other)


static void _init_ctor_QLocale_1986 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return_new<QLocale> ();
}

static void _call_ctor_QLocale_1986 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLocale &arg1 = gsi::arg_reader<const QLocale & >() (args, heap);
  ret.write<QLocale *> (new QLocale (arg1));
}


// QString QLocale::amText()


static void _init_f_amText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_amText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QLocale *)cls)->amText ());
}


// QLocale::Country QLocale::country()


static void _init_f_country_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QLocale::Country>::target_type > ();
}

static void _call_f_country_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QLocale::Country>::target_type > ((qt_gsi::Converter<QLocale::Country>::target_type)qt_gsi::CppToQtAdaptor<QLocale::Country>(((QLocale *)cls)->country ()));
}


// QString QLocale::dateFormat(QLocale::FormatType format)


static void _init_f_dateFormat_c2260 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_dateFormat_c2260 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->dateFormat (qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg1).cref()));
}


// QString QLocale::dateTimeFormat(QLocale::FormatType format)


static void _init_f_dateTimeFormat_c2260 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_dateTimeFormat_c2260 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->dateTimeFormat (qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg1).cref()));
}


// QString QLocale::dayName(int, QLocale::FormatType format)


static void _init_f_dayName_c2919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_dayName_c2919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->dayName (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QChar QLocale::decimalPoint()


static void _init_f_decimalPoint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_decimalPoint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->decimalPoint ()));
}


// QChar QLocale::exponential()


static void _init_f_exponential_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_exponential_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->exponential ()));
}


// QChar QLocale::groupSeparator()


static void _init_f_groupSeparator_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_groupSeparator_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->groupSeparator ()));
}


// QLocale::Language QLocale::language()


static void _init_f_language_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QLocale::Language>::target_type > ();
}

static void _call_f_language_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QLocale::Language>::target_type > ((qt_gsi::Converter<QLocale::Language>::target_type)qt_gsi::CppToQtAdaptor<QLocale::Language>(((QLocale *)cls)->language ()));
}


// QLocale::MeasurementSystem QLocale::measurementSystem()


static void _init_f_measurementSystem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QLocale::MeasurementSystem>::target_type > ();
}

static void _call_f_measurementSystem_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QLocale::MeasurementSystem>::target_type > ((qt_gsi::Converter<QLocale::MeasurementSystem>::target_type)qt_gsi::CppToQtAdaptor<QLocale::MeasurementSystem>(((QLocale *)cls)->measurementSystem ()));
}


// QString QLocale::monthName(int, QLocale::FormatType format)


static void _init_f_monthName_c2919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_monthName_c2919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->monthName (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QString QLocale::name()


static void _init_f_name_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_name_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QLocale *)cls)->name ());
}


// QChar QLocale::negativeSign()


static void _init_f_negativeSign_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_negativeSign_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->negativeSign ()));
}


// QFlags<QLocale::NumberOption> QLocale::numberOptions()


static void _init_f_numberOptions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QLocale::NumberOption> > ();
}

static void _call_f_numberOptions_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QLocale::NumberOption> > ((QFlags<QLocale::NumberOption>)((QLocale *)cls)->numberOptions ());
}


// bool QLocale::operator!=(const QLocale &other)


static void _init_f_operator_excl__eq__c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLocale &arg1 = gsi::arg_reader<const QLocale & >() (args, heap);
  ret.write<bool > ((bool)((QLocale *)cls)->operator!= (arg1));
}


// QLocale &QLocale::operator=(const QLocale &other)


static void _init_f_operator_eq__1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return<QLocale & > ();
}

static void _call_f_operator_eq__1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLocale &arg1 = gsi::arg_reader<const QLocale & >() (args, heap);
  ret.write<QLocale & > ((QLocale &)((QLocale *)cls)->operator= (arg1));
}


// bool QLocale::operator==(const QLocale &other)


static void _init_f_operator_eq__eq__c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLocale &arg1 = gsi::arg_reader<const QLocale & >() (args, heap);
  ret.write<bool > ((bool)((QLocale *)cls)->operator== (arg1));
}


// QChar QLocale::percent()


static void _init_f_percent_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_percent_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->percent ()));
}


// QString QLocale::pmText()


static void _init_f_pmText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_pmText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QLocale *)cls)->pmText ());
}


// QChar QLocale::positiveSign()


static void _init_f_positiveSign_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_positiveSign_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->positiveSign ()));
}


// void QLocale::setNumberOptions(QFlags<QLocale::NumberOption> options)


static void _init_f_setNumberOptions_3171 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options");
  decl->add_arg<QFlags<QLocale::NumberOption> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNumberOptions_3171 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QLocale::NumberOption> arg1 = gsi::arg_reader<QFlags<QLocale::NumberOption> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLocale *)cls)->setNumberOptions (arg1);
}


// QString QLocale::standaloneDayName(int, QLocale::FormatType format)


static void _init_f_standaloneDayName_c2919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_standaloneDayName_c2919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->standaloneDayName (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QString QLocale::standaloneMonthName(int, QLocale::FormatType format)


static void _init_f_standaloneMonthName_c2919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_standaloneMonthName_c2919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->standaloneMonthName (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QString QLocale::timeFormat(QLocale::FormatType format)


static void _init_f_timeFormat_c2260 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_timeFormat_c2260 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->timeFormat (qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg1).cref()));
}


// QDate QLocale::toDate(const QString &string, QLocale::FormatType)


static void _init_f_toDate_c4177 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QDate > ();
}

static void _call_f_toDate_c4177 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QDate > ((QDate)((QLocale *)cls)->toDate (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QDate QLocale::toDate(const QString &string, const QString &format)


static void _init_f_toDate_c3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QDate > ();
}

static void _call_f_toDate_c3942 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QDate > ((QDate)((QLocale *)cls)->toDate (arg1, arg2));
}


// QDateTime QLocale::toDateTime(const QString &string, QLocale::FormatType format)


static void _init_f_toDateTime_c4177 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QDateTime > ();
}

static void _call_f_toDateTime_c4177 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QDateTime > ((QDateTime)((QLocale *)cls)->toDateTime (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QDateTime QLocale::toDateTime(const QString &string, const QString &format)


static void _init_f_toDateTime_c3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QDateTime > ();
}

static void _call_f_toDateTime_c3942 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QDateTime > ((QDateTime)((QLocale *)cls)->toDateTime (arg1, arg2));
}


// double QLocale::toDouble(const QString &s, bool *ok)


static void _init_f_toDouble_c2967 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<double > ();
}

static void _call_f_toDouble_c2967 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<double > ((double)((QLocale *)cls)->toDouble (arg1, arg2));
}


// float QLocale::toFloat(const QString &s, bool *ok)


static void _init_f_toFloat_c2967 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<float > ();
}

static void _call_f_toFloat_c2967 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<float > ((float)((QLocale *)cls)->toFloat (arg1, arg2));
}


// int QLocale::toInt(const QString &s, bool *ok, int base)


static void _init_f_toInt_c3626 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("base", true, "0");
  decl->add_arg<int > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_toInt_c3626 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<int > ((int)((QLocale *)cls)->toInt (arg1, arg2, arg3));
}


// qlonglong QLocale::toLongLong(const QString &s, bool *ok, int base)


static void _init_f_toLongLong_c3626 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("base", true, "0");
  decl->add_arg<int > (argspec_2);
  decl->set_return<qlonglong > ();
}

static void _call_f_toLongLong_c3626 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<qlonglong > ((qlonglong)((QLocale *)cls)->toLongLong (arg1, arg2, arg3));
}


// short int QLocale::toShort(const QString &s, bool *ok, int base)


static void _init_f_toShort_c3626 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("base", true, "0");
  decl->add_arg<int > (argspec_2);
  decl->set_return<short int > ();
}

static void _call_f_toShort_c3626 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<short int > ((short int)((QLocale *)cls)->toShort (arg1, arg2, arg3));
}


// QString QLocale::toString(qlonglong i)


static void _init_f_toString_c1413 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<qlonglong > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c1413 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qlonglong arg1 = gsi::arg_reader<qlonglong >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1));
}


// QString QLocale::toString(qulonglong i)


static void _init_f_toString_c1530 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<qulonglong > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c1530 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qulonglong arg1 = gsi::arg_reader<qulonglong >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1));
}


// QString QLocale::toString(short int i)


static void _init_f_toString_c1471 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<short int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c1471 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  short int arg1 = gsi::arg_reader<short int >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1));
}


// QString QLocale::toString(unsigned short int i)


static void _init_f_toString_c2476 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<unsigned short int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c2476 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned short int arg1 = gsi::arg_reader<unsigned short int >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1));
}


// QString QLocale::toString(int i)


static void _init_f_toString_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1));
}


// QString QLocale::toString(unsigned int i)


static void _init_f_toString_c1772 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c1772 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = gsi::arg_reader<unsigned int >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1));
}


// QString QLocale::toString(double i, char f, int prec)


static void _init_f_toString_c2472 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("f", true, "'g'");
  decl->add_arg<char > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("prec", true, "6");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_toString_c2472 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  char arg2 = args ? gsi::arg_reader<char >() (args, heap) : gsi::arg_maker<char >() ('g', heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (6, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, arg2, arg3));
}


// QString QLocale::toString(float i, char f, int prec)


static void _init_f_toString_c2371 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<float > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("f", true, "'g'");
  decl->add_arg<char > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("prec", true, "6");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_toString_c2371 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  char arg2 = args ? gsi::arg_reader<char >() (args, heap) : gsi::arg_maker<char >() ('g', heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (6, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, arg2, arg3));
}


// QString QLocale::toString(const QDate &date, const QString &formatStr)


static void _init_f_toString_c3693 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<const QDate & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("formatStr");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c3693 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDate &arg1 = gsi::arg_reader<const QDate & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, arg2));
}


// QString QLocale::toString(const QDate &date, QLocale::FormatType format)


static void _init_f_toString_c3928 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<const QDate & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c3928 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDate &arg1 = gsi::arg_reader<const QDate & >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QString QLocale::toString(const QTime &time, const QString &formatStr)


static void _init_f_toString_c3710 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("time");
  decl->add_arg<const QTime & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("formatStr");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c3710 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTime &arg1 = gsi::arg_reader<const QTime & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, arg2));
}


// QString QLocale::toString(const QTime &time, QLocale::FormatType format)


static void _init_f_toString_c3945 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("time");
  decl->add_arg<const QTime & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c3945 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTime &arg1 = gsi::arg_reader<const QTime & >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QString QLocale::toString(const QDateTime &dateTime, QLocale::FormatType format)


static void _init_f_toString_c4327 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dateTime");
  decl->add_arg<const QDateTime & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c4327 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDateTime &arg1 = gsi::arg_reader<const QDateTime & >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QString QLocale::toString(const QDateTime &dateTime, const QString &format)


static void _init_f_toString_c4092 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dateTime");
  decl->add_arg<const QDateTime & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c4092 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDateTime &arg1 = gsi::arg_reader<const QDateTime & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, arg2));
}


// QTime QLocale::toTime(const QString &string, QLocale::FormatType)


static void _init_f_toTime_c4177 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QTime > ();
}

static void _call_f_toTime_c4177 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QTime > ((QTime)((QLocale *)cls)->toTime (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}


// QTime QLocale::toTime(const QString &string, const QString &format)


static void _init_f_toTime_c3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QTime > ();
}

static void _call_f_toTime_c3942 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QTime > ((QTime)((QLocale *)cls)->toTime (arg1, arg2));
}


// unsigned int QLocale::toUInt(const QString &s, bool *ok, int base)


static void _init_f_toUInt_c3626 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("base", true, "0");
  decl->add_arg<int > (argspec_2);
  decl->set_return<unsigned int > ();
}

static void _call_f_toUInt_c3626 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<unsigned int > ((unsigned int)((QLocale *)cls)->toUInt (arg1, arg2, arg3));
}


// qlonglong QLocale::toULongLong(const QString &s, bool *ok, int base)


static void _init_f_toULongLong_c3626 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("base", true, "0");
  decl->add_arg<int > (argspec_2);
  decl->set_return<qlonglong > ();
}

static void _call_f_toULongLong_c3626 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<qlonglong > ((qlonglong)((QLocale *)cls)->toULongLong (arg1, arg2, arg3));
}


// unsigned short int QLocale::toUShort(const QString &s, bool *ok, int base)


static void _init_f_toUShort_c3626 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("base", true, "0");
  decl->add_arg<int > (argspec_2);
  decl->set_return<unsigned short int > ();
}

static void _call_f_toUShort_c3626 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<unsigned short int > ((unsigned short int)((QLocale *)cls)->toUShort (arg1, arg2, arg3));
}


// QChar QLocale::zeroDigit()


static void _init_f_zeroDigit_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_zeroDigit_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->zeroDigit ()));
}


// static QLocale QLocale::c()


static void _init_f_c_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QLocale > ();
}

static void _call_f_c_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLocale > ((QLocale)QLocale::c ());
}


// static QList<QLocale::Country> QLocale::countriesForLanguage(QLocale::Language lang)


static void _init_f_countriesForLanguage_2029 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lang");
  decl->add_arg<const qt_gsi::Converter<QLocale::Language>::target_type & > (argspec_0);
  decl->set_return<QList<QLocale::Country> > ();
}

static void _call_f_countriesForLanguage_2029 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::Language>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QLocale::Language>::target_type & >() (args, heap);
  ret.write<QList<QLocale::Country> > ((QList<QLocale::Country>)QLocale::countriesForLanguage (qt_gsi::QtToCppAdaptor<QLocale::Language>(arg1).cref()));
}


// static QString QLocale::countryToString(QLocale::Country country)


static void _init_f_countryToString_1981 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("country");
  decl->add_arg<const qt_gsi::Converter<QLocale::Country>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_countryToString_1981 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::Country>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QLocale::Country>::target_type & >() (args, heap);
  ret.write<QString > ((QString)QLocale::countryToString (qt_gsi::QtToCppAdaptor<QLocale::Country>(arg1).cref()));
}


// static QString QLocale::languageToString(QLocale::Language language)


static void _init_f_languageToString_2029 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("language");
  decl->add_arg<const qt_gsi::Converter<QLocale::Language>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_languageToString_2029 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::Language>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QLocale::Language>::target_type & >() (args, heap);
  ret.write<QString > ((QString)QLocale::languageToString (qt_gsi::QtToCppAdaptor<QLocale::Language>(arg1).cref()));
}


// static void QLocale::setDefault(const QLocale &locale)


static void _init_f_setDefault_1986 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("locale");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefault_1986 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLocale &arg1 = gsi::arg_reader<const QLocale & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QLocale::setDefault (arg1);
}


// static QLocale QLocale::system()


static void _init_f_system_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QLocale > ();
}

static void _call_f_system_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLocale > ((QLocale)QLocale::system ());
}



namespace gsi
{

static gsi::Methods methods_QLocale () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLocale::QLocale()\nThis method creates an object of class QLocale.", &_init_ctor_QLocale_0, &_call_ctor_QLocale_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLocale::QLocale(const QString &name)\nThis method creates an object of class QLocale.", &_init_ctor_QLocale_2025, &_call_ctor_QLocale_2025);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLocale::QLocale(QLocale::Language language, QLocale::Country country)\nThis method creates an object of class QLocale.", &_init_ctor_QLocale_3902, &_call_ctor_QLocale_3902);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLocale::QLocale(const QLocale &other)\nThis method creates an object of class QLocale.", &_init_ctor_QLocale_1986, &_call_ctor_QLocale_1986);
  methods += new qt_gsi::GenericMethod ("amText", "@brief Method QString QLocale::amText()\n", true, &_init_f_amText_c0, &_call_f_amText_c0);
  methods += new qt_gsi::GenericMethod ("country", "@brief Method QLocale::Country QLocale::country()\n", true, &_init_f_country_c0, &_call_f_country_c0);
  methods += new qt_gsi::GenericMethod ("dateFormat", "@brief Method QString QLocale::dateFormat(QLocale::FormatType format)\n", true, &_init_f_dateFormat_c2260, &_call_f_dateFormat_c2260);
  methods += new qt_gsi::GenericMethod ("dateTimeFormat", "@brief Method QString QLocale::dateTimeFormat(QLocale::FormatType format)\n", true, &_init_f_dateTimeFormat_c2260, &_call_f_dateTimeFormat_c2260);
  methods += new qt_gsi::GenericMethod ("dayName", "@brief Method QString QLocale::dayName(int, QLocale::FormatType format)\n", true, &_init_f_dayName_c2919, &_call_f_dayName_c2919);
  methods += new qt_gsi::GenericMethod ("decimalPoint", "@brief Method QChar QLocale::decimalPoint()\n", true, &_init_f_decimalPoint_c0, &_call_f_decimalPoint_c0);
  methods += new qt_gsi::GenericMethod ("exponential", "@brief Method QChar QLocale::exponential()\n", true, &_init_f_exponential_c0, &_call_f_exponential_c0);
  methods += new qt_gsi::GenericMethod ("groupSeparator", "@brief Method QChar QLocale::groupSeparator()\n", true, &_init_f_groupSeparator_c0, &_call_f_groupSeparator_c0);
  methods += new qt_gsi::GenericMethod ("language", "@brief Method QLocale::Language QLocale::language()\n", true, &_init_f_language_c0, &_call_f_language_c0);
  methods += new qt_gsi::GenericMethod ("measurementSystem", "@brief Method QLocale::MeasurementSystem QLocale::measurementSystem()\n", true, &_init_f_measurementSystem_c0, &_call_f_measurementSystem_c0);
  methods += new qt_gsi::GenericMethod ("monthName", "@brief Method QString QLocale::monthName(int, QLocale::FormatType format)\n", true, &_init_f_monthName_c2919, &_call_f_monthName_c2919);
  methods += new qt_gsi::GenericMethod ("name", "@brief Method QString QLocale::name()\n", true, &_init_f_name_c0, &_call_f_name_c0);
  methods += new qt_gsi::GenericMethod ("negativeSign", "@brief Method QChar QLocale::negativeSign()\n", true, &_init_f_negativeSign_c0, &_call_f_negativeSign_c0);
  methods += new qt_gsi::GenericMethod (":numberOptions", "@brief Method QFlags<QLocale::NumberOption> QLocale::numberOptions()\n", true, &_init_f_numberOptions_c0, &_call_f_numberOptions_c0);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QLocale::operator!=(const QLocale &other)\n", true, &_init_f_operator_excl__eq__c1986, &_call_f_operator_excl__eq__c1986);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QLocale &QLocale::operator=(const QLocale &other)\n", false, &_init_f_operator_eq__1986, &_call_f_operator_eq__1986);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QLocale::operator==(const QLocale &other)\n", true, &_init_f_operator_eq__eq__c1986, &_call_f_operator_eq__eq__c1986);
  methods += new qt_gsi::GenericMethod ("percent", "@brief Method QChar QLocale::percent()\n", true, &_init_f_percent_c0, &_call_f_percent_c0);
  methods += new qt_gsi::GenericMethod ("pmText", "@brief Method QString QLocale::pmText()\n", true, &_init_f_pmText_c0, &_call_f_pmText_c0);
  methods += new qt_gsi::GenericMethod ("positiveSign", "@brief Method QChar QLocale::positiveSign()\n", true, &_init_f_positiveSign_c0, &_call_f_positiveSign_c0);
  methods += new qt_gsi::GenericMethod ("setNumberOptions|numberOptions=", "@brief Method void QLocale::setNumberOptions(QFlags<QLocale::NumberOption> options)\n", false, &_init_f_setNumberOptions_3171, &_call_f_setNumberOptions_3171);
  methods += new qt_gsi::GenericMethod ("standaloneDayName", "@brief Method QString QLocale::standaloneDayName(int, QLocale::FormatType format)\n", true, &_init_f_standaloneDayName_c2919, &_call_f_standaloneDayName_c2919);
  methods += new qt_gsi::GenericMethod ("standaloneMonthName", "@brief Method QString QLocale::standaloneMonthName(int, QLocale::FormatType format)\n", true, &_init_f_standaloneMonthName_c2919, &_call_f_standaloneMonthName_c2919);
  methods += new qt_gsi::GenericMethod ("timeFormat", "@brief Method QString QLocale::timeFormat(QLocale::FormatType format)\n", true, &_init_f_timeFormat_c2260, &_call_f_timeFormat_c2260);
  methods += new qt_gsi::GenericMethod ("toDate", "@brief Method QDate QLocale::toDate(const QString &string, QLocale::FormatType)\n", true, &_init_f_toDate_c4177, &_call_f_toDate_c4177);
  methods += new qt_gsi::GenericMethod ("toDate", "@brief Method QDate QLocale::toDate(const QString &string, const QString &format)\n", true, &_init_f_toDate_c3942, &_call_f_toDate_c3942);
  methods += new qt_gsi::GenericMethod ("toDateTime", "@brief Method QDateTime QLocale::toDateTime(const QString &string, QLocale::FormatType format)\n", true, &_init_f_toDateTime_c4177, &_call_f_toDateTime_c4177);
  methods += new qt_gsi::GenericMethod ("toDateTime", "@brief Method QDateTime QLocale::toDateTime(const QString &string, const QString &format)\n", true, &_init_f_toDateTime_c3942, &_call_f_toDateTime_c3942);
  methods += new qt_gsi::GenericMethod ("toDouble", "@brief Method double QLocale::toDouble(const QString &s, bool *ok)\n", true, &_init_f_toDouble_c2967, &_call_f_toDouble_c2967);
  methods += new qt_gsi::GenericMethod ("toFloat", "@brief Method float QLocale::toFloat(const QString &s, bool *ok)\n", true, &_init_f_toFloat_c2967, &_call_f_toFloat_c2967);
  methods += new qt_gsi::GenericMethod ("toInt", "@brief Method int QLocale::toInt(const QString &s, bool *ok, int base)\n", true, &_init_f_toInt_c3626, &_call_f_toInt_c3626);
  methods += new qt_gsi::GenericMethod ("toLongLong", "@brief Method qlonglong QLocale::toLongLong(const QString &s, bool *ok, int base)\n", true, &_init_f_toLongLong_c3626, &_call_f_toLongLong_c3626);
  methods += new qt_gsi::GenericMethod ("toShort", "@brief Method short int QLocale::toShort(const QString &s, bool *ok, int base)\n", true, &_init_f_toShort_c3626, &_call_f_toShort_c3626);
  methods += new qt_gsi::GenericMethod ("toString_ll", "@brief Method QString QLocale::toString(qlonglong i)\n", true, &_init_f_toString_c1413, &_call_f_toString_c1413);
  methods += new qt_gsi::GenericMethod ("toString_ull", "@brief Method QString QLocale::toString(qulonglong i)\n", true, &_init_f_toString_c1530, &_call_f_toString_c1530);
  methods += new qt_gsi::GenericMethod ("toString_s", "@brief Method QString QLocale::toString(short int i)\n", true, &_init_f_toString_c1471, &_call_f_toString_c1471);
  methods += new qt_gsi::GenericMethod ("toString_us", "@brief Method QString QLocale::toString(unsigned short int i)\n", true, &_init_f_toString_c2476, &_call_f_toString_c2476);
  methods += new qt_gsi::GenericMethod ("toString_i", "@brief Method QString QLocale::toString(int i)\n", true, &_init_f_toString_c767, &_call_f_toString_c767);
  methods += new qt_gsi::GenericMethod ("toString_ui", "@brief Method QString QLocale::toString(unsigned int i)\n", true, &_init_f_toString_c1772, &_call_f_toString_c1772);
  methods += new qt_gsi::GenericMethod ("toString_d", "@brief Method QString QLocale::toString(double i, char f, int prec)\n", true, &_init_f_toString_c2472, &_call_f_toString_c2472);
  methods += new qt_gsi::GenericMethod ("toString_f", "@brief Method QString QLocale::toString(float i, char f, int prec)\n", true, &_init_f_toString_c2371, &_call_f_toString_c2371);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QLocale::toString(const QDate &date, const QString &formatStr)\n", true, &_init_f_toString_c3693, &_call_f_toString_c3693);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QLocale::toString(const QDate &date, QLocale::FormatType format)\n", true, &_init_f_toString_c3928, &_call_f_toString_c3928);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QLocale::toString(const QTime &time, const QString &formatStr)\n", true, &_init_f_toString_c3710, &_call_f_toString_c3710);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QLocale::toString(const QTime &time, QLocale::FormatType format)\n", true, &_init_f_toString_c3945, &_call_f_toString_c3945);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QLocale::toString(const QDateTime &dateTime, QLocale::FormatType format)\n", true, &_init_f_toString_c4327, &_call_f_toString_c4327);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QLocale::toString(const QDateTime &dateTime, const QString &format)\n", true, &_init_f_toString_c4092, &_call_f_toString_c4092);
  methods += new qt_gsi::GenericMethod ("toTime", "@brief Method QTime QLocale::toTime(const QString &string, QLocale::FormatType)\n", true, &_init_f_toTime_c4177, &_call_f_toTime_c4177);
  methods += new qt_gsi::GenericMethod ("toTime", "@brief Method QTime QLocale::toTime(const QString &string, const QString &format)\n", true, &_init_f_toTime_c3942, &_call_f_toTime_c3942);
  methods += new qt_gsi::GenericMethod ("toUInt", "@brief Method unsigned int QLocale::toUInt(const QString &s, bool *ok, int base)\n", true, &_init_f_toUInt_c3626, &_call_f_toUInt_c3626);
  methods += new qt_gsi::GenericMethod ("toULongLong", "@brief Method qlonglong QLocale::toULongLong(const QString &s, bool *ok, int base)\n", true, &_init_f_toULongLong_c3626, &_call_f_toULongLong_c3626);
  methods += new qt_gsi::GenericMethod ("toUShort", "@brief Method unsigned short int QLocale::toUShort(const QString &s, bool *ok, int base)\n", true, &_init_f_toUShort_c3626, &_call_f_toUShort_c3626);
  methods += new qt_gsi::GenericMethod ("zeroDigit", "@brief Method QChar QLocale::zeroDigit()\n", true, &_init_f_zeroDigit_c0, &_call_f_zeroDigit_c0);
  methods += new qt_gsi::GenericStaticMethod ("c", "@brief Static method QLocale QLocale::c()\nThis method is static and can be called without an instance.", &_init_f_c_0, &_call_f_c_0);
  methods += new qt_gsi::GenericStaticMethod ("countriesForLanguage", "@brief Static method QList<QLocale::Country> QLocale::countriesForLanguage(QLocale::Language lang)\nThis method is static and can be called without an instance.", &_init_f_countriesForLanguage_2029, &_call_f_countriesForLanguage_2029);
  methods += new qt_gsi::GenericStaticMethod ("countryToString", "@brief Static method QString QLocale::countryToString(QLocale::Country country)\nThis method is static and can be called without an instance.", &_init_f_countryToString_1981, &_call_f_countryToString_1981);
  methods += new qt_gsi::GenericStaticMethod ("languageToString", "@brief Static method QString QLocale::languageToString(QLocale::Language language)\nThis method is static and can be called without an instance.", &_init_f_languageToString_2029, &_call_f_languageToString_2029);
  methods += new qt_gsi::GenericStaticMethod ("setDefault", "@brief Static method void QLocale::setDefault(const QLocale &locale)\nThis method is static and can be called without an instance.", &_init_f_setDefault_1986, &_call_f_setDefault_1986);
  methods += new qt_gsi::GenericStaticMethod ("system", "@brief Static method QLocale QLocale::system()\nThis method is static and can be called without an instance.", &_init_f_system_0, &_call_f_system_0);
  return methods;
}

gsi::Class<QLocale> decl_QLocale ("QtCore", "QLocale",
  methods_QLocale (),
  "@qt\n@brief Binding of QLocale");


GSI_QTCORE_PUBLIC gsi::Class<QLocale> &qtdecl_QLocale () { return decl_QLocale; }

}


//  Implementation of the enum wrapper class for QLocale::Country
namespace qt_gsi
{

static gsi::Enum<QLocale::Country> decl_QLocale_Country_Enum ("QtCore", "QLocale_Country",
    gsi::enum_const ("AnyCountry", QLocale::AnyCountry, "@brief Enum constant QLocale::AnyCountry") +
    gsi::enum_const ("Afghanistan", QLocale::Afghanistan, "@brief Enum constant QLocale::Afghanistan") +
    gsi::enum_const ("Albania", QLocale::Albania, "@brief Enum constant QLocale::Albania") +
    gsi::enum_const ("Algeria", QLocale::Algeria, "@brief Enum constant QLocale::Algeria") +
    gsi::enum_const ("AmericanSamoa", QLocale::AmericanSamoa, "@brief Enum constant QLocale::AmericanSamoa") +
    gsi::enum_const ("Andorra", QLocale::Andorra, "@brief Enum constant QLocale::Andorra") +
    gsi::enum_const ("Angola", QLocale::Angola, "@brief Enum constant QLocale::Angola") +
    gsi::enum_const ("Anguilla", QLocale::Anguilla, "@brief Enum constant QLocale::Anguilla") +
    gsi::enum_const ("Antarctica", QLocale::Antarctica, "@brief Enum constant QLocale::Antarctica") +
    gsi::enum_const ("AntiguaAndBarbuda", QLocale::AntiguaAndBarbuda, "@brief Enum constant QLocale::AntiguaAndBarbuda") +
    gsi::enum_const ("Argentina", QLocale::Argentina, "@brief Enum constant QLocale::Argentina") +
    gsi::enum_const ("Armenia", QLocale::Armenia, "@brief Enum constant QLocale::Armenia") +
    gsi::enum_const ("Aruba", QLocale::Aruba, "@brief Enum constant QLocale::Aruba") +
    gsi::enum_const ("Australia", QLocale::Australia, "@brief Enum constant QLocale::Australia") +
    gsi::enum_const ("Austria", QLocale::Austria, "@brief Enum constant QLocale::Austria") +
    gsi::enum_const ("Azerbaijan", QLocale::Azerbaijan, "@brief Enum constant QLocale::Azerbaijan") +
    gsi::enum_const ("Bahamas", QLocale::Bahamas, "@brief Enum constant QLocale::Bahamas") +
    gsi::enum_const ("Bahrain", QLocale::Bahrain, "@brief Enum constant QLocale::Bahrain") +
    gsi::enum_const ("Bangladesh", QLocale::Bangladesh, "@brief Enum constant QLocale::Bangladesh") +
    gsi::enum_const ("Barbados", QLocale::Barbados, "@brief Enum constant QLocale::Barbados") +
    gsi::enum_const ("Belarus", QLocale::Belarus, "@brief Enum constant QLocale::Belarus") +
    gsi::enum_const ("Belgium", QLocale::Belgium, "@brief Enum constant QLocale::Belgium") +
    gsi::enum_const ("Belize", QLocale::Belize, "@brief Enum constant QLocale::Belize") +
    gsi::enum_const ("Benin", QLocale::Benin, "@brief Enum constant QLocale::Benin") +
    gsi::enum_const ("Bermuda", QLocale::Bermuda, "@brief Enum constant QLocale::Bermuda") +
    gsi::enum_const ("Bhutan", QLocale::Bhutan, "@brief Enum constant QLocale::Bhutan") +
    gsi::enum_const ("Bolivia", QLocale::Bolivia, "@brief Enum constant QLocale::Bolivia") +
    gsi::enum_const ("BosniaAndHerzegowina", QLocale::BosniaAndHerzegowina, "@brief Enum constant QLocale::BosniaAndHerzegowina") +
    gsi::enum_const ("Botswana", QLocale::Botswana, "@brief Enum constant QLocale::Botswana") +
    gsi::enum_const ("BouvetIsland", QLocale::BouvetIsland, "@brief Enum constant QLocale::BouvetIsland") +
    gsi::enum_const ("Brazil", QLocale::Brazil, "@brief Enum constant QLocale::Brazil") +
    gsi::enum_const ("BritishIndianOceanTerritory", QLocale::BritishIndianOceanTerritory, "@brief Enum constant QLocale::BritishIndianOceanTerritory") +
    gsi::enum_const ("BruneiDarussalam", QLocale::BruneiDarussalam, "@brief Enum constant QLocale::BruneiDarussalam") +
    gsi::enum_const ("Bulgaria", QLocale::Bulgaria, "@brief Enum constant QLocale::Bulgaria") +
    gsi::enum_const ("BurkinaFaso", QLocale::BurkinaFaso, "@brief Enum constant QLocale::BurkinaFaso") +
    gsi::enum_const ("Burundi", QLocale::Burundi, "@brief Enum constant QLocale::Burundi") +
    gsi::enum_const ("Cambodia", QLocale::Cambodia, "@brief Enum constant QLocale::Cambodia") +
    gsi::enum_const ("Cameroon", QLocale::Cameroon, "@brief Enum constant QLocale::Cameroon") +
    gsi::enum_const ("Canada", QLocale::Canada, "@brief Enum constant QLocale::Canada") +
    gsi::enum_const ("CapeVerde", QLocale::CapeVerde, "@brief Enum constant QLocale::CapeVerde") +
    gsi::enum_const ("CaymanIslands", QLocale::CaymanIslands, "@brief Enum constant QLocale::CaymanIslands") +
    gsi::enum_const ("CentralAfricanRepublic", QLocale::CentralAfricanRepublic, "@brief Enum constant QLocale::CentralAfricanRepublic") +
    gsi::enum_const ("Chad", QLocale::Chad, "@brief Enum constant QLocale::Chad") +
    gsi::enum_const ("Chile", QLocale::Chile, "@brief Enum constant QLocale::Chile") +
    gsi::enum_const ("China", QLocale::China, "@brief Enum constant QLocale::China") +
    gsi::enum_const ("ChristmasIsland", QLocale::ChristmasIsland, "@brief Enum constant QLocale::ChristmasIsland") +
    gsi::enum_const ("CocosIslands", QLocale::CocosIslands, "@brief Enum constant QLocale::CocosIslands") +
    gsi::enum_const ("Colombia", QLocale::Colombia, "@brief Enum constant QLocale::Colombia") +
    gsi::enum_const ("Comoros", QLocale::Comoros, "@brief Enum constant QLocale::Comoros") +
    gsi::enum_const ("DemocraticRepublicOfCongo", QLocale::DemocraticRepublicOfCongo, "@brief Enum constant QLocale::DemocraticRepublicOfCongo") +
    gsi::enum_const ("PeoplesRepublicOfCongo", QLocale::PeoplesRepublicOfCongo, "@brief Enum constant QLocale::PeoplesRepublicOfCongo") +
    gsi::enum_const ("CookIslands", QLocale::CookIslands, "@brief Enum constant QLocale::CookIslands") +
    gsi::enum_const ("CostaRica", QLocale::CostaRica, "@brief Enum constant QLocale::CostaRica") +
    gsi::enum_const ("IvoryCoast", QLocale::IvoryCoast, "@brief Enum constant QLocale::IvoryCoast") +
    gsi::enum_const ("Croatia", QLocale::Croatia, "@brief Enum constant QLocale::Croatia") +
    gsi::enum_const ("Cuba", QLocale::Cuba, "@brief Enum constant QLocale::Cuba") +
    gsi::enum_const ("Cyprus", QLocale::Cyprus, "@brief Enum constant QLocale::Cyprus") +
    gsi::enum_const ("CzechRepublic", QLocale::CzechRepublic, "@brief Enum constant QLocale::CzechRepublic") +
    gsi::enum_const ("Denmark", QLocale::Denmark, "@brief Enum constant QLocale::Denmark") +
    gsi::enum_const ("Djibouti", QLocale::Djibouti, "@brief Enum constant QLocale::Djibouti") +
    gsi::enum_const ("Dominica", QLocale::Dominica, "@brief Enum constant QLocale::Dominica") +
    gsi::enum_const ("DominicanRepublic", QLocale::DominicanRepublic, "@brief Enum constant QLocale::DominicanRepublic") +
    gsi::enum_const ("EastTimor", QLocale::EastTimor, "@brief Enum constant QLocale::EastTimor") +
    gsi::enum_const ("Ecuador", QLocale::Ecuador, "@brief Enum constant QLocale::Ecuador") +
    gsi::enum_const ("Egypt", QLocale::Egypt, "@brief Enum constant QLocale::Egypt") +
    gsi::enum_const ("ElSalvador", QLocale::ElSalvador, "@brief Enum constant QLocale::ElSalvador") +
    gsi::enum_const ("EquatorialGuinea", QLocale::EquatorialGuinea, "@brief Enum constant QLocale::EquatorialGuinea") +
    gsi::enum_const ("Eritrea", QLocale::Eritrea, "@brief Enum constant QLocale::Eritrea") +
    gsi::enum_const ("Estonia", QLocale::Estonia, "@brief Enum constant QLocale::Estonia") +
    gsi::enum_const ("Ethiopia", QLocale::Ethiopia, "@brief Enum constant QLocale::Ethiopia") +
    gsi::enum_const ("FalklandIslands", QLocale::FalklandIslands, "@brief Enum constant QLocale::FalklandIslands") +
    gsi::enum_const ("FaroeIslands", QLocale::FaroeIslands, "@brief Enum constant QLocale::FaroeIslands") +
    gsi::enum_const ("FijiCountry", QLocale::FijiCountry, "@brief Enum constant QLocale::FijiCountry") +
    gsi::enum_const ("Finland", QLocale::Finland, "@brief Enum constant QLocale::Finland") +
    gsi::enum_const ("France", QLocale::France, "@brief Enum constant QLocale::France") +
    gsi::enum_const ("MetropolitanFrance", QLocale::MetropolitanFrance, "@brief Enum constant QLocale::MetropolitanFrance") +
    gsi::enum_const ("FrenchGuiana", QLocale::FrenchGuiana, "@brief Enum constant QLocale::FrenchGuiana") +
    gsi::enum_const ("FrenchPolynesia", QLocale::FrenchPolynesia, "@brief Enum constant QLocale::FrenchPolynesia") +
    gsi::enum_const ("FrenchSouthernTerritories", QLocale::FrenchSouthernTerritories, "@brief Enum constant QLocale::FrenchSouthernTerritories") +
    gsi::enum_const ("Gabon", QLocale::Gabon, "@brief Enum constant QLocale::Gabon") +
    gsi::enum_const ("Gambia", QLocale::Gambia, "@brief Enum constant QLocale::Gambia") +
    gsi::enum_const ("Georgia", QLocale::Georgia, "@brief Enum constant QLocale::Georgia") +
    gsi::enum_const ("Germany", QLocale::Germany, "@brief Enum constant QLocale::Germany") +
    gsi::enum_const ("Ghana", QLocale::Ghana, "@brief Enum constant QLocale::Ghana") +
    gsi::enum_const ("Gibraltar", QLocale::Gibraltar, "@brief Enum constant QLocale::Gibraltar") +
    gsi::enum_const ("Greece", QLocale::Greece, "@brief Enum constant QLocale::Greece") +
    gsi::enum_const ("Greenland", QLocale::Greenland, "@brief Enum constant QLocale::Greenland") +
    gsi::enum_const ("Grenada", QLocale::Grenada, "@brief Enum constant QLocale::Grenada") +
    gsi::enum_const ("Guadeloupe", QLocale::Guadeloupe, "@brief Enum constant QLocale::Guadeloupe") +
    gsi::enum_const ("Guam", QLocale::Guam, "@brief Enum constant QLocale::Guam") +
    gsi::enum_const ("Guatemala", QLocale::Guatemala, "@brief Enum constant QLocale::Guatemala") +
    gsi::enum_const ("Guinea", QLocale::Guinea, "@brief Enum constant QLocale::Guinea") +
    gsi::enum_const ("GuineaBissau", QLocale::GuineaBissau, "@brief Enum constant QLocale::GuineaBissau") +
    gsi::enum_const ("Guyana", QLocale::Guyana, "@brief Enum constant QLocale::Guyana") +
    gsi::enum_const ("Haiti", QLocale::Haiti, "@brief Enum constant QLocale::Haiti") +
    gsi::enum_const ("HeardAndMcDonaldIslands", QLocale::HeardAndMcDonaldIslands, "@brief Enum constant QLocale::HeardAndMcDonaldIslands") +
    gsi::enum_const ("Honduras", QLocale::Honduras, "@brief Enum constant QLocale::Honduras") +
    gsi::enum_const ("HongKong", QLocale::HongKong, "@brief Enum constant QLocale::HongKong") +
    gsi::enum_const ("Hungary", QLocale::Hungary, "@brief Enum constant QLocale::Hungary") +
    gsi::enum_const ("Iceland", QLocale::Iceland, "@brief Enum constant QLocale::Iceland") +
    gsi::enum_const ("India", QLocale::India, "@brief Enum constant QLocale::India") +
    gsi::enum_const ("Indonesia", QLocale::Indonesia, "@brief Enum constant QLocale::Indonesia") +
    gsi::enum_const ("Iran", QLocale::Iran, "@brief Enum constant QLocale::Iran") +
    gsi::enum_const ("Iraq", QLocale::Iraq, "@brief Enum constant QLocale::Iraq") +
    gsi::enum_const ("Ireland", QLocale::Ireland, "@brief Enum constant QLocale::Ireland") +
    gsi::enum_const ("Israel", QLocale::Israel, "@brief Enum constant QLocale::Israel") +
    gsi::enum_const ("Italy", QLocale::Italy, "@brief Enum constant QLocale::Italy") +
    gsi::enum_const ("Jamaica", QLocale::Jamaica, "@brief Enum constant QLocale::Jamaica") +
    gsi::enum_const ("Japan", QLocale::Japan, "@brief Enum constant QLocale::Japan") +
    gsi::enum_const ("Jordan", QLocale::Jordan, "@brief Enum constant QLocale::Jordan") +
    gsi::enum_const ("Kazakhstan", QLocale::Kazakhstan, "@brief Enum constant QLocale::Kazakhstan") +
    gsi::enum_const ("Kenya", QLocale::Kenya, "@brief Enum constant QLocale::Kenya") +
    gsi::enum_const ("Kiribati", QLocale::Kiribati, "@brief Enum constant QLocale::Kiribati") +
    gsi::enum_const ("DemocraticRepublicOfKorea", QLocale::DemocraticRepublicOfKorea, "@brief Enum constant QLocale::DemocraticRepublicOfKorea") +
    gsi::enum_const ("RepublicOfKorea", QLocale::RepublicOfKorea, "@brief Enum constant QLocale::RepublicOfKorea") +
    gsi::enum_const ("Kuwait", QLocale::Kuwait, "@brief Enum constant QLocale::Kuwait") +
    gsi::enum_const ("Kyrgyzstan", QLocale::Kyrgyzstan, "@brief Enum constant QLocale::Kyrgyzstan") +
    gsi::enum_const ("Lao", QLocale::Lao, "@brief Enum constant QLocale::Lao") +
    gsi::enum_const ("Latvia", QLocale::Latvia, "@brief Enum constant QLocale::Latvia") +
    gsi::enum_const ("Lebanon", QLocale::Lebanon, "@brief Enum constant QLocale::Lebanon") +
    gsi::enum_const ("Lesotho", QLocale::Lesotho, "@brief Enum constant QLocale::Lesotho") +
    gsi::enum_const ("Liberia", QLocale::Liberia, "@brief Enum constant QLocale::Liberia") +
    gsi::enum_const ("LibyanArabJamahiriya", QLocale::LibyanArabJamahiriya, "@brief Enum constant QLocale::LibyanArabJamahiriya") +
    gsi::enum_const ("Liechtenstein", QLocale::Liechtenstein, "@brief Enum constant QLocale::Liechtenstein") +
    gsi::enum_const ("Lithuania", QLocale::Lithuania, "@brief Enum constant QLocale::Lithuania") +
    gsi::enum_const ("Luxembourg", QLocale::Luxembourg, "@brief Enum constant QLocale::Luxembourg") +
    gsi::enum_const ("Macau", QLocale::Macau, "@brief Enum constant QLocale::Macau") +
    gsi::enum_const ("Macedonia", QLocale::Macedonia, "@brief Enum constant QLocale::Macedonia") +
    gsi::enum_const ("Madagascar", QLocale::Madagascar, "@brief Enum constant QLocale::Madagascar") +
    gsi::enum_const ("Malawi", QLocale::Malawi, "@brief Enum constant QLocale::Malawi") +
    gsi::enum_const ("Malaysia", QLocale::Malaysia, "@brief Enum constant QLocale::Malaysia") +
    gsi::enum_const ("Maldives", QLocale::Maldives, "@brief Enum constant QLocale::Maldives") +
    gsi::enum_const ("Mali", QLocale::Mali, "@brief Enum constant QLocale::Mali") +
    gsi::enum_const ("Malta", QLocale::Malta, "@brief Enum constant QLocale::Malta") +
    gsi::enum_const ("MarshallIslands", QLocale::MarshallIslands, "@brief Enum constant QLocale::MarshallIslands") +
    gsi::enum_const ("Martinique", QLocale::Martinique, "@brief Enum constant QLocale::Martinique") +
    gsi::enum_const ("Mauritania", QLocale::Mauritania, "@brief Enum constant QLocale::Mauritania") +
    gsi::enum_const ("Mauritius", QLocale::Mauritius, "@brief Enum constant QLocale::Mauritius") +
    gsi::enum_const ("Mayotte", QLocale::Mayotte, "@brief Enum constant QLocale::Mayotte") +
    gsi::enum_const ("Mexico", QLocale::Mexico, "@brief Enum constant QLocale::Mexico") +
    gsi::enum_const ("Micronesia", QLocale::Micronesia, "@brief Enum constant QLocale::Micronesia") +
    gsi::enum_const ("Moldova", QLocale::Moldova, "@brief Enum constant QLocale::Moldova") +
    gsi::enum_const ("Monaco", QLocale::Monaco, "@brief Enum constant QLocale::Monaco") +
    gsi::enum_const ("Mongolia", QLocale::Mongolia, "@brief Enum constant QLocale::Mongolia") +
    gsi::enum_const ("Montserrat", QLocale::Montserrat, "@brief Enum constant QLocale::Montserrat") +
    gsi::enum_const ("Morocco", QLocale::Morocco, "@brief Enum constant QLocale::Morocco") +
    gsi::enum_const ("Mozambique", QLocale::Mozambique, "@brief Enum constant QLocale::Mozambique") +
    gsi::enum_const ("Myanmar", QLocale::Myanmar, "@brief Enum constant QLocale::Myanmar") +
    gsi::enum_const ("Namibia", QLocale::Namibia, "@brief Enum constant QLocale::Namibia") +
    gsi::enum_const ("NauruCountry", QLocale::NauruCountry, "@brief Enum constant QLocale::NauruCountry") +
    gsi::enum_const ("Nepal", QLocale::Nepal, "@brief Enum constant QLocale::Nepal") +
    gsi::enum_const ("Netherlands", QLocale::Netherlands, "@brief Enum constant QLocale::Netherlands") +
    gsi::enum_const ("NetherlandsAntilles", QLocale::NetherlandsAntilles, "@brief Enum constant QLocale::NetherlandsAntilles") +
    gsi::enum_const ("NewCaledonia", QLocale::NewCaledonia, "@brief Enum constant QLocale::NewCaledonia") +
    gsi::enum_const ("NewZealand", QLocale::NewZealand, "@brief Enum constant QLocale::NewZealand") +
    gsi::enum_const ("Nicaragua", QLocale::Nicaragua, "@brief Enum constant QLocale::Nicaragua") +
    gsi::enum_const ("Niger", QLocale::Niger, "@brief Enum constant QLocale::Niger") +
    gsi::enum_const ("Nigeria", QLocale::Nigeria, "@brief Enum constant QLocale::Nigeria") +
    gsi::enum_const ("Niue", QLocale::Niue, "@brief Enum constant QLocale::Niue") +
    gsi::enum_const ("NorfolkIsland", QLocale::NorfolkIsland, "@brief Enum constant QLocale::NorfolkIsland") +
    gsi::enum_const ("NorthernMarianaIslands", QLocale::NorthernMarianaIslands, "@brief Enum constant QLocale::NorthernMarianaIslands") +
    gsi::enum_const ("Norway", QLocale::Norway, "@brief Enum constant QLocale::Norway") +
    gsi::enum_const ("Oman", QLocale::Oman, "@brief Enum constant QLocale::Oman") +
    gsi::enum_const ("Pakistan", QLocale::Pakistan, "@brief Enum constant QLocale::Pakistan") +
    gsi::enum_const ("Palau", QLocale::Palau, "@brief Enum constant QLocale::Palau") +
    gsi::enum_const ("PalestinianTerritory", QLocale::PalestinianTerritory, "@brief Enum constant QLocale::PalestinianTerritory") +
    gsi::enum_const ("Panama", QLocale::Panama, "@brief Enum constant QLocale::Panama") +
    gsi::enum_const ("PapuaNewGuinea", QLocale::PapuaNewGuinea, "@brief Enum constant QLocale::PapuaNewGuinea") +
    gsi::enum_const ("Paraguay", QLocale::Paraguay, "@brief Enum constant QLocale::Paraguay") +
    gsi::enum_const ("Peru", QLocale::Peru, "@brief Enum constant QLocale::Peru") +
    gsi::enum_const ("Philippines", QLocale::Philippines, "@brief Enum constant QLocale::Philippines") +
    gsi::enum_const ("Pitcairn", QLocale::Pitcairn, "@brief Enum constant QLocale::Pitcairn") +
    gsi::enum_const ("Poland", QLocale::Poland, "@brief Enum constant QLocale::Poland") +
    gsi::enum_const ("Portugal", QLocale::Portugal, "@brief Enum constant QLocale::Portugal") +
    gsi::enum_const ("PuertoRico", QLocale::PuertoRico, "@brief Enum constant QLocale::PuertoRico") +
    gsi::enum_const ("Qatar", QLocale::Qatar, "@brief Enum constant QLocale::Qatar") +
    gsi::enum_const ("Reunion", QLocale::Reunion, "@brief Enum constant QLocale::Reunion") +
    gsi::enum_const ("Romania", QLocale::Romania, "@brief Enum constant QLocale::Romania") +
    gsi::enum_const ("RussianFederation", QLocale::RussianFederation, "@brief Enum constant QLocale::RussianFederation") +
    gsi::enum_const ("Rwanda", QLocale::Rwanda, "@brief Enum constant QLocale::Rwanda") +
    gsi::enum_const ("SaintKittsAndNevis", QLocale::SaintKittsAndNevis, "@brief Enum constant QLocale::SaintKittsAndNevis") +
    gsi::enum_const ("StLucia", QLocale::StLucia, "@brief Enum constant QLocale::StLucia") +
    gsi::enum_const ("StVincentAndTheGrenadines", QLocale::StVincentAndTheGrenadines, "@brief Enum constant QLocale::StVincentAndTheGrenadines") +
    gsi::enum_const ("Samoa", QLocale::Samoa, "@brief Enum constant QLocale::Samoa") +
    gsi::enum_const ("SanMarino", QLocale::SanMarino, "@brief Enum constant QLocale::SanMarino") +
    gsi::enum_const ("SaoTomeAndPrincipe", QLocale::SaoTomeAndPrincipe, "@brief Enum constant QLocale::SaoTomeAndPrincipe") +
    gsi::enum_const ("SaudiArabia", QLocale::SaudiArabia, "@brief Enum constant QLocale::SaudiArabia") +
    gsi::enum_const ("Senegal", QLocale::Senegal, "@brief Enum constant QLocale::Senegal") +
    gsi::enum_const ("Seychelles", QLocale::Seychelles, "@brief Enum constant QLocale::Seychelles") +
    gsi::enum_const ("SierraLeone", QLocale::SierraLeone, "@brief Enum constant QLocale::SierraLeone") +
    gsi::enum_const ("Singapore", QLocale::Singapore, "@brief Enum constant QLocale::Singapore") +
    gsi::enum_const ("Slovakia", QLocale::Slovakia, "@brief Enum constant QLocale::Slovakia") +
    gsi::enum_const ("Slovenia", QLocale::Slovenia, "@brief Enum constant QLocale::Slovenia") +
    gsi::enum_const ("SolomonIslands", QLocale::SolomonIslands, "@brief Enum constant QLocale::SolomonIslands") +
    gsi::enum_const ("Somalia", QLocale::Somalia, "@brief Enum constant QLocale::Somalia") +
    gsi::enum_const ("SouthAfrica", QLocale::SouthAfrica, "@brief Enum constant QLocale::SouthAfrica") +
    gsi::enum_const ("SouthGeorgiaAndTheSouthSandwichIslands", QLocale::SouthGeorgiaAndTheSouthSandwichIslands, "@brief Enum constant QLocale::SouthGeorgiaAndTheSouthSandwichIslands") +
    gsi::enum_const ("Spain", QLocale::Spain, "@brief Enum constant QLocale::Spain") +
    gsi::enum_const ("SriLanka", QLocale::SriLanka, "@brief Enum constant QLocale::SriLanka") +
    gsi::enum_const ("StHelena", QLocale::StHelena, "@brief Enum constant QLocale::StHelena") +
    gsi::enum_const ("StPierreAndMiquelon", QLocale::StPierreAndMiquelon, "@brief Enum constant QLocale::StPierreAndMiquelon") +
    gsi::enum_const ("Sudan", QLocale::Sudan, "@brief Enum constant QLocale::Sudan") +
    gsi::enum_const ("Suriname", QLocale::Suriname, "@brief Enum constant QLocale::Suriname") +
    gsi::enum_const ("SvalbardAndJanMayenIslands", QLocale::SvalbardAndJanMayenIslands, "@brief Enum constant QLocale::SvalbardAndJanMayenIslands") +
    gsi::enum_const ("Swaziland", QLocale::Swaziland, "@brief Enum constant QLocale::Swaziland") +
    gsi::enum_const ("Sweden", QLocale::Sweden, "@brief Enum constant QLocale::Sweden") +
    gsi::enum_const ("Switzerland", QLocale::Switzerland, "@brief Enum constant QLocale::Switzerland") +
    gsi::enum_const ("SyrianArabRepublic", QLocale::SyrianArabRepublic, "@brief Enum constant QLocale::SyrianArabRepublic") +
    gsi::enum_const ("Taiwan", QLocale::Taiwan, "@brief Enum constant QLocale::Taiwan") +
    gsi::enum_const ("Tajikistan", QLocale::Tajikistan, "@brief Enum constant QLocale::Tajikistan") +
    gsi::enum_const ("Tanzania", QLocale::Tanzania, "@brief Enum constant QLocale::Tanzania") +
    gsi::enum_const ("Thailand", QLocale::Thailand, "@brief Enum constant QLocale::Thailand") +
    gsi::enum_const ("Togo", QLocale::Togo, "@brief Enum constant QLocale::Togo") +
    gsi::enum_const ("Tokelau", QLocale::Tokelau, "@brief Enum constant QLocale::Tokelau") +
    gsi::enum_const ("TongaCountry", QLocale::TongaCountry, "@brief Enum constant QLocale::TongaCountry") +
    gsi::enum_const ("TrinidadAndTobago", QLocale::TrinidadAndTobago, "@brief Enum constant QLocale::TrinidadAndTobago") +
    gsi::enum_const ("Tunisia", QLocale::Tunisia, "@brief Enum constant QLocale::Tunisia") +
    gsi::enum_const ("Turkey", QLocale::Turkey, "@brief Enum constant QLocale::Turkey") +
    gsi::enum_const ("Turkmenistan", QLocale::Turkmenistan, "@brief Enum constant QLocale::Turkmenistan") +
    gsi::enum_const ("TurksAndCaicosIslands", QLocale::TurksAndCaicosIslands, "@brief Enum constant QLocale::TurksAndCaicosIslands") +
    gsi::enum_const ("Tuvalu", QLocale::Tuvalu, "@brief Enum constant QLocale::Tuvalu") +
    gsi::enum_const ("Uganda", QLocale::Uganda, "@brief Enum constant QLocale::Uganda") +
    gsi::enum_const ("Ukraine", QLocale::Ukraine, "@brief Enum constant QLocale::Ukraine") +
    gsi::enum_const ("UnitedArabEmirates", QLocale::UnitedArabEmirates, "@brief Enum constant QLocale::UnitedArabEmirates") +
    gsi::enum_const ("UnitedKingdom", QLocale::UnitedKingdom, "@brief Enum constant QLocale::UnitedKingdom") +
    gsi::enum_const ("UnitedStates", QLocale::UnitedStates, "@brief Enum constant QLocale::UnitedStates") +
    gsi::enum_const ("UnitedStatesMinorOutlyingIslands", QLocale::UnitedStatesMinorOutlyingIslands, "@brief Enum constant QLocale::UnitedStatesMinorOutlyingIslands") +
    gsi::enum_const ("Uruguay", QLocale::Uruguay, "@brief Enum constant QLocale::Uruguay") +
    gsi::enum_const ("Uzbekistan", QLocale::Uzbekistan, "@brief Enum constant QLocale::Uzbekistan") +
    gsi::enum_const ("Vanuatu", QLocale::Vanuatu, "@brief Enum constant QLocale::Vanuatu") +
    gsi::enum_const ("VaticanCityState", QLocale::VaticanCityState, "@brief Enum constant QLocale::VaticanCityState") +
    gsi::enum_const ("Venezuela", QLocale::Venezuela, "@brief Enum constant QLocale::Venezuela") +
    gsi::enum_const ("VietNam", QLocale::VietNam, "@brief Enum constant QLocale::VietNam") +
    gsi::enum_const ("BritishVirginIslands", QLocale::BritishVirginIslands, "@brief Enum constant QLocale::BritishVirginIslands") +
    gsi::enum_const ("USVirginIslands", QLocale::USVirginIslands, "@brief Enum constant QLocale::USVirginIslands") +
    gsi::enum_const ("WallisAndFutunaIslands", QLocale::WallisAndFutunaIslands, "@brief Enum constant QLocale::WallisAndFutunaIslands") +
    gsi::enum_const ("WesternSahara", QLocale::WesternSahara, "@brief Enum constant QLocale::WesternSahara") +
    gsi::enum_const ("Yemen", QLocale::Yemen, "@brief Enum constant QLocale::Yemen") +
    gsi::enum_const ("Yugoslavia", QLocale::Yugoslavia, "@brief Enum constant QLocale::Yugoslavia") +
    gsi::enum_const ("Zambia", QLocale::Zambia, "@brief Enum constant QLocale::Zambia") +
    gsi::enum_const ("Zimbabwe", QLocale::Zimbabwe, "@brief Enum constant QLocale::Zimbabwe") +
    gsi::enum_const ("SerbiaAndMontenegro", QLocale::SerbiaAndMontenegro, "@brief Enum constant QLocale::SerbiaAndMontenegro") +
    gsi::enum_const ("LastCountry", QLocale::LastCountry, "@brief Enum constant QLocale::LastCountry"),
  "@qt\n@brief This class represents the QLocale::Country enum");

static gsi::QFlagsClass<QLocale::Country > decl_QLocale_Country_Enums ("QtCore", "QLocale_QFlags_Country",
  "@qt\n@brief This class represents the QFlags<QLocale::Country> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocale> inject_QLocale_Country_Enum_in_parent (decl_QLocale_Country_Enum.defs ());
static gsi::ClassExt<QLocale> decl_QLocale_Country_Enum_as_child (decl_QLocale_Country_Enum, "Country");
static gsi::ClassExt<QLocale> decl_QLocale_Country_Enums_as_child (decl_QLocale_Country_Enums, "QFlags_Country");

}


//  Implementation of the enum wrapper class for QLocale::FormatType
namespace qt_gsi
{

static gsi::Enum<QLocale::FormatType> decl_QLocale_FormatType_Enum ("QtCore", "QLocale_FormatType",
    gsi::enum_const ("LongFormat", QLocale::LongFormat, "@brief Enum constant QLocale::LongFormat") +
    gsi::enum_const ("ShortFormat", QLocale::ShortFormat, "@brief Enum constant QLocale::ShortFormat") +
    gsi::enum_const ("NarrowFormat", QLocale::NarrowFormat, "@brief Enum constant QLocale::NarrowFormat"),
  "@qt\n@brief This class represents the QLocale::FormatType enum");

static gsi::QFlagsClass<QLocale::FormatType > decl_QLocale_FormatType_Enums ("QtCore", "QLocale_QFlags_FormatType",
  "@qt\n@brief This class represents the QFlags<QLocale::FormatType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocale> inject_QLocale_FormatType_Enum_in_parent (decl_QLocale_FormatType_Enum.defs ());
static gsi::ClassExt<QLocale> decl_QLocale_FormatType_Enum_as_child (decl_QLocale_FormatType_Enum, "FormatType");
static gsi::ClassExt<QLocale> decl_QLocale_FormatType_Enums_as_child (decl_QLocale_FormatType_Enums, "QFlags_FormatType");

}


//  Implementation of the enum wrapper class for QLocale::Language
namespace qt_gsi
{

static gsi::Enum<QLocale::Language> decl_QLocale_Language_Enum ("QtCore", "QLocale_Language",
    gsi::enum_const ("C", QLocale::C, "@brief Enum constant QLocale::C") +
    gsi::enum_const ("Abkhazian", QLocale::Abkhazian, "@brief Enum constant QLocale::Abkhazian") +
    gsi::enum_const ("Afan", QLocale::Afan, "@brief Enum constant QLocale::Afan") +
    gsi::enum_const ("Afar", QLocale::Afar, "@brief Enum constant QLocale::Afar") +
    gsi::enum_const ("Afrikaans", QLocale::Afrikaans, "@brief Enum constant QLocale::Afrikaans") +
    gsi::enum_const ("Albanian", QLocale::Albanian, "@brief Enum constant QLocale::Albanian") +
    gsi::enum_const ("Amharic", QLocale::Amharic, "@brief Enum constant QLocale::Amharic") +
    gsi::enum_const ("Arabic", QLocale::Arabic, "@brief Enum constant QLocale::Arabic") +
    gsi::enum_const ("Armenian", QLocale::Armenian, "@brief Enum constant QLocale::Armenian") +
    gsi::enum_const ("Assamese", QLocale::Assamese, "@brief Enum constant QLocale::Assamese") +
    gsi::enum_const ("Aymara", QLocale::Aymara, "@brief Enum constant QLocale::Aymara") +
    gsi::enum_const ("Azerbaijani", QLocale::Azerbaijani, "@brief Enum constant QLocale::Azerbaijani") +
    gsi::enum_const ("Bashkir", QLocale::Bashkir, "@brief Enum constant QLocale::Bashkir") +
    gsi::enum_const ("Basque", QLocale::Basque, "@brief Enum constant QLocale::Basque") +
    gsi::enum_const ("Bengali", QLocale::Bengali, "@brief Enum constant QLocale::Bengali") +
    gsi::enum_const ("Bhutani", QLocale::Bhutani, "@brief Enum constant QLocale::Bhutani") +
    gsi::enum_const ("Bihari", QLocale::Bihari, "@brief Enum constant QLocale::Bihari") +
    gsi::enum_const ("Bislama", QLocale::Bislama, "@brief Enum constant QLocale::Bislama") +
    gsi::enum_const ("Breton", QLocale::Breton, "@brief Enum constant QLocale::Breton") +
    gsi::enum_const ("Bulgarian", QLocale::Bulgarian, "@brief Enum constant QLocale::Bulgarian") +
    gsi::enum_const ("Burmese", QLocale::Burmese, "@brief Enum constant QLocale::Burmese") +
    gsi::enum_const ("Byelorussian", QLocale::Byelorussian, "@brief Enum constant QLocale::Byelorussian") +
    gsi::enum_const ("Cambodian", QLocale::Cambodian, "@brief Enum constant QLocale::Cambodian") +
    gsi::enum_const ("Catalan", QLocale::Catalan, "@brief Enum constant QLocale::Catalan") +
    gsi::enum_const ("Chinese", QLocale::Chinese, "@brief Enum constant QLocale::Chinese") +
    gsi::enum_const ("Corsican", QLocale::Corsican, "@brief Enum constant QLocale::Corsican") +
    gsi::enum_const ("Croatian", QLocale::Croatian, "@brief Enum constant QLocale::Croatian") +
    gsi::enum_const ("Czech", QLocale::Czech, "@brief Enum constant QLocale::Czech") +
    gsi::enum_const ("Danish", QLocale::Danish, "@brief Enum constant QLocale::Danish") +
    gsi::enum_const ("Dutch", QLocale::Dutch, "@brief Enum constant QLocale::Dutch") +
    gsi::enum_const ("English", QLocale::English, "@brief Enum constant QLocale::English") +
    gsi::enum_const ("Esperanto", QLocale::Esperanto, "@brief Enum constant QLocale::Esperanto") +
    gsi::enum_const ("Estonian", QLocale::Estonian, "@brief Enum constant QLocale::Estonian") +
    gsi::enum_const ("Faroese", QLocale::Faroese, "@brief Enum constant QLocale::Faroese") +
    gsi::enum_const ("FijiLanguage", QLocale::FijiLanguage, "@brief Enum constant QLocale::FijiLanguage") +
    gsi::enum_const ("Finnish", QLocale::Finnish, "@brief Enum constant QLocale::Finnish") +
    gsi::enum_const ("French", QLocale::French, "@brief Enum constant QLocale::French") +
    gsi::enum_const ("Frisian", QLocale::Frisian, "@brief Enum constant QLocale::Frisian") +
    gsi::enum_const ("Gaelic", QLocale::Gaelic, "@brief Enum constant QLocale::Gaelic") +
    gsi::enum_const ("Galician", QLocale::Galician, "@brief Enum constant QLocale::Galician") +
    gsi::enum_const ("Georgian", QLocale::Georgian, "@brief Enum constant QLocale::Georgian") +
    gsi::enum_const ("German", QLocale::German, "@brief Enum constant QLocale::German") +
    gsi::enum_const ("Greek", QLocale::Greek, "@brief Enum constant QLocale::Greek") +
    gsi::enum_const ("Greenlandic", QLocale::Greenlandic, "@brief Enum constant QLocale::Greenlandic") +
    gsi::enum_const ("Guarani", QLocale::Guarani, "@brief Enum constant QLocale::Guarani") +
    gsi::enum_const ("Gujarati", QLocale::Gujarati, "@brief Enum constant QLocale::Gujarati") +
    gsi::enum_const ("Hausa", QLocale::Hausa, "@brief Enum constant QLocale::Hausa") +
    gsi::enum_const ("Hebrew", QLocale::Hebrew, "@brief Enum constant QLocale::Hebrew") +
    gsi::enum_const ("Hindi", QLocale::Hindi, "@brief Enum constant QLocale::Hindi") +
    gsi::enum_const ("Hungarian", QLocale::Hungarian, "@brief Enum constant QLocale::Hungarian") +
    gsi::enum_const ("Icelandic", QLocale::Icelandic, "@brief Enum constant QLocale::Icelandic") +
    gsi::enum_const ("Indonesian", QLocale::Indonesian, "@brief Enum constant QLocale::Indonesian") +
    gsi::enum_const ("Interlingua", QLocale::Interlingua, "@brief Enum constant QLocale::Interlingua") +
    gsi::enum_const ("Interlingue", QLocale::Interlingue, "@brief Enum constant QLocale::Interlingue") +
    gsi::enum_const ("Inuktitut", QLocale::Inuktitut, "@brief Enum constant QLocale::Inuktitut") +
    gsi::enum_const ("Inupiak", QLocale::Inupiak, "@brief Enum constant QLocale::Inupiak") +
    gsi::enum_const ("Irish", QLocale::Irish, "@brief Enum constant QLocale::Irish") +
    gsi::enum_const ("Italian", QLocale::Italian, "@brief Enum constant QLocale::Italian") +
    gsi::enum_const ("Japanese", QLocale::Japanese, "@brief Enum constant QLocale::Japanese") +
    gsi::enum_const ("Javanese", QLocale::Javanese, "@brief Enum constant QLocale::Javanese") +
    gsi::enum_const ("Kannada", QLocale::Kannada, "@brief Enum constant QLocale::Kannada") +
    gsi::enum_const ("Kashmiri", QLocale::Kashmiri, "@brief Enum constant QLocale::Kashmiri") +
    gsi::enum_const ("Kazakh", QLocale::Kazakh, "@brief Enum constant QLocale::Kazakh") +
    gsi::enum_const ("Kinyarwanda", QLocale::Kinyarwanda, "@brief Enum constant QLocale::Kinyarwanda") +
    gsi::enum_const ("Kirghiz", QLocale::Kirghiz, "@brief Enum constant QLocale::Kirghiz") +
    gsi::enum_const ("Korean", QLocale::Korean, "@brief Enum constant QLocale::Korean") +
    gsi::enum_const ("Kurdish", QLocale::Kurdish, "@brief Enum constant QLocale::Kurdish") +
    gsi::enum_const ("Kurundi", QLocale::Kurundi, "@brief Enum constant QLocale::Kurundi") +
    gsi::enum_const ("Laothian", QLocale::Laothian, "@brief Enum constant QLocale::Laothian") +
    gsi::enum_const ("Latin", QLocale::Latin, "@brief Enum constant QLocale::Latin") +
    gsi::enum_const ("Latvian", QLocale::Latvian, "@brief Enum constant QLocale::Latvian") +
    gsi::enum_const ("Lingala", QLocale::Lingala, "@brief Enum constant QLocale::Lingala") +
    gsi::enum_const ("Lithuanian", QLocale::Lithuanian, "@brief Enum constant QLocale::Lithuanian") +
    gsi::enum_const ("Macedonian", QLocale::Macedonian, "@brief Enum constant QLocale::Macedonian") +
    gsi::enum_const ("Malagasy", QLocale::Malagasy, "@brief Enum constant QLocale::Malagasy") +
    gsi::enum_const ("Malay", QLocale::Malay, "@brief Enum constant QLocale::Malay") +
    gsi::enum_const ("Malayalam", QLocale::Malayalam, "@brief Enum constant QLocale::Malayalam") +
    gsi::enum_const ("Maltese", QLocale::Maltese, "@brief Enum constant QLocale::Maltese") +
    gsi::enum_const ("Maori", QLocale::Maori, "@brief Enum constant QLocale::Maori") +
    gsi::enum_const ("Marathi", QLocale::Marathi, "@brief Enum constant QLocale::Marathi") +
    gsi::enum_const ("Moldavian", QLocale::Moldavian, "@brief Enum constant QLocale::Moldavian") +
    gsi::enum_const ("Mongolian", QLocale::Mongolian, "@brief Enum constant QLocale::Mongolian") +
    gsi::enum_const ("NauruLanguage", QLocale::NauruLanguage, "@brief Enum constant QLocale::NauruLanguage") +
    gsi::enum_const ("Nepali", QLocale::Nepali, "@brief Enum constant QLocale::Nepali") +
    gsi::enum_const ("Norwegian", QLocale::Norwegian, "@brief Enum constant QLocale::Norwegian") +
    gsi::enum_const ("NorwegianBokmal", QLocale::NorwegianBokmal, "@brief Enum constant QLocale::NorwegianBokmal") +
    gsi::enum_const ("Occitan", QLocale::Occitan, "@brief Enum constant QLocale::Occitan") +
    gsi::enum_const ("Oriya", QLocale::Oriya, "@brief Enum constant QLocale::Oriya") +
    gsi::enum_const ("Pashto", QLocale::Pashto, "@brief Enum constant QLocale::Pashto") +
    gsi::enum_const ("Persian", QLocale::Persian, "@brief Enum constant QLocale::Persian") +
    gsi::enum_const ("Polish", QLocale::Polish, "@brief Enum constant QLocale::Polish") +
    gsi::enum_const ("Portuguese", QLocale::Portuguese, "@brief Enum constant QLocale::Portuguese") +
    gsi::enum_const ("Punjabi", QLocale::Punjabi, "@brief Enum constant QLocale::Punjabi") +
    gsi::enum_const ("Quechua", QLocale::Quechua, "@brief Enum constant QLocale::Quechua") +
    gsi::enum_const ("RhaetoRomance", QLocale::RhaetoRomance, "@brief Enum constant QLocale::RhaetoRomance") +
    gsi::enum_const ("Romanian", QLocale::Romanian, "@brief Enum constant QLocale::Romanian") +
    gsi::enum_const ("Russian", QLocale::Russian, "@brief Enum constant QLocale::Russian") +
    gsi::enum_const ("Samoan", QLocale::Samoan, "@brief Enum constant QLocale::Samoan") +
    gsi::enum_const ("Sangho", QLocale::Sangho, "@brief Enum constant QLocale::Sangho") +
    gsi::enum_const ("Sanskrit", QLocale::Sanskrit, "@brief Enum constant QLocale::Sanskrit") +
    gsi::enum_const ("Serbian", QLocale::Serbian, "@brief Enum constant QLocale::Serbian") +
    gsi::enum_const ("SerboCroatian", QLocale::SerboCroatian, "@brief Enum constant QLocale::SerboCroatian") +
    gsi::enum_const ("Sesotho", QLocale::Sesotho, "@brief Enum constant QLocale::Sesotho") +
    gsi::enum_const ("Setswana", QLocale::Setswana, "@brief Enum constant QLocale::Setswana") +
    gsi::enum_const ("Shona", QLocale::Shona, "@brief Enum constant QLocale::Shona") +
    gsi::enum_const ("Sindhi", QLocale::Sindhi, "@brief Enum constant QLocale::Sindhi") +
    gsi::enum_const ("Singhalese", QLocale::Singhalese, "@brief Enum constant QLocale::Singhalese") +
    gsi::enum_const ("Siswati", QLocale::Siswati, "@brief Enum constant QLocale::Siswati") +
    gsi::enum_const ("Slovak", QLocale::Slovak, "@brief Enum constant QLocale::Slovak") +
    gsi::enum_const ("Slovenian", QLocale::Slovenian, "@brief Enum constant QLocale::Slovenian") +
    gsi::enum_const ("Somali", QLocale::Somali, "@brief Enum constant QLocale::Somali") +
    gsi::enum_const ("Spanish", QLocale::Spanish, "@brief Enum constant QLocale::Spanish") +
    gsi::enum_const ("Sundanese", QLocale::Sundanese, "@brief Enum constant QLocale::Sundanese") +
    gsi::enum_const ("Swahili", QLocale::Swahili, "@brief Enum constant QLocale::Swahili") +
    gsi::enum_const ("Swedish", QLocale::Swedish, "@brief Enum constant QLocale::Swedish") +
    gsi::enum_const ("Tagalog", QLocale::Tagalog, "@brief Enum constant QLocale::Tagalog") +
    gsi::enum_const ("Tajik", QLocale::Tajik, "@brief Enum constant QLocale::Tajik") +
    gsi::enum_const ("Tamil", QLocale::Tamil, "@brief Enum constant QLocale::Tamil") +
    gsi::enum_const ("Tatar", QLocale::Tatar, "@brief Enum constant QLocale::Tatar") +
    gsi::enum_const ("Telugu", QLocale::Telugu, "@brief Enum constant QLocale::Telugu") +
    gsi::enum_const ("Thai", QLocale::Thai, "@brief Enum constant QLocale::Thai") +
    gsi::enum_const ("Tibetan", QLocale::Tibetan, "@brief Enum constant QLocale::Tibetan") +
    gsi::enum_const ("Tigrinya", QLocale::Tigrinya, "@brief Enum constant QLocale::Tigrinya") +
    gsi::enum_const ("TongaLanguage", QLocale::TongaLanguage, "@brief Enum constant QLocale::TongaLanguage") +
    gsi::enum_const ("Tsonga", QLocale::Tsonga, "@brief Enum constant QLocale::Tsonga") +
    gsi::enum_const ("Turkish", QLocale::Turkish, "@brief Enum constant QLocale::Turkish") +
    gsi::enum_const ("Turkmen", QLocale::Turkmen, "@brief Enum constant QLocale::Turkmen") +
    gsi::enum_const ("Twi", QLocale::Twi, "@brief Enum constant QLocale::Twi") +
    gsi::enum_const ("Uigur", QLocale::Uigur, "@brief Enum constant QLocale::Uigur") +
    gsi::enum_const ("Ukrainian", QLocale::Ukrainian, "@brief Enum constant QLocale::Ukrainian") +
    gsi::enum_const ("Urdu", QLocale::Urdu, "@brief Enum constant QLocale::Urdu") +
    gsi::enum_const ("Uzbek", QLocale::Uzbek, "@brief Enum constant QLocale::Uzbek") +
    gsi::enum_const ("Vietnamese", QLocale::Vietnamese, "@brief Enum constant QLocale::Vietnamese") +
    gsi::enum_const ("Volapuk", QLocale::Volapuk, "@brief Enum constant QLocale::Volapuk") +
    gsi::enum_const ("Welsh", QLocale::Welsh, "@brief Enum constant QLocale::Welsh") +
    gsi::enum_const ("Wolof", QLocale::Wolof, "@brief Enum constant QLocale::Wolof") +
    gsi::enum_const ("Xhosa", QLocale::Xhosa, "@brief Enum constant QLocale::Xhosa") +
    gsi::enum_const ("Yiddish", QLocale::Yiddish, "@brief Enum constant QLocale::Yiddish") +
    gsi::enum_const ("Yoruba", QLocale::Yoruba, "@brief Enum constant QLocale::Yoruba") +
    gsi::enum_const ("Zhuang", QLocale::Zhuang, "@brief Enum constant QLocale::Zhuang") +
    gsi::enum_const ("Zulu", QLocale::Zulu, "@brief Enum constant QLocale::Zulu") +
    gsi::enum_const ("NorwegianNynorsk", QLocale::NorwegianNynorsk, "@brief Enum constant QLocale::NorwegianNynorsk") +
    gsi::enum_const ("Nynorsk", QLocale::Nynorsk, "@brief Enum constant QLocale::Nynorsk") +
    gsi::enum_const ("Bosnian", QLocale::Bosnian, "@brief Enum constant QLocale::Bosnian") +
    gsi::enum_const ("Divehi", QLocale::Divehi, "@brief Enum constant QLocale::Divehi") +
    gsi::enum_const ("Manx", QLocale::Manx, "@brief Enum constant QLocale::Manx") +
    gsi::enum_const ("Cornish", QLocale::Cornish, "@brief Enum constant QLocale::Cornish") +
    gsi::enum_const ("Akan", QLocale::Akan, "@brief Enum constant QLocale::Akan") +
    gsi::enum_const ("Konkani", QLocale::Konkani, "@brief Enum constant QLocale::Konkani") +
    gsi::enum_const ("Ga", QLocale::Ga, "@brief Enum constant QLocale::Ga") +
    gsi::enum_const ("Igbo", QLocale::Igbo, "@brief Enum constant QLocale::Igbo") +
    gsi::enum_const ("Kamba", QLocale::Kamba, "@brief Enum constant QLocale::Kamba") +
    gsi::enum_const ("Syriac", QLocale::Syriac, "@brief Enum constant QLocale::Syriac") +
    gsi::enum_const ("Blin", QLocale::Blin, "@brief Enum constant QLocale::Blin") +
    gsi::enum_const ("Geez", QLocale::Geez, "@brief Enum constant QLocale::Geez") +
    gsi::enum_const ("Koro", QLocale::Koro, "@brief Enum constant QLocale::Koro") +
    gsi::enum_const ("Sidamo", QLocale::Sidamo, "@brief Enum constant QLocale::Sidamo") +
    gsi::enum_const ("Atsam", QLocale::Atsam, "@brief Enum constant QLocale::Atsam") +
    gsi::enum_const ("Tigre", QLocale::Tigre, "@brief Enum constant QLocale::Tigre") +
    gsi::enum_const ("Jju", QLocale::Jju, "@brief Enum constant QLocale::Jju") +
    gsi::enum_const ("Friulian", QLocale::Friulian, "@brief Enum constant QLocale::Friulian") +
    gsi::enum_const ("Venda", QLocale::Venda, "@brief Enum constant QLocale::Venda") +
    gsi::enum_const ("Ewe", QLocale::Ewe, "@brief Enum constant QLocale::Ewe") +
    gsi::enum_const ("Walamo", QLocale::Walamo, "@brief Enum constant QLocale::Walamo") +
    gsi::enum_const ("Hawaiian", QLocale::Hawaiian, "@brief Enum constant QLocale::Hawaiian") +
    gsi::enum_const ("Tyap", QLocale::Tyap, "@brief Enum constant QLocale::Tyap") +
    gsi::enum_const ("Chewa", QLocale::Chewa, "@brief Enum constant QLocale::Chewa") +
    gsi::enum_const ("LastLanguage", QLocale::LastLanguage, "@brief Enum constant QLocale::LastLanguage"),
  "@qt\n@brief This class represents the QLocale::Language enum");

static gsi::QFlagsClass<QLocale::Language > decl_QLocale_Language_Enums ("QtCore", "QLocale_QFlags_Language",
  "@qt\n@brief This class represents the QFlags<QLocale::Language> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocale> inject_QLocale_Language_Enum_in_parent (decl_QLocale_Language_Enum.defs ());
static gsi::ClassExt<QLocale> decl_QLocale_Language_Enum_as_child (decl_QLocale_Language_Enum, "Language");
static gsi::ClassExt<QLocale> decl_QLocale_Language_Enums_as_child (decl_QLocale_Language_Enums, "QFlags_Language");

}


//  Implementation of the enum wrapper class for QLocale::MeasurementSystem
namespace qt_gsi
{

static gsi::Enum<QLocale::MeasurementSystem> decl_QLocale_MeasurementSystem_Enum ("QtCore", "QLocale_MeasurementSystem",
    gsi::enum_const ("MetricSystem", QLocale::MetricSystem, "@brief Enum constant QLocale::MetricSystem") +
    gsi::enum_const ("ImperialSystem", QLocale::ImperialSystem, "@brief Enum constant QLocale::ImperialSystem"),
  "@qt\n@brief This class represents the QLocale::MeasurementSystem enum");

static gsi::QFlagsClass<QLocale::MeasurementSystem > decl_QLocale_MeasurementSystem_Enums ("QtCore", "QLocale_QFlags_MeasurementSystem",
  "@qt\n@brief This class represents the QFlags<QLocale::MeasurementSystem> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocale> inject_QLocale_MeasurementSystem_Enum_in_parent (decl_QLocale_MeasurementSystem_Enum.defs ());
static gsi::ClassExt<QLocale> decl_QLocale_MeasurementSystem_Enum_as_child (decl_QLocale_MeasurementSystem_Enum, "MeasurementSystem");
static gsi::ClassExt<QLocale> decl_QLocale_MeasurementSystem_Enums_as_child (decl_QLocale_MeasurementSystem_Enums, "QFlags_MeasurementSystem");

}


//  Implementation of the enum wrapper class for QLocale::NumberOption
namespace qt_gsi
{

static gsi::Enum<QLocale::NumberOption> decl_QLocale_NumberOption_Enum ("QtCore", "QLocale_NumberOption",
    gsi::enum_const ("OmitGroupSeparator", QLocale::OmitGroupSeparator, "@brief Enum constant QLocale::OmitGroupSeparator") +
    gsi::enum_const ("RejectGroupSeparator", QLocale::RejectGroupSeparator, "@brief Enum constant QLocale::RejectGroupSeparator"),
  "@qt\n@brief This class represents the QLocale::NumberOption enum");

static gsi::QFlagsClass<QLocale::NumberOption > decl_QLocale_NumberOption_Enums ("QtCore", "QLocale_QFlags_NumberOption",
  "@qt\n@brief This class represents the QFlags<QLocale::NumberOption> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocale> inject_QLocale_NumberOption_Enum_in_parent (decl_QLocale_NumberOption_Enum.defs ());
static gsi::ClassExt<QLocale> decl_QLocale_NumberOption_Enum_as_child (decl_QLocale_NumberOption_Enum, "NumberOption");
static gsi::ClassExt<QLocale> decl_QLocale_NumberOption_Enums_as_child (decl_QLocale_NumberOption_Enums, "QFlags_NumberOption");

}

