
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCoreApplication.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCoreApplication>
#include <QChildEvent>
#include <QEvent>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include <QTranslator>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCoreApplication

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCoreApplication::staticMetaObject);
}


// bool QCoreApplication::filterEvent(void *message, long int *result)


static void _init_f_filterEvent_2477 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("message");
  decl->add_arg<void * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("result");
  decl->add_arg<long int * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_filterEvent_2477 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  void *arg1 = gsi::arg_reader<void * >() (args, heap);
  long int *arg2 = gsi::arg_reader<long int * >() (args, heap);
  ret.write<bool > ((bool)((QCoreApplication *)cls)->filterEvent (arg1, arg2));
}


// static void QCoreApplication::addLibraryPath(const QString &)


static void _init_f_addLibraryPath_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addLibraryPath_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::addLibraryPath (arg1);
}


// static QString QCoreApplication::applicationDirPath()


static void _init_f_applicationDirPath_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_applicationDirPath_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)QCoreApplication::applicationDirPath ());
}


// static QString QCoreApplication::applicationFilePath()


static void _init_f_applicationFilePath_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_applicationFilePath_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)QCoreApplication::applicationFilePath ());
}


// static QString QCoreApplication::applicationName()


static void _init_f_applicationName_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_applicationName_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)QCoreApplication::applicationName ());
}


// static qint64 QCoreApplication::applicationPid()


static void _init_f_applicationPid_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_applicationPid_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)QCoreApplication::applicationPid ());
}


// static QString QCoreApplication::applicationVersion()


static void _init_f_applicationVersion_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_applicationVersion_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)QCoreApplication::applicationVersion ());
}


// static QStringList QCoreApplication::arguments()


static void _init_f_arguments_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_arguments_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)QCoreApplication::arguments ());
}


// static bool QCoreApplication::closingDown()


static void _init_f_closingDown_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_closingDown_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)QCoreApplication::closingDown ());
}


// static int QCoreApplication::exec()


static void _init_f_exec_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_exec_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QCoreApplication::exec ());
}


// static void QCoreApplication::exit(int retcode)


static void _init_f_exit_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("retcode", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_exit_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::exit (arg1);
}


// static void QCoreApplication::flush()


static void _init_f_flush_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_flush_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::flush ();
}


// static bool QCoreApplication::hasPendingEvents()


static void _init_f_hasPendingEvents_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasPendingEvents_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)QCoreApplication::hasPendingEvents ());
}


// static void QCoreApplication::installTranslator(QTranslator *messageFile)


static void _init_f_installTranslator_1769 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("messageFile");
  decl->add_arg<QTranslator * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_installTranslator_1769 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTranslator *arg1 = gsi::arg_reader<QTranslator * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::installTranslator (arg1);
}


// static QCoreApplication *QCoreApplication::instance()


static void _init_f_instance_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QCoreApplication * > ();
}

static void _call_f_instance_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCoreApplication * > ((QCoreApplication *)QCoreApplication::instance ());
}


// static QStringList QCoreApplication::libraryPaths()


static void _init_f_libraryPaths_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_libraryPaths_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)QCoreApplication::libraryPaths ());
}


// static QString QCoreApplication::organizationDomain()


static void _init_f_organizationDomain_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_organizationDomain_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)QCoreApplication::organizationDomain ());
}


// static QString QCoreApplication::organizationName()


static void _init_f_organizationName_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_organizationName_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)QCoreApplication::organizationName ());
}


// static void QCoreApplication::postEvent(QObject *receiver, QEvent *event)


static void _init_f_postEvent_2411 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_postEvent_2411 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  QEvent *arg2 = gsi::arg_reader<QEvent * >() (args, heap);
  qt_gsi::qt_keep (arg2);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::postEvent (arg1, arg2);
}


// static void QCoreApplication::postEvent(QObject *receiver, QEvent *event, int priority)


static void _init_f_postEvent_3070 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("priority");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_postEvent_3070 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  QEvent *arg2 = gsi::arg_reader<QEvent * >() (args, heap);
  qt_gsi::qt_keep (arg2);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::postEvent (arg1, arg2, arg3);
}


// static void QCoreApplication::processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags)


static void _init_f_processEvents_3995 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags", true, "QEventLoop::AllEvents");
  decl->add_arg<QFlags<QEventLoop::ProcessEventsFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_processEvents_3995 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QEventLoop::ProcessEventsFlag> arg1 = args ? gsi::arg_reader<QFlags<QEventLoop::ProcessEventsFlag> >() (args, heap) : gsi::arg_maker<QFlags<QEventLoop::ProcessEventsFlag> >() (QEventLoop::AllEvents, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::processEvents (arg1);
}


// static void QCoreApplication::processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags, int maxtime)


static void _init_f_processEvents_4654 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<QEventLoop::ProcessEventsFlag> > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("maxtime");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_processEvents_4654 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QEventLoop::ProcessEventsFlag> arg1 = gsi::arg_reader<QFlags<QEventLoop::ProcessEventsFlag> >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::processEvents (arg1, arg2);
}


// static void QCoreApplication::quit()


static void _init_f_quit_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_quit_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::quit ();
}


// static void QCoreApplication::removeLibraryPath(const QString &)


static void _init_f_removeLibraryPath_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeLibraryPath_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::removeLibraryPath (arg1);
}


// static void QCoreApplication::removePostedEvents(QObject *receiver)


static void _init_f_removePostedEvents_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removePostedEvents_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::removePostedEvents (arg1);
}


// static void QCoreApplication::removePostedEvents(QObject *receiver, int eventType)


static void _init_f_removePostedEvents_1961 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("eventType");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_removePostedEvents_1961 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::removePostedEvents (arg1, arg2);
}


// static void QCoreApplication::removeTranslator(QTranslator *messageFile)


static void _init_f_removeTranslator_1769 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("messageFile");
  decl->add_arg<QTranslator * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeTranslator_1769 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTranslator *arg1 = gsi::arg_reader<QTranslator * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::removeTranslator (arg1);
}


// static bool QCoreApplication::sendEvent(QObject *receiver, QEvent *event)


static void _init_f_sendEvent_2411 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_sendEvent_2411 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  QEvent *arg2 = gsi::arg_reader<QEvent * >() (args, heap);
  ret.write<bool > ((bool)QCoreApplication::sendEvent (arg1, arg2));
}


// static void QCoreApplication::sendPostedEvents(QObject *receiver, int event_type)


static void _init_f_sendPostedEvents_1961 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event_type");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_sendPostedEvents_1961 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::sendPostedEvents (arg1, arg2);
}


// static void QCoreApplication::sendPostedEvents()


static void _init_f_sendPostedEvents_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_sendPostedEvents_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::sendPostedEvents ();
}


// static void QCoreApplication::setApplicationName(const QString &application)


static void _init_f_setApplicationName_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("application");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setApplicationName_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::setApplicationName (arg1);
}


// static void QCoreApplication::setApplicationVersion(const QString &version)


static void _init_f_setApplicationVersion_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("version");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setApplicationVersion_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::setApplicationVersion (arg1);
}


// static void QCoreApplication::setAttribute(Qt::ApplicationAttribute attribute, bool on)


static void _init_f_setAttribute_3593 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("attribute");
  decl->add_arg<const qt_gsi::Converter<Qt::ApplicationAttribute>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setAttribute_3593 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ApplicationAttribute>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ApplicationAttribute>::target_type & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::setAttribute (qt_gsi::QtToCppAdaptor<Qt::ApplicationAttribute>(arg1).cref(), arg2);
}


// static void QCoreApplication::setLibraryPaths(const QStringList &)


static void _init_f_setLibraryPaths_2437 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLibraryPaths_2437 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::setLibraryPaths (arg1);
}


// static void QCoreApplication::setOrganizationDomain(const QString &orgDomain)


static void _init_f_setOrganizationDomain_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orgDomain");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOrganizationDomain_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::setOrganizationDomain (arg1);
}


// static void QCoreApplication::setOrganizationName(const QString &orgName)


static void _init_f_setOrganizationName_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orgName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOrganizationName_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QCoreApplication::setOrganizationName (arg1);
}


// static bool QCoreApplication::startingUp()


static void _init_f_startingUp_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_startingUp_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)QCoreApplication::startingUp ());
}


// static bool QCoreApplication::testAttribute(Qt::ApplicationAttribute attribute)


static void _init_f_testAttribute_2837 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("attribute");
  decl->add_arg<const qt_gsi::Converter<Qt::ApplicationAttribute>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testAttribute_2837 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ApplicationAttribute>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ApplicationAttribute>::target_type & >() (args, heap);
  ret.write<bool > ((bool)QCoreApplication::testAttribute (qt_gsi::QtToCppAdaptor<Qt::ApplicationAttribute>(arg1).cref()));
}


// static QString QCoreApplication::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QCoreApplication::tr (arg1, arg2));
}


// static QString QCoreApplication::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QCoreApplication::tr (arg1, arg2, arg3));
}


// static QString QCoreApplication::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QCoreApplication::trUtf8 (arg1, arg2));
}


// static QString QCoreApplication::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QCoreApplication::trUtf8 (arg1, arg2, arg3));
}


// static QString QCoreApplication::translate(const char *context, const char *key, const char *disambiguation, QCoreApplication::Encoding encoding)


static void _init_f_translate_7842 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("context");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("key");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("disambiguation", true, "0");
  decl->add_arg<const char * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("encoding", true, "QCoreApplication::CodecForTr");
  decl->add_arg<const qt_gsi::Converter<QCoreApplication::Encoding>::target_type & > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_f_translate_7842 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg3 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  const qt_gsi::Converter<QCoreApplication::Encoding>::target_type & arg4 = args ? gsi::arg_reader<const qt_gsi::Converter<QCoreApplication::Encoding>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QCoreApplication::Encoding>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QCoreApplication::Encoding>(heap, QCoreApplication::CodecForTr), heap);
  ret.write<QString > ((QString)QCoreApplication::translate (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QCoreApplication::Encoding>(arg4).cref()));
}


// static QString QCoreApplication::translate(const char *context, const char *key, const char *disambiguation, QCoreApplication::Encoding encoding, int n)


static void _init_f_translate_8501 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("context");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("key");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("disambiguation");
  decl->add_arg<const char * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("encoding");
  decl->add_arg<const qt_gsi::Converter<QCoreApplication::Encoding>::target_type & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("n");
  decl->add_arg<int > (argspec_4);
  decl->set_return<QString > ();
}

static void _call_f_translate_8501 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg3 = gsi::arg_reader<const char * >() (args, heap);
  const qt_gsi::Converter<QCoreApplication::Encoding>::target_type & arg4 = gsi::arg_reader<const qt_gsi::Converter<QCoreApplication::Encoding>::target_type & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QCoreApplication::translate (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QCoreApplication::Encoding>(arg4).cref(), arg5));
}


namespace gsi
{

static gsi::Methods methods_QCoreApplication () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("filterEvent", "@brief Method bool QCoreApplication::filterEvent(void *message, long int *result)\n", false, &_init_f_filterEvent_2477, &_call_f_filterEvent_2477);
  methods += gsi::qt_signal ("aboutToQuit()", "aboutToQuit", "@brief Signal declaration for QCoreApplication::aboutToQuit()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QCoreApplication::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("unixSignal(int)", "unixSignal", gsi::arg("arg1"), "@brief Signal declaration for QCoreApplication::unixSignal(int)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("addLibraryPath", "@brief Static method void QCoreApplication::addLibraryPath(const QString &)\nThis method is static and can be called without an instance.", &_init_f_addLibraryPath_2025, &_call_f_addLibraryPath_2025);
  methods += new qt_gsi::GenericStaticMethod ("applicationDirPath", "@brief Static method QString QCoreApplication::applicationDirPath()\nThis method is static and can be called without an instance.", &_init_f_applicationDirPath_0, &_call_f_applicationDirPath_0);
  methods += new qt_gsi::GenericStaticMethod ("applicationFilePath", "@brief Static method QString QCoreApplication::applicationFilePath()\nThis method is static and can be called without an instance.", &_init_f_applicationFilePath_0, &_call_f_applicationFilePath_0);
  methods += new qt_gsi::GenericStaticMethod (":applicationName", "@brief Static method QString QCoreApplication::applicationName()\nThis method is static and can be called without an instance.", &_init_f_applicationName_0, &_call_f_applicationName_0);
  methods += new qt_gsi::GenericStaticMethod ("applicationPid", "@brief Static method qint64 QCoreApplication::applicationPid()\nThis method is static and can be called without an instance.", &_init_f_applicationPid_0, &_call_f_applicationPid_0);
  methods += new qt_gsi::GenericStaticMethod (":applicationVersion", "@brief Static method QString QCoreApplication::applicationVersion()\nThis method is static and can be called without an instance.", &_init_f_applicationVersion_0, &_call_f_applicationVersion_0);
  methods += new qt_gsi::GenericStaticMethod ("arguments", "@brief Static method QStringList QCoreApplication::arguments()\nThis method is static and can be called without an instance.", &_init_f_arguments_0, &_call_f_arguments_0);
  methods += new qt_gsi::GenericStaticMethod ("closingDown", "@brief Static method bool QCoreApplication::closingDown()\nThis method is static and can be called without an instance.", &_init_f_closingDown_0, &_call_f_closingDown_0);
  methods += new qt_gsi::GenericStaticMethod ("exec", "@brief Static method int QCoreApplication::exec()\nThis method is static and can be called without an instance.", &_init_f_exec_0, &_call_f_exec_0);
  methods += new qt_gsi::GenericStaticMethod ("exit", "@brief Static method void QCoreApplication::exit(int retcode)\nThis method is static and can be called without an instance.", &_init_f_exit_767, &_call_f_exit_767);
  methods += new qt_gsi::GenericStaticMethod ("flush", "@brief Static method void QCoreApplication::flush()\nThis method is static and can be called without an instance.", &_init_f_flush_0, &_call_f_flush_0);
  methods += new qt_gsi::GenericStaticMethod ("hasPendingEvents", "@brief Static method bool QCoreApplication::hasPendingEvents()\nThis method is static and can be called without an instance.", &_init_f_hasPendingEvents_0, &_call_f_hasPendingEvents_0);
  methods += new qt_gsi::GenericStaticMethod ("installTranslator", "@brief Static method void QCoreApplication::installTranslator(QTranslator *messageFile)\nThis method is static and can be called without an instance.", &_init_f_installTranslator_1769, &_call_f_installTranslator_1769);
  methods += new qt_gsi::GenericStaticMethod ("instance", "@brief Static method QCoreApplication *QCoreApplication::instance()\nThis method is static and can be called without an instance.", &_init_f_instance_0, &_call_f_instance_0);
  methods += new qt_gsi::GenericStaticMethod (":libraryPaths", "@brief Static method QStringList QCoreApplication::libraryPaths()\nThis method is static and can be called without an instance.", &_init_f_libraryPaths_0, &_call_f_libraryPaths_0);
  methods += new qt_gsi::GenericStaticMethod (":organizationDomain", "@brief Static method QString QCoreApplication::organizationDomain()\nThis method is static and can be called without an instance.", &_init_f_organizationDomain_0, &_call_f_organizationDomain_0);
  methods += new qt_gsi::GenericStaticMethod (":organizationName", "@brief Static method QString QCoreApplication::organizationName()\nThis method is static and can be called without an instance.", &_init_f_organizationName_0, &_call_f_organizationName_0);
  methods += new qt_gsi::GenericStaticMethod ("postEvent", "@brief Static method void QCoreApplication::postEvent(QObject *receiver, QEvent *event)\nThis method is static and can be called without an instance.", &_init_f_postEvent_2411, &_call_f_postEvent_2411);
  methods += new qt_gsi::GenericStaticMethod ("postEvent", "@brief Static method void QCoreApplication::postEvent(QObject *receiver, QEvent *event, int priority)\nThis method is static and can be called without an instance.", &_init_f_postEvent_3070, &_call_f_postEvent_3070);
  methods += new qt_gsi::GenericStaticMethod ("processEvents", "@brief Static method void QCoreApplication::processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags)\nThis method is static and can be called without an instance.", &_init_f_processEvents_3995, &_call_f_processEvents_3995);
  methods += new qt_gsi::GenericStaticMethod ("processEvents", "@brief Static method void QCoreApplication::processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags, int maxtime)\nThis method is static and can be called without an instance.", &_init_f_processEvents_4654, &_call_f_processEvents_4654);
  methods += new qt_gsi::GenericStaticMethod ("quit", "@brief Static method void QCoreApplication::quit()\nThis method is static and can be called without an instance.", &_init_f_quit_0, &_call_f_quit_0);
  methods += new qt_gsi::GenericStaticMethod ("removeLibraryPath", "@brief Static method void QCoreApplication::removeLibraryPath(const QString &)\nThis method is static and can be called without an instance.", &_init_f_removeLibraryPath_2025, &_call_f_removeLibraryPath_2025);
  methods += new qt_gsi::GenericStaticMethod ("removePostedEvents", "@brief Static method void QCoreApplication::removePostedEvents(QObject *receiver)\nThis method is static and can be called without an instance.", &_init_f_removePostedEvents_1302, &_call_f_removePostedEvents_1302);
  methods += new qt_gsi::GenericStaticMethod ("removePostedEvents", "@brief Static method void QCoreApplication::removePostedEvents(QObject *receiver, int eventType)\nThis method is static and can be called without an instance.", &_init_f_removePostedEvents_1961, &_call_f_removePostedEvents_1961);
  methods += new qt_gsi::GenericStaticMethod ("removeTranslator", "@brief Static method void QCoreApplication::removeTranslator(QTranslator *messageFile)\nThis method is static and can be called without an instance.", &_init_f_removeTranslator_1769, &_call_f_removeTranslator_1769);
  methods += new qt_gsi::GenericStaticMethod ("sendEvent", "@brief Static method bool QCoreApplication::sendEvent(QObject *receiver, QEvent *event)\nThis method is static and can be called without an instance.", &_init_f_sendEvent_2411, &_call_f_sendEvent_2411);
  methods += new qt_gsi::GenericStaticMethod ("sendPostedEvents", "@brief Static method void QCoreApplication::sendPostedEvents(QObject *receiver, int event_type)\nThis method is static and can be called without an instance.", &_init_f_sendPostedEvents_1961, &_call_f_sendPostedEvents_1961);
  methods += new qt_gsi::GenericStaticMethod ("sendPostedEvents", "@brief Static method void QCoreApplication::sendPostedEvents()\nThis method is static and can be called without an instance.", &_init_f_sendPostedEvents_0, &_call_f_sendPostedEvents_0);
  methods += new qt_gsi::GenericStaticMethod ("setApplicationName|applicationName=", "@brief Static method void QCoreApplication::setApplicationName(const QString &application)\nThis method is static and can be called without an instance.", &_init_f_setApplicationName_2025, &_call_f_setApplicationName_2025);
  methods += new qt_gsi::GenericStaticMethod ("setApplicationVersion|applicationVersion=", "@brief Static method void QCoreApplication::setApplicationVersion(const QString &version)\nThis method is static and can be called without an instance.", &_init_f_setApplicationVersion_2025, &_call_f_setApplicationVersion_2025);
  methods += new qt_gsi::GenericStaticMethod ("setAttribute", "@brief Static method void QCoreApplication::setAttribute(Qt::ApplicationAttribute attribute, bool on)\nThis method is static and can be called without an instance.", &_init_f_setAttribute_3593, &_call_f_setAttribute_3593);
  methods += new qt_gsi::GenericStaticMethod ("setLibraryPaths|libraryPaths=", "@brief Static method void QCoreApplication::setLibraryPaths(const QStringList &)\nThis method is static and can be called without an instance.", &_init_f_setLibraryPaths_2437, &_call_f_setLibraryPaths_2437);
  methods += new qt_gsi::GenericStaticMethod ("setOrganizationDomain|organizationDomain=", "@brief Static method void QCoreApplication::setOrganizationDomain(const QString &orgDomain)\nThis method is static and can be called without an instance.", &_init_f_setOrganizationDomain_2025, &_call_f_setOrganizationDomain_2025);
  methods += new qt_gsi::GenericStaticMethod ("setOrganizationName|organizationName=", "@brief Static method void QCoreApplication::setOrganizationName(const QString &orgName)\nThis method is static and can be called without an instance.", &_init_f_setOrganizationName_2025, &_call_f_setOrganizationName_2025);
  methods += new qt_gsi::GenericStaticMethod ("startingUp", "@brief Static method bool QCoreApplication::startingUp()\nThis method is static and can be called without an instance.", &_init_f_startingUp_0, &_call_f_startingUp_0);
  methods += new qt_gsi::GenericStaticMethod ("testAttribute", "@brief Static method bool QCoreApplication::testAttribute(Qt::ApplicationAttribute attribute)\nThis method is static and can be called without an instance.", &_init_f_testAttribute_2837, &_call_f_testAttribute_2837);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCoreApplication::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCoreApplication::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCoreApplication::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCoreApplication::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  methods += new qt_gsi::GenericStaticMethod ("translate", "@brief Static method QString QCoreApplication::translate(const char *context, const char *key, const char *disambiguation, QCoreApplication::Encoding encoding)\nThis method is static and can be called without an instance.", &_init_f_translate_7842, &_call_f_translate_7842);
  methods += new qt_gsi::GenericStaticMethod ("translate", "@brief Static method QString QCoreApplication::translate(const char *context, const char *key, const char *disambiguation, QCoreApplication::Encoding encoding, int n)\nThis method is static and can be called without an instance.", &_init_f_translate_8501, &_call_f_translate_8501);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QCoreApplication> decl_QCoreApplication (qtdecl_QObject (), "QtCore", "QCoreApplication_Native",
  methods_QCoreApplication (),
  "@hide\n@alias QCoreApplication");

GSI_QTCORE_PUBLIC gsi::Class<QCoreApplication> &qtdecl_QCoreApplication () { return decl_QCoreApplication; }

}


class QCoreApplication_Adaptor : public QCoreApplication, public qt_gsi::QtObjectBase
{
public:
  static QCoreApplication *ctor_QCoreApplication_Adaptor_args(const std::vector<std::string> &args)
  {
    //  QCoreApplication needs static sources, so we give it some.
    static char **argv = 0;
    static std::vector<std::string> args_copy;
    static int argc = 0;

    if (argv != 0) {
      throw tl::Exception(tl::to_string(QObject::tr("QCoreApplication cannot be instantiated twice")));
    }
    argv = new char *[args.size ()];
    args_copy = args;
    argc = int (args.size ());
    for (std::vector<std::string>::const_iterator a = args_copy.begin (); a != args_copy.end (); ++a) {
      argv[a - args_copy.begin ()] = (char *) a->c_str ();
    }

    return new QCoreApplication_Adaptor (argc, argv);
  }

  QCoreApplication_Adaptor (int &argc, char **argv) : QCoreApplication (argc, argv) { }

  virtual ~QCoreApplication_Adaptor();

  //  [expose] int QCoreApplication::receivers(const char *signal)
  int fp_QCoreApplication_receivers_c1731 (const char *signal) const {
    return QCoreApplication::receivers(signal);
  }

  //  [expose] QObject *QCoreApplication::sender()
  QObject * fp_QCoreApplication_sender_c0 () const {
    return QCoreApplication::sender();
  }

  //  [adaptor impl] bool QCoreApplication::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QCoreApplication::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCoreApplication_Adaptor, bool, QObject *, QEvent *>(&QCoreApplication_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QCoreApplication::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QCoreApplication::aboutToQuit()
  void emitter_QCoreApplication_aboutToQuit_0()
  {
    emit QCoreApplication::aboutToQuit();
  }

  //  [adaptor impl] void QCoreApplication::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QCoreApplication::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCoreApplication_Adaptor, QChildEvent *>(&QCoreApplication_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QCoreApplication::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QCoreApplication::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QCoreApplication::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCoreApplication_Adaptor, QEvent *>(&QCoreApplication_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QCoreApplication::customEvent(arg1);
    }
  }

  //  [emitter impl] void QCoreApplication::destroyed(QObject *)
  void emitter_QCoreApplication_destroyed_1302(QObject *arg1)
  {
    emit QCoreApplication::destroyed(arg1);
  }

  //  [adaptor impl] void QCoreApplication::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QCoreApplication::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QCoreApplication_Adaptor, const char *>(&QCoreApplication_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QCoreApplication::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QCoreApplication::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QCoreApplication::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCoreApplication_Adaptor, bool, QEvent *>(&QCoreApplication_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QCoreApplication::event(arg1);
    }
  }

  //  [adaptor impl] void QCoreApplication::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QCoreApplication::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCoreApplication_Adaptor, QTimerEvent *>(&QCoreApplication_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QCoreApplication::timerEvent(arg1);
    }
  }

  //  [emitter impl] void QCoreApplication::unixSignal(int)
  void emitter_QCoreApplication_unixSignal_767(int arg1)
  {
    emit QCoreApplication::unixSignal(arg1);
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QCoreApplication_Adaptor::~QCoreApplication_Adaptor() { }

// emitter void QCoreApplication::aboutToQuit()

static void _init_emitter_aboutToQuit_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_aboutToQuit_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCoreApplication_Adaptor *)cls)->emitter_QCoreApplication_aboutToQuit_0 ();
}


// void QCoreApplication::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCoreApplication_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCoreApplication_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QCoreApplication::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCoreApplication_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCoreApplication_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QCoreApplication::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QCoreApplication_Adaptor *)cls)->emitter_QCoreApplication_destroyed_1302 (arg1);
}


// void QCoreApplication::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCoreApplication_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QCoreApplication_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// bool QCoreApplication::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCoreApplication_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCoreApplication_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QCoreApplication::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCoreApplication_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCoreApplication_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed int QCoreApplication::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QCoreApplication_Adaptor *)cls)->fp_QCoreApplication_receivers_c1731 (arg1));
}


// exposed QObject *QCoreApplication::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QCoreApplication_Adaptor *)cls)->fp_QCoreApplication_sender_c0 ());
}


// void QCoreApplication::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCoreApplication_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCoreApplication_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QCoreApplication::unixSignal(int)

static void _init_emitter_unixSignal_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_unixSignal_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QCoreApplication_Adaptor *)cls)->emitter_QCoreApplication_unixSignal_767 (arg1);
}


namespace gsi
{

gsi::Class<QCoreApplication> &qtdecl_QCoreApplication ();

static gsi::Methods methods_QCoreApplication_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("emit_aboutToQuit", "@brief Emitter for signal void QCoreApplication::aboutToQuit()\nCall this method to emit this signal.", false, &_init_emitter_aboutToQuit_0, &_call_emitter_aboutToQuit_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCoreApplication::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCoreApplication::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QCoreApplication::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCoreApplication::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QCoreApplication::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QCoreApplication::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QCoreApplication::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QCoreApplication::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCoreApplication::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_unixSignal", "@brief Emitter for signal void QCoreApplication::unixSignal(int)\nCall this method to emit this signal.", false, &_init_emitter_unixSignal_767, &_call_emitter_unixSignal_767);
  return methods;
}

gsi::Class<QCoreApplication_Adaptor> decl_QCoreApplication_Adaptor (qtdecl_QCoreApplication (), "QtCore", "QCoreApplication",
    gsi::constructor("new", &QCoreApplication_Adaptor::ctor_QCoreApplication_Adaptor_args, gsi::arg ("argv"), "@brief Creates a new QCoreApplication object\n\n@param argv The command line arguments to pass to Qt")
+
  methods_QCoreApplication_Adaptor (),
  "@qt\n@brief Binding of QCoreApplication");

}


//  Implementation of the enum wrapper class for QCoreApplication::Encoding
namespace qt_gsi
{

static gsi::Enum<QCoreApplication::Encoding> decl_QCoreApplication_Encoding_Enum ("QtCore", "QCoreApplication_Encoding",
    gsi::enum_const ("CodecForTr", QCoreApplication::CodecForTr, "@brief Enum constant QCoreApplication::CodecForTr") +
    gsi::enum_const ("UnicodeUTF8", QCoreApplication::UnicodeUTF8, "@brief Enum constant QCoreApplication::UnicodeUTF8") +
    gsi::enum_const ("DefaultCodec", QCoreApplication::DefaultCodec, "@brief Enum constant QCoreApplication::DefaultCodec"),
  "@qt\n@brief This class represents the QCoreApplication::Encoding enum");

static gsi::QFlagsClass<QCoreApplication::Encoding > decl_QCoreApplication_Encoding_Enums ("QtCore", "QCoreApplication_QFlags_Encoding",
  "@qt\n@brief This class represents the QFlags<QCoreApplication::Encoding> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCoreApplication> inject_QCoreApplication_Encoding_Enum_in_parent (decl_QCoreApplication_Encoding_Enum.defs ());
static gsi::ClassExt<QCoreApplication> decl_QCoreApplication_Encoding_Enum_as_child (decl_QCoreApplication_Encoding_Enum, "Encoding");
static gsi::ClassExt<QCoreApplication> decl_QCoreApplication_Encoding_Enums_as_child (decl_QCoreApplication_Encoding_Enums, "QFlags_Encoding");

}

