#---------------------------------------------------------------------------------------
# Bundle: KLayoutHomebrew.app
#
# Descriptions:
#  This script invokes "klayout.app" that shares the Homebrew development environment.
#  More precisely, it uses the Qt6, Ruby, and Python packages of Homebrew installed in
#  the standard location.
#---------------------------------------------------------------------------------------

#--------------------------------------------------------------------------
# Localizing the language
# Workaround discussed in https://github.com/KLayout/klayout/issues/1213
#--------------------------------------------------------------------------
export LANG=$(defaults read -g AppleLocale).UTF-8

#--------------------------------------------------------------------------
# Your setups
#--------------------------------------------------------------------------

#--------------------------------------------------------------------------
# Export the 'KLAYOUT_GIT_HTTP_PROXY' environment variable if you need to
# use the git-based Salt Package Manager through a proxy server.
#--------------------------------------------------------------------------
#export KLAYOUT_GIT_HTTP_PROXY="http://111.222.333.444:5678"

#--------------------------------------------------------------------------
# Downloading data from the package server might time out (default=10 sec).
# If so, set the 'KLAYOUT_HTTP_TIMEOUT' environment variable.
# For example, to make a timeout of 20 seconds,
#--------------------------------------------------------------------------
#export KLAYOUT_HTTP_TIMEOUT=20.0

#--------------------------------------------------------------------------
# Export the 'KLAYOUT_PYTHONPATH' environment variable if required
# Ref. https://www.klayout.de/forum/discussion/2557/
#--------------------------------------------------------------------------
#export VIRTUAL_ENV=$HOME/opt/HBPy312
#export KLAYOUT_PYTHONPATH=$VIRTUAL_ENV/lib/python3.12/site-packages

#--------------------------------------------------------------------------
# With "-n" option, you can invoke multiple instances
#--------------------------------------------------------------------------
myklayout=/Applications/klayout.app
myconfig=$HOME/.klayout/klayoutrc

open -n -a "$myklayout" --args -e -c "$myconfig" -style=fusion "$@"
