
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsItemAnimation.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QGraphicsItemAnimation>
#include <QChildEvent>
#include <QEvent>
#include <QGraphicsItem>
#include <QMetaMethod>
#include <QObject>
#include <QPointF>
#include <QThread>
#include <QTimeLine>
#include <QTimerEvent>
#include <QTransform>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsItemAnimation

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsItemAnimation::staticMetaObject);
}


// void QGraphicsItemAnimation::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItemAnimation *)cls)->clear ();
}


// double QGraphicsItemAnimation::horizontalScaleAt(double step)


static void _init_f_horizontalScaleAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_horizontalScaleAt_c1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ret.write<double > ((double)((QGraphicsItemAnimation *)cls)->horizontalScaleAt (arg1));
}


// double QGraphicsItemAnimation::horizontalShearAt(double step)


static void _init_f_horizontalShearAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_horizontalShearAt_c1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ret.write<double > ((double)((QGraphicsItemAnimation *)cls)->horizontalShearAt (arg1));
}


// QGraphicsItem *QGraphicsItemAnimation::item()


static void _init_f_item_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_item_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsItemAnimation *)cls)->item ());
}


// QPointF QGraphicsItemAnimation::posAt(double step)


static void _init_f_posAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_posAt_c1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ret.write<QPointF > ((QPointF)((QGraphicsItemAnimation *)cls)->posAt (arg1));
}


// QList<QPair<qreal, QPointF> > QGraphicsItemAnimation::posList()


static void _init_f_posList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QPair<qreal, QPointF> > > ();
}

static void _call_f_posList_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QPair<qreal, QPointF> > > ((QList<QPair<qreal, QPointF> >)((QGraphicsItemAnimation *)cls)->posList ());
}


// double QGraphicsItemAnimation::rotationAt(double step)


static void _init_f_rotationAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_rotationAt_c1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ret.write<double > ((double)((QGraphicsItemAnimation *)cls)->rotationAt (arg1));
}


// QList<QPair<qreal, qreal> > QGraphicsItemAnimation::rotationList()


static void _init_f_rotationList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QPair<qreal, qreal> > > ();
}

static void _call_f_rotationList_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QPair<qreal, qreal> > > ((QList<QPair<qreal, qreal> >)((QGraphicsItemAnimation *)cls)->rotationList ());
}


// QList<QPair<qreal, QPointF> > QGraphicsItemAnimation::scaleList()


static void _init_f_scaleList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QPair<qreal, QPointF> > > ();
}

static void _call_f_scaleList_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QPair<qreal, QPointF> > > ((QList<QPair<qreal, QPointF> >)((QGraphicsItemAnimation *)cls)->scaleList ());
}


// void QGraphicsItemAnimation::setItem(QGraphicsItem *item)


static void _init_f_setItem_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItem_1919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = gsi::arg_reader<QGraphicsItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItemAnimation *)cls)->setItem (arg1);
}


// void QGraphicsItemAnimation::setPosAt(double step, const QPointF &pos)


static void _init_f_setPosAt_2949 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pos");
  decl->add_arg<const QPointF & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPosAt_2949 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  const QPointF &arg2 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItemAnimation *)cls)->setPosAt (arg1, arg2);
}


// void QGraphicsItemAnimation::setRotationAt(double step, double angle)


static void _init_f_setRotationAt_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("angle");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRotationAt_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItemAnimation *)cls)->setRotationAt (arg1, arg2);
}


// void QGraphicsItemAnimation::setScaleAt(double step, double sx, double sy)


static void _init_f_setScaleAt_2997 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sx");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sy");
  decl->add_arg<double > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setScaleAt_2997 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItemAnimation *)cls)->setScaleAt (arg1, arg2, arg3);
}


// void QGraphicsItemAnimation::setShearAt(double step, double sh, double sv)


static void _init_f_setShearAt_2997 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sh");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sv");
  decl->add_arg<double > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setShearAt_2997 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItemAnimation *)cls)->setShearAt (arg1, arg2, arg3);
}


// void QGraphicsItemAnimation::setStep(double x)


static void _init_f_setStep_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStep_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItemAnimation *)cls)->setStep (arg1);
}


// void QGraphicsItemAnimation::setTimeLine(QTimeLine *timeLine)


static void _init_f_setTimeLine_1494 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("timeLine");
  decl->add_arg<QTimeLine * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTimeLine_1494 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimeLine *arg1 = gsi::arg_reader<QTimeLine * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItemAnimation *)cls)->setTimeLine (arg1);
}


// void QGraphicsItemAnimation::setTranslationAt(double step, double dx, double dy)


static void _init_f_setTranslationAt_2997 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dx");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dy");
  decl->add_arg<double > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setTranslationAt_2997 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItemAnimation *)cls)->setTranslationAt (arg1, arg2, arg3);
}


// QList<QPair<qreal, QPointF> > QGraphicsItemAnimation::shearList()


static void _init_f_shearList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QPair<qreal, QPointF> > > ();
}

static void _call_f_shearList_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QPair<qreal, QPointF> > > ((QList<QPair<qreal, QPointF> >)((QGraphicsItemAnimation *)cls)->shearList ());
}


// QTimeLine *QGraphicsItemAnimation::timeLine()


static void _init_f_timeLine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTimeLine * > ();
}

static void _call_f_timeLine_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTimeLine * > ((QTimeLine *)((QGraphicsItemAnimation *)cls)->timeLine ());
}


// QTransform QGraphicsItemAnimation::transformAt(double step)


static void _init_f_transformAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QTransform > ();
}

static void _call_f_transformAt_c1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ret.write<QTransform > ((QTransform)((QGraphicsItemAnimation *)cls)->transformAt (arg1));
}


// QList<QPair<qreal, QPointF> > QGraphicsItemAnimation::translationList()


static void _init_f_translationList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QPair<qreal, QPointF> > > ();
}

static void _call_f_translationList_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QPair<qreal, QPointF> > > ((QList<QPair<qreal, QPointF> >)((QGraphicsItemAnimation *)cls)->translationList ());
}


// double QGraphicsItemAnimation::verticalScaleAt(double step)


static void _init_f_verticalScaleAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_verticalScaleAt_c1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ret.write<double > ((double)((QGraphicsItemAnimation *)cls)->verticalScaleAt (arg1));
}


// double QGraphicsItemAnimation::verticalShearAt(double step)


static void _init_f_verticalShearAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_verticalShearAt_c1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ret.write<double > ((double)((QGraphicsItemAnimation *)cls)->verticalShearAt (arg1));
}


// double QGraphicsItemAnimation::xTranslationAt(double step)


static void _init_f_xTranslationAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_xTranslationAt_c1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ret.write<double > ((double)((QGraphicsItemAnimation *)cls)->xTranslationAt (arg1));
}


// double QGraphicsItemAnimation::yTranslationAt(double step)


static void _init_f_yTranslationAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_yTranslationAt_c1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ret.write<double > ((double)((QGraphicsItemAnimation *)cls)->yTranslationAt (arg1));
}


// static QString QGraphicsItemAnimation::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QGraphicsItemAnimation::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QGraphicsItemAnimation () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QGraphicsItemAnimation::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("horizontalScaleAt", "@brief Method double QGraphicsItemAnimation::horizontalScaleAt(double step)\n", true, &_init_f_horizontalScaleAt_c1071, &_call_f_horizontalScaleAt_c1071);
  methods += new qt_gsi::GenericMethod ("horizontalShearAt", "@brief Method double QGraphicsItemAnimation::horizontalShearAt(double step)\n", true, &_init_f_horizontalShearAt_c1071, &_call_f_horizontalShearAt_c1071);
  methods += new qt_gsi::GenericMethod (":item", "@brief Method QGraphicsItem *QGraphicsItemAnimation::item()\n", true, &_init_f_item_c0, &_call_f_item_c0);
  methods += new qt_gsi::GenericMethod ("posAt", "@brief Method QPointF QGraphicsItemAnimation::posAt(double step)\n", true, &_init_f_posAt_c1071, &_call_f_posAt_c1071);
  methods += new qt_gsi::GenericMethod ("posList", "@brief Method QList<QPair<qreal, QPointF> > QGraphicsItemAnimation::posList()\n", true, &_init_f_posList_c0, &_call_f_posList_c0);
  methods += new qt_gsi::GenericMethod ("rotationAt", "@brief Method double QGraphicsItemAnimation::rotationAt(double step)\n", true, &_init_f_rotationAt_c1071, &_call_f_rotationAt_c1071);
  methods += new qt_gsi::GenericMethod ("rotationList", "@brief Method QList<QPair<qreal, qreal> > QGraphicsItemAnimation::rotationList()\n", true, &_init_f_rotationList_c0, &_call_f_rotationList_c0);
  methods += new qt_gsi::GenericMethod ("scaleList", "@brief Method QList<QPair<qreal, QPointF> > QGraphicsItemAnimation::scaleList()\n", true, &_init_f_scaleList_c0, &_call_f_scaleList_c0);
  methods += new qt_gsi::GenericMethod ("setItem|item=", "@brief Method void QGraphicsItemAnimation::setItem(QGraphicsItem *item)\n", false, &_init_f_setItem_1919, &_call_f_setItem_1919);
  methods += new qt_gsi::GenericMethod ("setPosAt", "@brief Method void QGraphicsItemAnimation::setPosAt(double step, const QPointF &pos)\n", false, &_init_f_setPosAt_2949, &_call_f_setPosAt_2949);
  methods += new qt_gsi::GenericMethod ("setRotationAt", "@brief Method void QGraphicsItemAnimation::setRotationAt(double step, double angle)\n", false, &_init_f_setRotationAt_2034, &_call_f_setRotationAt_2034);
  methods += new qt_gsi::GenericMethod ("setScaleAt", "@brief Method void QGraphicsItemAnimation::setScaleAt(double step, double sx, double sy)\n", false, &_init_f_setScaleAt_2997, &_call_f_setScaleAt_2997);
  methods += new qt_gsi::GenericMethod ("setShearAt", "@brief Method void QGraphicsItemAnimation::setShearAt(double step, double sh, double sv)\n", false, &_init_f_setShearAt_2997, &_call_f_setShearAt_2997);
  methods += new qt_gsi::GenericMethod ("setStep", "@brief Method void QGraphicsItemAnimation::setStep(double x)\n", false, &_init_f_setStep_1071, &_call_f_setStep_1071);
  methods += new qt_gsi::GenericMethod ("setTimeLine|timeLine=", "@brief Method void QGraphicsItemAnimation::setTimeLine(QTimeLine *timeLine)\n", false, &_init_f_setTimeLine_1494, &_call_f_setTimeLine_1494);
  methods += new qt_gsi::GenericMethod ("setTranslationAt", "@brief Method void QGraphicsItemAnimation::setTranslationAt(double step, double dx, double dy)\n", false, &_init_f_setTranslationAt_2997, &_call_f_setTranslationAt_2997);
  methods += new qt_gsi::GenericMethod ("shearList", "@brief Method QList<QPair<qreal, QPointF> > QGraphicsItemAnimation::shearList()\n", true, &_init_f_shearList_c0, &_call_f_shearList_c0);
  methods += new qt_gsi::GenericMethod (":timeLine", "@brief Method QTimeLine *QGraphicsItemAnimation::timeLine()\n", true, &_init_f_timeLine_c0, &_call_f_timeLine_c0);
  methods += new qt_gsi::GenericMethod ("transformAt", "@brief Method QTransform QGraphicsItemAnimation::transformAt(double step)\n", true, &_init_f_transformAt_c1071, &_call_f_transformAt_c1071);
  methods += new qt_gsi::GenericMethod ("translationList", "@brief Method QList<QPair<qreal, QPointF> > QGraphicsItemAnimation::translationList()\n", true, &_init_f_translationList_c0, &_call_f_translationList_c0);
  methods += new qt_gsi::GenericMethod ("verticalScaleAt", "@brief Method double QGraphicsItemAnimation::verticalScaleAt(double step)\n", true, &_init_f_verticalScaleAt_c1071, &_call_f_verticalScaleAt_c1071);
  methods += new qt_gsi::GenericMethod ("verticalShearAt", "@brief Method double QGraphicsItemAnimation::verticalShearAt(double step)\n", true, &_init_f_verticalShearAt_c1071, &_call_f_verticalShearAt_c1071);
  methods += new qt_gsi::GenericMethod ("xTranslationAt", "@brief Method double QGraphicsItemAnimation::xTranslationAt(double step)\n", true, &_init_f_xTranslationAt_c1071, &_call_f_xTranslationAt_c1071);
  methods += new qt_gsi::GenericMethod ("yTranslationAt", "@brief Method double QGraphicsItemAnimation::yTranslationAt(double step)\n", true, &_init_f_yTranslationAt_c1071, &_call_f_yTranslationAt_c1071);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QGraphicsItemAnimation::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QGraphicsItemAnimation::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsItemAnimation::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QGraphicsItemAnimation> decl_QGraphicsItemAnimation (qtdecl_QObject (), "QtWidgets", "QGraphicsItemAnimation_Native",
  methods_QGraphicsItemAnimation (),
  "@hide\n@alias QGraphicsItemAnimation");

GSI_QTWIDGETS_PUBLIC gsi::Class<QGraphicsItemAnimation> &qtdecl_QGraphicsItemAnimation () { return decl_QGraphicsItemAnimation; }

}


class QGraphicsItemAnimation_Adaptor : public QGraphicsItemAnimation, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsItemAnimation_Adaptor();

  //  [adaptor ctor] QGraphicsItemAnimation::QGraphicsItemAnimation(QObject *parent)
  QGraphicsItemAnimation_Adaptor() : QGraphicsItemAnimation()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsItemAnimation::QGraphicsItemAnimation(QObject *parent)
  QGraphicsItemAnimation_Adaptor(QObject *parent) : QGraphicsItemAnimation(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QGraphicsItemAnimation::isSignalConnected(const QMetaMethod &signal)
  bool fp_QGraphicsItemAnimation_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QGraphicsItemAnimation::isSignalConnected(signal);
  }

  //  [expose] int QGraphicsItemAnimation::receivers(const char *signal)
  int fp_QGraphicsItemAnimation_receivers_c1731 (const char *signal) const {
    return QGraphicsItemAnimation::receivers(signal);
  }

  //  [expose] QObject *QGraphicsItemAnimation::sender()
  QObject * fp_QGraphicsItemAnimation_sender_c0 () const {
    return QGraphicsItemAnimation::sender();
  }

  //  [expose] int QGraphicsItemAnimation::senderSignalIndex()
  int fp_QGraphicsItemAnimation_senderSignalIndex_c0 () const {
    return QGraphicsItemAnimation::senderSignalIndex();
  }

  //  [emitter impl] void QGraphicsItemAnimation::destroyed(QObject *)
  void emitter_QGraphicsItemAnimation_destroyed_1302(QObject *arg1)
  {
    emit QGraphicsItemAnimation::destroyed(arg1);
  }

  //  [adaptor impl] bool QGraphicsItemAnimation::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QGraphicsItemAnimation::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsItemAnimation_Adaptor, bool, QEvent *>(&QGraphicsItemAnimation_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QGraphicsItemAnimation::event(_event);
    }
  }

  //  [adaptor impl] bool QGraphicsItemAnimation::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QGraphicsItemAnimation::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsItemAnimation_Adaptor, bool, QObject *, QEvent *>(&QGraphicsItemAnimation_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QGraphicsItemAnimation::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QGraphicsItemAnimation::objectNameChanged(const QString &objectName)
  void emitter_QGraphicsItemAnimation_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QGraphicsItemAnimation::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QGraphicsItemAnimation::afterAnimationStep(double step)
  void cbs_afterAnimationStep_1071_0(double step)
  {
    QGraphicsItemAnimation::afterAnimationStep(step);
  }

  virtual void afterAnimationStep(double step)
  {
    if (cb_afterAnimationStep_1071_0.can_issue()) {
      cb_afterAnimationStep_1071_0.issue<QGraphicsItemAnimation_Adaptor, double>(&QGraphicsItemAnimation_Adaptor::cbs_afterAnimationStep_1071_0, step);
    } else {
      QGraphicsItemAnimation::afterAnimationStep(step);
    }
  }

  //  [adaptor impl] void QGraphicsItemAnimation::beforeAnimationStep(double step)
  void cbs_beforeAnimationStep_1071_0(double step)
  {
    QGraphicsItemAnimation::beforeAnimationStep(step);
  }

  virtual void beforeAnimationStep(double step)
  {
    if (cb_beforeAnimationStep_1071_0.can_issue()) {
      cb_beforeAnimationStep_1071_0.issue<QGraphicsItemAnimation_Adaptor, double>(&QGraphicsItemAnimation_Adaptor::cbs_beforeAnimationStep_1071_0, step);
    } else {
      QGraphicsItemAnimation::beforeAnimationStep(step);
    }
  }

  //  [adaptor impl] void QGraphicsItemAnimation::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QGraphicsItemAnimation::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsItemAnimation_Adaptor, QChildEvent *>(&QGraphicsItemAnimation_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QGraphicsItemAnimation::childEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItemAnimation::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QGraphicsItemAnimation::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsItemAnimation_Adaptor, QEvent *>(&QGraphicsItemAnimation_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QGraphicsItemAnimation::customEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItemAnimation::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QGraphicsItemAnimation::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QGraphicsItemAnimation_Adaptor, const QMetaMethod &>(&QGraphicsItemAnimation_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QGraphicsItemAnimation::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsItemAnimation::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QGraphicsItemAnimation::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsItemAnimation_Adaptor, QTimerEvent *>(&QGraphicsItemAnimation_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QGraphicsItemAnimation::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_afterAnimationStep_1071_0;
  gsi::Callback cb_beforeAnimationStep_1071_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QGraphicsItemAnimation_Adaptor::~QGraphicsItemAnimation_Adaptor() { }

//  Constructor QGraphicsItemAnimation::QGraphicsItemAnimation(QObject *parent) (adaptor class)

static void _init_ctor_QGraphicsItemAnimation_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QGraphicsItemAnimation_Adaptor> ();
}

static void _call_ctor_QGraphicsItemAnimation_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QGraphicsItemAnimation_Adaptor *> (new QGraphicsItemAnimation_Adaptor (arg1));
}


// void QGraphicsItemAnimation::afterAnimationStep(double step)

static void _init_cbs_afterAnimationStep_1071_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_afterAnimationStep_1071_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args.read<double > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItemAnimation_Adaptor *)cls)->cbs_afterAnimationStep_1071_0 (arg1);
}

static void _set_callback_cbs_afterAnimationStep_1071_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItemAnimation_Adaptor *)cls)->cb_afterAnimationStep_1071_0 = cb;
}


// void QGraphicsItemAnimation::beforeAnimationStep(double step)

static void _init_cbs_beforeAnimationStep_1071_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_beforeAnimationStep_1071_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args.read<double > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItemAnimation_Adaptor *)cls)->cbs_beforeAnimationStep_1071_0 (arg1);
}

static void _set_callback_cbs_beforeAnimationStep_1071_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItemAnimation_Adaptor *)cls)->cb_beforeAnimationStep_1071_0 = cb;
}


// void QGraphicsItemAnimation::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItemAnimation_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItemAnimation_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QGraphicsItemAnimation::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItemAnimation_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItemAnimation_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QGraphicsItemAnimation::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QGraphicsItemAnimation_Adaptor *)cls)->emitter_QGraphicsItemAnimation_destroyed_1302 (arg1);
}


// void QGraphicsItemAnimation::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItemAnimation_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItemAnimation_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QGraphicsItemAnimation::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsItemAnimation_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItemAnimation_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QGraphicsItemAnimation::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsItemAnimation_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItemAnimation_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QGraphicsItemAnimation::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsItemAnimation_Adaptor *)cls)->fp_QGraphicsItemAnimation_isSignalConnected_c2394 (arg1));
}


// emitter void QGraphicsItemAnimation::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QGraphicsItemAnimation_Adaptor *)cls)->emitter_QGraphicsItemAnimation_objectNameChanged_4567 (arg1);
}


// exposed int QGraphicsItemAnimation::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QGraphicsItemAnimation_Adaptor *)cls)->fp_QGraphicsItemAnimation_receivers_c1731 (arg1));
}


// exposed QObject *QGraphicsItemAnimation::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QGraphicsItemAnimation_Adaptor *)cls)->fp_QGraphicsItemAnimation_sender_c0 ());
}


// exposed int QGraphicsItemAnimation::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsItemAnimation_Adaptor *)cls)->fp_QGraphicsItemAnimation_senderSignalIndex_c0 ());
}


// void QGraphicsItemAnimation::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItemAnimation_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItemAnimation_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QGraphicsItemAnimation> &qtdecl_QGraphicsItemAnimation ();

static gsi::Methods methods_QGraphicsItemAnimation_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsItemAnimation::QGraphicsItemAnimation(QObject *parent)\nThis method creates an object of class QGraphicsItemAnimation.", &_init_ctor_QGraphicsItemAnimation_Adaptor_1302, &_call_ctor_QGraphicsItemAnimation_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*afterAnimationStep", "@brief Virtual method void QGraphicsItemAnimation::afterAnimationStep(double step)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_afterAnimationStep_1071_0, &_call_cbs_afterAnimationStep_1071_0);
  methods += new qt_gsi::GenericMethod ("*afterAnimationStep", "@hide", false, &_init_cbs_afterAnimationStep_1071_0, &_call_cbs_afterAnimationStep_1071_0, &_set_callback_cbs_afterAnimationStep_1071_0);
  methods += new qt_gsi::GenericMethod ("*beforeAnimationStep", "@brief Virtual method void QGraphicsItemAnimation::beforeAnimationStep(double step)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_beforeAnimationStep_1071_0, &_call_cbs_beforeAnimationStep_1071_0);
  methods += new qt_gsi::GenericMethod ("*beforeAnimationStep", "@hide", false, &_init_cbs_beforeAnimationStep_1071_0, &_call_cbs_beforeAnimationStep_1071_0, &_set_callback_cbs_beforeAnimationStep_1071_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsItemAnimation::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsItemAnimation::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QGraphicsItemAnimation::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsItemAnimation::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QGraphicsItemAnimation::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QGraphicsItemAnimation::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QGraphicsItemAnimation::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QGraphicsItemAnimation::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QGraphicsItemAnimation::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QGraphicsItemAnimation::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QGraphicsItemAnimation::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsItemAnimation::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QGraphicsItemAnimation_Adaptor> decl_QGraphicsItemAnimation_Adaptor (qtdecl_QGraphicsItemAnimation (), "QtWidgets", "QGraphicsItemAnimation",
  methods_QGraphicsItemAnimation_Adaptor (),
  "@qt\n@brief Binding of QGraphicsItemAnimation");

}

