
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQNetworkAccessManager.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QNetworkAccessManager>
#include <QAbstractNetworkCache>
#include <QAuthenticator>
#include <QChildEvent>
#include <QEvent>
#include <QHstsPolicy>
#include <QHttpMultiPart>
#include <QIODevice>
#include <QMetaMethod>
#include <QNetworkCookieJar>
#include <QNetworkProxy>
#include <QNetworkProxyFactory>
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QObject>
#include <QSslConfiguration>
#include <QSslError>
#include <QSslPreSharedKeyAuthenticator>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtNetworkCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QNetworkAccessManager

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QNetworkAccessManager::staticMetaObject);
}


// void QNetworkAccessManager::addStrictTransportSecurityHosts(const QList<QHstsPolicy> &knownHosts)


static void _init_f_addStrictTransportSecurityHosts_3051 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("knownHosts");
  decl->add_arg<const QList<QHstsPolicy> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addStrictTransportSecurityHosts_3051 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QHstsPolicy> &arg1 = gsi::arg_reader<const QList<QHstsPolicy> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager *)cls)->addStrictTransportSecurityHosts (arg1);
}


// bool QNetworkAccessManager::autoDeleteReplies()


static void _init_f_autoDeleteReplies_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_autoDeleteReplies_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QNetworkAccessManager *)cls)->autoDeleteReplies ());
}


// QAbstractNetworkCache *QNetworkAccessManager::cache()


static void _init_f_cache_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractNetworkCache * > ();
}

static void _call_f_cache_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractNetworkCache * > ((QAbstractNetworkCache *)((QNetworkAccessManager *)cls)->cache ());
}


// void QNetworkAccessManager::clearAccessCache()


static void _init_f_clearAccessCache_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearAccessCache_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager *)cls)->clearAccessCache ();
}


// void QNetworkAccessManager::clearConnectionCache()


static void _init_f_clearConnectionCache_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearConnectionCache_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager *)cls)->clearConnectionCache ();
}


// void QNetworkAccessManager::connectToHost(const QString &hostName, quint16 port)


static void _init_f_connectToHost_3017 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hostName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port", true, "80");
  decl->add_arg<quint16 > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_connectToHost_3017 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  quint16 arg2 = args ? gsi::arg_reader<quint16 >() (args, heap) : gsi::arg_maker<quint16 >() (80, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager *)cls)->connectToHost (arg1, arg2);
}


// void QNetworkAccessManager::connectToHostEncrypted(const QString &hostName, quint16 port, const QSslConfiguration &sslConfiguration)


static void _init_f_connectToHostEncrypted_5977 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hostName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port", true, "443");
  decl->add_arg<quint16 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sslConfiguration", true, "QSslConfiguration::defaultConfiguration()");
  decl->add_arg<const QSslConfiguration & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_connectToHostEncrypted_5977 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  quint16 arg2 = args ? gsi::arg_reader<quint16 >() (args, heap) : gsi::arg_maker<quint16 >() (443, heap);
  const QSslConfiguration &arg3 = args ? gsi::arg_reader<const QSslConfiguration & >() (args, heap) : gsi::arg_maker<const QSslConfiguration & >() (QSslConfiguration::defaultConfiguration(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager *)cls)->connectToHostEncrypted (arg1, arg2, arg3);
}


// void QNetworkAccessManager::connectToHostEncrypted(const QString &hostName, quint16 port, const QSslConfiguration &sslConfiguration, const QString &peerName)


static void _init_f_connectToHostEncrypted_7894 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hostName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port");
  decl->add_arg<quint16 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sslConfiguration");
  decl->add_arg<const QSslConfiguration & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("peerName");
  decl->add_arg<const QString & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_connectToHostEncrypted_7894 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  quint16 arg2 = gsi::arg_reader<quint16 >() (args, heap);
  const QSslConfiguration &arg3 = gsi::arg_reader<const QSslConfiguration & >() (args, heap);
  const QString &arg4 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager *)cls)->connectToHostEncrypted (arg1, arg2, arg3, arg4);
}


// QNetworkCookieJar *QNetworkAccessManager::cookieJar()


static void _init_f_cookieJar_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNetworkCookieJar * > ();
}

static void _call_f_cookieJar_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QNetworkCookieJar * > ((QNetworkCookieJar *)((QNetworkAccessManager *)cls)->cookieJar ());
}


// QNetworkReply *QNetworkAccessManager::deleteResource(const QNetworkRequest &request)


static void _init_f_deleteResource_2885 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_deleteResource_2885 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkRequest &arg1 = gsi::arg_reader<const QNetworkRequest & >() (args, heap);
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->deleteResource (arg1));
}


// void QNetworkAccessManager::enableStrictTransportSecurityStore(bool enabled, const QString &storeDir)


static void _init_f_enableStrictTransportSecurityStore_2781 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("storeDir", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_enableStrictTransportSecurityStore_2781 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager *)cls)->enableStrictTransportSecurityStore (arg1, arg2);
}


// QNetworkReply *QNetworkAccessManager::get(const QNetworkRequest &request)


static void _init_f_get_2885 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_get_2885 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkRequest &arg1 = gsi::arg_reader<const QNetworkRequest & >() (args, heap);
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->get (arg1));
}


// QNetworkReply *QNetworkAccessManager::head(const QNetworkRequest &request)


static void _init_f_head_2885 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_head_2885 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkRequest &arg1 = gsi::arg_reader<const QNetworkRequest & >() (args, heap);
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->head (arg1));
}


// bool QNetworkAccessManager::isStrictTransportSecurityEnabled()


static void _init_f_isStrictTransportSecurityEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isStrictTransportSecurityEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QNetworkAccessManager *)cls)->isStrictTransportSecurityEnabled ());
}


// bool QNetworkAccessManager::isStrictTransportSecurityStoreEnabled()


static void _init_f_isStrictTransportSecurityStoreEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isStrictTransportSecurityStoreEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QNetworkAccessManager *)cls)->isStrictTransportSecurityStoreEnabled ());
}


// QNetworkReply *QNetworkAccessManager::post(const QNetworkRequest &request, QIODevice *data)


static void _init_f_post_4224 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("data");
  decl->add_arg<QIODevice * > (argspec_1);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_post_4224 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkRequest &arg1 = gsi::arg_reader<const QNetworkRequest & >() (args, heap);
  QIODevice *arg2 = gsi::arg_reader<QIODevice * >() (args, heap);
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->post (arg1, arg2));
}


// QNetworkReply *QNetworkAccessManager::post(const QNetworkRequest &request, const QByteArray &data)


static void _init_f_post_5086 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("data");
  decl->add_arg<const QByteArray & > (argspec_1);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_post_5086 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkRequest &arg1 = gsi::arg_reader<const QNetworkRequest & >() (args, heap);
  const QByteArray &arg2 = gsi::arg_reader<const QByteArray & >() (args, heap);
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->post (arg1, arg2));
}


// QNetworkReply *QNetworkAccessManager::post(const QNetworkRequest &request, QHttpMultiPart *multiPart)


static void _init_f_post_4826 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("multiPart");
  decl->add_arg<QHttpMultiPart * > (argspec_1);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_post_4826 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkRequest &arg1 = gsi::arg_reader<const QNetworkRequest & >() (args, heap);
  QHttpMultiPart *arg2 = gsi::arg_reader<QHttpMultiPart * >() (args, heap);
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->post (arg1, arg2));
}


// QNetworkProxy QNetworkAccessManager::proxy()


static void _init_f_proxy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNetworkProxy > ();
}

static void _call_f_proxy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QNetworkProxy > ((QNetworkProxy)((QNetworkAccessManager *)cls)->proxy ());
}


// QNetworkProxyFactory *QNetworkAccessManager::proxyFactory()


static void _init_f_proxyFactory_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNetworkProxyFactory * > ();
}

static void _call_f_proxyFactory_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QNetworkProxyFactory * > ((QNetworkProxyFactory *)((QNetworkAccessManager *)cls)->proxyFactory ());
}


// QNetworkReply *QNetworkAccessManager::put(const QNetworkRequest &request, QIODevice *data)


static void _init_f_put_4224 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("data");
  decl->add_arg<QIODevice * > (argspec_1);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_put_4224 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkRequest &arg1 = gsi::arg_reader<const QNetworkRequest & >() (args, heap);
  QIODevice *arg2 = gsi::arg_reader<QIODevice * >() (args, heap);
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->put (arg1, arg2));
}


// QNetworkReply *QNetworkAccessManager::put(const QNetworkRequest &request, const QByteArray &data)


static void _init_f_put_5086 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("data");
  decl->add_arg<const QByteArray & > (argspec_1);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_put_5086 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkRequest &arg1 = gsi::arg_reader<const QNetworkRequest & >() (args, heap);
  const QByteArray &arg2 = gsi::arg_reader<const QByteArray & >() (args, heap);
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->put (arg1, arg2));
}


// QNetworkReply *QNetworkAccessManager::put(const QNetworkRequest &request, QHttpMultiPart *multiPart)


static void _init_f_put_4826 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("multiPart");
  decl->add_arg<QHttpMultiPart * > (argspec_1);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_put_4826 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkRequest &arg1 = gsi::arg_reader<const QNetworkRequest & >() (args, heap);
  QHttpMultiPart *arg2 = gsi::arg_reader<QHttpMultiPart * >() (args, heap);
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->put (arg1, arg2));
}


// QNetworkRequest::RedirectPolicy QNetworkAccessManager::redirectPolicy()


static void _init_f_redirectPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QNetworkRequest::RedirectPolicy>::target_type > ();
}

static void _call_f_redirectPolicy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QNetworkRequest::RedirectPolicy>::target_type > ((qt_gsi::Converter<QNetworkRequest::RedirectPolicy>::target_type)qt_gsi::CppToQtAdaptor<QNetworkRequest::RedirectPolicy>(((QNetworkAccessManager *)cls)->redirectPolicy ()));
}


// QNetworkReply *QNetworkAccessManager::sendCustomRequest(const QNetworkRequest &request, const QByteArray &verb, QIODevice *data)


static void _init_f_sendCustomRequest_6425 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("verb");
  decl->add_arg<const QByteArray & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data", true, "nullptr");
  decl->add_arg<QIODevice * > (argspec_2);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_sendCustomRequest_6425 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkRequest &arg1 = gsi::arg_reader<const QNetworkRequest & >() (args, heap);
  const QByteArray &arg2 = gsi::arg_reader<const QByteArray & >() (args, heap);
  QIODevice *arg3 = args ? gsi::arg_reader<QIODevice * >() (args, heap) : gsi::arg_maker<QIODevice * >() (nullptr, heap);
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->sendCustomRequest (arg1, arg2, arg3));
}


// QNetworkReply *QNetworkAccessManager::sendCustomRequest(const QNetworkRequest &request, const QByteArray &verb, const QByteArray &data)


static void _init_f_sendCustomRequest_7287 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("verb");
  decl->add_arg<const QByteArray & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data");
  decl->add_arg<const QByteArray & > (argspec_2);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_sendCustomRequest_7287 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkRequest &arg1 = gsi::arg_reader<const QNetworkRequest & >() (args, heap);
  const QByteArray &arg2 = gsi::arg_reader<const QByteArray & >() (args, heap);
  const QByteArray &arg3 = gsi::arg_reader<const QByteArray & >() (args, heap);
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->sendCustomRequest (arg1, arg2, arg3));
}


// QNetworkReply *QNetworkAccessManager::sendCustomRequest(const QNetworkRequest &request, const QByteArray &verb, QHttpMultiPart *multiPart)


static void _init_f_sendCustomRequest_7027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("verb");
  decl->add_arg<const QByteArray & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("multiPart");
  decl->add_arg<QHttpMultiPart * > (argspec_2);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_sendCustomRequest_7027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkRequest &arg1 = gsi::arg_reader<const QNetworkRequest & >() (args, heap);
  const QByteArray &arg2 = gsi::arg_reader<const QByteArray & >() (args, heap);
  QHttpMultiPart *arg3 = gsi::arg_reader<QHttpMultiPart * >() (args, heap);
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->sendCustomRequest (arg1, arg2, arg3));
}


// void QNetworkAccessManager::setAutoDeleteReplies(bool autoDelete)


static void _init_f_setAutoDeleteReplies_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("autoDelete");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoDeleteReplies_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager *)cls)->setAutoDeleteReplies (arg1);
}


// void QNetworkAccessManager::setCache(QAbstractNetworkCache *cache)


static void _init_f_setCache_2737 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cache");
  decl->add_arg<QAbstractNetworkCache * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCache_2737 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractNetworkCache *arg1 = gsi::arg_reader<QAbstractNetworkCache * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager *)cls)->setCache (arg1);
}


// void QNetworkAccessManager::setCookieJar(QNetworkCookieJar *cookieJar)


static void _init_f_setCookieJar_2336 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cookieJar");
  decl->add_arg<QNetworkCookieJar * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCookieJar_2336 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QNetworkCookieJar *arg1 = gsi::arg_reader<QNetworkCookieJar * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager *)cls)->setCookieJar (arg1);
}


// void QNetworkAccessManager::setProxy(const QNetworkProxy &proxy)


static void _init_f_setProxy_2686 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("proxy");
  decl->add_arg<const QNetworkProxy & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProxy_2686 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkProxy &arg1 = gsi::arg_reader<const QNetworkProxy & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager *)cls)->setProxy (arg1);
}


// void QNetworkAccessManager::setProxyFactory(QNetworkProxyFactory *factory)


static void _init_f_setProxyFactory_2723 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("factory");
  decl->add_arg<QNetworkProxyFactory * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProxyFactory_2723 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QNetworkProxyFactory *arg1 = gsi::arg_reader<QNetworkProxyFactory * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager *)cls)->setProxyFactory (arg1);
}


// void QNetworkAccessManager::setRedirectPolicy(QNetworkRequest::RedirectPolicy policy)


static void _init_f_setRedirectPolicy_3566 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<QNetworkRequest::RedirectPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRedirectPolicy_3566 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QNetworkRequest::RedirectPolicy>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QNetworkRequest::RedirectPolicy>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager *)cls)->setRedirectPolicy (qt_gsi::QtToCppAdaptor<QNetworkRequest::RedirectPolicy>(arg1).cref());
}


// void QNetworkAccessManager::setStrictTransportSecurityEnabled(bool enabled)


static void _init_f_setStrictTransportSecurityEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStrictTransportSecurityEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager *)cls)->setStrictTransportSecurityEnabled (arg1);
}


// void QNetworkAccessManager::setTransferTimeout(int timeout)


static void _init_f_setTransferTimeout_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("timeout", true, "QNetworkRequest::DefaultTransferTimeoutConstant");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTransferTimeout_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (QNetworkRequest::DefaultTransferTimeoutConstant, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager *)cls)->setTransferTimeout (arg1);
}


// QList<QHstsPolicy> QNetworkAccessManager::strictTransportSecurityHosts()


static void _init_f_strictTransportSecurityHosts_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QHstsPolicy> > ();
}

static void _call_f_strictTransportSecurityHosts_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QHstsPolicy> > ((QList<QHstsPolicy>)((QNetworkAccessManager *)cls)->strictTransportSecurityHosts ());
}


// QStringList QNetworkAccessManager::supportedSchemes()


static void _init_f_supportedSchemes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_supportedSchemes_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QNetworkAccessManager *)cls)->supportedSchemes ());
}


// int QNetworkAccessManager::transferTimeout()


static void _init_f_transferTimeout_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_transferTimeout_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QNetworkAccessManager *)cls)->transferTimeout ());
}


// static QString QNetworkAccessManager::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QNetworkAccessManager::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QNetworkAccessManager () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addStrictTransportSecurityHosts", "@brief Method void QNetworkAccessManager::addStrictTransportSecurityHosts(const QList<QHstsPolicy> &knownHosts)\n", false, &_init_f_addStrictTransportSecurityHosts_3051, &_call_f_addStrictTransportSecurityHosts_3051);
  methods += new qt_gsi::GenericMethod (":autoDeleteReplies", "@brief Method bool QNetworkAccessManager::autoDeleteReplies()\n", true, &_init_f_autoDeleteReplies_c0, &_call_f_autoDeleteReplies_c0);
  methods += new qt_gsi::GenericMethod (":cache", "@brief Method QAbstractNetworkCache *QNetworkAccessManager::cache()\n", true, &_init_f_cache_c0, &_call_f_cache_c0);
  methods += new qt_gsi::GenericMethod ("clearAccessCache", "@brief Method void QNetworkAccessManager::clearAccessCache()\n", false, &_init_f_clearAccessCache_0, &_call_f_clearAccessCache_0);
  methods += new qt_gsi::GenericMethod ("clearConnectionCache", "@brief Method void QNetworkAccessManager::clearConnectionCache()\n", false, &_init_f_clearConnectionCache_0, &_call_f_clearConnectionCache_0);
  methods += new qt_gsi::GenericMethod ("connectToHost", "@brief Method void QNetworkAccessManager::connectToHost(const QString &hostName, quint16 port)\n", false, &_init_f_connectToHost_3017, &_call_f_connectToHost_3017);
  methods += new qt_gsi::GenericMethod ("connectToHostEncrypted", "@brief Method void QNetworkAccessManager::connectToHostEncrypted(const QString &hostName, quint16 port, const QSslConfiguration &sslConfiguration)\n", false, &_init_f_connectToHostEncrypted_5977, &_call_f_connectToHostEncrypted_5977);
  methods += new qt_gsi::GenericMethod ("connectToHostEncrypted", "@brief Method void QNetworkAccessManager::connectToHostEncrypted(const QString &hostName, quint16 port, const QSslConfiguration &sslConfiguration, const QString &peerName)\n", false, &_init_f_connectToHostEncrypted_7894, &_call_f_connectToHostEncrypted_7894);
  methods += new qt_gsi::GenericMethod (":cookieJar", "@brief Method QNetworkCookieJar *QNetworkAccessManager::cookieJar()\n", true, &_init_f_cookieJar_c0, &_call_f_cookieJar_c0);
  methods += new qt_gsi::GenericMethod ("deleteResource", "@brief Method QNetworkReply *QNetworkAccessManager::deleteResource(const QNetworkRequest &request)\n", false, &_init_f_deleteResource_2885, &_call_f_deleteResource_2885);
  methods += new qt_gsi::GenericMethod ("enableStrictTransportSecurityStore", "@brief Method void QNetworkAccessManager::enableStrictTransportSecurityStore(bool enabled, const QString &storeDir)\n", false, &_init_f_enableStrictTransportSecurityStore_2781, &_call_f_enableStrictTransportSecurityStore_2781);
  methods += new qt_gsi::GenericMethod ("get", "@brief Method QNetworkReply *QNetworkAccessManager::get(const QNetworkRequest &request)\n", false, &_init_f_get_2885, &_call_f_get_2885);
  methods += new qt_gsi::GenericMethod ("head", "@brief Method QNetworkReply *QNetworkAccessManager::head(const QNetworkRequest &request)\n", false, &_init_f_head_2885, &_call_f_head_2885);
  methods += new qt_gsi::GenericMethod ("isStrictTransportSecurityEnabled?|:strictTransportSecurityEnabled", "@brief Method bool QNetworkAccessManager::isStrictTransportSecurityEnabled()\n", true, &_init_f_isStrictTransportSecurityEnabled_c0, &_call_f_isStrictTransportSecurityEnabled_c0);
  methods += new qt_gsi::GenericMethod ("isStrictTransportSecurityStoreEnabled?", "@brief Method bool QNetworkAccessManager::isStrictTransportSecurityStoreEnabled()\n", true, &_init_f_isStrictTransportSecurityStoreEnabled_c0, &_call_f_isStrictTransportSecurityStoreEnabled_c0);
  methods += new qt_gsi::GenericMethod ("post", "@brief Method QNetworkReply *QNetworkAccessManager::post(const QNetworkRequest &request, QIODevice *data)\n", false, &_init_f_post_4224, &_call_f_post_4224);
  methods += new qt_gsi::GenericMethod ("post", "@brief Method QNetworkReply *QNetworkAccessManager::post(const QNetworkRequest &request, const QByteArray &data)\n", false, &_init_f_post_5086, &_call_f_post_5086);
  methods += new qt_gsi::GenericMethod ("post", "@brief Method QNetworkReply *QNetworkAccessManager::post(const QNetworkRequest &request, QHttpMultiPart *multiPart)\n", false, &_init_f_post_4826, &_call_f_post_4826);
  methods += new qt_gsi::GenericMethod (":proxy", "@brief Method QNetworkProxy QNetworkAccessManager::proxy()\n", true, &_init_f_proxy_c0, &_call_f_proxy_c0);
  methods += new qt_gsi::GenericMethod (":proxyFactory", "@brief Method QNetworkProxyFactory *QNetworkAccessManager::proxyFactory()\n", true, &_init_f_proxyFactory_c0, &_call_f_proxyFactory_c0);
  methods += new qt_gsi::GenericMethod ("put", "@brief Method QNetworkReply *QNetworkAccessManager::put(const QNetworkRequest &request, QIODevice *data)\n", false, &_init_f_put_4224, &_call_f_put_4224);
  methods += new qt_gsi::GenericMethod ("put", "@brief Method QNetworkReply *QNetworkAccessManager::put(const QNetworkRequest &request, const QByteArray &data)\n", false, &_init_f_put_5086, &_call_f_put_5086);
  methods += new qt_gsi::GenericMethod ("put", "@brief Method QNetworkReply *QNetworkAccessManager::put(const QNetworkRequest &request, QHttpMultiPart *multiPart)\n", false, &_init_f_put_4826, &_call_f_put_4826);
  methods += new qt_gsi::GenericMethod (":redirectPolicy", "@brief Method QNetworkRequest::RedirectPolicy QNetworkAccessManager::redirectPolicy()\n", true, &_init_f_redirectPolicy_c0, &_call_f_redirectPolicy_c0);
  methods += new qt_gsi::GenericMethod ("sendCustomRequest", "@brief Method QNetworkReply *QNetworkAccessManager::sendCustomRequest(const QNetworkRequest &request, const QByteArray &verb, QIODevice *data)\n", false, &_init_f_sendCustomRequest_6425, &_call_f_sendCustomRequest_6425);
  methods += new qt_gsi::GenericMethod ("sendCustomRequest", "@brief Method QNetworkReply *QNetworkAccessManager::sendCustomRequest(const QNetworkRequest &request, const QByteArray &verb, const QByteArray &data)\n", false, &_init_f_sendCustomRequest_7287, &_call_f_sendCustomRequest_7287);
  methods += new qt_gsi::GenericMethod ("sendCustomRequest", "@brief Method QNetworkReply *QNetworkAccessManager::sendCustomRequest(const QNetworkRequest &request, const QByteArray &verb, QHttpMultiPart *multiPart)\n", false, &_init_f_sendCustomRequest_7027, &_call_f_sendCustomRequest_7027);
  methods += new qt_gsi::GenericMethod ("setAutoDeleteReplies|autoDeleteReplies=", "@brief Method void QNetworkAccessManager::setAutoDeleteReplies(bool autoDelete)\n", false, &_init_f_setAutoDeleteReplies_864, &_call_f_setAutoDeleteReplies_864);
  methods += new qt_gsi::GenericMethod ("setCache|cache=", "@brief Method void QNetworkAccessManager::setCache(QAbstractNetworkCache *cache)\n", false, &_init_f_setCache_2737, &_call_f_setCache_2737);
  methods += new qt_gsi::GenericMethod ("setCookieJar|cookieJar=", "@brief Method void QNetworkAccessManager::setCookieJar(QNetworkCookieJar *cookieJar)\n", false, &_init_f_setCookieJar_2336, &_call_f_setCookieJar_2336);
  methods += new qt_gsi::GenericMethod ("setProxy|proxy=", "@brief Method void QNetworkAccessManager::setProxy(const QNetworkProxy &proxy)\n", false, &_init_f_setProxy_2686, &_call_f_setProxy_2686);
  methods += new qt_gsi::GenericMethod ("setProxyFactory|proxyFactory=", "@brief Method void QNetworkAccessManager::setProxyFactory(QNetworkProxyFactory *factory)\n", false, &_init_f_setProxyFactory_2723, &_call_f_setProxyFactory_2723);
  methods += new qt_gsi::GenericMethod ("setRedirectPolicy|redirectPolicy=", "@brief Method void QNetworkAccessManager::setRedirectPolicy(QNetworkRequest::RedirectPolicy policy)\n", false, &_init_f_setRedirectPolicy_3566, &_call_f_setRedirectPolicy_3566);
  methods += new qt_gsi::GenericMethod ("setStrictTransportSecurityEnabled|strictTransportSecurityEnabled=", "@brief Method void QNetworkAccessManager::setStrictTransportSecurityEnabled(bool enabled)\n", false, &_init_f_setStrictTransportSecurityEnabled_864, &_call_f_setStrictTransportSecurityEnabled_864);
  methods += new qt_gsi::GenericMethod ("setTransferTimeout", "@brief Method void QNetworkAccessManager::setTransferTimeout(int timeout)\n", false, &_init_f_setTransferTimeout_767, &_call_f_setTransferTimeout_767);
  methods += new qt_gsi::GenericMethod ("strictTransportSecurityHosts", "@brief Method QList<QHstsPolicy> QNetworkAccessManager::strictTransportSecurityHosts()\n", true, &_init_f_strictTransportSecurityHosts_c0, &_call_f_strictTransportSecurityHosts_c0);
  methods += new qt_gsi::GenericMethod ("supportedSchemes", "@brief Method QStringList QNetworkAccessManager::supportedSchemes()\n", true, &_init_f_supportedSchemes_c0, &_call_f_supportedSchemes_c0);
  methods += new qt_gsi::GenericMethod ("transferTimeout", "@brief Method int QNetworkAccessManager::transferTimeout()\n", true, &_init_f_transferTimeout_c0, &_call_f_transferTimeout_c0);
  methods += gsi::qt_signal<QNetworkReply *, QAuthenticator * > ("authenticationRequired(QNetworkReply *, QAuthenticator *)", "authenticationRequired", gsi::arg("reply"), gsi::arg("authenticator"), "@brief Signal declaration for QNetworkAccessManager::authenticationRequired(QNetworkReply *reply, QAuthenticator *authenticator)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QNetworkAccessManager::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QNetworkReply * > ("encrypted(QNetworkReply *)", "encrypted", gsi::arg("reply"), "@brief Signal declaration for QNetworkAccessManager::encrypted(QNetworkReply *reply)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QNetworkReply * > ("finished(QNetworkReply *)", "finished", gsi::arg("reply"), "@brief Signal declaration for QNetworkAccessManager::finished(QNetworkReply *reply)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QNetworkAccessManager::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QNetworkReply *, QSslPreSharedKeyAuthenticator * > ("preSharedKeyAuthenticationRequired(QNetworkReply *, QSslPreSharedKeyAuthenticator *)", "preSharedKeyAuthenticationRequired", gsi::arg("reply"), gsi::arg("authenticator"), "@brief Signal declaration for QNetworkAccessManager::preSharedKeyAuthenticationRequired(QNetworkReply *reply, QSslPreSharedKeyAuthenticator *authenticator)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QNetworkProxy &, QAuthenticator * > ("proxyAuthenticationRequired(const QNetworkProxy &, QAuthenticator *)", "proxyAuthenticationRequired", gsi::arg("proxy"), gsi::arg("authenticator"), "@brief Signal declaration for QNetworkAccessManager::proxyAuthenticationRequired(const QNetworkProxy &proxy, QAuthenticator *authenticator)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QNetworkReply *, const QList<QSslError> & > ("sslErrors(QNetworkReply *, const QList<QSslError> &)", "sslErrors", gsi::arg("reply"), gsi::arg("errors"), "@brief Signal declaration for QNetworkAccessManager::sslErrors(QNetworkReply *reply, const QList<QSslError> &errors)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QNetworkAccessManager::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QNetworkAccessManager> decl_QNetworkAccessManager (qtdecl_QObject (), "QtNetwork", "QNetworkAccessManager_Native",
  methods_QNetworkAccessManager (),
  "@hide\n@alias QNetworkAccessManager");

GSI_QTNETWORK_PUBLIC gsi::Class<QNetworkAccessManager> &qtdecl_QNetworkAccessManager () { return decl_QNetworkAccessManager; }

}


class QNetworkAccessManager_Adaptor : public QNetworkAccessManager, public qt_gsi::QtObjectBase
{
public:

  virtual ~QNetworkAccessManager_Adaptor();

  //  [adaptor ctor] QNetworkAccessManager::QNetworkAccessManager(QObject *parent)
  QNetworkAccessManager_Adaptor() : QNetworkAccessManager()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QNetworkAccessManager::QNetworkAccessManager(QObject *parent)
  QNetworkAccessManager_Adaptor(QObject *parent) : QNetworkAccessManager(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QNetworkAccessManager::isSignalConnected(const QMetaMethod &signal)
  bool fp_QNetworkAccessManager_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QNetworkAccessManager::isSignalConnected(signal);
  }

  //  [expose] int QNetworkAccessManager::receivers(const char *signal)
  int fp_QNetworkAccessManager_receivers_c1731 (const char *signal) const {
    return QNetworkAccessManager::receivers(signal);
  }

  //  [expose] QObject *QNetworkAccessManager::sender()
  QObject * fp_QNetworkAccessManager_sender_c0 () const {
    return QNetworkAccessManager::sender();
  }

  //  [expose] int QNetworkAccessManager::senderSignalIndex()
  int fp_QNetworkAccessManager_senderSignalIndex_c0 () const {
    return QNetworkAccessManager::senderSignalIndex();
  }

  //  [expose] QStringList QNetworkAccessManager::supportedSchemesImplementation()
  QStringList fp_QNetworkAccessManager_supportedSchemesImplementation_c0 () const {
    return QNetworkAccessManager::supportedSchemesImplementation();
  }

  //  [emitter impl] void QNetworkAccessManager::authenticationRequired(QNetworkReply *reply, QAuthenticator *authenticator)
  void emitter_QNetworkAccessManager_authenticationRequired_3939(QNetworkReply *reply, QAuthenticator *authenticator)
  {
    emit QNetworkAccessManager::authenticationRequired(reply, authenticator);
  }

  //  [emitter impl] void QNetworkAccessManager::destroyed(QObject *)
  void emitter_QNetworkAccessManager_destroyed_1302(QObject *arg1)
  {
    emit QNetworkAccessManager::destroyed(arg1);
  }

  //  [emitter impl] void QNetworkAccessManager::encrypted(QNetworkReply *reply)
  void emitter_QNetworkAccessManager_encrypted_1973(QNetworkReply *reply)
  {
    emit QNetworkAccessManager::encrypted(reply);
  }

  //  [adaptor impl] bool QNetworkAccessManager::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QNetworkAccessManager::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QNetworkAccessManager_Adaptor, bool, QEvent *>(&QNetworkAccessManager_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QNetworkAccessManager::event(_event);
    }
  }

  //  [adaptor impl] bool QNetworkAccessManager::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QNetworkAccessManager::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QNetworkAccessManager_Adaptor, bool, QObject *, QEvent *>(&QNetworkAccessManager_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QNetworkAccessManager::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QNetworkAccessManager::finished(QNetworkReply *reply)
  void emitter_QNetworkAccessManager_finished_1973(QNetworkReply *reply)
  {
    emit QNetworkAccessManager::finished(reply);
  }

  //  [emitter impl] void QNetworkAccessManager::objectNameChanged(const QString &objectName)
  void emitter_QNetworkAccessManager_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QNetworkAccessManager::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QNetworkAccessManager::preSharedKeyAuthenticationRequired(QNetworkReply *reply, QSslPreSharedKeyAuthenticator *authenticator)
  void emitter_QNetworkAccessManager_preSharedKeyAuthenticationRequired_5436(QNetworkReply *reply, QSslPreSharedKeyAuthenticator *authenticator)
  {
    emit QNetworkAccessManager::preSharedKeyAuthenticationRequired(reply, authenticator);
  }

  //  [emitter impl] void QNetworkAccessManager::proxyAuthenticationRequired(const QNetworkProxy &proxy, QAuthenticator *authenticator)
  void emitter_QNetworkAccessManager_proxyAuthenticationRequired_4652(const QNetworkProxy &proxy, QAuthenticator *authenticator)
  {
    emit QNetworkAccessManager::proxyAuthenticationRequired(proxy, authenticator);
  }

  //  [emitter impl] void QNetworkAccessManager::sslErrors(QNetworkReply *reply, const QList<QSslError> &errors)
  void emitter_QNetworkAccessManager_sslErrors_4702(QNetworkReply *reply, const QList<QSslError> &errors)
  {
    emit QNetworkAccessManager::sslErrors(reply, errors);
  }

  //  [adaptor impl] QStringList QNetworkAccessManager::supportedSchemes()
  QStringList cbs_supportedSchemes_c0_0() const
  {
    return QNetworkAccessManager::supportedSchemes();
  }

  virtual QStringList supportedSchemes() const
  {
    if (cb_supportedSchemes_c0_0.can_issue()) {
      return cb_supportedSchemes_c0_0.issue<QNetworkAccessManager_Adaptor, QStringList>(&QNetworkAccessManager_Adaptor::cbs_supportedSchemes_c0_0);
    } else {
      return QNetworkAccessManager::supportedSchemes();
    }
  }

  //  [adaptor impl] void QNetworkAccessManager::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QNetworkAccessManager::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QNetworkAccessManager_Adaptor, QChildEvent *>(&QNetworkAccessManager_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QNetworkAccessManager::childEvent(event);
    }
  }

  //  [adaptor impl] QNetworkReply *QNetworkAccessManager::createRequest(QNetworkAccessManager::Operation op, const QNetworkRequest &request, QIODevice *outgoingData)
  QNetworkReply * cbs_createRequest_7733_1(const qt_gsi::Converter<QNetworkAccessManager::Operation>::target_type & op, const QNetworkRequest &request, QIODevice *outgoingData)
  {
    return QNetworkAccessManager::createRequest(qt_gsi::QtToCppAdaptor<QNetworkAccessManager::Operation>(op).cref(), request, outgoingData);
  }

  virtual QNetworkReply * createRequest(QNetworkAccessManager::Operation op, const QNetworkRequest &request, QIODevice *outgoingData)
  {
    if (cb_createRequest_7733_1.can_issue()) {
      return cb_createRequest_7733_1.issue<QNetworkAccessManager_Adaptor, QNetworkReply *, const qt_gsi::Converter<QNetworkAccessManager::Operation>::target_type &, const QNetworkRequest &, QIODevice *>(&QNetworkAccessManager_Adaptor::cbs_createRequest_7733_1, qt_gsi::CppToQtAdaptor<QNetworkAccessManager::Operation>(op), request, outgoingData);
    } else {
      return QNetworkAccessManager::createRequest(op, request, outgoingData);
    }
  }

  //  [adaptor impl] void QNetworkAccessManager::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QNetworkAccessManager::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QNetworkAccessManager_Adaptor, QEvent *>(&QNetworkAccessManager_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QNetworkAccessManager::customEvent(event);
    }
  }

  //  [adaptor impl] void QNetworkAccessManager::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QNetworkAccessManager::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QNetworkAccessManager_Adaptor, const QMetaMethod &>(&QNetworkAccessManager_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QNetworkAccessManager::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QNetworkAccessManager::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QNetworkAccessManager::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QNetworkAccessManager_Adaptor, QTimerEvent *>(&QNetworkAccessManager_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QNetworkAccessManager::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_supportedSchemes_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_createRequest_7733_1;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QNetworkAccessManager_Adaptor::~QNetworkAccessManager_Adaptor() { }

//  Constructor QNetworkAccessManager::QNetworkAccessManager(QObject *parent) (adaptor class)

static void _init_ctor_QNetworkAccessManager_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QNetworkAccessManager_Adaptor> ();
}

static void _call_ctor_QNetworkAccessManager_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QNetworkAccessManager_Adaptor *> (new QNetworkAccessManager_Adaptor (arg1));
}


// emitter void QNetworkAccessManager::authenticationRequired(QNetworkReply *reply, QAuthenticator *authenticator)

static void _init_emitter_authenticationRequired_3939 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("reply");
  decl->add_arg<QNetworkReply * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("authenticator");
  decl->add_arg<QAuthenticator * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_authenticationRequired_3939 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QNetworkReply *arg1 = gsi::arg_reader<QNetworkReply * >() (args, heap);
  QAuthenticator *arg2 = gsi::arg_reader<QAuthenticator * >() (args, heap);
  ((QNetworkAccessManager_Adaptor *)cls)->emitter_QNetworkAccessManager_authenticationRequired_3939 (arg1, arg2);
}


// void QNetworkAccessManager::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkAccessManager_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// QNetworkReply *QNetworkAccessManager::createRequest(QNetworkAccessManager::Operation op, const QNetworkRequest &request, QIODevice *outgoingData)

static void _init_cbs_createRequest_7733_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("op");
  decl->add_arg<const qt_gsi::Converter<QNetworkAccessManager::Operation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("outgoingData");
  decl->add_arg<QIODevice * > (argspec_2);
  decl->set_return<QNetworkReply * > ();
}

static void _call_cbs_createRequest_7733_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QNetworkAccessManager::Operation>::target_type & arg1 = args.read<const qt_gsi::Converter<QNetworkAccessManager::Operation>::target_type & > (heap);
  const QNetworkRequest &arg2 = args.read<const QNetworkRequest & > (heap);
  QIODevice *arg3 = args.read<QIODevice * > (heap);
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager_Adaptor *)cls)->cbs_createRequest_7733_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_createRequest_7733_1 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkAccessManager_Adaptor *)cls)->cb_createRequest_7733_1 = cb;
}


// void QNetworkAccessManager::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkAccessManager_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QNetworkAccessManager::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QNetworkAccessManager_Adaptor *)cls)->emitter_QNetworkAccessManager_destroyed_1302 (arg1);
}


// void QNetworkAccessManager::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkAccessManager_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// emitter void QNetworkAccessManager::encrypted(QNetworkReply *reply)

static void _init_emitter_encrypted_1973 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("reply");
  decl->add_arg<QNetworkReply * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_encrypted_1973 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QNetworkReply *arg1 = gsi::arg_reader<QNetworkReply * >() (args, heap);
  ((QNetworkAccessManager_Adaptor *)cls)->emitter_QNetworkAccessManager_encrypted_1973 (arg1);
}


// bool QNetworkAccessManager::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QNetworkAccessManager_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkAccessManager_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QNetworkAccessManager::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QNetworkAccessManager_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkAccessManager_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QNetworkAccessManager::finished(QNetworkReply *reply)

static void _init_emitter_finished_1973 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("reply");
  decl->add_arg<QNetworkReply * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_finished_1973 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QNetworkReply *arg1 = gsi::arg_reader<QNetworkReply * >() (args, heap);
  ((QNetworkAccessManager_Adaptor *)cls)->emitter_QNetworkAccessManager_finished_1973 (arg1);
}


// exposed bool QNetworkAccessManager::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QNetworkAccessManager_Adaptor *)cls)->fp_QNetworkAccessManager_isSignalConnected_c2394 (arg1));
}


// emitter void QNetworkAccessManager::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QNetworkAccessManager_Adaptor *)cls)->emitter_QNetworkAccessManager_objectNameChanged_4567 (arg1);
}


// emitter void QNetworkAccessManager::preSharedKeyAuthenticationRequired(QNetworkReply *reply, QSslPreSharedKeyAuthenticator *authenticator)

static void _init_emitter_preSharedKeyAuthenticationRequired_5436 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("reply");
  decl->add_arg<QNetworkReply * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("authenticator");
  decl->add_arg<QSslPreSharedKeyAuthenticator * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_preSharedKeyAuthenticationRequired_5436 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QNetworkReply *arg1 = gsi::arg_reader<QNetworkReply * >() (args, heap);
  QSslPreSharedKeyAuthenticator *arg2 = gsi::arg_reader<QSslPreSharedKeyAuthenticator * >() (args, heap);
  ((QNetworkAccessManager_Adaptor *)cls)->emitter_QNetworkAccessManager_preSharedKeyAuthenticationRequired_5436 (arg1, arg2);
}


// emitter void QNetworkAccessManager::proxyAuthenticationRequired(const QNetworkProxy &proxy, QAuthenticator *authenticator)

static void _init_emitter_proxyAuthenticationRequired_4652 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("proxy");
  decl->add_arg<const QNetworkProxy & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("authenticator");
  decl->add_arg<QAuthenticator * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_proxyAuthenticationRequired_4652 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkProxy &arg1 = gsi::arg_reader<const QNetworkProxy & >() (args, heap);
  QAuthenticator *arg2 = gsi::arg_reader<QAuthenticator * >() (args, heap);
  ((QNetworkAccessManager_Adaptor *)cls)->emitter_QNetworkAccessManager_proxyAuthenticationRequired_4652 (arg1, arg2);
}


// exposed int QNetworkAccessManager::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QNetworkAccessManager_Adaptor *)cls)->fp_QNetworkAccessManager_receivers_c1731 (arg1));
}


// exposed QObject *QNetworkAccessManager::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QNetworkAccessManager_Adaptor *)cls)->fp_QNetworkAccessManager_sender_c0 ());
}


// exposed int QNetworkAccessManager::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QNetworkAccessManager_Adaptor *)cls)->fp_QNetworkAccessManager_senderSignalIndex_c0 ());
}


// emitter void QNetworkAccessManager::sslErrors(QNetworkReply *reply, const QList<QSslError> &errors)

static void _init_emitter_sslErrors_4702 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("reply");
  decl->add_arg<QNetworkReply * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("errors");
  decl->add_arg<const QList<QSslError> & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_sslErrors_4702 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QNetworkReply *arg1 = gsi::arg_reader<QNetworkReply * >() (args, heap);
  const QList<QSslError> &arg2 = gsi::arg_reader<const QList<QSslError> & >() (args, heap);
  ((QNetworkAccessManager_Adaptor *)cls)->emitter_QNetworkAccessManager_sslErrors_4702 (arg1, arg2);
}


// QStringList QNetworkAccessManager::supportedSchemes()

static void _init_cbs_supportedSchemes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_cbs_supportedSchemes_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QNetworkAccessManager_Adaptor *)cls)->cbs_supportedSchemes_c0_0 ());
}

static void _set_callback_cbs_supportedSchemes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkAccessManager_Adaptor *)cls)->cb_supportedSchemes_c0_0 = cb;
}


// exposed QStringList QNetworkAccessManager::supportedSchemesImplementation()

static void _init_fp_supportedSchemesImplementation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_fp_supportedSchemesImplementation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QNetworkAccessManager_Adaptor *)cls)->fp_QNetworkAccessManager_supportedSchemesImplementation_c0 ());
}


// void QNetworkAccessManager::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkAccessManager_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkAccessManager_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QNetworkAccessManager> &qtdecl_QNetworkAccessManager ();

static gsi::Methods methods_QNetworkAccessManager_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QNetworkAccessManager::QNetworkAccessManager(QObject *parent)\nThis method creates an object of class QNetworkAccessManager.", &_init_ctor_QNetworkAccessManager_Adaptor_1302, &_call_ctor_QNetworkAccessManager_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("emit_authenticationRequired", "@brief Emitter for signal void QNetworkAccessManager::authenticationRequired(QNetworkReply *reply, QAuthenticator *authenticator)\nCall this method to emit this signal.", false, &_init_emitter_authenticationRequired_3939, &_call_emitter_authenticationRequired_3939);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QNetworkAccessManager::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*createRequest", "@brief Virtual method QNetworkReply *QNetworkAccessManager::createRequest(QNetworkAccessManager::Operation op, const QNetworkRequest &request, QIODevice *outgoingData)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_createRequest_7733_1, &_call_cbs_createRequest_7733_1);
  methods += new qt_gsi::GenericMethod ("*createRequest", "@hide", false, &_init_cbs_createRequest_7733_1, &_call_cbs_createRequest_7733_1, &_set_callback_cbs_createRequest_7733_1);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QNetworkAccessManager::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QNetworkAccessManager::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QNetworkAccessManager::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("emit_encrypted", "@brief Emitter for signal void QNetworkAccessManager::encrypted(QNetworkReply *reply)\nCall this method to emit this signal.", false, &_init_emitter_encrypted_1973, &_call_emitter_encrypted_1973);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QNetworkAccessManager::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QNetworkAccessManager::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_finished", "@brief Emitter for signal void QNetworkAccessManager::finished(QNetworkReply *reply)\nCall this method to emit this signal.", false, &_init_emitter_finished_1973, &_call_emitter_finished_1973);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QNetworkAccessManager::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QNetworkAccessManager::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("emit_preSharedKeyAuthenticationRequired", "@brief Emitter for signal void QNetworkAccessManager::preSharedKeyAuthenticationRequired(QNetworkReply *reply, QSslPreSharedKeyAuthenticator *authenticator)\nCall this method to emit this signal.", false, &_init_emitter_preSharedKeyAuthenticationRequired_5436, &_call_emitter_preSharedKeyAuthenticationRequired_5436);
  methods += new qt_gsi::GenericMethod ("emit_proxyAuthenticationRequired", "@brief Emitter for signal void QNetworkAccessManager::proxyAuthenticationRequired(const QNetworkProxy &proxy, QAuthenticator *authenticator)\nCall this method to emit this signal.", false, &_init_emitter_proxyAuthenticationRequired_4652, &_call_emitter_proxyAuthenticationRequired_4652);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QNetworkAccessManager::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QNetworkAccessManager::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QNetworkAccessManager::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("emit_sslErrors", "@brief Emitter for signal void QNetworkAccessManager::sslErrors(QNetworkReply *reply, const QList<QSslError> &errors)\nCall this method to emit this signal.", false, &_init_emitter_sslErrors_4702, &_call_emitter_sslErrors_4702);
  methods += new qt_gsi::GenericMethod ("supportedSchemes", "@brief Virtual method QStringList QNetworkAccessManager::supportedSchemes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedSchemes_c0_0, &_call_cbs_supportedSchemes_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedSchemes", "@hide", true, &_init_cbs_supportedSchemes_c0_0, &_call_cbs_supportedSchemes_c0_0, &_set_callback_cbs_supportedSchemes_c0_0);
  methods += new qt_gsi::GenericMethod ("*supportedSchemesImplementation", "@brief Method QStringList QNetworkAccessManager::supportedSchemesImplementation()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_supportedSchemesImplementation_c0, &_call_fp_supportedSchemesImplementation_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QNetworkAccessManager::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QNetworkAccessManager_Adaptor> decl_QNetworkAccessManager_Adaptor (qtdecl_QNetworkAccessManager (), "QtNetwork", "QNetworkAccessManager",
  methods_QNetworkAccessManager_Adaptor (),
  "@qt\n@brief Binding of QNetworkAccessManager");

}


//  Implementation of the enum wrapper class for QNetworkAccessManager::Operation
namespace qt_gsi
{

static gsi::Enum<QNetworkAccessManager::Operation> decl_QNetworkAccessManager_Operation_Enum ("QtNetwork", "QNetworkAccessManager_Operation",
    gsi::enum_const ("HeadOperation", QNetworkAccessManager::HeadOperation, "@brief Enum constant QNetworkAccessManager::HeadOperation") +
    gsi::enum_const ("GetOperation", QNetworkAccessManager::GetOperation, "@brief Enum constant QNetworkAccessManager::GetOperation") +
    gsi::enum_const ("PutOperation", QNetworkAccessManager::PutOperation, "@brief Enum constant QNetworkAccessManager::PutOperation") +
    gsi::enum_const ("PostOperation", QNetworkAccessManager::PostOperation, "@brief Enum constant QNetworkAccessManager::PostOperation") +
    gsi::enum_const ("DeleteOperation", QNetworkAccessManager::DeleteOperation, "@brief Enum constant QNetworkAccessManager::DeleteOperation") +
    gsi::enum_const ("CustomOperation", QNetworkAccessManager::CustomOperation, "@brief Enum constant QNetworkAccessManager::CustomOperation") +
    gsi::enum_const ("UnknownOperation", QNetworkAccessManager::UnknownOperation, "@brief Enum constant QNetworkAccessManager::UnknownOperation"),
  "@qt\n@brief This class represents the QNetworkAccessManager::Operation enum");

static gsi::QFlagsClass<QNetworkAccessManager::Operation > decl_QNetworkAccessManager_Operation_Enums ("QtNetwork", "QNetworkAccessManager_QFlags_Operation",
  "@qt\n@brief This class represents the QFlags<QNetworkAccessManager::Operation> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QNetworkAccessManager> inject_QNetworkAccessManager_Operation_Enum_in_parent (decl_QNetworkAccessManager_Operation_Enum.defs ());
static gsi::ClassExt<QNetworkAccessManager> decl_QNetworkAccessManager_Operation_Enum_as_child (decl_QNetworkAccessManager_Operation_Enum, "Operation");
static gsi::ClassExt<QNetworkAccessManager> decl_QNetworkAccessManager_Operation_Enums_as_child (decl_QNetworkAccessManager_Operation_Enums, "QFlags_Operation");

}

