
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMessageLogger.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMessageLogger>
#include <QDebug>
#include <QLoggingCategory>
#include <QNoDebug>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMessageLogger
  static void critical1(QMessageLogger *logger, const char *msg) {
    logger->critical("%s", msg);
  }
  static void critical2(QMessageLogger *logger, const QLoggingCategory &cat, const char *msg) {
    logger->critical(cat, "%s", msg);
  }
  static void debug1(QMessageLogger *logger, const char *msg) {
    logger->debug("%s", msg);
  }
  static void debug2(QMessageLogger *logger, const QLoggingCategory &cat, const char *msg) {
    logger->debug(cat, "%s", msg);
  }
  static void fatal1(QMessageLogger *logger, const char *msg) {
    logger->fatal("%s", msg);
  }
  static void info1(QMessageLogger *logger, const char *msg) {
    logger->info("%s", msg);
  }
  static void info2(QMessageLogger *logger, const QLoggingCategory &cat, const char *msg) {
    logger->info(cat, "%s", msg);
  }
  static void noDebug1(QMessageLogger *logger, const char *msg) {
    logger->noDebug("%s", msg);
  }
  static void warning1(QMessageLogger *logger, const char *msg) {
    logger->warning("%s", msg);
  }
  static void warning2(QMessageLogger *logger, const QLoggingCategory &cat, const char *msg) {
    logger->warning(cat, "%s", msg);
  }

//  Constructor QMessageLogger::QMessageLogger()


static void _init_ctor_QMessageLogger_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QMessageLogger> ();
}

static void _call_ctor_QMessageLogger_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMessageLogger *> (new QMessageLogger ());
}


//  Constructor QMessageLogger::QMessageLogger(const char *file, int line, const char *function)


static void _init_ctor_QMessageLogger_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("file");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("line");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("function");
  decl->add_arg<const char * > (argspec_2);
  decl->set_return_new<QMessageLogger> ();
}

static void _call_ctor_QMessageLogger_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const char *arg3 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<QMessageLogger *> (new QMessageLogger (arg1, arg2, arg3));
}


//  Constructor QMessageLogger::QMessageLogger(const char *file, int line, const char *function, const char *category)


static void _init_ctor_QMessageLogger_5636 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("file");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("line");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("function");
  decl->add_arg<const char * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("category");
  decl->add_arg<const char * > (argspec_3);
  decl->set_return_new<QMessageLogger> ();
}

static void _call_ctor_QMessageLogger_5636 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const char *arg3 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg4 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<QMessageLogger *> (new QMessageLogger (arg1, arg2, arg3, arg4));
}


// QDebug QMessageLogger::critical()


static void _init_f_critical_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDebug > ();
}

static void _call_f_critical_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDebug > ((QDebug)((QMessageLogger *)cls)->critical ());
}


// QDebug QMessageLogger::critical(const QLoggingCategory &cat)


static void _init_f_critical_c2935 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cat");
  decl->add_arg<const QLoggingCategory & > (argspec_0);
  decl->set_return<QDebug > ();
}

static void _call_f_critical_c2935 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLoggingCategory &arg1 = gsi::arg_reader<const QLoggingCategory & >() (args, heap);
  ret.write<QDebug > ((QDebug)((QMessageLogger *)cls)->critical (arg1));
}


// QDebug QMessageLogger::debug()


static void _init_f_debug_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDebug > ();
}

static void _call_f_debug_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDebug > ((QDebug)((QMessageLogger *)cls)->debug ());
}


// QDebug QMessageLogger::debug(const QLoggingCategory &cat)


static void _init_f_debug_c2935 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cat");
  decl->add_arg<const QLoggingCategory & > (argspec_0);
  decl->set_return<QDebug > ();
}

static void _call_f_debug_c2935 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLoggingCategory &arg1 = gsi::arg_reader<const QLoggingCategory & >() (args, heap);
  ret.write<QDebug > ((QDebug)((QMessageLogger *)cls)->debug (arg1));
}


// QDebug QMessageLogger::info()


static void _init_f_info_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDebug > ();
}

static void _call_f_info_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDebug > ((QDebug)((QMessageLogger *)cls)->info ());
}


// QDebug QMessageLogger::info(const QLoggingCategory &cat)


static void _init_f_info_c2935 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cat");
  decl->add_arg<const QLoggingCategory & > (argspec_0);
  decl->set_return<QDebug > ();
}

static void _call_f_info_c2935 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLoggingCategory &arg1 = gsi::arg_reader<const QLoggingCategory & >() (args, heap);
  ret.write<QDebug > ((QDebug)((QMessageLogger *)cls)->info (arg1));
}


// QNoDebug QMessageLogger::noDebug()


static void _init_f_noDebug_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNoDebug > ();
}

static void _call_f_noDebug_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QNoDebug > ((QNoDebug)((QMessageLogger *)cls)->noDebug ());
}


// QDebug QMessageLogger::warning()


static void _init_f_warning_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDebug > ();
}

static void _call_f_warning_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDebug > ((QDebug)((QMessageLogger *)cls)->warning ());
}


// QDebug QMessageLogger::warning(const QLoggingCategory &cat)


static void _init_f_warning_c2935 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cat");
  decl->add_arg<const QLoggingCategory & > (argspec_0);
  decl->set_return<QDebug > ();
}

static void _call_f_warning_c2935 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLoggingCategory &arg1 = gsi::arg_reader<const QLoggingCategory & >() (args, heap);
  ret.write<QDebug > ((QDebug)((QMessageLogger *)cls)->warning (arg1));
}



namespace gsi
{

static gsi::Methods methods_QMessageLogger () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMessageLogger::QMessageLogger()\nThis method creates an object of class QMessageLogger.", &_init_ctor_QMessageLogger_0, &_call_ctor_QMessageLogger_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMessageLogger::QMessageLogger(const char *file, int line, const char *function)\nThis method creates an object of class QMessageLogger.", &_init_ctor_QMessageLogger_4013, &_call_ctor_QMessageLogger_4013);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMessageLogger::QMessageLogger(const char *file, int line, const char *function, const char *category)\nThis method creates an object of class QMessageLogger.", &_init_ctor_QMessageLogger_5636, &_call_ctor_QMessageLogger_5636);
  methods += new qt_gsi::GenericMethod ("critical", "@brief Method QDebug QMessageLogger::critical()\n", true, &_init_f_critical_c0, &_call_f_critical_c0);
  methods += new qt_gsi::GenericMethod ("critical", "@brief Method QDebug QMessageLogger::critical(const QLoggingCategory &cat)\n", true, &_init_f_critical_c2935, &_call_f_critical_c2935);
  methods += new qt_gsi::GenericMethod ("debug", "@brief Method QDebug QMessageLogger::debug()\n", true, &_init_f_debug_c0, &_call_f_debug_c0);
  methods += new qt_gsi::GenericMethod ("debug", "@brief Method QDebug QMessageLogger::debug(const QLoggingCategory &cat)\n", true, &_init_f_debug_c2935, &_call_f_debug_c2935);
  methods += new qt_gsi::GenericMethod ("info", "@brief Method QDebug QMessageLogger::info()\n", true, &_init_f_info_c0, &_call_f_info_c0);
  methods += new qt_gsi::GenericMethod ("info", "@brief Method QDebug QMessageLogger::info(const QLoggingCategory &cat)\n", true, &_init_f_info_c2935, &_call_f_info_c2935);
  methods += new qt_gsi::GenericMethod ("noDebug", "@brief Method QNoDebug QMessageLogger::noDebug()\n", true, &_init_f_noDebug_c0, &_call_f_noDebug_c0);
  methods += new qt_gsi::GenericMethod ("warning", "@brief Method QDebug QMessageLogger::warning()\n", true, &_init_f_warning_c0, &_call_f_warning_c0);
  methods += new qt_gsi::GenericMethod ("warning", "@brief Method QDebug QMessageLogger::warning(const QLoggingCategory &cat)\n", true, &_init_f_warning_c2935, &_call_f_warning_c2935);
  return methods;
}

gsi::Class<QMessageLogger> decl_QMessageLogger ("QtCore", "QMessageLogger",
  gsi::method_ext("critical", &critical1, gsi::arg ("msg"), "@brief Method void QMessageLogger::critical(const char *msg)") +
  gsi::method_ext("critical", &critical2, gsi::arg ("cat"), gsi::arg ("msg"), "@brief Method void QMessageLogger::critical(const QLoggingCategory &cat, const char *msg)") +
  gsi::method_ext("debug", &debug1, gsi::arg ("msg"), "@brief Method void QMessageLogger::debug(const char *msg)") +
  gsi::method_ext("debug", &debug2, gsi::arg ("cat"), gsi::arg ("msg"), "@brief Method void QMessageLogger::debug(const QLoggingCategory &cat, const char *msg)") +
  gsi::method_ext("fatal", &fatal1, gsi::arg ("msg"), "@brief Method void QMessageLogger::fatal(const char *msg)") +
  gsi::method_ext("info", &info1, gsi::arg ("msg"), "@brief Method void QMessageLogger::info(const char *msg)") +
  gsi::method_ext("info", &info2, gsi::arg ("cat"), gsi::arg ("msg"), "@brief Method void QMessageLogger::info(const QLoggingCategory &cat, const char *msg)") +
  gsi::method_ext("noDebug", &noDebug1, gsi::arg ("msg"), "@brief Method void QMessageLogger::noDebug(const char *msg)") +
  gsi::method_ext("warning", &warning1, gsi::arg ("msg"), "@brief Method void QMessageLogger::warning(const char *msg)") +
  gsi::method_ext("warning", &warning2, gsi::arg ("cat"), gsi::arg ("msg"), "@brief Method void QMessageLogger::warning(const QLoggingCategory &cat, const char *msg)")
+
  methods_QMessageLogger (),
  "@qt\n@brief Binding of QMessageLogger");


GSI_QTCORE_PUBLIC gsi::Class<QMessageLogger> &qtdecl_QMessageLogger () { return decl_QMessageLogger; }

}

