
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMessageBox.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMessageBox>
#include <QAbstractButton>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QCheckBox>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMetaMethod>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QPushButton>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMessageBox

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMessageBox::staticMetaObject);
}


// void QMessageBox::addButton(QAbstractButton *button, QMessageBox::ButtonRole role)


static void _init_f_addButton_4728 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::ButtonRole>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addButton_4728 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractButton *arg1 = gsi::arg_reader<QAbstractButton * >() (args, heap);
  const qt_gsi::Converter<QMessageBox::ButtonRole>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QMessageBox::ButtonRole>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->addButton (arg1, qt_gsi::QtToCppAdaptor<QMessageBox::ButtonRole>(arg2).cref());
}


// QPushButton *QMessageBox::addButton(const QString &text, QMessageBox::ButtonRole role)


static void _init_f_addButton_4594 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::ButtonRole>::target_type & > (argspec_1);
  decl->set_return<QPushButton * > ();
}

static void _call_f_addButton_4594 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QMessageBox::ButtonRole>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QMessageBox::ButtonRole>::target_type & >() (args, heap);
  ret.write<QPushButton * > ((QPushButton *)((QMessageBox *)cls)->addButton (arg1, qt_gsi::QtToCppAdaptor<QMessageBox::ButtonRole>(arg2).cref()));
}


// QPushButton *QMessageBox::addButton(QMessageBox::StandardButton button)


static void _init_f_addButton_3092 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > (argspec_0);
  decl->set_return<QPushButton * > ();
}

static void _call_f_addButton_3092 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & >() (args, heap);
  ret.write<QPushButton * > ((QPushButton *)((QMessageBox *)cls)->addButton (qt_gsi::QtToCppAdaptor<QMessageBox::StandardButton>(arg1).cref()));
}


// QAbstractButton *QMessageBox::button(QMessageBox::StandardButton which)


static void _init_f_button_c3092 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > (argspec_0);
  decl->set_return<QAbstractButton * > ();
}

static void _call_f_button_c3092 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & >() (args, heap);
  ret.write<QAbstractButton * > ((QAbstractButton *)((QMessageBox *)cls)->button (qt_gsi::QtToCppAdaptor<QMessageBox::StandardButton>(arg1).cref()));
}


// QMessageBox::ButtonRole QMessageBox::buttonRole(QAbstractButton *button)


static void _init_f_buttonRole_c2159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  decl->set_return<qt_gsi::Converter<QMessageBox::ButtonRole>::target_type > ();
}

static void _call_f_buttonRole_c2159 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractButton *arg1 = gsi::arg_reader<QAbstractButton * >() (args, heap);
  ret.write<qt_gsi::Converter<QMessageBox::ButtonRole>::target_type > ((qt_gsi::Converter<QMessageBox::ButtonRole>::target_type)qt_gsi::CppToQtAdaptor<QMessageBox::ButtonRole>(((QMessageBox *)cls)->buttonRole (arg1)));
}


// QString QMessageBox::buttonText(int button)


static void _init_f_buttonText_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_buttonText_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)((QMessageBox *)cls)->buttonText (arg1));
}


// QList<QAbstractButton *> QMessageBox::buttons()


static void _init_f_buttons_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QAbstractButton *> > ();
}

static void _call_f_buttons_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QAbstractButton *> > ((QList<QAbstractButton *>)((QMessageBox *)cls)->buttons ());
}


// QCheckBox *QMessageBox::checkBox()


static void _init_f_checkBox_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QCheckBox * > ();
}

static void _call_f_checkBox_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCheckBox * > ((QCheckBox *)((QMessageBox *)cls)->checkBox ());
}


// QAbstractButton *QMessageBox::clickedButton()


static void _init_f_clickedButton_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractButton * > ();
}

static void _call_f_clickedButton_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractButton * > ((QAbstractButton *)((QMessageBox *)cls)->clickedButton ());
}


// QPushButton *QMessageBox::defaultButton()


static void _init_f_defaultButton_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPushButton * > ();
}

static void _call_f_defaultButton_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPushButton * > ((QPushButton *)((QMessageBox *)cls)->defaultButton ());
}


// QString QMessageBox::detailedText()


static void _init_f_detailedText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_detailedText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QMessageBox *)cls)->detailedText ());
}


// QAbstractButton *QMessageBox::escapeButton()


static void _init_f_escapeButton_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractButton * > ();
}

static void _call_f_escapeButton_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractButton * > ((QAbstractButton *)((QMessageBox *)cls)->escapeButton ());
}


// QMessageBox::Icon QMessageBox::icon()


static void _init_f_icon_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMessageBox::Icon>::target_type > ();
}

static void _call_f_icon_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMessageBox::Icon>::target_type > ((qt_gsi::Converter<QMessageBox::Icon>::target_type)qt_gsi::CppToQtAdaptor<QMessageBox::Icon>(((QMessageBox *)cls)->icon ()));
}


// QPixmap QMessageBox::iconPixmap()


static void _init_f_iconPixmap_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPixmap > ();
}

static void _call_f_iconPixmap_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPixmap > ((QPixmap)((QMessageBox *)cls)->iconPixmap ());
}


// QString QMessageBox::informativeText()


static void _init_f_informativeText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_informativeText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QMessageBox *)cls)->informativeText ());
}


// void QMessageBox::open()


static void _init_f_open_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_open_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->open ();
}


// void QMessageBox::open(QObject *receiver, const char *member)


static void _init_f_open_2925 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("member");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_open_2925 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->open (arg1, arg2);
}


// void QMessageBox::removeButton(QAbstractButton *button)


static void _init_f_removeButton_2159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeButton_2159 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractButton *arg1 = gsi::arg_reader<QAbstractButton * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->removeButton (arg1);
}


// void QMessageBox::setButtonText(int button, const QString &text)


static void _init_f_setButtonText_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setButtonText_2684 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->setButtonText (arg1, arg2);
}


// void QMessageBox::setCheckBox(QCheckBox *cb)


static void _init_f_setCheckBox_1478 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cb");
  decl->add_arg<QCheckBox * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCheckBox_1478 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCheckBox *arg1 = gsi::arg_reader<QCheckBox * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->setCheckBox (arg1);
}


// void QMessageBox::setDefaultButton(QPushButton *button)


static void _init_f_setDefaultButton_1755 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QPushButton * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultButton_1755 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPushButton *arg1 = gsi::arg_reader<QPushButton * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->setDefaultButton (arg1);
}


// void QMessageBox::setDefaultButton(QMessageBox::StandardButton button)


static void _init_f_setDefaultButton_3092 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultButton_3092 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->setDefaultButton (qt_gsi::QtToCppAdaptor<QMessageBox::StandardButton>(arg1).cref());
}


// void QMessageBox::setDetailedText(const QString &text)


static void _init_f_setDetailedText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDetailedText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->setDetailedText (arg1);
}


// void QMessageBox::setEscapeButton(QAbstractButton *button)


static void _init_f_setEscapeButton_2159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEscapeButton_2159 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractButton *arg1 = gsi::arg_reader<QAbstractButton * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->setEscapeButton (arg1);
}


// void QMessageBox::setEscapeButton(QMessageBox::StandardButton button)


static void _init_f_setEscapeButton_3092 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEscapeButton_3092 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->setEscapeButton (qt_gsi::QtToCppAdaptor<QMessageBox::StandardButton>(arg1).cref());
}


// void QMessageBox::setIcon(QMessageBox::Icon)


static void _init_f_setIcon_2032 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::Icon>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIcon_2032 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMessageBox::Icon>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMessageBox::Icon>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->setIcon (qt_gsi::QtToCppAdaptor<QMessageBox::Icon>(arg1).cref());
}


// void QMessageBox::setIconPixmap(const QPixmap &pixmap)


static void _init_f_setIconPixmap_2017 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIconPixmap_2017 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPixmap &arg1 = gsi::arg_reader<const QPixmap & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->setIconPixmap (arg1);
}


// void QMessageBox::setInformativeText(const QString &text)


static void _init_f_setInformativeText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInformativeText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->setInformativeText (arg1);
}


// void QMessageBox::setStandardButtons(QFlags<QMessageBox::StandardButton> buttons)


static void _init_f_setStandardButtons_3788 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("buttons");
  decl->add_arg<QFlags<QMessageBox::StandardButton> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStandardButtons_3788 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QMessageBox::StandardButton> arg1 = gsi::arg_reader<QFlags<QMessageBox::StandardButton> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->setStandardButtons (arg1);
}


// void QMessageBox::setText(const QString &text)


static void _init_f_setText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->setText (arg1);
}


// void QMessageBox::setTextFormat(Qt::TextFormat format)


static void _init_f_setTextFormat_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<Qt::TextFormat>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextFormat_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::TextFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::TextFormat>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->setTextFormat (qt_gsi::QtToCppAdaptor<Qt::TextFormat>(arg1).cref());
}


// void QMessageBox::setTextInteractionFlags(QFlags<Qt::TextInteractionFlag> flags)


static void _init_f_setTextInteractionFlags_3396 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<Qt::TextInteractionFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextInteractionFlags_3396 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::TextInteractionFlag> arg1 = gsi::arg_reader<QFlags<Qt::TextInteractionFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->setTextInteractionFlags (arg1);
}


// void QMessageBox::setWindowModality(Qt::WindowModality windowModality)


static void _init_f_setWindowModality_2216 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("windowModality");
  decl->add_arg<const qt_gsi::Converter<Qt::WindowModality>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowModality_2216 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::WindowModality>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::WindowModality>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->setWindowModality (qt_gsi::QtToCppAdaptor<Qt::WindowModality>(arg1).cref());
}


// void QMessageBox::setWindowTitle(const QString &title)


static void _init_f_setWindowTitle_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowTitle_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox *)cls)->setWindowTitle (arg1);
}


// QMessageBox::StandardButton QMessageBox::standardButton(QAbstractButton *button)


static void _init_f_standardButton_c2159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  decl->set_return<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ();
}

static void _call_f_standardButton_c2159 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractButton *arg1 = gsi::arg_reader<QAbstractButton * >() (args, heap);
  ret.write<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ((qt_gsi::Converter<QMessageBox::StandardButton>::target_type)qt_gsi::CppToQtAdaptor<QMessageBox::StandardButton>(((QMessageBox *)cls)->standardButton (arg1)));
}


// QFlags<QMessageBox::StandardButton> QMessageBox::standardButtons()


static void _init_f_standardButtons_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QMessageBox::StandardButton> > ();
}

static void _call_f_standardButtons_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QMessageBox::StandardButton> > ((QFlags<QMessageBox::StandardButton>)((QMessageBox *)cls)->standardButtons ());
}


// QString QMessageBox::text()


static void _init_f_text_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_text_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QMessageBox *)cls)->text ());
}


// Qt::TextFormat QMessageBox::textFormat()


static void _init_f_textFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::TextFormat>::target_type > ();
}

static void _call_f_textFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::TextFormat>::target_type > ((qt_gsi::Converter<Qt::TextFormat>::target_type)qt_gsi::CppToQtAdaptor<Qt::TextFormat>(((QMessageBox *)cls)->textFormat ()));
}


// QFlags<Qt::TextInteractionFlag> QMessageBox::textInteractionFlags()


static void _init_f_textInteractionFlags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::TextInteractionFlag> > ();
}

static void _call_f_textInteractionFlags_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::TextInteractionFlag> > ((QFlags<Qt::TextInteractionFlag>)((QMessageBox *)cls)->textInteractionFlags ());
}


// static void QMessageBox::about(QWidget *parent, const QString &title, const QString &text)


static void _init_f_about_5149 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_about_5149 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QMessageBox::about (arg1, arg2, arg3);
}


// static void QMessageBox::aboutQt(QWidget *parent, const QString &title)


static void _init_f_aboutQt_3232 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_aboutQt_3232 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QMessageBox::aboutQt (arg1, arg2);
}


// static QMessageBox::StandardButton QMessageBox::critical(QWidget *parent, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QMessageBox::StandardButton defaultButton)


static void _init_f_critical_11813 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("buttons", true, "QMessageBox::Ok");
  decl->add_arg<QFlags<QMessageBox::StandardButton> > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("defaultButton", true, "QMessageBox::NoButton");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > (argspec_4);
  decl->set_return<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ();
}

static void _call_f_critical_11813 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  QFlags<QMessageBox::StandardButton> arg4 = args ? gsi::arg_reader<QFlags<QMessageBox::StandardButton> >() (args, heap) : gsi::arg_maker<QFlags<QMessageBox::StandardButton> >() (QMessageBox::Ok, heap);
  const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & arg5 = args ? gsi::arg_reader<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QMessageBox::StandardButton>(heap, QMessageBox::NoButton), heap);
  ret.write<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ((qt_gsi::Converter<QMessageBox::StandardButton>::target_type)qt_gsi::CppToQtAdaptor<QMessageBox::StandardButton>(QMessageBox::critical (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<QMessageBox::StandardButton>(arg5).cref())));
}


// static QMessageBox::StandardButton QMessageBox::information(QWidget *parent, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QMessageBox::StandardButton defaultButton)


static void _init_f_information_11813 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("buttons", true, "QMessageBox::Ok");
  decl->add_arg<QFlags<QMessageBox::StandardButton> > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("defaultButton", true, "QMessageBox::NoButton");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > (argspec_4);
  decl->set_return<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ();
}

static void _call_f_information_11813 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  QFlags<QMessageBox::StandardButton> arg4 = args ? gsi::arg_reader<QFlags<QMessageBox::StandardButton> >() (args, heap) : gsi::arg_maker<QFlags<QMessageBox::StandardButton> >() (QMessageBox::Ok, heap);
  const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & arg5 = args ? gsi::arg_reader<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QMessageBox::StandardButton>(heap, QMessageBox::NoButton), heap);
  ret.write<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ((qt_gsi::Converter<QMessageBox::StandardButton>::target_type)qt_gsi::CppToQtAdaptor<QMessageBox::StandardButton>(QMessageBox::information (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<QMessageBox::StandardButton>(arg5).cref())));
}


// static QMessageBox::StandardButton QMessageBox::question(QWidget *parent, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QMessageBox::StandardButton defaultButton)


static void _init_f_question_11813 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("buttons", true, "QMessageBox::StandardButtons(QMessageBox::Yes | QMessageBox::No)");
  decl->add_arg<QFlags<QMessageBox::StandardButton> > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("defaultButton", true, "QMessageBox::NoButton");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > (argspec_4);
  decl->set_return<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ();
}

static void _call_f_question_11813 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  QFlags<QMessageBox::StandardButton> arg4 = args ? gsi::arg_reader<QFlags<QMessageBox::StandardButton> >() (args, heap) : gsi::arg_maker<QFlags<QMessageBox::StandardButton> >() (QMessageBox::StandardButtons(QMessageBox::Yes | QMessageBox::No), heap);
  const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & arg5 = args ? gsi::arg_reader<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QMessageBox::StandardButton>(heap, QMessageBox::NoButton), heap);
  ret.write<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ((qt_gsi::Converter<QMessageBox::StandardButton>::target_type)qt_gsi::CppToQtAdaptor<QMessageBox::StandardButton>(QMessageBox::question (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<QMessageBox::StandardButton>(arg5).cref())));
}


// static QString QMessageBox::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMessageBox::tr (arg1, arg2, arg3));
}


// static QString QMessageBox::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMessageBox::trUtf8 (arg1, arg2, arg3));
}


// static QMessageBox::StandardButton QMessageBox::warning(QWidget *parent, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QMessageBox::StandardButton defaultButton)


static void _init_f_warning_11813 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("buttons", true, "QMessageBox::Ok");
  decl->add_arg<QFlags<QMessageBox::StandardButton> > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("defaultButton", true, "QMessageBox::NoButton");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > (argspec_4);
  decl->set_return<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ();
}

static void _call_f_warning_11813 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  QFlags<QMessageBox::StandardButton> arg4 = args ? gsi::arg_reader<QFlags<QMessageBox::StandardButton> >() (args, heap) : gsi::arg_maker<QFlags<QMessageBox::StandardButton> >() (QMessageBox::Ok, heap);
  const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & arg5 = args ? gsi::arg_reader<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QMessageBox::StandardButton>(heap, QMessageBox::NoButton), heap);
  ret.write<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ((qt_gsi::Converter<QMessageBox::StandardButton>::target_type)qt_gsi::CppToQtAdaptor<QMessageBox::StandardButton>(QMessageBox::warning (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<QMessageBox::StandardButton>(arg5).cref())));
}


namespace gsi
{

static gsi::Methods methods_QMessageBox () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addButton", "@brief Method void QMessageBox::addButton(QAbstractButton *button, QMessageBox::ButtonRole role)\n", false, &_init_f_addButton_4728, &_call_f_addButton_4728);
  methods += new qt_gsi::GenericMethod ("addButton", "@brief Method QPushButton *QMessageBox::addButton(const QString &text, QMessageBox::ButtonRole role)\n", false, &_init_f_addButton_4594, &_call_f_addButton_4594);
  methods += new qt_gsi::GenericMethod ("addButton", "@brief Method QPushButton *QMessageBox::addButton(QMessageBox::StandardButton button)\n", false, &_init_f_addButton_3092, &_call_f_addButton_3092);
  methods += new qt_gsi::GenericMethod ("button", "@brief Method QAbstractButton *QMessageBox::button(QMessageBox::StandardButton which)\n", true, &_init_f_button_c3092, &_call_f_button_c3092);
  methods += new qt_gsi::GenericMethod ("buttonRole", "@brief Method QMessageBox::ButtonRole QMessageBox::buttonRole(QAbstractButton *button)\n", true, &_init_f_buttonRole_c2159, &_call_f_buttonRole_c2159);
  methods += new qt_gsi::GenericMethod ("buttonText", "@brief Method QString QMessageBox::buttonText(int button)\n", true, &_init_f_buttonText_c767, &_call_f_buttonText_c767);
  methods += new qt_gsi::GenericMethod ("buttons", "@brief Method QList<QAbstractButton *> QMessageBox::buttons()\n", true, &_init_f_buttons_c0, &_call_f_buttons_c0);
  methods += new qt_gsi::GenericMethod (":checkBox", "@brief Method QCheckBox *QMessageBox::checkBox()\n", true, &_init_f_checkBox_c0, &_call_f_checkBox_c0);
  methods += new qt_gsi::GenericMethod ("clickedButton", "@brief Method QAbstractButton *QMessageBox::clickedButton()\n", true, &_init_f_clickedButton_c0, &_call_f_clickedButton_c0);
  methods += new qt_gsi::GenericMethod (":defaultButton", "@brief Method QPushButton *QMessageBox::defaultButton()\n", true, &_init_f_defaultButton_c0, &_call_f_defaultButton_c0);
  methods += new qt_gsi::GenericMethod (":detailedText", "@brief Method QString QMessageBox::detailedText()\n", true, &_init_f_detailedText_c0, &_call_f_detailedText_c0);
  methods += new qt_gsi::GenericMethod (":escapeButton", "@brief Method QAbstractButton *QMessageBox::escapeButton()\n", true, &_init_f_escapeButton_c0, &_call_f_escapeButton_c0);
  methods += new qt_gsi::GenericMethod (":icon", "@brief Method QMessageBox::Icon QMessageBox::icon()\n", true, &_init_f_icon_c0, &_call_f_icon_c0);
  methods += new qt_gsi::GenericMethod (":iconPixmap", "@brief Method QPixmap QMessageBox::iconPixmap()\n", true, &_init_f_iconPixmap_c0, &_call_f_iconPixmap_c0);
  methods += new qt_gsi::GenericMethod (":informativeText", "@brief Method QString QMessageBox::informativeText()\n", true, &_init_f_informativeText_c0, &_call_f_informativeText_c0);
  methods += new qt_gsi::GenericMethod ("open", "@brief Method void QMessageBox::open()\nThis is a reimplementation of QDialog::open", false, &_init_f_open_0, &_call_f_open_0);
  methods += new qt_gsi::GenericMethod ("open", "@brief Method void QMessageBox::open(QObject *receiver, const char *member)\n", false, &_init_f_open_2925, &_call_f_open_2925);
  methods += new qt_gsi::GenericMethod ("removeButton", "@brief Method void QMessageBox::removeButton(QAbstractButton *button)\n", false, &_init_f_removeButton_2159, &_call_f_removeButton_2159);
  methods += new qt_gsi::GenericMethod ("setButtonText", "@brief Method void QMessageBox::setButtonText(int button, const QString &text)\n", false, &_init_f_setButtonText_2684, &_call_f_setButtonText_2684);
  methods += new qt_gsi::GenericMethod ("setCheckBox|checkBox=", "@brief Method void QMessageBox::setCheckBox(QCheckBox *cb)\n", false, &_init_f_setCheckBox_1478, &_call_f_setCheckBox_1478);
  methods += new qt_gsi::GenericMethod ("setDefaultButton|defaultButton=", "@brief Method void QMessageBox::setDefaultButton(QPushButton *button)\n", false, &_init_f_setDefaultButton_1755, &_call_f_setDefaultButton_1755);
  methods += new qt_gsi::GenericMethod ("setDefaultButton|defaultButton=", "@brief Method void QMessageBox::setDefaultButton(QMessageBox::StandardButton button)\n", false, &_init_f_setDefaultButton_3092, &_call_f_setDefaultButton_3092);
  methods += new qt_gsi::GenericMethod ("setDetailedText|detailedText=", "@brief Method void QMessageBox::setDetailedText(const QString &text)\n", false, &_init_f_setDetailedText_2025, &_call_f_setDetailedText_2025);
  methods += new qt_gsi::GenericMethod ("setEscapeButton|escapeButton=", "@brief Method void QMessageBox::setEscapeButton(QAbstractButton *button)\n", false, &_init_f_setEscapeButton_2159, &_call_f_setEscapeButton_2159);
  methods += new qt_gsi::GenericMethod ("setEscapeButton|escapeButton=", "@brief Method void QMessageBox::setEscapeButton(QMessageBox::StandardButton button)\n", false, &_init_f_setEscapeButton_3092, &_call_f_setEscapeButton_3092);
  methods += new qt_gsi::GenericMethod ("setIcon|icon=", "@brief Method void QMessageBox::setIcon(QMessageBox::Icon)\n", false, &_init_f_setIcon_2032, &_call_f_setIcon_2032);
  methods += new qt_gsi::GenericMethod ("setIconPixmap|iconPixmap=", "@brief Method void QMessageBox::setIconPixmap(const QPixmap &pixmap)\n", false, &_init_f_setIconPixmap_2017, &_call_f_setIconPixmap_2017);
  methods += new qt_gsi::GenericMethod ("setInformativeText|informativeText=", "@brief Method void QMessageBox::setInformativeText(const QString &text)\n", false, &_init_f_setInformativeText_2025, &_call_f_setInformativeText_2025);
  methods += new qt_gsi::GenericMethod ("setStandardButtons|standardButtons=", "@brief Method void QMessageBox::setStandardButtons(QFlags<QMessageBox::StandardButton> buttons)\n", false, &_init_f_setStandardButtons_3788, &_call_f_setStandardButtons_3788);
  methods += new qt_gsi::GenericMethod ("setText|text=", "@brief Method void QMessageBox::setText(const QString &text)\n", false, &_init_f_setText_2025, &_call_f_setText_2025);
  methods += new qt_gsi::GenericMethod ("setTextFormat|textFormat=", "@brief Method void QMessageBox::setTextFormat(Qt::TextFormat format)\n", false, &_init_f_setTextFormat_1787, &_call_f_setTextFormat_1787);
  methods += new qt_gsi::GenericMethod ("setTextInteractionFlags|textInteractionFlags=", "@brief Method void QMessageBox::setTextInteractionFlags(QFlags<Qt::TextInteractionFlag> flags)\n", false, &_init_f_setTextInteractionFlags_3396, &_call_f_setTextInteractionFlags_3396);
  methods += new qt_gsi::GenericMethod ("setWindowModality|windowModality=", "@brief Method void QMessageBox::setWindowModality(Qt::WindowModality windowModality)\n", false, &_init_f_setWindowModality_2216, &_call_f_setWindowModality_2216);
  methods += new qt_gsi::GenericMethod ("setWindowTitle|windowTitle=", "@brief Method void QMessageBox::setWindowTitle(const QString &title)\n", false, &_init_f_setWindowTitle_2025, &_call_f_setWindowTitle_2025);
  methods += new qt_gsi::GenericMethod ("standardButton", "@brief Method QMessageBox::StandardButton QMessageBox::standardButton(QAbstractButton *button)\n", true, &_init_f_standardButton_c2159, &_call_f_standardButton_c2159);
  methods += new qt_gsi::GenericMethod (":standardButtons", "@brief Method QFlags<QMessageBox::StandardButton> QMessageBox::standardButtons()\n", true, &_init_f_standardButtons_c0, &_call_f_standardButtons_c0);
  methods += new qt_gsi::GenericMethod (":text", "@brief Method QString QMessageBox::text()\n", true, &_init_f_text_c0, &_call_f_text_c0);
  methods += new qt_gsi::GenericMethod (":textFormat", "@brief Method Qt::TextFormat QMessageBox::textFormat()\n", true, &_init_f_textFormat_c0, &_call_f_textFormat_c0);
  methods += new qt_gsi::GenericMethod (":textInteractionFlags", "@brief Method QFlags<Qt::TextInteractionFlag> QMessageBox::textInteractionFlags()\n", true, &_init_f_textInteractionFlags_c0, &_call_f_textInteractionFlags_c0);
  methods += gsi::qt_signal ("accepted()", "accepted", "@brief Signal declaration for QMessageBox::accepted()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QAbstractButton * > ("buttonClicked(QAbstractButton *)", "buttonClicked", gsi::arg("button"), "@brief Signal declaration for QMessageBox::buttonClicked(QAbstractButton *button)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QMessageBox::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QMessageBox::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("finished(int)", "finished", gsi::arg("result"), "@brief Signal declaration for QMessageBox::finished(int result)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QMessageBox::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("rejected()", "rejected", "@brief Signal declaration for QMessageBox::rejected()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QMessageBox::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QMessageBox::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QMessageBox::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("about", "@brief Static method void QMessageBox::about(QWidget *parent, const QString &title, const QString &text)\nThis method is static and can be called without an instance.", &_init_f_about_5149, &_call_f_about_5149);
  methods += new qt_gsi::GenericStaticMethod ("aboutQt", "@brief Static method void QMessageBox::aboutQt(QWidget *parent, const QString &title)\nThis method is static and can be called without an instance.", &_init_f_aboutQt_3232, &_call_f_aboutQt_3232);
  methods += new qt_gsi::GenericStaticMethod ("critical", "@brief Static method QMessageBox::StandardButton QMessageBox::critical(QWidget *parent, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QMessageBox::StandardButton defaultButton)\nThis method is static and can be called without an instance.", &_init_f_critical_11813, &_call_f_critical_11813);
  methods += new qt_gsi::GenericStaticMethod ("information", "@brief Static method QMessageBox::StandardButton QMessageBox::information(QWidget *parent, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QMessageBox::StandardButton defaultButton)\nThis method is static and can be called without an instance.", &_init_f_information_11813, &_call_f_information_11813);
  methods += new qt_gsi::GenericStaticMethod ("question", "@brief Static method QMessageBox::StandardButton QMessageBox::question(QWidget *parent, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QMessageBox::StandardButton defaultButton)\nThis method is static and can be called without an instance.", &_init_f_question_11813, &_call_f_question_11813);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMessageBox::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMessageBox::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  methods += new qt_gsi::GenericStaticMethod ("warning", "@brief Static method QMessageBox::StandardButton QMessageBox::warning(QWidget *parent, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QMessageBox::StandardButton defaultButton)\nThis method is static and can be called without an instance.", &_init_f_warning_11813, &_call_f_warning_11813);
  return methods;
}

gsi::Class<QDialog> &qtdecl_QDialog ();

qt_gsi::QtNativeClass<QMessageBox> decl_QMessageBox (qtdecl_QDialog (), "QtWidgets", "QMessageBox_Native",
  methods_QMessageBox (),
  "@hide\n@alias QMessageBox");

GSI_QTWIDGETS_PUBLIC gsi::Class<QMessageBox> &qtdecl_QMessageBox () { return decl_QMessageBox; }

}


class QMessageBox_Adaptor : public QMessageBox, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMessageBox_Adaptor();

  //  [adaptor ctor] QMessageBox::QMessageBox(QWidget *parent)
  QMessageBox_Adaptor() : QMessageBox()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMessageBox::QMessageBox(QWidget *parent)
  QMessageBox_Adaptor(QWidget *parent) : QMessageBox(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMessageBox::QMessageBox(QMessageBox::Icon icon, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QWidget *parent, QFlags<Qt::WindowType> flags)
  QMessageBox_Adaptor(QMessageBox::Icon icon, const QString &title, const QString &text) : QMessageBox(icon, title, text)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMessageBox::QMessageBox(QMessageBox::Icon icon, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QWidget *parent, QFlags<Qt::WindowType> flags)
  QMessageBox_Adaptor(QMessageBox::Icon icon, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons) : QMessageBox(icon, title, text, buttons)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMessageBox::QMessageBox(QMessageBox::Icon icon, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QWidget *parent, QFlags<Qt::WindowType> flags)
  QMessageBox_Adaptor(QMessageBox::Icon icon, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QWidget *parent) : QMessageBox(icon, title, text, buttons, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMessageBox::QMessageBox(QMessageBox::Icon icon, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QWidget *parent, QFlags<Qt::WindowType> flags)
  QMessageBox_Adaptor(QMessageBox::Icon icon, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QWidget *parent, QFlags<Qt::WindowType> flags) : QMessageBox(icon, title, text, buttons, parent, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMessageBox::QMessageBox(const QString &title, const QString &text, QMessageBox::Icon icon, int button0, int button1, int button2, QWidget *parent, QFlags<Qt::WindowType> f)
  QMessageBox_Adaptor(const QString &title, const QString &text, QMessageBox::Icon icon, int button0, int button1, int button2) : QMessageBox(title, text, icon, button0, button1, button2)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMessageBox::QMessageBox(const QString &title, const QString &text, QMessageBox::Icon icon, int button0, int button1, int button2, QWidget *parent, QFlags<Qt::WindowType> f)
  QMessageBox_Adaptor(const QString &title, const QString &text, QMessageBox::Icon icon, int button0, int button1, int button2, QWidget *parent) : QMessageBox(title, text, icon, button0, button1, button2, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMessageBox::QMessageBox(const QString &title, const QString &text, QMessageBox::Icon icon, int button0, int button1, int button2, QWidget *parent, QFlags<Qt::WindowType> f)
  QMessageBox_Adaptor(const QString &title, const QString &text, QMessageBox::Icon icon, int button0, int button1, int button2, QWidget *parent, QFlags<Qt::WindowType> f) : QMessageBox(title, text, icon, button0, button1, button2, parent, f)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QMessageBox::adjustPosition(QWidget *)
  void fp_QMessageBox_adjustPosition_1315 (QWidget *arg1) {
    QMessageBox::adjustPosition(arg1);
  }

  //  [expose] void QMessageBox::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QMessageBox_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QMessageBox::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QMessageBox::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QMessageBox_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QMessageBox::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] bool QMessageBox::focusNextChild()
  bool fp_QMessageBox_focusNextChild_0 () {
    return QMessageBox::focusNextChild();
  }

  //  [expose] bool QMessageBox::focusPreviousChild()
  bool fp_QMessageBox_focusPreviousChild_0 () {
    return QMessageBox::focusPreviousChild();
  }

  //  [expose] bool QMessageBox::isSignalConnected(const QMetaMethod &signal)
  bool fp_QMessageBox_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QMessageBox::isSignalConnected(signal);
  }

  //  [expose] int QMessageBox::receivers(const char *signal)
  int fp_QMessageBox_receivers_c1731 (const char *signal) const {
    return QMessageBox::receivers(signal);
  }

  //  [expose] QObject *QMessageBox::sender()
  QObject * fp_QMessageBox_sender_c0 () const {
    return QMessageBox::sender();
  }

  //  [expose] int QMessageBox::senderSignalIndex()
  int fp_QMessageBox_senderSignalIndex_c0 () const {
    return QMessageBox::senderSignalIndex();
  }

  //  [expose] void QMessageBox::updateMicroFocus()
  void fp_QMessageBox_updateMicroFocus_0 () {
    QMessageBox::updateMicroFocus();
  }

  //  [adaptor impl] void QMessageBox::accept()
  void cbs_accept_0_0()
  {
    QMessageBox::accept();
  }

  virtual void accept()
  {
    if (cb_accept_0_0.can_issue()) {
      cb_accept_0_0.issue<QMessageBox_Adaptor>(&QMessageBox_Adaptor::cbs_accept_0_0);
    } else {
      QMessageBox::accept();
    }
  }

  //  [emitter impl] void QMessageBox::accepted()
  void emitter_QMessageBox_accepted_0()
  {
    emit QMessageBox::accepted();
  }

  //  [emitter impl] void QMessageBox::buttonClicked(QAbstractButton *button)
  void emitter_QMessageBox_buttonClicked_2159(QAbstractButton *button)
  {
    emit QMessageBox::buttonClicked(button);
  }

  //  [emitter impl] void QMessageBox::customContextMenuRequested(const QPoint &pos)
  void emitter_QMessageBox_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QMessageBox::customContextMenuRequested(pos);
  }

  //  [emitter impl] void QMessageBox::destroyed(QObject *)
  void emitter_QMessageBox_destroyed_1302(QObject *arg1)
  {
    emit QMessageBox::destroyed(arg1);
  }

  //  [adaptor impl] void QMessageBox::done(int)
  void cbs_done_767_0(int arg1)
  {
    QMessageBox::done(arg1);
  }

  virtual void done(int arg1)
  {
    if (cb_done_767_0.can_issue()) {
      cb_done_767_0.issue<QMessageBox_Adaptor, int>(&QMessageBox_Adaptor::cbs_done_767_0, arg1);
    } else {
      QMessageBox::done(arg1);
    }
  }

  //  [adaptor impl] int QMessageBox::exec()
  int cbs_exec_0_0()
  {
    return QMessageBox::exec();
  }

  virtual int exec()
  {
    if (cb_exec_0_0.can_issue()) {
      return cb_exec_0_0.issue<QMessageBox_Adaptor, int>(&QMessageBox_Adaptor::cbs_exec_0_0);
    } else {
      return QMessageBox::exec();
    }
  }

  //  [emitter impl] void QMessageBox::finished(int result)
  void emitter_QMessageBox_finished_767(int result)
  {
    emit QMessageBox::finished(result);
  }

  //  [adaptor impl] bool QMessageBox::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QMessageBox::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QMessageBox_Adaptor, bool>(&QMessageBox_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QMessageBox::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QMessageBox::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QMessageBox::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QMessageBox_Adaptor, int, int>(&QMessageBox_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QMessageBox::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QMessageBox::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QMessageBox::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QMessageBox_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QMessageBox_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QMessageBox::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QMessageBox::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QMessageBox::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QMessageBox_Adaptor, QSize>(&QMessageBox_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QMessageBox::minimumSizeHint();
    }
  }

  //  [emitter impl] void QMessageBox::objectNameChanged(const QString &objectName)
  void emitter_QMessageBox_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QMessageBox::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QMessageBox::open()
  void cbs_open_0_0()
  {
    QMessageBox::open();
  }

  virtual void open()
  {
    if (cb_open_0_0.can_issue()) {
      cb_open_0_0.issue<QMessageBox_Adaptor>(&QMessageBox_Adaptor::cbs_open_0_0);
    } else {
      QMessageBox::open();
    }
  }

  //  [adaptor impl] QPaintEngine *QMessageBox::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QMessageBox::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QMessageBox_Adaptor, QPaintEngine *>(&QMessageBox_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QMessageBox::paintEngine();
    }
  }

  //  [adaptor impl] void QMessageBox::reject()
  void cbs_reject_0_0()
  {
    QMessageBox::reject();
  }

  virtual void reject()
  {
    if (cb_reject_0_0.can_issue()) {
      cb_reject_0_0.issue<QMessageBox_Adaptor>(&QMessageBox_Adaptor::cbs_reject_0_0);
    } else {
      QMessageBox::reject();
    }
  }

  //  [emitter impl] void QMessageBox::rejected()
  void emitter_QMessageBox_rejected_0()
  {
    emit QMessageBox::rejected();
  }

  //  [adaptor impl] void QMessageBox::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QMessageBox::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QMessageBox_Adaptor, bool>(&QMessageBox_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QMessageBox::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QMessageBox::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QMessageBox::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QMessageBox_Adaptor, QSize>(&QMessageBox_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QMessageBox::sizeHint();
    }
  }

  //  [emitter impl] void QMessageBox::windowIconChanged(const QIcon &icon)
  void emitter_QMessageBox_windowIconChanged_1787(const QIcon &icon)
  {
    emit QMessageBox::windowIconChanged(icon);
  }

  //  [emitter impl] void QMessageBox::windowIconTextChanged(const QString &iconText)
  void emitter_QMessageBox_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QMessageBox::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QMessageBox::windowTitleChanged(const QString &title)
  void emitter_QMessageBox_windowTitleChanged_2025(const QString &title)
  {
    emit QMessageBox::windowTitleChanged(title);
  }

  //  [adaptor impl] void QMessageBox::actionEvent(QActionEvent *event)
  void cbs_actionEvent_1823_0(QActionEvent *event)
  {
    QMessageBox::actionEvent(event);
  }

  virtual void actionEvent(QActionEvent *event)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QMessageBox_Adaptor, QActionEvent *>(&QMessageBox_Adaptor::cbs_actionEvent_1823_0, event);
    } else {
      QMessageBox::actionEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::changeEvent(QEvent *event)
  void cbs_changeEvent_1217_0(QEvent *event)
  {
    QMessageBox::changeEvent(event);
  }

  virtual void changeEvent(QEvent *event)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QMessageBox_Adaptor, QEvent *>(&QMessageBox_Adaptor::cbs_changeEvent_1217_0, event);
    } else {
      QMessageBox::changeEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QMessageBox::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMessageBox_Adaptor, QChildEvent *>(&QMessageBox_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QMessageBox::childEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::closeEvent(QCloseEvent *event)
  void cbs_closeEvent_1719_0(QCloseEvent *event)
  {
    QMessageBox::closeEvent(event);
  }

  virtual void closeEvent(QCloseEvent *event)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QMessageBox_Adaptor, QCloseEvent *>(&QMessageBox_Adaptor::cbs_closeEvent_1719_0, event);
    } else {
      QMessageBox::closeEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QMessageBox::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QMessageBox_Adaptor, QContextMenuEvent *>(&QMessageBox_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QMessageBox::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QMessageBox::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMessageBox_Adaptor, QEvent *>(&QMessageBox_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QMessageBox::customEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QMessageBox::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QMessageBox_Adaptor, const QMetaMethod &>(&QMessageBox_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QMessageBox::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMessageBox::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QMessageBox::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QMessageBox_Adaptor, QDragEnterEvent *>(&QMessageBox_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QMessageBox::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::dragLeaveEvent(QDragLeaveEvent *event)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *event)
  {
    QMessageBox::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *event)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QMessageBox_Adaptor, QDragLeaveEvent *>(&QMessageBox_Adaptor::cbs_dragLeaveEvent_2092_0, event);
    } else {
      QMessageBox::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::dragMoveEvent(QDragMoveEvent *event)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *event)
  {
    QMessageBox::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QDragMoveEvent *event)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QMessageBox_Adaptor, QDragMoveEvent *>(&QMessageBox_Adaptor::cbs_dragMoveEvent_2006_0, event);
    } else {
      QMessageBox::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QMessageBox::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QMessageBox_Adaptor, QDropEvent *>(&QMessageBox_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QMessageBox::dropEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::enterEvent(QEvent *event)
  void cbs_enterEvent_1217_0(QEvent *event)
  {
    QMessageBox::enterEvent(event);
  }

  virtual void enterEvent(QEvent *event)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QMessageBox_Adaptor, QEvent *>(&QMessageBox_Adaptor::cbs_enterEvent_1217_0, event);
    } else {
      QMessageBox::enterEvent(event);
    }
  }

  //  [adaptor impl] bool QMessageBox::event(QEvent *e)
  bool cbs_event_1217_0(QEvent *e)
  {
    return QMessageBox::event(e);
  }

  virtual bool event(QEvent *e)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMessageBox_Adaptor, bool, QEvent *>(&QMessageBox_Adaptor::cbs_event_1217_0, e);
    } else {
      return QMessageBox::event(e);
    }
  }

  //  [adaptor impl] bool QMessageBox::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QMessageBox::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMessageBox_Adaptor, bool, QObject *, QEvent *>(&QMessageBox_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QMessageBox::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QMessageBox::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QMessageBox::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QMessageBox_Adaptor, QFocusEvent *>(&QMessageBox_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QMessageBox::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QMessageBox::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QMessageBox::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QMessageBox_Adaptor, bool, bool>(&QMessageBox_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QMessageBox::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QMessageBox::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QMessageBox::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QMessageBox_Adaptor, QFocusEvent *>(&QMessageBox_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QMessageBox::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::hideEvent(QHideEvent *event)
  void cbs_hideEvent_1595_0(QHideEvent *event)
  {
    QMessageBox::hideEvent(event);
  }

  virtual void hideEvent(QHideEvent *event)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QMessageBox_Adaptor, QHideEvent *>(&QMessageBox_Adaptor::cbs_hideEvent_1595_0, event);
    } else {
      QMessageBox::hideEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QMessageBox::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QMessageBox_Adaptor, QPainter *>(&QMessageBox_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QMessageBox::initPainter(painter);
    }
  }

  //  [adaptor impl] void QMessageBox::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QMessageBox::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QMessageBox_Adaptor, QInputMethodEvent *>(&QMessageBox_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QMessageBox::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QMessageBox::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QMessageBox_Adaptor, QKeyEvent *>(&QMessageBox_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QMessageBox::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QMessageBox::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QMessageBox_Adaptor, QKeyEvent *>(&QMessageBox_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QMessageBox::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::leaveEvent(QEvent *event)
  void cbs_leaveEvent_1217_0(QEvent *event)
  {
    QMessageBox::leaveEvent(event);
  }

  virtual void leaveEvent(QEvent *event)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QMessageBox_Adaptor, QEvent *>(&QMessageBox_Adaptor::cbs_leaveEvent_1217_0, event);
    } else {
      QMessageBox::leaveEvent(event);
    }
  }

  //  [adaptor impl] int QMessageBox::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QMessageBox::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QMessageBox_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QMessageBox_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QMessageBox::metric(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QMessageBox::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QMessageBox_Adaptor, QMouseEvent *>(&QMessageBox_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QMessageBox::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::mouseMoveEvent(QMouseEvent *event)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *event)
  {
    QMessageBox::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QMouseEvent *event)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QMessageBox_Adaptor, QMouseEvent *>(&QMessageBox_Adaptor::cbs_mouseMoveEvent_1738_0, event);
    } else {
      QMessageBox::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::mousePressEvent(QMouseEvent *event)
  void cbs_mousePressEvent_1738_0(QMouseEvent *event)
  {
    QMessageBox::mousePressEvent(event);
  }

  virtual void mousePressEvent(QMouseEvent *event)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QMessageBox_Adaptor, QMouseEvent *>(&QMessageBox_Adaptor::cbs_mousePressEvent_1738_0, event);
    } else {
      QMessageBox::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::mouseReleaseEvent(QMouseEvent *event)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *event)
  {
    QMessageBox::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QMessageBox_Adaptor, QMouseEvent *>(&QMessageBox_Adaptor::cbs_mouseReleaseEvent_1738_0, event);
    } else {
      QMessageBox::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::moveEvent(QMoveEvent *event)
  void cbs_moveEvent_1624_0(QMoveEvent *event)
  {
    QMessageBox::moveEvent(event);
  }

  virtual void moveEvent(QMoveEvent *event)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QMessageBox_Adaptor, QMoveEvent *>(&QMessageBox_Adaptor::cbs_moveEvent_1624_0, event);
    } else {
      QMessageBox::moveEvent(event);
    }
  }

  //  [adaptor impl] bool QMessageBox::nativeEvent(const QByteArray &eventType, void *message, long int *result)
  bool cbs_nativeEvent_4678_0(const QByteArray &eventType, void *message, long int *result)
  {
    return QMessageBox::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, long int *result)
  {
    if (cb_nativeEvent_4678_0.can_issue()) {
      return cb_nativeEvent_4678_0.issue<QMessageBox_Adaptor, bool, const QByteArray &, void *, long int *>(&QMessageBox_Adaptor::cbs_nativeEvent_4678_0, eventType, message, result);
    } else {
      return QMessageBox::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QMessageBox::paintEvent(QPaintEvent *event)
  void cbs_paintEvent_1725_0(QPaintEvent *event)
  {
    QMessageBox::paintEvent(event);
  }

  virtual void paintEvent(QPaintEvent *event)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QMessageBox_Adaptor, QPaintEvent *>(&QMessageBox_Adaptor::cbs_paintEvent_1725_0, event);
    } else {
      QMessageBox::paintEvent(event);
    }
  }

  //  [adaptor impl] QPaintDevice *QMessageBox::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QMessageBox::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QMessageBox_Adaptor, QPaintDevice *, QPoint *>(&QMessageBox_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QMessageBox::redirected(offset);
    }
  }

  //  [adaptor impl] void QMessageBox::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QMessageBox::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QMessageBox_Adaptor, QResizeEvent *>(&QMessageBox_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QMessageBox::resizeEvent(event);
    }
  }

  //  [adaptor impl] QPainter *QMessageBox::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QMessageBox::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QMessageBox_Adaptor, QPainter *>(&QMessageBox_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QMessageBox::sharedPainter();
    }
  }

  //  [adaptor impl] void QMessageBox::showEvent(QShowEvent *event)
  void cbs_showEvent_1634_0(QShowEvent *event)
  {
    QMessageBox::showEvent(event);
  }

  virtual void showEvent(QShowEvent *event)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QMessageBox_Adaptor, QShowEvent *>(&QMessageBox_Adaptor::cbs_showEvent_1634_0, event);
    } else {
      QMessageBox::showEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::tabletEvent(QTabletEvent *event)
  void cbs_tabletEvent_1821_0(QTabletEvent *event)
  {
    QMessageBox::tabletEvent(event);
  }

  virtual void tabletEvent(QTabletEvent *event)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QMessageBox_Adaptor, QTabletEvent *>(&QMessageBox_Adaptor::cbs_tabletEvent_1821_0, event);
    } else {
      QMessageBox::tabletEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QMessageBox::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMessageBox_Adaptor, QTimerEvent *>(&QMessageBox_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QMessageBox::timerEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::wheelEvent(QWheelEvent *event)
  void cbs_wheelEvent_1718_0(QWheelEvent *event)
  {
    QMessageBox::wheelEvent(event);
  }

  virtual void wheelEvent(QWheelEvent *event)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QMessageBox_Adaptor, QWheelEvent *>(&QMessageBox_Adaptor::cbs_wheelEvent_1718_0, event);
    } else {
      QMessageBox::wheelEvent(event);
    }
  }

  gsi::Callback cb_accept_0_0;
  gsi::Callback cb_done_767_0;
  gsi::Callback cb_exec_0_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_open_0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reject_0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_4678_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QMessageBox_Adaptor::~QMessageBox_Adaptor() { }

//  Constructor QMessageBox::QMessageBox(QWidget *parent) (adaptor class)

static void _init_ctor_QMessageBox_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QMessageBox_Adaptor> ();
}

static void _call_ctor_QMessageBox_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  ret.write<QMessageBox_Adaptor *> (new QMessageBox_Adaptor (arg1));
}


//  Constructor QMessageBox::QMessageBox(QMessageBox::Icon icon, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QWidget *parent, QFlags<Qt::WindowType> flags) (adaptor class)

static void _init_ctor_QMessageBox_Adaptor_13140 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::Icon>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("buttons", true, "QMessageBox::NoButton");
  decl->add_arg<QFlags<QMessageBox::StandardButton> > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("flags", true, "Qt::Dialog | Qt::MSWindowsFixedSizeDialogHint");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_5);
  decl->set_return_new<QMessageBox_Adaptor> ();
}

static void _call_ctor_QMessageBox_Adaptor_13140 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMessageBox::Icon>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMessageBox::Icon>::target_type & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  QFlags<QMessageBox::StandardButton> arg4 = args ? gsi::arg_reader<QFlags<QMessageBox::StandardButton> >() (args, heap) : gsi::arg_maker<QFlags<QMessageBox::StandardButton> >() (QMessageBox::NoButton, heap);
  QWidget *arg5 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  QFlags<Qt::WindowType> arg6 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (Qt::Dialog | Qt::MSWindowsFixedSizeDialogHint, heap);
  ret.write<QMessageBox_Adaptor *> (new QMessageBox_Adaptor (qt_gsi::QtToCppAdaptor<QMessageBox::Icon>(arg1).cref(), arg2, arg3, arg4, arg5, arg6));
}


//  Constructor QMessageBox::QMessageBox(const QString &title, const QString &text, QMessageBox::Icon icon, int button0, int button1, int button2, QWidget *parent, QFlags<Qt::WindowType> f) (adaptor class)

static void _init_ctor_QMessageBox_Adaptor_11437 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("icon");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::Icon>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("button0");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("button1");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("button2");
  decl->add_arg<int > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("f", true, "Qt::Dialog | Qt::MSWindowsFixedSizeDialogHint");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_7);
  decl->set_return_new<QMessageBox_Adaptor> ();
}

static void _call_ctor_QMessageBox_Adaptor_11437 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QMessageBox::Icon>::target_type & arg3 = gsi::arg_reader<const qt_gsi::Converter<QMessageBox::Icon>::target_type & >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  int arg6 = gsi::arg_reader<int >() (args, heap);
  QWidget *arg7 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  QFlags<Qt::WindowType> arg8 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (Qt::Dialog | Qt::MSWindowsFixedSizeDialogHint, heap);
  ret.write<QMessageBox_Adaptor *> (new QMessageBox_Adaptor (arg1, arg2, qt_gsi::QtToCppAdaptor<QMessageBox::Icon>(arg3).cref(), arg4, arg5, arg6, arg7, arg8));
}


// void QMessageBox::accept()

static void _init_cbs_accept_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_accept_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_accept_0_0 ();
}

static void _set_callback_cbs_accept_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_accept_0_0 = cb;
}


// emitter void QMessageBox::accepted()

static void _init_emitter_accepted_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_accepted_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMessageBox_Adaptor *)cls)->emitter_QMessageBox_accepted_0 ();
}


// void QMessageBox::actionEvent(QActionEvent *event)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// exposed void QMessageBox::adjustPosition(QWidget *)

static void _init_fp_adjustPosition_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_adjustPosition_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->fp_QMessageBox_adjustPosition_1315 (arg1);
}


// emitter void QMessageBox::buttonClicked(QAbstractButton *button)

static void _init_emitter_buttonClicked_2159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_buttonClicked_2159 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractButton *arg1 = gsi::arg_reader<QAbstractButton * >() (args, heap);
  ((QMessageBox_Adaptor *)cls)->emitter_QMessageBox_buttonClicked_2159 (arg1);
}


// void QMessageBox::changeEvent(QEvent *event)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QMessageBox::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QMessageBox::closeEvent(QCloseEvent *event)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QMessageBox::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QMessageBox::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->fp_QMessageBox_create_2208 (arg1, arg2, arg3);
}


// emitter void QMessageBox::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QMessageBox_Adaptor *)cls)->emitter_QMessageBox_customContextMenuRequested_1916 (arg1);
}


// void QMessageBox::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QMessageBox::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->fp_QMessageBox_destroy_1620 (arg1, arg2);
}


// emitter void QMessageBox::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QMessageBox_Adaptor *)cls)->emitter_QMessageBox_destroyed_1302 (arg1);
}


// void QMessageBox::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QMessageBox::done(int)

static void _init_cbs_done_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_done_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_done_767_0 (arg1);
}

static void _set_callback_cbs_done_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_done_767_0 = cb;
}


// void QMessageBox::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QMessageBox::dragLeaveEvent(QDragLeaveEvent *event)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QMessageBox::dragMoveEvent(QDragMoveEvent *event)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QMessageBox::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QMessageBox::enterEvent(QEvent *event)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}


// bool QMessageBox::event(QEvent *e)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMessageBox_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QMessageBox::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMessageBox_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// int QMessageBox::exec()

static void _init_cbs_exec_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_exec_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMessageBox_Adaptor *)cls)->cbs_exec_0_0 ());
}

static void _set_callback_cbs_exec_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_exec_0_0 = cb;
}


// emitter void QMessageBox::finished(int result)

static void _init_emitter_finished_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("result");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_finished_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QMessageBox_Adaptor *)cls)->emitter_QMessageBox_finished_767 (arg1);
}


// void QMessageBox::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QMessageBox::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMessageBox_Adaptor *)cls)->fp_QMessageBox_focusNextChild_0 ());
}


// bool QMessageBox::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QMessageBox_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QMessageBox::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QMessageBox::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMessageBox_Adaptor *)cls)->fp_QMessageBox_focusPreviousChild_0 ());
}


// bool QMessageBox::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMessageBox_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QMessageBox::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QMessageBox_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QMessageBox::hideEvent(QHideEvent *event)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QMessageBox::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// void QMessageBox::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QMessageBox::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QMessageBox_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// exposed bool QMessageBox::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QMessageBox_Adaptor *)cls)->fp_QMessageBox_isSignalConnected_c2394 (arg1));
}


// void QMessageBox::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QMessageBox::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QMessageBox::leaveEvent(QEvent *event)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QMessageBox::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QMessageBox_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QMessageBox::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QMessageBox_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QMessageBox::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QMessageBox::mouseMoveEvent(QMouseEvent *event)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QMessageBox::mousePressEvent(QMouseEvent *event)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QMessageBox::mouseReleaseEvent(QMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QMessageBox::moveEvent(QMoveEvent *event)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QMessageBox::nativeEvent(const QByteArray &eventType, void *message, long int *result)

static void _init_cbs_nativeEvent_4678_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<long int * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_4678_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  long int *arg3 = args.read<long int * > (heap);
  ret.write<bool > ((bool)((QMessageBox_Adaptor *)cls)->cbs_nativeEvent_4678_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_4678_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_nativeEvent_4678_0 = cb;
}


// emitter void QMessageBox::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMessageBox_Adaptor *)cls)->emitter_QMessageBox_objectNameChanged_4567 (arg1);
}


// void QMessageBox::open()

static void _init_cbs_open_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_open_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_open_0_0 ();
}

static void _set_callback_cbs_open_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_open_0_0 = cb;
}


// QPaintEngine *QMessageBox::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QMessageBox_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QMessageBox::paintEvent(QPaintEvent *event)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QMessageBox::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QMessageBox_Adaptor *)cls)->fp_QMessageBox_receivers_c1731 (arg1));
}


// QPaintDevice *QMessageBox::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QMessageBox_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// void QMessageBox::reject()

static void _init_cbs_reject_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reject_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_reject_0_0 ();
}

static void _set_callback_cbs_reject_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_reject_0_0 = cb;
}


// emitter void QMessageBox::rejected()

static void _init_emitter_rejected_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_rejected_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMessageBox_Adaptor *)cls)->emitter_QMessageBox_rejected_0 ();
}


// void QMessageBox::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed QObject *QMessageBox::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMessageBox_Adaptor *)cls)->fp_QMessageBox_sender_c0 ());
}


// exposed int QMessageBox::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMessageBox_Adaptor *)cls)->fp_QMessageBox_senderSignalIndex_c0 ());
}


// void QMessageBox::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// QPainter *QMessageBox::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QMessageBox_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QMessageBox::showEvent(QShowEvent *event)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QMessageBox::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QMessageBox_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QMessageBox::tabletEvent(QTabletEvent *event)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QMessageBox::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QMessageBox::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->fp_QMessageBox_updateMicroFocus_0 ();
}


// void QMessageBox::wheelEvent(QWheelEvent *event)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMessageBox_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QMessageBox::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  ((QMessageBox_Adaptor *)cls)->emitter_QMessageBox_windowIconChanged_1787 (arg1);
}


// emitter void QMessageBox::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMessageBox_Adaptor *)cls)->emitter_QMessageBox_windowIconTextChanged_2025 (arg1);
}


// emitter void QMessageBox::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMessageBox_Adaptor *)cls)->emitter_QMessageBox_windowTitleChanged_2025 (arg1);
}


namespace gsi
{

gsi::Class<QMessageBox> &qtdecl_QMessageBox ();

static gsi::Methods methods_QMessageBox_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMessageBox::QMessageBox(QWidget *parent)\nThis method creates an object of class QMessageBox.", &_init_ctor_QMessageBox_Adaptor_1315, &_call_ctor_QMessageBox_Adaptor_1315);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMessageBox::QMessageBox(QMessageBox::Icon icon, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QWidget *parent, QFlags<Qt::WindowType> flags)\nThis method creates an object of class QMessageBox.", &_init_ctor_QMessageBox_Adaptor_13140, &_call_ctor_QMessageBox_Adaptor_13140);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMessageBox::QMessageBox(const QString &title, const QString &text, QMessageBox::Icon icon, int button0, int button1, int button2, QWidget *parent, QFlags<Qt::WindowType> f)\nThis method creates an object of class QMessageBox.", &_init_ctor_QMessageBox_Adaptor_11437, &_call_ctor_QMessageBox_Adaptor_11437);
  methods += new qt_gsi::GenericMethod ("accept", "@brief Virtual method void QMessageBox::accept()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0);
  methods += new qt_gsi::GenericMethod ("accept", "@hide", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0, &_set_callback_cbs_accept_0_0);
  methods += new qt_gsi::GenericMethod ("emit_accepted", "@brief Emitter for signal void QMessageBox::accepted()\nCall this method to emit this signal.", false, &_init_emitter_accepted_0, &_call_emitter_accepted_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QMessageBox::actionEvent(QActionEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*adjustPosition", "@brief Method void QMessageBox::adjustPosition(QWidget *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_adjustPosition_1315, &_call_fp_adjustPosition_1315);
  methods += new qt_gsi::GenericMethod ("emit_buttonClicked", "@brief Emitter for signal void QMessageBox::buttonClicked(QAbstractButton *button)\nCall this method to emit this signal.", false, &_init_emitter_buttonClicked_2159, &_call_emitter_buttonClicked_2159);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QMessageBox::changeEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMessageBox::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QMessageBox::closeEvent(QCloseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QMessageBox::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*create|qt_create", "@brief Method void QMessageBox::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QMessageBox::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMessageBox::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*destroy|qt_destroy", "@brief Method void QMessageBox::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QMessageBox::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMessageBox::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("done", "@brief Virtual method void QMessageBox::done(int)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0);
  methods += new qt_gsi::GenericMethod ("done", "@hide", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0, &_set_callback_cbs_done_767_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QMessageBox::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QMessageBox::dragLeaveEvent(QDragLeaveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QMessageBox::dragMoveEvent(QDragMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QMessageBox::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QMessageBox::enterEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QMessageBox::event(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QMessageBox::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("exec", "@brief Virtual method int QMessageBox::exec()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_exec_0_0, &_call_cbs_exec_0_0);
  methods += new qt_gsi::GenericMethod ("exec", "@hide", false, &_init_cbs_exec_0_0, &_call_cbs_exec_0_0, &_set_callback_cbs_exec_0_0);
  methods += new qt_gsi::GenericMethod ("emit_finished", "@brief Emitter for signal void QMessageBox::finished(int result)\nCall this method to emit this signal.", false, &_init_emitter_finished_767, &_call_emitter_finished_767);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QMessageBox::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QMessageBox::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QMessageBox::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QMessageBox::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QMessageBox::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QMessageBox::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QMessageBox::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QMessageBox::hideEvent(QHideEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QMessageBox::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QMessageBox::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QMessageBox::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QMessageBox::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QMessageBox::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QMessageBox::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QMessageBox::leaveEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QMessageBox::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QMessageBox::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QMessageBox::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QMessageBox::mouseMoveEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QMessageBox::mousePressEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QMessageBox::mouseReleaseEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QMessageBox::moveEvent(QMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QMessageBox::nativeEvent(const QByteArray &eventType, void *message, long int *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0, &_set_callback_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QMessageBox::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("open", "@brief Virtual method void QMessageBox::open()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_open_0_0, &_call_cbs_open_0_0);
  methods += new qt_gsi::GenericMethod ("open", "@hide", false, &_init_cbs_open_0_0, &_call_cbs_open_0_0, &_set_callback_cbs_open_0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QMessageBox::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QMessageBox::paintEvent(QPaintEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QMessageBox::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QMessageBox::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("reject", "@brief Virtual method void QMessageBox::reject()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0);
  methods += new qt_gsi::GenericMethod ("reject", "@hide", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0, &_set_callback_cbs_reject_0_0);
  methods += new qt_gsi::GenericMethod ("emit_rejected", "@brief Emitter for signal void QMessageBox::rejected()\nCall this method to emit this signal.", false, &_init_emitter_rejected_0, &_call_emitter_rejected_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QMessageBox::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QMessageBox::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QMessageBox::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QMessageBox::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QMessageBox::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QMessageBox::showEvent(QShowEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QMessageBox::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QMessageBox::tabletEvent(QTabletEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMessageBox::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QMessageBox::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QMessageBox::wheelEvent(QWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QMessageBox::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QMessageBox::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QMessageBox::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  return methods;
}

gsi::Class<QMessageBox_Adaptor> decl_QMessageBox_Adaptor (qtdecl_QMessageBox (), "QtWidgets", "QMessageBox",
  methods_QMessageBox_Adaptor (),
  "@qt\n@brief Binding of QMessageBox");

}


//  Implementation of the enum wrapper class for QMessageBox::ButtonRole
namespace qt_gsi
{

static gsi::Enum<QMessageBox::ButtonRole> decl_QMessageBox_ButtonRole_Enum ("QtWidgets", "QMessageBox_ButtonRole",
    gsi::enum_const ("InvalidRole", QMessageBox::InvalidRole, "@brief Enum constant QMessageBox::InvalidRole") +
    gsi::enum_const ("AcceptRole", QMessageBox::AcceptRole, "@brief Enum constant QMessageBox::AcceptRole") +
    gsi::enum_const ("RejectRole", QMessageBox::RejectRole, "@brief Enum constant QMessageBox::RejectRole") +
    gsi::enum_const ("DestructiveRole", QMessageBox::DestructiveRole, "@brief Enum constant QMessageBox::DestructiveRole") +
    gsi::enum_const ("ActionRole", QMessageBox::ActionRole, "@brief Enum constant QMessageBox::ActionRole") +
    gsi::enum_const ("HelpRole", QMessageBox::HelpRole, "@brief Enum constant QMessageBox::HelpRole") +
    gsi::enum_const ("YesRole", QMessageBox::YesRole, "@brief Enum constant QMessageBox::YesRole") +
    gsi::enum_const ("NoRole", QMessageBox::NoRole, "@brief Enum constant QMessageBox::NoRole") +
    gsi::enum_const ("ResetRole", QMessageBox::ResetRole, "@brief Enum constant QMessageBox::ResetRole") +
    gsi::enum_const ("ApplyRole", QMessageBox::ApplyRole, "@brief Enum constant QMessageBox::ApplyRole") +
    gsi::enum_const ("NRoles", QMessageBox::NRoles, "@brief Enum constant QMessageBox::NRoles"),
  "@qt\n@brief This class represents the QMessageBox::ButtonRole enum");

static gsi::QFlagsClass<QMessageBox::ButtonRole > decl_QMessageBox_ButtonRole_Enums ("QtWidgets", "QMessageBox_QFlags_ButtonRole",
  "@qt\n@brief This class represents the QFlags<QMessageBox::ButtonRole> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMessageBox> inject_QMessageBox_ButtonRole_Enum_in_parent (decl_QMessageBox_ButtonRole_Enum.defs ());
static gsi::ClassExt<QMessageBox> decl_QMessageBox_ButtonRole_Enum_as_child (decl_QMessageBox_ButtonRole_Enum, "ButtonRole");
static gsi::ClassExt<QMessageBox> decl_QMessageBox_ButtonRole_Enums_as_child (decl_QMessageBox_ButtonRole_Enums, "QFlags_ButtonRole");

}


//  Implementation of the enum wrapper class for QMessageBox::Icon
namespace qt_gsi
{

static gsi::Enum<QMessageBox::Icon> decl_QMessageBox_Icon_Enum ("QtWidgets", "QMessageBox_Icon",
    gsi::enum_const ("NoIcon", QMessageBox::NoIcon, "@brief Enum constant QMessageBox::NoIcon") +
    gsi::enum_const ("Information", QMessageBox::Information, "@brief Enum constant QMessageBox::Information") +
    gsi::enum_const ("Warning", QMessageBox::Warning, "@brief Enum constant QMessageBox::Warning") +
    gsi::enum_const ("Critical", QMessageBox::Critical, "@brief Enum constant QMessageBox::Critical") +
    gsi::enum_const ("Question", QMessageBox::Question, "@brief Enum constant QMessageBox::Question"),
  "@qt\n@brief This class represents the QMessageBox::Icon enum");

static gsi::QFlagsClass<QMessageBox::Icon > decl_QMessageBox_Icon_Enums ("QtWidgets", "QMessageBox_QFlags_Icon",
  "@qt\n@brief This class represents the QFlags<QMessageBox::Icon> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMessageBox> inject_QMessageBox_Icon_Enum_in_parent (decl_QMessageBox_Icon_Enum.defs ());
static gsi::ClassExt<QMessageBox> decl_QMessageBox_Icon_Enum_as_child (decl_QMessageBox_Icon_Enum, "Icon");
static gsi::ClassExt<QMessageBox> decl_QMessageBox_Icon_Enums_as_child (decl_QMessageBox_Icon_Enums, "QFlags_Icon");

}


//  Implementation of the enum wrapper class for QMessageBox::StandardButton
namespace qt_gsi
{

static gsi::Enum<QMessageBox::StandardButton> decl_QMessageBox_StandardButton_Enum ("QtWidgets", "QMessageBox_StandardButton",
    gsi::enum_const ("NoButton", QMessageBox::NoButton, "@brief Enum constant QMessageBox::NoButton") +
    gsi::enum_const ("Ok", QMessageBox::Ok, "@brief Enum constant QMessageBox::Ok") +
    gsi::enum_const ("Save", QMessageBox::Save, "@brief Enum constant QMessageBox::Save") +
    gsi::enum_const ("SaveAll", QMessageBox::SaveAll, "@brief Enum constant QMessageBox::SaveAll") +
    gsi::enum_const ("Open", QMessageBox::Open, "@brief Enum constant QMessageBox::Open") +
    gsi::enum_const ("Yes", QMessageBox::Yes, "@brief Enum constant QMessageBox::Yes") +
    gsi::enum_const ("YesToAll", QMessageBox::YesToAll, "@brief Enum constant QMessageBox::YesToAll") +
    gsi::enum_const ("No", QMessageBox::No, "@brief Enum constant QMessageBox::No") +
    gsi::enum_const ("NoToAll", QMessageBox::NoToAll, "@brief Enum constant QMessageBox::NoToAll") +
    gsi::enum_const ("Abort", QMessageBox::Abort, "@brief Enum constant QMessageBox::Abort") +
    gsi::enum_const ("Retry", QMessageBox::Retry, "@brief Enum constant QMessageBox::Retry") +
    gsi::enum_const ("Ignore", QMessageBox::Ignore, "@brief Enum constant QMessageBox::Ignore") +
    gsi::enum_const ("Close", QMessageBox::Close, "@brief Enum constant QMessageBox::Close") +
    gsi::enum_const ("Cancel", QMessageBox::Cancel, "@brief Enum constant QMessageBox::Cancel") +
    gsi::enum_const ("Discard", QMessageBox::Discard, "@brief Enum constant QMessageBox::Discard") +
    gsi::enum_const ("Help", QMessageBox::Help, "@brief Enum constant QMessageBox::Help") +
    gsi::enum_const ("Apply", QMessageBox::Apply, "@brief Enum constant QMessageBox::Apply") +
    gsi::enum_const ("Reset", QMessageBox::Reset, "@brief Enum constant QMessageBox::Reset") +
    gsi::enum_const ("RestoreDefaults", QMessageBox::RestoreDefaults, "@brief Enum constant QMessageBox::RestoreDefaults") +
    gsi::enum_const ("FirstButton", QMessageBox::FirstButton, "@brief Enum constant QMessageBox::FirstButton") +
    gsi::enum_const ("LastButton", QMessageBox::LastButton, "@brief Enum constant QMessageBox::LastButton") +
    gsi::enum_const ("YesAll", QMessageBox::YesAll, "@brief Enum constant QMessageBox::YesAll") +
    gsi::enum_const ("NoAll", QMessageBox::NoAll, "@brief Enum constant QMessageBox::NoAll") +
    gsi::enum_const ("Default", QMessageBox::Default, "@brief Enum constant QMessageBox::Default") +
    gsi::enum_const ("Escape", QMessageBox::Escape, "@brief Enum constant QMessageBox::Escape") +
    gsi::enum_const ("FlagMask", QMessageBox::FlagMask, "@brief Enum constant QMessageBox::FlagMask") +
    gsi::enum_const ("ButtonMask", QMessageBox::ButtonMask, "@brief Enum constant QMessageBox::ButtonMask"),
  "@qt\n@brief This class represents the QMessageBox::StandardButton enum");

static gsi::QFlagsClass<QMessageBox::StandardButton > decl_QMessageBox_StandardButton_Enums ("QtWidgets", "QMessageBox_QFlags_StandardButton",
  "@qt\n@brief This class represents the QFlags<QMessageBox::StandardButton> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMessageBox> inject_QMessageBox_StandardButton_Enum_in_parent (decl_QMessageBox_StandardButton_Enum.defs ());
static gsi::ClassExt<QMessageBox> decl_QMessageBox_StandardButton_Enum_as_child (decl_QMessageBox_StandardButton_Enum, "StandardButton");
static gsi::ClassExt<QMessageBox> decl_QMessageBox_StandardButton_Enums_as_child (decl_QMessageBox_StandardButton_Enums, "QFlags_StandardButton");

}

