
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGridLayout.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QGridLayout>
#include <QChildEvent>
#include <QEvent>
#include <QLayout>
#include <QLayoutItem>
#include <QMargins>
#include <QMetaMethod>
#include <QObject>
#include <QRect>
#include <QSize>
#include <QSpacerItem>
#include <QThread>
#include <QTimerEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGridLayout

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGridLayout::staticMetaObject);
}


// void QGridLayout::addItem(QLayoutItem *item, int row, int column, int rowSpan, int columnSpan, QFlags<Qt::AlignmentFlag>)


static void _init_f_addItem_7018 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QLayoutItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("row");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("column");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("rowSpan", true, "1");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("columnSpan", true, "1");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("arg6", true, "Qt::Alignment()");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_addItem_7018 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayoutItem *arg1 = gsi::arg_reader<QLayoutItem * >() (args, heap);
  qt_gsi::qt_keep (arg1);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (1, heap);
  int arg5 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (1, heap);
  QFlags<Qt::AlignmentFlag> arg6 = args ? gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::AlignmentFlag> >() (Qt::Alignment(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout *)cls)->addItem (arg1, arg2, arg3, arg4, arg5, arg6);
}


// void QGridLayout::addLayout(QLayout *, int row, int column, QFlags<Qt::AlignmentFlag>)


static void _init_f_addLayout_5301 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QLayout * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("row");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("column");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("arg4", true, "Qt::Alignment()");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_addLayout_5301 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayout *arg1 = gsi::arg_reader<QLayout * >() (args, heap);
  qt_gsi::qt_keep (arg1);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  QFlags<Qt::AlignmentFlag> arg4 = args ? gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::AlignmentFlag> >() (Qt::Alignment(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout *)cls)->addLayout (arg1, arg2, arg3, arg4);
}


// void QGridLayout::addLayout(QLayout *, int row, int column, int rowSpan, int columnSpan, QFlags<Qt::AlignmentFlag>)


static void _init_f_addLayout_6619 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QLayout * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("row");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("column");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("rowSpan");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("columnSpan");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("arg6", true, "Qt::Alignment()");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_addLayout_6619 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayout *arg1 = gsi::arg_reader<QLayout * >() (args, heap);
  qt_gsi::qt_keep (arg1);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  QFlags<Qt::AlignmentFlag> arg6 = args ? gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::AlignmentFlag> >() (Qt::Alignment(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout *)cls)->addLayout (arg1, arg2, arg3, arg4, arg5, arg6);
}


// void QGridLayout::addWidget(QWidget *w)


static void _init_f_addWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addWidget_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  qt_gsi::qt_keep (arg1);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout *)cls)->addWidget (arg1);
}


// void QGridLayout::addWidget(QWidget *, int row, int column, QFlags<Qt::AlignmentFlag>)


static void _init_f_addWidget_5275 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("row");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("column");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("arg4", true, "Qt::Alignment()");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_addWidget_5275 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  qt_gsi::qt_keep (arg1);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  QFlags<Qt::AlignmentFlag> arg4 = args ? gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::AlignmentFlag> >() (Qt::Alignment(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout *)cls)->addWidget (arg1, arg2, arg3, arg4);
}


// void QGridLayout::addWidget(QWidget *, int row, int column, int rowSpan, int columnSpan, QFlags<Qt::AlignmentFlag>)


static void _init_f_addWidget_6593 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("row");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("column");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("rowSpan");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("columnSpan");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("arg6", true, "Qt::Alignment()");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_addWidget_6593 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  qt_gsi::qt_keep (arg1);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  QFlags<Qt::AlignmentFlag> arg6 = args ? gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::AlignmentFlag> >() (Qt::Alignment(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout *)cls)->addWidget (arg1, arg2, arg3, arg4, arg5, arg6);
}


// QRect QGridLayout::cellRect(int row, int column)


static void _init_f_cellRect_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QRect > ();
}

static void _call_f_cellRect_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QRect > ((QRect)((QGridLayout *)cls)->cellRect (arg1, arg2));
}


// int QGridLayout::columnCount()


static void _init_f_columnCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_columnCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGridLayout *)cls)->columnCount ());
}


// int QGridLayout::columnMinimumWidth(int column)


static void _init_f_columnMinimumWidth_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_columnMinimumWidth_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QGridLayout *)cls)->columnMinimumWidth (arg1));
}


// int QGridLayout::columnStretch(int column)


static void _init_f_columnStretch_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_columnStretch_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QGridLayout *)cls)->columnStretch (arg1));
}


// int QGridLayout::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGridLayout *)cls)->count ());
}


// QFlags<Qt::Orientation> QGridLayout::expandingDirections()


static void _init_f_expandingDirections_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::Orientation> > ();
}

static void _call_f_expandingDirections_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::Orientation> > ((QFlags<Qt::Orientation>)((QGridLayout *)cls)->expandingDirections ());
}


// void QGridLayout::getItemPosition(int idx, int *row, int *column, int *rowSpan, int *columnSpan)


static void _init_f_getItemPosition_c4147 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("idx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("row");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("column");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("rowSpan");
  decl->add_arg<int * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("columnSpan");
  decl->add_arg<int * > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_getItemPosition_c4147 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int *arg2 = gsi::arg_reader<int * >() (args, heap);
  int *arg3 = gsi::arg_reader<int * >() (args, heap);
  int *arg4 = gsi::arg_reader<int * >() (args, heap);
  int *arg5 = gsi::arg_reader<int * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout *)cls)->getItemPosition (arg1, arg2, arg3, arg4, arg5);
}


// bool QGridLayout::hasHeightForWidth()


static void _init_f_hasHeightForWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasHeightForWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGridLayout *)cls)->hasHeightForWidth ());
}


// int QGridLayout::heightForWidth(int)


static void _init_f_heightForWidth_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_heightForWidth_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QGridLayout *)cls)->heightForWidth (arg1));
}


// int QGridLayout::horizontalSpacing()


static void _init_f_horizontalSpacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_horizontalSpacing_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGridLayout *)cls)->horizontalSpacing ());
}


// void QGridLayout::invalidate()


static void _init_f_invalidate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_invalidate_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout *)cls)->invalidate ();
}


// QLayoutItem *QGridLayout::itemAt(int index)


static void _init_f_itemAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_f_itemAt_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QLayoutItem * > ((QLayoutItem *)((QGridLayout *)cls)->itemAt (arg1));
}


// QLayoutItem *QGridLayout::itemAtPosition(int row, int column)


static void _init_f_itemAtPosition_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QLayoutItem * > ();
}

static void _call_f_itemAtPosition_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QLayoutItem * > ((QLayoutItem *)((QGridLayout *)cls)->itemAtPosition (arg1, arg2));
}


// QSize QGridLayout::maximumSize()


static void _init_f_maximumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_maximumSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QGridLayout *)cls)->maximumSize ());
}


// int QGridLayout::minimumHeightForWidth(int)


static void _init_f_minimumHeightForWidth_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_minimumHeightForWidth_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QGridLayout *)cls)->minimumHeightForWidth (arg1));
}


// QSize QGridLayout::minimumSize()


static void _init_f_minimumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QGridLayout *)cls)->minimumSize ());
}


// Qt::Corner QGridLayout::originCorner()


static void _init_f_originCorner_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::Corner>::target_type > ();
}

static void _call_f_originCorner_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::Corner>::target_type > ((qt_gsi::Converter<Qt::Corner>::target_type)qt_gsi::CppToQtAdaptor<Qt::Corner>(((QGridLayout *)cls)->originCorner ()));
}


// int QGridLayout::rowCount()


static void _init_f_rowCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_rowCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGridLayout *)cls)->rowCount ());
}


// int QGridLayout::rowMinimumHeight(int row)


static void _init_f_rowMinimumHeight_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_rowMinimumHeight_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QGridLayout *)cls)->rowMinimumHeight (arg1));
}


// int QGridLayout::rowStretch(int row)


static void _init_f_rowStretch_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_rowStretch_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QGridLayout *)cls)->rowStretch (arg1));
}


// void QGridLayout::setColumnMinimumWidth(int column, int minSize)


static void _init_f_setColumnMinimumWidth_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("minSize");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setColumnMinimumWidth_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout *)cls)->setColumnMinimumWidth (arg1, arg2);
}


// void QGridLayout::setColumnStretch(int column, int stretch)


static void _init_f_setColumnStretch_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stretch");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setColumnStretch_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout *)cls)->setColumnStretch (arg1, arg2);
}


// void QGridLayout::setDefaultPositioning(int n, Qt::Orientation orient)


static void _init_f_setDefaultPositioning_2572 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("n");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orient");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setDefaultPositioning_2572 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout *)cls)->setDefaultPositioning (arg1, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg2).cref());
}


// void QGridLayout::setGeometry(const QRect &)


static void _init_f_setGeometry_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout *)cls)->setGeometry (arg1);
}


// void QGridLayout::setHorizontalSpacing(int spacing)


static void _init_f_setHorizontalSpacing_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spacing");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHorizontalSpacing_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout *)cls)->setHorizontalSpacing (arg1);
}


// void QGridLayout::setOriginCorner(Qt::Corner)


static void _init_f_setOriginCorner_1366 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::Corner>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOriginCorner_1366 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Corner>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::Corner>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout *)cls)->setOriginCorner (qt_gsi::QtToCppAdaptor<Qt::Corner>(arg1).cref());
}


// void QGridLayout::setRowMinimumHeight(int row, int minSize)


static void _init_f_setRowMinimumHeight_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("minSize");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRowMinimumHeight_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout *)cls)->setRowMinimumHeight (arg1, arg2);
}


// void QGridLayout::setRowStretch(int row, int stretch)


static void _init_f_setRowStretch_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stretch");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRowStretch_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout *)cls)->setRowStretch (arg1, arg2);
}


// void QGridLayout::setSpacing(int spacing)


static void _init_f_setSpacing_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spacing");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSpacing_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout *)cls)->setSpacing (arg1);
}


// void QGridLayout::setVerticalSpacing(int spacing)


static void _init_f_setVerticalSpacing_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spacing");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVerticalSpacing_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout *)cls)->setVerticalSpacing (arg1);
}


// QSize QGridLayout::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QGridLayout *)cls)->sizeHint ());
}


// int QGridLayout::spacing()


static void _init_f_spacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_spacing_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGridLayout *)cls)->spacing ());
}


// QLayoutItem *QGridLayout::takeAt(int index)


static void _init_f_takeAt_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<QLayoutItem * > ();
}

static void _call_f_takeAt_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QLayoutItem * > ((QLayoutItem *)((QGridLayout *)cls)->takeAt (arg1));
}


// int QGridLayout::verticalSpacing()


static void _init_f_verticalSpacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_verticalSpacing_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGridLayout *)cls)->verticalSpacing ());
}


// static QString QGridLayout::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QGridLayout::tr (arg1, arg2, arg3));
}


// static QString QGridLayout::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QGridLayout::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QGridLayout () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addItem", "@brief Method void QGridLayout::addItem(QLayoutItem *item, int row, int column, int rowSpan, int columnSpan, QFlags<Qt::AlignmentFlag>)\n", false, &_init_f_addItem_7018, &_call_f_addItem_7018);
  methods += new qt_gsi::GenericMethod ("addLayout", "@brief Method void QGridLayout::addLayout(QLayout *, int row, int column, QFlags<Qt::AlignmentFlag>)\n", false, &_init_f_addLayout_5301, &_call_f_addLayout_5301);
  methods += new qt_gsi::GenericMethod ("addLayout", "@brief Method void QGridLayout::addLayout(QLayout *, int row, int column, int rowSpan, int columnSpan, QFlags<Qt::AlignmentFlag>)\n", false, &_init_f_addLayout_6619, &_call_f_addLayout_6619);
  methods += new qt_gsi::GenericMethod ("addWidget", "@brief Method void QGridLayout::addWidget(QWidget *w)\n", false, &_init_f_addWidget_1315, &_call_f_addWidget_1315);
  methods += new qt_gsi::GenericMethod ("addWidget", "@brief Method void QGridLayout::addWidget(QWidget *, int row, int column, QFlags<Qt::AlignmentFlag>)\n", false, &_init_f_addWidget_5275, &_call_f_addWidget_5275);
  methods += new qt_gsi::GenericMethod ("addWidget", "@brief Method void QGridLayout::addWidget(QWidget *, int row, int column, int rowSpan, int columnSpan, QFlags<Qt::AlignmentFlag>)\n", false, &_init_f_addWidget_6593, &_call_f_addWidget_6593);
  methods += new qt_gsi::GenericMethod ("cellRect", "@brief Method QRect QGridLayout::cellRect(int row, int column)\n", true, &_init_f_cellRect_c1426, &_call_f_cellRect_c1426);
  methods += new qt_gsi::GenericMethod ("columnCount", "@brief Method int QGridLayout::columnCount()\n", true, &_init_f_columnCount_c0, &_call_f_columnCount_c0);
  methods += new qt_gsi::GenericMethod ("columnMinimumWidth", "@brief Method int QGridLayout::columnMinimumWidth(int column)\n", true, &_init_f_columnMinimumWidth_c767, &_call_f_columnMinimumWidth_c767);
  methods += new qt_gsi::GenericMethod ("columnStretch", "@brief Method int QGridLayout::columnStretch(int column)\n", true, &_init_f_columnStretch_c767, &_call_f_columnStretch_c767);
  methods += new qt_gsi::GenericMethod ("count", "@brief Method int QGridLayout::count()\nThis is a reimplementation of QLayout::count", true, &_init_f_count_c0, &_call_f_count_c0);
  methods += new qt_gsi::GenericMethod ("expandingDirections", "@brief Method QFlags<Qt::Orientation> QGridLayout::expandingDirections()\nThis is a reimplementation of QLayout::expandingDirections", true, &_init_f_expandingDirections_c0, &_call_f_expandingDirections_c0);
  methods += new qt_gsi::GenericMethod ("getItemPosition", "@brief Method void QGridLayout::getItemPosition(int idx, int *row, int *column, int *rowSpan, int *columnSpan)\n", true, &_init_f_getItemPosition_c4147, &_call_f_getItemPosition_c4147);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Method bool QGridLayout::hasHeightForWidth()\nThis is a reimplementation of QLayoutItem::hasHeightForWidth", true, &_init_f_hasHeightForWidth_c0, &_call_f_hasHeightForWidth_c0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Method int QGridLayout::heightForWidth(int)\nThis is a reimplementation of QLayoutItem::heightForWidth", true, &_init_f_heightForWidth_c767, &_call_f_heightForWidth_c767);
  methods += new qt_gsi::GenericMethod (":horizontalSpacing", "@brief Method int QGridLayout::horizontalSpacing()\n", true, &_init_f_horizontalSpacing_c0, &_call_f_horizontalSpacing_c0);
  methods += new qt_gsi::GenericMethod ("invalidate", "@brief Method void QGridLayout::invalidate()\nThis is a reimplementation of QLayout::invalidate", false, &_init_f_invalidate_0, &_call_f_invalidate_0);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Method QLayoutItem *QGridLayout::itemAt(int index)\nThis is a reimplementation of QLayout::itemAt", true, &_init_f_itemAt_c767, &_call_f_itemAt_c767);
  methods += new qt_gsi::GenericMethod ("itemAtPosition", "@brief Method QLayoutItem *QGridLayout::itemAtPosition(int row, int column)\n", true, &_init_f_itemAtPosition_c1426, &_call_f_itemAtPosition_c1426);
  methods += new qt_gsi::GenericMethod ("maximumSize", "@brief Method QSize QGridLayout::maximumSize()\nThis is a reimplementation of QLayout::maximumSize", true, &_init_f_maximumSize_c0, &_call_f_maximumSize_c0);
  methods += new qt_gsi::GenericMethod ("minimumHeightForWidth", "@brief Method int QGridLayout::minimumHeightForWidth(int)\nThis is a reimplementation of QLayoutItem::minimumHeightForWidth", true, &_init_f_minimumHeightForWidth_c767, &_call_f_minimumHeightForWidth_c767);
  methods += new qt_gsi::GenericMethod ("minimumSize", "@brief Method QSize QGridLayout::minimumSize()\nThis is a reimplementation of QLayout::minimumSize", true, &_init_f_minimumSize_c0, &_call_f_minimumSize_c0);
  methods += new qt_gsi::GenericMethod (":originCorner", "@brief Method Qt::Corner QGridLayout::originCorner()\n", true, &_init_f_originCorner_c0, &_call_f_originCorner_c0);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Method int QGridLayout::rowCount()\n", true, &_init_f_rowCount_c0, &_call_f_rowCount_c0);
  methods += new qt_gsi::GenericMethod ("rowMinimumHeight", "@brief Method int QGridLayout::rowMinimumHeight(int row)\n", true, &_init_f_rowMinimumHeight_c767, &_call_f_rowMinimumHeight_c767);
  methods += new qt_gsi::GenericMethod ("rowStretch", "@brief Method int QGridLayout::rowStretch(int row)\n", true, &_init_f_rowStretch_c767, &_call_f_rowStretch_c767);
  methods += new qt_gsi::GenericMethod ("setColumnMinimumWidth", "@brief Method void QGridLayout::setColumnMinimumWidth(int column, int minSize)\n", false, &_init_f_setColumnMinimumWidth_1426, &_call_f_setColumnMinimumWidth_1426);
  methods += new qt_gsi::GenericMethod ("setColumnStretch", "@brief Method void QGridLayout::setColumnStretch(int column, int stretch)\n", false, &_init_f_setColumnStretch_1426, &_call_f_setColumnStretch_1426);
  methods += new qt_gsi::GenericMethod ("setDefaultPositioning", "@brief Method void QGridLayout::setDefaultPositioning(int n, Qt::Orientation orient)\n", false, &_init_f_setDefaultPositioning_2572, &_call_f_setDefaultPositioning_2572);
  methods += new qt_gsi::GenericMethod ("setGeometry|geometry=", "@brief Method void QGridLayout::setGeometry(const QRect &)\nThis is a reimplementation of QLayout::setGeometry", false, &_init_f_setGeometry_1792, &_call_f_setGeometry_1792);
  methods += new qt_gsi::GenericMethod ("setHorizontalSpacing|horizontalSpacing=", "@brief Method void QGridLayout::setHorizontalSpacing(int spacing)\n", false, &_init_f_setHorizontalSpacing_767, &_call_f_setHorizontalSpacing_767);
  methods += new qt_gsi::GenericMethod ("setOriginCorner|originCorner=", "@brief Method void QGridLayout::setOriginCorner(Qt::Corner)\n", false, &_init_f_setOriginCorner_1366, &_call_f_setOriginCorner_1366);
  methods += new qt_gsi::GenericMethod ("setRowMinimumHeight", "@brief Method void QGridLayout::setRowMinimumHeight(int row, int minSize)\n", false, &_init_f_setRowMinimumHeight_1426, &_call_f_setRowMinimumHeight_1426);
  methods += new qt_gsi::GenericMethod ("setRowStretch", "@brief Method void QGridLayout::setRowStretch(int row, int stretch)\n", false, &_init_f_setRowStretch_1426, &_call_f_setRowStretch_1426);
  methods += new qt_gsi::GenericMethod ("setSpacing|spacing=", "@brief Method void QGridLayout::setSpacing(int spacing)\n", false, &_init_f_setSpacing_767, &_call_f_setSpacing_767);
  methods += new qt_gsi::GenericMethod ("setVerticalSpacing|verticalSpacing=", "@brief Method void QGridLayout::setVerticalSpacing(int spacing)\n", false, &_init_f_setVerticalSpacing_767, &_call_f_setVerticalSpacing_767);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Method QSize QGridLayout::sizeHint()\nThis is a reimplementation of QLayoutItem::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod (":spacing", "@brief Method int QGridLayout::spacing()\n", true, &_init_f_spacing_c0, &_call_f_spacing_c0);
  methods += new qt_gsi::GenericMethod ("takeAt", "@brief Method QLayoutItem *QGridLayout::takeAt(int index)\nThis is a reimplementation of QLayout::takeAt", false, &_init_f_takeAt_767, &_call_f_takeAt_767);
  methods += new qt_gsi::GenericMethod (":verticalSpacing", "@brief Method int QGridLayout::verticalSpacing()\n", true, &_init_f_verticalSpacing_c0, &_call_f_verticalSpacing_c0);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QGridLayout::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QGridLayout::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGridLayout::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGridLayout::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QLayout> &qtdecl_QLayout ();

qt_gsi::QtNativeClass<QGridLayout> decl_QGridLayout (qtdecl_QLayout (), "QtWidgets", "QGridLayout_Native",
  methods_QGridLayout (),
  "@hide\n@alias QGridLayout");

GSI_QTWIDGETS_PUBLIC gsi::Class<QGridLayout> &qtdecl_QGridLayout () { return decl_QGridLayout; }

}


class QGridLayout_Adaptor : public QGridLayout, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGridLayout_Adaptor();

  //  [adaptor ctor] QGridLayout::QGridLayout(QWidget *parent)
  QGridLayout_Adaptor(QWidget *parent) : QGridLayout(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGridLayout::QGridLayout()
  QGridLayout_Adaptor() : QGridLayout()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QGridLayout::addChildLayout(QLayout *l)
  void fp_QGridLayout_addChildLayout_1341 (QLayout *l) {
    QGridLayout::addChildLayout(l);
  }

  //  [expose] void QGridLayout::addChildWidget(QWidget *w)
  void fp_QGridLayout_addChildWidget_1315 (QWidget *w) {
    QGridLayout::addChildWidget(w);
  }

  //  [expose] bool QGridLayout::adoptLayout(QLayout *layout)
  bool fp_QGridLayout_adoptLayout_1341 (QLayout *layout) {
    return QGridLayout::adoptLayout(layout);
  }

  //  [expose] QRect QGridLayout::alignmentRect(const QRect &)
  QRect fp_QGridLayout_alignmentRect_c1792 (const QRect &arg1) const {
    return QGridLayout::alignmentRect(arg1);
  }

  //  [expose] bool QGridLayout::isSignalConnected(const QMetaMethod &signal)
  bool fp_QGridLayout_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QGridLayout::isSignalConnected(signal);
  }

  //  [expose] int QGridLayout::receivers(const char *signal)
  int fp_QGridLayout_receivers_c1731 (const char *signal) const {
    return QGridLayout::receivers(signal);
  }

  //  [expose] QObject *QGridLayout::sender()
  QObject * fp_QGridLayout_sender_c0 () const {
    return QGridLayout::sender();
  }

  //  [expose] int QGridLayout::senderSignalIndex()
  int fp_QGridLayout_senderSignalIndex_c0 () const {
    return QGridLayout::senderSignalIndex();
  }

  //  [expose] void QGridLayout::widgetEvent(QEvent *)
  void fp_QGridLayout_widgetEvent_1217 (QEvent *arg1) {
    QGridLayout::widgetEvent(arg1);
  }

  //  [adaptor impl] QFlags<QSizePolicy::ControlType> QGridLayout::controlTypes()
  QFlags<QSizePolicy::ControlType> cbs_controlTypes_c0_0() const
  {
    return QGridLayout::controlTypes();
  }

  virtual QFlags<QSizePolicy::ControlType> controlTypes() const
  {
    if (cb_controlTypes_c0_0.can_issue()) {
      return cb_controlTypes_c0_0.issue<QGridLayout_Adaptor, QFlags<QSizePolicy::ControlType> >(&QGridLayout_Adaptor::cbs_controlTypes_c0_0);
    } else {
      return QGridLayout::controlTypes();
    }
  }

  //  [adaptor impl] int QGridLayout::count()
  int cbs_count_c0_0() const
  {
    return QGridLayout::count();
  }

  virtual int count() const
  {
    if (cb_count_c0_0.can_issue()) {
      return cb_count_c0_0.issue<QGridLayout_Adaptor, int>(&QGridLayout_Adaptor::cbs_count_c0_0);
    } else {
      return QGridLayout::count();
    }
  }

  //  [emitter impl] void QGridLayout::destroyed(QObject *)
  void emitter_QGridLayout_destroyed_1302(QObject *arg1)
  {
    emit QGridLayout::destroyed(arg1);
  }

  //  [adaptor impl] bool QGridLayout::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QGridLayout::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGridLayout_Adaptor, bool, QEvent *>(&QGridLayout_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QGridLayout::event(_event);
    }
  }

  //  [adaptor impl] bool QGridLayout::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QGridLayout::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGridLayout_Adaptor, bool, QObject *, QEvent *>(&QGridLayout_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QGridLayout::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] QFlags<Qt::Orientation> QGridLayout::expandingDirections()
  QFlags<Qt::Orientation> cbs_expandingDirections_c0_0() const
  {
    return QGridLayout::expandingDirections();
  }

  virtual QFlags<Qt::Orientation> expandingDirections() const
  {
    if (cb_expandingDirections_c0_0.can_issue()) {
      return cb_expandingDirections_c0_0.issue<QGridLayout_Adaptor, QFlags<Qt::Orientation> >(&QGridLayout_Adaptor::cbs_expandingDirections_c0_0);
    } else {
      return QGridLayout::expandingDirections();
    }
  }

  //  [adaptor impl] QRect QGridLayout::geometry()
  QRect cbs_geometry_c0_0() const
  {
    return QGridLayout::geometry();
  }

  virtual QRect geometry() const
  {
    if (cb_geometry_c0_0.can_issue()) {
      return cb_geometry_c0_0.issue<QGridLayout_Adaptor, QRect>(&QGridLayout_Adaptor::cbs_geometry_c0_0);
    } else {
      return QGridLayout::geometry();
    }
  }

  //  [adaptor impl] bool QGridLayout::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QGridLayout::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QGridLayout_Adaptor, bool>(&QGridLayout_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QGridLayout::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QGridLayout::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QGridLayout::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QGridLayout_Adaptor, int, int>(&QGridLayout_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QGridLayout::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] int QGridLayout::indexOf(QWidget *)
  int cbs_indexOf_c1315_0(QWidget *arg1) const
  {
    return QGridLayout::indexOf(arg1);
  }

  virtual int indexOf(QWidget *arg1) const
  {
    if (cb_indexOf_c1315_0.can_issue()) {
      return cb_indexOf_c1315_0.issue<QGridLayout_Adaptor, int, QWidget *>(&QGridLayout_Adaptor::cbs_indexOf_c1315_0, arg1);
    } else {
      return QGridLayout::indexOf(arg1);
    }
  }

  //  [adaptor impl] void QGridLayout::invalidate()
  void cbs_invalidate_0_0()
  {
    QGridLayout::invalidate();
  }

  virtual void invalidate()
  {
    if (cb_invalidate_0_0.can_issue()) {
      cb_invalidate_0_0.issue<QGridLayout_Adaptor>(&QGridLayout_Adaptor::cbs_invalidate_0_0);
    } else {
      QGridLayout::invalidate();
    }
  }

  //  [adaptor impl] bool QGridLayout::isEmpty()
  bool cbs_isEmpty_c0_0() const
  {
    return QGridLayout::isEmpty();
  }

  virtual bool isEmpty() const
  {
    if (cb_isEmpty_c0_0.can_issue()) {
      return cb_isEmpty_c0_0.issue<QGridLayout_Adaptor, bool>(&QGridLayout_Adaptor::cbs_isEmpty_c0_0);
    } else {
      return QGridLayout::isEmpty();
    }
  }

  //  [adaptor impl] QLayoutItem *QGridLayout::itemAt(int index)
  QLayoutItem * cbs_itemAt_c767_0(int index) const
  {
    return QGridLayout::itemAt(index);
  }

  virtual QLayoutItem * itemAt(int index) const
  {
    if (cb_itemAt_c767_0.can_issue()) {
      return cb_itemAt_c767_0.issue<QGridLayout_Adaptor, QLayoutItem *, int>(&QGridLayout_Adaptor::cbs_itemAt_c767_0, index);
    } else {
      return QGridLayout::itemAt(index);
    }
  }

  //  [adaptor impl] QLayout *QGridLayout::layout()
  QLayout * cbs_layout_0_0()
  {
    return QGridLayout::layout();
  }

  virtual QLayout * layout()
  {
    if (cb_layout_0_0.can_issue()) {
      return cb_layout_0_0.issue<QGridLayout_Adaptor, QLayout *>(&QGridLayout_Adaptor::cbs_layout_0_0);
    } else {
      return QGridLayout::layout();
    }
  }

  //  [adaptor impl] QSize QGridLayout::maximumSize()
  QSize cbs_maximumSize_c0_0() const
  {
    return QGridLayout::maximumSize();
  }

  virtual QSize maximumSize() const
  {
    if (cb_maximumSize_c0_0.can_issue()) {
      return cb_maximumSize_c0_0.issue<QGridLayout_Adaptor, QSize>(&QGridLayout_Adaptor::cbs_maximumSize_c0_0);
    } else {
      return QGridLayout::maximumSize();
    }
  }

  //  [adaptor impl] int QGridLayout::minimumHeightForWidth(int)
  int cbs_minimumHeightForWidth_c767_0(int arg1) const
  {
    return QGridLayout::minimumHeightForWidth(arg1);
  }

  virtual int minimumHeightForWidth(int arg1) const
  {
    if (cb_minimumHeightForWidth_c767_0.can_issue()) {
      return cb_minimumHeightForWidth_c767_0.issue<QGridLayout_Adaptor, int, int>(&QGridLayout_Adaptor::cbs_minimumHeightForWidth_c767_0, arg1);
    } else {
      return QGridLayout::minimumHeightForWidth(arg1);
    }
  }

  //  [adaptor impl] QSize QGridLayout::minimumSize()
  QSize cbs_minimumSize_c0_0() const
  {
    return QGridLayout::minimumSize();
  }

  virtual QSize minimumSize() const
  {
    if (cb_minimumSize_c0_0.can_issue()) {
      return cb_minimumSize_c0_0.issue<QGridLayout_Adaptor, QSize>(&QGridLayout_Adaptor::cbs_minimumSize_c0_0);
    } else {
      return QGridLayout::minimumSize();
    }
  }

  //  [emitter impl] void QGridLayout::objectNameChanged(const QString &objectName)
  void emitter_QGridLayout_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QGridLayout::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QGridLayout::setGeometry(const QRect &)
  void cbs_setGeometry_1792_0(const QRect &arg1)
  {
    QGridLayout::setGeometry(arg1);
  }

  virtual void setGeometry(const QRect &arg1)
  {
    if (cb_setGeometry_1792_0.can_issue()) {
      cb_setGeometry_1792_0.issue<QGridLayout_Adaptor, const QRect &>(&QGridLayout_Adaptor::cbs_setGeometry_1792_0, arg1);
    } else {
      QGridLayout::setGeometry(arg1);
    }
  }

  //  [adaptor impl] QSize QGridLayout::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QGridLayout::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QGridLayout_Adaptor, QSize>(&QGridLayout_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QGridLayout::sizeHint();
    }
  }

  //  [adaptor impl] QSpacerItem *QGridLayout::spacerItem()
  QSpacerItem * cbs_spacerItem_0_0()
  {
    return QGridLayout::spacerItem();
  }

  virtual QSpacerItem * spacerItem()
  {
    if (cb_spacerItem_0_0.can_issue()) {
      return cb_spacerItem_0_0.issue<QGridLayout_Adaptor, QSpacerItem *>(&QGridLayout_Adaptor::cbs_spacerItem_0_0);
    } else {
      return QGridLayout::spacerItem();
    }
  }

  //  [adaptor impl] QLayoutItem *QGridLayout::takeAt(int index)
  QLayoutItem * cbs_takeAt_767_0(int index)
  {
    return QGridLayout::takeAt(index);
  }

  virtual QLayoutItem * takeAt(int index)
  {
    if (cb_takeAt_767_0.can_issue()) {
      return cb_takeAt_767_0.issue<QGridLayout_Adaptor, QLayoutItem *, int>(&QGridLayout_Adaptor::cbs_takeAt_767_0, index);
    } else {
      return QGridLayout::takeAt(index);
    }
  }

  //  [adaptor impl] QWidget *QGridLayout::widget()
  QWidget * cbs_widget_0_0()
  {
    return QGridLayout::widget();
  }

  virtual QWidget * widget()
  {
    if (cb_widget_0_0.can_issue()) {
      return cb_widget_0_0.issue<QGridLayout_Adaptor, QWidget *>(&QGridLayout_Adaptor::cbs_widget_0_0);
    } else {
      return QGridLayout::widget();
    }
  }

  //  [adaptor impl] void QGridLayout::addItem(QLayoutItem *)
  void cbs_addItem_1740_0(QLayoutItem *arg1)
  {
    QGridLayout::addItem(arg1);
  }

  virtual void addItem(QLayoutItem *arg1)
  {
    if (cb_addItem_1740_0.can_issue()) {
      cb_addItem_1740_0.issue<QGridLayout_Adaptor, QLayoutItem *>(&QGridLayout_Adaptor::cbs_addItem_1740_0, arg1);
    } else {
      QGridLayout::addItem(arg1);
    }
  }

  //  [adaptor impl] void QGridLayout::childEvent(QChildEvent *e)
  void cbs_childEvent_1701_0(QChildEvent *e)
  {
    QGridLayout::childEvent(e);
  }

  virtual void childEvent(QChildEvent *e)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGridLayout_Adaptor, QChildEvent *>(&QGridLayout_Adaptor::cbs_childEvent_1701_0, e);
    } else {
      QGridLayout::childEvent(e);
    }
  }

  //  [adaptor impl] void QGridLayout::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QGridLayout::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGridLayout_Adaptor, QEvent *>(&QGridLayout_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QGridLayout::customEvent(event);
    }
  }

  //  [adaptor impl] void QGridLayout::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QGridLayout::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QGridLayout_Adaptor, const QMetaMethod &>(&QGridLayout_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QGridLayout::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGridLayout::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QGridLayout::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGridLayout_Adaptor, QTimerEvent *>(&QGridLayout_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QGridLayout::timerEvent(event);
    }
  }

  gsi::Callback cb_controlTypes_c0_0;
  gsi::Callback cb_count_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_expandingDirections_c0_0;
  gsi::Callback cb_geometry_c0_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_indexOf_c1315_0;
  gsi::Callback cb_invalidate_0_0;
  gsi::Callback cb_isEmpty_c0_0;
  gsi::Callback cb_itemAt_c767_0;
  gsi::Callback cb_layout_0_0;
  gsi::Callback cb_maximumSize_c0_0;
  gsi::Callback cb_minimumHeightForWidth_c767_0;
  gsi::Callback cb_minimumSize_c0_0;
  gsi::Callback cb_setGeometry_1792_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_spacerItem_0_0;
  gsi::Callback cb_takeAt_767_0;
  gsi::Callback cb_widget_0_0;
  gsi::Callback cb_addItem_1740_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QGridLayout_Adaptor::~QGridLayout_Adaptor() { }

//  Constructor QGridLayout::QGridLayout(QWidget *parent) (adaptor class)

static void _init_ctor_QGridLayout_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QGridLayout_Adaptor> ();
}

static void _call_ctor_QGridLayout_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  ret.write<QGridLayout_Adaptor *> (new QGridLayout_Adaptor (arg1));
}


//  Constructor QGridLayout::QGridLayout() (adaptor class)

static void _init_ctor_QGridLayout_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QGridLayout_Adaptor> ();
}

static void _call_ctor_QGridLayout_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGridLayout_Adaptor *> (new QGridLayout_Adaptor ());
}


// exposed void QGridLayout::addChildLayout(QLayout *l)

static void _init_fp_addChildLayout_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildLayout_1341 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayout *arg1 = gsi::arg_reader<QLayout * >() (args, heap);
  qt_gsi::qt_keep (arg1);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout_Adaptor *)cls)->fp_QGridLayout_addChildLayout_1341 (arg1);
}


// exposed void QGridLayout::addChildWidget(QWidget *w)

static void _init_fp_addChildWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildWidget_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout_Adaptor *)cls)->fp_QGridLayout_addChildWidget_1315 (arg1);
}


// void QGridLayout::addItem(QLayoutItem *)

static void _init_cbs_addItem_1740_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_addItem_1740_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayoutItem *arg1 = args.read<QLayoutItem * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout_Adaptor *)cls)->cbs_addItem_1740_0 (arg1);
}

static void _set_callback_cbs_addItem_1740_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_addItem_1740_0 = cb;
}


// exposed bool QGridLayout::adoptLayout(QLayout *layout)

static void _init_fp_adoptLayout_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layout");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_adoptLayout_1341 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayout *arg1 = gsi::arg_reader<QLayout * >() (args, heap);
  ret.write<bool > ((bool)((QGridLayout_Adaptor *)cls)->fp_QGridLayout_adoptLayout_1341 (arg1));
}


// exposed QRect QGridLayout::alignmentRect(const QRect &)

static void _init_fp_alignmentRect_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_fp_alignmentRect_c1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  ret.write<QRect > ((QRect)((QGridLayout_Adaptor *)cls)->fp_QGridLayout_alignmentRect_c1792 (arg1));
}


// void QGridLayout::childEvent(QChildEvent *e)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// QFlags<QSizePolicy::ControlType> QGridLayout::controlTypes()

static void _init_cbs_controlTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QSizePolicy::ControlType> > ();
}

static void _call_cbs_controlTypes_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QSizePolicy::ControlType> > ((QFlags<QSizePolicy::ControlType>)((QGridLayout_Adaptor *)cls)->cbs_controlTypes_c0_0 ());
}

static void _set_callback_cbs_controlTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_controlTypes_c0_0 = cb;
}


// int QGridLayout::count()

static void _init_cbs_count_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_count_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGridLayout_Adaptor *)cls)->cbs_count_c0_0 ());
}

static void _set_callback_cbs_count_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_count_c0_0 = cb;
}


// void QGridLayout::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QGridLayout::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QGridLayout_Adaptor *)cls)->emitter_QGridLayout_destroyed_1302 (arg1);
}


// void QGridLayout::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QGridLayout::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGridLayout_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QGridLayout::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGridLayout_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// QFlags<Qt::Orientation> QGridLayout::expandingDirections()

static void _init_cbs_expandingDirections_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::Orientation> > ();
}

static void _call_cbs_expandingDirections_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::Orientation> > ((QFlags<Qt::Orientation>)((QGridLayout_Adaptor *)cls)->cbs_expandingDirections_c0_0 ());
}

static void _set_callback_cbs_expandingDirections_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_expandingDirections_c0_0 = cb;
}


// QRect QGridLayout::geometry()

static void _init_cbs_geometry_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_cbs_geometry_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QGridLayout_Adaptor *)cls)->cbs_geometry_c0_0 ());
}

static void _set_callback_cbs_geometry_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_geometry_c0_0 = cb;
}


// bool QGridLayout::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGridLayout_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QGridLayout::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QGridLayout_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// int QGridLayout::indexOf(QWidget *)

static void _init_cbs_indexOf_c1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_indexOf_c1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  ret.write<int > ((int)((QGridLayout_Adaptor *)cls)->cbs_indexOf_c1315_0 (arg1));
}

static void _set_callback_cbs_indexOf_c1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_indexOf_c1315_0 = cb;
}


// void QGridLayout::invalidate()

static void _init_cbs_invalidate_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_invalidate_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout_Adaptor *)cls)->cbs_invalidate_0_0 ();
}

static void _set_callback_cbs_invalidate_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_invalidate_0_0 = cb;
}


// bool QGridLayout::isEmpty()

static void _init_cbs_isEmpty_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isEmpty_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGridLayout_Adaptor *)cls)->cbs_isEmpty_c0_0 ());
}

static void _set_callback_cbs_isEmpty_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_isEmpty_c0_0 = cb;
}


// exposed bool QGridLayout::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QGridLayout_Adaptor *)cls)->fp_QGridLayout_isSignalConnected_c2394 (arg1));
}


// QLayoutItem *QGridLayout::itemAt(int index)

static void _init_cbs_itemAt_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_itemAt_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QLayoutItem * > ((QLayoutItem *)((QGridLayout_Adaptor *)cls)->cbs_itemAt_c767_0 (arg1));
}

static void _set_callback_cbs_itemAt_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_itemAt_c767_0 = cb;
}


// QLayout *QGridLayout::layout()

static void _init_cbs_layout_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLayout * > ();
}

static void _call_cbs_layout_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLayout * > ((QLayout *)((QGridLayout_Adaptor *)cls)->cbs_layout_0_0 ());
}

static void _set_callback_cbs_layout_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_layout_0_0 = cb;
}


// QSize QGridLayout::maximumSize()

static void _init_cbs_maximumSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_maximumSize_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QGridLayout_Adaptor *)cls)->cbs_maximumSize_c0_0 ());
}

static void _set_callback_cbs_maximumSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_maximumSize_c0_0 = cb;
}


// int QGridLayout::minimumHeightForWidth(int)

static void _init_cbs_minimumHeightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_minimumHeightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QGridLayout_Adaptor *)cls)->cbs_minimumHeightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_minimumHeightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_minimumHeightForWidth_c767_0 = cb;
}


// QSize QGridLayout::minimumSize()

static void _init_cbs_minimumSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSize_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QGridLayout_Adaptor *)cls)->cbs_minimumSize_c0_0 ());
}

static void _set_callback_cbs_minimumSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_minimumSize_c0_0 = cb;
}


// emitter void QGridLayout::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QGridLayout_Adaptor *)cls)->emitter_QGridLayout_objectNameChanged_4567 (arg1);
}


// exposed int QGridLayout::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QGridLayout_Adaptor *)cls)->fp_QGridLayout_receivers_c1731 (arg1));
}


// exposed QObject *QGridLayout::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QGridLayout_Adaptor *)cls)->fp_QGridLayout_sender_c0 ());
}


// exposed int QGridLayout::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGridLayout_Adaptor *)cls)->fp_QGridLayout_senderSignalIndex_c0 ());
}


// void QGridLayout::setGeometry(const QRect &)

static void _init_cbs_setGeometry_1792_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setGeometry_1792_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout_Adaptor *)cls)->cbs_setGeometry_1792_0 (arg1);
}

static void _set_callback_cbs_setGeometry_1792_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_setGeometry_1792_0 = cb;
}


// QSize QGridLayout::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QGridLayout_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// QSpacerItem *QGridLayout::spacerItem()

static void _init_cbs_spacerItem_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSpacerItem * > ();
}

static void _call_cbs_spacerItem_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSpacerItem * > ((QSpacerItem *)((QGridLayout_Adaptor *)cls)->cbs_spacerItem_0_0 ());
}

static void _set_callback_cbs_spacerItem_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_spacerItem_0_0 = cb;
}


// QLayoutItem *QGridLayout::takeAt(int index)

static void _init_cbs_takeAt_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_takeAt_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QLayoutItem * > ((QLayoutItem *)((QGridLayout_Adaptor *)cls)->cbs_takeAt_767_0 (arg1));
}

static void _set_callback_cbs_takeAt_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_takeAt_767_0 = cb;
}


// void QGridLayout::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// QWidget *QGridLayout::widget()

static void _init_cbs_widget_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_cbs_widget_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QGridLayout_Adaptor *)cls)->cbs_widget_0_0 ());
}

static void _set_callback_cbs_widget_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGridLayout_Adaptor *)cls)->cb_widget_0_0 = cb;
}


// exposed void QGridLayout::widgetEvent(QEvent *)

static void _init_fp_widgetEvent_1217 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_widgetEvent_1217 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = gsi::arg_reader<QEvent * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGridLayout_Adaptor *)cls)->fp_QGridLayout_widgetEvent_1217 (arg1);
}


namespace gsi
{

gsi::Class<QGridLayout> &qtdecl_QGridLayout ();

static gsi::Methods methods_QGridLayout_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGridLayout::QGridLayout(QWidget *parent)\nThis method creates an object of class QGridLayout.", &_init_ctor_QGridLayout_Adaptor_1315, &_call_ctor_QGridLayout_Adaptor_1315);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGridLayout::QGridLayout()\nThis method creates an object of class QGridLayout.", &_init_ctor_QGridLayout_Adaptor_0, &_call_ctor_QGridLayout_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("*addChildLayout", "@brief Method void QGridLayout::addChildLayout(QLayout *l)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildLayout_1341, &_call_fp_addChildLayout_1341);
  methods += new qt_gsi::GenericMethod ("*addChildWidget", "@brief Method void QGridLayout::addChildWidget(QWidget *w)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildWidget_1315, &_call_fp_addChildWidget_1315);
  methods += new qt_gsi::GenericMethod ("*addItem", "@brief Virtual method void QGridLayout::addItem(QLayoutItem *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_addItem_1740_0, &_call_cbs_addItem_1740_0);
  methods += new qt_gsi::GenericMethod ("*addItem", "@hide", false, &_init_cbs_addItem_1740_0, &_call_cbs_addItem_1740_0, &_set_callback_cbs_addItem_1740_0);
  methods += new qt_gsi::GenericMethod ("*adoptLayout", "@brief Method bool QGridLayout::adoptLayout(QLayout *layout)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_adoptLayout_1341, &_call_fp_adoptLayout_1341);
  methods += new qt_gsi::GenericMethod ("*alignmentRect", "@brief Method QRect QGridLayout::alignmentRect(const QRect &)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_alignmentRect_c1792, &_call_fp_alignmentRect_c1792);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGridLayout::childEvent(QChildEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("controlTypes", "@brief Virtual method QFlags<QSizePolicy::ControlType> QGridLayout::controlTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_controlTypes_c0_0, &_call_cbs_controlTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("controlTypes", "@hide", true, &_init_cbs_controlTypes_c0_0, &_call_cbs_controlTypes_c0_0, &_set_callback_cbs_controlTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("count", "@brief Virtual method int QGridLayout::count()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0);
  methods += new qt_gsi::GenericMethod ("count", "@hide", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0, &_set_callback_cbs_count_c0_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGridLayout::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QGridLayout::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGridLayout::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QGridLayout::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QGridLayout::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("expandingDirections", "@brief Virtual method QFlags<Qt::Orientation> QGridLayout::expandingDirections()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_expandingDirections_c0_0, &_call_cbs_expandingDirections_c0_0);
  methods += new qt_gsi::GenericMethod ("expandingDirections", "@hide", true, &_init_cbs_expandingDirections_c0_0, &_call_cbs_expandingDirections_c0_0, &_set_callback_cbs_expandingDirections_c0_0);
  methods += new qt_gsi::GenericMethod ("geometry", "@brief Virtual method QRect QGridLayout::geometry()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_geometry_c0_0, &_call_cbs_geometry_c0_0);
  methods += new qt_gsi::GenericMethod ("geometry", "@hide", true, &_init_cbs_geometry_c0_0, &_call_cbs_geometry_c0_0, &_set_callback_cbs_geometry_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QGridLayout::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QGridLayout::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("indexOf", "@brief Virtual method int QGridLayout::indexOf(QWidget *)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexOf_c1315_0, &_call_cbs_indexOf_c1315_0);
  methods += new qt_gsi::GenericMethod ("indexOf", "@hide", true, &_init_cbs_indexOf_c1315_0, &_call_cbs_indexOf_c1315_0, &_set_callback_cbs_indexOf_c1315_0);
  methods += new qt_gsi::GenericMethod ("invalidate", "@brief Virtual method void QGridLayout::invalidate()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0);
  methods += new qt_gsi::GenericMethod ("invalidate", "@hide", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0, &_set_callback_cbs_invalidate_0_0);
  methods += new qt_gsi::GenericMethod ("isEmpty", "@brief Virtual method bool QGridLayout::isEmpty()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0);
  methods += new qt_gsi::GenericMethod ("isEmpty", "@hide", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0, &_set_callback_cbs_isEmpty_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QGridLayout::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Virtual method QLayoutItem *QGridLayout::itemAt(int index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0);
  methods += new qt_gsi::GenericMethod ("itemAt", "@hide", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0, &_set_callback_cbs_itemAt_c767_0);
  methods += new qt_gsi::GenericMethod ("layout", "@brief Virtual method QLayout *QGridLayout::layout()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_layout_0_0, &_call_cbs_layout_0_0);
  methods += new qt_gsi::GenericMethod ("layout", "@hide", false, &_init_cbs_layout_0_0, &_call_cbs_layout_0_0, &_set_callback_cbs_layout_0_0);
  methods += new qt_gsi::GenericMethod ("maximumSize", "@brief Virtual method QSize QGridLayout::maximumSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_maximumSize_c0_0, &_call_cbs_maximumSize_c0_0);
  methods += new qt_gsi::GenericMethod ("maximumSize", "@hide", true, &_init_cbs_maximumSize_c0_0, &_call_cbs_maximumSize_c0_0, &_set_callback_cbs_maximumSize_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumHeightForWidth", "@brief Virtual method int QGridLayout::minimumHeightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumHeightForWidth_c767_0, &_call_cbs_minimumHeightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("minimumHeightForWidth", "@hide", true, &_init_cbs_minimumHeightForWidth_c767_0, &_call_cbs_minimumHeightForWidth_c767_0, &_set_callback_cbs_minimumHeightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("minimumSize", "@brief Virtual method QSize QGridLayout::minimumSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSize_c0_0, &_call_cbs_minimumSize_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSize", "@hide", true, &_init_cbs_minimumSize_c0_0, &_call_cbs_minimumSize_c0_0, &_set_callback_cbs_minimumSize_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QGridLayout::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QGridLayout::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QGridLayout::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QGridLayout::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@brief Virtual method void QGridLayout::setGeometry(const QRect &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setGeometry_1792_0, &_call_cbs_setGeometry_1792_0);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@hide", false, &_init_cbs_setGeometry_1792_0, &_call_cbs_setGeometry_1792_0, &_set_callback_cbs_setGeometry_1792_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QGridLayout::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("spacerItem", "@brief Virtual method QSpacerItem *QGridLayout::spacerItem()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_spacerItem_0_0, &_call_cbs_spacerItem_0_0);
  methods += new qt_gsi::GenericMethod ("spacerItem", "@hide", false, &_init_cbs_spacerItem_0_0, &_call_cbs_spacerItem_0_0, &_set_callback_cbs_spacerItem_0_0);
  methods += new qt_gsi::GenericMethod ("takeAt", "@brief Virtual method QLayoutItem *QGridLayout::takeAt(int index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_takeAt_767_0, &_call_cbs_takeAt_767_0);
  methods += new qt_gsi::GenericMethod ("takeAt", "@hide", false, &_init_cbs_takeAt_767_0, &_call_cbs_takeAt_767_0, &_set_callback_cbs_takeAt_767_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGridLayout::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("widget", "@brief Virtual method QWidget *QGridLayout::widget()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_widget_0_0, &_call_cbs_widget_0_0);
  methods += new qt_gsi::GenericMethod ("widget", "@hide", false, &_init_cbs_widget_0_0, &_call_cbs_widget_0_0, &_set_callback_cbs_widget_0_0);
  methods += new qt_gsi::GenericMethod ("*widgetEvent", "@brief Method void QGridLayout::widgetEvent(QEvent *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_widgetEvent_1217, &_call_fp_widgetEvent_1217);
  return methods;
}

gsi::Class<QGridLayout_Adaptor> decl_QGridLayout_Adaptor (qtdecl_QGridLayout (), "QtWidgets", "QGridLayout",
  methods_QGridLayout_Adaptor (),
  "@qt\n@brief Binding of QGridLayout");

}

