
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsWidget.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QGraphicsWidget>
#include <QAction>
#include <QChildEvent>
#include <QCloseEvent>
#include <QCursor>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QGraphicsEffect>
#include <QGraphicsItem>
#include <QGraphicsItemGroup>
#include <QGraphicsLayout>
#include <QGraphicsLayoutItem>
#include <QGraphicsObject>
#include <QGraphicsScene>
#include <QGraphicsSceneContextMenuEvent>
#include <QGraphicsSceneDragDropEvent>
#include <QGraphicsSceneHoverEvent>
#include <QGraphicsSceneMouseEvent>
#include <QGraphicsSceneMoveEvent>
#include <QGraphicsSceneResizeEvent>
#include <QGraphicsSceneWheelEvent>
#include <QHideEvent>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QMatrix>
#include <QMetaMethod>
#include <QObject>
#include <QPainter>
#include <QPainterPath>
#include <QPalette>
#include <QPointF>
#include <QPolygonF>
#include <QRectF>
#include <QRegion>
#include <QShowEvent>
#include <QSize>
#include <QSizeF>
#include <QSizePolicy>
#include <QStyle>
#include <QStyleOption>
#include <QStyleOptionGraphicsItem>
#include <QThread>
#include <QTimerEvent>
#include <QTransform>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsWidget

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsWidget::staticMetaObject);
}


// QList<QAction*> QGraphicsWidget::actions()


static void _init_f_actions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QAction*> > ();
}

static void _call_f_actions_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QAction*> > ((QList<QAction*>)((QGraphicsWidget *)cls)->actions ());
}


// void QGraphicsWidget::addAction(QAction *action)


static void _init_f_addAction_1309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<QAction * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addAction_1309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAction *arg1 = gsi::arg_reader<QAction * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->addAction (arg1);
}


// void QGraphicsWidget::addActions(QList<QAction*> actions)


static void _init_f_addActions_1780 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("actions");
  decl->add_arg<QList<QAction*> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addActions_1780 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QList<QAction*> arg1 = gsi::arg_reader<QList<QAction*> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->addActions (arg1);
}


// void QGraphicsWidget::adjustSize()


static void _init_f_adjustSize_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_adjustSize_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->adjustSize ();
}


// bool QGraphicsWidget::autoFillBackground()


static void _init_f_autoFillBackground_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_autoFillBackground_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsWidget *)cls)->autoFillBackground ());
}


// QRectF QGraphicsWidget::boundingRect()


static void _init_f_boundingRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QGraphicsWidget *)cls)->boundingRect ());
}


// const QList<QObject*> &QGraphicsWidget::children()


static void _init_f_children_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QList<QObject*> & > ();
}

static void _call_f_children_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QList<QObject*> & > ((const QList<QObject*> &)((QGraphicsWidget *)cls)->children ());
}


// bool QGraphicsWidget::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsWidget *)cls)->close ());
}


// Qt::FocusPolicy QGraphicsWidget::focusPolicy()


static void _init_f_focusPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::FocusPolicy>::target_type > ();
}

static void _call_f_focusPolicy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::FocusPolicy>::target_type > ((qt_gsi::Converter<Qt::FocusPolicy>::target_type)qt_gsi::CppToQtAdaptor<Qt::FocusPolicy>(((QGraphicsWidget *)cls)->focusPolicy ()));
}


// QGraphicsWidget *QGraphicsWidget::focusWidget()


static void _init_f_focusWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsWidget * > ();
}

static void _call_f_focusWidget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsWidget * > ((QGraphicsWidget *)((QGraphicsWidget *)cls)->focusWidget ());
}


// QFont QGraphicsWidget::font()


static void _init_f_font_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_font_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFont > ((QFont)((QGraphicsWidget *)cls)->font ());
}


// void QGraphicsWidget::getContentsMargins(double *left, double *top, double *right, double *bottom)


static void _init_f_getContentsMargins_c4704 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<double * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<double * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_getContentsMargins_c4704 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double *arg1 = gsi::arg_reader<double * >() (args, heap);
  double *arg2 = gsi::arg_reader<double * >() (args, heap);
  double *arg3 = gsi::arg_reader<double * >() (args, heap);
  double *arg4 = gsi::arg_reader<double * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->getContentsMargins (arg1, arg2, arg3, arg4);
}


// void QGraphicsWidget::getWindowFrameMargins(double *left, double *top, double *right, double *bottom)


static void _init_f_getWindowFrameMargins_c4704 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<double * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<double * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_getWindowFrameMargins_c4704 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double *arg1 = gsi::arg_reader<double * >() (args, heap);
  double *arg2 = gsi::arg_reader<double * >() (args, heap);
  double *arg3 = gsi::arg_reader<double * >() (args, heap);
  double *arg4 = gsi::arg_reader<double * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->getWindowFrameMargins (arg1, arg2, arg3, arg4);
}


// int QGraphicsWidget::grabShortcut(const QKeySequence &sequence, Qt::ShortcutContext context)


static void _init_f_grabShortcut_4758 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sequence");
  decl->add_arg<const QKeySequence & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("context", true, "Qt::WindowShortcut");
  decl->add_arg<const qt_gsi::Converter<Qt::ShortcutContext>::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_grabShortcut_4758 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QKeySequence &arg1 = gsi::arg_reader<const QKeySequence & >() (args, heap);
  const qt_gsi::Converter<Qt::ShortcutContext>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ShortcutContext>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ShortcutContext>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ShortcutContext>(heap, Qt::WindowShortcut), heap);
  ret.write<int > ((int)((QGraphicsWidget *)cls)->grabShortcut (arg1, qt_gsi::QtToCppAdaptor<Qt::ShortcutContext>(arg2).cref()));
}


// void QGraphicsWidget::insertAction(QAction *before, QAction *action)


static void _init_f_insertAction_2510 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("before");
  decl->add_arg<QAction * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<QAction * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertAction_2510 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAction *arg1 = gsi::arg_reader<QAction * >() (args, heap);
  QAction *arg2 = gsi::arg_reader<QAction * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->insertAction (arg1, arg2);
}


// void QGraphicsWidget::insertActions(QAction *before, QList<QAction*> actions)


static void _init_f_insertActions_2981 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("before");
  decl->add_arg<QAction * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("actions");
  decl->add_arg<QList<QAction*> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertActions_2981 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAction *arg1 = gsi::arg_reader<QAction * >() (args, heap);
  QList<QAction*> arg2 = gsi::arg_reader<QList<QAction*> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->insertActions (arg1, arg2);
}


// bool QGraphicsWidget::isActiveWindow()


static void _init_f_isActiveWindow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActiveWindow_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsWidget *)cls)->isActiveWindow ());
}


// QGraphicsLayout *QGraphicsWidget::layout()


static void _init_f_layout_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsLayout * > ();
}

static void _call_f_layout_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsLayout * > ((QGraphicsLayout *)((QGraphicsWidget *)cls)->layout ());
}


// Qt::LayoutDirection QGraphicsWidget::layoutDirection()


static void _init_f_layoutDirection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ();
}

static void _call_f_layoutDirection_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ((qt_gsi::Converter<Qt::LayoutDirection>::target_type)qt_gsi::CppToQtAdaptor<Qt::LayoutDirection>(((QGraphicsWidget *)cls)->layoutDirection ()));
}


// void QGraphicsWidget::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)


static void _init_f_paint_6301 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_paint_6301 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  const QStyleOptionGraphicsItem *arg2 = gsi::arg_reader<const QStyleOptionGraphicsItem * >() (args, heap);
  QWidget *arg3 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->paint (arg1, arg2, arg3);
}


// void QGraphicsWidget::paintWindowFrame(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)


static void _init_f_paintWindowFrame_6301 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_paintWindowFrame_6301 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  const QStyleOptionGraphicsItem *arg2 = gsi::arg_reader<const QStyleOptionGraphicsItem * >() (args, heap);
  QWidget *arg3 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->paintWindowFrame (arg1, arg2, arg3);
}


// QPalette QGraphicsWidget::palette()


static void _init_f_palette_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPalette > ();
}

static void _call_f_palette_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPalette > ((QPalette)((QGraphicsWidget *)cls)->palette ());
}


// QRectF QGraphicsWidget::rect()


static void _init_f_rect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_rect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QGraphicsWidget *)cls)->rect ());
}


// void QGraphicsWidget::releaseShortcut(int id)


static void _init_f_releaseShortcut_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_releaseShortcut_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->releaseShortcut (arg1);
}


// void QGraphicsWidget::removeAction(QAction *action)


static void _init_f_removeAction_1309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<QAction * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeAction_1309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAction *arg1 = gsi::arg_reader<QAction * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->removeAction (arg1);
}


// void QGraphicsWidget::resize(const QSizeF &size)


static void _init_f_resize_1875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_resize_1875 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSizeF &arg1 = gsi::arg_reader<const QSizeF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->resize (arg1);
}


// void QGraphicsWidget::resize(double w, double h)


static void _init_f_resize_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_resize_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->resize (arg1, arg2);
}


// void QGraphicsWidget::setAttribute(Qt::WidgetAttribute attribute, bool on)


static void _init_f_setAttribute_3065 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("attribute");
  decl->add_arg<const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setAttribute_3065 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->setAttribute (qt_gsi::QtToCppAdaptor<Qt::WidgetAttribute>(arg1).cref(), arg2);
}


// void QGraphicsWidget::setAutoFillBackground(bool enabled)


static void _init_f_setAutoFillBackground_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoFillBackground_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->setAutoFillBackground (arg1);
}


// void QGraphicsWidget::setContentsMargins(double left, double top, double right, double bottom)


static void _init_f_setContentsMargins_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setContentsMargins_3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->setContentsMargins (arg1, arg2, arg3, arg4);
}


// void QGraphicsWidget::setFocusPolicy(Qt::FocusPolicy policy)


static void _init_f_setFocusPolicy_1885 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<Qt::FocusPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocusPolicy_1885 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::FocusPolicy>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::FocusPolicy>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->setFocusPolicy (qt_gsi::QtToCppAdaptor<Qt::FocusPolicy>(arg1).cref());
}


// void QGraphicsWidget::setFont(const QFont &font)


static void _init_f_setFont_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("font");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFont_1801 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->setFont (arg1);
}


// void QGraphicsWidget::setGeometry(const QRectF &rect)


static void _init_f_setGeometry_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->setGeometry (arg1);
}


// void QGraphicsWidget::setGeometry(double x, double y, double w, double h)


static void _init_f_setGeometry_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->setGeometry (arg1, arg2, arg3, arg4);
}


// void QGraphicsWidget::setLayout(QGraphicsLayout *layout)


static void _init_f_setLayout_2158 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layout");
  decl->add_arg<QGraphicsLayout * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLayout_2158 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsLayout *arg1 = gsi::arg_reader<QGraphicsLayout * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->setLayout (arg1);
}


// void QGraphicsWidget::setLayoutDirection(Qt::LayoutDirection direction)


static void _init_f_setLayoutDirection_2316 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLayoutDirection_2316 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->setLayoutDirection (qt_gsi::QtToCppAdaptor<Qt::LayoutDirection>(arg1).cref());
}


// void QGraphicsWidget::setPalette(const QPalette &palette)


static void _init_f_setPalette_2113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("palette");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPalette_2113 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = gsi::arg_reader<const QPalette & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->setPalette (arg1);
}


// void QGraphicsWidget::setShortcutAutoRepeat(int id, bool enabled)


static void _init_f_setShortcutAutoRepeat_1523 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enabled", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setShortcutAutoRepeat_1523 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->setShortcutAutoRepeat (arg1, arg2);
}


// void QGraphicsWidget::setShortcutEnabled(int id, bool enabled)


static void _init_f_setShortcutEnabled_1523 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enabled", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setShortcutEnabled_1523 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->setShortcutEnabled (arg1, arg2);
}


// void QGraphicsWidget::setStyle(QStyle *style)


static void _init_f_setStyle_1232 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("style");
  decl->add_arg<QStyle * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStyle_1232 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyle *arg1 = gsi::arg_reader<QStyle * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->setStyle (arg1);
}


// void QGraphicsWidget::setWindowFlags(QFlags<Qt::WindowType> wFlags)


static void _init_f_setWindowFlags_2495 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("wFlags");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowFlags_2495 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::WindowType> arg1 = gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->setWindowFlags (arg1);
}


// void QGraphicsWidget::setWindowFrameMargins(double left, double top, double right, double bottom)


static void _init_f_setWindowFrameMargins_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setWindowFrameMargins_3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->setWindowFrameMargins (arg1, arg2, arg3, arg4);
}


// void QGraphicsWidget::setWindowTitle(const QString &title)


static void _init_f_setWindowTitle_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowTitle_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->setWindowTitle (arg1);
}


// QPainterPath QGraphicsWidget::shape()


static void _init_f_shape_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_f_shape_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsWidget *)cls)->shape ());
}


// QSizeF QGraphicsWidget::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSizeF > ((QSizeF)((QGraphicsWidget *)cls)->size ());
}


// QStyle *QGraphicsWidget::style()


static void _init_f_style_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStyle * > ();
}

static void _call_f_style_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStyle * > ((QStyle *)((QGraphicsWidget *)cls)->style ());
}


// bool QGraphicsWidget::testAttribute(Qt::WidgetAttribute attribute)


static void _init_f_testAttribute_c2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("attribute");
  decl->add_arg<const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testAttribute_c2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsWidget *)cls)->testAttribute (qt_gsi::QtToCppAdaptor<Qt::WidgetAttribute>(arg1).cref()));
}


// int QGraphicsWidget::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsWidget *)cls)->type ());
}


// void QGraphicsWidget::unsetLayoutDirection()


static void _init_f_unsetLayoutDirection_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_unsetLayoutDirection_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->unsetLayoutDirection ();
}


// void QGraphicsWidget::unsetWindowFrameMargins()


static void _init_f_unsetWindowFrameMargins_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_unsetWindowFrameMargins_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget *)cls)->unsetWindowFrameMargins ();
}


// QFlags<Qt::WindowType> QGraphicsWidget::windowFlags()


static void _init_f_windowFlags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::WindowType> > ();
}

static void _call_f_windowFlags_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::WindowType> > ((QFlags<Qt::WindowType>)((QGraphicsWidget *)cls)->windowFlags ());
}


// QRectF QGraphicsWidget::windowFrameGeometry()


static void _init_f_windowFrameGeometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_windowFrameGeometry_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QGraphicsWidget *)cls)->windowFrameGeometry ());
}


// QRectF QGraphicsWidget::windowFrameRect()


static void _init_f_windowFrameRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_windowFrameRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QGraphicsWidget *)cls)->windowFrameRect ());
}


// QString QGraphicsWidget::windowTitle()


static void _init_f_windowTitle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_windowTitle_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QGraphicsWidget *)cls)->windowTitle ());
}


// Qt::WindowType QGraphicsWidget::windowType()


static void _init_f_windowType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::WindowType>::target_type > ();
}

static void _call_f_windowType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::WindowType>::target_type > ((qt_gsi::Converter<Qt::WindowType>::target_type)qt_gsi::CppToQtAdaptor<Qt::WindowType>(((QGraphicsWidget *)cls)->windowType ()));
}


// static void QGraphicsWidget::setTabOrder(QGraphicsWidget *first, QGraphicsWidget *second)


static void _init_f_setTabOrder_4156 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("first");
  decl->add_arg<QGraphicsWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("second");
  decl->add_arg<QGraphicsWidget * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTabOrder_4156 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsWidget *arg1 = gsi::arg_reader<QGraphicsWidget * >() (args, heap);
  QGraphicsWidget *arg2 = gsi::arg_reader<QGraphicsWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QGraphicsWidget::setTabOrder (arg1, arg2);
}


// static QString QGraphicsWidget::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QGraphicsWidget::tr (arg1, arg2, arg3));
}


// static QString QGraphicsWidget::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QGraphicsWidget::trUtf8 (arg1, arg2, arg3));
}


//  base class cast for QGraphicsObject

static void _init_f_QGraphicsWidget_as_QGraphicsObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsObject *> ();
}

static void _call_f_QGraphicsWidget_as_QGraphicsObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsObject *> ((QGraphicsObject *)(QGraphicsWidget *)cls);
}

static void _init_f_QGraphicsWidget_as_const_QGraphicsObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QGraphicsObject *> ();
}

static void _call_f_QGraphicsWidget_as_const_QGraphicsObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QGraphicsObject *> ((const QGraphicsObject *)(const QGraphicsWidget *)cls);
}

//  base class cast for QGraphicsLayoutItem

static void _init_f_QGraphicsWidget_as_QGraphicsLayoutItem (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsLayoutItem *> ();
}

static void _call_f_QGraphicsWidget_as_QGraphicsLayoutItem (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsLayoutItem *> ((QGraphicsLayoutItem *)(QGraphicsWidget *)cls);
}

static void _init_f_QGraphicsWidget_as_const_QGraphicsLayoutItem (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QGraphicsLayoutItem *> ();
}

static void _call_f_QGraphicsWidget_as_const_QGraphicsLayoutItem (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QGraphicsLayoutItem *> ((const QGraphicsLayoutItem *)(const QGraphicsWidget *)cls);
}


namespace gsi
{

static gsi::Methods methods_QGraphicsWidget () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("actions", "@brief Method QList<QAction*> QGraphicsWidget::actions()\n", true, &_init_f_actions_c0, &_call_f_actions_c0);
  methods += new qt_gsi::GenericMethod ("addAction", "@brief Method void QGraphicsWidget::addAction(QAction *action)\n", false, &_init_f_addAction_1309, &_call_f_addAction_1309);
  methods += new qt_gsi::GenericMethod ("addActions", "@brief Method void QGraphicsWidget::addActions(QList<QAction*> actions)\n", false, &_init_f_addActions_1780, &_call_f_addActions_1780);
  methods += new qt_gsi::GenericMethod ("adjustSize", "@brief Method void QGraphicsWidget::adjustSize()\n", false, &_init_f_adjustSize_0, &_call_f_adjustSize_0);
  methods += new qt_gsi::GenericMethod (":autoFillBackground", "@brief Method bool QGraphicsWidget::autoFillBackground()\n", true, &_init_f_autoFillBackground_c0, &_call_f_autoFillBackground_c0);
  methods += new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRectF QGraphicsWidget::boundingRect()\nThis is a reimplementation of QGraphicsItem::boundingRect", true, &_init_f_boundingRect_c0, &_call_f_boundingRect_c0);
  methods += new qt_gsi::GenericMethod (":children", "@brief Method const QList<QObject*> &QGraphicsWidget::children()\n", true, &_init_f_children_c0, &_call_f_children_c0);
  methods += new qt_gsi::GenericMethod ("close", "@brief Method bool QGraphicsWidget::close()\n", false, &_init_f_close_0, &_call_f_close_0);
  methods += new qt_gsi::GenericMethod (":focusPolicy", "@brief Method Qt::FocusPolicy QGraphicsWidget::focusPolicy()\n", true, &_init_f_focusPolicy_c0, &_call_f_focusPolicy_c0);
  methods += new qt_gsi::GenericMethod ("focusWidget", "@brief Method QGraphicsWidget *QGraphicsWidget::focusWidget()\n", true, &_init_f_focusWidget_c0, &_call_f_focusWidget_c0);
  methods += new qt_gsi::GenericMethod (":font", "@brief Method QFont QGraphicsWidget::font()\n", true, &_init_f_font_c0, &_call_f_font_c0);
  methods += new qt_gsi::GenericMethod ("getContentsMargins", "@brief Method void QGraphicsWidget::getContentsMargins(double *left, double *top, double *right, double *bottom)\nThis is a reimplementation of QGraphicsLayoutItem::getContentsMargins", true, &_init_f_getContentsMargins_c4704, &_call_f_getContentsMargins_c4704);
  methods += new qt_gsi::GenericMethod ("getWindowFrameMargins", "@brief Method void QGraphicsWidget::getWindowFrameMargins(double *left, double *top, double *right, double *bottom)\n", true, &_init_f_getWindowFrameMargins_c4704, &_call_f_getWindowFrameMargins_c4704);
  methods += new qt_gsi::GenericMethod ("grabShortcut", "@brief Method int QGraphicsWidget::grabShortcut(const QKeySequence &sequence, Qt::ShortcutContext context)\n", false, &_init_f_grabShortcut_4758, &_call_f_grabShortcut_4758);
  methods += new qt_gsi::GenericMethod ("insertAction", "@brief Method void QGraphicsWidget::insertAction(QAction *before, QAction *action)\n", false, &_init_f_insertAction_2510, &_call_f_insertAction_2510);
  methods += new qt_gsi::GenericMethod ("insertActions", "@brief Method void QGraphicsWidget::insertActions(QAction *before, QList<QAction*> actions)\n", false, &_init_f_insertActions_2981, &_call_f_insertActions_2981);
  methods += new qt_gsi::GenericMethod ("isActiveWindow?", "@brief Method bool QGraphicsWidget::isActiveWindow()\n", true, &_init_f_isActiveWindow_c0, &_call_f_isActiveWindow_c0);
  methods += new qt_gsi::GenericMethod (":layout", "@brief Method QGraphicsLayout *QGraphicsWidget::layout()\n", true, &_init_f_layout_c0, &_call_f_layout_c0);
  methods += new qt_gsi::GenericMethod (":layoutDirection", "@brief Method Qt::LayoutDirection QGraphicsWidget::layoutDirection()\n", true, &_init_f_layoutDirection_c0, &_call_f_layoutDirection_c0);
  methods += new qt_gsi::GenericMethod ("paint", "@brief Method void QGraphicsWidget::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)\nThis is a reimplementation of QGraphicsItem::paint", false, &_init_f_paint_6301, &_call_f_paint_6301);
  methods += new qt_gsi::GenericMethod ("paintWindowFrame", "@brief Method void QGraphicsWidget::paintWindowFrame(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)\n", false, &_init_f_paintWindowFrame_6301, &_call_f_paintWindowFrame_6301);
  methods += new qt_gsi::GenericMethod (":palette", "@brief Method QPalette QGraphicsWidget::palette()\n", true, &_init_f_palette_c0, &_call_f_palette_c0);
  methods += new qt_gsi::GenericMethod ("rect", "@brief Method QRectF QGraphicsWidget::rect()\n", true, &_init_f_rect_c0, &_call_f_rect_c0);
  methods += new qt_gsi::GenericMethod ("releaseShortcut", "@brief Method void QGraphicsWidget::releaseShortcut(int id)\n", false, &_init_f_releaseShortcut_767, &_call_f_releaseShortcut_767);
  methods += new qt_gsi::GenericMethod ("removeAction", "@brief Method void QGraphicsWidget::removeAction(QAction *action)\n", false, &_init_f_removeAction_1309, &_call_f_removeAction_1309);
  methods += new qt_gsi::GenericMethod ("resize", "@brief Method void QGraphicsWidget::resize(const QSizeF &size)\n", false, &_init_f_resize_1875, &_call_f_resize_1875);
  methods += new qt_gsi::GenericMethod ("resize", "@brief Method void QGraphicsWidget::resize(double w, double h)\n", false, &_init_f_resize_2034, &_call_f_resize_2034);
  methods += new qt_gsi::GenericMethod ("setAttribute", "@brief Method void QGraphicsWidget::setAttribute(Qt::WidgetAttribute attribute, bool on)\n", false, &_init_f_setAttribute_3065, &_call_f_setAttribute_3065);
  methods += new qt_gsi::GenericMethod ("setAutoFillBackground|autoFillBackground=", "@brief Method void QGraphicsWidget::setAutoFillBackground(bool enabled)\n", false, &_init_f_setAutoFillBackground_864, &_call_f_setAutoFillBackground_864);
  methods += new qt_gsi::GenericMethod ("setContentsMargins", "@brief Method void QGraphicsWidget::setContentsMargins(double left, double top, double right, double bottom)\n", false, &_init_f_setContentsMargins_3960, &_call_f_setContentsMargins_3960);
  methods += new qt_gsi::GenericMethod ("setFocusPolicy|focusPolicy=", "@brief Method void QGraphicsWidget::setFocusPolicy(Qt::FocusPolicy policy)\n", false, &_init_f_setFocusPolicy_1885, &_call_f_setFocusPolicy_1885);
  methods += new qt_gsi::GenericMethod ("setFont|font=", "@brief Method void QGraphicsWidget::setFont(const QFont &font)\n", false, &_init_f_setFont_1801, &_call_f_setFont_1801);
  methods += new qt_gsi::GenericMethod ("setGeometry|geometry=", "@brief Method void QGraphicsWidget::setGeometry(const QRectF &rect)\nThis is a reimplementation of QGraphicsLayoutItem::setGeometry", false, &_init_f_setGeometry_1862, &_call_f_setGeometry_1862);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@brief Method void QGraphicsWidget::setGeometry(double x, double y, double w, double h)\n", false, &_init_f_setGeometry_3960, &_call_f_setGeometry_3960);
  methods += new qt_gsi::GenericMethod ("setLayout|layout=", "@brief Method void QGraphicsWidget::setLayout(QGraphicsLayout *layout)\n", false, &_init_f_setLayout_2158, &_call_f_setLayout_2158);
  methods += new qt_gsi::GenericMethod ("setLayoutDirection|layoutDirection=", "@brief Method void QGraphicsWidget::setLayoutDirection(Qt::LayoutDirection direction)\n", false, &_init_f_setLayoutDirection_2316, &_call_f_setLayoutDirection_2316);
  methods += new qt_gsi::GenericMethod ("setPalette|palette=", "@brief Method void QGraphicsWidget::setPalette(const QPalette &palette)\n", false, &_init_f_setPalette_2113, &_call_f_setPalette_2113);
  methods += new qt_gsi::GenericMethod ("setShortcutAutoRepeat", "@brief Method void QGraphicsWidget::setShortcutAutoRepeat(int id, bool enabled)\n", false, &_init_f_setShortcutAutoRepeat_1523, &_call_f_setShortcutAutoRepeat_1523);
  methods += new qt_gsi::GenericMethod ("setShortcutEnabled", "@brief Method void QGraphicsWidget::setShortcutEnabled(int id, bool enabled)\n", false, &_init_f_setShortcutEnabled_1523, &_call_f_setShortcutEnabled_1523);
  methods += new qt_gsi::GenericMethod ("setStyle|style=", "@brief Method void QGraphicsWidget::setStyle(QStyle *style)\n", false, &_init_f_setStyle_1232, &_call_f_setStyle_1232);
  methods += new qt_gsi::GenericMethod ("setWindowFlags|windowFlags=", "@brief Method void QGraphicsWidget::setWindowFlags(QFlags<Qt::WindowType> wFlags)\n", false, &_init_f_setWindowFlags_2495, &_call_f_setWindowFlags_2495);
  methods += new qt_gsi::GenericMethod ("setWindowFrameMargins", "@brief Method void QGraphicsWidget::setWindowFrameMargins(double left, double top, double right, double bottom)\n", false, &_init_f_setWindowFrameMargins_3960, &_call_f_setWindowFrameMargins_3960);
  methods += new qt_gsi::GenericMethod ("setWindowTitle|windowTitle=", "@brief Method void QGraphicsWidget::setWindowTitle(const QString &title)\n", false, &_init_f_setWindowTitle_2025, &_call_f_setWindowTitle_2025);
  methods += new qt_gsi::GenericMethod ("shape", "@brief Method QPainterPath QGraphicsWidget::shape()\nThis is a reimplementation of QGraphicsItem::shape", true, &_init_f_shape_c0, &_call_f_shape_c0);
  methods += new qt_gsi::GenericMethod (":size", "@brief Method QSizeF QGraphicsWidget::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
  methods += new qt_gsi::GenericMethod (":style", "@brief Method QStyle *QGraphicsWidget::style()\n", true, &_init_f_style_c0, &_call_f_style_c0);
  methods += new qt_gsi::GenericMethod ("testAttribute", "@brief Method bool QGraphicsWidget::testAttribute(Qt::WidgetAttribute attribute)\n", true, &_init_f_testAttribute_c2309, &_call_f_testAttribute_c2309);
  methods += new qt_gsi::GenericMethod ("type", "@brief Method int QGraphicsWidget::type()\nThis is a reimplementation of QGraphicsItem::type", true, &_init_f_type_c0, &_call_f_type_c0);
  methods += new qt_gsi::GenericMethod ("unsetLayoutDirection", "@brief Method void QGraphicsWidget::unsetLayoutDirection()\n", false, &_init_f_unsetLayoutDirection_0, &_call_f_unsetLayoutDirection_0);
  methods += new qt_gsi::GenericMethod ("unsetWindowFrameMargins", "@brief Method void QGraphicsWidget::unsetWindowFrameMargins()\n", false, &_init_f_unsetWindowFrameMargins_0, &_call_f_unsetWindowFrameMargins_0);
  methods += new qt_gsi::GenericMethod (":windowFlags", "@brief Method QFlags<Qt::WindowType> QGraphicsWidget::windowFlags()\n", true, &_init_f_windowFlags_c0, &_call_f_windowFlags_c0);
  methods += new qt_gsi::GenericMethod ("windowFrameGeometry", "@brief Method QRectF QGraphicsWidget::windowFrameGeometry()\n", true, &_init_f_windowFrameGeometry_c0, &_call_f_windowFrameGeometry_c0);
  methods += new qt_gsi::GenericMethod ("windowFrameRect", "@brief Method QRectF QGraphicsWidget::windowFrameRect()\n", true, &_init_f_windowFrameRect_c0, &_call_f_windowFrameRect_c0);
  methods += new qt_gsi::GenericMethod (":windowTitle", "@brief Method QString QGraphicsWidget::windowTitle()\n", true, &_init_f_windowTitle_c0, &_call_f_windowTitle_c0);
  methods += new qt_gsi::GenericMethod ("windowType", "@brief Method Qt::WindowType QGraphicsWidget::windowType()\n", true, &_init_f_windowType_c0, &_call_f_windowType_c0);
  methods += gsi::qt_signal ("childrenChanged()", "childrenChanged", "@brief Signal declaration for QGraphicsWidget::childrenChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QGraphicsWidget::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("enabledChanged()", "enabledChanged", "@brief Signal declaration for QGraphicsWidget::enabledChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("geometryChanged()", "geometryChanged", "@brief Signal declaration for QGraphicsWidget::geometryChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("heightChanged()", "heightChanged", "@brief Signal declaration for QGraphicsWidget::heightChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("layoutChanged()", "layoutChanged", "@brief Signal declaration for QGraphicsWidget::layoutChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QGraphicsWidget::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("opacityChanged()", "opacityChanged", "@brief Signal declaration for QGraphicsWidget::opacityChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("parentChanged()", "parentChanged", "@brief Signal declaration for QGraphicsWidget::parentChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("rotationChanged()", "rotationChanged", "@brief Signal declaration for QGraphicsWidget::rotationChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("scaleChanged()", "scaleChanged", "@brief Signal declaration for QGraphicsWidget::scaleChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("visibleChanged()", "visibleChanged", "@brief Signal declaration for QGraphicsWidget::visibleChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("widthChanged()", "widthChanged", "@brief Signal declaration for QGraphicsWidget::widthChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("xChanged()", "xChanged", "@brief Signal declaration for QGraphicsWidget::xChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("yChanged()", "yChanged", "@brief Signal declaration for QGraphicsWidget::yChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("zChanged()", "zChanged", "@brief Signal declaration for QGraphicsWidget::zChanged()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("setTabOrder", "@brief Static method void QGraphicsWidget::setTabOrder(QGraphicsWidget *first, QGraphicsWidget *second)\nThis method is static and can be called without an instance.", &_init_f_setTabOrder_4156, &_call_f_setTabOrder_4156);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsWidget::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsWidget::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  methods += new qt_gsi::GenericMethod ("asQGraphicsObject", "@brief Delivers the base class interface QGraphicsObject of QGraphicsWidget\nClass QGraphicsWidget is derived from multiple base classes. This method delivers the QGraphicsObject base class aspect.", false, &_init_f_QGraphicsWidget_as_QGraphicsObject, &_call_f_QGraphicsWidget_as_QGraphicsObject);
  methods += new qt_gsi::GenericMethod ("asConstQGraphicsObject", "@brief Delivers the base class interface QGraphicsObject of QGraphicsWidget\nClass QGraphicsWidget is derived from multiple base classes. This method delivers the QGraphicsObject base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QGraphicsWidget_as_const_QGraphicsObject, &_call_f_QGraphicsWidget_as_const_QGraphicsObject);
  methods += new qt_gsi::GenericMethod ("asQGraphicsLayoutItem", "@brief Delivers the base class interface QGraphicsLayoutItem of QGraphicsWidget\nClass QGraphicsWidget is derived from multiple base classes. This method delivers the QGraphicsLayoutItem base class aspect.", false, &_init_f_QGraphicsWidget_as_QGraphicsLayoutItem, &_call_f_QGraphicsWidget_as_QGraphicsLayoutItem);
  methods += new qt_gsi::GenericMethod ("asConstQGraphicsLayoutItem", "@brief Delivers the base class interface QGraphicsLayoutItem of QGraphicsWidget\nClass QGraphicsWidget is derived from multiple base classes. This method delivers the QGraphicsLayoutItem base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QGraphicsWidget_as_const_QGraphicsLayoutItem, &_call_f_QGraphicsWidget_as_const_QGraphicsLayoutItem);
  return methods;
}

gsi::Class<QGraphicsObject> &qtdecl_QGraphicsObject ();

qt_gsi::QtNativeClass<QGraphicsWidget> decl_QGraphicsWidget (qtdecl_QGraphicsObject (), "QtWidgets", "QGraphicsWidget_Native",
  methods_QGraphicsWidget (),
  "@hide\n@alias QGraphicsWidget");

//  Additional base classes

gsi::Class<QGraphicsLayoutItem> &qtdecl_QGraphicsLayoutItem ();

gsi::ClassExt<QGraphicsWidget> base_class_QGraphicsLayoutItem_in_QGraphicsWidget (qtdecl_QGraphicsLayoutItem ());

GSI_QTWIDGETS_PUBLIC gsi::Class<QGraphicsWidget> &qtdecl_QGraphicsWidget () { return decl_QGraphicsWidget; }

}


class QGraphicsWidget_Adaptor : public QGraphicsWidget, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsWidget_Adaptor();

  //  [adaptor ctor] QGraphicsWidget::QGraphicsWidget(QGraphicsItem *parent, QFlags<Qt::WindowType> wFlags)
  QGraphicsWidget_Adaptor() : QGraphicsWidget()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsWidget::QGraphicsWidget(QGraphicsItem *parent, QFlags<Qt::WindowType> wFlags)
  QGraphicsWidget_Adaptor(QGraphicsItem *parent) : QGraphicsWidget(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsWidget::QGraphicsWidget(QGraphicsItem *parent, QFlags<Qt::WindowType> wFlags)
  QGraphicsWidget_Adaptor(QGraphicsItem *parent, QFlags<Qt::WindowType> wFlags) : QGraphicsWidget(parent, wFlags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QGraphicsWidget::addToIndex()
  void fp_QGraphicsWidget_addToIndex_0 () {
    QGraphicsWidget::addToIndex();
  }

  //  [expose] bool QGraphicsWidget::isSignalConnected(const QMetaMethod &signal)
  bool fp_QGraphicsWidget_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QGraphicsWidget::isSignalConnected(signal);
  }

  //  [expose] void QGraphicsWidget::prepareGeometryChange()
  void fp_QGraphicsWidget_prepareGeometryChange_0 () {
    QGraphicsWidget::prepareGeometryChange();
  }

  //  [expose] int QGraphicsWidget::receivers(const char *signal)
  int fp_QGraphicsWidget_receivers_c1731 (const char *signal) const {
    return QGraphicsWidget::receivers(signal);
  }

  //  [expose] void QGraphicsWidget::removeFromIndex()
  void fp_QGraphicsWidget_removeFromIndex_0 () {
    QGraphicsWidget::removeFromIndex();
  }

  //  [expose] QObject *QGraphicsWidget::sender()
  QObject * fp_QGraphicsWidget_sender_c0 () const {
    return QGraphicsWidget::sender();
  }

  //  [expose] int QGraphicsWidget::senderSignalIndex()
  int fp_QGraphicsWidget_senderSignalIndex_c0 () const {
    return QGraphicsWidget::senderSignalIndex();
  }

  //  [expose] void QGraphicsWidget::setGraphicsItem(QGraphicsItem *item)
  void fp_QGraphicsWidget_setGraphicsItem_1919 (QGraphicsItem *item) {
    QGraphicsWidget::setGraphicsItem(item);
  }

  //  [expose] void QGraphicsWidget::setOwnedByLayout(bool ownedByLayout)
  void fp_QGraphicsWidget_setOwnedByLayout_864 (bool ownedByLayout) {
    QGraphicsWidget::setOwnedByLayout(ownedByLayout);
  }

  //  [expose] void QGraphicsWidget::updateMicroFocus()
  void fp_QGraphicsWidget_updateMicroFocus_0 () {
    QGraphicsWidget::updateMicroFocus();
  }

  //  [adaptor impl] void QGraphicsWidget::advance(int phase)
  void cbs_advance_767_0(int phase)
  {
    QGraphicsWidget::advance(phase);
  }

  virtual void advance(int phase)
  {
    if (cb_advance_767_0.can_issue()) {
      cb_advance_767_0.issue<QGraphicsWidget_Adaptor, int>(&QGraphicsWidget_Adaptor::cbs_advance_767_0, phase);
    } else {
      QGraphicsWidget::advance(phase);
    }
  }

  //  [adaptor impl] QRectF QGraphicsWidget::boundingRect()
  QRectF cbs_boundingRect_c0_0() const
  {
    return QGraphicsWidget::boundingRect();
  }

  virtual QRectF boundingRect() const
  {
    if (cb_boundingRect_c0_0.can_issue()) {
      return cb_boundingRect_c0_0.issue<QGraphicsWidget_Adaptor, QRectF>(&QGraphicsWidget_Adaptor::cbs_boundingRect_c0_0);
    } else {
      return QGraphicsWidget::boundingRect();
    }
  }

  //  [emitter impl] void QGraphicsWidget::childrenChanged()
  void emitter_QGraphicsWidget_childrenChanged_0()
  {
    emit QGraphicsWidget::childrenChanged();
  }

  //  [adaptor impl] bool QGraphicsWidget::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)
  bool cbs_collidesWithItem_c4977_1(const QGraphicsItem *other, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & mode) const
  {
    return QGraphicsWidget::collidesWithItem(other, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(mode).cref());
  }

  virtual bool collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode) const
  {
    if (cb_collidesWithItem_c4977_1.can_issue()) {
      return cb_collidesWithItem_c4977_1.issue<QGraphicsWidget_Adaptor, bool, const QGraphicsItem *, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &>(&QGraphicsWidget_Adaptor::cbs_collidesWithItem_c4977_1, other, qt_gsi::CppToQtAdaptor<Qt::ItemSelectionMode>(mode));
    } else {
      return QGraphicsWidget::collidesWithItem(other, mode);
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)
  bool cbs_collidesWithPath_c4877_1(const QPainterPath &path, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & mode) const
  {
    return QGraphicsWidget::collidesWithPath(path, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(mode).cref());
  }

  virtual bool collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode) const
  {
    if (cb_collidesWithPath_c4877_1.can_issue()) {
      return cb_collidesWithPath_c4877_1.issue<QGraphicsWidget_Adaptor, bool, const QPainterPath &, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &>(&QGraphicsWidget_Adaptor::cbs_collidesWithPath_c4877_1, path, qt_gsi::CppToQtAdaptor<Qt::ItemSelectionMode>(mode));
    } else {
      return QGraphicsWidget::collidesWithPath(path, mode);
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::contains(const QPointF &point)
  bool cbs_contains_c1986_0(const QPointF &point) const
  {
    return QGraphicsWidget::contains(point);
  }

  virtual bool contains(const QPointF &point) const
  {
    if (cb_contains_c1986_0.can_issue()) {
      return cb_contains_c1986_0.issue<QGraphicsWidget_Adaptor, bool, const QPointF &>(&QGraphicsWidget_Adaptor::cbs_contains_c1986_0, point);
    } else {
      return QGraphicsWidget::contains(point);
    }
  }

  //  [emitter impl] void QGraphicsWidget::destroyed(QObject *)
  void emitter_QGraphicsWidget_destroyed_1302(QObject *arg1)
  {
    emit QGraphicsWidget::destroyed(arg1);
  }

  //  [emitter impl] void QGraphicsWidget::enabledChanged()
  void emitter_QGraphicsWidget_enabledChanged_0()
  {
    emit QGraphicsWidget::enabledChanged();
  }

  //  [adaptor impl] bool QGraphicsWidget::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QGraphicsWidget::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsWidget_Adaptor, bool, QObject *, QEvent *>(&QGraphicsWidget_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QGraphicsWidget::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QGraphicsWidget::geometryChanged()
  void emitter_QGraphicsWidget_geometryChanged_0()
  {
    emit QGraphicsWidget::geometryChanged();
  }

  //  [adaptor impl] void QGraphicsWidget::getContentsMargins(double *left, double *top, double *right, double *bottom)
  void cbs_getContentsMargins_c4704_0(double *left, double *top, double *right, double *bottom) const
  {
    QGraphicsWidget::getContentsMargins(left, top, right, bottom);
  }

  virtual void getContentsMargins(double *left, double *top, double *right, double *bottom) const
  {
    if (cb_getContentsMargins_c4704_0.can_issue()) {
      cb_getContentsMargins_c4704_0.issue<QGraphicsWidget_Adaptor, double *, double *, double *, double *>(&QGraphicsWidget_Adaptor::cbs_getContentsMargins_c4704_0, left, top, right, bottom);
    } else {
      QGraphicsWidget::getContentsMargins(left, top, right, bottom);
    }
  }

  //  [emitter impl] void QGraphicsWidget::heightChanged()
  void emitter_QGraphicsWidget_heightChanged_0()
  {
    emit QGraphicsWidget::heightChanged();
  }

  //  [adaptor impl] bool QGraphicsWidget::isObscuredBy(const QGraphicsItem *item)
  bool cbs_isObscuredBy_c2614_0(const QGraphicsItem *item) const
  {
    return QGraphicsWidget::isObscuredBy(item);
  }

  virtual bool isObscuredBy(const QGraphicsItem *item) const
  {
    if (cb_isObscuredBy_c2614_0.can_issue()) {
      return cb_isObscuredBy_c2614_0.issue<QGraphicsWidget_Adaptor, bool, const QGraphicsItem *>(&QGraphicsWidget_Adaptor::cbs_isObscuredBy_c2614_0, item);
    } else {
      return QGraphicsWidget::isObscuredBy(item);
    }
  }

  //  [emitter impl] void QGraphicsWidget::layoutChanged()
  void emitter_QGraphicsWidget_layoutChanged_0()
  {
    emit QGraphicsWidget::layoutChanged();
  }

  //  [emitter impl] void QGraphicsWidget::objectNameChanged(const QString &objectName)
  void emitter_QGraphicsWidget_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QGraphicsWidget::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QGraphicsWidget::opacityChanged()
  void emitter_QGraphicsWidget_opacityChanged_0()
  {
    emit QGraphicsWidget::opacityChanged();
  }

  //  [adaptor impl] QPainterPath QGraphicsWidget::opaqueArea()
  QPainterPath cbs_opaqueArea_c0_0() const
  {
    return QGraphicsWidget::opaqueArea();
  }

  virtual QPainterPath opaqueArea() const
  {
    if (cb_opaqueArea_c0_0.can_issue()) {
      return cb_opaqueArea_c0_0.issue<QGraphicsWidget_Adaptor, QPainterPath>(&QGraphicsWidget_Adaptor::cbs_opaqueArea_c0_0);
    } else {
      return QGraphicsWidget::opaqueArea();
    }
  }

  //  [adaptor impl] void QGraphicsWidget::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  void cbs_paint_6301_1(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    QGraphicsWidget::paint(painter, option, widget);
  }

  virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    if (cb_paint_6301_1.can_issue()) {
      cb_paint_6301_1.issue<QGraphicsWidget_Adaptor, QPainter *, const QStyleOptionGraphicsItem *, QWidget *>(&QGraphicsWidget_Adaptor::cbs_paint_6301_1, painter, option, widget);
    } else {
      QGraphicsWidget::paint(painter, option, widget);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::paintWindowFrame(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  void cbs_paintWindowFrame_6301_1(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    QGraphicsWidget::paintWindowFrame(painter, option, widget);
  }

  virtual void paintWindowFrame(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    if (cb_paintWindowFrame_6301_1.can_issue()) {
      cb_paintWindowFrame_6301_1.issue<QGraphicsWidget_Adaptor, QPainter *, const QStyleOptionGraphicsItem *, QWidget *>(&QGraphicsWidget_Adaptor::cbs_paintWindowFrame_6301_1, painter, option, widget);
    } else {
      QGraphicsWidget::paintWindowFrame(painter, option, widget);
    }
  }

  //  [emitter impl] void QGraphicsWidget::parentChanged()
  void emitter_QGraphicsWidget_parentChanged_0()
  {
    emit QGraphicsWidget::parentChanged();
  }

  //  [emitter impl] void QGraphicsWidget::rotationChanged()
  void emitter_QGraphicsWidget_rotationChanged_0()
  {
    emit QGraphicsWidget::rotationChanged();
  }

  //  [emitter impl] void QGraphicsWidget::scaleChanged()
  void emitter_QGraphicsWidget_scaleChanged_0()
  {
    emit QGraphicsWidget::scaleChanged();
  }

  //  [adaptor impl] void QGraphicsWidget::setGeometry(const QRectF &rect)
  void cbs_setGeometry_1862_0(const QRectF &rect)
  {
    QGraphicsWidget::setGeometry(rect);
  }

  virtual void setGeometry(const QRectF &rect)
  {
    if (cb_setGeometry_1862_0.can_issue()) {
      cb_setGeometry_1862_0.issue<QGraphicsWidget_Adaptor, const QRectF &>(&QGraphicsWidget_Adaptor::cbs_setGeometry_1862_0, rect);
    } else {
      QGraphicsWidget::setGeometry(rect);
    }
  }

  //  [adaptor impl] QPainterPath QGraphicsWidget::shape()
  QPainterPath cbs_shape_c0_0() const
  {
    return QGraphicsWidget::shape();
  }

  virtual QPainterPath shape() const
  {
    if (cb_shape_c0_0.can_issue()) {
      return cb_shape_c0_0.issue<QGraphicsWidget_Adaptor, QPainterPath>(&QGraphicsWidget_Adaptor::cbs_shape_c0_0);
    } else {
      return QGraphicsWidget::shape();
    }
  }

  //  [adaptor impl] int QGraphicsWidget::type()
  int cbs_type_c0_0() const
  {
    return QGraphicsWidget::type();
  }

  virtual int type() const
  {
    if (cb_type_c0_0.can_issue()) {
      return cb_type_c0_0.issue<QGraphicsWidget_Adaptor, int>(&QGraphicsWidget_Adaptor::cbs_type_c0_0);
    } else {
      return QGraphicsWidget::type();
    }
  }

  //  [emitter impl] void QGraphicsWidget::visibleChanged()
  void emitter_QGraphicsWidget_visibleChanged_0()
  {
    emit QGraphicsWidget::visibleChanged();
  }

  //  [emitter impl] void QGraphicsWidget::widthChanged()
  void emitter_QGraphicsWidget_widthChanged_0()
  {
    emit QGraphicsWidget::widthChanged();
  }

  //  [emitter impl] void QGraphicsWidget::xChanged()
  void emitter_QGraphicsWidget_xChanged_0()
  {
    emit QGraphicsWidget::xChanged();
  }

  //  [emitter impl] void QGraphicsWidget::yChanged()
  void emitter_QGraphicsWidget_yChanged_0()
  {
    emit QGraphicsWidget::yChanged();
  }

  //  [emitter impl] void QGraphicsWidget::zChanged()
  void emitter_QGraphicsWidget_zChanged_0()
  {
    emit QGraphicsWidget::zChanged();
  }

  //  [adaptor impl] void QGraphicsWidget::changeEvent(QEvent *event)
  void cbs_changeEvent_1217_0(QEvent *event)
  {
    QGraphicsWidget::changeEvent(event);
  }

  virtual void changeEvent(QEvent *event)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QGraphicsWidget_Adaptor, QEvent *>(&QGraphicsWidget_Adaptor::cbs_changeEvent_1217_0, event);
    } else {
      QGraphicsWidget::changeEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QGraphicsWidget::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsWidget_Adaptor, QChildEvent *>(&QGraphicsWidget_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QGraphicsWidget::childEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::closeEvent(QCloseEvent *event)
  void cbs_closeEvent_1719_0(QCloseEvent *event)
  {
    QGraphicsWidget::closeEvent(event);
  }

  virtual void closeEvent(QCloseEvent *event)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QGraphicsWidget_Adaptor, QCloseEvent *>(&QGraphicsWidget_Adaptor::cbs_closeEvent_1719_0, event);
    } else {
      QGraphicsWidget::closeEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  void cbs_contextMenuEvent_3674_0(QGraphicsSceneContextMenuEvent *event)
  {
    QGraphicsWidget::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_3674_0.can_issue()) {
      cb_contextMenuEvent_3674_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneContextMenuEvent *>(&QGraphicsWidget_Adaptor::cbs_contextMenuEvent_3674_0, event);
    } else {
      QGraphicsWidget::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QGraphicsWidget::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsWidget_Adaptor, QEvent *>(&QGraphicsWidget_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QGraphicsWidget::customEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QGraphicsWidget::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QGraphicsWidget_Adaptor, const QMetaMethod &>(&QGraphicsWidget_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QGraphicsWidget::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragEnterEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsWidget::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragEnterEvent_3315_0.can_issue()) {
      cb_dragEnterEvent_3315_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsWidget_Adaptor::cbs_dragEnterEvent_3315_0, event);
    } else {
      QGraphicsWidget::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragLeaveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsWidget::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragLeaveEvent_3315_0.can_issue()) {
      cb_dragLeaveEvent_3315_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsWidget_Adaptor::cbs_dragLeaveEvent_3315_0, event);
    } else {
      QGraphicsWidget::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragMoveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsWidget::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragMoveEvent_3315_0.can_issue()) {
      cb_dragMoveEvent_3315_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsWidget_Adaptor::cbs_dragMoveEvent_3315_0, event);
    } else {
      QGraphicsWidget::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::dropEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dropEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsWidget::dropEvent(event);
  }

  virtual void dropEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dropEvent_3315_0.can_issue()) {
      cb_dropEvent_3315_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsWidget_Adaptor::cbs_dropEvent_3315_0, event);
    } else {
      QGraphicsWidget::dropEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QGraphicsWidget::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsWidget_Adaptor, bool, QEvent *>(&QGraphicsWidget_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QGraphicsWidget::event(_event);
    }
  }

  //  [adaptor impl] QVariant QGraphicsWidget::extension(const QVariant &variant)
  QVariant cbs_extension_c2119_0(const QVariant &variant) const
  {
    return QGraphicsWidget::extension(variant);
  }

  virtual QVariant extension(const QVariant &variant) const
  {
    if (cb_extension_c2119_0.can_issue()) {
      return cb_extension_c2119_0.issue<QGraphicsWidget_Adaptor, QVariant, const QVariant &>(&QGraphicsWidget_Adaptor::cbs_extension_c2119_0, variant);
    } else {
      return QGraphicsWidget::extension(variant);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsWidget::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QGraphicsWidget_Adaptor, QFocusEvent *>(&QGraphicsWidget_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QGraphicsWidget::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QGraphicsWidget::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QGraphicsWidget_Adaptor, bool, bool>(&QGraphicsWidget_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QGraphicsWidget::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsWidget::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QGraphicsWidget_Adaptor, QFocusEvent *>(&QGraphicsWidget_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QGraphicsWidget::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::grabKeyboardEvent(QEvent *event)
  void cbs_grabKeyboardEvent_1217_0(QEvent *event)
  {
    QGraphicsWidget::grabKeyboardEvent(event);
  }

  virtual void grabKeyboardEvent(QEvent *event)
  {
    if (cb_grabKeyboardEvent_1217_0.can_issue()) {
      cb_grabKeyboardEvent_1217_0.issue<QGraphicsWidget_Adaptor, QEvent *>(&QGraphicsWidget_Adaptor::cbs_grabKeyboardEvent_1217_0, event);
    } else {
      QGraphicsWidget::grabKeyboardEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::grabMouseEvent(QEvent *event)
  void cbs_grabMouseEvent_1217_0(QEvent *event)
  {
    QGraphicsWidget::grabMouseEvent(event);
  }

  virtual void grabMouseEvent(QEvent *event)
  {
    if (cb_grabMouseEvent_1217_0.can_issue()) {
      cb_grabMouseEvent_1217_0.issue<QGraphicsWidget_Adaptor, QEvent *>(&QGraphicsWidget_Adaptor::cbs_grabMouseEvent_1217_0, event);
    } else {
      QGraphicsWidget::grabMouseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::hideEvent(QHideEvent *event)
  void cbs_hideEvent_1595_0(QHideEvent *event)
  {
    QGraphicsWidget::hideEvent(event);
  }

  virtual void hideEvent(QHideEvent *event)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QGraphicsWidget_Adaptor, QHideEvent *>(&QGraphicsWidget_Adaptor::cbs_hideEvent_1595_0, event);
    } else {
      QGraphicsWidget::hideEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::hoverEnterEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverEnterEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsWidget::hoverEnterEvent(event);
  }

  virtual void hoverEnterEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverEnterEvent_3044_0.can_issue()) {
      cb_hoverEnterEvent_3044_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsWidget_Adaptor::cbs_hoverEnterEvent_3044_0, event);
    } else {
      QGraphicsWidget::hoverEnterEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverLeaveEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsWidget::hoverLeaveEvent(event);
  }

  virtual void hoverLeaveEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverLeaveEvent_3044_0.can_issue()) {
      cb_hoverLeaveEvent_3044_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsWidget_Adaptor::cbs_hoverLeaveEvent_3044_0, event);
    } else {
      QGraphicsWidget::hoverLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::hoverMoveEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverMoveEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsWidget::hoverMoveEvent(event);
  }

  virtual void hoverMoveEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverMoveEvent_3044_0.can_issue()) {
      cb_hoverMoveEvent_3044_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsWidget_Adaptor::cbs_hoverMoveEvent_3044_0, event);
    } else {
      QGraphicsWidget::hoverMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::initStyleOption(QStyleOption *option)
  void cbs_initStyleOption_c1865_0(QStyleOption *option) const
  {
    QGraphicsWidget::initStyleOption(option);
  }

  virtual void initStyleOption(QStyleOption *option) const
  {
    if (cb_initStyleOption_c1865_0.can_issue()) {
      cb_initStyleOption_c1865_0.issue<QGraphicsWidget_Adaptor, QStyleOption *>(&QGraphicsWidget_Adaptor::cbs_initStyleOption_c1865_0, option);
    } else {
      QGraphicsWidget::initStyleOption(option);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QGraphicsWidget::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QGraphicsWidget_Adaptor, QInputMethodEvent *>(&QGraphicsWidget_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QGraphicsWidget::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] QVariant QGraphicsWidget::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QGraphicsWidget::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QGraphicsWidget_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QGraphicsWidget_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QGraphicsWidget::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] QVariant QGraphicsWidget::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)
  QVariant cbs_itemChange_5658_0(const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & change, const QVariant &value)
  {
    return QGraphicsWidget::itemChange(qt_gsi::QtToCppAdaptor<QGraphicsItem::GraphicsItemChange>(change).cref(), value);
  }

  virtual QVariant itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)
  {
    if (cb_itemChange_5658_0.can_issue()) {
      return cb_itemChange_5658_0.issue<QGraphicsWidget_Adaptor, QVariant, const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type &, const QVariant &>(&QGraphicsWidget_Adaptor::cbs_itemChange_5658_0, qt_gsi::CppToQtAdaptor<QGraphicsItem::GraphicsItemChange>(change), value);
    } else {
      return QGraphicsWidget::itemChange(change, value);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsWidget::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QGraphicsWidget_Adaptor, QKeyEvent *>(&QGraphicsWidget_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QGraphicsWidget::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsWidget::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QGraphicsWidget_Adaptor, QKeyEvent *>(&QGraphicsWidget_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QGraphicsWidget::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseDoubleClickEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsWidget::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_3049_0.can_issue()) {
      cb_mouseDoubleClickEvent_3049_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsWidget_Adaptor::cbs_mouseDoubleClickEvent_3049_0, event);
    } else {
      QGraphicsWidget::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseMoveEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsWidget::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseMoveEvent_3049_0.can_issue()) {
      cb_mouseMoveEvent_3049_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsWidget_Adaptor::cbs_mouseMoveEvent_3049_0, event);
    } else {
      QGraphicsWidget::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::mousePressEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mousePressEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsWidget::mousePressEvent(event);
  }

  virtual void mousePressEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mousePressEvent_3049_0.can_issue()) {
      cb_mousePressEvent_3049_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsWidget_Adaptor::cbs_mousePressEvent_3049_0, event);
    } else {
      QGraphicsWidget::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseReleaseEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsWidget::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_3049_0.can_issue()) {
      cb_mouseReleaseEvent_3049_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsWidget_Adaptor::cbs_mouseReleaseEvent_3049_0, event);
    } else {
      QGraphicsWidget::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::moveEvent(QGraphicsSceneMoveEvent *event)
  void cbs_moveEvent_2935_0(QGraphicsSceneMoveEvent *event)
  {
    QGraphicsWidget::moveEvent(event);
  }

  virtual void moveEvent(QGraphicsSceneMoveEvent *event)
  {
    if (cb_moveEvent_2935_0.can_issue()) {
      cb_moveEvent_2935_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneMoveEvent *>(&QGraphicsWidget_Adaptor::cbs_moveEvent_2935_0, event);
    } else {
      QGraphicsWidget::moveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::polishEvent()
  void cbs_polishEvent_0_0()
  {
    QGraphicsWidget::polishEvent();
  }

  virtual void polishEvent()
  {
    if (cb_polishEvent_0_0.can_issue()) {
      cb_polishEvent_0_0.issue<QGraphicsWidget_Adaptor>(&QGraphicsWidget_Adaptor::cbs_polishEvent_0_0);
    } else {
      QGraphicsWidget::polishEvent();
    }
  }

  //  [adaptor impl] QVariant QGraphicsWidget::propertyChange(const QString &propertyName, const QVariant &value)
  QVariant cbs_propertyChange_4036_0(const QString &propertyName, const QVariant &value)
  {
    return QGraphicsWidget::propertyChange(propertyName, value);
  }

  virtual QVariant propertyChange(const QString &propertyName, const QVariant &value)
  {
    if (cb_propertyChange_4036_0.can_issue()) {
      return cb_propertyChange_4036_0.issue<QGraphicsWidget_Adaptor, QVariant, const QString &, const QVariant &>(&QGraphicsWidget_Adaptor::cbs_propertyChange_4036_0, propertyName, value);
    } else {
      return QGraphicsWidget::propertyChange(propertyName, value);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::resizeEvent(QGraphicsSceneResizeEvent *event)
  void cbs_resizeEvent_3154_0(QGraphicsSceneResizeEvent *event)
  {
    QGraphicsWidget::resizeEvent(event);
  }

  virtual void resizeEvent(QGraphicsSceneResizeEvent *event)
  {
    if (cb_resizeEvent_3154_0.can_issue()) {
      cb_resizeEvent_3154_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneResizeEvent *>(&QGraphicsWidget_Adaptor::cbs_resizeEvent_3154_0, event);
    } else {
      QGraphicsWidget::resizeEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::sceneEvent(QEvent *event)
  bool cbs_sceneEvent_1217_0(QEvent *event)
  {
    return QGraphicsWidget::sceneEvent(event);
  }

  virtual bool sceneEvent(QEvent *event)
  {
    if (cb_sceneEvent_1217_0.can_issue()) {
      return cb_sceneEvent_1217_0.issue<QGraphicsWidget_Adaptor, bool, QEvent *>(&QGraphicsWidget_Adaptor::cbs_sceneEvent_1217_0, event);
    } else {
      return QGraphicsWidget::sceneEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::sceneEventFilter(QGraphicsItem *watched, QEvent *event)
  bool cbs_sceneEventFilter_3028_0(QGraphicsItem *watched, QEvent *event)
  {
    return QGraphicsWidget::sceneEventFilter(watched, event);
  }

  virtual bool sceneEventFilter(QGraphicsItem *watched, QEvent *event)
  {
    if (cb_sceneEventFilter_3028_0.can_issue()) {
      return cb_sceneEventFilter_3028_0.issue<QGraphicsWidget_Adaptor, bool, QGraphicsItem *, QEvent *>(&QGraphicsWidget_Adaptor::cbs_sceneEventFilter_3028_0, watched, event);
    } else {
      return QGraphicsWidget::sceneEventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)
  void cbs_setExtension_4817_0(unsigned int extension, const QVariant &variant)
  {
    QGraphicsWidget::setExtension(QGraphicsItem::Extension(extension), variant);
  }

  virtual void setExtension(QGraphicsItem::Extension extension, const QVariant &variant)
  {
    if (cb_setExtension_4817_0.can_issue()) {
      cb_setExtension_4817_0.issue<QGraphicsWidget_Adaptor, unsigned int, const QVariant &>(&QGraphicsWidget_Adaptor::cbs_setExtension_4817_0, (unsigned int)(extension), variant);
    } else {
      QGraphicsWidget::setExtension(extension, variant);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::showEvent(QShowEvent *event)
  void cbs_showEvent_1634_0(QShowEvent *event)
  {
    QGraphicsWidget::showEvent(event);
  }

  virtual void showEvent(QShowEvent *event)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QGraphicsWidget_Adaptor, QShowEvent *>(&QGraphicsWidget_Adaptor::cbs_showEvent_1634_0, event);
    } else {
      QGraphicsWidget::showEvent(event);
    }
  }

  //  [adaptor impl] QSizeF QGraphicsWidget::sizeHint(Qt::SizeHint which, const QSizeF &constraint)
  QSizeF cbs_sizeHint_c3330_1(const qt_gsi::Converter<Qt::SizeHint>::target_type & which, const QSizeF &constraint) const
  {
    return QGraphicsWidget::sizeHint(qt_gsi::QtToCppAdaptor<Qt::SizeHint>(which).cref(), constraint);
  }

  virtual QSizeF sizeHint(Qt::SizeHint which, const QSizeF &constraint) const
  {
    if (cb_sizeHint_c3330_1.can_issue()) {
      return cb_sizeHint_c3330_1.issue<QGraphicsWidget_Adaptor, QSizeF, const qt_gsi::Converter<Qt::SizeHint>::target_type &, const QSizeF &>(&QGraphicsWidget_Adaptor::cbs_sizeHint_c3330_1, qt_gsi::CppToQtAdaptor<Qt::SizeHint>(which), constraint);
    } else {
      return QGraphicsWidget::sizeHint(which, constraint);
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::supportsExtension(QGraphicsItem::Extension extension)
  bool cbs_supportsExtension_c2806_0(unsigned int extension) const
  {
    return QGraphicsWidget::supportsExtension(QGraphicsItem::Extension(extension));
  }

  virtual bool supportsExtension(QGraphicsItem::Extension extension) const
  {
    if (cb_supportsExtension_c2806_0.can_issue()) {
      return cb_supportsExtension_c2806_0.issue<QGraphicsWidget_Adaptor, bool, unsigned int>(&QGraphicsWidget_Adaptor::cbs_supportsExtension_c2806_0, (unsigned int)(extension));
    } else {
      return QGraphicsWidget::supportsExtension(extension);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QGraphicsWidget::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsWidget_Adaptor, QTimerEvent *>(&QGraphicsWidget_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QGraphicsWidget::timerEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::ungrabKeyboardEvent(QEvent *event)
  void cbs_ungrabKeyboardEvent_1217_0(QEvent *event)
  {
    QGraphicsWidget::ungrabKeyboardEvent(event);
  }

  virtual void ungrabKeyboardEvent(QEvent *event)
  {
    if (cb_ungrabKeyboardEvent_1217_0.can_issue()) {
      cb_ungrabKeyboardEvent_1217_0.issue<QGraphicsWidget_Adaptor, QEvent *>(&QGraphicsWidget_Adaptor::cbs_ungrabKeyboardEvent_1217_0, event);
    } else {
      QGraphicsWidget::ungrabKeyboardEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::ungrabMouseEvent(QEvent *event)
  void cbs_ungrabMouseEvent_1217_0(QEvent *event)
  {
    QGraphicsWidget::ungrabMouseEvent(event);
  }

  virtual void ungrabMouseEvent(QEvent *event)
  {
    if (cb_ungrabMouseEvent_1217_0.can_issue()) {
      cb_ungrabMouseEvent_1217_0.issue<QGraphicsWidget_Adaptor, QEvent *>(&QGraphicsWidget_Adaptor::cbs_ungrabMouseEvent_1217_0, event);
    } else {
      QGraphicsWidget::ungrabMouseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::updateGeometry()
  void cbs_updateGeometry_0_0()
  {
    QGraphicsWidget::updateGeometry();
  }

  virtual void updateGeometry()
  {
    if (cb_updateGeometry_0_0.can_issue()) {
      cb_updateGeometry_0_0.issue<QGraphicsWidget_Adaptor>(&QGraphicsWidget_Adaptor::cbs_updateGeometry_0_0);
    } else {
      QGraphicsWidget::updateGeometry();
    }
  }

  //  [adaptor impl] void QGraphicsWidget::wheelEvent(QGraphicsSceneWheelEvent *event)
  void cbs_wheelEvent_3029_0(QGraphicsSceneWheelEvent *event)
  {
    QGraphicsWidget::wheelEvent(event);
  }

  virtual void wheelEvent(QGraphicsSceneWheelEvent *event)
  {
    if (cb_wheelEvent_3029_0.can_issue()) {
      cb_wheelEvent_3029_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneWheelEvent *>(&QGraphicsWidget_Adaptor::cbs_wheelEvent_3029_0, event);
    } else {
      QGraphicsWidget::wheelEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::windowFrameEvent(QEvent *e)
  bool cbs_windowFrameEvent_1217_0(QEvent *e)
  {
    return QGraphicsWidget::windowFrameEvent(e);
  }

  virtual bool windowFrameEvent(QEvent *e)
  {
    if (cb_windowFrameEvent_1217_0.can_issue()) {
      return cb_windowFrameEvent_1217_0.issue<QGraphicsWidget_Adaptor, bool, QEvent *>(&QGraphicsWidget_Adaptor::cbs_windowFrameEvent_1217_0, e);
    } else {
      return QGraphicsWidget::windowFrameEvent(e);
    }
  }

  //  [adaptor impl] Qt::WindowFrameSection QGraphicsWidget::windowFrameSectionAt(const QPointF &pos)
  qt_gsi::Converter<Qt::WindowFrameSection>::target_type cbs_windowFrameSectionAt_c1986_0(const QPointF &pos) const
  {
    return qt_gsi::CppToQtAdaptor<Qt::WindowFrameSection>(QGraphicsWidget::windowFrameSectionAt(pos));
  }

  virtual Qt::WindowFrameSection windowFrameSectionAt(const QPointF &pos) const
  {
    if (cb_windowFrameSectionAt_c1986_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<Qt::WindowFrameSection>(cb_windowFrameSectionAt_c1986_0.issue<QGraphicsWidget_Adaptor, qt_gsi::Converter<Qt::WindowFrameSection>::target_type, const QPointF &>(&QGraphicsWidget_Adaptor::cbs_windowFrameSectionAt_c1986_0, pos)).cref();
    } else {
      return QGraphicsWidget::windowFrameSectionAt(pos);
    }
  }

  gsi::Callback cb_advance_767_0;
  gsi::Callback cb_boundingRect_c0_0;
  gsi::Callback cb_collidesWithItem_c4977_1;
  gsi::Callback cb_collidesWithPath_c4877_1;
  gsi::Callback cb_contains_c1986_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_getContentsMargins_c4704_0;
  gsi::Callback cb_isObscuredBy_c2614_0;
  gsi::Callback cb_opaqueArea_c0_0;
  gsi::Callback cb_paint_6301_1;
  gsi::Callback cb_paintWindowFrame_6301_1;
  gsi::Callback cb_setGeometry_1862_0;
  gsi::Callback cb_shape_c0_0;
  gsi::Callback cb_type_c0_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_3674_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_dragEnterEvent_3315_0;
  gsi::Callback cb_dragLeaveEvent_3315_0;
  gsi::Callback cb_dragMoveEvent_3315_0;
  gsi::Callback cb_dropEvent_3315_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_extension_c2119_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_grabKeyboardEvent_1217_0;
  gsi::Callback cb_grabMouseEvent_1217_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_hoverEnterEvent_3044_0;
  gsi::Callback cb_hoverLeaveEvent_3044_0;
  gsi::Callback cb_hoverMoveEvent_3044_0;
  gsi::Callback cb_initStyleOption_c1865_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_itemChange_5658_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_mouseDoubleClickEvent_3049_0;
  gsi::Callback cb_mouseMoveEvent_3049_0;
  gsi::Callback cb_mousePressEvent_3049_0;
  gsi::Callback cb_mouseReleaseEvent_3049_0;
  gsi::Callback cb_moveEvent_2935_0;
  gsi::Callback cb_polishEvent_0_0;
  gsi::Callback cb_propertyChange_4036_0;
  gsi::Callback cb_resizeEvent_3154_0;
  gsi::Callback cb_sceneEvent_1217_0;
  gsi::Callback cb_sceneEventFilter_3028_0;
  gsi::Callback cb_setExtension_4817_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_sizeHint_c3330_1;
  gsi::Callback cb_supportsExtension_c2806_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_ungrabKeyboardEvent_1217_0;
  gsi::Callback cb_ungrabMouseEvent_1217_0;
  gsi::Callback cb_updateGeometry_0_0;
  gsi::Callback cb_wheelEvent_3029_0;
  gsi::Callback cb_windowFrameEvent_1217_0;
  gsi::Callback cb_windowFrameSectionAt_c1986_0;
};

QGraphicsWidget_Adaptor::~QGraphicsWidget_Adaptor() { }

//  Constructor QGraphicsWidget::QGraphicsWidget(QGraphicsItem *parent, QFlags<Qt::WindowType> wFlags) (adaptor class)

static void _init_ctor_QGraphicsWidget_Adaptor_4306 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("wFlags", true, "Qt::WindowFlags()");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_1);
  decl->set_return_new<QGraphicsWidget_Adaptor> ();
}

static void _call_ctor_QGraphicsWidget_Adaptor_4306 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = args ? gsi::arg_reader<QGraphicsItem * >() (args, heap) : gsi::arg_maker<QGraphicsItem * >() (nullptr, heap);
  QFlags<Qt::WindowType> arg2 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (Qt::WindowFlags(), heap);
  ret.write<QGraphicsWidget_Adaptor *> (new QGraphicsWidget_Adaptor (arg1, arg2));
}


// exposed void QGraphicsWidget::addToIndex()

static void _init_fp_addToIndex_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_addToIndex_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->fp_QGraphicsWidget_addToIndex_0 ();
}


// void QGraphicsWidget::advance(int phase)

static void _init_cbs_advance_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("phase");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_advance_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_advance_767_0 (arg1);
}

static void _set_callback_cbs_advance_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_advance_767_0 = cb;
}


// QRectF QGraphicsWidget::boundingRect()

static void _init_cbs_boundingRect_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_cbs_boundingRect_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QGraphicsWidget_Adaptor *)cls)->cbs_boundingRect_c0_0 ());
}

static void _set_callback_cbs_boundingRect_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_boundingRect_c0_0 = cb;
}


// void QGraphicsWidget::changeEvent(QEvent *event)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QGraphicsWidget::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QGraphicsWidget::childrenChanged()

static void _init_emitter_childrenChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_childrenChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsWidget_Adaptor *)cls)->emitter_QGraphicsWidget_childrenChanged_0 ();
}


// void QGraphicsWidget::closeEvent(QCloseEvent *event)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// bool QGraphicsWidget::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)

static void _init_cbs_collidesWithItem_c4977_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_collidesWithItem_c4977_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > (heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (heap);
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_collidesWithItem_c4977_1 (arg1, arg2));
}

static void _set_callback_cbs_collidesWithItem_c4977_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_collidesWithItem_c4977_1 = cb;
}


// bool QGraphicsWidget::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)

static void _init_cbs_collidesWithPath_c4877_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_collidesWithPath_c4877_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = args.read<const QPainterPath & > (heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (heap);
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_collidesWithPath_c4877_1 (arg1, arg2));
}

static void _set_callback_cbs_collidesWithPath_c4877_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_collidesWithPath_c4877_1 = cb;
}


// bool QGraphicsWidget::contains(const QPointF &point)

static void _init_cbs_contains_c1986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_contains_c1986_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = args.read<const QPointF & > (heap);
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_contains_c1986_0 (arg1));
}

static void _set_callback_cbs_contains_c1986_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_contains_c1986_0 = cb;
}


// void QGraphicsWidget::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_3674_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_3674_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneContextMenuEvent *arg1 = args.read<QGraphicsSceneContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_contextMenuEvent_3674_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_3674_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_contextMenuEvent_3674_0 = cb;
}


// void QGraphicsWidget::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QGraphicsWidget::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QGraphicsWidget_Adaptor *)cls)->emitter_QGraphicsWidget_destroyed_1302 (arg1);
}


// void QGraphicsWidget::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QGraphicsWidget::dragEnterEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragEnterEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_dragEnterEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_dragEnterEvent_3315_0 = cb;
}


// void QGraphicsWidget::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragLeaveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_dragLeaveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_dragLeaveEvent_3315_0 = cb;
}


// void QGraphicsWidget::dragMoveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragMoveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_dragMoveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_dragMoveEvent_3315_0 = cb;
}


// void QGraphicsWidget::dropEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dropEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_dropEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dropEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_dropEvent_3315_0 = cb;
}


// emitter void QGraphicsWidget::enabledChanged()

static void _init_emitter_enabledChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_enabledChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsWidget_Adaptor *)cls)->emitter_QGraphicsWidget_enabledChanged_0 ();
}


// bool QGraphicsWidget::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QGraphicsWidget::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// QVariant QGraphicsWidget::extension(const QVariant &variant)

static void _init_cbs_extension_c2119_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("variant");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_extension_c2119_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = args.read<const QVariant & > (heap);
  ret.write<QVariant > ((QVariant)((QGraphicsWidget_Adaptor *)cls)->cbs_extension_c2119_0 (arg1));
}

static void _set_callback_cbs_extension_c2119_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_extension_c2119_0 = cb;
}


// void QGraphicsWidget::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// bool QGraphicsWidget::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QGraphicsWidget::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// emitter void QGraphicsWidget::geometryChanged()

static void _init_emitter_geometryChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_geometryChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsWidget_Adaptor *)cls)->emitter_QGraphicsWidget_geometryChanged_0 ();
}


// void QGraphicsWidget::getContentsMargins(double *left, double *top, double *right, double *bottom)

static void _init_cbs_getContentsMargins_c4704_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<double * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<double * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_getContentsMargins_c4704_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double *arg1 = args.read<double * > (heap);
  double *arg2 = args.read<double * > (heap);
  double *arg3 = args.read<double * > (heap);
  double *arg4 = args.read<double * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_getContentsMargins_c4704_0 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_getContentsMargins_c4704_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_getContentsMargins_c4704_0 = cb;
}


// void QGraphicsWidget::grabKeyboardEvent(QEvent *event)

static void _init_cbs_grabKeyboardEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_grabKeyboardEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_grabKeyboardEvent_1217_0 (arg1);
}

static void _set_callback_cbs_grabKeyboardEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_grabKeyboardEvent_1217_0 = cb;
}


// void QGraphicsWidget::grabMouseEvent(QEvent *event)

static void _init_cbs_grabMouseEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_grabMouseEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_grabMouseEvent_1217_0 (arg1);
}

static void _set_callback_cbs_grabMouseEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_grabMouseEvent_1217_0 = cb;
}


// emitter void QGraphicsWidget::heightChanged()

static void _init_emitter_heightChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_heightChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsWidget_Adaptor *)cls)->emitter_QGraphicsWidget_heightChanged_0 ();
}


// void QGraphicsWidget::hideEvent(QHideEvent *event)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QGraphicsWidget::hoverEnterEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverEnterEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverEnterEvent_3044_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_hoverEnterEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverEnterEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_hoverEnterEvent_3044_0 = cb;
}


// void QGraphicsWidget::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverLeaveEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverLeaveEvent_3044_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_hoverLeaveEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverLeaveEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_hoverLeaveEvent_3044_0 = cb;
}


// void QGraphicsWidget::hoverMoveEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverMoveEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverMoveEvent_3044_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_hoverMoveEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverMoveEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_hoverMoveEvent_3044_0 = cb;
}


// void QGraphicsWidget::initStyleOption(QStyleOption *option)

static void _init_cbs_initStyleOption_c1865_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOption * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initStyleOption_c1865_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyleOption *arg1 = args.read<QStyleOption * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_initStyleOption_c1865_0 (arg1);
}

static void _set_callback_cbs_initStyleOption_c1865_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_initStyleOption_c1865_0 = cb;
}


// void QGraphicsWidget::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QGraphicsWidget::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QGraphicsWidget_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// bool QGraphicsWidget::isObscuredBy(const QGraphicsItem *item)

static void _init_cbs_isObscuredBy_c2614_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isObscuredBy_c2614_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > (heap);
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_isObscuredBy_c2614_0 (arg1));
}

static void _set_callback_cbs_isObscuredBy_c2614_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_isObscuredBy_c2614_0 = cb;
}


// exposed bool QGraphicsWidget::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->fp_QGraphicsWidget_isSignalConnected_c2394 (arg1));
}


// QVariant QGraphicsWidget::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)

static void _init_cbs_itemChange_5658_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("change");
  decl->add_arg<const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_itemChange_5658_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & arg1 = args.read<const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  ret.write<QVariant > ((QVariant)((QGraphicsWidget_Adaptor *)cls)->cbs_itemChange_5658_0 (arg1, arg2));
}

static void _set_callback_cbs_itemChange_5658_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_itemChange_5658_0 = cb;
}


// void QGraphicsWidget::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QGraphicsWidget::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// emitter void QGraphicsWidget::layoutChanged()

static void _init_emitter_layoutChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_layoutChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsWidget_Adaptor *)cls)->emitter_QGraphicsWidget_layoutChanged_0 ();
}


// void QGraphicsWidget::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_mouseDoubleClickEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_mouseDoubleClickEvent_3049_0 = cb;
}


// void QGraphicsWidget::mouseMoveEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseMoveEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_mouseMoveEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_mouseMoveEvent_3049_0 = cb;
}


// void QGraphicsWidget::mousePressEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mousePressEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_mousePressEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_mousePressEvent_3049_0 = cb;
}


// void QGraphicsWidget::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_mouseReleaseEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_mouseReleaseEvent_3049_0 = cb;
}


// void QGraphicsWidget::moveEvent(QGraphicsSceneMoveEvent *event)

static void _init_cbs_moveEvent_2935_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_2935_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMoveEvent *arg1 = args.read<QGraphicsSceneMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_moveEvent_2935_0 (arg1);
}

static void _set_callback_cbs_moveEvent_2935_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_moveEvent_2935_0 = cb;
}


// emitter void QGraphicsWidget::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QGraphicsWidget_Adaptor *)cls)->emitter_QGraphicsWidget_objectNameChanged_4567 (arg1);
}


// emitter void QGraphicsWidget::opacityChanged()

static void _init_emitter_opacityChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_opacityChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsWidget_Adaptor *)cls)->emitter_QGraphicsWidget_opacityChanged_0 ();
}


// QPainterPath QGraphicsWidget::opaqueArea()

static void _init_cbs_opaqueArea_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_cbs_opaqueArea_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsWidget_Adaptor *)cls)->cbs_opaqueArea_c0_0 ());
}

static void _set_callback_cbs_opaqueArea_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_opaqueArea_c0_0 = cb;
}


// void QGraphicsWidget::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)

static void _init_cbs_paint_6301_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paint_6301_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QStyleOptionGraphicsItem *arg2 = args.read<const QStyleOptionGraphicsItem * > (heap);
  QWidget *arg3 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_paint_6301_1 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paint_6301_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_paint_6301_1 = cb;
}


// void QGraphicsWidget::paintWindowFrame(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)

static void _init_cbs_paintWindowFrame_6301_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paintWindowFrame_6301_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QStyleOptionGraphicsItem *arg2 = args.read<const QStyleOptionGraphicsItem * > (heap);
  QWidget *arg3 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_paintWindowFrame_6301_1 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paintWindowFrame_6301_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_paintWindowFrame_6301_1 = cb;
}


// emitter void QGraphicsWidget::parentChanged()

static void _init_emitter_parentChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_parentChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsWidget_Adaptor *)cls)->emitter_QGraphicsWidget_parentChanged_0 ();
}


// void QGraphicsWidget::polishEvent()

static void _init_cbs_polishEvent_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_polishEvent_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_polishEvent_0_0 ();
}

static void _set_callback_cbs_polishEvent_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_polishEvent_0_0 = cb;
}


// exposed void QGraphicsWidget::prepareGeometryChange()

static void _init_fp_prepareGeometryChange_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_prepareGeometryChange_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->fp_QGraphicsWidget_prepareGeometryChange_0 ();
}


// QVariant QGraphicsWidget::propertyChange(const QString &propertyName, const QVariant &value)

static void _init_cbs_propertyChange_4036_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("propertyName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_propertyChange_4036_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  ret.write<QVariant > ((QVariant)((QGraphicsWidget_Adaptor *)cls)->cbs_propertyChange_4036_0 (arg1, arg2));
}

static void _set_callback_cbs_propertyChange_4036_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_propertyChange_4036_0 = cb;
}


// exposed int QGraphicsWidget::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QGraphicsWidget_Adaptor *)cls)->fp_QGraphicsWidget_receivers_c1731 (arg1));
}


// exposed void QGraphicsWidget::removeFromIndex()

static void _init_fp_removeFromIndex_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_removeFromIndex_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->fp_QGraphicsWidget_removeFromIndex_0 ();
}


// void QGraphicsWidget::resizeEvent(QGraphicsSceneResizeEvent *event)

static void _init_cbs_resizeEvent_3154_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_3154_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneResizeEvent *arg1 = args.read<QGraphicsSceneResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_resizeEvent_3154_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_3154_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_resizeEvent_3154_0 = cb;
}


// emitter void QGraphicsWidget::rotationChanged()

static void _init_emitter_rotationChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_rotationChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsWidget_Adaptor *)cls)->emitter_QGraphicsWidget_rotationChanged_0 ();
}


// emitter void QGraphicsWidget::scaleChanged()

static void _init_emitter_scaleChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_scaleChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsWidget_Adaptor *)cls)->emitter_QGraphicsWidget_scaleChanged_0 ();
}


// bool QGraphicsWidget::sceneEvent(QEvent *event)

static void _init_cbs_sceneEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_sceneEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_sceneEvent_1217_0 (arg1));
}

static void _set_callback_cbs_sceneEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_sceneEvent_1217_0 = cb;
}


// bool QGraphicsWidget::sceneEventFilter(QGraphicsItem *watched, QEvent *event)

static void _init_cbs_sceneEventFilter_3028_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_sceneEventFilter_3028_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_sceneEventFilter_3028_0 (arg1, arg2));
}

static void _set_callback_cbs_sceneEventFilter_3028_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_sceneEventFilter_3028_0 = cb;
}


// exposed QObject *QGraphicsWidget::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QGraphicsWidget_Adaptor *)cls)->fp_QGraphicsWidget_sender_c0 ());
}


// exposed int QGraphicsWidget::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsWidget_Adaptor *)cls)->fp_QGraphicsWidget_senderSignalIndex_c0 ());
}


// void QGraphicsWidget::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)

static void _init_cbs_setExtension_4817_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extension");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("variant");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setExtension_4817_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = args.read<unsigned int > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_setExtension_4817_0 (arg1, arg2);
}

static void _set_callback_cbs_setExtension_4817_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_setExtension_4817_0 = cb;
}


// void QGraphicsWidget::setGeometry(const QRectF &rect)

static void _init_cbs_setGeometry_1862_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setGeometry_1862_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args.read<const QRectF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_setGeometry_1862_0 (arg1);
}

static void _set_callback_cbs_setGeometry_1862_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_setGeometry_1862_0 = cb;
}


// exposed void QGraphicsWidget::setGraphicsItem(QGraphicsItem *item)

static void _init_fp_setGraphicsItem_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setGraphicsItem_1919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = gsi::arg_reader<QGraphicsItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->fp_QGraphicsWidget_setGraphicsItem_1919 (arg1);
}


// exposed void QGraphicsWidget::setOwnedByLayout(bool ownedByLayout)

static void _init_fp_setOwnedByLayout_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ownedByLayout");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setOwnedByLayout_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->fp_QGraphicsWidget_setOwnedByLayout_864 (arg1);
}


// QPainterPath QGraphicsWidget::shape()

static void _init_cbs_shape_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_cbs_shape_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsWidget_Adaptor *)cls)->cbs_shape_c0_0 ());
}

static void _set_callback_cbs_shape_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_shape_c0_0 = cb;
}


// void QGraphicsWidget::showEvent(QShowEvent *event)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSizeF QGraphicsWidget::sizeHint(Qt::SizeHint which, const QSizeF &constraint)

static void _init_cbs_sizeHint_c3330_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<Qt::SizeHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("constraint");
  decl->add_arg<const QSizeF & > (argspec_1);
  decl->set_return<QSizeF > ();
}

static void _call_cbs_sizeHint_c3330_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SizeHint>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::SizeHint>::target_type & > (heap);
  const QSizeF &arg2 = args.read<const QSizeF & > (heap);
  ret.write<QSizeF > ((QSizeF)((QGraphicsWidget_Adaptor *)cls)->cbs_sizeHint_c3330_1 (arg1, arg2));
}

static void _set_callback_cbs_sizeHint_c3330_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_sizeHint_c3330_1 = cb;
}


// bool QGraphicsWidget::supportsExtension(QGraphicsItem::Extension extension)

static void _init_cbs_supportsExtension_c2806_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extension");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_supportsExtension_c2806_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = args.read<unsigned int > (heap);
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_supportsExtension_c2806_0 (arg1));
}

static void _set_callback_cbs_supportsExtension_c2806_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_supportsExtension_c2806_0 = cb;
}


// void QGraphicsWidget::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// int QGraphicsWidget::type()

static void _init_cbs_type_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_type_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsWidget_Adaptor *)cls)->cbs_type_c0_0 ());
}

static void _set_callback_cbs_type_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_type_c0_0 = cb;
}


// void QGraphicsWidget::ungrabKeyboardEvent(QEvent *event)

static void _init_cbs_ungrabKeyboardEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_ungrabKeyboardEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_ungrabKeyboardEvent_1217_0 (arg1);
}

static void _set_callback_cbs_ungrabKeyboardEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_ungrabKeyboardEvent_1217_0 = cb;
}


// void QGraphicsWidget::ungrabMouseEvent(QEvent *event)

static void _init_cbs_ungrabMouseEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_ungrabMouseEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_ungrabMouseEvent_1217_0 (arg1);
}

static void _set_callback_cbs_ungrabMouseEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_ungrabMouseEvent_1217_0 = cb;
}


// void QGraphicsWidget::updateGeometry()

static void _init_cbs_updateGeometry_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateGeometry_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_updateGeometry_0_0 ();
}

static void _set_callback_cbs_updateGeometry_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_updateGeometry_0_0 = cb;
}


// exposed void QGraphicsWidget::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->fp_QGraphicsWidget_updateMicroFocus_0 ();
}


// emitter void QGraphicsWidget::visibleChanged()

static void _init_emitter_visibleChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_visibleChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsWidget_Adaptor *)cls)->emitter_QGraphicsWidget_visibleChanged_0 ();
}


// void QGraphicsWidget::wheelEvent(QGraphicsSceneWheelEvent *event)

static void _init_cbs_wheelEvent_3029_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_3029_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneWheelEvent *arg1 = args.read<QGraphicsSceneWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsWidget_Adaptor *)cls)->cbs_wheelEvent_3029_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_3029_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_wheelEvent_3029_0 = cb;
}


// emitter void QGraphicsWidget::widthChanged()

static void _init_emitter_widthChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_widthChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsWidget_Adaptor *)cls)->emitter_QGraphicsWidget_widthChanged_0 ();
}


// bool QGraphicsWidget::windowFrameEvent(QEvent *e)

static void _init_cbs_windowFrameEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_windowFrameEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_windowFrameEvent_1217_0 (arg1));
}

static void _set_callback_cbs_windowFrameEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_windowFrameEvent_1217_0 = cb;
}


// Qt::WindowFrameSection QGraphicsWidget::windowFrameSectionAt(const QPointF &pos)

static void _init_cbs_windowFrameSectionAt_c1986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<qt_gsi::Converter<Qt::WindowFrameSection>::target_type > ();
}

static void _call_cbs_windowFrameSectionAt_c1986_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = args.read<const QPointF & > (heap);
  ret.write<qt_gsi::Converter<Qt::WindowFrameSection>::target_type > ((qt_gsi::Converter<Qt::WindowFrameSection>::target_type)((QGraphicsWidget_Adaptor *)cls)->cbs_windowFrameSectionAt_c1986_0 (arg1));
}

static void _set_callback_cbs_windowFrameSectionAt_c1986_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_windowFrameSectionAt_c1986_0 = cb;
}


// emitter void QGraphicsWidget::xChanged()

static void _init_emitter_xChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_xChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsWidget_Adaptor *)cls)->emitter_QGraphicsWidget_xChanged_0 ();
}


// emitter void QGraphicsWidget::yChanged()

static void _init_emitter_yChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_yChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsWidget_Adaptor *)cls)->emitter_QGraphicsWidget_yChanged_0 ();
}


// emitter void QGraphicsWidget::zChanged()

static void _init_emitter_zChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_zChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsWidget_Adaptor *)cls)->emitter_QGraphicsWidget_zChanged_0 ();
}


namespace gsi
{

gsi::Class<QGraphicsWidget> &qtdecl_QGraphicsWidget ();

static gsi::Methods methods_QGraphicsWidget_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsWidget::QGraphicsWidget(QGraphicsItem *parent, QFlags<Qt::WindowType> wFlags)\nThis method creates an object of class QGraphicsWidget.", &_init_ctor_QGraphicsWidget_Adaptor_4306, &_call_ctor_QGraphicsWidget_Adaptor_4306);
  methods += new qt_gsi::GenericMethod ("*addToIndex", "@brief Method void QGraphicsWidget::addToIndex()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addToIndex_0, &_call_fp_addToIndex_0);
  methods += new qt_gsi::GenericMethod ("advance", "@brief Virtual method void QGraphicsWidget::advance(int phase)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_advance_767_0, &_call_cbs_advance_767_0);
  methods += new qt_gsi::GenericMethod ("advance", "@hide", false, &_init_cbs_advance_767_0, &_call_cbs_advance_767_0, &_set_callback_cbs_advance_767_0);
  methods += new qt_gsi::GenericMethod ("boundingRect", "@brief Virtual method QRectF QGraphicsWidget::boundingRect()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_boundingRect_c0_0, &_call_cbs_boundingRect_c0_0);
  methods += new qt_gsi::GenericMethod ("boundingRect", "@hide", true, &_init_cbs_boundingRect_c0_0, &_call_cbs_boundingRect_c0_0, &_set_callback_cbs_boundingRect_c0_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QGraphicsWidget::changeEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsWidget::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_childrenChanged", "@brief Emitter for signal void QGraphicsWidget::childrenChanged()\nCall this method to emit this signal.", false, &_init_emitter_childrenChanged_0, &_call_emitter_childrenChanged_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QGraphicsWidget::closeEvent(QCloseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("collidesWithItem", "@brief Virtual method bool QGraphicsWidget::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_collidesWithItem_c4977_1, &_call_cbs_collidesWithItem_c4977_1);
  methods += new qt_gsi::GenericMethod ("collidesWithItem", "@hide", true, &_init_cbs_collidesWithItem_c4977_1, &_call_cbs_collidesWithItem_c4977_1, &_set_callback_cbs_collidesWithItem_c4977_1);
  methods += new qt_gsi::GenericMethod ("collidesWithPath", "@brief Virtual method bool QGraphicsWidget::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_collidesWithPath_c4877_1, &_call_cbs_collidesWithPath_c4877_1);
  methods += new qt_gsi::GenericMethod ("collidesWithPath", "@hide", true, &_init_cbs_collidesWithPath_c4877_1, &_call_cbs_collidesWithPath_c4877_1, &_set_callback_cbs_collidesWithPath_c4877_1);
  methods += new qt_gsi::GenericMethod ("contains", "@brief Virtual method bool QGraphicsWidget::contains(const QPointF &point)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_contains_c1986_0, &_call_cbs_contains_c1986_0);
  methods += new qt_gsi::GenericMethod ("contains", "@hide", true, &_init_cbs_contains_c1986_0, &_call_cbs_contains_c1986_0, &_set_callback_cbs_contains_c1986_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QGraphicsWidget::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0, &_set_callback_cbs_contextMenuEvent_3674_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsWidget::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QGraphicsWidget::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsWidget::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QGraphicsWidget::dragEnterEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0, &_set_callback_cbs_dragEnterEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QGraphicsWidget::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0, &_set_callback_cbs_dragLeaveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QGraphicsWidget::dragMoveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0, &_set_callback_cbs_dragMoveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QGraphicsWidget::dropEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0, &_set_callback_cbs_dropEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("emit_enabledChanged", "@brief Emitter for signal void QGraphicsWidget::enabledChanged()\nCall this method to emit this signal.", false, &_init_emitter_enabledChanged_0, &_call_emitter_enabledChanged_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QGraphicsWidget::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QGraphicsWidget::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*extension", "@brief Virtual method QVariant QGraphicsWidget::extension(const QVariant &variant)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_extension_c2119_0, &_call_cbs_extension_c2119_0);
  methods += new qt_gsi::GenericMethod ("*extension", "@hide", true, &_init_cbs_extension_c2119_0, &_call_cbs_extension_c2119_0, &_set_callback_cbs_extension_c2119_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QGraphicsWidget::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QGraphicsWidget::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QGraphicsWidget::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("emit_geometryChanged", "@brief Emitter for signal void QGraphicsWidget::geometryChanged()\nCall this method to emit this signal.", false, &_init_emitter_geometryChanged_0, &_call_emitter_geometryChanged_0);
  methods += new qt_gsi::GenericMethod ("getContentsMargins", "@brief Virtual method void QGraphicsWidget::getContentsMargins(double *left, double *top, double *right, double *bottom)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_getContentsMargins_c4704_0, &_call_cbs_getContentsMargins_c4704_0);
  methods += new qt_gsi::GenericMethod ("getContentsMargins", "@hide", true, &_init_cbs_getContentsMargins_c4704_0, &_call_cbs_getContentsMargins_c4704_0, &_set_callback_cbs_getContentsMargins_c4704_0);
  methods += new qt_gsi::GenericMethod ("*grabKeyboardEvent", "@brief Virtual method void QGraphicsWidget::grabKeyboardEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_grabKeyboardEvent_1217_0, &_call_cbs_grabKeyboardEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*grabKeyboardEvent", "@hide", false, &_init_cbs_grabKeyboardEvent_1217_0, &_call_cbs_grabKeyboardEvent_1217_0, &_set_callback_cbs_grabKeyboardEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*grabMouseEvent", "@brief Virtual method void QGraphicsWidget::grabMouseEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_grabMouseEvent_1217_0, &_call_cbs_grabMouseEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*grabMouseEvent", "@hide", false, &_init_cbs_grabMouseEvent_1217_0, &_call_cbs_grabMouseEvent_1217_0, &_set_callback_cbs_grabMouseEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_heightChanged", "@brief Emitter for signal void QGraphicsWidget::heightChanged()\nCall this method to emit this signal.", false, &_init_emitter_heightChanged_0, &_call_emitter_heightChanged_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QGraphicsWidget::hideEvent(QHideEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hoverEnterEvent", "@brief Virtual method void QGraphicsWidget::hoverEnterEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverEnterEvent_3044_0, &_call_cbs_hoverEnterEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverEnterEvent", "@hide", false, &_init_cbs_hoverEnterEvent_3044_0, &_call_cbs_hoverEnterEvent_3044_0, &_set_callback_cbs_hoverEnterEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverLeaveEvent", "@brief Virtual method void QGraphicsWidget::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverLeaveEvent_3044_0, &_call_cbs_hoverLeaveEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverLeaveEvent", "@hide", false, &_init_cbs_hoverLeaveEvent_3044_0, &_call_cbs_hoverLeaveEvent_3044_0, &_set_callback_cbs_hoverLeaveEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverMoveEvent", "@brief Virtual method void QGraphicsWidget::hoverMoveEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverMoveEvent_3044_0, &_call_cbs_hoverMoveEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverMoveEvent", "@hide", false, &_init_cbs_hoverMoveEvent_3044_0, &_call_cbs_hoverMoveEvent_3044_0, &_set_callback_cbs_hoverMoveEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@brief Virtual method void QGraphicsWidget::initStyleOption(QStyleOption *option)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initStyleOption_c1865_0, &_call_cbs_initStyleOption_c1865_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@hide", true, &_init_cbs_initStyleOption_c1865_0, &_call_cbs_initStyleOption_c1865_0, &_set_callback_cbs_initStyleOption_c1865_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QGraphicsWidget::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodQuery", "@brief Virtual method QVariant QGraphicsWidget::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("isObscuredBy", "@brief Virtual method bool QGraphicsWidget::isObscuredBy(const QGraphicsItem *item)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isObscuredBy_c2614_0, &_call_cbs_isObscuredBy_c2614_0);
  methods += new qt_gsi::GenericMethod ("isObscuredBy", "@hide", true, &_init_cbs_isObscuredBy_c2614_0, &_call_cbs_isObscuredBy_c2614_0, &_set_callback_cbs_isObscuredBy_c2614_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QGraphicsWidget::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*itemChange", "@brief Virtual method QVariant QGraphicsWidget::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_itemChange_5658_0, &_call_cbs_itemChange_5658_0);
  methods += new qt_gsi::GenericMethod ("*itemChange", "@hide", false, &_init_cbs_itemChange_5658_0, &_call_cbs_itemChange_5658_0, &_set_callback_cbs_itemChange_5658_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QGraphicsWidget::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QGraphicsWidget::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("emit_layoutChanged", "@brief Emitter for signal void QGraphicsWidget::layoutChanged()\nCall this method to emit this signal.", false, &_init_emitter_layoutChanged_0, &_call_emitter_layoutChanged_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QGraphicsWidget::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0, &_set_callback_cbs_mouseDoubleClickEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QGraphicsWidget::mouseMoveEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0, &_set_callback_cbs_mouseMoveEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QGraphicsWidget::mousePressEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0, &_set_callback_cbs_mousePressEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QGraphicsWidget::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0, &_set_callback_cbs_mouseReleaseEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QGraphicsWidget::moveEvent(QGraphicsSceneMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_2935_0, &_call_cbs_moveEvent_2935_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_2935_0, &_call_cbs_moveEvent_2935_0, &_set_callback_cbs_moveEvent_2935_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QGraphicsWidget::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("emit_opacityChanged", "@brief Emitter for signal void QGraphicsWidget::opacityChanged()\nCall this method to emit this signal.", false, &_init_emitter_opacityChanged_0, &_call_emitter_opacityChanged_0);
  methods += new qt_gsi::GenericMethod ("opaqueArea", "@brief Virtual method QPainterPath QGraphicsWidget::opaqueArea()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_opaqueArea_c0_0, &_call_cbs_opaqueArea_c0_0);
  methods += new qt_gsi::GenericMethod ("opaqueArea", "@hide", true, &_init_cbs_opaqueArea_c0_0, &_call_cbs_opaqueArea_c0_0, &_set_callback_cbs_opaqueArea_c0_0);
  methods += new qt_gsi::GenericMethod ("paint", "@brief Virtual method void QGraphicsWidget::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paint_6301_1, &_call_cbs_paint_6301_1);
  methods += new qt_gsi::GenericMethod ("paint", "@hide", false, &_init_cbs_paint_6301_1, &_call_cbs_paint_6301_1, &_set_callback_cbs_paint_6301_1);
  methods += new qt_gsi::GenericMethod ("paintWindowFrame", "@brief Virtual method void QGraphicsWidget::paintWindowFrame(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintWindowFrame_6301_1, &_call_cbs_paintWindowFrame_6301_1);
  methods += new qt_gsi::GenericMethod ("paintWindowFrame", "@hide", false, &_init_cbs_paintWindowFrame_6301_1, &_call_cbs_paintWindowFrame_6301_1, &_set_callback_cbs_paintWindowFrame_6301_1);
  methods += new qt_gsi::GenericMethod ("emit_parentChanged", "@brief Emitter for signal void QGraphicsWidget::parentChanged()\nCall this method to emit this signal.", false, &_init_emitter_parentChanged_0, &_call_emitter_parentChanged_0);
  methods += new qt_gsi::GenericMethod ("*polishEvent", "@brief Virtual method void QGraphicsWidget::polishEvent()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_polishEvent_0_0, &_call_cbs_polishEvent_0_0);
  methods += new qt_gsi::GenericMethod ("*polishEvent", "@hide", false, &_init_cbs_polishEvent_0_0, &_call_cbs_polishEvent_0_0, &_set_callback_cbs_polishEvent_0_0);
  methods += new qt_gsi::GenericMethod ("*prepareGeometryChange", "@brief Method void QGraphicsWidget::prepareGeometryChange()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_prepareGeometryChange_0, &_call_fp_prepareGeometryChange_0);
  methods += new qt_gsi::GenericMethod ("*propertyChange", "@brief Virtual method QVariant QGraphicsWidget::propertyChange(const QString &propertyName, const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_propertyChange_4036_0, &_call_cbs_propertyChange_4036_0);
  methods += new qt_gsi::GenericMethod ("*propertyChange", "@hide", false, &_init_cbs_propertyChange_4036_0, &_call_cbs_propertyChange_4036_0, &_set_callback_cbs_propertyChange_4036_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QGraphicsWidget::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*removeFromIndex", "@brief Method void QGraphicsWidget::removeFromIndex()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_removeFromIndex_0, &_call_fp_removeFromIndex_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QGraphicsWidget::resizeEvent(QGraphicsSceneResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_3154_0, &_call_cbs_resizeEvent_3154_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_3154_0, &_call_cbs_resizeEvent_3154_0, &_set_callback_cbs_resizeEvent_3154_0);
  methods += new qt_gsi::GenericMethod ("emit_rotationChanged", "@brief Emitter for signal void QGraphicsWidget::rotationChanged()\nCall this method to emit this signal.", false, &_init_emitter_rotationChanged_0, &_call_emitter_rotationChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_scaleChanged", "@brief Emitter for signal void QGraphicsWidget::scaleChanged()\nCall this method to emit this signal.", false, &_init_emitter_scaleChanged_0, &_call_emitter_scaleChanged_0);
  methods += new qt_gsi::GenericMethod ("*sceneEvent", "@brief Virtual method bool QGraphicsWidget::sceneEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sceneEvent_1217_0, &_call_cbs_sceneEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*sceneEvent", "@hide", false, &_init_cbs_sceneEvent_1217_0, &_call_cbs_sceneEvent_1217_0, &_set_callback_cbs_sceneEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*sceneEventFilter", "@brief Virtual method bool QGraphicsWidget::sceneEventFilter(QGraphicsItem *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sceneEventFilter_3028_0, &_call_cbs_sceneEventFilter_3028_0);
  methods += new qt_gsi::GenericMethod ("*sceneEventFilter", "@hide", false, &_init_cbs_sceneEventFilter_3028_0, &_call_cbs_sceneEventFilter_3028_0, &_set_callback_cbs_sceneEventFilter_3028_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QGraphicsWidget::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QGraphicsWidget::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setExtension", "@brief Virtual method void QGraphicsWidget::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setExtension_4817_0, &_call_cbs_setExtension_4817_0);
  methods += new qt_gsi::GenericMethod ("*setExtension", "@hide", false, &_init_cbs_setExtension_4817_0, &_call_cbs_setExtension_4817_0, &_set_callback_cbs_setExtension_4817_0);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@brief Virtual method void QGraphicsWidget::setGeometry(const QRectF &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setGeometry_1862_0, &_call_cbs_setGeometry_1862_0);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@hide", false, &_init_cbs_setGeometry_1862_0, &_call_cbs_setGeometry_1862_0, &_set_callback_cbs_setGeometry_1862_0);
  methods += new qt_gsi::GenericMethod ("*setGraphicsItem", "@brief Method void QGraphicsWidget::setGraphicsItem(QGraphicsItem *item)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setGraphicsItem_1919, &_call_fp_setGraphicsItem_1919);
  methods += new qt_gsi::GenericMethod ("*setOwnedByLayout", "@brief Method void QGraphicsWidget::setOwnedByLayout(bool ownedByLayout)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setOwnedByLayout_864, &_call_fp_setOwnedByLayout_864);
  methods += new qt_gsi::GenericMethod ("shape", "@brief Virtual method QPainterPath QGraphicsWidget::shape()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_shape_c0_0, &_call_cbs_shape_c0_0);
  methods += new qt_gsi::GenericMethod ("shape", "@hide", true, &_init_cbs_shape_c0_0, &_call_cbs_shape_c0_0, &_set_callback_cbs_shape_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QGraphicsWidget::showEvent(QShowEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*sizeHint", "@brief Virtual method QSizeF QGraphicsWidget::sizeHint(Qt::SizeHint which, const QSizeF &constraint)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c3330_1, &_call_cbs_sizeHint_c3330_1);
  methods += new qt_gsi::GenericMethod ("*sizeHint", "@hide", true, &_init_cbs_sizeHint_c3330_1, &_call_cbs_sizeHint_c3330_1, &_set_callback_cbs_sizeHint_c3330_1);
  methods += new qt_gsi::GenericMethod ("*supportsExtension", "@brief Virtual method bool QGraphicsWidget::supportsExtension(QGraphicsItem::Extension extension)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportsExtension_c2806_0, &_call_cbs_supportsExtension_c2806_0);
  methods += new qt_gsi::GenericMethod ("*supportsExtension", "@hide", true, &_init_cbs_supportsExtension_c2806_0, &_call_cbs_supportsExtension_c2806_0, &_set_callback_cbs_supportsExtension_c2806_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsWidget::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("type", "@brief Virtual method int QGraphicsWidget::type()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0);
  methods += new qt_gsi::GenericMethod ("type", "@hide", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0, &_set_callback_cbs_type_c0_0);
  methods += new qt_gsi::GenericMethod ("*ungrabKeyboardEvent", "@brief Virtual method void QGraphicsWidget::ungrabKeyboardEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_ungrabKeyboardEvent_1217_0, &_call_cbs_ungrabKeyboardEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*ungrabKeyboardEvent", "@hide", false, &_init_cbs_ungrabKeyboardEvent_1217_0, &_call_cbs_ungrabKeyboardEvent_1217_0, &_set_callback_cbs_ungrabKeyboardEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*ungrabMouseEvent", "@brief Virtual method void QGraphicsWidget::ungrabMouseEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_ungrabMouseEvent_1217_0, &_call_cbs_ungrabMouseEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*ungrabMouseEvent", "@hide", false, &_init_cbs_ungrabMouseEvent_1217_0, &_call_cbs_ungrabMouseEvent_1217_0, &_set_callback_cbs_ungrabMouseEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*updateGeometry", "@brief Virtual method void QGraphicsWidget::updateGeometry()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateGeometry_0_0, &_call_cbs_updateGeometry_0_0);
  methods += new qt_gsi::GenericMethod ("*updateGeometry", "@hide", false, &_init_cbs_updateGeometry_0_0, &_call_cbs_updateGeometry_0_0, &_set_callback_cbs_updateGeometry_0_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QGraphicsWidget::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("emit_visibleChanged", "@brief Emitter for signal void QGraphicsWidget::visibleChanged()\nCall this method to emit this signal.", false, &_init_emitter_visibleChanged_0, &_call_emitter_visibleChanged_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QGraphicsWidget::wheelEvent(QGraphicsSceneWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0, &_set_callback_cbs_wheelEvent_3029_0);
  methods += new qt_gsi::GenericMethod ("emit_widthChanged", "@brief Emitter for signal void QGraphicsWidget::widthChanged()\nCall this method to emit this signal.", false, &_init_emitter_widthChanged_0, &_call_emitter_widthChanged_0);
  methods += new qt_gsi::GenericMethod ("*windowFrameEvent", "@brief Virtual method bool QGraphicsWidget::windowFrameEvent(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowFrameEvent_1217_0, &_call_cbs_windowFrameEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*windowFrameEvent", "@hide", false, &_init_cbs_windowFrameEvent_1217_0, &_call_cbs_windowFrameEvent_1217_0, &_set_callback_cbs_windowFrameEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*windowFrameSectionAt", "@brief Virtual method Qt::WindowFrameSection QGraphicsWidget::windowFrameSectionAt(const QPointF &pos)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_windowFrameSectionAt_c1986_0, &_call_cbs_windowFrameSectionAt_c1986_0);
  methods += new qt_gsi::GenericMethod ("*windowFrameSectionAt", "@hide", true, &_init_cbs_windowFrameSectionAt_c1986_0, &_call_cbs_windowFrameSectionAt_c1986_0, &_set_callback_cbs_windowFrameSectionAt_c1986_0);
  methods += new qt_gsi::GenericMethod ("emit_xChanged", "@brief Emitter for signal void QGraphicsWidget::xChanged()\nCall this method to emit this signal.", false, &_init_emitter_xChanged_0, &_call_emitter_xChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_yChanged", "@brief Emitter for signal void QGraphicsWidget::yChanged()\nCall this method to emit this signal.", false, &_init_emitter_yChanged_0, &_call_emitter_yChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_zChanged", "@brief Emitter for signal void QGraphicsWidget::zChanged()\nCall this method to emit this signal.", false, &_init_emitter_zChanged_0, &_call_emitter_zChanged_0);
  return methods;
}

gsi::Class<QGraphicsWidget_Adaptor> decl_QGraphicsWidget_Adaptor (qtdecl_QGraphicsWidget (), "QtWidgets", "QGraphicsWidget",
  methods_QGraphicsWidget_Adaptor (),
  "@qt\n@brief Binding of QGraphicsWidget");

}

