
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsEffect.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QGraphicsEffect>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QPainter>
#include <QPixmap>
#include <QPoint>
#include <QRectF>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsEffect

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsEffect::staticMetaObject);
}


// QRectF QGraphicsEffect::boundingRect()


static void _init_f_boundingRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QGraphicsEffect *)cls)->boundingRect ());
}


// QRectF QGraphicsEffect::boundingRectFor(const QRectF &sourceRect)


static void _init_f_boundingRectFor_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceRect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRectFor_c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QGraphicsEffect *)cls)->boundingRectFor (arg1));
}


// bool QGraphicsEffect::isEnabled()


static void _init_f_isEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsEffect *)cls)->isEnabled ());
}


// void QGraphicsEffect::setEnabled(bool enable)


static void _init_f_setEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsEffect *)cls)->setEnabled (arg1);
}


// void QGraphicsEffect::update()


static void _init_f_update_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_update_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsEffect *)cls)->update ();
}


// static QString QGraphicsEffect::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QGraphicsEffect::tr (arg1, arg2, arg3));
}


// static QString QGraphicsEffect::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QGraphicsEffect::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QGraphicsEffect () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRectF QGraphicsEffect::boundingRect()\n", true, &_init_f_boundingRect_c0, &_call_f_boundingRect_c0);
  methods += new qt_gsi::GenericMethod ("boundingRectFor", "@brief Method QRectF QGraphicsEffect::boundingRectFor(const QRectF &sourceRect)\n", true, &_init_f_boundingRectFor_c1862, &_call_f_boundingRectFor_c1862);
  methods += new qt_gsi::GenericMethod ("isEnabled?|:enabled", "@brief Method bool QGraphicsEffect::isEnabled()\n", true, &_init_f_isEnabled_c0, &_call_f_isEnabled_c0);
  methods += new qt_gsi::GenericMethod ("setEnabled|enabled=", "@brief Method void QGraphicsEffect::setEnabled(bool enable)\n", false, &_init_f_setEnabled_864, &_call_f_setEnabled_864);
  methods += new qt_gsi::GenericMethod ("update", "@brief Method void QGraphicsEffect::update()\n", false, &_init_f_update_0, &_call_f_update_0);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QGraphicsEffect::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("enabledChanged(bool)", "enabledChanged", gsi::arg("enabled"), "@brief Signal declaration for QGraphicsEffect::enabledChanged(bool enabled)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QGraphicsEffect::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsEffect::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsEffect::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QGraphicsEffect> decl_QGraphicsEffect (qtdecl_QObject (), "QtWidgets", "QGraphicsEffect_Native",
  methods_QGraphicsEffect (),
  "@hide\n@alias QGraphicsEffect");

GSI_QTWIDGETS_PUBLIC gsi::Class<QGraphicsEffect> &qtdecl_QGraphicsEffect () { return decl_QGraphicsEffect; }

}


class QGraphicsEffect_Adaptor : public QGraphicsEffect, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsEffect_Adaptor();

  //  [adaptor ctor] QGraphicsEffect::QGraphicsEffect(QObject *parent)
  QGraphicsEffect_Adaptor() : QGraphicsEffect()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsEffect::QGraphicsEffect(QObject *parent)
  QGraphicsEffect_Adaptor(QObject *parent) : QGraphicsEffect(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QGraphicsEffect::drawSource(QPainter *painter)
  void fp_QGraphicsEffect_drawSource_1426 (QPainter *painter) {
    QGraphicsEffect::drawSource(painter);
  }

  //  [expose] bool QGraphicsEffect::isSignalConnected(const QMetaMethod &signal)
  bool fp_QGraphicsEffect_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QGraphicsEffect::isSignalConnected(signal);
  }

  //  [expose] int QGraphicsEffect::receivers(const char *signal)
  int fp_QGraphicsEffect_receivers_c1731 (const char *signal) const {
    return QGraphicsEffect::receivers(signal);
  }

  //  [expose] QObject *QGraphicsEffect::sender()
  QObject * fp_QGraphicsEffect_sender_c0 () const {
    return QGraphicsEffect::sender();
  }

  //  [expose] int QGraphicsEffect::senderSignalIndex()
  int fp_QGraphicsEffect_senderSignalIndex_c0 () const {
    return QGraphicsEffect::senderSignalIndex();
  }

  //  [expose] QRectF QGraphicsEffect::sourceBoundingRect(Qt::CoordinateSystem system)
  QRectF fp_QGraphicsEffect_sourceBoundingRect_c2426 (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & system) const {
    return QGraphicsEffect::sourceBoundingRect(qt_gsi::QtToCppAdaptor<Qt::CoordinateSystem>(system).cref());
  }

  //  [expose] bool QGraphicsEffect::sourceIsPixmap()
  bool fp_QGraphicsEffect_sourceIsPixmap_c0 () const {
    return QGraphicsEffect::sourceIsPixmap();
  }

  //  [expose] QPixmap QGraphicsEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)
  QPixmap fp_QGraphicsEffect_sourcePixmap_c6763 (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & system, QPoint *offset, const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & mode) const {
    return QGraphicsEffect::sourcePixmap(qt_gsi::QtToCppAdaptor<Qt::CoordinateSystem>(system).cref(), offset, qt_gsi::QtToCppAdaptor<QGraphicsEffect::PixmapPadMode>(mode).cref());
  }

  //  [expose] void QGraphicsEffect::updateBoundingRect()
  void fp_QGraphicsEffect_updateBoundingRect_0 () {
    QGraphicsEffect::updateBoundingRect();
  }

  //  [adaptor impl] QRectF QGraphicsEffect::boundingRectFor(const QRectF &sourceRect)
  QRectF cbs_boundingRectFor_c1862_0(const QRectF &sourceRect) const
  {
    return QGraphicsEffect::boundingRectFor(sourceRect);
  }

  virtual QRectF boundingRectFor(const QRectF &sourceRect) const
  {
    if (cb_boundingRectFor_c1862_0.can_issue()) {
      return cb_boundingRectFor_c1862_0.issue<QGraphicsEffect_Adaptor, QRectF, const QRectF &>(&QGraphicsEffect_Adaptor::cbs_boundingRectFor_c1862_0, sourceRect);
    } else {
      return QGraphicsEffect::boundingRectFor(sourceRect);
    }
  }

  //  [emitter impl] void QGraphicsEffect::destroyed(QObject *)
  void emitter_QGraphicsEffect_destroyed_1302(QObject *arg1)
  {
    emit QGraphicsEffect::destroyed(arg1);
  }

  //  [emitter impl] void QGraphicsEffect::enabledChanged(bool enabled)
  void emitter_QGraphicsEffect_enabledChanged_864(bool enabled)
  {
    emit QGraphicsEffect::enabledChanged(enabled);
  }

  //  [adaptor impl] bool QGraphicsEffect::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QGraphicsEffect::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsEffect_Adaptor, bool, QEvent *>(&QGraphicsEffect_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QGraphicsEffect::event(_event);
    }
  }

  //  [adaptor impl] bool QGraphicsEffect::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QGraphicsEffect::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsEffect_Adaptor, bool, QObject *, QEvent *>(&QGraphicsEffect_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QGraphicsEffect::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QGraphicsEffect::objectNameChanged(const QString &objectName)
  void emitter_QGraphicsEffect_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QGraphicsEffect::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QGraphicsEffect::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QGraphicsEffect::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsEffect_Adaptor, QChildEvent *>(&QGraphicsEffect_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QGraphicsEffect::childEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsEffect::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QGraphicsEffect::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsEffect_Adaptor, QEvent *>(&QGraphicsEffect_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QGraphicsEffect::customEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsEffect::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QGraphicsEffect::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QGraphicsEffect_Adaptor, const QMetaMethod &>(&QGraphicsEffect_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QGraphicsEffect::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsEffect::draw(QPainter *painter)
  void cbs_draw_1426_0(QPainter *painter)
  {
    __SUPPRESS_UNUSED_WARNING (painter);
    throw qt_gsi::AbstractMethodCalledException("draw");
  }

  virtual void draw(QPainter *painter)
  {
    if (cb_draw_1426_0.can_issue()) {
      cb_draw_1426_0.issue<QGraphicsEffect_Adaptor, QPainter *>(&QGraphicsEffect_Adaptor::cbs_draw_1426_0, painter);
    } else {
      throw qt_gsi::AbstractMethodCalledException("draw");
    }
  }

  //  [adaptor impl] void QGraphicsEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
  void cbs_sourceChanged_3695_0(QFlags<QGraphicsEffect::ChangeFlag> flags)
  {
    QGraphicsEffect::sourceChanged(flags);
  }

  virtual void sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
  {
    if (cb_sourceChanged_3695_0.can_issue()) {
      cb_sourceChanged_3695_0.issue<QGraphicsEffect_Adaptor, QFlags<QGraphicsEffect::ChangeFlag> >(&QGraphicsEffect_Adaptor::cbs_sourceChanged_3695_0, flags);
    } else {
      QGraphicsEffect::sourceChanged(flags);
    }
  }

  //  [adaptor impl] void QGraphicsEffect::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QGraphicsEffect::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsEffect_Adaptor, QTimerEvent *>(&QGraphicsEffect_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QGraphicsEffect::timerEvent(event);
    }
  }

  gsi::Callback cb_boundingRectFor_c1862_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_draw_1426_0;
  gsi::Callback cb_sourceChanged_3695_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QGraphicsEffect_Adaptor::~QGraphicsEffect_Adaptor() { }

//  Constructor QGraphicsEffect::QGraphicsEffect(QObject *parent) (adaptor class)

static void _init_ctor_QGraphicsEffect_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QGraphicsEffect_Adaptor> ();
}

static void _call_ctor_QGraphicsEffect_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QGraphicsEffect_Adaptor *> (new QGraphicsEffect_Adaptor (arg1));
}


// QRectF QGraphicsEffect::boundingRectFor(const QRectF &sourceRect)

static void _init_cbs_boundingRectFor_c1862_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceRect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_cbs_boundingRectFor_c1862_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args.read<const QRectF & > (heap);
  ret.write<QRectF > ((QRectF)((QGraphicsEffect_Adaptor *)cls)->cbs_boundingRectFor_c1862_0 (arg1));
}

static void _set_callback_cbs_boundingRectFor_c1862_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsEffect_Adaptor *)cls)->cb_boundingRectFor_c1862_0 = cb;
}


// void QGraphicsEffect::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsEffect_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsEffect_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QGraphicsEffect::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsEffect_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsEffect_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QGraphicsEffect::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QGraphicsEffect_Adaptor *)cls)->emitter_QGraphicsEffect_destroyed_1302 (arg1);
}


// void QGraphicsEffect::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsEffect_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsEffect_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QGraphicsEffect::draw(QPainter *painter)

static void _init_cbs_draw_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_draw_1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsEffect_Adaptor *)cls)->cbs_draw_1426_0 (arg1);
}

static void _set_callback_cbs_draw_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsEffect_Adaptor *)cls)->cb_draw_1426_0 = cb;
}


// exposed void QGraphicsEffect::drawSource(QPainter *painter)

static void _init_fp_drawSource_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawSource_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsEffect_Adaptor *)cls)->fp_QGraphicsEffect_drawSource_1426 (arg1);
}


// emitter void QGraphicsEffect::enabledChanged(bool enabled)

static void _init_emitter_enabledChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_enabledChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QGraphicsEffect_Adaptor *)cls)->emitter_QGraphicsEffect_enabledChanged_864 (arg1);
}


// bool QGraphicsEffect::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsEffect_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsEffect_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QGraphicsEffect::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsEffect_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsEffect_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QGraphicsEffect::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsEffect_Adaptor *)cls)->fp_QGraphicsEffect_isSignalConnected_c2394 (arg1));
}


// emitter void QGraphicsEffect::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QGraphicsEffect_Adaptor *)cls)->emitter_QGraphicsEffect_objectNameChanged_4567 (arg1);
}


// exposed int QGraphicsEffect::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QGraphicsEffect_Adaptor *)cls)->fp_QGraphicsEffect_receivers_c1731 (arg1));
}


// exposed QObject *QGraphicsEffect::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QGraphicsEffect_Adaptor *)cls)->fp_QGraphicsEffect_sender_c0 ());
}


// exposed int QGraphicsEffect::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsEffect_Adaptor *)cls)->fp_QGraphicsEffect_senderSignalIndex_c0 ());
}


// exposed QRectF QGraphicsEffect::sourceBoundingRect(Qt::CoordinateSystem system)

static void _init_fp_sourceBoundingRect_c2426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("system", true, "Qt::LogicalCoordinates");
  decl->add_arg<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_fp_sourceBoundingRect_c2426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::CoordinateSystem>(heap, Qt::LogicalCoordinates), heap);
  ret.write<QRectF > ((QRectF)((QGraphicsEffect_Adaptor *)cls)->fp_QGraphicsEffect_sourceBoundingRect_c2426 (arg1));
}


// void QGraphicsEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)

static void _init_cbs_sourceChanged_3695_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<QGraphicsEffect::ChangeFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_sourceChanged_3695_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QGraphicsEffect::ChangeFlag> arg1 = args.read<QFlags<QGraphicsEffect::ChangeFlag> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsEffect_Adaptor *)cls)->cbs_sourceChanged_3695_0 (arg1);
}

static void _set_callback_cbs_sourceChanged_3695_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsEffect_Adaptor *)cls)->cb_sourceChanged_3695_0 = cb;
}


// exposed bool QGraphicsEffect::sourceIsPixmap()

static void _init_fp_sourceIsPixmap_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_sourceIsPixmap_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsEffect_Adaptor *)cls)->fp_QGraphicsEffect_sourceIsPixmap_c0 ());
}


// exposed QPixmap QGraphicsEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)

static void _init_fp_sourcePixmap_c6763 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("system", true, "Qt::LogicalCoordinates");
  decl->add_arg<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("offset", true, "nullptr");
  decl->add_arg<QPoint * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QGraphicsEffect::PadToEffectiveBoundingRect");
  decl->add_arg<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_fp_sourcePixmap_c6763 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::CoordinateSystem>(heap, Qt::LogicalCoordinates), heap);
  QPoint *arg2 = args ? gsi::arg_reader<QPoint * >() (args, heap) : gsi::arg_maker<QPoint * >() (nullptr, heap);
  const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QGraphicsEffect::PixmapPadMode>(heap, QGraphicsEffect::PadToEffectiveBoundingRect), heap);
  ret.write<QPixmap > ((QPixmap)((QGraphicsEffect_Adaptor *)cls)->fp_QGraphicsEffect_sourcePixmap_c6763 (arg1, arg2, arg3));
}


// void QGraphicsEffect::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsEffect_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsEffect_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QGraphicsEffect::updateBoundingRect()

static void _init_fp_updateBoundingRect_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateBoundingRect_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsEffect_Adaptor *)cls)->fp_QGraphicsEffect_updateBoundingRect_0 ();
}


namespace gsi
{

gsi::Class<QGraphicsEffect> &qtdecl_QGraphicsEffect ();

static gsi::Methods methods_QGraphicsEffect_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsEffect::QGraphicsEffect(QObject *parent)\nThis method creates an object of class QGraphicsEffect.", &_init_ctor_QGraphicsEffect_Adaptor_1302, &_call_ctor_QGraphicsEffect_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("boundingRectFor", "@brief Virtual method QRectF QGraphicsEffect::boundingRectFor(const QRectF &sourceRect)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_boundingRectFor_c1862_0, &_call_cbs_boundingRectFor_c1862_0);
  methods += new qt_gsi::GenericMethod ("boundingRectFor", "@hide", true, &_init_cbs_boundingRectFor_c1862_0, &_call_cbs_boundingRectFor_c1862_0, &_set_callback_cbs_boundingRectFor_c1862_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsEffect::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsEffect::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QGraphicsEffect::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsEffect::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*draw", "@brief Virtual method void QGraphicsEffect::draw(QPainter *painter)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_draw_1426_0, &_call_cbs_draw_1426_0);
  methods += new qt_gsi::GenericMethod ("*draw", "@hide", false, &_init_cbs_draw_1426_0, &_call_cbs_draw_1426_0, &_set_callback_cbs_draw_1426_0);
  methods += new qt_gsi::GenericMethod ("*drawSource", "@brief Method void QGraphicsEffect::drawSource(QPainter *painter)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawSource_1426, &_call_fp_drawSource_1426);
  methods += new qt_gsi::GenericMethod ("emit_enabledChanged", "@brief Emitter for signal void QGraphicsEffect::enabledChanged(bool enabled)\nCall this method to emit this signal.", false, &_init_emitter_enabledChanged_864, &_call_emitter_enabledChanged_864);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QGraphicsEffect::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QGraphicsEffect::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QGraphicsEffect::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QGraphicsEffect::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QGraphicsEffect::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QGraphicsEffect::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QGraphicsEffect::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*sourceBoundingRect", "@brief Method QRectF QGraphicsEffect::sourceBoundingRect(Qt::CoordinateSystem system)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourceBoundingRect_c2426, &_call_fp_sourceBoundingRect_c2426);
  methods += new qt_gsi::GenericMethod ("*sourceChanged", "@brief Virtual method void QGraphicsEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sourceChanged_3695_0, &_call_cbs_sourceChanged_3695_0);
  methods += new qt_gsi::GenericMethod ("*sourceChanged", "@hide", false, &_init_cbs_sourceChanged_3695_0, &_call_cbs_sourceChanged_3695_0, &_set_callback_cbs_sourceChanged_3695_0);
  methods += new qt_gsi::GenericMethod ("*sourceIsPixmap", "@brief Method bool QGraphicsEffect::sourceIsPixmap()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourceIsPixmap_c0, &_call_fp_sourceIsPixmap_c0);
  methods += new qt_gsi::GenericMethod ("*sourcePixmap", "@brief Method QPixmap QGraphicsEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourcePixmap_c6763, &_call_fp_sourcePixmap_c6763);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsEffect::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateBoundingRect", "@brief Method void QGraphicsEffect::updateBoundingRect()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateBoundingRect_0, &_call_fp_updateBoundingRect_0);
  return methods;
}

gsi::Class<QGraphicsEffect_Adaptor> decl_QGraphicsEffect_Adaptor (qtdecl_QGraphicsEffect (), "QtWidgets", "QGraphicsEffect",
  methods_QGraphicsEffect_Adaptor (),
  "@qt\n@brief Binding of QGraphicsEffect");

}


//  Implementation of the enum wrapper class for QGraphicsEffect::ChangeFlag
namespace qt_gsi
{

static gsi::Enum<QGraphicsEffect::ChangeFlag> decl_QGraphicsEffect_ChangeFlag_Enum ("QtWidgets", "QGraphicsEffect_ChangeFlag",
    gsi::enum_const ("SourceAttached", QGraphicsEffect::SourceAttached, "@brief Enum constant QGraphicsEffect::SourceAttached") +
    gsi::enum_const ("SourceDetached", QGraphicsEffect::SourceDetached, "@brief Enum constant QGraphicsEffect::SourceDetached") +
    gsi::enum_const ("SourceBoundingRectChanged", QGraphicsEffect::SourceBoundingRectChanged, "@brief Enum constant QGraphicsEffect::SourceBoundingRectChanged") +
    gsi::enum_const ("SourceInvalidated", QGraphicsEffect::SourceInvalidated, "@brief Enum constant QGraphicsEffect::SourceInvalidated"),
  "@qt\n@brief This class represents the QGraphicsEffect::ChangeFlag enum");

static gsi::QFlagsClass<QGraphicsEffect::ChangeFlag > decl_QGraphicsEffect_ChangeFlag_Enums ("QtWidgets", "QGraphicsEffect_QFlags_ChangeFlag",
  "@qt\n@brief This class represents the QFlags<QGraphicsEffect::ChangeFlag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsEffect> inject_QGraphicsEffect_ChangeFlag_Enum_in_parent (decl_QGraphicsEffect_ChangeFlag_Enum.defs ());
static gsi::ClassExt<QGraphicsEffect> decl_QGraphicsEffect_ChangeFlag_Enum_as_child (decl_QGraphicsEffect_ChangeFlag_Enum, "ChangeFlag");
static gsi::ClassExt<QGraphicsEffect> decl_QGraphicsEffect_ChangeFlag_Enums_as_child (decl_QGraphicsEffect_ChangeFlag_Enums, "QFlags_ChangeFlag");

}


//  Implementation of the enum wrapper class for QGraphicsEffect::PixmapPadMode
namespace qt_gsi
{

static gsi::Enum<QGraphicsEffect::PixmapPadMode> decl_QGraphicsEffect_PixmapPadMode_Enum ("QtWidgets", "QGraphicsEffect_PixmapPadMode",
    gsi::enum_const ("NoPad", QGraphicsEffect::NoPad, "@brief Enum constant QGraphicsEffect::NoPad") +
    gsi::enum_const ("PadToTransparentBorder", QGraphicsEffect::PadToTransparentBorder, "@brief Enum constant QGraphicsEffect::PadToTransparentBorder") +
    gsi::enum_const ("PadToEffectiveBoundingRect", QGraphicsEffect::PadToEffectiveBoundingRect, "@brief Enum constant QGraphicsEffect::PadToEffectiveBoundingRect"),
  "@qt\n@brief This class represents the QGraphicsEffect::PixmapPadMode enum");

static gsi::QFlagsClass<QGraphicsEffect::PixmapPadMode > decl_QGraphicsEffect_PixmapPadMode_Enums ("QtWidgets", "QGraphicsEffect_QFlags_PixmapPadMode",
  "@qt\n@brief This class represents the QFlags<QGraphicsEffect::PixmapPadMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsEffect> inject_QGraphicsEffect_PixmapPadMode_Enum_in_parent (decl_QGraphicsEffect_PixmapPadMode_Enum.defs ());
static gsi::ClassExt<QGraphicsEffect> decl_QGraphicsEffect_PixmapPadMode_Enum_as_child (decl_QGraphicsEffect_PixmapPadMode_Enum, "PixmapPadMode");
static gsi::ClassExt<QGraphicsEffect> decl_QGraphicsEffect_PixmapPadMode_Enums_as_child (decl_QGraphicsEffect_PixmapPadMode_Enums, "QFlags_PixmapPadMode");

}

