
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsDropShadowEffect.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QGraphicsDropShadowEffect>
#include <QChildEvent>
#include <QColor>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QPainter>
#include <QPixmap>
#include <QPoint>
#include <QPointF>
#include <QRectF>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsDropShadowEffect

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsDropShadowEffect::staticMetaObject);
}


// double QGraphicsDropShadowEffect::blurRadius()


static void _init_f_blurRadius_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_blurRadius_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsDropShadowEffect *)cls)->blurRadius ());
}


// QRectF QGraphicsDropShadowEffect::boundingRectFor(const QRectF &rect)


static void _init_f_boundingRectFor_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRectFor_c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QGraphicsDropShadowEffect *)cls)->boundingRectFor (arg1));
}


// QColor QGraphicsDropShadowEffect::color()


static void _init_f_color_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QColor > ();
}

static void _call_f_color_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QColor > ((QColor)((QGraphicsDropShadowEffect *)cls)->color ());
}


// QPointF QGraphicsDropShadowEffect::offset()


static void _init_f_offset_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_offset_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPointF > ((QPointF)((QGraphicsDropShadowEffect *)cls)->offset ());
}


// void QGraphicsDropShadowEffect::setBlurRadius(double blurRadius)


static void _init_f_setBlurRadius_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("blurRadius");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBlurRadius_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsDropShadowEffect *)cls)->setBlurRadius (arg1);
}


// void QGraphicsDropShadowEffect::setColor(const QColor &color)


static void _init_f_setColor_1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("color");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setColor_1905 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QColor &arg1 = gsi::arg_reader<const QColor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsDropShadowEffect *)cls)->setColor (arg1);
}


// void QGraphicsDropShadowEffect::setOffset(const QPointF &ofs)


static void _init_f_setOffset_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ofs");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOffset_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsDropShadowEffect *)cls)->setOffset (arg1);
}


// void QGraphicsDropShadowEffect::setOffset(double dx, double dy)


static void _init_f_setOffset_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setOffset_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsDropShadowEffect *)cls)->setOffset (arg1, arg2);
}


// void QGraphicsDropShadowEffect::setOffset(double d)


static void _init_f_setOffset_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("d");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOffset_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsDropShadowEffect *)cls)->setOffset (arg1);
}


// void QGraphicsDropShadowEffect::setXOffset(double dx)


static void _init_f_setXOffset_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setXOffset_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsDropShadowEffect *)cls)->setXOffset (arg1);
}


// void QGraphicsDropShadowEffect::setYOffset(double dy)


static void _init_f_setYOffset_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dy");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setYOffset_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsDropShadowEffect *)cls)->setYOffset (arg1);
}


// double QGraphicsDropShadowEffect::xOffset()


static void _init_f_xOffset_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_xOffset_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsDropShadowEffect *)cls)->xOffset ());
}


// double QGraphicsDropShadowEffect::yOffset()


static void _init_f_yOffset_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_yOffset_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsDropShadowEffect *)cls)->yOffset ());
}


// static QString QGraphicsDropShadowEffect::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QGraphicsDropShadowEffect::tr (arg1, arg2, arg3));
}


// static QString QGraphicsDropShadowEffect::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QGraphicsDropShadowEffect::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QGraphicsDropShadowEffect () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":blurRadius", "@brief Method double QGraphicsDropShadowEffect::blurRadius()\n", true, &_init_f_blurRadius_c0, &_call_f_blurRadius_c0);
  methods += new qt_gsi::GenericMethod ("boundingRectFor", "@brief Method QRectF QGraphicsDropShadowEffect::boundingRectFor(const QRectF &rect)\nThis is a reimplementation of QGraphicsEffect::boundingRectFor", true, &_init_f_boundingRectFor_c1862, &_call_f_boundingRectFor_c1862);
  methods += new qt_gsi::GenericMethod (":color", "@brief Method QColor QGraphicsDropShadowEffect::color()\n", true, &_init_f_color_c0, &_call_f_color_c0);
  methods += new qt_gsi::GenericMethod (":offset", "@brief Method QPointF QGraphicsDropShadowEffect::offset()\n", true, &_init_f_offset_c0, &_call_f_offset_c0);
  methods += new qt_gsi::GenericMethod ("setBlurRadius|blurRadius=", "@brief Method void QGraphicsDropShadowEffect::setBlurRadius(double blurRadius)\n", false, &_init_f_setBlurRadius_1071, &_call_f_setBlurRadius_1071);
  methods += new qt_gsi::GenericMethod ("setColor|color=", "@brief Method void QGraphicsDropShadowEffect::setColor(const QColor &color)\n", false, &_init_f_setColor_1905, &_call_f_setColor_1905);
  methods += new qt_gsi::GenericMethod ("setOffset|offset=", "@brief Method void QGraphicsDropShadowEffect::setOffset(const QPointF &ofs)\n", false, &_init_f_setOffset_1986, &_call_f_setOffset_1986);
  methods += new qt_gsi::GenericMethod ("setOffset", "@brief Method void QGraphicsDropShadowEffect::setOffset(double dx, double dy)\n", false, &_init_f_setOffset_2034, &_call_f_setOffset_2034);
  methods += new qt_gsi::GenericMethod ("setOffset|offset=", "@brief Method void QGraphicsDropShadowEffect::setOffset(double d)\n", false, &_init_f_setOffset_1071, &_call_f_setOffset_1071);
  methods += new qt_gsi::GenericMethod ("setXOffset|xOffset=", "@brief Method void QGraphicsDropShadowEffect::setXOffset(double dx)\n", false, &_init_f_setXOffset_1071, &_call_f_setXOffset_1071);
  methods += new qt_gsi::GenericMethod ("setYOffset|yOffset=", "@brief Method void QGraphicsDropShadowEffect::setYOffset(double dy)\n", false, &_init_f_setYOffset_1071, &_call_f_setYOffset_1071);
  methods += new qt_gsi::GenericMethod (":xOffset", "@brief Method double QGraphicsDropShadowEffect::xOffset()\n", true, &_init_f_xOffset_c0, &_call_f_xOffset_c0);
  methods += new qt_gsi::GenericMethod (":yOffset", "@brief Method double QGraphicsDropShadowEffect::yOffset()\n", true, &_init_f_yOffset_c0, &_call_f_yOffset_c0);
  methods += gsi::qt_signal<double > ("blurRadiusChanged(double)", "blurRadiusChanged", gsi::arg("blurRadius"), "@brief Signal declaration for QGraphicsDropShadowEffect::blurRadiusChanged(double blurRadius)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QColor & > ("colorChanged(const QColor &)", "colorChanged", gsi::arg("color"), "@brief Signal declaration for QGraphicsDropShadowEffect::colorChanged(const QColor &color)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QGraphicsDropShadowEffect::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("enabledChanged(bool)", "enabledChanged", gsi::arg("enabled"), "@brief Signal declaration for QGraphicsDropShadowEffect::enabledChanged(bool enabled)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QGraphicsDropShadowEffect::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPointF & > ("offsetChanged(const QPointF &)", "offsetChanged", gsi::arg("offset"), "@brief Signal declaration for QGraphicsDropShadowEffect::offsetChanged(const QPointF &offset)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsDropShadowEffect::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsDropShadowEffect::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QGraphicsEffect> &qtdecl_QGraphicsEffect ();

qt_gsi::QtNativeClass<QGraphicsDropShadowEffect> decl_QGraphicsDropShadowEffect (qtdecl_QGraphicsEffect (), "QtWidgets", "QGraphicsDropShadowEffect_Native",
  methods_QGraphicsDropShadowEffect (),
  "@hide\n@alias QGraphicsDropShadowEffect");

GSI_QTWIDGETS_PUBLIC gsi::Class<QGraphicsDropShadowEffect> &qtdecl_QGraphicsDropShadowEffect () { return decl_QGraphicsDropShadowEffect; }

}


class QGraphicsDropShadowEffect_Adaptor : public QGraphicsDropShadowEffect, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsDropShadowEffect_Adaptor();

  //  [adaptor ctor] QGraphicsDropShadowEffect::QGraphicsDropShadowEffect(QObject *parent)
  QGraphicsDropShadowEffect_Adaptor() : QGraphicsDropShadowEffect()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsDropShadowEffect::QGraphicsDropShadowEffect(QObject *parent)
  QGraphicsDropShadowEffect_Adaptor(QObject *parent) : QGraphicsDropShadowEffect(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QGraphicsDropShadowEffect::drawSource(QPainter *painter)
  void fp_QGraphicsDropShadowEffect_drawSource_1426 (QPainter *painter) {
    QGraphicsDropShadowEffect::drawSource(painter);
  }

  //  [expose] bool QGraphicsDropShadowEffect::isSignalConnected(const QMetaMethod &signal)
  bool fp_QGraphicsDropShadowEffect_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QGraphicsDropShadowEffect::isSignalConnected(signal);
  }

  //  [expose] int QGraphicsDropShadowEffect::receivers(const char *signal)
  int fp_QGraphicsDropShadowEffect_receivers_c1731 (const char *signal) const {
    return QGraphicsDropShadowEffect::receivers(signal);
  }

  //  [expose] QObject *QGraphicsDropShadowEffect::sender()
  QObject * fp_QGraphicsDropShadowEffect_sender_c0 () const {
    return QGraphicsDropShadowEffect::sender();
  }

  //  [expose] int QGraphicsDropShadowEffect::senderSignalIndex()
  int fp_QGraphicsDropShadowEffect_senderSignalIndex_c0 () const {
    return QGraphicsDropShadowEffect::senderSignalIndex();
  }

  //  [expose] QRectF QGraphicsDropShadowEffect::sourceBoundingRect(Qt::CoordinateSystem system)
  QRectF fp_QGraphicsDropShadowEffect_sourceBoundingRect_c2426 (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & system) const {
    return QGraphicsDropShadowEffect::sourceBoundingRect(qt_gsi::QtToCppAdaptor<Qt::CoordinateSystem>(system).cref());
  }

  //  [expose] bool QGraphicsDropShadowEffect::sourceIsPixmap()
  bool fp_QGraphicsDropShadowEffect_sourceIsPixmap_c0 () const {
    return QGraphicsDropShadowEffect::sourceIsPixmap();
  }

  //  [expose] QPixmap QGraphicsDropShadowEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)
  QPixmap fp_QGraphicsDropShadowEffect_sourcePixmap_c6763 (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & system, QPoint *offset, const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & mode) const {
    return QGraphicsDropShadowEffect::sourcePixmap(qt_gsi::QtToCppAdaptor<Qt::CoordinateSystem>(system).cref(), offset, qt_gsi::QtToCppAdaptor<QGraphicsEffect::PixmapPadMode>(mode).cref());
  }

  //  [expose] void QGraphicsDropShadowEffect::updateBoundingRect()
  void fp_QGraphicsDropShadowEffect_updateBoundingRect_0 () {
    QGraphicsDropShadowEffect::updateBoundingRect();
  }

  //  [emitter impl] void QGraphicsDropShadowEffect::blurRadiusChanged(double blurRadius)
  void emitter_QGraphicsDropShadowEffect_blurRadiusChanged_1071(double blurRadius)
  {
    emit QGraphicsDropShadowEffect::blurRadiusChanged(blurRadius);
  }

  //  [adaptor impl] QRectF QGraphicsDropShadowEffect::boundingRectFor(const QRectF &rect)
  QRectF cbs_boundingRectFor_c1862_0(const QRectF &rect) const
  {
    return QGraphicsDropShadowEffect::boundingRectFor(rect);
  }

  virtual QRectF boundingRectFor(const QRectF &rect) const
  {
    if (cb_boundingRectFor_c1862_0.can_issue()) {
      return cb_boundingRectFor_c1862_0.issue<QGraphicsDropShadowEffect_Adaptor, QRectF, const QRectF &>(&QGraphicsDropShadowEffect_Adaptor::cbs_boundingRectFor_c1862_0, rect);
    } else {
      return QGraphicsDropShadowEffect::boundingRectFor(rect);
    }
  }

  //  [emitter impl] void QGraphicsDropShadowEffect::colorChanged(const QColor &color)
  void emitter_QGraphicsDropShadowEffect_colorChanged_1905(const QColor &color)
  {
    emit QGraphicsDropShadowEffect::colorChanged(color);
  }

  //  [emitter impl] void QGraphicsDropShadowEffect::destroyed(QObject *)
  void emitter_QGraphicsDropShadowEffect_destroyed_1302(QObject *arg1)
  {
    emit QGraphicsDropShadowEffect::destroyed(arg1);
  }

  //  [emitter impl] void QGraphicsDropShadowEffect::enabledChanged(bool enabled)
  void emitter_QGraphicsDropShadowEffect_enabledChanged_864(bool enabled)
  {
    emit QGraphicsDropShadowEffect::enabledChanged(enabled);
  }

  //  [adaptor impl] bool QGraphicsDropShadowEffect::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QGraphicsDropShadowEffect::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsDropShadowEffect_Adaptor, bool, QEvent *>(&QGraphicsDropShadowEffect_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QGraphicsDropShadowEffect::event(_event);
    }
  }

  //  [adaptor impl] bool QGraphicsDropShadowEffect::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QGraphicsDropShadowEffect::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsDropShadowEffect_Adaptor, bool, QObject *, QEvent *>(&QGraphicsDropShadowEffect_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QGraphicsDropShadowEffect::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QGraphicsDropShadowEffect::objectNameChanged(const QString &objectName)
  void emitter_QGraphicsDropShadowEffect_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QGraphicsDropShadowEffect::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QGraphicsDropShadowEffect::offsetChanged(const QPointF &offset)
  void emitter_QGraphicsDropShadowEffect_offsetChanged_1986(const QPointF &offset)
  {
    emit QGraphicsDropShadowEffect::offsetChanged(offset);
  }

  //  [adaptor impl] void QGraphicsDropShadowEffect::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QGraphicsDropShadowEffect::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsDropShadowEffect_Adaptor, QChildEvent *>(&QGraphicsDropShadowEffect_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QGraphicsDropShadowEffect::childEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsDropShadowEffect::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QGraphicsDropShadowEffect::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsDropShadowEffect_Adaptor, QEvent *>(&QGraphicsDropShadowEffect_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QGraphicsDropShadowEffect::customEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsDropShadowEffect::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QGraphicsDropShadowEffect::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QGraphicsDropShadowEffect_Adaptor, const QMetaMethod &>(&QGraphicsDropShadowEffect_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QGraphicsDropShadowEffect::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsDropShadowEffect::draw(QPainter *painter)
  void cbs_draw_1426_0(QPainter *painter)
  {
    QGraphicsDropShadowEffect::draw(painter);
  }

  virtual void draw(QPainter *painter)
  {
    if (cb_draw_1426_0.can_issue()) {
      cb_draw_1426_0.issue<QGraphicsDropShadowEffect_Adaptor, QPainter *>(&QGraphicsDropShadowEffect_Adaptor::cbs_draw_1426_0, painter);
    } else {
      QGraphicsDropShadowEffect::draw(painter);
    }
  }

  //  [adaptor impl] void QGraphicsDropShadowEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
  void cbs_sourceChanged_3695_0(QFlags<QGraphicsEffect::ChangeFlag> flags)
  {
    QGraphicsDropShadowEffect::sourceChanged(flags);
  }

  virtual void sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
  {
    if (cb_sourceChanged_3695_0.can_issue()) {
      cb_sourceChanged_3695_0.issue<QGraphicsDropShadowEffect_Adaptor, QFlags<QGraphicsEffect::ChangeFlag> >(&QGraphicsDropShadowEffect_Adaptor::cbs_sourceChanged_3695_0, flags);
    } else {
      QGraphicsDropShadowEffect::sourceChanged(flags);
    }
  }

  //  [adaptor impl] void QGraphicsDropShadowEffect::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QGraphicsDropShadowEffect::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsDropShadowEffect_Adaptor, QTimerEvent *>(&QGraphicsDropShadowEffect_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QGraphicsDropShadowEffect::timerEvent(event);
    }
  }

  gsi::Callback cb_boundingRectFor_c1862_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_draw_1426_0;
  gsi::Callback cb_sourceChanged_3695_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QGraphicsDropShadowEffect_Adaptor::~QGraphicsDropShadowEffect_Adaptor() { }

//  Constructor QGraphicsDropShadowEffect::QGraphicsDropShadowEffect(QObject *parent) (adaptor class)

static void _init_ctor_QGraphicsDropShadowEffect_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QGraphicsDropShadowEffect_Adaptor> ();
}

static void _call_ctor_QGraphicsDropShadowEffect_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QGraphicsDropShadowEffect_Adaptor *> (new QGraphicsDropShadowEffect_Adaptor (arg1));
}


// emitter void QGraphicsDropShadowEffect::blurRadiusChanged(double blurRadius)

static void _init_emitter_blurRadiusChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("blurRadius");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_blurRadiusChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->emitter_QGraphicsDropShadowEffect_blurRadiusChanged_1071 (arg1);
}


// QRectF QGraphicsDropShadowEffect::boundingRectFor(const QRectF &rect)

static void _init_cbs_boundingRectFor_c1862_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_cbs_boundingRectFor_c1862_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args.read<const QRectF & > (heap);
  ret.write<QRectF > ((QRectF)((QGraphicsDropShadowEffect_Adaptor *)cls)->cbs_boundingRectFor_c1862_0 (arg1));
}

static void _set_callback_cbs_boundingRectFor_c1862_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->cb_boundingRectFor_c1862_0 = cb;
}


// void QGraphicsDropShadowEffect::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QGraphicsDropShadowEffect::colorChanged(const QColor &color)

static void _init_emitter_colorChanged_1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("color");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_colorChanged_1905 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QColor &arg1 = gsi::arg_reader<const QColor & >() (args, heap);
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->emitter_QGraphicsDropShadowEffect_colorChanged_1905 (arg1);
}


// void QGraphicsDropShadowEffect::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QGraphicsDropShadowEffect::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->emitter_QGraphicsDropShadowEffect_destroyed_1302 (arg1);
}


// void QGraphicsDropShadowEffect::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QGraphicsDropShadowEffect::draw(QPainter *painter)

static void _init_cbs_draw_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_draw_1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->cbs_draw_1426_0 (arg1);
}

static void _set_callback_cbs_draw_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->cb_draw_1426_0 = cb;
}


// exposed void QGraphicsDropShadowEffect::drawSource(QPainter *painter)

static void _init_fp_drawSource_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawSource_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->fp_QGraphicsDropShadowEffect_drawSource_1426 (arg1);
}


// emitter void QGraphicsDropShadowEffect::enabledChanged(bool enabled)

static void _init_emitter_enabledChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_enabledChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->emitter_QGraphicsDropShadowEffect_enabledChanged_864 (arg1);
}


// bool QGraphicsDropShadowEffect::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsDropShadowEffect_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QGraphicsDropShadowEffect::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsDropShadowEffect_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QGraphicsDropShadowEffect::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsDropShadowEffect_Adaptor *)cls)->fp_QGraphicsDropShadowEffect_isSignalConnected_c2394 (arg1));
}


// emitter void QGraphicsDropShadowEffect::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->emitter_QGraphicsDropShadowEffect_objectNameChanged_4567 (arg1);
}


// emitter void QGraphicsDropShadowEffect::offsetChanged(const QPointF &offset)

static void _init_emitter_offsetChanged_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_offsetChanged_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->emitter_QGraphicsDropShadowEffect_offsetChanged_1986 (arg1);
}


// exposed int QGraphicsDropShadowEffect::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QGraphicsDropShadowEffect_Adaptor *)cls)->fp_QGraphicsDropShadowEffect_receivers_c1731 (arg1));
}


// exposed QObject *QGraphicsDropShadowEffect::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QGraphicsDropShadowEffect_Adaptor *)cls)->fp_QGraphicsDropShadowEffect_sender_c0 ());
}


// exposed int QGraphicsDropShadowEffect::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsDropShadowEffect_Adaptor *)cls)->fp_QGraphicsDropShadowEffect_senderSignalIndex_c0 ());
}


// exposed QRectF QGraphicsDropShadowEffect::sourceBoundingRect(Qt::CoordinateSystem system)

static void _init_fp_sourceBoundingRect_c2426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("system", true, "Qt::LogicalCoordinates");
  decl->add_arg<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_fp_sourceBoundingRect_c2426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::CoordinateSystem>(heap, Qt::LogicalCoordinates), heap);
  ret.write<QRectF > ((QRectF)((QGraphicsDropShadowEffect_Adaptor *)cls)->fp_QGraphicsDropShadowEffect_sourceBoundingRect_c2426 (arg1));
}


// void QGraphicsDropShadowEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)

static void _init_cbs_sourceChanged_3695_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<QGraphicsEffect::ChangeFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_sourceChanged_3695_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QGraphicsEffect::ChangeFlag> arg1 = args.read<QFlags<QGraphicsEffect::ChangeFlag> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->cbs_sourceChanged_3695_0 (arg1);
}

static void _set_callback_cbs_sourceChanged_3695_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->cb_sourceChanged_3695_0 = cb;
}


// exposed bool QGraphicsDropShadowEffect::sourceIsPixmap()

static void _init_fp_sourceIsPixmap_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_sourceIsPixmap_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsDropShadowEffect_Adaptor *)cls)->fp_QGraphicsDropShadowEffect_sourceIsPixmap_c0 ());
}


// exposed QPixmap QGraphicsDropShadowEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)

static void _init_fp_sourcePixmap_c6763 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("system", true, "Qt::LogicalCoordinates");
  decl->add_arg<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("offset", true, "nullptr");
  decl->add_arg<QPoint * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QGraphicsEffect::PadToEffectiveBoundingRect");
  decl->add_arg<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_fp_sourcePixmap_c6763 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::CoordinateSystem>(heap, Qt::LogicalCoordinates), heap);
  QPoint *arg2 = args ? gsi::arg_reader<QPoint * >() (args, heap) : gsi::arg_maker<QPoint * >() (nullptr, heap);
  const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QGraphicsEffect::PixmapPadMode>(heap, QGraphicsEffect::PadToEffectiveBoundingRect), heap);
  ret.write<QPixmap > ((QPixmap)((QGraphicsDropShadowEffect_Adaptor *)cls)->fp_QGraphicsDropShadowEffect_sourcePixmap_c6763 (arg1, arg2, arg3));
}


// void QGraphicsDropShadowEffect::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QGraphicsDropShadowEffect::updateBoundingRect()

static void _init_fp_updateBoundingRect_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateBoundingRect_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsDropShadowEffect_Adaptor *)cls)->fp_QGraphicsDropShadowEffect_updateBoundingRect_0 ();
}


namespace gsi
{

gsi::Class<QGraphicsDropShadowEffect> &qtdecl_QGraphicsDropShadowEffect ();

static gsi::Methods methods_QGraphicsDropShadowEffect_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsDropShadowEffect::QGraphicsDropShadowEffect(QObject *parent)\nThis method creates an object of class QGraphicsDropShadowEffect.", &_init_ctor_QGraphicsDropShadowEffect_Adaptor_1302, &_call_ctor_QGraphicsDropShadowEffect_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("emit_blurRadiusChanged", "@brief Emitter for signal void QGraphicsDropShadowEffect::blurRadiusChanged(double blurRadius)\nCall this method to emit this signal.", false, &_init_emitter_blurRadiusChanged_1071, &_call_emitter_blurRadiusChanged_1071);
  methods += new qt_gsi::GenericMethod ("boundingRectFor", "@brief Virtual method QRectF QGraphicsDropShadowEffect::boundingRectFor(const QRectF &rect)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_boundingRectFor_c1862_0, &_call_cbs_boundingRectFor_c1862_0);
  methods += new qt_gsi::GenericMethod ("boundingRectFor", "@hide", true, &_init_cbs_boundingRectFor_c1862_0, &_call_cbs_boundingRectFor_c1862_0, &_set_callback_cbs_boundingRectFor_c1862_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsDropShadowEffect::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_colorChanged", "@brief Emitter for signal void QGraphicsDropShadowEffect::colorChanged(const QColor &color)\nCall this method to emit this signal.", false, &_init_emitter_colorChanged_1905, &_call_emitter_colorChanged_1905);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsDropShadowEffect::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QGraphicsDropShadowEffect::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsDropShadowEffect::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*draw", "@brief Virtual method void QGraphicsDropShadowEffect::draw(QPainter *painter)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_draw_1426_0, &_call_cbs_draw_1426_0);
  methods += new qt_gsi::GenericMethod ("*draw", "@hide", false, &_init_cbs_draw_1426_0, &_call_cbs_draw_1426_0, &_set_callback_cbs_draw_1426_0);
  methods += new qt_gsi::GenericMethod ("*drawSource", "@brief Method void QGraphicsDropShadowEffect::drawSource(QPainter *painter)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawSource_1426, &_call_fp_drawSource_1426);
  methods += new qt_gsi::GenericMethod ("emit_enabledChanged", "@brief Emitter for signal void QGraphicsDropShadowEffect::enabledChanged(bool enabled)\nCall this method to emit this signal.", false, &_init_emitter_enabledChanged_864, &_call_emitter_enabledChanged_864);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QGraphicsDropShadowEffect::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QGraphicsDropShadowEffect::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QGraphicsDropShadowEffect::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QGraphicsDropShadowEffect::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("emit_offsetChanged", "@brief Emitter for signal void QGraphicsDropShadowEffect::offsetChanged(const QPointF &offset)\nCall this method to emit this signal.", false, &_init_emitter_offsetChanged_1986, &_call_emitter_offsetChanged_1986);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QGraphicsDropShadowEffect::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QGraphicsDropShadowEffect::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QGraphicsDropShadowEffect::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*sourceBoundingRect", "@brief Method QRectF QGraphicsDropShadowEffect::sourceBoundingRect(Qt::CoordinateSystem system)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourceBoundingRect_c2426, &_call_fp_sourceBoundingRect_c2426);
  methods += new qt_gsi::GenericMethod ("*sourceChanged", "@brief Virtual method void QGraphicsDropShadowEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sourceChanged_3695_0, &_call_cbs_sourceChanged_3695_0);
  methods += new qt_gsi::GenericMethod ("*sourceChanged", "@hide", false, &_init_cbs_sourceChanged_3695_0, &_call_cbs_sourceChanged_3695_0, &_set_callback_cbs_sourceChanged_3695_0);
  methods += new qt_gsi::GenericMethod ("*sourceIsPixmap", "@brief Method bool QGraphicsDropShadowEffect::sourceIsPixmap()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourceIsPixmap_c0, &_call_fp_sourceIsPixmap_c0);
  methods += new qt_gsi::GenericMethod ("*sourcePixmap", "@brief Method QPixmap QGraphicsDropShadowEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourcePixmap_c6763, &_call_fp_sourcePixmap_c6763);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsDropShadowEffect::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateBoundingRect", "@brief Method void QGraphicsDropShadowEffect::updateBoundingRect()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateBoundingRect_0, &_call_fp_updateBoundingRect_0);
  return methods;
}

gsi::Class<QGraphicsDropShadowEffect_Adaptor> decl_QGraphicsDropShadowEffect_Adaptor (qtdecl_QGraphicsDropShadowEffect (), "QtWidgets", "QGraphicsDropShadowEffect",
  methods_QGraphicsDropShadowEffect_Adaptor (),
  "@qt\n@brief Binding of QGraphicsDropShadowEffect");

}

