
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQNetworkSession.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QNetworkSession>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QNetworkConfiguration>
#include <QNetworkInterface>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtNetworkCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QNetworkSession

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QNetworkSession::staticMetaObject);
}


// void QNetworkSession::accept()


static void _init_f_accept_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_accept_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkSession *)cls)->accept ();
}


// quint64 QNetworkSession::activeTime()


static void _init_f_activeTime_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<quint64 > ();
}

static void _call_f_activeTime_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<quint64 > ((quint64)((QNetworkSession *)cls)->activeTime ());
}


// quint64 QNetworkSession::bytesReceived()


static void _init_f_bytesReceived_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<quint64 > ();
}

static void _call_f_bytesReceived_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<quint64 > ((quint64)((QNetworkSession *)cls)->bytesReceived ());
}


// quint64 QNetworkSession::bytesWritten()


static void _init_f_bytesWritten_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<quint64 > ();
}

static void _call_f_bytesWritten_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<quint64 > ((quint64)((QNetworkSession *)cls)->bytesWritten ());
}


// void QNetworkSession::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkSession *)cls)->close ();
}


// QNetworkConfiguration QNetworkSession::configuration()


static void _init_f_configuration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNetworkConfiguration > ();
}

static void _call_f_configuration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QNetworkConfiguration > ((QNetworkConfiguration)((QNetworkSession *)cls)->configuration ());
}


// QNetworkSession::SessionError QNetworkSession::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QNetworkSession::SessionError>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QNetworkSession::SessionError>::target_type > ((qt_gsi::Converter<QNetworkSession::SessionError>::target_type)qt_gsi::CppToQtAdaptor<QNetworkSession::SessionError>(((QNetworkSession *)cls)->error ()));
}


// QString QNetworkSession::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QNetworkSession *)cls)->errorString ());
}


// void QNetworkSession::ignore()


static void _init_f_ignore_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_ignore_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkSession *)cls)->ignore ();
}


// QNetworkInterface QNetworkSession::interface()


static void _init_f_interface_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNetworkInterface > ();
}

static void _call_f_interface_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QNetworkInterface > ((QNetworkInterface)((QNetworkSession *)cls)->interface ());
}


// bool QNetworkSession::isOpen()


static void _init_f_isOpen_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isOpen_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QNetworkSession *)cls)->isOpen ());
}


// void QNetworkSession::migrate()


static void _init_f_migrate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_migrate_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkSession *)cls)->migrate ();
}


// void QNetworkSession::open()


static void _init_f_open_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_open_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkSession *)cls)->open ();
}


// void QNetworkSession::reject()


static void _init_f_reject_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_reject_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkSession *)cls)->reject ();
}


// QVariant QNetworkSession::sessionProperty(const QString &key)


static void _init_f_sessionProperty_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_sessionProperty_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QNetworkSession *)cls)->sessionProperty (arg1));
}


// void QNetworkSession::setSessionProperty(const QString &key, const QVariant &value)


static void _init_f_setSessionProperty_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSessionProperty_4036 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkSession *)cls)->setSessionProperty (arg1, arg2);
}


// QNetworkSession::State QNetworkSession::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QNetworkSession::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QNetworkSession::State>::target_type > ((qt_gsi::Converter<QNetworkSession::State>::target_type)qt_gsi::CppToQtAdaptor<QNetworkSession::State>(((QNetworkSession *)cls)->state ()));
}


// void QNetworkSession::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkSession *)cls)->stop ();
}


// QFlags<QNetworkSession::UsagePolicy> QNetworkSession::usagePolicies()


static void _init_f_usagePolicies_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QNetworkSession::UsagePolicy> > ();
}

static void _call_f_usagePolicies_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QNetworkSession::UsagePolicy> > ((QFlags<QNetworkSession::UsagePolicy>)((QNetworkSession *)cls)->usagePolicies ());
}


// bool QNetworkSession::waitForOpened(int msecs)


static void _init_f_waitForOpened_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForOpened_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (30000, heap);
  ret.write<bool > ((bool)((QNetworkSession *)cls)->waitForOpened (arg1));
}


// static QString QNetworkSession::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QNetworkSession::tr (arg1, arg2, arg3));
}


// static QString QNetworkSession::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QNetworkSession::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QNetworkSession () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("accept", "@brief Method void QNetworkSession::accept()\n", false, &_init_f_accept_0, &_call_f_accept_0);
  methods += new qt_gsi::GenericMethod ("activeTime", "@brief Method quint64 QNetworkSession::activeTime()\n", true, &_init_f_activeTime_c0, &_call_f_activeTime_c0);
  methods += new qt_gsi::GenericMethod ("bytesReceived", "@brief Method quint64 QNetworkSession::bytesReceived()\n", true, &_init_f_bytesReceived_c0, &_call_f_bytesReceived_c0);
  methods += new qt_gsi::GenericMethod ("bytesWritten", "@brief Method quint64 QNetworkSession::bytesWritten()\n", true, &_init_f_bytesWritten_c0, &_call_f_bytesWritten_c0);
  methods += new qt_gsi::GenericMethod ("close", "@brief Method void QNetworkSession::close()\n", false, &_init_f_close_0, &_call_f_close_0);
  methods += new qt_gsi::GenericMethod ("configuration", "@brief Method QNetworkConfiguration QNetworkSession::configuration()\n", true, &_init_f_configuration_c0, &_call_f_configuration_c0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QNetworkSession::SessionError QNetworkSession::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QNetworkSession::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("ignore", "@brief Method void QNetworkSession::ignore()\n", false, &_init_f_ignore_0, &_call_f_ignore_0);
  methods += new qt_gsi::GenericMethod ("interface", "@brief Method QNetworkInterface QNetworkSession::interface()\n", true, &_init_f_interface_c0, &_call_f_interface_c0);
  methods += new qt_gsi::GenericMethod ("isOpen?", "@brief Method bool QNetworkSession::isOpen()\n", true, &_init_f_isOpen_c0, &_call_f_isOpen_c0);
  methods += new qt_gsi::GenericMethod ("migrate", "@brief Method void QNetworkSession::migrate()\n", false, &_init_f_migrate_0, &_call_f_migrate_0);
  methods += new qt_gsi::GenericMethod ("open", "@brief Method void QNetworkSession::open()\n", false, &_init_f_open_0, &_call_f_open_0);
  methods += new qt_gsi::GenericMethod ("reject", "@brief Method void QNetworkSession::reject()\n", false, &_init_f_reject_0, &_call_f_reject_0);
  methods += new qt_gsi::GenericMethod ("sessionProperty", "@brief Method QVariant QNetworkSession::sessionProperty(const QString &key)\n", true, &_init_f_sessionProperty_c2025, &_call_f_sessionProperty_c2025);
  methods += new qt_gsi::GenericMethod ("setSessionProperty", "@brief Method void QNetworkSession::setSessionProperty(const QString &key, const QVariant &value)\n", false, &_init_f_setSessionProperty_4036, &_call_f_setSessionProperty_4036);
  methods += new qt_gsi::GenericMethod ("state", "@brief Method QNetworkSession::State QNetworkSession::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QNetworkSession::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod ("usagePolicies", "@brief Method QFlags<QNetworkSession::UsagePolicy> QNetworkSession::usagePolicies()\n", true, &_init_f_usagePolicies_c0, &_call_f_usagePolicies_c0);
  methods += new qt_gsi::GenericMethod ("waitForOpened", "@brief Method bool QNetworkSession::waitForOpened(int msecs)\n", false, &_init_f_waitForOpened_767, &_call_f_waitForOpened_767);
  methods += gsi::qt_signal ("closed()", "closed", "@brief Signal declaration for QNetworkSession::closed()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QNetworkSession::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QNetworkSession::SessionError>::target_type & > ("error(QNetworkSession::SessionError)", "error_sig", gsi::arg("arg1"), "@brief Signal declaration for QNetworkSession::error(QNetworkSession::SessionError)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("newConfigurationActivated()", "newConfigurationActivated", "@brief Signal declaration for QNetworkSession::newConfigurationActivated()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QNetworkSession::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("opened()", "opened", "@brief Signal declaration for QNetworkSession::opened()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QNetworkConfiguration &, bool > ("preferredConfigurationChanged(const QNetworkConfiguration &, bool)", "preferredConfigurationChanged", gsi::arg("config"), gsi::arg("isSeamless"), "@brief Signal declaration for QNetworkSession::preferredConfigurationChanged(const QNetworkConfiguration &config, bool isSeamless)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QNetworkSession::State>::target_type & > ("stateChanged(QNetworkSession::State)", "stateChanged", gsi::arg("arg1"), "@brief Signal declaration for QNetworkSession::stateChanged(QNetworkSession::State)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QFlags<QNetworkSession::UsagePolicy> > ("usagePoliciesChanged(QFlags<QNetworkSession::UsagePolicy>)", "usagePoliciesChanged", gsi::arg("usagePolicies"), "@brief Signal declaration for QNetworkSession::usagePoliciesChanged(QFlags<QNetworkSession::UsagePolicy> usagePolicies)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QNetworkSession::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QNetworkSession::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QNetworkSession> decl_QNetworkSession (qtdecl_QObject (), "QtNetwork", "QNetworkSession_Native",
  methods_QNetworkSession (),
  "@hide\n@alias QNetworkSession");

GSI_QTNETWORK_PUBLIC gsi::Class<QNetworkSession> &qtdecl_QNetworkSession () { return decl_QNetworkSession; }

}


class QNetworkSession_Adaptor : public QNetworkSession, public qt_gsi::QtObjectBase
{
public:

  virtual ~QNetworkSession_Adaptor();

  //  [adaptor ctor] QNetworkSession::QNetworkSession(const QNetworkConfiguration &connConfig, QObject *parent)
  QNetworkSession_Adaptor(const QNetworkConfiguration &connConfig) : QNetworkSession(connConfig)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QNetworkSession::QNetworkSession(const QNetworkConfiguration &connConfig, QObject *parent)
  QNetworkSession_Adaptor(const QNetworkConfiguration &connConfig, QObject *parent) : QNetworkSession(connConfig, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QNetworkSession::isSignalConnected(const QMetaMethod &signal)
  bool fp_QNetworkSession_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QNetworkSession::isSignalConnected(signal);
  }

  //  [expose] int QNetworkSession::receivers(const char *signal)
  int fp_QNetworkSession_receivers_c1731 (const char *signal) const {
    return QNetworkSession::receivers(signal);
  }

  //  [expose] QObject *QNetworkSession::sender()
  QObject * fp_QNetworkSession_sender_c0 () const {
    return QNetworkSession::sender();
  }

  //  [expose] int QNetworkSession::senderSignalIndex()
  int fp_QNetworkSession_senderSignalIndex_c0 () const {
    return QNetworkSession::senderSignalIndex();
  }

  //  [emitter impl] void QNetworkSession::closed()
  void emitter_QNetworkSession_closed_0()
  {
    emit QNetworkSession::closed();
  }

  //  [emitter impl] void QNetworkSession::destroyed(QObject *)
  void emitter_QNetworkSession_destroyed_1302(QObject *arg1)
  {
    emit QNetworkSession::destroyed(arg1);
  }

  //  [emitter impl] void QNetworkSession::error(QNetworkSession::SessionError)
  void emitter_QNetworkSession_error_3381(QNetworkSession::SessionError arg1)
  {
    emit QNetworkSession::error(arg1);
  }

  //  [adaptor impl] bool QNetworkSession::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QNetworkSession::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QNetworkSession_Adaptor, bool, QEvent *>(&QNetworkSession_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QNetworkSession::event(_event);
    }
  }

  //  [adaptor impl] bool QNetworkSession::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QNetworkSession::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QNetworkSession_Adaptor, bool, QObject *, QEvent *>(&QNetworkSession_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QNetworkSession::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QNetworkSession::newConfigurationActivated()
  void emitter_QNetworkSession_newConfigurationActivated_0()
  {
    emit QNetworkSession::newConfigurationActivated();
  }

  //  [emitter impl] void QNetworkSession::objectNameChanged(const QString &objectName)
  void emitter_QNetworkSession_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QNetworkSession::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QNetworkSession::opened()
  void emitter_QNetworkSession_opened_0()
  {
    emit QNetworkSession::opened();
  }

  //  [emitter impl] void QNetworkSession::preferredConfigurationChanged(const QNetworkConfiguration &config, bool isSeamless)
  void emitter_QNetworkSession_preferredConfigurationChanged_4264(const QNetworkConfiguration &config, bool isSeamless)
  {
    emit QNetworkSession::preferredConfigurationChanged(config, isSeamless);
  }

  //  [emitter impl] void QNetworkSession::stateChanged(QNetworkSession::State)
  void emitter_QNetworkSession_stateChanged_2632(QNetworkSession::State arg1)
  {
    emit QNetworkSession::stateChanged(arg1);
  }

  //  [emitter impl] void QNetworkSession::usagePoliciesChanged(QFlags<QNetworkSession::UsagePolicy> usagePolicies)
  void emitter_QNetworkSession_usagePoliciesChanged_3940(QFlags<QNetworkSession::UsagePolicy> usagePolicies)
  {
    emit QNetworkSession::usagePoliciesChanged(usagePolicies);
  }

  //  [adaptor impl] void QNetworkSession::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QNetworkSession::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QNetworkSession_Adaptor, QChildEvent *>(&QNetworkSession_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QNetworkSession::childEvent(event);
    }
  }

  //  [adaptor impl] void QNetworkSession::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QNetworkSession::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QNetworkSession_Adaptor, QEvent *>(&QNetworkSession_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QNetworkSession::customEvent(event);
    }
  }

  //  [adaptor impl] void QNetworkSession::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QNetworkSession::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QNetworkSession_Adaptor, const QMetaMethod &>(&QNetworkSession_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QNetworkSession::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QNetworkSession::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QNetworkSession::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QNetworkSession_Adaptor, QTimerEvent *>(&QNetworkSession_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QNetworkSession::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QNetworkSession_Adaptor::~QNetworkSession_Adaptor() { }

//  Constructor QNetworkSession::QNetworkSession(const QNetworkConfiguration &connConfig, QObject *parent) (adaptor class)

static void _init_ctor_QNetworkSession_Adaptor_4702 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("connConfig");
  decl->add_arg<const QNetworkConfiguration & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QNetworkSession_Adaptor> ();
}

static void _call_ctor_QNetworkSession_Adaptor_4702 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkConfiguration &arg1 = gsi::arg_reader<const QNetworkConfiguration & >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QNetworkSession_Adaptor *> (new QNetworkSession_Adaptor (arg1, arg2));
}


// void QNetworkSession::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkSession_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkSession_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QNetworkSession::closed()

static void _init_emitter_closed_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_closed_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QNetworkSession_Adaptor *)cls)->emitter_QNetworkSession_closed_0 ();
}


// void QNetworkSession::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkSession_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkSession_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QNetworkSession::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QNetworkSession_Adaptor *)cls)->emitter_QNetworkSession_destroyed_1302 (arg1);
}


// void QNetworkSession::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkSession_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkSession_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// emitter void QNetworkSession::error(QNetworkSession::SessionError)

static void _init_emitter_error_3381 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QNetworkSession::SessionError>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_error_3381 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QNetworkSession::SessionError>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QNetworkSession::SessionError>::target_type & >() (args, heap);
  ((QNetworkSession_Adaptor *)cls)->emitter_QNetworkSession_error_3381 (arg1);
}


// bool QNetworkSession::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QNetworkSession_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkSession_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QNetworkSession::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QNetworkSession_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkSession_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QNetworkSession::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QNetworkSession_Adaptor *)cls)->fp_QNetworkSession_isSignalConnected_c2394 (arg1));
}


// emitter void QNetworkSession::newConfigurationActivated()

static void _init_emitter_newConfigurationActivated_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_newConfigurationActivated_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QNetworkSession_Adaptor *)cls)->emitter_QNetworkSession_newConfigurationActivated_0 ();
}


// emitter void QNetworkSession::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QNetworkSession_Adaptor *)cls)->emitter_QNetworkSession_objectNameChanged_4567 (arg1);
}


// emitter void QNetworkSession::opened()

static void _init_emitter_opened_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_opened_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QNetworkSession_Adaptor *)cls)->emitter_QNetworkSession_opened_0 ();
}


// emitter void QNetworkSession::preferredConfigurationChanged(const QNetworkConfiguration &config, bool isSeamless)

static void _init_emitter_preferredConfigurationChanged_4264 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("config");
  decl->add_arg<const QNetworkConfiguration & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("isSeamless");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_preferredConfigurationChanged_4264 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkConfiguration &arg1 = gsi::arg_reader<const QNetworkConfiguration & >() (args, heap);
  bool arg2 = gsi::arg_reader<bool >() (args, heap);
  ((QNetworkSession_Adaptor *)cls)->emitter_QNetworkSession_preferredConfigurationChanged_4264 (arg1, arg2);
}


// exposed int QNetworkSession::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QNetworkSession_Adaptor *)cls)->fp_QNetworkSession_receivers_c1731 (arg1));
}


// exposed QObject *QNetworkSession::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QNetworkSession_Adaptor *)cls)->fp_QNetworkSession_sender_c0 ());
}


// exposed int QNetworkSession::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QNetworkSession_Adaptor *)cls)->fp_QNetworkSession_senderSignalIndex_c0 ());
}


// emitter void QNetworkSession::stateChanged(QNetworkSession::State)

static void _init_emitter_stateChanged_2632 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QNetworkSession::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_stateChanged_2632 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QNetworkSession::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QNetworkSession::State>::target_type & >() (args, heap);
  ((QNetworkSession_Adaptor *)cls)->emitter_QNetworkSession_stateChanged_2632 (arg1);
}


// void QNetworkSession::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QNetworkSession_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkSession_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QNetworkSession::usagePoliciesChanged(QFlags<QNetworkSession::UsagePolicy> usagePolicies)

static void _init_emitter_usagePoliciesChanged_3940 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("usagePolicies");
  decl->add_arg<QFlags<QNetworkSession::UsagePolicy> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_usagePoliciesChanged_3940 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QNetworkSession::UsagePolicy> arg1 = gsi::arg_reader<QFlags<QNetworkSession::UsagePolicy> >() (args, heap);
  ((QNetworkSession_Adaptor *)cls)->emitter_QNetworkSession_usagePoliciesChanged_3940 (arg1);
}


namespace gsi
{

gsi::Class<QNetworkSession> &qtdecl_QNetworkSession ();

static gsi::Methods methods_QNetworkSession_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QNetworkSession::QNetworkSession(const QNetworkConfiguration &connConfig, QObject *parent)\nThis method creates an object of class QNetworkSession.", &_init_ctor_QNetworkSession_Adaptor_4702, &_call_ctor_QNetworkSession_Adaptor_4702);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QNetworkSession::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_closed", "@brief Emitter for signal void QNetworkSession::closed()\nCall this method to emit this signal.", false, &_init_emitter_closed_0, &_call_emitter_closed_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QNetworkSession::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QNetworkSession::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QNetworkSession::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("emit_error_sig", "@brief Emitter for signal void QNetworkSession::error(QNetworkSession::SessionError)\nCall this method to emit this signal.", false, &_init_emitter_error_3381, &_call_emitter_error_3381);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QNetworkSession::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QNetworkSession::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QNetworkSession::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_newConfigurationActivated", "@brief Emitter for signal void QNetworkSession::newConfigurationActivated()\nCall this method to emit this signal.", false, &_init_emitter_newConfigurationActivated_0, &_call_emitter_newConfigurationActivated_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QNetworkSession::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("emit_opened", "@brief Emitter for signal void QNetworkSession::opened()\nCall this method to emit this signal.", false, &_init_emitter_opened_0, &_call_emitter_opened_0);
  methods += new qt_gsi::GenericMethod ("emit_preferredConfigurationChanged", "@brief Emitter for signal void QNetworkSession::preferredConfigurationChanged(const QNetworkConfiguration &config, bool isSeamless)\nCall this method to emit this signal.", false, &_init_emitter_preferredConfigurationChanged_4264, &_call_emitter_preferredConfigurationChanged_4264);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QNetworkSession::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QNetworkSession::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QNetworkSession::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("emit_stateChanged", "@brief Emitter for signal void QNetworkSession::stateChanged(QNetworkSession::State)\nCall this method to emit this signal.", false, &_init_emitter_stateChanged_2632, &_call_emitter_stateChanged_2632);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QNetworkSession::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_usagePoliciesChanged", "@brief Emitter for signal void QNetworkSession::usagePoliciesChanged(QFlags<QNetworkSession::UsagePolicy> usagePolicies)\nCall this method to emit this signal.", false, &_init_emitter_usagePoliciesChanged_3940, &_call_emitter_usagePoliciesChanged_3940);
  return methods;
}

gsi::Class<QNetworkSession_Adaptor> decl_QNetworkSession_Adaptor (qtdecl_QNetworkSession (), "QtNetwork", "QNetworkSession",
  methods_QNetworkSession_Adaptor (),
  "@qt\n@brief Binding of QNetworkSession");

}


//  Implementation of the enum wrapper class for QNetworkSession::SessionError
namespace qt_gsi
{

static gsi::Enum<QNetworkSession::SessionError> decl_QNetworkSession_SessionError_Enum ("QtNetwork", "QNetworkSession_SessionError",
    gsi::enum_const ("UnknownSessionError", QNetworkSession::UnknownSessionError, "@brief Enum constant QNetworkSession::UnknownSessionError") +
    gsi::enum_const ("SessionAbortedError", QNetworkSession::SessionAbortedError, "@brief Enum constant QNetworkSession::SessionAbortedError") +
    gsi::enum_const ("RoamingError", QNetworkSession::RoamingError, "@brief Enum constant QNetworkSession::RoamingError") +
    gsi::enum_const ("OperationNotSupportedError", QNetworkSession::OperationNotSupportedError, "@brief Enum constant QNetworkSession::OperationNotSupportedError") +
    gsi::enum_const ("InvalidConfigurationError", QNetworkSession::InvalidConfigurationError, "@brief Enum constant QNetworkSession::InvalidConfigurationError"),
  "@qt\n@brief This class represents the QNetworkSession::SessionError enum");

static gsi::QFlagsClass<QNetworkSession::SessionError > decl_QNetworkSession_SessionError_Enums ("QtNetwork", "QNetworkSession_QFlags_SessionError",
  "@qt\n@brief This class represents the QFlags<QNetworkSession::SessionError> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QNetworkSession> inject_QNetworkSession_SessionError_Enum_in_parent (decl_QNetworkSession_SessionError_Enum.defs ());
static gsi::ClassExt<QNetworkSession> decl_QNetworkSession_SessionError_Enum_as_child (decl_QNetworkSession_SessionError_Enum, "SessionError");
static gsi::ClassExt<QNetworkSession> decl_QNetworkSession_SessionError_Enums_as_child (decl_QNetworkSession_SessionError_Enums, "QFlags_SessionError");

}


//  Implementation of the enum wrapper class for QNetworkSession::State
namespace qt_gsi
{

static gsi::Enum<QNetworkSession::State> decl_QNetworkSession_State_Enum ("QtNetwork", "QNetworkSession_State",
    gsi::enum_const ("Invalid", QNetworkSession::Invalid, "@brief Enum constant QNetworkSession::Invalid") +
    gsi::enum_const ("NotAvailable", QNetworkSession::NotAvailable, "@brief Enum constant QNetworkSession::NotAvailable") +
    gsi::enum_const ("Connecting", QNetworkSession::Connecting, "@brief Enum constant QNetworkSession::Connecting") +
    gsi::enum_const ("Connected", QNetworkSession::Connected, "@brief Enum constant QNetworkSession::Connected") +
    gsi::enum_const ("Closing", QNetworkSession::Closing, "@brief Enum constant QNetworkSession::Closing") +
    gsi::enum_const ("Disconnected", QNetworkSession::Disconnected, "@brief Enum constant QNetworkSession::Disconnected") +
    gsi::enum_const ("Roaming", QNetworkSession::Roaming, "@brief Enum constant QNetworkSession::Roaming"),
  "@qt\n@brief This class represents the QNetworkSession::State enum");

static gsi::QFlagsClass<QNetworkSession::State > decl_QNetworkSession_State_Enums ("QtNetwork", "QNetworkSession_QFlags_State",
  "@qt\n@brief This class represents the QFlags<QNetworkSession::State> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QNetworkSession> inject_QNetworkSession_State_Enum_in_parent (decl_QNetworkSession_State_Enum.defs ());
static gsi::ClassExt<QNetworkSession> decl_QNetworkSession_State_Enum_as_child (decl_QNetworkSession_State_Enum, "State");
static gsi::ClassExt<QNetworkSession> decl_QNetworkSession_State_Enums_as_child (decl_QNetworkSession_State_Enums, "QFlags_State");

}


//  Implementation of the enum wrapper class for QNetworkSession::UsagePolicy
namespace qt_gsi
{

static gsi::Enum<QNetworkSession::UsagePolicy> decl_QNetworkSession_UsagePolicy_Enum ("QtNetwork", "QNetworkSession_UsagePolicy",
    gsi::enum_const ("NoPolicy", QNetworkSession::NoPolicy, "@brief Enum constant QNetworkSession::NoPolicy") +
    gsi::enum_const ("NoBackgroundTrafficPolicy", QNetworkSession::NoBackgroundTrafficPolicy, "@brief Enum constant QNetworkSession::NoBackgroundTrafficPolicy"),
  "@qt\n@brief This class represents the QNetworkSession::UsagePolicy enum");

static gsi::QFlagsClass<QNetworkSession::UsagePolicy > decl_QNetworkSession_UsagePolicy_Enums ("QtNetwork", "QNetworkSession_QFlags_UsagePolicy",
  "@qt\n@brief This class represents the QFlags<QNetworkSession::UsagePolicy> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QNetworkSession> inject_QNetworkSession_UsagePolicy_Enum_in_parent (decl_QNetworkSession_UsagePolicy_Enum.defs ());
static gsi::ClassExt<QNetworkSession> decl_QNetworkSession_UsagePolicy_Enum_as_child (decl_QNetworkSession_UsagePolicy_Enum, "UsagePolicy");
static gsi::ClassExt<QNetworkSession> decl_QNetworkSession_UsagePolicy_Enums_as_child (decl_QNetworkSession_UsagePolicy_Enums, "QFlags_UsagePolicy");

}

