
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCameraImageCaptureControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCameraImageCaptureControl>
#include <QChildEvent>
#include <QEvent>
#include <QImage>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include <QVideoFrame>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCameraImageCaptureControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCameraImageCaptureControl::staticMetaObject);
}


// void QCameraImageCaptureControl::cancelCapture()


static void _init_f_cancelCapture_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_cancelCapture_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCaptureControl *)cls)->cancelCapture ();
}


// int QCameraImageCaptureControl::capture(const QString &fileName)


static void _init_f_capture_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_capture_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<int > ((int)((QCameraImageCaptureControl *)cls)->capture (arg1));
}


// QCameraImageCapture::DriveMode QCameraImageCaptureControl::driveMode()


static void _init_f_driveMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCameraImageCapture::DriveMode>::target_type > ();
}

static void _call_f_driveMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCameraImageCapture::DriveMode>::target_type > ((qt_gsi::Converter<QCameraImageCapture::DriveMode>::target_type)qt_gsi::CppToQtAdaptor<QCameraImageCapture::DriveMode>(((QCameraImageCaptureControl *)cls)->driveMode ()));
}


// bool QCameraImageCaptureControl::isReadyForCapture()


static void _init_f_isReadyForCapture_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isReadyForCapture_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCameraImageCaptureControl *)cls)->isReadyForCapture ());
}


// void QCameraImageCaptureControl::setDriveMode(QCameraImageCapture::DriveMode mode)


static void _init_f_setDriveMode_3320 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCameraImageCapture::DriveMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDriveMode_3320 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraImageCapture::DriveMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraImageCapture::DriveMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCaptureControl *)cls)->setDriveMode (qt_gsi::QtToCppAdaptor<QCameraImageCapture::DriveMode>(arg1).cref());
}


// static QString QCameraImageCaptureControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraImageCaptureControl::tr (arg1, arg2, arg3));
}


// static QString QCameraImageCaptureControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraImageCaptureControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QCameraImageCaptureControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("cancelCapture", "@brief Method void QCameraImageCaptureControl::cancelCapture()\n", false, &_init_f_cancelCapture_0, &_call_f_cancelCapture_0);
  methods += new qt_gsi::GenericMethod ("capture", "@brief Method int QCameraImageCaptureControl::capture(const QString &fileName)\n", false, &_init_f_capture_2025, &_call_f_capture_2025);
  methods += new qt_gsi::GenericMethod (":driveMode", "@brief Method QCameraImageCapture::DriveMode QCameraImageCaptureControl::driveMode()\n", true, &_init_f_driveMode_c0, &_call_f_driveMode_c0);
  methods += new qt_gsi::GenericMethod ("isReadyForCapture?", "@brief Method bool QCameraImageCaptureControl::isReadyForCapture()\n", true, &_init_f_isReadyForCapture_c0, &_call_f_isReadyForCapture_c0);
  methods += new qt_gsi::GenericMethod ("setDriveMode|driveMode=", "@brief Method void QCameraImageCaptureControl::setDriveMode(QCameraImageCapture::DriveMode mode)\n", false, &_init_f_setDriveMode_3320, &_call_f_setDriveMode_3320);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QCameraImageCaptureControl::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, int, const QString & > ("error(int, int, const QString &)", "error", gsi::arg("id"), gsi::arg("error"), gsi::arg("errorString"), "@brief Signal declaration for QCameraImageCaptureControl::error(int id, int error, const QString &errorString)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, const QVideoFrame & > ("imageAvailable(int, const QVideoFrame &)", "imageAvailable", gsi::arg("requestId"), gsi::arg("buffer"), "@brief Signal declaration for QCameraImageCaptureControl::imageAvailable(int requestId, const QVideoFrame &buffer)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, const QImage & > ("imageCaptured(int, const QImage &)", "imageCaptured", gsi::arg("requestId"), gsi::arg("preview"), "@brief Signal declaration for QCameraImageCaptureControl::imageCaptured(int requestId, const QImage &preview)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("imageExposed(int)", "imageExposed", gsi::arg("requestId"), "@brief Signal declaration for QCameraImageCaptureControl::imageExposed(int requestId)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, const QString &, const QVariant & > ("imageMetadataAvailable(int, const QString &, const QVariant &)", "imageMetadataAvailable", gsi::arg("id"), gsi::arg("key"), gsi::arg("value"), "@brief Signal declaration for QCameraImageCaptureControl::imageMetadataAvailable(int id, const QString &key, const QVariant &value)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, const QString & > ("imageSaved(int, const QString &)", "imageSaved", gsi::arg("requestId"), gsi::arg("fileName"), "@brief Signal declaration for QCameraImageCaptureControl::imageSaved(int requestId, const QString &fileName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QCameraImageCaptureControl::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("readyForCaptureChanged(bool)", "readyForCaptureChanged", gsi::arg("ready"), "@brief Signal declaration for QCameraImageCaptureControl::readyForCaptureChanged(bool ready)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCameraImageCaptureControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCameraImageCaptureControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QCameraImageCaptureControl> decl_QCameraImageCaptureControl (qtdecl_QMediaControl (), "QtMultimedia", "QCameraImageCaptureControl_Native",
  methods_QCameraImageCaptureControl (),
  "@hide\n@alias QCameraImageCaptureControl");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QCameraImageCaptureControl> &qtdecl_QCameraImageCaptureControl () { return decl_QCameraImageCaptureControl; }

}


class QCameraImageCaptureControl_Adaptor : public QCameraImageCaptureControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCameraImageCaptureControl_Adaptor();

  //  [adaptor ctor] QCameraImageCaptureControl::QCameraImageCaptureControl()
  QCameraImageCaptureControl_Adaptor() : QCameraImageCaptureControl()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QCameraImageCaptureControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QCameraImageCaptureControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QCameraImageCaptureControl::isSignalConnected(signal);
  }

  //  [expose] int QCameraImageCaptureControl::receivers(const char *signal)
  int fp_QCameraImageCaptureControl_receivers_c1731 (const char *signal) const {
    return QCameraImageCaptureControl::receivers(signal);
  }

  //  [expose] QObject *QCameraImageCaptureControl::sender()
  QObject * fp_QCameraImageCaptureControl_sender_c0 () const {
    return QCameraImageCaptureControl::sender();
  }

  //  [expose] int QCameraImageCaptureControl::senderSignalIndex()
  int fp_QCameraImageCaptureControl_senderSignalIndex_c0 () const {
    return QCameraImageCaptureControl::senderSignalIndex();
  }

  //  [adaptor impl] void QCameraImageCaptureControl::cancelCapture()
  void cbs_cancelCapture_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("cancelCapture");
  }

  virtual void cancelCapture()
  {
    if (cb_cancelCapture_0_0.can_issue()) {
      cb_cancelCapture_0_0.issue<QCameraImageCaptureControl_Adaptor>(&QCameraImageCaptureControl_Adaptor::cbs_cancelCapture_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("cancelCapture");
    }
  }

  //  [adaptor impl] int QCameraImageCaptureControl::capture(const QString &fileName)
  int cbs_capture_2025_0(const QString &fileName)
  {
    __SUPPRESS_UNUSED_WARNING (fileName);
    throw qt_gsi::AbstractMethodCalledException("capture");
  }

  virtual int capture(const QString &fileName)
  {
    if (cb_capture_2025_0.can_issue()) {
      return cb_capture_2025_0.issue<QCameraImageCaptureControl_Adaptor, int, const QString &>(&QCameraImageCaptureControl_Adaptor::cbs_capture_2025_0, fileName);
    } else {
      throw qt_gsi::AbstractMethodCalledException("capture");
    }
  }

  //  [emitter impl] void QCameraImageCaptureControl::destroyed(QObject *)
  void emitter_QCameraImageCaptureControl_destroyed_1302(QObject *arg1)
  {
    emit QCameraImageCaptureControl::destroyed(arg1);
  }

  //  [adaptor impl] QCameraImageCapture::DriveMode QCameraImageCaptureControl::driveMode()
  qt_gsi::Converter<QCameraImageCapture::DriveMode>::target_type cbs_driveMode_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("driveMode");
  }

  virtual QCameraImageCapture::DriveMode driveMode() const
  {
    if (cb_driveMode_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QCameraImageCapture::DriveMode>(cb_driveMode_c0_0.issue<QCameraImageCaptureControl_Adaptor, qt_gsi::Converter<QCameraImageCapture::DriveMode>::target_type>(&QCameraImageCaptureControl_Adaptor::cbs_driveMode_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("driveMode");
    }
  }

  //  [emitter impl] void QCameraImageCaptureControl::error(int id, int error, const QString &errorString)
  void emitter_QCameraImageCaptureControl_error_3343(int id, int _error, const QString &errorString)
  {
    emit QCameraImageCaptureControl::error(id, _error, errorString);
  }

  //  [adaptor impl] bool QCameraImageCaptureControl::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QCameraImageCaptureControl::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCameraImageCaptureControl_Adaptor, bool, QEvent *>(&QCameraImageCaptureControl_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QCameraImageCaptureControl::event(_event);
    }
  }

  //  [adaptor impl] bool QCameraImageCaptureControl::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QCameraImageCaptureControl::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCameraImageCaptureControl_Adaptor, bool, QObject *, QEvent *>(&QCameraImageCaptureControl_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QCameraImageCaptureControl::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QCameraImageCaptureControl::imageAvailable(int requestId, const QVideoFrame &buffer)
  void emitter_QCameraImageCaptureControl_imageAvailable_3047(int requestId, const QVideoFrame &buffer)
  {
    emit QCameraImageCaptureControl::imageAvailable(requestId, buffer);
  }

  //  [emitter impl] void QCameraImageCaptureControl::imageCaptured(int requestId, const QImage &preview)
  void emitter_QCameraImageCaptureControl_imageCaptured_2536(int requestId, const QImage &preview)
  {
    emit QCameraImageCaptureControl::imageCaptured(requestId, preview);
  }

  //  [emitter impl] void QCameraImageCaptureControl::imageExposed(int requestId)
  void emitter_QCameraImageCaptureControl_imageExposed_767(int requestId)
  {
    emit QCameraImageCaptureControl::imageExposed(requestId);
  }

  //  [emitter impl] void QCameraImageCaptureControl::imageMetadataAvailable(int id, const QString &key, const QVariant &value)
  void emitter_QCameraImageCaptureControl_imageMetadataAvailable_4695(int id, const QString &key, const QVariant &value)
  {
    emit QCameraImageCaptureControl::imageMetadataAvailable(id, key, value);
  }

  //  [emitter impl] void QCameraImageCaptureControl::imageSaved(int requestId, const QString &fileName)
  void emitter_QCameraImageCaptureControl_imageSaved_2684(int requestId, const QString &fileName)
  {
    emit QCameraImageCaptureControl::imageSaved(requestId, fileName);
  }

  //  [adaptor impl] bool QCameraImageCaptureControl::isReadyForCapture()
  bool cbs_isReadyForCapture_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isReadyForCapture");
  }

  virtual bool isReadyForCapture() const
  {
    if (cb_isReadyForCapture_c0_0.can_issue()) {
      return cb_isReadyForCapture_c0_0.issue<QCameraImageCaptureControl_Adaptor, bool>(&QCameraImageCaptureControl_Adaptor::cbs_isReadyForCapture_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isReadyForCapture");
    }
  }

  //  [emitter impl] void QCameraImageCaptureControl::objectNameChanged(const QString &objectName)
  void emitter_QCameraImageCaptureControl_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QCameraImageCaptureControl::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QCameraImageCaptureControl::readyForCaptureChanged(bool ready)
  void emitter_QCameraImageCaptureControl_readyForCaptureChanged_864(bool ready)
  {
    emit QCameraImageCaptureControl::readyForCaptureChanged(ready);
  }

  //  [adaptor impl] void QCameraImageCaptureControl::setDriveMode(QCameraImageCapture::DriveMode mode)
  void cbs_setDriveMode_3320_0(const qt_gsi::Converter<QCameraImageCapture::DriveMode>::target_type & mode)
  {
    __SUPPRESS_UNUSED_WARNING (mode);
    throw qt_gsi::AbstractMethodCalledException("setDriveMode");
  }

  virtual void setDriveMode(QCameraImageCapture::DriveMode mode)
  {
    if (cb_setDriveMode_3320_0.can_issue()) {
      cb_setDriveMode_3320_0.issue<QCameraImageCaptureControl_Adaptor, const qt_gsi::Converter<QCameraImageCapture::DriveMode>::target_type &>(&QCameraImageCaptureControl_Adaptor::cbs_setDriveMode_3320_0, qt_gsi::CppToQtAdaptor<QCameraImageCapture::DriveMode>(mode));
    } else {
      throw qt_gsi::AbstractMethodCalledException("setDriveMode");
    }
  }

  //  [adaptor impl] void QCameraImageCaptureControl::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QCameraImageCaptureControl::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCameraImageCaptureControl_Adaptor, QChildEvent *>(&QCameraImageCaptureControl_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QCameraImageCaptureControl::childEvent(event);
    }
  }

  //  [adaptor impl] void QCameraImageCaptureControl::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QCameraImageCaptureControl::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCameraImageCaptureControl_Adaptor, QEvent *>(&QCameraImageCaptureControl_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QCameraImageCaptureControl::customEvent(event);
    }
  }

  //  [adaptor impl] void QCameraImageCaptureControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QCameraImageCaptureControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QCameraImageCaptureControl_Adaptor, const QMetaMethod &>(&QCameraImageCaptureControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QCameraImageCaptureControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QCameraImageCaptureControl::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QCameraImageCaptureControl::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCameraImageCaptureControl_Adaptor, QTimerEvent *>(&QCameraImageCaptureControl_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QCameraImageCaptureControl::timerEvent(event);
    }
  }

  gsi::Callback cb_cancelCapture_0_0;
  gsi::Callback cb_capture_2025_0;
  gsi::Callback cb_driveMode_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isReadyForCapture_c0_0;
  gsi::Callback cb_setDriveMode_3320_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QCameraImageCaptureControl_Adaptor::~QCameraImageCaptureControl_Adaptor() { }

//  Constructor QCameraImageCaptureControl::QCameraImageCaptureControl() (adaptor class)

static void _init_ctor_QCameraImageCaptureControl_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QCameraImageCaptureControl_Adaptor> ();
}

static void _call_ctor_QCameraImageCaptureControl_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCameraImageCaptureControl_Adaptor *> (new QCameraImageCaptureControl_Adaptor ());
}


// void QCameraImageCaptureControl::cancelCapture()

static void _init_cbs_cancelCapture_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_cancelCapture_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCaptureControl_Adaptor *)cls)->cbs_cancelCapture_0_0 ();
}

static void _set_callback_cbs_cancelCapture_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCaptureControl_Adaptor *)cls)->cb_cancelCapture_0_0 = cb;
}


// int QCameraImageCaptureControl::capture(const QString &fileName)

static void _init_cbs_capture_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_capture_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<int > ((int)((QCameraImageCaptureControl_Adaptor *)cls)->cbs_capture_2025_0 (arg1));
}

static void _set_callback_cbs_capture_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCaptureControl_Adaptor *)cls)->cb_capture_2025_0 = cb;
}


// void QCameraImageCaptureControl::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCaptureControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCaptureControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QCameraImageCaptureControl::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCaptureControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCaptureControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QCameraImageCaptureControl::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QCameraImageCaptureControl_Adaptor *)cls)->emitter_QCameraImageCaptureControl_destroyed_1302 (arg1);
}


// void QCameraImageCaptureControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCaptureControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCaptureControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// QCameraImageCapture::DriveMode QCameraImageCaptureControl::driveMode()

static void _init_cbs_driveMode_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCameraImageCapture::DriveMode>::target_type > ();
}

static void _call_cbs_driveMode_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCameraImageCapture::DriveMode>::target_type > ((qt_gsi::Converter<QCameraImageCapture::DriveMode>::target_type)((QCameraImageCaptureControl_Adaptor *)cls)->cbs_driveMode_c0_0 ());
}

static void _set_callback_cbs_driveMode_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCaptureControl_Adaptor *)cls)->cb_driveMode_c0_0 = cb;
}


// emitter void QCameraImageCaptureControl::error(int id, int error, const QString &errorString)

static void _init_emitter_error_3343 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("error");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("errorString");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_error_3343 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  ((QCameraImageCaptureControl_Adaptor *)cls)->emitter_QCameraImageCaptureControl_error_3343 (arg1, arg2, arg3);
}


// bool QCameraImageCaptureControl::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraImageCaptureControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCaptureControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QCameraImageCaptureControl::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraImageCaptureControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCaptureControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QCameraImageCaptureControl::imageAvailable(int requestId, const QVideoFrame &buffer)

static void _init_emitter_imageAvailable_3047 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("requestId");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("buffer");
  decl->add_arg<const QVideoFrame & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_imageAvailable_3047 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QVideoFrame &arg2 = gsi::arg_reader<const QVideoFrame & >() (args, heap);
  ((QCameraImageCaptureControl_Adaptor *)cls)->emitter_QCameraImageCaptureControl_imageAvailable_3047 (arg1, arg2);
}


// emitter void QCameraImageCaptureControl::imageCaptured(int requestId, const QImage &preview)

static void _init_emitter_imageCaptured_2536 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("requestId");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("preview");
  decl->add_arg<const QImage & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_imageCaptured_2536 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QImage &arg2 = gsi::arg_reader<const QImage & >() (args, heap);
  ((QCameraImageCaptureControl_Adaptor *)cls)->emitter_QCameraImageCaptureControl_imageCaptured_2536 (arg1, arg2);
}


// emitter void QCameraImageCaptureControl::imageExposed(int requestId)

static void _init_emitter_imageExposed_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("requestId");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_imageExposed_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QCameraImageCaptureControl_Adaptor *)cls)->emitter_QCameraImageCaptureControl_imageExposed_767 (arg1);
}


// emitter void QCameraImageCaptureControl::imageMetadataAvailable(int id, const QString &key, const QVariant &value)

static void _init_emitter_imageMetadataAvailable_4695 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("key");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_imageMetadataAvailable_4695 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QVariant &arg3 = gsi::arg_reader<const QVariant & >() (args, heap);
  ((QCameraImageCaptureControl_Adaptor *)cls)->emitter_QCameraImageCaptureControl_imageMetadataAvailable_4695 (arg1, arg2, arg3);
}


// emitter void QCameraImageCaptureControl::imageSaved(int requestId, const QString &fileName)

static void _init_emitter_imageSaved_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("requestId");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("fileName");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_imageSaved_2684 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ((QCameraImageCaptureControl_Adaptor *)cls)->emitter_QCameraImageCaptureControl_imageSaved_2684 (arg1, arg2);
}


// bool QCameraImageCaptureControl::isReadyForCapture()

static void _init_cbs_isReadyForCapture_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isReadyForCapture_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCameraImageCaptureControl_Adaptor *)cls)->cbs_isReadyForCapture_c0_0 ());
}

static void _set_callback_cbs_isReadyForCapture_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCaptureControl_Adaptor *)cls)->cb_isReadyForCapture_c0_0 = cb;
}


// exposed bool QCameraImageCaptureControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QCameraImageCaptureControl_Adaptor *)cls)->fp_QCameraImageCaptureControl_isSignalConnected_c2394 (arg1));
}


// emitter void QCameraImageCaptureControl::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QCameraImageCaptureControl_Adaptor *)cls)->emitter_QCameraImageCaptureControl_objectNameChanged_4567 (arg1);
}


// emitter void QCameraImageCaptureControl::readyForCaptureChanged(bool ready)

static void _init_emitter_readyForCaptureChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ready");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_readyForCaptureChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QCameraImageCaptureControl_Adaptor *)cls)->emitter_QCameraImageCaptureControl_readyForCaptureChanged_864 (arg1);
}


// exposed int QCameraImageCaptureControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QCameraImageCaptureControl_Adaptor *)cls)->fp_QCameraImageCaptureControl_receivers_c1731 (arg1));
}


// exposed QObject *QCameraImageCaptureControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QCameraImageCaptureControl_Adaptor *)cls)->fp_QCameraImageCaptureControl_sender_c0 ());
}


// exposed int QCameraImageCaptureControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCameraImageCaptureControl_Adaptor *)cls)->fp_QCameraImageCaptureControl_senderSignalIndex_c0 ());
}


// void QCameraImageCaptureControl::setDriveMode(QCameraImageCapture::DriveMode mode)

static void _init_cbs_setDriveMode_3320_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCameraImageCapture::DriveMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setDriveMode_3320_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraImageCapture::DriveMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraImageCapture::DriveMode>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCaptureControl_Adaptor *)cls)->cbs_setDriveMode_3320_0 (arg1);
}

static void _set_callback_cbs_setDriveMode_3320_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCaptureControl_Adaptor *)cls)->cb_setDriveMode_3320_0 = cb;
}


// void QCameraImageCaptureControl::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCaptureControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCaptureControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QCameraImageCaptureControl> &qtdecl_QCameraImageCaptureControl ();

static gsi::Methods methods_QCameraImageCaptureControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCameraImageCaptureControl::QCameraImageCaptureControl()\nThis method creates an object of class QCameraImageCaptureControl.", &_init_ctor_QCameraImageCaptureControl_Adaptor_0, &_call_ctor_QCameraImageCaptureControl_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("cancelCapture", "@brief Virtual method void QCameraImageCaptureControl::cancelCapture()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_cancelCapture_0_0, &_call_cbs_cancelCapture_0_0);
  methods += new qt_gsi::GenericMethod ("cancelCapture", "@hide", false, &_init_cbs_cancelCapture_0_0, &_call_cbs_cancelCapture_0_0, &_set_callback_cbs_cancelCapture_0_0);
  methods += new qt_gsi::GenericMethod ("capture", "@brief Virtual method int QCameraImageCaptureControl::capture(const QString &fileName)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_capture_2025_0, &_call_cbs_capture_2025_0);
  methods += new qt_gsi::GenericMethod ("capture", "@hide", false, &_init_cbs_capture_2025_0, &_call_cbs_capture_2025_0, &_set_callback_cbs_capture_2025_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCameraImageCaptureControl::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCameraImageCaptureControl::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QCameraImageCaptureControl::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCameraImageCaptureControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("driveMode", "@brief Virtual method QCameraImageCapture::DriveMode QCameraImageCaptureControl::driveMode()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_driveMode_c0_0, &_call_cbs_driveMode_c0_0);
  methods += new qt_gsi::GenericMethod ("driveMode", "@hide", true, &_init_cbs_driveMode_c0_0, &_call_cbs_driveMode_c0_0, &_set_callback_cbs_driveMode_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_error", "@brief Emitter for signal void QCameraImageCaptureControl::error(int id, int error, const QString &errorString)\nCall this method to emit this signal.", false, &_init_emitter_error_3343, &_call_emitter_error_3343);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QCameraImageCaptureControl::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QCameraImageCaptureControl::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_imageAvailable", "@brief Emitter for signal void QCameraImageCaptureControl::imageAvailable(int requestId, const QVideoFrame &buffer)\nCall this method to emit this signal.", false, &_init_emitter_imageAvailable_3047, &_call_emitter_imageAvailable_3047);
  methods += new qt_gsi::GenericMethod ("emit_imageCaptured", "@brief Emitter for signal void QCameraImageCaptureControl::imageCaptured(int requestId, const QImage &preview)\nCall this method to emit this signal.", false, &_init_emitter_imageCaptured_2536, &_call_emitter_imageCaptured_2536);
  methods += new qt_gsi::GenericMethod ("emit_imageExposed", "@brief Emitter for signal void QCameraImageCaptureControl::imageExposed(int requestId)\nCall this method to emit this signal.", false, &_init_emitter_imageExposed_767, &_call_emitter_imageExposed_767);
  methods += new qt_gsi::GenericMethod ("emit_imageMetadataAvailable", "@brief Emitter for signal void QCameraImageCaptureControl::imageMetadataAvailable(int id, const QString &key, const QVariant &value)\nCall this method to emit this signal.", false, &_init_emitter_imageMetadataAvailable_4695, &_call_emitter_imageMetadataAvailable_4695);
  methods += new qt_gsi::GenericMethod ("emit_imageSaved", "@brief Emitter for signal void QCameraImageCaptureControl::imageSaved(int requestId, const QString &fileName)\nCall this method to emit this signal.", false, &_init_emitter_imageSaved_2684, &_call_emitter_imageSaved_2684);
  methods += new qt_gsi::GenericMethod ("isReadyForCapture", "@brief Virtual method bool QCameraImageCaptureControl::isReadyForCapture()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isReadyForCapture_c0_0, &_call_cbs_isReadyForCapture_c0_0);
  methods += new qt_gsi::GenericMethod ("isReadyForCapture", "@hide", true, &_init_cbs_isReadyForCapture_c0_0, &_call_cbs_isReadyForCapture_c0_0, &_set_callback_cbs_isReadyForCapture_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QCameraImageCaptureControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QCameraImageCaptureControl::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("emit_readyForCaptureChanged", "@brief Emitter for signal void QCameraImageCaptureControl::readyForCaptureChanged(bool ready)\nCall this method to emit this signal.", false, &_init_emitter_readyForCaptureChanged_864, &_call_emitter_readyForCaptureChanged_864);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QCameraImageCaptureControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QCameraImageCaptureControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QCameraImageCaptureControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setDriveMode", "@brief Virtual method void QCameraImageCaptureControl::setDriveMode(QCameraImageCapture::DriveMode mode)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setDriveMode_3320_0, &_call_cbs_setDriveMode_3320_0);
  methods += new qt_gsi::GenericMethod ("setDriveMode", "@hide", false, &_init_cbs_setDriveMode_3320_0, &_call_cbs_setDriveMode_3320_0, &_set_callback_cbs_setDriveMode_3320_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCameraImageCaptureControl::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QCameraImageCaptureControl_Adaptor> decl_QCameraImageCaptureControl_Adaptor (qtdecl_QCameraImageCaptureControl (), "QtMultimedia", "QCameraImageCaptureControl",
  methods_QCameraImageCaptureControl_Adaptor (),
  "@qt\n@brief Binding of QCameraImageCaptureControl");

}

