
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCameraImageCapture.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCameraImageCapture>
#include <QChildEvent>
#include <QEvent>
#include <QImage>
#include <QImageEncoderSettings>
#include <QMediaObject>
#include <QMetaMethod>
#include <QObject>
#include <QSize>
#include <QThread>
#include <QTimerEvent>
#include <QVideoFrame>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCameraImageCapture

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCameraImageCapture::staticMetaObject);
}


// QMultimedia::AvailabilityStatus QCameraImageCapture::availability()


static void _init_f_availability_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ();
}

static void _call_f_availability_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ((qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type)qt_gsi::CppToQtAdaptor<QMultimedia::AvailabilityStatus>(((QCameraImageCapture *)cls)->availability ()));
}


// QVideoFrame::PixelFormat QCameraImageCapture::bufferFormat()


static void _init_f_bufferFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type > ();
}

static void _call_f_bufferFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type > ((qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type)qt_gsi::CppToQtAdaptor<QVideoFrame::PixelFormat>(((QCameraImageCapture *)cls)->bufferFormat ()));
}


// void QCameraImageCapture::cancelCapture()


static void _init_f_cancelCapture_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_cancelCapture_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture *)cls)->cancelCapture ();
}


// int QCameraImageCapture::capture(const QString &location)


static void _init_f_capture_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("location", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_capture_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<int > ((int)((QCameraImageCapture *)cls)->capture (arg1));
}


// QFlags<QCameraImageCapture::CaptureDestination> QCameraImageCapture::captureDestination()


static void _init_f_captureDestination_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QCameraImageCapture::CaptureDestination> > ();
}

static void _call_f_captureDestination_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QCameraImageCapture::CaptureDestination> > ((QFlags<QCameraImageCapture::CaptureDestination>)((QCameraImageCapture *)cls)->captureDestination ());
}


// QImageEncoderSettings QCameraImageCapture::encodingSettings()


static void _init_f_encodingSettings_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QImageEncoderSettings > ();
}

static void _call_f_encodingSettings_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QImageEncoderSettings > ((QImageEncoderSettings)((QCameraImageCapture *)cls)->encodingSettings ());
}


// QCameraImageCapture::Error QCameraImageCapture::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCameraImageCapture::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCameraImageCapture::Error>::target_type > ((qt_gsi::Converter<QCameraImageCapture::Error>::target_type)qt_gsi::CppToQtAdaptor<QCameraImageCapture::Error>(((QCameraImageCapture *)cls)->error ()));
}


// QString QCameraImageCapture::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QCameraImageCapture *)cls)->errorString ());
}


// QString QCameraImageCapture::imageCodecDescription(const QString &codecName)


static void _init_f_imageCodecDescription_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("codecName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_imageCodecDescription_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)((QCameraImageCapture *)cls)->imageCodecDescription (arg1));
}


// bool QCameraImageCapture::isAvailable()


static void _init_f_isAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCameraImageCapture *)cls)->isAvailable ());
}


// bool QCameraImageCapture::isCaptureDestinationSupported(QFlags<QCameraImageCapture::CaptureDestination> destination)


static void _init_f_isCaptureDestinationSupported_c4999 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destination");
  decl->add_arg<QFlags<QCameraImageCapture::CaptureDestination> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isCaptureDestinationSupported_c4999 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCameraImageCapture::CaptureDestination> arg1 = gsi::arg_reader<QFlags<QCameraImageCapture::CaptureDestination> >() (args, heap);
  ret.write<bool > ((bool)((QCameraImageCapture *)cls)->isCaptureDestinationSupported (arg1));
}


// bool QCameraImageCapture::isReadyForCapture()


static void _init_f_isReadyForCapture_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isReadyForCapture_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCameraImageCapture *)cls)->isReadyForCapture ());
}


// QMediaObject *QCameraImageCapture::mediaObject()


static void _init_f_mediaObject_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaObject * > ();
}

static void _call_f_mediaObject_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaObject * > ((QMediaObject *)((QCameraImageCapture *)cls)->mediaObject ());
}


// void QCameraImageCapture::setBufferFormat(const QVideoFrame::PixelFormat format)


static void _init_f_setBufferFormat_3453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBufferFormat_3453 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture *)cls)->setBufferFormat (qt_gsi::QtToCppAdaptor<QVideoFrame::PixelFormat>(arg1).cref());
}


// void QCameraImageCapture::setCaptureDestination(QFlags<QCameraImageCapture::CaptureDestination> destination)


static void _init_f_setCaptureDestination_4999 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destination");
  decl->add_arg<QFlags<QCameraImageCapture::CaptureDestination> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCaptureDestination_4999 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCameraImageCapture::CaptureDestination> arg1 = gsi::arg_reader<QFlags<QCameraImageCapture::CaptureDestination> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture *)cls)->setCaptureDestination (arg1);
}


// void QCameraImageCapture::setEncodingSettings(const QImageEncoderSettings &settings)


static void _init_f_setEncodingSettings_3430 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("settings");
  decl->add_arg<const QImageEncoderSettings & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodingSettings_3430 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QImageEncoderSettings &arg1 = gsi::arg_reader<const QImageEncoderSettings & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture *)cls)->setEncodingSettings (arg1);
}


// QList<QVideoFrame::PixelFormat> QCameraImageCapture::supportedBufferFormats()


static void _init_f_supportedBufferFormats_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QVideoFrame::PixelFormat> > ();
}

static void _call_f_supportedBufferFormats_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QVideoFrame::PixelFormat> > ((QList<QVideoFrame::PixelFormat>)((QCameraImageCapture *)cls)->supportedBufferFormats ());
}


// QStringList QCameraImageCapture::supportedImageCodecs()


static void _init_f_supportedImageCodecs_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_supportedImageCodecs_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QCameraImageCapture *)cls)->supportedImageCodecs ());
}


// QList<QSize> QCameraImageCapture::supportedResolutions(const QImageEncoderSettings &settings, bool *continuous)


static void _init_f_supportedResolutions_c4372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("settings", true, "QImageEncoderSettings()");
  decl->add_arg<const QImageEncoderSettings & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("continuous", true, "nullptr");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<QList<QSize> > ();
}

static void _call_f_supportedResolutions_c4372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QImageEncoderSettings &arg1 = args ? gsi::arg_reader<const QImageEncoderSettings & >() (args, heap) : gsi::arg_maker<const QImageEncoderSettings & >() (QImageEncoderSettings(), heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (nullptr, heap);
  ret.write<QList<QSize> > ((QList<QSize>)((QCameraImageCapture *)cls)->supportedResolutions (arg1, arg2));
}


// static QString QCameraImageCapture::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraImageCapture::tr (arg1, arg2, arg3));
}


// static QString QCameraImageCapture::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraImageCapture::trUtf8 (arg1, arg2, arg3));
}


//  base class cast for QObject

static void _init_f_QCameraImageCapture_as_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject *> ();
}

static void _call_f_QCameraImageCapture_as_QObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QObject *> ((QObject *)(QCameraImageCapture *)cls);
}

static void _init_f_QCameraImageCapture_as_const_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QObject *> ();
}

static void _call_f_QCameraImageCapture_as_const_QObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QObject *> ((const QObject *)(const QCameraImageCapture *)cls);
}

//  base class cast for QMediaBindableInterface

static void _init_f_QCameraImageCapture_as_QMediaBindableInterface (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaBindableInterface *> ();
}

static void _call_f_QCameraImageCapture_as_QMediaBindableInterface (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QMediaBindableInterface *> ((QMediaBindableInterface *)(QCameraImageCapture *)cls);
}

static void _init_f_QCameraImageCapture_as_const_QMediaBindableInterface (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QMediaBindableInterface *> ();
}

static void _call_f_QCameraImageCapture_as_const_QMediaBindableInterface (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMediaBindableInterface *> ((const QMediaBindableInterface *)(const QCameraImageCapture *)cls);
}


namespace gsi
{

static gsi::Methods methods_QCameraImageCapture () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("availability", "@brief Method QMultimedia::AvailabilityStatus QCameraImageCapture::availability()\n", true, &_init_f_availability_c0, &_call_f_availability_c0);
  methods += new qt_gsi::GenericMethod (":bufferFormat", "@brief Method QVideoFrame::PixelFormat QCameraImageCapture::bufferFormat()\n", true, &_init_f_bufferFormat_c0, &_call_f_bufferFormat_c0);
  methods += new qt_gsi::GenericMethod ("cancelCapture", "@brief Method void QCameraImageCapture::cancelCapture()\n", false, &_init_f_cancelCapture_0, &_call_f_cancelCapture_0);
  methods += new qt_gsi::GenericMethod ("capture", "@brief Method int QCameraImageCapture::capture(const QString &location)\n", false, &_init_f_capture_2025, &_call_f_capture_2025);
  methods += new qt_gsi::GenericMethod (":captureDestination", "@brief Method QFlags<QCameraImageCapture::CaptureDestination> QCameraImageCapture::captureDestination()\n", true, &_init_f_captureDestination_c0, &_call_f_captureDestination_c0);
  methods += new qt_gsi::GenericMethod (":encodingSettings", "@brief Method QImageEncoderSettings QCameraImageCapture::encodingSettings()\n", true, &_init_f_encodingSettings_c0, &_call_f_encodingSettings_c0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QCameraImageCapture::Error QCameraImageCapture::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QCameraImageCapture::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("imageCodecDescription", "@brief Method QString QCameraImageCapture::imageCodecDescription(const QString &codecName)\n", true, &_init_f_imageCodecDescription_c2025, &_call_f_imageCodecDescription_c2025);
  methods += new qt_gsi::GenericMethod ("isAvailable?", "@brief Method bool QCameraImageCapture::isAvailable()\n", true, &_init_f_isAvailable_c0, &_call_f_isAvailable_c0);
  methods += new qt_gsi::GenericMethod ("isCaptureDestinationSupported?", "@brief Method bool QCameraImageCapture::isCaptureDestinationSupported(QFlags<QCameraImageCapture::CaptureDestination> destination)\n", true, &_init_f_isCaptureDestinationSupported_c4999, &_call_f_isCaptureDestinationSupported_c4999);
  methods += new qt_gsi::GenericMethod ("isReadyForCapture?|:readyForCapture", "@brief Method bool QCameraImageCapture::isReadyForCapture()\n", true, &_init_f_isReadyForCapture_c0, &_call_f_isReadyForCapture_c0);
  methods += new qt_gsi::GenericMethod ("mediaObject", "@brief Method QMediaObject *QCameraImageCapture::mediaObject()\nThis is a reimplementation of QMediaBindableInterface::mediaObject", true, &_init_f_mediaObject_c0, &_call_f_mediaObject_c0);
  methods += new qt_gsi::GenericMethod ("setBufferFormat|bufferFormat=", "@brief Method void QCameraImageCapture::setBufferFormat(const QVideoFrame::PixelFormat format)\n", false, &_init_f_setBufferFormat_3453, &_call_f_setBufferFormat_3453);
  methods += new qt_gsi::GenericMethod ("setCaptureDestination|captureDestination=", "@brief Method void QCameraImageCapture::setCaptureDestination(QFlags<QCameraImageCapture::CaptureDestination> destination)\n", false, &_init_f_setCaptureDestination_4999, &_call_f_setCaptureDestination_4999);
  methods += new qt_gsi::GenericMethod ("setEncodingSettings|encodingSettings=", "@brief Method void QCameraImageCapture::setEncodingSettings(const QImageEncoderSettings &settings)\n", false, &_init_f_setEncodingSettings_3430, &_call_f_setEncodingSettings_3430);
  methods += new qt_gsi::GenericMethod ("supportedBufferFormats", "@brief Method QList<QVideoFrame::PixelFormat> QCameraImageCapture::supportedBufferFormats()\n", true, &_init_f_supportedBufferFormats_c0, &_call_f_supportedBufferFormats_c0);
  methods += new qt_gsi::GenericMethod ("supportedImageCodecs", "@brief Method QStringList QCameraImageCapture::supportedImageCodecs()\n", true, &_init_f_supportedImageCodecs_c0, &_call_f_supportedImageCodecs_c0);
  methods += new qt_gsi::GenericMethod ("supportedResolutions", "@brief Method QList<QSize> QCameraImageCapture::supportedResolutions(const QImageEncoderSettings &settings, bool *continuous)\n", true, &_init_f_supportedResolutions_c4372, &_call_f_supportedResolutions_c4372);
  methods += gsi::qt_signal<const qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type & > ("bufferFormatChanged(QVideoFrame::PixelFormat)", "bufferFormatChanged", gsi::arg("format"), "@brief Signal declaration for QCameraImageCapture::bufferFormatChanged(QVideoFrame::PixelFormat format)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QFlags<QCameraImageCapture::CaptureDestination> > ("captureDestinationChanged(QFlags<QCameraImageCapture::CaptureDestination>)", "captureDestinationChanged", gsi::arg("destination"), "@brief Signal declaration for QCameraImageCapture::captureDestinationChanged(QFlags<QCameraImageCapture::CaptureDestination> destination)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QCameraImageCapture::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, const qt_gsi::Converter<QCameraImageCapture::Error>::target_type &, const QString & > ("error(int, QCameraImageCapture::Error, const QString &)", "error_sig", gsi::arg("id"), gsi::arg("error"), gsi::arg("errorString"), "@brief Signal declaration for QCameraImageCapture::error(int id, QCameraImageCapture::Error error, const QString &errorString)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, const QVideoFrame & > ("imageAvailable(int, const QVideoFrame &)", "imageAvailable", gsi::arg("id"), gsi::arg("frame"), "@brief Signal declaration for QCameraImageCapture::imageAvailable(int id, const QVideoFrame &frame)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, const QImage & > ("imageCaptured(int, const QImage &)", "imageCaptured", gsi::arg("id"), gsi::arg("preview"), "@brief Signal declaration for QCameraImageCapture::imageCaptured(int id, const QImage &preview)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("imageExposed(int)", "imageExposed", gsi::arg("id"), "@brief Signal declaration for QCameraImageCapture::imageExposed(int id)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, const QString &, const QVariant & > ("imageMetadataAvailable(int, const QString &, const QVariant &)", "imageMetadataAvailable", gsi::arg("id"), gsi::arg("key"), gsi::arg("value"), "@brief Signal declaration for QCameraImageCapture::imageMetadataAvailable(int id, const QString &key, const QVariant &value)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, const QString & > ("imageSaved(int, const QString &)", "imageSaved", gsi::arg("id"), gsi::arg("fileName"), "@brief Signal declaration for QCameraImageCapture::imageSaved(int id, const QString &fileName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QCameraImageCapture::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("readyForCaptureChanged(bool)", "readyForCaptureChanged", gsi::arg("ready"), "@brief Signal declaration for QCameraImageCapture::readyForCaptureChanged(bool ready)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCameraImageCapture::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCameraImageCapture::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  methods += new qt_gsi::GenericMethod ("asQObject", "@brief Delivers the base class interface QObject of QCameraImageCapture\nClass QCameraImageCapture is derived from multiple base classes. This method delivers the QObject base class aspect.", false, &_init_f_QCameraImageCapture_as_QObject, &_call_f_QCameraImageCapture_as_QObject);
  methods += new qt_gsi::GenericMethod ("asConstQObject", "@brief Delivers the base class interface QObject of QCameraImageCapture\nClass QCameraImageCapture is derived from multiple base classes. This method delivers the QObject base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QCameraImageCapture_as_const_QObject, &_call_f_QCameraImageCapture_as_const_QObject);
  methods += new qt_gsi::GenericMethod ("asQMediaBindableInterface", "@brief Delivers the base class interface QMediaBindableInterface of QCameraImageCapture\nClass QCameraImageCapture is derived from multiple base classes. This method delivers the QMediaBindableInterface base class aspect.", false, &_init_f_QCameraImageCapture_as_QMediaBindableInterface, &_call_f_QCameraImageCapture_as_QMediaBindableInterface);
  methods += new qt_gsi::GenericMethod ("asConstQMediaBindableInterface", "@brief Delivers the base class interface QMediaBindableInterface of QCameraImageCapture\nClass QCameraImageCapture is derived from multiple base classes. This method delivers the QMediaBindableInterface base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QCameraImageCapture_as_const_QMediaBindableInterface, &_call_f_QCameraImageCapture_as_const_QMediaBindableInterface);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QCameraImageCapture> decl_QCameraImageCapture (qtdecl_QObject (), "QtMultimedia", "QCameraImageCapture_Native",
  methods_QCameraImageCapture (),
  "@hide\n@alias QCameraImageCapture");

//  Additional base classes

gsi::Class<QMediaBindableInterface> &qtdecl_QMediaBindableInterface ();

gsi::ClassExt<QCameraImageCapture> base_class_QMediaBindableInterface_in_QCameraImageCapture (qtdecl_QMediaBindableInterface ());

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QCameraImageCapture> &qtdecl_QCameraImageCapture () { return decl_QCameraImageCapture; }

}


class QCameraImageCapture_Adaptor : public QCameraImageCapture, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCameraImageCapture_Adaptor();

  //  [adaptor ctor] QCameraImageCapture::QCameraImageCapture(QMediaObject *mediaObject, QObject *parent)
  QCameraImageCapture_Adaptor(QMediaObject *mediaObject) : QCameraImageCapture(mediaObject)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCameraImageCapture::QCameraImageCapture(QMediaObject *mediaObject, QObject *parent)
  QCameraImageCapture_Adaptor(QMediaObject *mediaObject, QObject *parent) : QCameraImageCapture(mediaObject, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QCameraImageCapture::isSignalConnected(const QMetaMethod &signal)
  bool fp_QCameraImageCapture_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QCameraImageCapture::isSignalConnected(signal);
  }

  //  [expose] int QCameraImageCapture::receivers(const char *signal)
  int fp_QCameraImageCapture_receivers_c1731 (const char *signal) const {
    return QCameraImageCapture::receivers(signal);
  }

  //  [expose] QObject *QCameraImageCapture::sender()
  QObject * fp_QCameraImageCapture_sender_c0 () const {
    return QCameraImageCapture::sender();
  }

  //  [expose] int QCameraImageCapture::senderSignalIndex()
  int fp_QCameraImageCapture_senderSignalIndex_c0 () const {
    return QCameraImageCapture::senderSignalIndex();
  }

  //  [emitter impl] void QCameraImageCapture::bufferFormatChanged(QVideoFrame::PixelFormat format)
  void emitter_QCameraImageCapture_bufferFormatChanged_2758(QVideoFrame::PixelFormat format)
  {
    emit QCameraImageCapture::bufferFormatChanged(format);
  }

  //  [emitter impl] void QCameraImageCapture::captureDestinationChanged(QFlags<QCameraImageCapture::CaptureDestination> destination)
  void emitter_QCameraImageCapture_captureDestinationChanged_4999(QFlags<QCameraImageCapture::CaptureDestination> destination)
  {
    emit QCameraImageCapture::captureDestinationChanged(destination);
  }

  //  [emitter impl] void QCameraImageCapture::destroyed(QObject *)
  void emitter_QCameraImageCapture_destroyed_1302(QObject *arg1)
  {
    emit QCameraImageCapture::destroyed(arg1);
  }

  //  [emitter impl] void QCameraImageCapture::error(int id, QCameraImageCapture::Error error, const QString &errorString)
  void emitter_QCameraImageCapture_error_5523(int id, QCameraImageCapture::Error _error, const QString &errorString)
  {
    emit QCameraImageCapture::error(id, _error, errorString);
  }

  //  [adaptor impl] bool QCameraImageCapture::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QCameraImageCapture::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCameraImageCapture_Adaptor, bool, QEvent *>(&QCameraImageCapture_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QCameraImageCapture::event(_event);
    }
  }

  //  [adaptor impl] bool QCameraImageCapture::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QCameraImageCapture::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCameraImageCapture_Adaptor, bool, QObject *, QEvent *>(&QCameraImageCapture_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QCameraImageCapture::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QCameraImageCapture::imageAvailable(int id, const QVideoFrame &frame)
  void emitter_QCameraImageCapture_imageAvailable_3047(int id, const QVideoFrame &frame)
  {
    emit QCameraImageCapture::imageAvailable(id, frame);
  }

  //  [emitter impl] void QCameraImageCapture::imageCaptured(int id, const QImage &preview)
  void emitter_QCameraImageCapture_imageCaptured_2536(int id, const QImage &preview)
  {
    emit QCameraImageCapture::imageCaptured(id, preview);
  }

  //  [emitter impl] void QCameraImageCapture::imageExposed(int id)
  void emitter_QCameraImageCapture_imageExposed_767(int id)
  {
    emit QCameraImageCapture::imageExposed(id);
  }

  //  [emitter impl] void QCameraImageCapture::imageMetadataAvailable(int id, const QString &key, const QVariant &value)
  void emitter_QCameraImageCapture_imageMetadataAvailable_4695(int id, const QString &key, const QVariant &value)
  {
    emit QCameraImageCapture::imageMetadataAvailable(id, key, value);
  }

  //  [emitter impl] void QCameraImageCapture::imageSaved(int id, const QString &fileName)
  void emitter_QCameraImageCapture_imageSaved_2684(int id, const QString &fileName)
  {
    emit QCameraImageCapture::imageSaved(id, fileName);
  }

  //  [adaptor impl] QMediaObject *QCameraImageCapture::mediaObject()
  QMediaObject * cbs_mediaObject_c0_0() const
  {
    return QCameraImageCapture::mediaObject();
  }

  virtual QMediaObject * mediaObject() const
  {
    if (cb_mediaObject_c0_0.can_issue()) {
      return cb_mediaObject_c0_0.issue<QCameraImageCapture_Adaptor, QMediaObject *>(&QCameraImageCapture_Adaptor::cbs_mediaObject_c0_0);
    } else {
      return QCameraImageCapture::mediaObject();
    }
  }

  //  [emitter impl] void QCameraImageCapture::objectNameChanged(const QString &objectName)
  void emitter_QCameraImageCapture_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QCameraImageCapture::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QCameraImageCapture::readyForCaptureChanged(bool ready)
  void emitter_QCameraImageCapture_readyForCaptureChanged_864(bool ready)
  {
    emit QCameraImageCapture::readyForCaptureChanged(ready);
  }

  //  [adaptor impl] void QCameraImageCapture::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QCameraImageCapture::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCameraImageCapture_Adaptor, QChildEvent *>(&QCameraImageCapture_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QCameraImageCapture::childEvent(event);
    }
  }

  //  [adaptor impl] void QCameraImageCapture::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QCameraImageCapture::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCameraImageCapture_Adaptor, QEvent *>(&QCameraImageCapture_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QCameraImageCapture::customEvent(event);
    }
  }

  //  [adaptor impl] void QCameraImageCapture::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QCameraImageCapture::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QCameraImageCapture_Adaptor, const QMetaMethod &>(&QCameraImageCapture_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QCameraImageCapture::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QCameraImageCapture::setMediaObject(QMediaObject *)
  bool cbs_setMediaObject_1782_0(QMediaObject *arg1)
  {
    return QCameraImageCapture::setMediaObject(arg1);
  }

  virtual bool setMediaObject(QMediaObject *arg1)
  {
    if (cb_setMediaObject_1782_0.can_issue()) {
      return cb_setMediaObject_1782_0.issue<QCameraImageCapture_Adaptor, bool, QMediaObject *>(&QCameraImageCapture_Adaptor::cbs_setMediaObject_1782_0, arg1);
    } else {
      return QCameraImageCapture::setMediaObject(arg1);
    }
  }

  //  [adaptor impl] void QCameraImageCapture::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QCameraImageCapture::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCameraImageCapture_Adaptor, QTimerEvent *>(&QCameraImageCapture_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QCameraImageCapture::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_mediaObject_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_setMediaObject_1782_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QCameraImageCapture_Adaptor::~QCameraImageCapture_Adaptor() { }

//  Constructor QCameraImageCapture::QCameraImageCapture(QMediaObject *mediaObject, QObject *parent) (adaptor class)

static void _init_ctor_QCameraImageCapture_Adaptor_2976 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mediaObject");
  decl->add_arg<QMediaObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QCameraImageCapture_Adaptor> ();
}

static void _call_ctor_QCameraImageCapture_Adaptor_2976 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMediaObject *arg1 = gsi::arg_reader<QMediaObject * >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QCameraImageCapture_Adaptor *> (new QCameraImageCapture_Adaptor (arg1, arg2));
}


// emitter void QCameraImageCapture::bufferFormatChanged(QVideoFrame::PixelFormat format)

static void _init_emitter_bufferFormatChanged_2758 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_bufferFormatChanged_2758 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type & >() (args, heap);
  ((QCameraImageCapture_Adaptor *)cls)->emitter_QCameraImageCapture_bufferFormatChanged_2758 (arg1);
}


// emitter void QCameraImageCapture::captureDestinationChanged(QFlags<QCameraImageCapture::CaptureDestination> destination)

static void _init_emitter_captureDestinationChanged_4999 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destination");
  decl->add_arg<QFlags<QCameraImageCapture::CaptureDestination> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_captureDestinationChanged_4999 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCameraImageCapture::CaptureDestination> arg1 = gsi::arg_reader<QFlags<QCameraImageCapture::CaptureDestination> >() (args, heap);
  ((QCameraImageCapture_Adaptor *)cls)->emitter_QCameraImageCapture_captureDestinationChanged_4999 (arg1);
}


// void QCameraImageCapture::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCapture_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QCameraImageCapture::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCapture_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QCameraImageCapture::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QCameraImageCapture_Adaptor *)cls)->emitter_QCameraImageCapture_destroyed_1302 (arg1);
}


// void QCameraImageCapture::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCapture_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// emitter void QCameraImageCapture::error(int id, QCameraImageCapture::Error error, const QString &errorString)

static void _init_emitter_error_5523 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("error");
  decl->add_arg<const qt_gsi::Converter<QCameraImageCapture::Error>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("errorString");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_error_5523 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QCameraImageCapture::Error>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QCameraImageCapture::Error>::target_type & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  ((QCameraImageCapture_Adaptor *)cls)->emitter_QCameraImageCapture_error_5523 (arg1, arg2, arg3);
}


// bool QCameraImageCapture::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraImageCapture_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCapture_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QCameraImageCapture::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraImageCapture_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCapture_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QCameraImageCapture::imageAvailable(int id, const QVideoFrame &frame)

static void _init_emitter_imageAvailable_3047 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("frame");
  decl->add_arg<const QVideoFrame & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_imageAvailable_3047 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QVideoFrame &arg2 = gsi::arg_reader<const QVideoFrame & >() (args, heap);
  ((QCameraImageCapture_Adaptor *)cls)->emitter_QCameraImageCapture_imageAvailable_3047 (arg1, arg2);
}


// emitter void QCameraImageCapture::imageCaptured(int id, const QImage &preview)

static void _init_emitter_imageCaptured_2536 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("preview");
  decl->add_arg<const QImage & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_imageCaptured_2536 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QImage &arg2 = gsi::arg_reader<const QImage & >() (args, heap);
  ((QCameraImageCapture_Adaptor *)cls)->emitter_QCameraImageCapture_imageCaptured_2536 (arg1, arg2);
}


// emitter void QCameraImageCapture::imageExposed(int id)

static void _init_emitter_imageExposed_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_imageExposed_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QCameraImageCapture_Adaptor *)cls)->emitter_QCameraImageCapture_imageExposed_767 (arg1);
}


// emitter void QCameraImageCapture::imageMetadataAvailable(int id, const QString &key, const QVariant &value)

static void _init_emitter_imageMetadataAvailable_4695 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("key");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_imageMetadataAvailable_4695 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QVariant &arg3 = gsi::arg_reader<const QVariant & >() (args, heap);
  ((QCameraImageCapture_Adaptor *)cls)->emitter_QCameraImageCapture_imageMetadataAvailable_4695 (arg1, arg2, arg3);
}


// emitter void QCameraImageCapture::imageSaved(int id, const QString &fileName)

static void _init_emitter_imageSaved_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("fileName");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_imageSaved_2684 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ((QCameraImageCapture_Adaptor *)cls)->emitter_QCameraImageCapture_imageSaved_2684 (arg1, arg2);
}


// exposed bool QCameraImageCapture::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QCameraImageCapture_Adaptor *)cls)->fp_QCameraImageCapture_isSignalConnected_c2394 (arg1));
}


// QMediaObject *QCameraImageCapture::mediaObject()

static void _init_cbs_mediaObject_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaObject * > ();
}

static void _call_cbs_mediaObject_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaObject * > ((QMediaObject *)((QCameraImageCapture_Adaptor *)cls)->cbs_mediaObject_c0_0 ());
}

static void _set_callback_cbs_mediaObject_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCapture_Adaptor *)cls)->cb_mediaObject_c0_0 = cb;
}


// emitter void QCameraImageCapture::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QCameraImageCapture_Adaptor *)cls)->emitter_QCameraImageCapture_objectNameChanged_4567 (arg1);
}


// emitter void QCameraImageCapture::readyForCaptureChanged(bool ready)

static void _init_emitter_readyForCaptureChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ready");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_readyForCaptureChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QCameraImageCapture_Adaptor *)cls)->emitter_QCameraImageCapture_readyForCaptureChanged_864 (arg1);
}


// exposed int QCameraImageCapture::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QCameraImageCapture_Adaptor *)cls)->fp_QCameraImageCapture_receivers_c1731 (arg1));
}


// exposed QObject *QCameraImageCapture::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QCameraImageCapture_Adaptor *)cls)->fp_QCameraImageCapture_sender_c0 ());
}


// exposed int QCameraImageCapture::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCameraImageCapture_Adaptor *)cls)->fp_QCameraImageCapture_senderSignalIndex_c0 ());
}


// bool QCameraImageCapture::setMediaObject(QMediaObject *)

static void _init_cbs_setMediaObject_1782_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMediaObject * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_setMediaObject_1782_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMediaObject *arg1 = args.read<QMediaObject * > (heap);
  ret.write<bool > ((bool)((QCameraImageCapture_Adaptor *)cls)->cbs_setMediaObject_1782_0 (arg1));
}

static void _set_callback_cbs_setMediaObject_1782_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCapture_Adaptor *)cls)->cb_setMediaObject_1782_0 = cb;
}


// void QCameraImageCapture::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCapture_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QCameraImageCapture> &qtdecl_QCameraImageCapture ();

static gsi::Methods methods_QCameraImageCapture_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCameraImageCapture::QCameraImageCapture(QMediaObject *mediaObject, QObject *parent)\nThis method creates an object of class QCameraImageCapture.", &_init_ctor_QCameraImageCapture_Adaptor_2976, &_call_ctor_QCameraImageCapture_Adaptor_2976);
  methods += new qt_gsi::GenericMethod ("emit_bufferFormatChanged", "@brief Emitter for signal void QCameraImageCapture::bufferFormatChanged(QVideoFrame::PixelFormat format)\nCall this method to emit this signal.", false, &_init_emitter_bufferFormatChanged_2758, &_call_emitter_bufferFormatChanged_2758);
  methods += new qt_gsi::GenericMethod ("emit_captureDestinationChanged", "@brief Emitter for signal void QCameraImageCapture::captureDestinationChanged(QFlags<QCameraImageCapture::CaptureDestination> destination)\nCall this method to emit this signal.", false, &_init_emitter_captureDestinationChanged_4999, &_call_emitter_captureDestinationChanged_4999);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCameraImageCapture::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCameraImageCapture::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QCameraImageCapture::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCameraImageCapture::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("emit_error_sig", "@brief Emitter for signal void QCameraImageCapture::error(int id, QCameraImageCapture::Error error, const QString &errorString)\nCall this method to emit this signal.", false, &_init_emitter_error_5523, &_call_emitter_error_5523);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QCameraImageCapture::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QCameraImageCapture::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_imageAvailable", "@brief Emitter for signal void QCameraImageCapture::imageAvailable(int id, const QVideoFrame &frame)\nCall this method to emit this signal.", false, &_init_emitter_imageAvailable_3047, &_call_emitter_imageAvailable_3047);
  methods += new qt_gsi::GenericMethod ("emit_imageCaptured", "@brief Emitter for signal void QCameraImageCapture::imageCaptured(int id, const QImage &preview)\nCall this method to emit this signal.", false, &_init_emitter_imageCaptured_2536, &_call_emitter_imageCaptured_2536);
  methods += new qt_gsi::GenericMethod ("emit_imageExposed", "@brief Emitter for signal void QCameraImageCapture::imageExposed(int id)\nCall this method to emit this signal.", false, &_init_emitter_imageExposed_767, &_call_emitter_imageExposed_767);
  methods += new qt_gsi::GenericMethod ("emit_imageMetadataAvailable", "@brief Emitter for signal void QCameraImageCapture::imageMetadataAvailable(int id, const QString &key, const QVariant &value)\nCall this method to emit this signal.", false, &_init_emitter_imageMetadataAvailable_4695, &_call_emitter_imageMetadataAvailable_4695);
  methods += new qt_gsi::GenericMethod ("emit_imageSaved", "@brief Emitter for signal void QCameraImageCapture::imageSaved(int id, const QString &fileName)\nCall this method to emit this signal.", false, &_init_emitter_imageSaved_2684, &_call_emitter_imageSaved_2684);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QCameraImageCapture::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("mediaObject", "@brief Virtual method QMediaObject *QCameraImageCapture::mediaObject()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mediaObject_c0_0, &_call_cbs_mediaObject_c0_0);
  methods += new qt_gsi::GenericMethod ("mediaObject", "@hide", true, &_init_cbs_mediaObject_c0_0, &_call_cbs_mediaObject_c0_0, &_set_callback_cbs_mediaObject_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QCameraImageCapture::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("emit_readyForCaptureChanged", "@brief Emitter for signal void QCameraImageCapture::readyForCaptureChanged(bool ready)\nCall this method to emit this signal.", false, &_init_emitter_readyForCaptureChanged_864, &_call_emitter_readyForCaptureChanged_864);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QCameraImageCapture::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QCameraImageCapture::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QCameraImageCapture::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setMediaObject", "@brief Virtual method bool QCameraImageCapture::setMediaObject(QMediaObject *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setMediaObject_1782_0, &_call_cbs_setMediaObject_1782_0);
  methods += new qt_gsi::GenericMethod ("*setMediaObject", "@hide", false, &_init_cbs_setMediaObject_1782_0, &_call_cbs_setMediaObject_1782_0, &_set_callback_cbs_setMediaObject_1782_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCameraImageCapture::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QCameraImageCapture_Adaptor> decl_QCameraImageCapture_Adaptor (qtdecl_QCameraImageCapture (), "QtMultimedia", "QCameraImageCapture",
  methods_QCameraImageCapture_Adaptor (),
  "@qt\n@brief Binding of QCameraImageCapture");

}


//  Implementation of the enum wrapper class for QCameraImageCapture::CaptureDestination
namespace qt_gsi
{

static gsi::Enum<QCameraImageCapture::CaptureDestination> decl_QCameraImageCapture_CaptureDestination_Enum ("QtMultimedia", "QCameraImageCapture_CaptureDestination",
    gsi::enum_const ("CaptureToFile", QCameraImageCapture::CaptureToFile, "@brief Enum constant QCameraImageCapture::CaptureToFile") +
    gsi::enum_const ("CaptureToBuffer", QCameraImageCapture::CaptureToBuffer, "@brief Enum constant QCameraImageCapture::CaptureToBuffer"),
  "@qt\n@brief This class represents the QCameraImageCapture::CaptureDestination enum");

static gsi::QFlagsClass<QCameraImageCapture::CaptureDestination > decl_QCameraImageCapture_CaptureDestination_Enums ("QtMultimedia", "QCameraImageCapture_QFlags_CaptureDestination",
  "@qt\n@brief This class represents the QFlags<QCameraImageCapture::CaptureDestination> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCameraImageCapture> inject_QCameraImageCapture_CaptureDestination_Enum_in_parent (decl_QCameraImageCapture_CaptureDestination_Enum.defs ());
static gsi::ClassExt<QCameraImageCapture> decl_QCameraImageCapture_CaptureDestination_Enum_as_child (decl_QCameraImageCapture_CaptureDestination_Enum, "CaptureDestination");
static gsi::ClassExt<QCameraImageCapture> decl_QCameraImageCapture_CaptureDestination_Enums_as_child (decl_QCameraImageCapture_CaptureDestination_Enums, "QFlags_CaptureDestination");

}


//  Implementation of the enum wrapper class for QCameraImageCapture::DriveMode
namespace qt_gsi
{

static gsi::Enum<QCameraImageCapture::DriveMode> decl_QCameraImageCapture_DriveMode_Enum ("QtMultimedia", "QCameraImageCapture_DriveMode",
    gsi::enum_const ("SingleImageCapture", QCameraImageCapture::SingleImageCapture, "@brief Enum constant QCameraImageCapture::SingleImageCapture"),
  "@qt\n@brief This class represents the QCameraImageCapture::DriveMode enum");

static gsi::QFlagsClass<QCameraImageCapture::DriveMode > decl_QCameraImageCapture_DriveMode_Enums ("QtMultimedia", "QCameraImageCapture_QFlags_DriveMode",
  "@qt\n@brief This class represents the QFlags<QCameraImageCapture::DriveMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCameraImageCapture> inject_QCameraImageCapture_DriveMode_Enum_in_parent (decl_QCameraImageCapture_DriveMode_Enum.defs ());
static gsi::ClassExt<QCameraImageCapture> decl_QCameraImageCapture_DriveMode_Enum_as_child (decl_QCameraImageCapture_DriveMode_Enum, "DriveMode");
static gsi::ClassExt<QCameraImageCapture> decl_QCameraImageCapture_DriveMode_Enums_as_child (decl_QCameraImageCapture_DriveMode_Enums, "QFlags_DriveMode");

}


//  Implementation of the enum wrapper class for QCameraImageCapture::Error
namespace qt_gsi
{

static gsi::Enum<QCameraImageCapture::Error> decl_QCameraImageCapture_Error_Enum ("QtMultimedia", "QCameraImageCapture_Error",
    gsi::enum_const ("NoError", QCameraImageCapture::NoError, "@brief Enum constant QCameraImageCapture::NoError") +
    gsi::enum_const ("NotReadyError", QCameraImageCapture::NotReadyError, "@brief Enum constant QCameraImageCapture::NotReadyError") +
    gsi::enum_const ("ResourceError", QCameraImageCapture::ResourceError, "@brief Enum constant QCameraImageCapture::ResourceError") +
    gsi::enum_const ("OutOfSpaceError", QCameraImageCapture::OutOfSpaceError, "@brief Enum constant QCameraImageCapture::OutOfSpaceError") +
    gsi::enum_const ("NotSupportedFeatureError", QCameraImageCapture::NotSupportedFeatureError, "@brief Enum constant QCameraImageCapture::NotSupportedFeatureError") +
    gsi::enum_const ("FormatError", QCameraImageCapture::FormatError, "@brief Enum constant QCameraImageCapture::FormatError"),
  "@qt\n@brief This class represents the QCameraImageCapture::Error enum");

static gsi::QFlagsClass<QCameraImageCapture::Error > decl_QCameraImageCapture_Error_Enums ("QtMultimedia", "QCameraImageCapture_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QCameraImageCapture::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCameraImageCapture> inject_QCameraImageCapture_Error_Enum_in_parent (decl_QCameraImageCapture_Error_Enum.defs ());
static gsi::ClassExt<QCameraImageCapture> decl_QCameraImageCapture_Error_Enum_as_child (decl_QCameraImageCapture_Error_Enum, "Error");
static gsi::ClassExt<QCameraImageCapture> decl_QCameraImageCapture_Error_Enums_as_child (decl_QCameraImageCapture_Error_Enums, "QFlags_Error");

}

