
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractVideoSurface.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAbstractVideoSurface>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QSize>
#include <QThread>
#include <QTimerEvent>
#include <QVideoFrame>
#include <QVideoSurfaceFormat>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractVideoSurface

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAbstractVideoSurface::staticMetaObject);
}


// QAbstractVideoSurface::Error QAbstractVideoSurface::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractVideoSurface::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAbstractVideoSurface::Error>::target_type > ((qt_gsi::Converter<QAbstractVideoSurface::Error>::target_type)qt_gsi::CppToQtAdaptor<QAbstractVideoSurface::Error>(((QAbstractVideoSurface *)cls)->error ()));
}


// bool QAbstractVideoSurface::isActive()


static void _init_f_isActive_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActive_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAbstractVideoSurface *)cls)->isActive ());
}


// bool QAbstractVideoSurface::isFormatSupported(const QVideoSurfaceFormat &format)


static void _init_f_isFormatSupported_c3227 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QVideoSurfaceFormat & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isFormatSupported_c3227 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoSurfaceFormat &arg1 = gsi::arg_reader<const QVideoSurfaceFormat & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractVideoSurface *)cls)->isFormatSupported (arg1));
}


// QSize QAbstractVideoSurface::nativeResolution()


static void _init_f_nativeResolution_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_nativeResolution_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QAbstractVideoSurface *)cls)->nativeResolution ());
}


// QVideoSurfaceFormat QAbstractVideoSurface::nearestFormat(const QVideoSurfaceFormat &format)


static void _init_f_nearestFormat_c3227 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QVideoSurfaceFormat & > (argspec_0);
  decl->set_return<QVideoSurfaceFormat > ();
}

static void _call_f_nearestFormat_c3227 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoSurfaceFormat &arg1 = gsi::arg_reader<const QVideoSurfaceFormat & >() (args, heap);
  ret.write<QVideoSurfaceFormat > ((QVideoSurfaceFormat)((QAbstractVideoSurface *)cls)->nearestFormat (arg1));
}


// bool QAbstractVideoSurface::present(const QVideoFrame &frame)


static void _init_f_present_2388 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frame");
  decl->add_arg<const QVideoFrame & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_present_2388 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoFrame &arg1 = gsi::arg_reader<const QVideoFrame & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractVideoSurface *)cls)->present (arg1));
}


// bool QAbstractVideoSurface::start(const QVideoSurfaceFormat &format)


static void _init_f_start_3227 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QVideoSurfaceFormat & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_start_3227 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoSurfaceFormat &arg1 = gsi::arg_reader<const QVideoSurfaceFormat & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractVideoSurface *)cls)->start (arg1));
}


// void QAbstractVideoSurface::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractVideoSurface *)cls)->stop ();
}


// QList<QVideoFrame::PixelFormat> QAbstractVideoSurface::supportedPixelFormats(QAbstractVideoBuffer::HandleType type)


static void _init_f_supportedPixelFormats_c3564 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type", true, "QAbstractVideoBuffer::NoHandle");
  decl->add_arg<const qt_gsi::Converter<QAbstractVideoBuffer::HandleType>::target_type & > (argspec_0);
  decl->set_return<QList<QVideoFrame::PixelFormat> > ();
}

static void _call_f_supportedPixelFormats_c3564 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractVideoBuffer::HandleType>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractVideoBuffer::HandleType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractVideoBuffer::HandleType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractVideoBuffer::HandleType>(heap, QAbstractVideoBuffer::NoHandle), heap);
  ret.write<QList<QVideoFrame::PixelFormat> > ((QList<QVideoFrame::PixelFormat>)((QAbstractVideoSurface *)cls)->supportedPixelFormats (qt_gsi::QtToCppAdaptor<QAbstractVideoBuffer::HandleType>(arg1).cref()));
}


// QVideoSurfaceFormat QAbstractVideoSurface::surfaceFormat()


static void _init_f_surfaceFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVideoSurfaceFormat > ();
}

static void _call_f_surfaceFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVideoSurfaceFormat > ((QVideoSurfaceFormat)((QAbstractVideoSurface *)cls)->surfaceFormat ());
}


// static QString QAbstractVideoSurface::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractVideoSurface::tr (arg1, arg2, arg3));
}


// static QString QAbstractVideoSurface::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractVideoSurface::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QAbstractVideoSurface () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QAbstractVideoSurface::Error QAbstractVideoSurface::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("isActive?", "@brief Method bool QAbstractVideoSurface::isActive()\n", true, &_init_f_isActive_c0, &_call_f_isActive_c0);
  methods += new qt_gsi::GenericMethod ("isFormatSupported?", "@brief Method bool QAbstractVideoSurface::isFormatSupported(const QVideoSurfaceFormat &format)\n", true, &_init_f_isFormatSupported_c3227, &_call_f_isFormatSupported_c3227);
  methods += new qt_gsi::GenericMethod (":nativeResolution", "@brief Method QSize QAbstractVideoSurface::nativeResolution()\n", true, &_init_f_nativeResolution_c0, &_call_f_nativeResolution_c0);
  methods += new qt_gsi::GenericMethod ("nearestFormat", "@brief Method QVideoSurfaceFormat QAbstractVideoSurface::nearestFormat(const QVideoSurfaceFormat &format)\n", true, &_init_f_nearestFormat_c3227, &_call_f_nearestFormat_c3227);
  methods += new qt_gsi::GenericMethod ("present", "@brief Method bool QAbstractVideoSurface::present(const QVideoFrame &frame)\n", false, &_init_f_present_2388, &_call_f_present_2388);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method bool QAbstractVideoSurface::start(const QVideoSurfaceFormat &format)\n", false, &_init_f_start_3227, &_call_f_start_3227);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QAbstractVideoSurface::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod ("supportedPixelFormats", "@brief Method QList<QVideoFrame::PixelFormat> QAbstractVideoSurface::supportedPixelFormats(QAbstractVideoBuffer::HandleType type)\n", true, &_init_f_supportedPixelFormats_c3564, &_call_f_supportedPixelFormats_c3564);
  methods += new qt_gsi::GenericMethod ("surfaceFormat", "@brief Method QVideoSurfaceFormat QAbstractVideoSurface::surfaceFormat()\n", true, &_init_f_surfaceFormat_c0, &_call_f_surfaceFormat_c0);
  methods += gsi::qt_signal<bool > ("activeChanged(bool)", "activeChanged", gsi::arg("active"), "@brief Signal declaration for QAbstractVideoSurface::activeChanged(bool active)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QAbstractVideoSurface::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QSize & > ("nativeResolutionChanged(const QSize &)", "nativeResolutionChanged", gsi::arg("resolution"), "@brief Signal declaration for QAbstractVideoSurface::nativeResolutionChanged(const QSize &resolution)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QAbstractVideoSurface::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("supportedFormatsChanged()", "supportedFormatsChanged", "@brief Signal declaration for QAbstractVideoSurface::supportedFormatsChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QVideoSurfaceFormat & > ("surfaceFormatChanged(const QVideoSurfaceFormat &)", "surfaceFormatChanged", gsi::arg("format"), "@brief Signal declaration for QAbstractVideoSurface::surfaceFormatChanged(const QVideoSurfaceFormat &format)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractVideoSurface::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractVideoSurface::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QAbstractVideoSurface> decl_QAbstractVideoSurface (qtdecl_QObject (), "QtMultimedia", "QAbstractVideoSurface_Native",
  methods_QAbstractVideoSurface (),
  "@hide\n@alias QAbstractVideoSurface");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QAbstractVideoSurface> &qtdecl_QAbstractVideoSurface () { return decl_QAbstractVideoSurface; }

}


class QAbstractVideoSurface_Adaptor : public QAbstractVideoSurface, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAbstractVideoSurface_Adaptor();

  //  [adaptor ctor] QAbstractVideoSurface::QAbstractVideoSurface(QObject *parent)
  QAbstractVideoSurface_Adaptor() : QAbstractVideoSurface()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAbstractVideoSurface::QAbstractVideoSurface(QObject *parent)
  QAbstractVideoSurface_Adaptor(QObject *parent) : QAbstractVideoSurface(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QAbstractVideoSurface::isSignalConnected(const QMetaMethod &signal)
  bool fp_QAbstractVideoSurface_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QAbstractVideoSurface::isSignalConnected(signal);
  }

  //  [expose] int QAbstractVideoSurface::receivers(const char *signal)
  int fp_QAbstractVideoSurface_receivers_c1731 (const char *signal) const {
    return QAbstractVideoSurface::receivers(signal);
  }

  //  [expose] QObject *QAbstractVideoSurface::sender()
  QObject * fp_QAbstractVideoSurface_sender_c0 () const {
    return QAbstractVideoSurface::sender();
  }

  //  [expose] int QAbstractVideoSurface::senderSignalIndex()
  int fp_QAbstractVideoSurface_senderSignalIndex_c0 () const {
    return QAbstractVideoSurface::senderSignalIndex();
  }

  //  [expose] void QAbstractVideoSurface::setError(QAbstractVideoSurface::Error error)
  void fp_QAbstractVideoSurface_setError_3191 (const qt_gsi::Converter<QAbstractVideoSurface::Error>::target_type & error) {
    QAbstractVideoSurface::setError(qt_gsi::QtToCppAdaptor<QAbstractVideoSurface::Error>(error).cref());
  }

  //  [expose] void QAbstractVideoSurface::setNativeResolution(const QSize &resolution)
  void fp_QAbstractVideoSurface_setNativeResolution_1805 (const QSize &resolution) {
    QAbstractVideoSurface::setNativeResolution(resolution);
  }

  //  [emitter impl] void QAbstractVideoSurface::activeChanged(bool active)
  void emitter_QAbstractVideoSurface_activeChanged_864(bool active)
  {
    emit QAbstractVideoSurface::activeChanged(active);
  }

  //  [emitter impl] void QAbstractVideoSurface::destroyed(QObject *)
  void emitter_QAbstractVideoSurface_destroyed_1302(QObject *arg1)
  {
    emit QAbstractVideoSurface::destroyed(arg1);
  }

  //  [adaptor impl] bool QAbstractVideoSurface::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QAbstractVideoSurface::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAbstractVideoSurface_Adaptor, bool, QEvent *>(&QAbstractVideoSurface_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QAbstractVideoSurface::event(_event);
    }
  }

  //  [adaptor impl] bool QAbstractVideoSurface::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QAbstractVideoSurface::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAbstractVideoSurface_Adaptor, bool, QObject *, QEvent *>(&QAbstractVideoSurface_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QAbstractVideoSurface::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] bool QAbstractVideoSurface::isFormatSupported(const QVideoSurfaceFormat &format)
  bool cbs_isFormatSupported_c3227_0(const QVideoSurfaceFormat &format) const
  {
    return QAbstractVideoSurface::isFormatSupported(format);
  }

  virtual bool isFormatSupported(const QVideoSurfaceFormat &format) const
  {
    if (cb_isFormatSupported_c3227_0.can_issue()) {
      return cb_isFormatSupported_c3227_0.issue<QAbstractVideoSurface_Adaptor, bool, const QVideoSurfaceFormat &>(&QAbstractVideoSurface_Adaptor::cbs_isFormatSupported_c3227_0, format);
    } else {
      return QAbstractVideoSurface::isFormatSupported(format);
    }
  }

  //  [emitter impl] void QAbstractVideoSurface::nativeResolutionChanged(const QSize &resolution)
  void emitter_QAbstractVideoSurface_nativeResolutionChanged_1805(const QSize &resolution)
  {
    emit QAbstractVideoSurface::nativeResolutionChanged(resolution);
  }

  //  [adaptor impl] QVideoSurfaceFormat QAbstractVideoSurface::nearestFormat(const QVideoSurfaceFormat &format)
  QVideoSurfaceFormat cbs_nearestFormat_c3227_0(const QVideoSurfaceFormat &format) const
  {
    return QAbstractVideoSurface::nearestFormat(format);
  }

  virtual QVideoSurfaceFormat nearestFormat(const QVideoSurfaceFormat &format) const
  {
    if (cb_nearestFormat_c3227_0.can_issue()) {
      return cb_nearestFormat_c3227_0.issue<QAbstractVideoSurface_Adaptor, QVideoSurfaceFormat, const QVideoSurfaceFormat &>(&QAbstractVideoSurface_Adaptor::cbs_nearestFormat_c3227_0, format);
    } else {
      return QAbstractVideoSurface::nearestFormat(format);
    }
  }

  //  [emitter impl] void QAbstractVideoSurface::objectNameChanged(const QString &objectName)
  void emitter_QAbstractVideoSurface_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QAbstractVideoSurface::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] bool QAbstractVideoSurface::present(const QVideoFrame &frame)
  bool cbs_present_2388_0(const QVideoFrame &frame)
  {
    __SUPPRESS_UNUSED_WARNING (frame);
    throw qt_gsi::AbstractMethodCalledException("present");
  }

  virtual bool present(const QVideoFrame &frame)
  {
    if (cb_present_2388_0.can_issue()) {
      return cb_present_2388_0.issue<QAbstractVideoSurface_Adaptor, bool, const QVideoFrame &>(&QAbstractVideoSurface_Adaptor::cbs_present_2388_0, frame);
    } else {
      throw qt_gsi::AbstractMethodCalledException("present");
    }
  }

  //  [adaptor impl] bool QAbstractVideoSurface::start(const QVideoSurfaceFormat &format)
  bool cbs_start_3227_0(const QVideoSurfaceFormat &format)
  {
    return QAbstractVideoSurface::start(format);
  }

  virtual bool start(const QVideoSurfaceFormat &format)
  {
    if (cb_start_3227_0.can_issue()) {
      return cb_start_3227_0.issue<QAbstractVideoSurface_Adaptor, bool, const QVideoSurfaceFormat &>(&QAbstractVideoSurface_Adaptor::cbs_start_3227_0, format);
    } else {
      return QAbstractVideoSurface::start(format);
    }
  }

  //  [adaptor impl] void QAbstractVideoSurface::stop()
  void cbs_stop_0_0()
  {
    QAbstractVideoSurface::stop();
  }

  virtual void stop()
  {
    if (cb_stop_0_0.can_issue()) {
      cb_stop_0_0.issue<QAbstractVideoSurface_Adaptor>(&QAbstractVideoSurface_Adaptor::cbs_stop_0_0);
    } else {
      QAbstractVideoSurface::stop();
    }
  }

  //  [emitter impl] void QAbstractVideoSurface::supportedFormatsChanged()
  void emitter_QAbstractVideoSurface_supportedFormatsChanged_0()
  {
    emit QAbstractVideoSurface::supportedFormatsChanged();
  }

  //  [adaptor impl] QList<QVideoFrame::PixelFormat> QAbstractVideoSurface::supportedPixelFormats(QAbstractVideoBuffer::HandleType type)
  QList<QVideoFrame::PixelFormat> cbs_supportedPixelFormats_c3564_1(const qt_gsi::Converter<QAbstractVideoBuffer::HandleType>::target_type & type) const
  {
    __SUPPRESS_UNUSED_WARNING (type);
    throw qt_gsi::AbstractMethodCalledException("supportedPixelFormats");
  }

  virtual QList<QVideoFrame::PixelFormat> supportedPixelFormats(QAbstractVideoBuffer::HandleType type) const
  {
    if (cb_supportedPixelFormats_c3564_1.can_issue()) {
      return cb_supportedPixelFormats_c3564_1.issue<QAbstractVideoSurface_Adaptor, QList<QVideoFrame::PixelFormat>, const qt_gsi::Converter<QAbstractVideoBuffer::HandleType>::target_type &>(&QAbstractVideoSurface_Adaptor::cbs_supportedPixelFormats_c3564_1, qt_gsi::CppToQtAdaptor<QAbstractVideoBuffer::HandleType>(type));
    } else {
      throw qt_gsi::AbstractMethodCalledException("supportedPixelFormats");
    }
  }

  //  [emitter impl] void QAbstractVideoSurface::surfaceFormatChanged(const QVideoSurfaceFormat &format)
  void emitter_QAbstractVideoSurface_surfaceFormatChanged_3227(const QVideoSurfaceFormat &format)
  {
    emit QAbstractVideoSurface::surfaceFormatChanged(format);
  }

  //  [adaptor impl] void QAbstractVideoSurface::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QAbstractVideoSurface::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAbstractVideoSurface_Adaptor, QChildEvent *>(&QAbstractVideoSurface_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QAbstractVideoSurface::childEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractVideoSurface::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QAbstractVideoSurface::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAbstractVideoSurface_Adaptor, QEvent *>(&QAbstractVideoSurface_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QAbstractVideoSurface::customEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractVideoSurface::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QAbstractVideoSurface::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QAbstractVideoSurface_Adaptor, const QMetaMethod &>(&QAbstractVideoSurface_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QAbstractVideoSurface::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAbstractVideoSurface::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QAbstractVideoSurface::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAbstractVideoSurface_Adaptor, QTimerEvent *>(&QAbstractVideoSurface_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QAbstractVideoSurface::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isFormatSupported_c3227_0;
  gsi::Callback cb_nearestFormat_c3227_0;
  gsi::Callback cb_present_2388_0;
  gsi::Callback cb_start_3227_0;
  gsi::Callback cb_stop_0_0;
  gsi::Callback cb_supportedPixelFormats_c3564_1;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAbstractVideoSurface_Adaptor::~QAbstractVideoSurface_Adaptor() { }

//  Constructor QAbstractVideoSurface::QAbstractVideoSurface(QObject *parent) (adaptor class)

static void _init_ctor_QAbstractVideoSurface_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QAbstractVideoSurface_Adaptor> ();
}

static void _call_ctor_QAbstractVideoSurface_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QAbstractVideoSurface_Adaptor *> (new QAbstractVideoSurface_Adaptor (arg1));
}


// emitter void QAbstractVideoSurface::activeChanged(bool active)

static void _init_emitter_activeChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("active");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_activeChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QAbstractVideoSurface_Adaptor *)cls)->emitter_QAbstractVideoSurface_activeChanged_864 (arg1);
}


// void QAbstractVideoSurface::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractVideoSurface_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractVideoSurface_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QAbstractVideoSurface::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractVideoSurface_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractVideoSurface_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QAbstractVideoSurface::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QAbstractVideoSurface_Adaptor *)cls)->emitter_QAbstractVideoSurface_destroyed_1302 (arg1);
}


// void QAbstractVideoSurface::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractVideoSurface_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractVideoSurface_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QAbstractVideoSurface::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractVideoSurface_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractVideoSurface_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QAbstractVideoSurface::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractVideoSurface_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractVideoSurface_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QAbstractVideoSurface::isFormatSupported(const QVideoSurfaceFormat &format)

static void _init_cbs_isFormatSupported_c3227_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QVideoSurfaceFormat & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isFormatSupported_c3227_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoSurfaceFormat &arg1 = args.read<const QVideoSurfaceFormat & > (heap);
  ret.write<bool > ((bool)((QAbstractVideoSurface_Adaptor *)cls)->cbs_isFormatSupported_c3227_0 (arg1));
}

static void _set_callback_cbs_isFormatSupported_c3227_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractVideoSurface_Adaptor *)cls)->cb_isFormatSupported_c3227_0 = cb;
}


// exposed bool QAbstractVideoSurface::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractVideoSurface_Adaptor *)cls)->fp_QAbstractVideoSurface_isSignalConnected_c2394 (arg1));
}


// emitter void QAbstractVideoSurface::nativeResolutionChanged(const QSize &resolution)

static void _init_emitter_nativeResolutionChanged_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("resolution");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_nativeResolutionChanged_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  ((QAbstractVideoSurface_Adaptor *)cls)->emitter_QAbstractVideoSurface_nativeResolutionChanged_1805 (arg1);
}


// QVideoSurfaceFormat QAbstractVideoSurface::nearestFormat(const QVideoSurfaceFormat &format)

static void _init_cbs_nearestFormat_c3227_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QVideoSurfaceFormat & > (argspec_0);
  decl->set_return<QVideoSurfaceFormat > ();
}

static void _call_cbs_nearestFormat_c3227_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoSurfaceFormat &arg1 = args.read<const QVideoSurfaceFormat & > (heap);
  ret.write<QVideoSurfaceFormat > ((QVideoSurfaceFormat)((QAbstractVideoSurface_Adaptor *)cls)->cbs_nearestFormat_c3227_0 (arg1));
}

static void _set_callback_cbs_nearestFormat_c3227_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractVideoSurface_Adaptor *)cls)->cb_nearestFormat_c3227_0 = cb;
}


// emitter void QAbstractVideoSurface::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QAbstractVideoSurface_Adaptor *)cls)->emitter_QAbstractVideoSurface_objectNameChanged_4567 (arg1);
}


// bool QAbstractVideoSurface::present(const QVideoFrame &frame)

static void _init_cbs_present_2388_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frame");
  decl->add_arg<const QVideoFrame & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_present_2388_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoFrame &arg1 = args.read<const QVideoFrame & > (heap);
  ret.write<bool > ((bool)((QAbstractVideoSurface_Adaptor *)cls)->cbs_present_2388_0 (arg1));
}

static void _set_callback_cbs_present_2388_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractVideoSurface_Adaptor *)cls)->cb_present_2388_0 = cb;
}


// exposed int QAbstractVideoSurface::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QAbstractVideoSurface_Adaptor *)cls)->fp_QAbstractVideoSurface_receivers_c1731 (arg1));
}


// exposed QObject *QAbstractVideoSurface::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAbstractVideoSurface_Adaptor *)cls)->fp_QAbstractVideoSurface_sender_c0 ());
}


// exposed int QAbstractVideoSurface::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractVideoSurface_Adaptor *)cls)->fp_QAbstractVideoSurface_senderSignalIndex_c0 ());
}


// exposed void QAbstractVideoSurface::setError(QAbstractVideoSurface::Error error)

static void _init_fp_setError_3191 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<const qt_gsi::Converter<QAbstractVideoSurface::Error>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setError_3191 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractVideoSurface::Error>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractVideoSurface::Error>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractVideoSurface_Adaptor *)cls)->fp_QAbstractVideoSurface_setError_3191 (arg1);
}


// exposed void QAbstractVideoSurface::setNativeResolution(const QSize &resolution)

static void _init_fp_setNativeResolution_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("resolution");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setNativeResolution_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractVideoSurface_Adaptor *)cls)->fp_QAbstractVideoSurface_setNativeResolution_1805 (arg1);
}


// bool QAbstractVideoSurface::start(const QVideoSurfaceFormat &format)

static void _init_cbs_start_3227_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QVideoSurfaceFormat & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_start_3227_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoSurfaceFormat &arg1 = args.read<const QVideoSurfaceFormat & > (heap);
  ret.write<bool > ((bool)((QAbstractVideoSurface_Adaptor *)cls)->cbs_start_3227_0 (arg1));
}

static void _set_callback_cbs_start_3227_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractVideoSurface_Adaptor *)cls)->cb_start_3227_0 = cb;
}


// void QAbstractVideoSurface::stop()

static void _init_cbs_stop_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_stop_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractVideoSurface_Adaptor *)cls)->cbs_stop_0_0 ();
}

static void _set_callback_cbs_stop_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractVideoSurface_Adaptor *)cls)->cb_stop_0_0 = cb;
}


// emitter void QAbstractVideoSurface::supportedFormatsChanged()

static void _init_emitter_supportedFormatsChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_supportedFormatsChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QAbstractVideoSurface_Adaptor *)cls)->emitter_QAbstractVideoSurface_supportedFormatsChanged_0 ();
}


// QList<QVideoFrame::PixelFormat> QAbstractVideoSurface::supportedPixelFormats(QAbstractVideoBuffer::HandleType type)

static void _init_cbs_supportedPixelFormats_c3564_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QAbstractVideoBuffer::HandleType>::target_type & > (argspec_0);
  decl->set_return<QList<QVideoFrame::PixelFormat> > ();
}

static void _call_cbs_supportedPixelFormats_c3564_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractVideoBuffer::HandleType>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractVideoBuffer::HandleType>::target_type & > (heap);
  ret.write<QList<QVideoFrame::PixelFormat> > ((QList<QVideoFrame::PixelFormat>)((QAbstractVideoSurface_Adaptor *)cls)->cbs_supportedPixelFormats_c3564_1 (arg1));
}

static void _set_callback_cbs_supportedPixelFormats_c3564_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractVideoSurface_Adaptor *)cls)->cb_supportedPixelFormats_c3564_1 = cb;
}


// emitter void QAbstractVideoSurface::surfaceFormatChanged(const QVideoSurfaceFormat &format)

static void _init_emitter_surfaceFormatChanged_3227 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QVideoSurfaceFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_surfaceFormatChanged_3227 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoSurfaceFormat &arg1 = gsi::arg_reader<const QVideoSurfaceFormat & >() (args, heap);
  ((QAbstractVideoSurface_Adaptor *)cls)->emitter_QAbstractVideoSurface_surfaceFormatChanged_3227 (arg1);
}


// void QAbstractVideoSurface::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractVideoSurface_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractVideoSurface_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QAbstractVideoSurface> &qtdecl_QAbstractVideoSurface ();

static gsi::Methods methods_QAbstractVideoSurface_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractVideoSurface::QAbstractVideoSurface(QObject *parent)\nThis method creates an object of class QAbstractVideoSurface.", &_init_ctor_QAbstractVideoSurface_Adaptor_1302, &_call_ctor_QAbstractVideoSurface_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("emit_activeChanged", "@brief Emitter for signal void QAbstractVideoSurface::activeChanged(bool active)\nCall this method to emit this signal.", false, &_init_emitter_activeChanged_864, &_call_emitter_activeChanged_864);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAbstractVideoSurface::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAbstractVideoSurface::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QAbstractVideoSurface::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAbstractVideoSurface::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QAbstractVideoSurface::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAbstractVideoSurface::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("isFormatSupported", "@brief Virtual method bool QAbstractVideoSurface::isFormatSupported(const QVideoSurfaceFormat &format)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isFormatSupported_c3227_0, &_call_cbs_isFormatSupported_c3227_0);
  methods += new qt_gsi::GenericMethod ("isFormatSupported", "@hide", true, &_init_cbs_isFormatSupported_c3227_0, &_call_cbs_isFormatSupported_c3227_0, &_set_callback_cbs_isFormatSupported_c3227_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QAbstractVideoSurface::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_nativeResolutionChanged", "@brief Emitter for signal void QAbstractVideoSurface::nativeResolutionChanged(const QSize &resolution)\nCall this method to emit this signal.", false, &_init_emitter_nativeResolutionChanged_1805, &_call_emitter_nativeResolutionChanged_1805);
  methods += new qt_gsi::GenericMethod ("nearestFormat", "@brief Virtual method QVideoSurfaceFormat QAbstractVideoSurface::nearestFormat(const QVideoSurfaceFormat &format)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_nearestFormat_c3227_0, &_call_cbs_nearestFormat_c3227_0);
  methods += new qt_gsi::GenericMethod ("nearestFormat", "@hide", true, &_init_cbs_nearestFormat_c3227_0, &_call_cbs_nearestFormat_c3227_0, &_set_callback_cbs_nearestFormat_c3227_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QAbstractVideoSurface::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("present", "@brief Virtual method bool QAbstractVideoSurface::present(const QVideoFrame &frame)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_present_2388_0, &_call_cbs_present_2388_0);
  methods += new qt_gsi::GenericMethod ("present", "@hide", false, &_init_cbs_present_2388_0, &_call_cbs_present_2388_0, &_set_callback_cbs_present_2388_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QAbstractVideoSurface::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QAbstractVideoSurface::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QAbstractVideoSurface::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setError", "@brief Method void QAbstractVideoSurface::setError(QAbstractVideoSurface::Error error)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setError_3191, &_call_fp_setError_3191);
  methods += new qt_gsi::GenericMethod ("*setNativeResolution", "@brief Method void QAbstractVideoSurface::setNativeResolution(const QSize &resolution)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setNativeResolution_1805, &_call_fp_setNativeResolution_1805);
  methods += new qt_gsi::GenericMethod ("start", "@brief Virtual method bool QAbstractVideoSurface::start(const QVideoSurfaceFormat &format)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_start_3227_0, &_call_cbs_start_3227_0);
  methods += new qt_gsi::GenericMethod ("start", "@hide", false, &_init_cbs_start_3227_0, &_call_cbs_start_3227_0, &_set_callback_cbs_start_3227_0);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Virtual method void QAbstractVideoSurface::stop()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_stop_0_0, &_call_cbs_stop_0_0);
  methods += new qt_gsi::GenericMethod ("stop", "@hide", false, &_init_cbs_stop_0_0, &_call_cbs_stop_0_0, &_set_callback_cbs_stop_0_0);
  methods += new qt_gsi::GenericMethod ("emit_supportedFormatsChanged", "@brief Emitter for signal void QAbstractVideoSurface::supportedFormatsChanged()\nCall this method to emit this signal.", false, &_init_emitter_supportedFormatsChanged_0, &_call_emitter_supportedFormatsChanged_0);
  methods += new qt_gsi::GenericMethod ("supportedPixelFormats", "@brief Virtual method QList<QVideoFrame::PixelFormat> QAbstractVideoSurface::supportedPixelFormats(QAbstractVideoBuffer::HandleType type)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedPixelFormats_c3564_1, &_call_cbs_supportedPixelFormats_c3564_1);
  methods += new qt_gsi::GenericMethod ("supportedPixelFormats", "@hide", true, &_init_cbs_supportedPixelFormats_c3564_1, &_call_cbs_supportedPixelFormats_c3564_1, &_set_callback_cbs_supportedPixelFormats_c3564_1);
  methods += new qt_gsi::GenericMethod ("emit_surfaceFormatChanged", "@brief Emitter for signal void QAbstractVideoSurface::surfaceFormatChanged(const QVideoSurfaceFormat &format)\nCall this method to emit this signal.", false, &_init_emitter_surfaceFormatChanged_3227, &_call_emitter_surfaceFormatChanged_3227);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAbstractVideoSurface::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QAbstractVideoSurface_Adaptor> decl_QAbstractVideoSurface_Adaptor (qtdecl_QAbstractVideoSurface (), "QtMultimedia", "QAbstractVideoSurface",
  methods_QAbstractVideoSurface_Adaptor (),
  "@qt\n@brief Binding of QAbstractVideoSurface");

}


//  Implementation of the enum wrapper class for QAbstractVideoSurface::Error
namespace qt_gsi
{

static gsi::Enum<QAbstractVideoSurface::Error> decl_QAbstractVideoSurface_Error_Enum ("QtMultimedia", "QAbstractVideoSurface_Error",
    gsi::enum_const ("NoError", QAbstractVideoSurface::NoError, "@brief Enum constant QAbstractVideoSurface::NoError") +
    gsi::enum_const ("UnsupportedFormatError", QAbstractVideoSurface::UnsupportedFormatError, "@brief Enum constant QAbstractVideoSurface::UnsupportedFormatError") +
    gsi::enum_const ("IncorrectFormatError", QAbstractVideoSurface::IncorrectFormatError, "@brief Enum constant QAbstractVideoSurface::IncorrectFormatError") +
    gsi::enum_const ("StoppedError", QAbstractVideoSurface::StoppedError, "@brief Enum constant QAbstractVideoSurface::StoppedError") +
    gsi::enum_const ("ResourceError", QAbstractVideoSurface::ResourceError, "@brief Enum constant QAbstractVideoSurface::ResourceError"),
  "@qt\n@brief This class represents the QAbstractVideoSurface::Error enum");

static gsi::QFlagsClass<QAbstractVideoSurface::Error > decl_QAbstractVideoSurface_Error_Enums ("QtMultimedia", "QAbstractVideoSurface_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QAbstractVideoSurface::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractVideoSurface> inject_QAbstractVideoSurface_Error_Enum_in_parent (decl_QAbstractVideoSurface_Error_Enum.defs ());
static gsi::ClassExt<QAbstractVideoSurface> decl_QAbstractVideoSurface_Error_Enum_as_child (decl_QAbstractVideoSurface_Error_Enum, "Error");
static gsi::ClassExt<QAbstractVideoSurface> decl_QAbstractVideoSurface_Error_Enums_as_child (decl_QAbstractVideoSurface_Error_Enums, "QFlags_Error");

}

