
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQRegExpValidator.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QRegExpValidator>
#include <QChildEvent>
#include <QEvent>
#include <QLocale>
#include <QMetaMethod>
#include <QObject>
#include <QRegExp>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QRegExpValidator

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QRegExpValidator::staticMetaObject);
}


// const QRegExp &QRegExpValidator::regExp()


static void _init_f_regExp_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QRegExp & > ();
}

static void _call_f_regExp_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QRegExp & > ((const QRegExp &)((QRegExpValidator *)cls)->regExp ());
}


// void QRegExpValidator::setRegExp(const QRegExp &rx)


static void _init_f_setRegExp_1981 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rx");
  decl->add_arg<const QRegExp & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRegExp_1981 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegExp &arg1 = gsi::arg_reader<const QRegExp & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRegExpValidator *)cls)->setRegExp (arg1);
}


// QValidator::State QRegExpValidator::validate(QString &input, int &pos)


static void _init_f_validate_c2171 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("input");
  decl->add_arg<QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pos");
  decl->add_arg<int & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QValidator::State>::target_type > ();
}

static void _call_f_validate_c2171 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString &arg1 = gsi::arg_reader<QString & >() (args, heap);
  int &arg2 = gsi::arg_reader<int & >() (args, heap);
  ret.write<qt_gsi::Converter<QValidator::State>::target_type > ((qt_gsi::Converter<QValidator::State>::target_type)qt_gsi::CppToQtAdaptor<QValidator::State>(((QRegExpValidator *)cls)->validate (arg1, arg2)));
}


// static QString QRegExpValidator::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QRegExpValidator::tr (arg1, arg2, arg3));
}


// static QString QRegExpValidator::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QRegExpValidator::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QRegExpValidator () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":regExp", "@brief Method const QRegExp &QRegExpValidator::regExp()\n", true, &_init_f_regExp_c0, &_call_f_regExp_c0);
  methods += new qt_gsi::GenericMethod ("setRegExp|regExp=", "@brief Method void QRegExpValidator::setRegExp(const QRegExp &rx)\n", false, &_init_f_setRegExp_1981, &_call_f_setRegExp_1981);
  methods += new qt_gsi::GenericMethod ("validate", "@brief Method QValidator::State QRegExpValidator::validate(QString &input, int &pos)\nThis is a reimplementation of QValidator::validate", true, &_init_f_validate_c2171, &_call_f_validate_c2171);
  methods += gsi::qt_signal ("changed()", "changed", "@brief Signal declaration for QRegExpValidator::changed()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QRegExpValidator::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QRegExpValidator::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QRegExp & > ("regExpChanged(const QRegExp &)", "regExpChanged", gsi::arg("regExp"), "@brief Signal declaration for QRegExpValidator::regExpChanged(const QRegExp &regExp)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QRegExpValidator::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QRegExpValidator::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QValidator> &qtdecl_QValidator ();

qt_gsi::QtNativeClass<QRegExpValidator> decl_QRegExpValidator (qtdecl_QValidator (), "QtGui", "QRegExpValidator_Native",
  methods_QRegExpValidator (),
  "@hide\n@alias QRegExpValidator");

GSI_QTGUI_PUBLIC gsi::Class<QRegExpValidator> &qtdecl_QRegExpValidator () { return decl_QRegExpValidator; }

}


class QRegExpValidator_Adaptor : public QRegExpValidator, public qt_gsi::QtObjectBase
{
public:

  virtual ~QRegExpValidator_Adaptor();

  //  [adaptor ctor] QRegExpValidator::QRegExpValidator(QObject *parent)
  QRegExpValidator_Adaptor() : QRegExpValidator()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QRegExpValidator::QRegExpValidator(QObject *parent)
  QRegExpValidator_Adaptor(QObject *parent) : QRegExpValidator(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QRegExpValidator::QRegExpValidator(const QRegExp &rx, QObject *parent)
  QRegExpValidator_Adaptor(const QRegExp &rx) : QRegExpValidator(rx)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QRegExpValidator::QRegExpValidator(const QRegExp &rx, QObject *parent)
  QRegExpValidator_Adaptor(const QRegExp &rx, QObject *parent) : QRegExpValidator(rx, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QRegExpValidator::isSignalConnected(const QMetaMethod &signal)
  bool fp_QRegExpValidator_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QRegExpValidator::isSignalConnected(signal);
  }

  //  [expose] int QRegExpValidator::receivers(const char *signal)
  int fp_QRegExpValidator_receivers_c1731 (const char *signal) const {
    return QRegExpValidator::receivers(signal);
  }

  //  [expose] QObject *QRegExpValidator::sender()
  QObject * fp_QRegExpValidator_sender_c0 () const {
    return QRegExpValidator::sender();
  }

  //  [expose] int QRegExpValidator::senderSignalIndex()
  int fp_QRegExpValidator_senderSignalIndex_c0 () const {
    return QRegExpValidator::senderSignalIndex();
  }

  //  [emitter impl] void QRegExpValidator::changed()
  void emitter_QRegExpValidator_changed_0()
  {
    emit QRegExpValidator::changed();
  }

  //  [emitter impl] void QRegExpValidator::destroyed(QObject *)
  void emitter_QRegExpValidator_destroyed_1302(QObject *arg1)
  {
    emit QRegExpValidator::destroyed(arg1);
  }

  //  [adaptor impl] bool QRegExpValidator::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QRegExpValidator::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QRegExpValidator_Adaptor, bool, QEvent *>(&QRegExpValidator_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QRegExpValidator::event(_event);
    }
  }

  //  [adaptor impl] bool QRegExpValidator::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QRegExpValidator::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QRegExpValidator_Adaptor, bool, QObject *, QEvent *>(&QRegExpValidator_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QRegExpValidator::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QRegExpValidator::fixup(QString &)
  void cbs_fixup_c1330_0(QString &arg1) const
  {
    QRegExpValidator::fixup(arg1);
  }

  virtual void fixup(QString &arg1) const
  {
    if (cb_fixup_c1330_0.can_issue()) {
      cb_fixup_c1330_0.issue<QRegExpValidator_Adaptor, QString &>(&QRegExpValidator_Adaptor::cbs_fixup_c1330_0, arg1);
    } else {
      QRegExpValidator::fixup(arg1);
    }
  }

  //  [emitter impl] void QRegExpValidator::objectNameChanged(const QString &objectName)
  void emitter_QRegExpValidator_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QRegExpValidator::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QRegExpValidator::regExpChanged(const QRegExp &regExp)
  void emitter_QRegExpValidator_regExpChanged_1981(const QRegExp &regExp)
  {
    emit QRegExpValidator::regExpChanged(regExp);
  }

  //  [adaptor impl] QValidator::State QRegExpValidator::validate(QString &input, int &pos)
  qt_gsi::Converter<QValidator::State>::target_type cbs_validate_c2171_0(QString &input, int &pos) const
  {
    return qt_gsi::CppToQtAdaptor<QValidator::State>(QRegExpValidator::validate(input, pos));
  }

  virtual QValidator::State validate(QString &input, int &pos) const
  {
    if (cb_validate_c2171_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QValidator::State>(cb_validate_c2171_0.issue<QRegExpValidator_Adaptor, qt_gsi::Converter<QValidator::State>::target_type, QString &, int &>(&QRegExpValidator_Adaptor::cbs_validate_c2171_0, input, pos)).cref();
    } else {
      return QRegExpValidator::validate(input, pos);
    }
  }

  //  [adaptor impl] void QRegExpValidator::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QRegExpValidator::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QRegExpValidator_Adaptor, QChildEvent *>(&QRegExpValidator_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QRegExpValidator::childEvent(event);
    }
  }

  //  [adaptor impl] void QRegExpValidator::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QRegExpValidator::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QRegExpValidator_Adaptor, QEvent *>(&QRegExpValidator_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QRegExpValidator::customEvent(event);
    }
  }

  //  [adaptor impl] void QRegExpValidator::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QRegExpValidator::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QRegExpValidator_Adaptor, const QMetaMethod &>(&QRegExpValidator_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QRegExpValidator::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QRegExpValidator::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QRegExpValidator::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QRegExpValidator_Adaptor, QTimerEvent *>(&QRegExpValidator_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QRegExpValidator::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_fixup_c1330_0;
  gsi::Callback cb_validate_c2171_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QRegExpValidator_Adaptor::~QRegExpValidator_Adaptor() { }

//  Constructor QRegExpValidator::QRegExpValidator(QObject *parent) (adaptor class)

static void _init_ctor_QRegExpValidator_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QRegExpValidator_Adaptor> ();
}

static void _call_ctor_QRegExpValidator_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QRegExpValidator_Adaptor *> (new QRegExpValidator_Adaptor (arg1));
}


//  Constructor QRegExpValidator::QRegExpValidator(const QRegExp &rx, QObject *parent) (adaptor class)

static void _init_ctor_QRegExpValidator_Adaptor_3175 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rx");
  decl->add_arg<const QRegExp & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QRegExpValidator_Adaptor> ();
}

static void _call_ctor_QRegExpValidator_Adaptor_3175 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegExp &arg1 = gsi::arg_reader<const QRegExp & >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QRegExpValidator_Adaptor *> (new QRegExpValidator_Adaptor (arg1, arg2));
}


// emitter void QRegExpValidator::changed()

static void _init_emitter_changed_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_changed_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QRegExpValidator_Adaptor *)cls)->emitter_QRegExpValidator_changed_0 ();
}


// void QRegExpValidator::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRegExpValidator_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QRegExpValidator_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QRegExpValidator::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRegExpValidator_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QRegExpValidator_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QRegExpValidator::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QRegExpValidator_Adaptor *)cls)->emitter_QRegExpValidator_destroyed_1302 (arg1);
}


// void QRegExpValidator::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRegExpValidator_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QRegExpValidator_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QRegExpValidator::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QRegExpValidator_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QRegExpValidator_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QRegExpValidator::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QRegExpValidator_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QRegExpValidator_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QRegExpValidator::fixup(QString &)

static void _init_cbs_fixup_c1330_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fixup_c1330_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString &arg1 = args.read<QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRegExpValidator_Adaptor *)cls)->cbs_fixup_c1330_0 (arg1);
}

static void _set_callback_cbs_fixup_c1330_0 (void *cls, const gsi::Callback &cb)
{
  ((QRegExpValidator_Adaptor *)cls)->cb_fixup_c1330_0 = cb;
}


// exposed bool QRegExpValidator::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QRegExpValidator_Adaptor *)cls)->fp_QRegExpValidator_isSignalConnected_c2394 (arg1));
}


// emitter void QRegExpValidator::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QRegExpValidator_Adaptor *)cls)->emitter_QRegExpValidator_objectNameChanged_4567 (arg1);
}


// exposed int QRegExpValidator::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QRegExpValidator_Adaptor *)cls)->fp_QRegExpValidator_receivers_c1731 (arg1));
}


// emitter void QRegExpValidator::regExpChanged(const QRegExp &regExp)

static void _init_emitter_regExpChanged_1981 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("regExp");
  decl->add_arg<const QRegExp & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_regExpChanged_1981 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegExp &arg1 = gsi::arg_reader<const QRegExp & >() (args, heap);
  ((QRegExpValidator_Adaptor *)cls)->emitter_QRegExpValidator_regExpChanged_1981 (arg1);
}


// exposed QObject *QRegExpValidator::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QRegExpValidator_Adaptor *)cls)->fp_QRegExpValidator_sender_c0 ());
}


// exposed int QRegExpValidator::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRegExpValidator_Adaptor *)cls)->fp_QRegExpValidator_senderSignalIndex_c0 ());
}


// void QRegExpValidator::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRegExpValidator_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QRegExpValidator_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// QValidator::State QRegExpValidator::validate(QString &input, int &pos)

static void _init_cbs_validate_c2171_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("input");
  decl->add_arg<QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pos");
  decl->add_arg<int & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QValidator::State>::target_type > ();
}

static void _call_cbs_validate_c2171_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString &arg1 = args.read<QString & > (heap);
  int &arg2 = args.read<int & > (heap);
  ret.write<qt_gsi::Converter<QValidator::State>::target_type > ((qt_gsi::Converter<QValidator::State>::target_type)((QRegExpValidator_Adaptor *)cls)->cbs_validate_c2171_0 (arg1, arg2));
}

static void _set_callback_cbs_validate_c2171_0 (void *cls, const gsi::Callback &cb)
{
  ((QRegExpValidator_Adaptor *)cls)->cb_validate_c2171_0 = cb;
}


namespace gsi
{

gsi::Class<QRegExpValidator> &qtdecl_QRegExpValidator ();

static gsi::Methods methods_QRegExpValidator_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRegExpValidator::QRegExpValidator(QObject *parent)\nThis method creates an object of class QRegExpValidator.", &_init_ctor_QRegExpValidator_Adaptor_1302, &_call_ctor_QRegExpValidator_Adaptor_1302);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRegExpValidator::QRegExpValidator(const QRegExp &rx, QObject *parent)\nThis method creates an object of class QRegExpValidator.", &_init_ctor_QRegExpValidator_Adaptor_3175, &_call_ctor_QRegExpValidator_Adaptor_3175);
  methods += new qt_gsi::GenericMethod ("emit_changed", "@brief Emitter for signal void QRegExpValidator::changed()\nCall this method to emit this signal.", false, &_init_emitter_changed_0, &_call_emitter_changed_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QRegExpValidator::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QRegExpValidator::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QRegExpValidator::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QRegExpValidator::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QRegExpValidator::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QRegExpValidator::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("fixup", "@brief Virtual method void QRegExpValidator::fixup(QString &)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_fixup_c1330_0, &_call_cbs_fixup_c1330_0);
  methods += new qt_gsi::GenericMethod ("fixup", "@hide", true, &_init_cbs_fixup_c1330_0, &_call_cbs_fixup_c1330_0, &_set_callback_cbs_fixup_c1330_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QRegExpValidator::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QRegExpValidator::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QRegExpValidator::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("emit_regExpChanged", "@brief Emitter for signal void QRegExpValidator::regExpChanged(const QRegExp &regExp)\nCall this method to emit this signal.", false, &_init_emitter_regExpChanged_1981, &_call_emitter_regExpChanged_1981);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QRegExpValidator::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QRegExpValidator::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QRegExpValidator::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("validate", "@brief Virtual method QValidator::State QRegExpValidator::validate(QString &input, int &pos)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_validate_c2171_0, &_call_cbs_validate_c2171_0);
  methods += new qt_gsi::GenericMethod ("validate", "@hide", true, &_init_cbs_validate_c2171_0, &_call_cbs_validate_c2171_0, &_set_callback_cbs_validate_c2171_0);
  return methods;
}

gsi::Class<QRegExpValidator_Adaptor> decl_QRegExpValidator_Adaptor (qtdecl_QRegExpValidator (), "QtGui", "QRegExpValidator",
  methods_QRegExpValidator_Adaptor (),
  "@qt\n@brief Binding of QRegExpValidator");

}

