
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSqlQueryModel.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QSqlQueryModel>
#include <QChildEvent>
#include <QDataStream>
#include <QEvent>
#include <QMimeData>
#include <QModelIndex>
#include <QObject>
#include <QSize>
#include <QSqlDatabase>
#include <QSqlError>
#include <QSqlQuery>
#include <QSqlRecord>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtSqlCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSqlQueryModel

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSqlQueryModel::staticMetaObject);
}


// bool QSqlQueryModel::canFetchMore(const QModelIndex &parent)


static void _init_f_canFetchMore_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_canFetchMore_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QSqlQueryModel *)cls)->canFetchMore (arg1));
}


// void QSqlQueryModel::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel *)cls)->clear ();
}


// int QSqlQueryModel::columnCount(const QModelIndex &parent)


static void _init_f_columnCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_columnCount_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<int > ((int)((QSqlQueryModel *)cls)->columnCount (arg1));
}


// QVariant QSqlQueryModel::data(const QModelIndex &item, int role)


static void _init_f_data_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_data_c3054 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::DisplayRole, heap);
  ret.write<QVariant > ((QVariant)((QSqlQueryModel *)cls)->data (arg1, arg2));
}


// void QSqlQueryModel::fetchMore(const QModelIndex &parent)


static void _init_f_fetchMore_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_fetchMore_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel *)cls)->fetchMore (arg1);
}


// QVariant QSqlQueryModel::headerData(int section, Qt::Orientation orientation, int role)


static void _init_f_headerData_c3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_f_headerData_c3231 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::DisplayRole, heap);
  ret.write<QVariant > ((QVariant)((QSqlQueryModel *)cls)->headerData (arg1, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg2).cref(), arg3));
}


// bool QSqlQueryModel::insertColumns(int column, int count, const QModelIndex &parent)


static void _init_f_insertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_insertColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QSqlQueryModel *)cls)->insertColumns (arg1, arg2, arg3));
}


// QSqlError QSqlQueryModel::lastError()


static void _init_f_lastError_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSqlError > ();
}

static void _call_f_lastError_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSqlError > ((QSqlError)((QSqlQueryModel *)cls)->lastError ());
}


// QSqlQuery QSqlQueryModel::query()


static void _init_f_query_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSqlQuery > ();
}

static void _call_f_query_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSqlQuery > ((QSqlQuery)((QSqlQueryModel *)cls)->query ());
}


// QSqlRecord QSqlQueryModel::record(int row)


static void _init_f_record_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QSqlRecord > ();
}

static void _call_f_record_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QSqlRecord > ((QSqlRecord)((QSqlQueryModel *)cls)->record (arg1));
}


// QSqlRecord QSqlQueryModel::record()


static void _init_f_record_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSqlRecord > ();
}

static void _call_f_record_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSqlRecord > ((QSqlRecord)((QSqlQueryModel *)cls)->record ());
}


// bool QSqlQueryModel::removeColumns(int column, int count, const QModelIndex &parent)


static void _init_f_removeColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_removeColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QSqlQueryModel *)cls)->removeColumns (arg1, arg2, arg3));
}


// int QSqlQueryModel::rowCount(const QModelIndex &parent)


static void _init_f_rowCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_rowCount_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<int > ((int)((QSqlQueryModel *)cls)->rowCount (arg1));
}


// bool QSqlQueryModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)


static void _init_f_setHeaderData_5242 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("role", true, "Qt::EditRole");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_setHeaderData_5242 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  const QVariant &arg3 = gsi::arg_reader<const QVariant & >() (args, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::EditRole, heap);
  ret.write<bool > ((bool)((QSqlQueryModel *)cls)->setHeaderData (arg1, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg2).cref(), arg3, arg4));
}


// void QSqlQueryModel::setQuery(const QSqlQuery &query)


static void _init_f_setQuery_2232 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const QSqlQuery & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setQuery_2232 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSqlQuery &arg1 = gsi::arg_reader<const QSqlQuery & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel *)cls)->setQuery (arg1);
}


// void QSqlQueryModel::setQuery(const QString &query, const QSqlDatabase &db)


static void _init_f_setQuery_4404 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("db", true, "QSqlDatabase()");
  decl->add_arg<const QSqlDatabase & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setQuery_4404 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QSqlDatabase &arg2 = args ? gsi::arg_reader<const QSqlDatabase & >() (args, heap) : gsi::arg_maker<const QSqlDatabase & >() (QSqlDatabase(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel *)cls)->setQuery (arg1, arg2);
}


// static QString QSqlQueryModel::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QSqlQueryModel::tr (arg1, arg2));
}


// static QString QSqlQueryModel::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QSqlQueryModel::tr (arg1, arg2, arg3));
}


// static QString QSqlQueryModel::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QSqlQueryModel::trUtf8 (arg1, arg2));
}


// static QString QSqlQueryModel::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QSqlQueryModel::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QSqlQueryModel () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("canFetchMore", "@brief Method bool QSqlQueryModel::canFetchMore(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::canFetchMore", true, &_init_f_canFetchMore_c2395, &_call_f_canFetchMore_c2395);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QSqlQueryModel::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("columnCount", "@brief Method int QSqlQueryModel::columnCount(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::columnCount", true, &_init_f_columnCount_c2395, &_call_f_columnCount_c2395);
  methods += new qt_gsi::GenericMethod ("data", "@brief Method QVariant QSqlQueryModel::data(const QModelIndex &item, int role)\nThis is a reimplementation of QAbstractItemModel::data", true, &_init_f_data_c3054, &_call_f_data_c3054);
  methods += new qt_gsi::GenericMethod ("fetchMore", "@brief Method void QSqlQueryModel::fetchMore(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::fetchMore", false, &_init_f_fetchMore_2395, &_call_f_fetchMore_2395);
  methods += new qt_gsi::GenericMethod ("headerData", "@brief Method QVariant QSqlQueryModel::headerData(int section, Qt::Orientation orientation, int role)\nThis is a reimplementation of QAbstractItemModel::headerData", true, &_init_f_headerData_c3231, &_call_f_headerData_c3231);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@brief Method bool QSqlQueryModel::insertColumns(int column, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::insertColumns", false, &_init_f_insertColumns_3713, &_call_f_insertColumns_3713);
  methods += new qt_gsi::GenericMethod ("lastError", "@brief Method QSqlError QSqlQueryModel::lastError()\n", true, &_init_f_lastError_c0, &_call_f_lastError_c0);
  methods += new qt_gsi::GenericMethod (":query", "@brief Method QSqlQuery QSqlQueryModel::query()\n", true, &_init_f_query_c0, &_call_f_query_c0);
  methods += new qt_gsi::GenericMethod ("record", "@brief Method QSqlRecord QSqlQueryModel::record(int row)\n", true, &_init_f_record_c767, &_call_f_record_c767);
  methods += new qt_gsi::GenericMethod ("record", "@brief Method QSqlRecord QSqlQueryModel::record()\n", true, &_init_f_record_c0, &_call_f_record_c0);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@brief Method bool QSqlQueryModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::removeColumns", false, &_init_f_removeColumns_3713, &_call_f_removeColumns_3713);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Method int QSqlQueryModel::rowCount(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::rowCount", true, &_init_f_rowCount_c2395, &_call_f_rowCount_c2395);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@brief Method bool QSqlQueryModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)\nThis is a reimplementation of QAbstractItemModel::setHeaderData", false, &_init_f_setHeaderData_5242, &_call_f_setHeaderData_5242);
  methods += new qt_gsi::GenericMethod ("setQuery|query=", "@brief Method void QSqlQueryModel::setQuery(const QSqlQuery &query)\n", false, &_init_f_setQuery_2232, &_call_f_setQuery_2232);
  methods += new qt_gsi::GenericMethod ("setQuery", "@brief Method void QSqlQueryModel::setQuery(const QString &query, const QSqlDatabase &db)\n", false, &_init_f_setQuery_4404, &_call_f_setQuery_4404);
  methods += gsi::qt_signal<const QModelIndex &, const QModelIndex & > ("dataChanged(const QModelIndex &, const QModelIndex &)", "dataChanged", gsi::arg("topLeft"), gsi::arg("bottomRight"), "@brief Signal declaration for QSqlQueryModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QSqlQueryModel::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::Orientation>::target_type &, int, int > ("headerDataChanged(Qt::Orientation, int, int)", "headerDataChanged", gsi::arg("orientation"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSqlQueryModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("layoutAboutToBeChanged()", "layoutAboutToBeChanged", "@brief Signal declaration for QSqlQueryModel::layoutAboutToBeChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("layoutChanged()", "layoutChanged", "@brief Signal declaration for QSqlQueryModel::layoutChanged()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSqlQueryModel::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSqlQueryModel::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSqlQueryModel::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSqlQueryModel::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QAbstractTableModel> &qtdecl_QAbstractTableModel ();

qt_gsi::QtNativeClass<QSqlQueryModel> decl_QSqlQueryModel (qtdecl_QAbstractTableModel (), "QtSql", "QSqlQueryModel_Native",
  methods_QSqlQueryModel (),
  "@hide\n@alias QSqlQueryModel");

GSI_QTSQL_PUBLIC gsi::Class<QSqlQueryModel> &qtdecl_QSqlQueryModel () { return decl_QSqlQueryModel; }

}


class QSqlQueryModel_Adaptor : public QSqlQueryModel, public qt_gsi::QtObjectBase
{
public:

  virtual ~QSqlQueryModel_Adaptor();

  //  [adaptor ctor] QSqlQueryModel::QSqlQueryModel(QObject *parent)
  QSqlQueryModel_Adaptor() : QSqlQueryModel()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSqlQueryModel::QSqlQueryModel(QObject *parent)
  QSqlQueryModel_Adaptor(QObject *parent) : QSqlQueryModel(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QSqlQueryModel::beginInsertColumns(const QModelIndex &parent, int first, int last)
  void fp_QSqlQueryModel_beginInsertColumns_3713 (const QModelIndex &parent, int first, int last) {
    QSqlQueryModel::beginInsertColumns(parent, first, last);
  }

  //  [expose] void QSqlQueryModel::beginInsertRows(const QModelIndex &parent, int first, int last)
  void fp_QSqlQueryModel_beginInsertRows_3713 (const QModelIndex &parent, int first, int last) {
    QSqlQueryModel::beginInsertRows(parent, first, last);
  }

  //  [expose] bool QSqlQueryModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)
  bool fp_QSqlQueryModel_beginMoveColumns_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn) {
    return QSqlQueryModel::beginMoveColumns(sourceParent, sourceFirst, sourceLast, destinationParent, destinationColumn);
  }

  //  [expose] bool QSqlQueryModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)
  bool fp_QSqlQueryModel_beginMoveRows_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow) {
    return QSqlQueryModel::beginMoveRows(sourceParent, sourceFirst, sourceLast, destinationParent, destinationRow);
  }

  //  [expose] void QSqlQueryModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)
  void fp_QSqlQueryModel_beginRemoveColumns_3713 (const QModelIndex &parent, int first, int last) {
    QSqlQueryModel::beginRemoveColumns(parent, first, last);
  }

  //  [expose] void QSqlQueryModel::beginRemoveRows(const QModelIndex &parent, int first, int last)
  void fp_QSqlQueryModel_beginRemoveRows_3713 (const QModelIndex &parent, int first, int last) {
    QSqlQueryModel::beginRemoveRows(parent, first, last);
  }

  //  [expose] void QSqlQueryModel::beginResetModel()
  void fp_QSqlQueryModel_beginResetModel_0 () {
    QSqlQueryModel::beginResetModel();
  }

  //  [expose] void QSqlQueryModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)
  void fp_QSqlQueryModel_changePersistentIndex_4682 (const QModelIndex &from, const QModelIndex &to) {
    QSqlQueryModel::changePersistentIndex(from, to);
  }

  //  [expose] void QSqlQueryModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)
  void fp_QSqlQueryModel_changePersistentIndexList_5912 (const QList<QModelIndex> &from, const QList<QModelIndex> &to) {
    QSqlQueryModel::changePersistentIndexList(from, to);
  }

  //  [expose] QModelIndex QSqlQueryModel::createIndex(int row, int column, void *data)
  QModelIndex fp_QSqlQueryModel_createIndex_c2374 (int row, int column, void *data) const {
    return QSqlQueryModel::createIndex(row, column, data);
  }

  //  [expose] QModelIndex QSqlQueryModel::createIndex(int row, int column, int id)
  QModelIndex fp_QSqlQueryModel_createIndex_c2085 (int row, int column, int id) const {
    return QSqlQueryModel::createIndex(row, column, id);
  }

  //  [expose] QModelIndex QSqlQueryModel::createIndex(int row, int column, quint32 id)
  QModelIndex fp_QSqlQueryModel_createIndex_c2416 (int row, int column, quint32 id) const {
    return QSqlQueryModel::createIndex(row, column, id);
  }

  //  [expose] bool QSqlQueryModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)
  bool fp_QSqlQueryModel_decodeData_5302 (int row, int column, const QModelIndex &parent, QDataStream &stream) {
    return QSqlQueryModel::decodeData(row, column, parent, stream);
  }

  //  [expose] void QSqlQueryModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)
  void fp_QSqlQueryModel_encodeData_c4599 (const QList<QModelIndex> &indexes, QDataStream &stream) const {
    QSqlQueryModel::encodeData(indexes, stream);
  }

  //  [expose] void QSqlQueryModel::endInsertColumns()
  void fp_QSqlQueryModel_endInsertColumns_0 () {
    QSqlQueryModel::endInsertColumns();
  }

  //  [expose] void QSqlQueryModel::endInsertRows()
  void fp_QSqlQueryModel_endInsertRows_0 () {
    QSqlQueryModel::endInsertRows();
  }

  //  [expose] void QSqlQueryModel::endMoveColumns()
  void fp_QSqlQueryModel_endMoveColumns_0 () {
    QSqlQueryModel::endMoveColumns();
  }

  //  [expose] void QSqlQueryModel::endMoveRows()
  void fp_QSqlQueryModel_endMoveRows_0 () {
    QSqlQueryModel::endMoveRows();
  }

  //  [expose] void QSqlQueryModel::endRemoveColumns()
  void fp_QSqlQueryModel_endRemoveColumns_0 () {
    QSqlQueryModel::endRemoveColumns();
  }

  //  [expose] void QSqlQueryModel::endRemoveRows()
  void fp_QSqlQueryModel_endRemoveRows_0 () {
    QSqlQueryModel::endRemoveRows();
  }

  //  [expose] void QSqlQueryModel::endResetModel()
  void fp_QSqlQueryModel_endResetModel_0 () {
    QSqlQueryModel::endResetModel();
  }

  //  [expose] QModelIndex QSqlQueryModel::indexInQuery(const QModelIndex &item)
  QModelIndex fp_QSqlQueryModel_indexInQuery_c2395 (const QModelIndex &item) const {
    return QSqlQueryModel::indexInQuery(item);
  }

  //  [expose] QList<QModelIndex> QSqlQueryModel::persistentIndexList()
  QList<QModelIndex> fp_QSqlQueryModel_persistentIndexList_c0 () const {
    return QSqlQueryModel::persistentIndexList();
  }

  //  [expose] int QSqlQueryModel::receivers(const char *signal)
  int fp_QSqlQueryModel_receivers_c1731 (const char *signal) const {
    return QSqlQueryModel::receivers(signal);
  }

  //  [expose] void QSqlQueryModel::reset()
  void fp_QSqlQueryModel_reset_0 () {
    QSqlQueryModel::reset();
  }

  //  [expose] QObject *QSqlQueryModel::sender()
  QObject * fp_QSqlQueryModel_sender_c0 () const {
    return QSqlQueryModel::sender();
  }

  //  [expose] void QSqlQueryModel::setLastError(const QSqlError &error)
  void fp_QSqlQueryModel_setLastError_2220 (const QSqlError &error) {
    QSqlQueryModel::setLastError(error);
  }

  //  [expose] void QSqlQueryModel::setRoleNames(const QHash<int, QByteArray> &roleNames)
  void fp_QSqlQueryModel_setRoleNames_3419 (const QHash<int, QByteArray> &roleNames) {
    QSqlQueryModel::setRoleNames(roleNames);
  }

  //  [adaptor impl] QModelIndex QSqlQueryModel::buddy(const QModelIndex &index)
  QModelIndex cbs_buddy_c2395_0(const QModelIndex &index) const
  {
    return QSqlQueryModel::buddy(index);
  }

  virtual QModelIndex buddy(const QModelIndex &index) const
  {
    if (cb_buddy_c2395_0.can_issue()) {
      return cb_buddy_c2395_0.issue<QSqlQueryModel_Adaptor, QModelIndex, const QModelIndex &>(&QSqlQueryModel_Adaptor::cbs_buddy_c2395_0, index);
    } else {
      return QSqlQueryModel::buddy(index);
    }
  }

  //  [adaptor impl] bool QSqlQueryModel::canFetchMore(const QModelIndex &parent)
  bool cbs_canFetchMore_c2395_1(const QModelIndex &parent) const
  {
    return QSqlQueryModel::canFetchMore(parent);
  }

  virtual bool canFetchMore(const QModelIndex &parent) const
  {
    if (cb_canFetchMore_c2395_1.can_issue()) {
      return cb_canFetchMore_c2395_1.issue<QSqlQueryModel_Adaptor, bool, const QModelIndex &>(&QSqlQueryModel_Adaptor::cbs_canFetchMore_c2395_1, parent);
    } else {
      return QSqlQueryModel::canFetchMore(parent);
    }
  }

  //  [adaptor impl] void QSqlQueryModel::clear()
  void cbs_clear_0_0()
  {
    QSqlQueryModel::clear();
  }

  virtual void clear()
  {
    if (cb_clear_0_0.can_issue()) {
      cb_clear_0_0.issue<QSqlQueryModel_Adaptor>(&QSqlQueryModel_Adaptor::cbs_clear_0_0);
    } else {
      QSqlQueryModel::clear();
    }
  }

  //  [adaptor impl] int QSqlQueryModel::columnCount(const QModelIndex &parent)
  int cbs_columnCount_c2395_1(const QModelIndex &parent) const
  {
    return QSqlQueryModel::columnCount(parent);
  }

  virtual int columnCount(const QModelIndex &parent) const
  {
    if (cb_columnCount_c2395_1.can_issue()) {
      return cb_columnCount_c2395_1.issue<QSqlQueryModel_Adaptor, int, const QModelIndex &>(&QSqlQueryModel_Adaptor::cbs_columnCount_c2395_1, parent);
    } else {
      return QSqlQueryModel::columnCount(parent);
    }
  }

  //  [adaptor impl] QVariant QSqlQueryModel::data(const QModelIndex &item, int role)
  QVariant cbs_data_c3054_1(const QModelIndex &item, int role) const
  {
    return QSqlQueryModel::data(item, role);
  }

  virtual QVariant data(const QModelIndex &item, int role) const
  {
    if (cb_data_c3054_1.can_issue()) {
      return cb_data_c3054_1.issue<QSqlQueryModel_Adaptor, QVariant, const QModelIndex &, int>(&QSqlQueryModel_Adaptor::cbs_data_c3054_1, item, role);
    } else {
      return QSqlQueryModel::data(item, role);
    }
  }

  //  [adaptor impl] bool QSqlQueryModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_dropMimeData_7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent)
  {
    return QSqlQueryModel::dropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  {
    if (cb_dropMimeData_7425_0.can_issue()) {
      return cb_dropMimeData_7425_0.issue<QSqlQueryModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QSqlQueryModel_Adaptor::cbs_dropMimeData_7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QSqlQueryModel::dropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QSqlQueryModel::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QSqlQueryModel::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QSqlQueryModel_Adaptor, bool, QEvent *>(&QSqlQueryModel_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QSqlQueryModel::event(arg1);
    }
  }

  //  [adaptor impl] bool QSqlQueryModel::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QSqlQueryModel::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QSqlQueryModel_Adaptor, bool, QObject *, QEvent *>(&QSqlQueryModel_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QSqlQueryModel::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QSqlQueryModel::fetchMore(const QModelIndex &parent)
  void cbs_fetchMore_2395_1(const QModelIndex &parent)
  {
    QSqlQueryModel::fetchMore(parent);
  }

  virtual void fetchMore(const QModelIndex &parent)
  {
    if (cb_fetchMore_2395_1.can_issue()) {
      cb_fetchMore_2395_1.issue<QSqlQueryModel_Adaptor, const QModelIndex &>(&QSqlQueryModel_Adaptor::cbs_fetchMore_2395_1, parent);
    } else {
      QSqlQueryModel::fetchMore(parent);
    }
  }

  //  [adaptor impl] QFlags<Qt::ItemFlag> QSqlQueryModel::flags(const QModelIndex &index)
  QFlags<Qt::ItemFlag> cbs_flags_c2395_0(const QModelIndex &index) const
  {
    return QSqlQueryModel::flags(index);
  }

  virtual QFlags<Qt::ItemFlag> flags(const QModelIndex &index) const
  {
    if (cb_flags_c2395_0.can_issue()) {
      return cb_flags_c2395_0.issue<QSqlQueryModel_Adaptor, QFlags<Qt::ItemFlag>, const QModelIndex &>(&QSqlQueryModel_Adaptor::cbs_flags_c2395_0, index);
    } else {
      return QSqlQueryModel::flags(index);
    }
  }

  //  [adaptor impl] QVariant QSqlQueryModel::headerData(int section, Qt::Orientation orientation, int role)
  QVariant cbs_headerData_c3231_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, int role) const
  {
    return QSqlQueryModel::headerData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), role);
  }

  virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const
  {
    if (cb_headerData_c3231_1.can_issue()) {
      return cb_headerData_c3231_1.issue<QSqlQueryModel_Adaptor, QVariant, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, int>(&QSqlQueryModel_Adaptor::cbs_headerData_c3231_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), role);
    } else {
      return QSqlQueryModel::headerData(section, orientation, role);
    }
  }

  //  [adaptor impl] QModelIndex QSqlQueryModel::index(int row, int column, const QModelIndex &parent)
  QModelIndex cbs_index_c3713_1(int row, int column, const QModelIndex &parent) const
  {
    return QSqlQueryModel::index(row, column, parent);
  }

  virtual QModelIndex index(int row, int column, const QModelIndex &parent) const
  {
    if (cb_index_c3713_1.can_issue()) {
      return cb_index_c3713_1.issue<QSqlQueryModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QSqlQueryModel_Adaptor::cbs_index_c3713_1, row, column, parent);
    } else {
      return QSqlQueryModel::index(row, column, parent);
    }
  }

  //  [adaptor impl] bool QSqlQueryModel::insertColumns(int column, int count, const QModelIndex &parent)
  bool cbs_insertColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QSqlQueryModel::insertColumns(column, count, parent);
  }

  virtual bool insertColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_insertColumns_3713_1.can_issue()) {
      return cb_insertColumns_3713_1.issue<QSqlQueryModel_Adaptor, bool, int, int, const QModelIndex &>(&QSqlQueryModel_Adaptor::cbs_insertColumns_3713_1, column, count, parent);
    } else {
      return QSqlQueryModel::insertColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QSqlQueryModel::insertRows(int row, int count, const QModelIndex &parent)
  bool cbs_insertRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QSqlQueryModel::insertRows(row, count, parent);
  }

  virtual bool insertRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_insertRows_3713_1.can_issue()) {
      return cb_insertRows_3713_1.issue<QSqlQueryModel_Adaptor, bool, int, int, const QModelIndex &>(&QSqlQueryModel_Adaptor::cbs_insertRows_3713_1, row, count, parent);
    } else {
      return QSqlQueryModel::insertRows(row, count, parent);
    }
  }

  //  [adaptor impl] QMap<int, QVariant> QSqlQueryModel::itemData(const QModelIndex &index)
  QMap<int, QVariant> cbs_itemData_c2395_0(const QModelIndex &index) const
  {
    return QSqlQueryModel::itemData(index);
  }

  virtual QMap<int, QVariant> itemData(const QModelIndex &index) const
  {
    if (cb_itemData_c2395_0.can_issue()) {
      return cb_itemData_c2395_0.issue<QSqlQueryModel_Adaptor, QMap<int, QVariant>, const QModelIndex &>(&QSqlQueryModel_Adaptor::cbs_itemData_c2395_0, index);
    } else {
      return QSqlQueryModel::itemData(index);
    }
  }

  //  [adaptor impl] QList<QModelIndex> QSqlQueryModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)
  QList<QModelIndex> cbs_match_c7932_2(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    return QSqlQueryModel::match(start, role, value, hits, flags);
  }

  virtual QList<QModelIndex> match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    if (cb_match_c7932_2.can_issue()) {
      return cb_match_c7932_2.issue<QSqlQueryModel_Adaptor, QList<QModelIndex>, const QModelIndex &, int, const QVariant &, int, QFlags<Qt::MatchFlag> >(&QSqlQueryModel_Adaptor::cbs_match_c7932_2, start, role, value, hits, flags);
    } else {
      return QSqlQueryModel::match(start, role, value, hits, flags);
    }
  }

  //  [adaptor impl] QMimeData *QSqlQueryModel::mimeData(const QList<QModelIndex> &indexes)
  QMimeData * cbs_mimeData_c3010_0(const QList<QModelIndex> &indexes) const
  {
    return QSqlQueryModel::mimeData(indexes);
  }

  virtual QMimeData * mimeData(const QList<QModelIndex> &indexes) const
  {
    if (cb_mimeData_c3010_0.can_issue()) {
      return cb_mimeData_c3010_0.issue<QSqlQueryModel_Adaptor, QMimeData *, const QList<QModelIndex> &>(&QSqlQueryModel_Adaptor::cbs_mimeData_c3010_0, indexes);
    } else {
      return QSqlQueryModel::mimeData(indexes);
    }
  }

  //  [adaptor impl] QStringList QSqlQueryModel::mimeTypes()
  QStringList cbs_mimeTypes_c0_0() const
  {
    return QSqlQueryModel::mimeTypes();
  }

  virtual QStringList mimeTypes() const
  {
    if (cb_mimeTypes_c0_0.can_issue()) {
      return cb_mimeTypes_c0_0.issue<QSqlQueryModel_Adaptor, QStringList>(&QSqlQueryModel_Adaptor::cbs_mimeTypes_c0_0);
    } else {
      return QSqlQueryModel::mimeTypes();
    }
  }

  //  [adaptor impl] bool QSqlQueryModel::removeColumns(int column, int count, const QModelIndex &parent)
  bool cbs_removeColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QSqlQueryModel::removeColumns(column, count, parent);
  }

  virtual bool removeColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_removeColumns_3713_1.can_issue()) {
      return cb_removeColumns_3713_1.issue<QSqlQueryModel_Adaptor, bool, int, int, const QModelIndex &>(&QSqlQueryModel_Adaptor::cbs_removeColumns_3713_1, column, count, parent);
    } else {
      return QSqlQueryModel::removeColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QSqlQueryModel::removeRows(int row, int count, const QModelIndex &parent)
  bool cbs_removeRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QSqlQueryModel::removeRows(row, count, parent);
  }

  virtual bool removeRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_removeRows_3713_1.can_issue()) {
      return cb_removeRows_3713_1.issue<QSqlQueryModel_Adaptor, bool, int, int, const QModelIndex &>(&QSqlQueryModel_Adaptor::cbs_removeRows_3713_1, row, count, parent);
    } else {
      return QSqlQueryModel::removeRows(row, count, parent);
    }
  }

  //  [adaptor impl] void QSqlQueryModel::revert()
  void cbs_revert_0_0()
  {
    QSqlQueryModel::revert();
  }

  virtual void revert()
  {
    if (cb_revert_0_0.can_issue()) {
      cb_revert_0_0.issue<QSqlQueryModel_Adaptor>(&QSqlQueryModel_Adaptor::cbs_revert_0_0);
    } else {
      QSqlQueryModel::revert();
    }
  }

  //  [adaptor impl] int QSqlQueryModel::rowCount(const QModelIndex &parent)
  int cbs_rowCount_c2395_1(const QModelIndex &parent) const
  {
    return QSqlQueryModel::rowCount(parent);
  }

  virtual int rowCount(const QModelIndex &parent) const
  {
    if (cb_rowCount_c2395_1.can_issue()) {
      return cb_rowCount_c2395_1.issue<QSqlQueryModel_Adaptor, int, const QModelIndex &>(&QSqlQueryModel_Adaptor::cbs_rowCount_c2395_1, parent);
    } else {
      return QSqlQueryModel::rowCount(parent);
    }
  }

  //  [adaptor impl] bool QSqlQueryModel::setData(const QModelIndex &index, const QVariant &value, int role)
  bool cbs_setData_5065_1(const QModelIndex &index, const QVariant &value, int role)
  {
    return QSqlQueryModel::setData(index, value, role);
  }

  virtual bool setData(const QModelIndex &index, const QVariant &value, int role)
  {
    if (cb_setData_5065_1.can_issue()) {
      return cb_setData_5065_1.issue<QSqlQueryModel_Adaptor, bool, const QModelIndex &, const QVariant &, int>(&QSqlQueryModel_Adaptor::cbs_setData_5065_1, index, value, role);
    } else {
      return QSqlQueryModel::setData(index, value, role);
    }
  }

  //  [adaptor impl] bool QSqlQueryModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  bool cbs_setHeaderData_5242_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, const QVariant &value, int role)
  {
    return QSqlQueryModel::setHeaderData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), value, role);
  }

  virtual bool setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  {
    if (cb_setHeaderData_5242_1.can_issue()) {
      return cb_setHeaderData_5242_1.issue<QSqlQueryModel_Adaptor, bool, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, const QVariant &, int>(&QSqlQueryModel_Adaptor::cbs_setHeaderData_5242_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), value, role);
    } else {
      return QSqlQueryModel::setHeaderData(section, orientation, value, role);
    }
  }

  //  [adaptor impl] bool QSqlQueryModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)
  bool cbs_setItemData_5414_0(const QModelIndex &index, const QMap<int, QVariant> &roles)
  {
    return QSqlQueryModel::setItemData(index, roles);
  }

  virtual bool setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)
  {
    if (cb_setItemData_5414_0.can_issue()) {
      return cb_setItemData_5414_0.issue<QSqlQueryModel_Adaptor, bool, const QModelIndex &, const QMap<int, QVariant> &>(&QSqlQueryModel_Adaptor::cbs_setItemData_5414_0, index, roles);
    } else {
      return QSqlQueryModel::setItemData(index, roles);
    }
  }

  //  [adaptor impl] void QSqlQueryModel::sort(int column, Qt::SortOrder order)
  void cbs_sort_2340_1(int column, const qt_gsi::Converter<Qt::SortOrder>::target_type & order)
  {
    QSqlQueryModel::sort(column, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(order).cref());
  }

  virtual void sort(int column, Qt::SortOrder order)
  {
    if (cb_sort_2340_1.can_issue()) {
      cb_sort_2340_1.issue<QSqlQueryModel_Adaptor, int, const qt_gsi::Converter<Qt::SortOrder>::target_type &>(&QSqlQueryModel_Adaptor::cbs_sort_2340_1, column, qt_gsi::CppToQtAdaptor<Qt::SortOrder>(order));
    } else {
      QSqlQueryModel::sort(column, order);
    }
  }

  //  [adaptor impl] QSize QSqlQueryModel::span(const QModelIndex &index)
  QSize cbs_span_c2395_0(const QModelIndex &index) const
  {
    return QSqlQueryModel::span(index);
  }

  virtual QSize span(const QModelIndex &index) const
  {
    if (cb_span_c2395_0.can_issue()) {
      return cb_span_c2395_0.issue<QSqlQueryModel_Adaptor, QSize, const QModelIndex &>(&QSqlQueryModel_Adaptor::cbs_span_c2395_0, index);
    } else {
      return QSqlQueryModel::span(index);
    }
  }

  //  [adaptor impl] bool QSqlQueryModel::submit()
  bool cbs_submit_0_0()
  {
    return QSqlQueryModel::submit();
  }

  virtual bool submit()
  {
    if (cb_submit_0_0.can_issue()) {
      return cb_submit_0_0.issue<QSqlQueryModel_Adaptor, bool>(&QSqlQueryModel_Adaptor::cbs_submit_0_0);
    } else {
      return QSqlQueryModel::submit();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QSqlQueryModel::supportedDropActions()
  QFlags<Qt::DropAction> cbs_supportedDropActions_c0_0() const
  {
    return QSqlQueryModel::supportedDropActions();
  }

  virtual QFlags<Qt::DropAction> supportedDropActions() const
  {
    if (cb_supportedDropActions_c0_0.can_issue()) {
      return cb_supportedDropActions_c0_0.issue<QSqlQueryModel_Adaptor, QFlags<Qt::DropAction> >(&QSqlQueryModel_Adaptor::cbs_supportedDropActions_c0_0);
    } else {
      return QSqlQueryModel::supportedDropActions();
    }
  }

  //  [adaptor impl] void QSqlQueryModel::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QSqlQueryModel::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QSqlQueryModel_Adaptor, QChildEvent *>(&QSqlQueryModel_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QSqlQueryModel::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QSqlQueryModel::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QSqlQueryModel::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QSqlQueryModel_Adaptor, QEvent *>(&QSqlQueryModel_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QSqlQueryModel::customEvent(arg1);
    }
  }

  //  [emitter impl] void QSqlQueryModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  void emitter_QSqlQueryModel_dataChanged_4682(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  {
    emit QSqlQueryModel::dataChanged(topLeft, bottomRight);
  }

  //  [emitter impl] void QSqlQueryModel::destroyed(QObject *)
  void emitter_QSqlQueryModel_destroyed_1302(QObject *arg1)
  {
    emit QSqlQueryModel::destroyed(arg1);
  }

  //  [adaptor impl] void QSqlQueryModel::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QSqlQueryModel::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QSqlQueryModel_Adaptor, const char *>(&QSqlQueryModel_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QSqlQueryModel::disconnectNotify(signal);
    }
  }

  //  [emitter impl] void QSqlQueryModel::headerDataChanged(Qt::Orientation orientation, int first, int last)
  void emitter_QSqlQueryModel_headerDataChanged_3231(Qt::Orientation orientation, int first, int last)
  {
    emit QSqlQueryModel::headerDataChanged(orientation, first, last);
  }

  //  [emitter impl] void QSqlQueryModel::layoutAboutToBeChanged()
  void emitter_QSqlQueryModel_layoutAboutToBeChanged_0()
  {
    emit QSqlQueryModel::layoutAboutToBeChanged();
  }

  //  [emitter impl] void QSqlQueryModel::layoutChanged()
  void emitter_QSqlQueryModel_layoutChanged_0()
  {
    emit QSqlQueryModel::layoutChanged();
  }

  //  [adaptor impl] void QSqlQueryModel::queryChange()
  void cbs_queryChange_0_0()
  {
    QSqlQueryModel::queryChange();
  }

  virtual void queryChange()
  {
    if (cb_queryChange_0_0.can_issue()) {
      cb_queryChange_0_0.issue<QSqlQueryModel_Adaptor>(&QSqlQueryModel_Adaptor::cbs_queryChange_0_0);
    } else {
      QSqlQueryModel::queryChange();
    }
  }

  //  [adaptor impl] void QSqlQueryModel::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QSqlQueryModel::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QSqlQueryModel_Adaptor, QTimerEvent *>(&QSqlQueryModel_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QSqlQueryModel::timerEvent(arg1);
    }
  }

  gsi::Callback cb_buddy_c2395_0;
  gsi::Callback cb_canFetchMore_c2395_1;
  gsi::Callback cb_clear_0_0;
  gsi::Callback cb_columnCount_c2395_1;
  gsi::Callback cb_data_c3054_1;
  gsi::Callback cb_dropMimeData_7425_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_fetchMore_2395_1;
  gsi::Callback cb_flags_c2395_0;
  gsi::Callback cb_headerData_c3231_1;
  gsi::Callback cb_index_c3713_1;
  gsi::Callback cb_insertColumns_3713_1;
  gsi::Callback cb_insertRows_3713_1;
  gsi::Callback cb_itemData_c2395_0;
  gsi::Callback cb_match_c7932_2;
  gsi::Callback cb_mimeData_c3010_0;
  gsi::Callback cb_mimeTypes_c0_0;
  gsi::Callback cb_removeColumns_3713_1;
  gsi::Callback cb_removeRows_3713_1;
  gsi::Callback cb_revert_0_0;
  gsi::Callback cb_rowCount_c2395_1;
  gsi::Callback cb_setData_5065_1;
  gsi::Callback cb_setHeaderData_5242_1;
  gsi::Callback cb_setItemData_5414_0;
  gsi::Callback cb_sort_2340_1;
  gsi::Callback cb_span_c2395_0;
  gsi::Callback cb_submit_0_0;
  gsi::Callback cb_supportedDropActions_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_queryChange_0_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QSqlQueryModel_Adaptor::~QSqlQueryModel_Adaptor() { }

//  Constructor QSqlQueryModel::QSqlQueryModel(QObject *parent) (adaptor class)

static void _init_ctor_QSqlQueryModel_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QSqlQueryModel_Adaptor> ();
}

static void _call_ctor_QSqlQueryModel_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QSqlQueryModel_Adaptor *> (new QSqlQueryModel_Adaptor (arg1));
}


// exposed void QSqlQueryModel::beginInsertColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_beginInsertColumns_3713 (arg1, arg2, arg3);
}


// exposed void QSqlQueryModel::beginInsertRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_beginInsertRows_3713 (arg1, arg2, arg3);
}


// exposed bool QSqlQueryModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)

static void _init_fp_beginMoveColumns_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationColumn");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveColumns_6659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_beginMoveColumns_6659 (arg1, arg2, arg3, arg4, arg5));
}


// exposed bool QSqlQueryModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)

static void _init_fp_beginMoveRows_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationRow");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveRows_6659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_beginMoveRows_6659 (arg1, arg2, arg3, arg4, arg5));
}


// exposed void QSqlQueryModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_beginRemoveColumns_3713 (arg1, arg2, arg3);
}


// exposed void QSqlQueryModel::beginRemoveRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_beginRemoveRows_3713 (arg1, arg2, arg3);
}


// exposed void QSqlQueryModel::beginResetModel()

static void _init_fp_beginResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_beginResetModel_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_beginResetModel_0 ();
}


// QModelIndex QSqlQueryModel::buddy(const QModelIndex &index)

static void _init_cbs_buddy_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_buddy_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QSqlQueryModel_Adaptor *)cls)->cbs_buddy_c2395_0 (arg1));
}

static void _set_callback_cbs_buddy_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_buddy_c2395_0 = cb;
}


// bool QSqlQueryModel::canFetchMore(const QModelIndex &parent)

static void _init_cbs_canFetchMore_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_canFetchMore_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlQueryModel_Adaptor *)cls)->cbs_canFetchMore_c2395_1 (arg1));
}

static void _set_callback_cbs_canFetchMore_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_canFetchMore_c2395_1 = cb;
}


// exposed void QSqlQueryModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)

static void _init_fp_changePersistentIndex_4682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndex_4682 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_changePersistentIndex_4682 (arg1, arg2);
}


// exposed void QSqlQueryModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)

static void _init_fp_changePersistentIndexList_5912 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QList<QModelIndex> & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndexList_5912 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  const QList<QModelIndex> &arg2 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_changePersistentIndexList_5912 (arg1, arg2);
}


// void QSqlQueryModel::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QSqlQueryModel::clear()

static void _init_cbs_clear_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_clear_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->cbs_clear_0_0 ();
}

static void _set_callback_cbs_clear_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_clear_0_0 = cb;
}


// int QSqlQueryModel::columnCount(const QModelIndex &parent)

static void _init_cbs_columnCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_columnCount_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<int > ((int)((QSqlQueryModel_Adaptor *)cls)->cbs_columnCount_c2395_1 (arg1));
}

static void _set_callback_cbs_columnCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_columnCount_c2395_1 = cb;
}


// exposed QModelIndex QSqlQueryModel::createIndex(int row, int column, void *data)

static void _init_fp_createIndex_c2374 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data", true, "0");
  decl->add_arg<void * > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2374 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  void *arg3 = args ? gsi::arg_reader<void * >() (args, heap) : gsi::arg_maker<void * >() (0, heap);
  ret.write<QModelIndex > ((QModelIndex)((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_createIndex_c2374 (arg1, arg2, arg3));
}


// exposed QModelIndex QSqlQueryModel::createIndex(int row, int column, int id)

static void _init_fp_createIndex_c2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2085 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_createIndex_c2085 (arg1, arg2, arg3));
}


// exposed QModelIndex QSqlQueryModel::createIndex(int row, int column, quint32 id)

static void _init_fp_createIndex_c2416 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<quint32 > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2416 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  quint32 arg3 = gsi::arg_reader<quint32 >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_createIndex_c2416 (arg1, arg2, arg3));
}


// void QSqlQueryModel::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// QVariant QSqlQueryModel::data(const QModelIndex &item, int role)

static void _init_cbs_data_c3054_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_data_c3054_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QSqlQueryModel_Adaptor *)cls)->cbs_data_c3054_1 (arg1, arg2));
}

static void _set_callback_cbs_data_c3054_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_data_c3054_1 = cb;
}


// emitter void QSqlQueryModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)

static void _init_emitter_dataChanged_4682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeft");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomRight");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_dataChanged_4682 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QSqlQueryModel_Adaptor *)cls)->emitter_QSqlQueryModel_dataChanged_4682 (arg1, arg2);
}


// exposed bool QSqlQueryModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)

static void _init_fp_decodeData_5302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("stream");
  decl->add_arg<QDataStream & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_fp_decodeData_5302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  QDataStream &arg4 = gsi::arg_reader<QDataStream & >() (args, heap);
  ret.write<bool > ((bool)((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_decodeData_5302 (arg1, arg2, arg3, arg4));
}


// emitter void QSqlQueryModel::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QSqlQueryModel_Adaptor *)cls)->emitter_QSqlQueryModel_destroyed_1302 (arg1);
}


// void QSqlQueryModel::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// bool QSqlQueryModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_dropMimeData_7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_dropMimeData_7425_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  const QModelIndex &arg5 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlQueryModel_Adaptor *)cls)->cbs_dropMimeData_7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_dropMimeData_7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_dropMimeData_7425_0 = cb;
}


// exposed void QSqlQueryModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)

static void _init_fp_encodeData_c4599 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream");
  decl->add_arg<QDataStream & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_encodeData_c4599 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  QDataStream &arg2 = gsi::arg_reader<QDataStream & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_encodeData_c4599 (arg1, arg2);
}


// exposed void QSqlQueryModel::endInsertColumns()

static void _init_fp_endInsertColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_endInsertColumns_0 ();
}


// exposed void QSqlQueryModel::endInsertRows()

static void _init_fp_endInsertRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_endInsertRows_0 ();
}


// exposed void QSqlQueryModel::endMoveColumns()

static void _init_fp_endMoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_endMoveColumns_0 ();
}


// exposed void QSqlQueryModel::endMoveRows()

static void _init_fp_endMoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_endMoveRows_0 ();
}


// exposed void QSqlQueryModel::endRemoveColumns()

static void _init_fp_endRemoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_endRemoveColumns_0 ();
}


// exposed void QSqlQueryModel::endRemoveRows()

static void _init_fp_endRemoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_endRemoveRows_0 ();
}


// exposed void QSqlQueryModel::endResetModel()

static void _init_fp_endResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endResetModel_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_endResetModel_0 ();
}


// bool QSqlQueryModel::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSqlQueryModel_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QSqlQueryModel::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSqlQueryModel_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QSqlQueryModel::fetchMore(const QModelIndex &parent)

static void _init_cbs_fetchMore_2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fetchMore_2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->cbs_fetchMore_2395_1 (arg1);
}

static void _set_callback_cbs_fetchMore_2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_fetchMore_2395_1 = cb;
}


// QFlags<Qt::ItemFlag> QSqlQueryModel::flags(const QModelIndex &index)

static void _init_cbs_flags_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QFlags<Qt::ItemFlag> > ();
}

static void _call_cbs_flags_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QFlags<Qt::ItemFlag> > ((QFlags<Qt::ItemFlag>)((QSqlQueryModel_Adaptor *)cls)->cbs_flags_c2395_0 (arg1));
}

static void _set_callback_cbs_flags_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_flags_c2395_0 = cb;
}


// QVariant QSqlQueryModel::headerData(int section, Qt::Orientation orientation, int role)

static void _init_cbs_headerData_c3231_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_cbs_headerData_c3231_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QSqlQueryModel_Adaptor *)cls)->cbs_headerData_c3231_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_headerData_c3231_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_headerData_c3231_1 = cb;
}


// emitter void QSqlQueryModel::headerDataChanged(Qt::Orientation orientation, int first, int last)

static void _init_emitter_headerDataChanged_3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_headerDataChanged_3231 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSqlQueryModel_Adaptor *)cls)->emitter_QSqlQueryModel_headerDataChanged_3231 (arg1, arg2, arg3);
}


// QModelIndex QSqlQueryModel::index(int row, int column, const QModelIndex &parent)

static void _init_cbs_index_c3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_index_c3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QSqlQueryModel_Adaptor *)cls)->cbs_index_c3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_index_c3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_index_c3713_1 = cb;
}


// exposed QModelIndex QSqlQueryModel::indexInQuery(const QModelIndex &item)

static void _init_fp_indexInQuery_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_indexInQuery_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_indexInQuery_c2395 (arg1));
}


// bool QSqlQueryModel::insertColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_insertColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertColumns_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlQueryModel_Adaptor *)cls)->cbs_insertColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_insertColumns_3713_1 = cb;
}


// bool QSqlQueryModel::insertRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_insertRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertRows_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlQueryModel_Adaptor *)cls)->cbs_insertRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_insertRows_3713_1 = cb;
}


// QMap<int, QVariant> QSqlQueryModel::itemData(const QModelIndex &index)

static void _init_cbs_itemData_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QMap<int, QVariant> > ();
}

static void _call_cbs_itemData_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QMap<int, QVariant> > ((QMap<int, QVariant>)((QSqlQueryModel_Adaptor *)cls)->cbs_itemData_c2395_0 (arg1));
}

static void _set_callback_cbs_itemData_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_itemData_c2395_0 = cb;
}


// emitter void QSqlQueryModel::layoutAboutToBeChanged()

static void _init_emitter_layoutAboutToBeChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_layoutAboutToBeChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QSqlQueryModel_Adaptor *)cls)->emitter_QSqlQueryModel_layoutAboutToBeChanged_0 ();
}


// emitter void QSqlQueryModel::layoutChanged()

static void _init_emitter_layoutChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_layoutChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QSqlQueryModel_Adaptor *)cls)->emitter_QSqlQueryModel_layoutChanged_0 ();
}


// QList<QModelIndex> QSqlQueryModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)

static void _init_cbs_match_c7932_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("hits");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags");
  decl->add_arg<QFlags<Qt::MatchFlag> > (argspec_4);
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_cbs_match_c7932_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  const QVariant &arg3 = args.read<const QVariant & > (heap);
  int arg4 = args.read<int > (heap);
  QFlags<Qt::MatchFlag> arg5 = args.read<QFlags<Qt::MatchFlag> > (heap);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QSqlQueryModel_Adaptor *)cls)->cbs_match_c7932_2 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_match_c7932_2 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_match_c7932_2 = cb;
}


// QMimeData *QSqlQueryModel::mimeData(const QList<QModelIndex> &indexes)

static void _init_cbs_mimeData_c3010_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_mimeData_c3010_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = args.read<const QList<QModelIndex> & > (heap);
  ret.write<QMimeData * > ((QMimeData *)((QSqlQueryModel_Adaptor *)cls)->cbs_mimeData_c3010_0 (arg1));
}

static void _set_callback_cbs_mimeData_c3010_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_mimeData_c3010_0 = cb;
}


// QStringList QSqlQueryModel::mimeTypes()

static void _init_cbs_mimeTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_cbs_mimeTypes_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QSqlQueryModel_Adaptor *)cls)->cbs_mimeTypes_c0_0 ());
}

static void _set_callback_cbs_mimeTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_mimeTypes_c0_0 = cb;
}


// exposed QList<QModelIndex> QSqlQueryModel::persistentIndexList()

static void _init_fp_persistentIndexList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_fp_persistentIndexList_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_persistentIndexList_c0 ());
}


// void QSqlQueryModel::queryChange()

static void _init_cbs_queryChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_queryChange_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->cbs_queryChange_0_0 ();
}

static void _set_callback_cbs_queryChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_queryChange_0_0 = cb;
}


// exposed int QSqlQueryModel::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_receivers_c1731 (arg1));
}


// bool QSqlQueryModel::removeColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_removeColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeColumns_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlQueryModel_Adaptor *)cls)->cbs_removeColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_removeColumns_3713_1 = cb;
}


// bool QSqlQueryModel::removeRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_removeRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeRows_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlQueryModel_Adaptor *)cls)->cbs_removeRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_removeRows_3713_1 = cb;
}


// exposed void QSqlQueryModel::reset()

static void _init_fp_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_reset_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_reset_0 ();
}


// void QSqlQueryModel::revert()

static void _init_cbs_revert_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_revert_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->cbs_revert_0_0 ();
}

static void _set_callback_cbs_revert_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_revert_0_0 = cb;
}


// int QSqlQueryModel::rowCount(const QModelIndex &parent)

static void _init_cbs_rowCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_rowCount_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<int > ((int)((QSqlQueryModel_Adaptor *)cls)->cbs_rowCount_c2395_1 (arg1));
}

static void _set_callback_cbs_rowCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_rowCount_c2395_1 = cb;
}


// exposed QObject *QSqlQueryModel::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_sender_c0 ());
}


// bool QSqlQueryModel::setData(const QModelIndex &index, const QVariant &value, int role)

static void _init_cbs_setData_5065_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_setData_5065_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSqlQueryModel_Adaptor *)cls)->cbs_setData_5065_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_setData_5065_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_setData_5065_1 = cb;
}


// bool QSqlQueryModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)

static void _init_cbs_setHeaderData_5242_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("role");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_setHeaderData_5242_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  const QVariant &arg3 = args.read<const QVariant & > (heap);
  int arg4 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSqlQueryModel_Adaptor *)cls)->cbs_setHeaderData_5242_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_setHeaderData_5242_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_setHeaderData_5242_1 = cb;
}


// bool QSqlQueryModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)

static void _init_cbs_setItemData_5414_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("roles");
  decl->add_arg<const QMap<int, QVariant> & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_setItemData_5414_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QMap<int, QVariant> &arg2 = args.read<const QMap<int, QVariant> & > (heap);
  ret.write<bool > ((bool)((QSqlQueryModel_Adaptor *)cls)->cbs_setItemData_5414_0 (arg1, arg2));
}

static void _set_callback_cbs_setItemData_5414_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_setItemData_5414_0 = cb;
}


// exposed void QSqlQueryModel::setLastError(const QSqlError &error)

static void _init_fp_setLastError_2220 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<const QSqlError & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setLastError_2220 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSqlError &arg1 = gsi::arg_reader<const QSqlError & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_setLastError_2220 (arg1);
}


// exposed void QSqlQueryModel::setRoleNames(const QHash<int, QByteArray> &roleNames)

static void _init_fp_setRoleNames_3419 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("roleNames");
  decl->add_arg<const QHash<int, QByteArray> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setRoleNames_3419 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QHash<int, QByteArray> &arg1 = gsi::arg_reader<const QHash<int, QByteArray> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->fp_QSqlQueryModel_setRoleNames_3419 (arg1);
}


// void QSqlQueryModel::sort(int column, Qt::SortOrder order)

static void _init_cbs_sort_2340_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_sort_2340_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->cbs_sort_2340_1 (arg1, arg2);
}

static void _set_callback_cbs_sort_2340_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_sort_2340_1 = cb;
}


// QSize QSqlQueryModel::span(const QModelIndex &index)

static void _init_cbs_span_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_cbs_span_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QSize > ((QSize)((QSqlQueryModel_Adaptor *)cls)->cbs_span_c2395_0 (arg1));
}

static void _set_callback_cbs_span_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_span_c2395_0 = cb;
}


// bool QSqlQueryModel::submit()

static void _init_cbs_submit_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_submit_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlQueryModel_Adaptor *)cls)->cbs_submit_0_0 ());
}

static void _set_callback_cbs_submit_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_submit_0_0 = cb;
}


// QFlags<Qt::DropAction> QSqlQueryModel::supportedDropActions()

static void _init_cbs_supportedDropActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::DropAction> > ();
}

static void _call_cbs_supportedDropActions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::DropAction> > ((QFlags<Qt::DropAction>)((QSqlQueryModel_Adaptor *)cls)->cbs_supportedDropActions_c0_0 ());
}

static void _set_callback_cbs_supportedDropActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_supportedDropActions_c0_0 = cb;
}


// void QSqlQueryModel::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlQueryModel_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlQueryModel_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QSqlQueryModel> &qtdecl_QSqlQueryModel ();

static gsi::Methods methods_QSqlQueryModel_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSqlQueryModel::QSqlQueryModel(QObject *parent)\nThis method creates an object of class QSqlQueryModel.", &_init_ctor_QSqlQueryModel_Adaptor_1302, &_call_ctor_QSqlQueryModel_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*beginInsertColumns", "@brief Method void QSqlQueryModel::beginInsertColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertColumns_3713, &_call_fp_beginInsertColumns_3713);
  methods += new qt_gsi::GenericMethod ("*beginInsertRows", "@brief Method void QSqlQueryModel::beginInsertRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertRows_3713, &_call_fp_beginInsertRows_3713);
  methods += new qt_gsi::GenericMethod ("*beginMoveColumns", "@brief Method bool QSqlQueryModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveColumns_6659, &_call_fp_beginMoveColumns_6659);
  methods += new qt_gsi::GenericMethod ("*beginMoveRows", "@brief Method bool QSqlQueryModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveRows_6659, &_call_fp_beginMoveRows_6659);
  methods += new qt_gsi::GenericMethod ("*beginRemoveColumns", "@brief Method void QSqlQueryModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveColumns_3713, &_call_fp_beginRemoveColumns_3713);
  methods += new qt_gsi::GenericMethod ("*beginRemoveRows", "@brief Method void QSqlQueryModel::beginRemoveRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveRows_3713, &_call_fp_beginRemoveRows_3713);
  methods += new qt_gsi::GenericMethod ("*beginResetModel", "@brief Method void QSqlQueryModel::beginResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginResetModel_0, &_call_fp_beginResetModel_0);
  methods += new qt_gsi::GenericMethod ("buddy", "@brief Virtual method QModelIndex QSqlQueryModel::buddy(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0);
  methods += new qt_gsi::GenericMethod ("buddy", "@hide", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0, &_set_callback_cbs_buddy_c2395_0);
  methods += new qt_gsi::GenericMethod ("canFetchMore", "@brief Virtual method bool QSqlQueryModel::canFetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canFetchMore_c2395_1, &_call_cbs_canFetchMore_c2395_1);
  methods += new qt_gsi::GenericMethod ("canFetchMore", "@hide", true, &_init_cbs_canFetchMore_c2395_1, &_call_cbs_canFetchMore_c2395_1, &_set_callback_cbs_canFetchMore_c2395_1);
  methods += new qt_gsi::GenericMethod ("*changePersistentIndex", "@brief Method void QSqlQueryModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndex_4682, &_call_fp_changePersistentIndex_4682);
  methods += new qt_gsi::GenericMethod ("*changePersistentIndexList", "@brief Method void QSqlQueryModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndexList_5912, &_call_fp_changePersistentIndexList_5912);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QSqlQueryModel::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Virtual method void QSqlQueryModel::clear()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0);
  methods += new qt_gsi::GenericMethod ("clear", "@hide", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0, &_set_callback_cbs_clear_0_0);
  methods += new qt_gsi::GenericMethod ("columnCount", "@brief Virtual method int QSqlQueryModel::columnCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("columnCount", "@hide", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1, &_set_callback_cbs_columnCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("*createIndex", "@brief Method QModelIndex QSqlQueryModel::createIndex(int row, int column, void *data)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2374, &_call_fp_createIndex_c2374);
  methods += new qt_gsi::GenericMethod ("*createIndex", "@brief Method QModelIndex QSqlQueryModel::createIndex(int row, int column, int id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2085, &_call_fp_createIndex_c2085);
  methods += new qt_gsi::GenericMethod ("*createIndex", "@brief Method QModelIndex QSqlQueryModel::createIndex(int row, int column, quint32 id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2416, &_call_fp_createIndex_c2416);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QSqlQueryModel::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("data", "@brief Virtual method QVariant QSqlQueryModel::data(const QModelIndex &item, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1);
  methods += new qt_gsi::GenericMethod ("data", "@hide", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1, &_set_callback_cbs_data_c3054_1);
  methods += new qt_gsi::GenericMethod ("emit_dataChanged", "@brief Emitter for signal void QSqlQueryModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)\nCall this method to emit this signal.", false, &_init_emitter_dataChanged_4682, &_call_emitter_dataChanged_4682);
  methods += new qt_gsi::GenericMethod ("*decodeData", "@brief Method bool QSqlQueryModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_decodeData_5302, &_call_fp_decodeData_5302);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QSqlQueryModel::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QSqlQueryModel::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@brief Virtual method bool QSqlQueryModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@hide", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0, &_set_callback_cbs_dropMimeData_7425_0);
  methods += new qt_gsi::GenericMethod ("*encodeData", "@brief Method void QSqlQueryModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_encodeData_c4599, &_call_fp_encodeData_c4599);
  methods += new qt_gsi::GenericMethod ("*endInsertColumns", "@brief Method void QSqlQueryModel::endInsertColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertColumns_0, &_call_fp_endInsertColumns_0);
  methods += new qt_gsi::GenericMethod ("*endInsertRows", "@brief Method void QSqlQueryModel::endInsertRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertRows_0, &_call_fp_endInsertRows_0);
  methods += new qt_gsi::GenericMethod ("*endMoveColumns", "@brief Method void QSqlQueryModel::endMoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveColumns_0, &_call_fp_endMoveColumns_0);
  methods += new qt_gsi::GenericMethod ("*endMoveRows", "@brief Method void QSqlQueryModel::endMoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveRows_0, &_call_fp_endMoveRows_0);
  methods += new qt_gsi::GenericMethod ("*endRemoveColumns", "@brief Method void QSqlQueryModel::endRemoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveColumns_0, &_call_fp_endRemoveColumns_0);
  methods += new qt_gsi::GenericMethod ("*endRemoveRows", "@brief Method void QSqlQueryModel::endRemoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveRows_0, &_call_fp_endRemoveRows_0);
  methods += new qt_gsi::GenericMethod ("*endResetModel", "@brief Method void QSqlQueryModel::endResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endResetModel_0, &_call_fp_endResetModel_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QSqlQueryModel::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QSqlQueryModel::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("fetchMore", "@brief Virtual method void QSqlQueryModel::fetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fetchMore_2395_1, &_call_cbs_fetchMore_2395_1);
  methods += new qt_gsi::GenericMethod ("fetchMore", "@hide", false, &_init_cbs_fetchMore_2395_1, &_call_cbs_fetchMore_2395_1, &_set_callback_cbs_fetchMore_2395_1);
  methods += new qt_gsi::GenericMethod ("flags", "@brief Virtual method QFlags<Qt::ItemFlag> QSqlQueryModel::flags(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0);
  methods += new qt_gsi::GenericMethod ("flags", "@hide", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0, &_set_callback_cbs_flags_c2395_0);
  methods += new qt_gsi::GenericMethod ("headerData", "@brief Virtual method QVariant QSqlQueryModel::headerData(int section, Qt::Orientation orientation, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1);
  methods += new qt_gsi::GenericMethod ("headerData", "@hide", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1, &_set_callback_cbs_headerData_c3231_1);
  methods += new qt_gsi::GenericMethod ("emit_headerDataChanged", "@brief Emitter for signal void QSqlQueryModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_headerDataChanged_3231, &_call_emitter_headerDataChanged_3231);
  methods += new qt_gsi::GenericMethod ("index", "@brief Virtual method QModelIndex QSqlQueryModel::index(int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1);
  methods += new qt_gsi::GenericMethod ("index", "@hide", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1, &_set_callback_cbs_index_c3713_1);
  methods += new qt_gsi::GenericMethod ("*indexInQuery", "@brief Method QModelIndex QSqlQueryModel::indexInQuery(const QModelIndex &item)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_indexInQuery_c2395, &_call_fp_indexInQuery_c2395);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@brief Virtual method bool QSqlQueryModel::insertColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@hide", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1, &_set_callback_cbs_insertColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("insertRows", "@brief Virtual method bool QSqlQueryModel::insertRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1);
  methods += new qt_gsi::GenericMethod ("insertRows", "@hide", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1, &_set_callback_cbs_insertRows_3713_1);
  methods += new qt_gsi::GenericMethod ("itemData", "@brief Virtual method QMap<int, QVariant> QSqlQueryModel::itemData(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemData_c2395_0, &_call_cbs_itemData_c2395_0);
  methods += new qt_gsi::GenericMethod ("itemData", "@hide", true, &_init_cbs_itemData_c2395_0, &_call_cbs_itemData_c2395_0, &_set_callback_cbs_itemData_c2395_0);
  methods += new qt_gsi::GenericMethod ("emit_layoutAboutToBeChanged", "@brief Emitter for signal void QSqlQueryModel::layoutAboutToBeChanged()\nCall this method to emit this signal.", false, &_init_emitter_layoutAboutToBeChanged_0, &_call_emitter_layoutAboutToBeChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_layoutChanged", "@brief Emitter for signal void QSqlQueryModel::layoutChanged()\nCall this method to emit this signal.", false, &_init_emitter_layoutChanged_0, &_call_emitter_layoutChanged_0);
  methods += new qt_gsi::GenericMethod ("match", "@brief Virtual method QList<QModelIndex> QSqlQueryModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2);
  methods += new qt_gsi::GenericMethod ("match", "@hide", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2, &_set_callback_cbs_match_c7932_2);
  methods += new qt_gsi::GenericMethod ("mimeData", "@brief Virtual method QMimeData *QSqlQueryModel::mimeData(const QList<QModelIndex> &indexes)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0);
  methods += new qt_gsi::GenericMethod ("mimeData", "@hide", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0, &_set_callback_cbs_mimeData_c3010_0);
  methods += new qt_gsi::GenericMethod ("mimeTypes", "@brief Virtual method QStringList QSqlQueryModel::mimeTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("mimeTypes", "@hide", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0, &_set_callback_cbs_mimeTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("*persistentIndexList", "@brief Method QList<QModelIndex> QSqlQueryModel::persistentIndexList()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_persistentIndexList_c0, &_call_fp_persistentIndexList_c0);
  methods += new qt_gsi::GenericMethod ("*queryChange", "@brief Virtual method void QSqlQueryModel::queryChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_queryChange_0_0, &_call_cbs_queryChange_0_0);
  methods += new qt_gsi::GenericMethod ("*queryChange", "@hide", false, &_init_cbs_queryChange_0_0, &_call_cbs_queryChange_0_0, &_set_callback_cbs_queryChange_0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QSqlQueryModel::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@brief Virtual method bool QSqlQueryModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@hide", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1, &_set_callback_cbs_removeColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("removeRows", "@brief Virtual method bool QSqlQueryModel::removeRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1);
  methods += new qt_gsi::GenericMethod ("removeRows", "@hide", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1, &_set_callback_cbs_removeRows_3713_1);
  methods += new qt_gsi::GenericMethod ("*reset", "@brief Method void QSqlQueryModel::reset()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_reset_0, &_call_fp_reset_0);
  methods += new qt_gsi::GenericMethod ("revert", "@brief Virtual method void QSqlQueryModel::revert()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0);
  methods += new qt_gsi::GenericMethod ("revert", "@hide", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0, &_set_callback_cbs_revert_0_0);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Virtual method int QSqlQueryModel::rowCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("rowCount", "@hide", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1, &_set_callback_cbs_rowCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QSqlQueryModel::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("setData", "@brief Virtual method bool QSqlQueryModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1);
  methods += new qt_gsi::GenericMethod ("setData", "@hide", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1, &_set_callback_cbs_setData_5065_1);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@brief Virtual method bool QSqlQueryModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@hide", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1, &_set_callback_cbs_setHeaderData_5242_1);
  methods += new qt_gsi::GenericMethod ("setItemData", "@brief Virtual method bool QSqlQueryModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setItemData_5414_0, &_call_cbs_setItemData_5414_0);
  methods += new qt_gsi::GenericMethod ("setItemData", "@hide", false, &_init_cbs_setItemData_5414_0, &_call_cbs_setItemData_5414_0, &_set_callback_cbs_setItemData_5414_0);
  methods += new qt_gsi::GenericMethod ("*setLastError", "@brief Method void QSqlQueryModel::setLastError(const QSqlError &error)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setLastError_2220, &_call_fp_setLastError_2220);
  methods += new qt_gsi::GenericMethod ("*setRoleNames", "@brief Method void QSqlQueryModel::setRoleNames(const QHash<int, QByteArray> &roleNames)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setRoleNames_3419, &_call_fp_setRoleNames_3419);
  methods += new qt_gsi::GenericMethod ("sort", "@brief Virtual method void QSqlQueryModel::sort(int column, Qt::SortOrder order)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1);
  methods += new qt_gsi::GenericMethod ("sort", "@hide", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1, &_set_callback_cbs_sort_2340_1);
  methods += new qt_gsi::GenericMethod ("span", "@brief Virtual method QSize QSqlQueryModel::span(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0);
  methods += new qt_gsi::GenericMethod ("span", "@hide", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0, &_set_callback_cbs_span_c2395_0);
  methods += new qt_gsi::GenericMethod ("submit", "@brief Virtual method bool QSqlQueryModel::submit()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0);
  methods += new qt_gsi::GenericMethod ("submit", "@hide", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0, &_set_callback_cbs_submit_0_0);
  methods += new qt_gsi::GenericMethod ("supportedDropActions", "@brief Virtual method QFlags<Qt::DropAction> QSqlQueryModel::supportedDropActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDropActions", "@hide", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0, &_set_callback_cbs_supportedDropActions_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QSqlQueryModel::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QSqlQueryModel_Adaptor> decl_QSqlQueryModel_Adaptor (qtdecl_QSqlQueryModel (), "QtSql", "QSqlQueryModel",
  methods_QSqlQueryModel_Adaptor (),
  "@qt\n@brief Binding of QSqlQueryModel");

}

