
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQUrlInfo.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QUrlInfo>
#include <QDateTime>
#include "gsiQt.h"
#include "gsiQtNetworkCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QUrlInfo

// QString QUrlInfo::group()


static void _init_f_group_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_group_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUrlInfo *)cls)->group ());
}


// bool QUrlInfo::isDir()


static void _init_f_isDir_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDir_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrlInfo *)cls)->isDir ());
}


// bool QUrlInfo::isExecutable()


static void _init_f_isExecutable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isExecutable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrlInfo *)cls)->isExecutable ());
}


// bool QUrlInfo::isFile()


static void _init_f_isFile_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isFile_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrlInfo *)cls)->isFile ());
}


// bool QUrlInfo::isReadable()


static void _init_f_isReadable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isReadable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrlInfo *)cls)->isReadable ());
}


// bool QUrlInfo::isSymLink()


static void _init_f_isSymLink_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSymLink_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrlInfo *)cls)->isSymLink ());
}


// bool QUrlInfo::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrlInfo *)cls)->isValid ());
}


// bool QUrlInfo::isWritable()


static void _init_f_isWritable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWritable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrlInfo *)cls)->isWritable ());
}


// QDateTime QUrlInfo::lastModified()


static void _init_f_lastModified_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDateTime > ();
}

static void _call_f_lastModified_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDateTime > ((QDateTime)((QUrlInfo *)cls)->lastModified ());
}


// QDateTime QUrlInfo::lastRead()


static void _init_f_lastRead_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDateTime > ();
}

static void _call_f_lastRead_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDateTime > ((QDateTime)((QUrlInfo *)cls)->lastRead ());
}


// QString QUrlInfo::name()


static void _init_f_name_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_name_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUrlInfo *)cls)->name ());
}


// bool QUrlInfo::operator!=(const QUrlInfo &i)


static void _init_f_operator_excl__eq__c2097 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<const QUrlInfo & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2097 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrlInfo &arg1 = gsi::arg_reader<const QUrlInfo & >() (args, heap);
  ret.write<bool > ((bool)((QUrlInfo *)cls)->operator!= (arg1));
}


// QUrlInfo &QUrlInfo::operator=(const QUrlInfo &ui)


static void _init_f_operator_eq__2097 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ui");
  decl->add_arg<const QUrlInfo & > (argspec_0);
  decl->set_return<QUrlInfo & > ();
}

static void _call_f_operator_eq__2097 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrlInfo &arg1 = gsi::arg_reader<const QUrlInfo & >() (args, heap);
  ret.write<QUrlInfo & > ((QUrlInfo &)((QUrlInfo *)cls)->operator= (arg1));
}


// bool QUrlInfo::operator==(const QUrlInfo &i)


static void _init_f_operator_eq__eq__c2097 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<const QUrlInfo & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2097 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrlInfo &arg1 = gsi::arg_reader<const QUrlInfo & >() (args, heap);
  ret.write<bool > ((bool)((QUrlInfo *)cls)->operator== (arg1));
}


// QString QUrlInfo::owner()


static void _init_f_owner_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_owner_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUrlInfo *)cls)->owner ());
}


// int QUrlInfo::permissions()


static void _init_f_permissions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_permissions_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QUrlInfo *)cls)->permissions ());
}


// void QUrlInfo::setDir(bool b)


static void _init_f_setDir_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDir_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo *)cls)->setDir (arg1);
}


// void QUrlInfo::setFile(bool b)


static void _init_f_setFile_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFile_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo *)cls)->setFile (arg1);
}


// void QUrlInfo::setGroup(const QString &s)


static void _init_f_setGroup_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGroup_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo *)cls)->setGroup (arg1);
}


// void QUrlInfo::setLastModified(const QDateTime &dt)


static void _init_f_setLastModified_2175 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dt");
  decl->add_arg<const QDateTime & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLastModified_2175 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDateTime &arg1 = gsi::arg_reader<const QDateTime & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo *)cls)->setLastModified (arg1);
}


// void QUrlInfo::setLastRead(const QDateTime &dt)


static void _init_f_setLastRead_2175 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dt");
  decl->add_arg<const QDateTime & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLastRead_2175 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDateTime &arg1 = gsi::arg_reader<const QDateTime & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo *)cls)->setLastRead (arg1);
}


// void QUrlInfo::setName(const QString &name)


static void _init_f_setName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setName_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo *)cls)->setName (arg1);
}


// void QUrlInfo::setOwner(const QString &s)


static void _init_f_setOwner_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOwner_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo *)cls)->setOwner (arg1);
}


// void QUrlInfo::setPermissions(int p)


static void _init_f_setPermissions_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPermissions_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo *)cls)->setPermissions (arg1);
}


// void QUrlInfo::setReadable(bool b)


static void _init_f_setReadable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setReadable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo *)cls)->setReadable (arg1);
}


// void QUrlInfo::setSize(qint64 size)


static void _init_f_setSize_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSize_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo *)cls)->setSize (arg1);
}


// void QUrlInfo::setSymLink(bool b)


static void _init_f_setSymLink_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSymLink_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo *)cls)->setSymLink (arg1);
}


// void QUrlInfo::setWritable(bool b)


static void _init_f_setWritable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWritable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo *)cls)->setWritable (arg1);
}


// qint64 QUrlInfo::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QUrlInfo *)cls)->size ());
}


// static bool QUrlInfo::equal(const QUrlInfo &i1, const QUrlInfo &i2, int sortBy)


static void _init_f_equal_4745 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i1");
  decl->add_arg<const QUrlInfo & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("i2");
  decl->add_arg<const QUrlInfo & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sortBy");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_equal_4745 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrlInfo &arg1 = gsi::arg_reader<const QUrlInfo & >() (args, heap);
  const QUrlInfo &arg2 = gsi::arg_reader<const QUrlInfo & >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)QUrlInfo::equal (arg1, arg2, arg3));
}


// static bool QUrlInfo::greaterThan(const QUrlInfo &i1, const QUrlInfo &i2, int sortBy)


static void _init_f_greaterThan_4745 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i1");
  decl->add_arg<const QUrlInfo & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("i2");
  decl->add_arg<const QUrlInfo & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sortBy");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_greaterThan_4745 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrlInfo &arg1 = gsi::arg_reader<const QUrlInfo & >() (args, heap);
  const QUrlInfo &arg2 = gsi::arg_reader<const QUrlInfo & >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)QUrlInfo::greaterThan (arg1, arg2, arg3));
}


// static bool QUrlInfo::lessThan(const QUrlInfo &i1, const QUrlInfo &i2, int sortBy)


static void _init_f_lessThan_4745 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i1");
  decl->add_arg<const QUrlInfo & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("i2");
  decl->add_arg<const QUrlInfo & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sortBy");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_lessThan_4745 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrlInfo &arg1 = gsi::arg_reader<const QUrlInfo & >() (args, heap);
  const QUrlInfo &arg2 = gsi::arg_reader<const QUrlInfo & >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)QUrlInfo::lessThan (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QUrlInfo () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod (":group", "@brief Method QString QUrlInfo::group()\n", true, &_init_f_group_c0, &_call_f_group_c0);
  methods += new qt_gsi::GenericMethod ("isDir?|:dir", "@brief Method bool QUrlInfo::isDir()\n", true, &_init_f_isDir_c0, &_call_f_isDir_c0);
  methods += new qt_gsi::GenericMethod ("isExecutable?", "@brief Method bool QUrlInfo::isExecutable()\n", true, &_init_f_isExecutable_c0, &_call_f_isExecutable_c0);
  methods += new qt_gsi::GenericMethod ("isFile?|:file", "@brief Method bool QUrlInfo::isFile()\n", true, &_init_f_isFile_c0, &_call_f_isFile_c0);
  methods += new qt_gsi::GenericMethod ("isReadable?|:readable", "@brief Method bool QUrlInfo::isReadable()\n", true, &_init_f_isReadable_c0, &_call_f_isReadable_c0);
  methods += new qt_gsi::GenericMethod ("isSymLink?|:symLink", "@brief Method bool QUrlInfo::isSymLink()\n", true, &_init_f_isSymLink_c0, &_call_f_isSymLink_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QUrlInfo::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod ("isWritable?|:writable", "@brief Method bool QUrlInfo::isWritable()\n", true, &_init_f_isWritable_c0, &_call_f_isWritable_c0);
  methods += new qt_gsi::GenericMethod (":lastModified", "@brief Method QDateTime QUrlInfo::lastModified()\n", true, &_init_f_lastModified_c0, &_call_f_lastModified_c0);
  methods += new qt_gsi::GenericMethod (":lastRead", "@brief Method QDateTime QUrlInfo::lastRead()\n", true, &_init_f_lastRead_c0, &_call_f_lastRead_c0);
  methods += new qt_gsi::GenericMethod (":name", "@brief Method QString QUrlInfo::name()\n", true, &_init_f_name_c0, &_call_f_name_c0);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QUrlInfo::operator!=(const QUrlInfo &i)\n", true, &_init_f_operator_excl__eq__c2097, &_call_f_operator_excl__eq__c2097);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QUrlInfo &QUrlInfo::operator=(const QUrlInfo &ui)\n", false, &_init_f_operator_eq__2097, &_call_f_operator_eq__2097);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QUrlInfo::operator==(const QUrlInfo &i)\n", true, &_init_f_operator_eq__eq__c2097, &_call_f_operator_eq__eq__c2097);
  methods += new qt_gsi::GenericMethod (":owner", "@brief Method QString QUrlInfo::owner()\n", true, &_init_f_owner_c0, &_call_f_owner_c0);
  methods += new qt_gsi::GenericMethod (":permissions", "@brief Method int QUrlInfo::permissions()\n", true, &_init_f_permissions_c0, &_call_f_permissions_c0);
  methods += new qt_gsi::GenericMethod ("setDir|dir=", "@brief Method void QUrlInfo::setDir(bool b)\n", false, &_init_f_setDir_864, &_call_f_setDir_864);
  methods += new qt_gsi::GenericMethod ("setFile|file=", "@brief Method void QUrlInfo::setFile(bool b)\n", false, &_init_f_setFile_864, &_call_f_setFile_864);
  methods += new qt_gsi::GenericMethod ("setGroup|group=", "@brief Method void QUrlInfo::setGroup(const QString &s)\n", false, &_init_f_setGroup_2025, &_call_f_setGroup_2025);
  methods += new qt_gsi::GenericMethod ("setLastModified|lastModified=", "@brief Method void QUrlInfo::setLastModified(const QDateTime &dt)\n", false, &_init_f_setLastModified_2175, &_call_f_setLastModified_2175);
  methods += new qt_gsi::GenericMethod ("setLastRead|lastRead=", "@brief Method void QUrlInfo::setLastRead(const QDateTime &dt)\n", false, &_init_f_setLastRead_2175, &_call_f_setLastRead_2175);
  methods += new qt_gsi::GenericMethod ("setName|name=", "@brief Method void QUrlInfo::setName(const QString &name)\n", false, &_init_f_setName_2025, &_call_f_setName_2025);
  methods += new qt_gsi::GenericMethod ("setOwner|owner=", "@brief Method void QUrlInfo::setOwner(const QString &s)\n", false, &_init_f_setOwner_2025, &_call_f_setOwner_2025);
  methods += new qt_gsi::GenericMethod ("setPermissions|permissions=", "@brief Method void QUrlInfo::setPermissions(int p)\n", false, &_init_f_setPermissions_767, &_call_f_setPermissions_767);
  methods += new qt_gsi::GenericMethod ("setReadable|readable=", "@brief Method void QUrlInfo::setReadable(bool b)\n", false, &_init_f_setReadable_864, &_call_f_setReadable_864);
  methods += new qt_gsi::GenericMethod ("setSize|size=", "@brief Method void QUrlInfo::setSize(qint64 size)\n", false, &_init_f_setSize_986, &_call_f_setSize_986);
  methods += new qt_gsi::GenericMethod ("setSymLink|symLink=", "@brief Method void QUrlInfo::setSymLink(bool b)\n", false, &_init_f_setSymLink_864, &_call_f_setSymLink_864);
  methods += new qt_gsi::GenericMethod ("setWritable|writable=", "@brief Method void QUrlInfo::setWritable(bool b)\n", false, &_init_f_setWritable_864, &_call_f_setWritable_864);
  methods += new qt_gsi::GenericMethod (":size", "@brief Method qint64 QUrlInfo::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
  methods += new qt_gsi::GenericStaticMethod ("equal", "@brief Static method bool QUrlInfo::equal(const QUrlInfo &i1, const QUrlInfo &i2, int sortBy)\nThis method is static and can be called without an instance.", &_init_f_equal_4745, &_call_f_equal_4745);
  methods += new qt_gsi::GenericStaticMethod ("greaterThan", "@brief Static method bool QUrlInfo::greaterThan(const QUrlInfo &i1, const QUrlInfo &i2, int sortBy)\nThis method is static and can be called without an instance.", &_init_f_greaterThan_4745, &_call_f_greaterThan_4745);
  methods += new qt_gsi::GenericStaticMethod ("lessThan", "@brief Static method bool QUrlInfo::lessThan(const QUrlInfo &i1, const QUrlInfo &i2, int sortBy)\nThis method is static and can be called without an instance.", &_init_f_lessThan_4745, &_call_f_lessThan_4745);
  return methods;
}

gsi::Class<QUrlInfo> decl_QUrlInfo ("QtNetwork", "QUrlInfo_Native",
  methods_QUrlInfo (),
  "@hide\n@alias QUrlInfo");

GSI_QTNETWORK_PUBLIC gsi::Class<QUrlInfo> &qtdecl_QUrlInfo () { return decl_QUrlInfo; }

}


class QUrlInfo_Adaptor : public QUrlInfo, public qt_gsi::QtObjectBase
{
public:

  virtual ~QUrlInfo_Adaptor();

  //  [adaptor ctor] QUrlInfo::QUrlInfo()
  QUrlInfo_Adaptor() : QUrlInfo()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QUrlInfo::QUrlInfo(const QUrlInfo &ui)
  QUrlInfo_Adaptor(const QUrlInfo &ui) : QUrlInfo(ui)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] void QUrlInfo::setDir(bool b)
  void cbs_setDir_864_0(bool b)
  {
    QUrlInfo::setDir(b);
  }

  virtual void setDir(bool b)
  {
    if (cb_setDir_864_0.can_issue()) {
      cb_setDir_864_0.issue<QUrlInfo_Adaptor, bool>(&QUrlInfo_Adaptor::cbs_setDir_864_0, b);
    } else {
      QUrlInfo::setDir(b);
    }
  }

  //  [adaptor impl] void QUrlInfo::setFile(bool b)
  void cbs_setFile_864_0(bool b)
  {
    QUrlInfo::setFile(b);
  }

  virtual void setFile(bool b)
  {
    if (cb_setFile_864_0.can_issue()) {
      cb_setFile_864_0.issue<QUrlInfo_Adaptor, bool>(&QUrlInfo_Adaptor::cbs_setFile_864_0, b);
    } else {
      QUrlInfo::setFile(b);
    }
  }

  //  [adaptor impl] void QUrlInfo::setGroup(const QString &s)
  void cbs_setGroup_2025_0(const QString &s)
  {
    QUrlInfo::setGroup(s);
  }

  virtual void setGroup(const QString &s)
  {
    if (cb_setGroup_2025_0.can_issue()) {
      cb_setGroup_2025_0.issue<QUrlInfo_Adaptor, const QString &>(&QUrlInfo_Adaptor::cbs_setGroup_2025_0, s);
    } else {
      QUrlInfo::setGroup(s);
    }
  }

  //  [adaptor impl] void QUrlInfo::setLastModified(const QDateTime &dt)
  void cbs_setLastModified_2175_0(const QDateTime &dt)
  {
    QUrlInfo::setLastModified(dt);
  }

  virtual void setLastModified(const QDateTime &dt)
  {
    if (cb_setLastModified_2175_0.can_issue()) {
      cb_setLastModified_2175_0.issue<QUrlInfo_Adaptor, const QDateTime &>(&QUrlInfo_Adaptor::cbs_setLastModified_2175_0, dt);
    } else {
      QUrlInfo::setLastModified(dt);
    }
  }

  //  [adaptor impl] void QUrlInfo::setName(const QString &name)
  void cbs_setName_2025_0(const QString &name)
  {
    QUrlInfo::setName(name);
  }

  virtual void setName(const QString &name)
  {
    if (cb_setName_2025_0.can_issue()) {
      cb_setName_2025_0.issue<QUrlInfo_Adaptor, const QString &>(&QUrlInfo_Adaptor::cbs_setName_2025_0, name);
    } else {
      QUrlInfo::setName(name);
    }
  }

  //  [adaptor impl] void QUrlInfo::setOwner(const QString &s)
  void cbs_setOwner_2025_0(const QString &s)
  {
    QUrlInfo::setOwner(s);
  }

  virtual void setOwner(const QString &s)
  {
    if (cb_setOwner_2025_0.can_issue()) {
      cb_setOwner_2025_0.issue<QUrlInfo_Adaptor, const QString &>(&QUrlInfo_Adaptor::cbs_setOwner_2025_0, s);
    } else {
      QUrlInfo::setOwner(s);
    }
  }

  //  [adaptor impl] void QUrlInfo::setPermissions(int p)
  void cbs_setPermissions_767_0(int p)
  {
    QUrlInfo::setPermissions(p);
  }

  virtual void setPermissions(int p)
  {
    if (cb_setPermissions_767_0.can_issue()) {
      cb_setPermissions_767_0.issue<QUrlInfo_Adaptor, int>(&QUrlInfo_Adaptor::cbs_setPermissions_767_0, p);
    } else {
      QUrlInfo::setPermissions(p);
    }
  }

  //  [adaptor impl] void QUrlInfo::setReadable(bool b)
  void cbs_setReadable_864_0(bool b)
  {
    QUrlInfo::setReadable(b);
  }

  virtual void setReadable(bool b)
  {
    if (cb_setReadable_864_0.can_issue()) {
      cb_setReadable_864_0.issue<QUrlInfo_Adaptor, bool>(&QUrlInfo_Adaptor::cbs_setReadable_864_0, b);
    } else {
      QUrlInfo::setReadable(b);
    }
  }

  //  [adaptor impl] void QUrlInfo::setSize(qint64 size)
  void cbs_setSize_986_0(qint64 size)
  {
    QUrlInfo::setSize(size);
  }

  virtual void setSize(qint64 size)
  {
    if (cb_setSize_986_0.can_issue()) {
      cb_setSize_986_0.issue<QUrlInfo_Adaptor, qint64>(&QUrlInfo_Adaptor::cbs_setSize_986_0, size);
    } else {
      QUrlInfo::setSize(size);
    }
  }

  //  [adaptor impl] void QUrlInfo::setSymLink(bool b)
  void cbs_setSymLink_864_0(bool b)
  {
    QUrlInfo::setSymLink(b);
  }

  virtual void setSymLink(bool b)
  {
    if (cb_setSymLink_864_0.can_issue()) {
      cb_setSymLink_864_0.issue<QUrlInfo_Adaptor, bool>(&QUrlInfo_Adaptor::cbs_setSymLink_864_0, b);
    } else {
      QUrlInfo::setSymLink(b);
    }
  }

  //  [adaptor impl] void QUrlInfo::setWritable(bool b)
  void cbs_setWritable_864_0(bool b)
  {
    QUrlInfo::setWritable(b);
  }

  virtual void setWritable(bool b)
  {
    if (cb_setWritable_864_0.can_issue()) {
      cb_setWritable_864_0.issue<QUrlInfo_Adaptor, bool>(&QUrlInfo_Adaptor::cbs_setWritable_864_0, b);
    } else {
      QUrlInfo::setWritable(b);
    }
  }

  gsi::Callback cb_setDir_864_0;
  gsi::Callback cb_setFile_864_0;
  gsi::Callback cb_setGroup_2025_0;
  gsi::Callback cb_setLastModified_2175_0;
  gsi::Callback cb_setName_2025_0;
  gsi::Callback cb_setOwner_2025_0;
  gsi::Callback cb_setPermissions_767_0;
  gsi::Callback cb_setReadable_864_0;
  gsi::Callback cb_setSize_986_0;
  gsi::Callback cb_setSymLink_864_0;
  gsi::Callback cb_setWritable_864_0;
};

QUrlInfo_Adaptor::~QUrlInfo_Adaptor() { }

//  Constructor QUrlInfo::QUrlInfo() (adaptor class)

static void _init_ctor_QUrlInfo_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QUrlInfo_Adaptor> ();
}

static void _call_ctor_QUrlInfo_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QUrlInfo_Adaptor *> (new QUrlInfo_Adaptor ());
}


//  Constructor QUrlInfo::QUrlInfo(const QUrlInfo &ui) (adaptor class)

static void _init_ctor_QUrlInfo_Adaptor_2097 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ui");
  decl->add_arg<const QUrlInfo & > (argspec_0);
  decl->set_return_new<QUrlInfo_Adaptor> ();
}

static void _call_ctor_QUrlInfo_Adaptor_2097 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrlInfo &arg1 = gsi::arg_reader<const QUrlInfo & >() (args, heap);
  ret.write<QUrlInfo_Adaptor *> (new QUrlInfo_Adaptor (arg1));
}


// void QUrlInfo::setDir(bool b)

static void _init_cbs_setDir_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setDir_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo_Adaptor *)cls)->cbs_setDir_864_0 (arg1);
}

static void _set_callback_cbs_setDir_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setDir_864_0 = cb;
}


// void QUrlInfo::setFile(bool b)

static void _init_cbs_setFile_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setFile_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo_Adaptor *)cls)->cbs_setFile_864_0 (arg1);
}

static void _set_callback_cbs_setFile_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setFile_864_0 = cb;
}


// void QUrlInfo::setGroup(const QString &s)

static void _init_cbs_setGroup_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setGroup_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo_Adaptor *)cls)->cbs_setGroup_2025_0 (arg1);
}

static void _set_callback_cbs_setGroup_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setGroup_2025_0 = cb;
}


// void QUrlInfo::setLastModified(const QDateTime &dt)

static void _init_cbs_setLastModified_2175_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dt");
  decl->add_arg<const QDateTime & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setLastModified_2175_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDateTime &arg1 = args.read<const QDateTime & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo_Adaptor *)cls)->cbs_setLastModified_2175_0 (arg1);
}

static void _set_callback_cbs_setLastModified_2175_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setLastModified_2175_0 = cb;
}


// void QUrlInfo::setName(const QString &name)

static void _init_cbs_setName_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setName_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo_Adaptor *)cls)->cbs_setName_2025_0 (arg1);
}

static void _set_callback_cbs_setName_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setName_2025_0 = cb;
}


// void QUrlInfo::setOwner(const QString &s)

static void _init_cbs_setOwner_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setOwner_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo_Adaptor *)cls)->cbs_setOwner_2025_0 (arg1);
}

static void _set_callback_cbs_setOwner_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setOwner_2025_0 = cb;
}


// void QUrlInfo::setPermissions(int p)

static void _init_cbs_setPermissions_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setPermissions_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo_Adaptor *)cls)->cbs_setPermissions_767_0 (arg1);
}

static void _set_callback_cbs_setPermissions_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setPermissions_767_0 = cb;
}


// void QUrlInfo::setReadable(bool b)

static void _init_cbs_setReadable_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setReadable_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo_Adaptor *)cls)->cbs_setReadable_864_0 (arg1);
}

static void _set_callback_cbs_setReadable_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setReadable_864_0 = cb;
}


// void QUrlInfo::setSize(qint64 size)

static void _init_cbs_setSize_986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSize_986_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = args.read<qint64 > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo_Adaptor *)cls)->cbs_setSize_986_0 (arg1);
}

static void _set_callback_cbs_setSize_986_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setSize_986_0 = cb;
}


// void QUrlInfo::setSymLink(bool b)

static void _init_cbs_setSymLink_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSymLink_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo_Adaptor *)cls)->cbs_setSymLink_864_0 (arg1);
}

static void _set_callback_cbs_setSymLink_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setSymLink_864_0 = cb;
}


// void QUrlInfo::setWritable(bool b)

static void _init_cbs_setWritable_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setWritable_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrlInfo_Adaptor *)cls)->cbs_setWritable_864_0 (arg1);
}

static void _set_callback_cbs_setWritable_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setWritable_864_0 = cb;
}


namespace gsi
{

gsi::Class<QUrlInfo> &qtdecl_QUrlInfo ();

static gsi::Methods methods_QUrlInfo_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUrlInfo::QUrlInfo()\nThis method creates an object of class QUrlInfo.", &_init_ctor_QUrlInfo_Adaptor_0, &_call_ctor_QUrlInfo_Adaptor_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUrlInfo::QUrlInfo(const QUrlInfo &ui)\nThis method creates an object of class QUrlInfo.", &_init_ctor_QUrlInfo_Adaptor_2097, &_call_ctor_QUrlInfo_Adaptor_2097);
  methods += new qt_gsi::GenericMethod ("setDir", "@brief Virtual method void QUrlInfo::setDir(bool b)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setDir_864_0, &_call_cbs_setDir_864_0);
  methods += new qt_gsi::GenericMethod ("setDir", "@hide", false, &_init_cbs_setDir_864_0, &_call_cbs_setDir_864_0, &_set_callback_cbs_setDir_864_0);
  methods += new qt_gsi::GenericMethod ("setFile", "@brief Virtual method void QUrlInfo::setFile(bool b)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setFile_864_0, &_call_cbs_setFile_864_0);
  methods += new qt_gsi::GenericMethod ("setFile", "@hide", false, &_init_cbs_setFile_864_0, &_call_cbs_setFile_864_0, &_set_callback_cbs_setFile_864_0);
  methods += new qt_gsi::GenericMethod ("setGroup", "@brief Virtual method void QUrlInfo::setGroup(const QString &s)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setGroup_2025_0, &_call_cbs_setGroup_2025_0);
  methods += new qt_gsi::GenericMethod ("setGroup", "@hide", false, &_init_cbs_setGroup_2025_0, &_call_cbs_setGroup_2025_0, &_set_callback_cbs_setGroup_2025_0);
  methods += new qt_gsi::GenericMethod ("setLastModified", "@brief Virtual method void QUrlInfo::setLastModified(const QDateTime &dt)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setLastModified_2175_0, &_call_cbs_setLastModified_2175_0);
  methods += new qt_gsi::GenericMethod ("setLastModified", "@hide", false, &_init_cbs_setLastModified_2175_0, &_call_cbs_setLastModified_2175_0, &_set_callback_cbs_setLastModified_2175_0);
  methods += new qt_gsi::GenericMethod ("setName", "@brief Virtual method void QUrlInfo::setName(const QString &name)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setName_2025_0, &_call_cbs_setName_2025_0);
  methods += new qt_gsi::GenericMethod ("setName", "@hide", false, &_init_cbs_setName_2025_0, &_call_cbs_setName_2025_0, &_set_callback_cbs_setName_2025_0);
  methods += new qt_gsi::GenericMethod ("setOwner", "@brief Virtual method void QUrlInfo::setOwner(const QString &s)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setOwner_2025_0, &_call_cbs_setOwner_2025_0);
  methods += new qt_gsi::GenericMethod ("setOwner", "@hide", false, &_init_cbs_setOwner_2025_0, &_call_cbs_setOwner_2025_0, &_set_callback_cbs_setOwner_2025_0);
  methods += new qt_gsi::GenericMethod ("setPermissions", "@brief Virtual method void QUrlInfo::setPermissions(int p)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setPermissions_767_0, &_call_cbs_setPermissions_767_0);
  methods += new qt_gsi::GenericMethod ("setPermissions", "@hide", false, &_init_cbs_setPermissions_767_0, &_call_cbs_setPermissions_767_0, &_set_callback_cbs_setPermissions_767_0);
  methods += new qt_gsi::GenericMethod ("setReadable", "@brief Virtual method void QUrlInfo::setReadable(bool b)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setReadable_864_0, &_call_cbs_setReadable_864_0);
  methods += new qt_gsi::GenericMethod ("setReadable", "@hide", false, &_init_cbs_setReadable_864_0, &_call_cbs_setReadable_864_0, &_set_callback_cbs_setReadable_864_0);
  methods += new qt_gsi::GenericMethod ("setSize", "@brief Virtual method void QUrlInfo::setSize(qint64 size)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSize_986_0, &_call_cbs_setSize_986_0);
  methods += new qt_gsi::GenericMethod ("setSize", "@hide", false, &_init_cbs_setSize_986_0, &_call_cbs_setSize_986_0, &_set_callback_cbs_setSize_986_0);
  methods += new qt_gsi::GenericMethod ("setSymLink", "@brief Virtual method void QUrlInfo::setSymLink(bool b)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSymLink_864_0, &_call_cbs_setSymLink_864_0);
  methods += new qt_gsi::GenericMethod ("setSymLink", "@hide", false, &_init_cbs_setSymLink_864_0, &_call_cbs_setSymLink_864_0, &_set_callback_cbs_setSymLink_864_0);
  methods += new qt_gsi::GenericMethod ("setWritable", "@brief Virtual method void QUrlInfo::setWritable(bool b)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setWritable_864_0, &_call_cbs_setWritable_864_0);
  methods += new qt_gsi::GenericMethod ("setWritable", "@hide", false, &_init_cbs_setWritable_864_0, &_call_cbs_setWritable_864_0, &_set_callback_cbs_setWritable_864_0);
  return methods;
}

gsi::Class<QUrlInfo_Adaptor> decl_QUrlInfo_Adaptor (qtdecl_QUrlInfo (), "QtNetwork", "QUrlInfo",
  methods_QUrlInfo_Adaptor (),
  "@qt\n@brief Binding of QUrlInfo");

}

