
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2026 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSettings.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QSettings>
#include <QChildEvent>
#include <QEvent>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSettings

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSettings::staticMetaObject);
}


// QStringList QSettings::allKeys()


static void _init_f_allKeys_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_allKeys_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QSettings *)cls)->allKeys ());
}


// QString QSettings::applicationName()


static void _init_f_applicationName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_applicationName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QSettings *)cls)->applicationName ());
}


// void QSettings::beginGroup(const QString &prefix)


static void _init_f_beginGroup_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("prefix");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_beginGroup_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSettings *)cls)->beginGroup (arg1);
}


// int QSettings::beginReadArray(const QString &prefix)


static void _init_f_beginReadArray_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("prefix");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_beginReadArray_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<int > ((int)((QSettings *)cls)->beginReadArray (arg1));
}


// void QSettings::beginWriteArray(const QString &prefix, int size)


static void _init_f_beginWriteArray_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("prefix");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("size", true, "-1");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_beginWriteArray_2684 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSettings *)cls)->beginWriteArray (arg1, arg2);
}


// QStringList QSettings::childGroups()


static void _init_f_childGroups_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_childGroups_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QSettings *)cls)->childGroups ());
}


// QStringList QSettings::childKeys()


static void _init_f_childKeys_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_childKeys_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QSettings *)cls)->childKeys ());
}


// void QSettings::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSettings *)cls)->clear ();
}


// bool QSettings::contains(const QString &key)


static void _init_f_contains_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_contains_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QSettings *)cls)->contains (arg1));
}


// void QSettings::endArray()


static void _init_f_endArray_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_endArray_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSettings *)cls)->endArray ();
}


// void QSettings::endGroup()


static void _init_f_endGroup_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_endGroup_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSettings *)cls)->endGroup ();
}


// bool QSettings::fallbacksEnabled()


static void _init_f_fallbacksEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_fallbacksEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSettings *)cls)->fallbacksEnabled ());
}


// QString QSettings::fileName()


static void _init_f_fileName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fileName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QSettings *)cls)->fileName ());
}


// QSettings::Format QSettings::format()


static void _init_f_format_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSettings::Format>::target_type > ();
}

static void _call_f_format_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSettings::Format>::target_type > ((qt_gsi::Converter<QSettings::Format>::target_type)qt_gsi::CppToQtAdaptor<QSettings::Format>(((QSettings *)cls)->format ()));
}


// QString QSettings::group()


static void _init_f_group_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_group_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QSettings *)cls)->group ());
}


// bool QSettings::isWritable()


static void _init_f_isWritable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWritable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSettings *)cls)->isWritable ());
}


// QString QSettings::organizationName()


static void _init_f_organizationName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_organizationName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QSettings *)cls)->organizationName ());
}


// void QSettings::remove(const QString &key)


static void _init_f_remove_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_remove_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSettings *)cls)->remove (arg1);
}


// QSettings::Scope QSettings::scope()


static void _init_f_scope_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSettings::Scope>::target_type > ();
}

static void _call_f_scope_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSettings::Scope>::target_type > ((qt_gsi::Converter<QSettings::Scope>::target_type)qt_gsi::CppToQtAdaptor<QSettings::Scope>(((QSettings *)cls)->scope ()));
}


// void QSettings::setArrayIndex(int i)


static void _init_f_setArrayIndex_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setArrayIndex_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSettings *)cls)->setArrayIndex (arg1);
}


// void QSettings::setFallbacksEnabled(bool b)


static void _init_f_setFallbacksEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFallbacksEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSettings *)cls)->setFallbacksEnabled (arg1);
}


// void QSettings::setValue(const QString &key, const QVariant &value)


static void _init_f_setValue_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setValue_4036 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSettings *)cls)->setValue (arg1, arg2);
}


// QSettings::Status QSettings::status()


static void _init_f_status_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSettings::Status>::target_type > ();
}

static void _call_f_status_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSettings::Status>::target_type > ((qt_gsi::Converter<QSettings::Status>::target_type)qt_gsi::CppToQtAdaptor<QSettings::Status>(((QSettings *)cls)->status ()));
}


// void QSettings::sync()


static void _init_f_sync_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_sync_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSettings *)cls)->sync ();
}


// QVariant QSettings::value(const QString &key, const QVariant &defaultValue)


static void _init_f_value_c4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("defaultValue", true, "QVariant()");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_value_c4036 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QVariant &arg2 = args ? gsi::arg_reader<const QVariant & >() (args, heap) : gsi::arg_maker<const QVariant & >() (QVariant(), heap);
  ret.write<QVariant > ((QVariant)((QSettings *)cls)->value (arg1, arg2));
}


// static QSettings::Format QSettings::defaultFormat()


static void _init_f_defaultFormat_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSettings::Format>::target_type > ();
}

static void _call_f_defaultFormat_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSettings::Format>::target_type > ((qt_gsi::Converter<QSettings::Format>::target_type)qt_gsi::CppToQtAdaptor<QSettings::Format>(QSettings::defaultFormat ()));
}


// static void QSettings::setDefaultFormat(QSettings::Format format)


static void _init_f_setDefaultFormat_2099 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QSettings::Format>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultFormat_2099 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSettings::Format>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSettings::Format>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QSettings::setDefaultFormat (qt_gsi::QtToCppAdaptor<QSettings::Format>(arg1).cref());
}


// static void QSettings::setPath(QSettings::Format format, QSettings::Scope scope, const QString &path)


static void _init_f_setPath_5896 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QSettings::Format>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("scope");
  decl->add_arg<const qt_gsi::Converter<QSettings::Scope>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("path");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setPath_5896 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSettings::Format>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSettings::Format>::target_type & >() (args, heap);
  const qt_gsi::Converter<QSettings::Scope>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QSettings::Scope>::target_type & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QSettings::setPath (qt_gsi::QtToCppAdaptor<QSettings::Format>(arg1).cref(), qt_gsi::QtToCppAdaptor<QSettings::Scope>(arg2).cref(), arg3);
}


// static void QSettings::setSystemIniPath(const QString &dir)


static void _init_f_setSystemIniPath_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSystemIniPath_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QSettings::setSystemIniPath (arg1);
}


// static void QSettings::setUserIniPath(const QString &dir)


static void _init_f_setUserIniPath_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUserIniPath_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QSettings::setUserIniPath (arg1);
}


// static QString QSettings::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QSettings::tr (arg1, arg2));
}


// static QString QSettings::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QSettings::tr (arg1, arg2, arg3));
}


// static QString QSettings::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QSettings::trUtf8 (arg1, arg2));
}


// static QString QSettings::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QSettings::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QSettings () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("allKeys", "@brief Method QStringList QSettings::allKeys()\n", true, &_init_f_allKeys_c0, &_call_f_allKeys_c0);
  methods += new qt_gsi::GenericMethod ("applicationName", "@brief Method QString QSettings::applicationName()\n", true, &_init_f_applicationName_c0, &_call_f_applicationName_c0);
  methods += new qt_gsi::GenericMethod ("beginGroup", "@brief Method void QSettings::beginGroup(const QString &prefix)\n", false, &_init_f_beginGroup_2025, &_call_f_beginGroup_2025);
  methods += new qt_gsi::GenericMethod ("beginReadArray", "@brief Method int QSettings::beginReadArray(const QString &prefix)\n", false, &_init_f_beginReadArray_2025, &_call_f_beginReadArray_2025);
  methods += new qt_gsi::GenericMethod ("beginWriteArray", "@brief Method void QSettings::beginWriteArray(const QString &prefix, int size)\n", false, &_init_f_beginWriteArray_2684, &_call_f_beginWriteArray_2684);
  methods += new qt_gsi::GenericMethod ("childGroups", "@brief Method QStringList QSettings::childGroups()\n", true, &_init_f_childGroups_c0, &_call_f_childGroups_c0);
  methods += new qt_gsi::GenericMethod ("childKeys", "@brief Method QStringList QSettings::childKeys()\n", true, &_init_f_childKeys_c0, &_call_f_childKeys_c0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QSettings::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("contains", "@brief Method bool QSettings::contains(const QString &key)\n", true, &_init_f_contains_c2025, &_call_f_contains_c2025);
  methods += new qt_gsi::GenericMethod ("endArray", "@brief Method void QSettings::endArray()\n", false, &_init_f_endArray_0, &_call_f_endArray_0);
  methods += new qt_gsi::GenericMethod ("endGroup", "@brief Method void QSettings::endGroup()\n", false, &_init_f_endGroup_0, &_call_f_endGroup_0);
  methods += new qt_gsi::GenericMethod (":fallbacksEnabled", "@brief Method bool QSettings::fallbacksEnabled()\n", true, &_init_f_fallbacksEnabled_c0, &_call_f_fallbacksEnabled_c0);
  methods += new qt_gsi::GenericMethod ("fileName", "@brief Method QString QSettings::fileName()\n", true, &_init_f_fileName_c0, &_call_f_fileName_c0);
  methods += new qt_gsi::GenericMethod ("format", "@brief Method QSettings::Format QSettings::format()\n", true, &_init_f_format_c0, &_call_f_format_c0);
  methods += new qt_gsi::GenericMethod ("group", "@brief Method QString QSettings::group()\n", true, &_init_f_group_c0, &_call_f_group_c0);
  methods += new qt_gsi::GenericMethod ("isWritable?", "@brief Method bool QSettings::isWritable()\n", true, &_init_f_isWritable_c0, &_call_f_isWritable_c0);
  methods += new qt_gsi::GenericMethod ("organizationName", "@brief Method QString QSettings::organizationName()\n", true, &_init_f_organizationName_c0, &_call_f_organizationName_c0);
  methods += new qt_gsi::GenericMethod ("remove", "@brief Method void QSettings::remove(const QString &key)\n", false, &_init_f_remove_2025, &_call_f_remove_2025);
  methods += new qt_gsi::GenericMethod ("scope", "@brief Method QSettings::Scope QSettings::scope()\n", true, &_init_f_scope_c0, &_call_f_scope_c0);
  methods += new qt_gsi::GenericMethod ("setArrayIndex", "@brief Method void QSettings::setArrayIndex(int i)\n", false, &_init_f_setArrayIndex_767, &_call_f_setArrayIndex_767);
  methods += new qt_gsi::GenericMethod ("setFallbacksEnabled|fallbacksEnabled=", "@brief Method void QSettings::setFallbacksEnabled(bool b)\n", false, &_init_f_setFallbacksEnabled_864, &_call_f_setFallbacksEnabled_864);
  methods += new qt_gsi::GenericMethod ("setValue", "@brief Method void QSettings::setValue(const QString &key, const QVariant &value)\n", false, &_init_f_setValue_4036, &_call_f_setValue_4036);
  methods += new qt_gsi::GenericMethod ("status", "@brief Method QSettings::Status QSettings::status()\n", true, &_init_f_status_c0, &_call_f_status_c0);
  methods += new qt_gsi::GenericMethod ("sync", "@brief Method void QSettings::sync()\n", false, &_init_f_sync_0, &_call_f_sync_0);
  methods += new qt_gsi::GenericMethod ("value", "@brief Method QVariant QSettings::value(const QString &key, const QVariant &defaultValue)\n", true, &_init_f_value_c4036, &_call_f_value_c4036);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QSettings::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod (":defaultFormat", "@brief Static method QSettings::Format QSettings::defaultFormat()\nThis method is static and can be called without an instance.", &_init_f_defaultFormat_0, &_call_f_defaultFormat_0);
  methods += new qt_gsi::GenericStaticMethod ("setDefaultFormat|defaultFormat=", "@brief Static method void QSettings::setDefaultFormat(QSettings::Format format)\nThis method is static and can be called without an instance.", &_init_f_setDefaultFormat_2099, &_call_f_setDefaultFormat_2099);
  methods += new qt_gsi::GenericStaticMethod ("setPath", "@brief Static method void QSettings::setPath(QSettings::Format format, QSettings::Scope scope, const QString &path)\nThis method is static and can be called without an instance.", &_init_f_setPath_5896, &_call_f_setPath_5896);
  methods += new qt_gsi::GenericStaticMethod ("setSystemIniPath", "@brief Static method void QSettings::setSystemIniPath(const QString &dir)\nThis method is static and can be called without an instance.", &_init_f_setSystemIniPath_2025, &_call_f_setSystemIniPath_2025);
  methods += new qt_gsi::GenericStaticMethod ("setUserIniPath", "@brief Static method void QSettings::setUserIniPath(const QString &dir)\nThis method is static and can be called without an instance.", &_init_f_setUserIniPath_2025, &_call_f_setUserIniPath_2025);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSettings::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSettings::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSettings::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSettings::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QSettings> decl_QSettings (qtdecl_QObject (), "QtCore", "QSettings_Native",
  methods_QSettings (),
  "@hide\n@alias QSettings");

GSI_QTCORE_PUBLIC gsi::Class<QSettings> &qtdecl_QSettings () { return decl_QSettings; }

}


class QSettings_Adaptor : public QSettings, public qt_gsi::QtObjectBase
{
public:

  virtual ~QSettings_Adaptor();

  //  [adaptor ctor] QSettings::QSettings(const QString &organization, const QString &application, QObject *parent)
  QSettings_Adaptor(const QString &organization) : QSettings(organization)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(const QString &organization, const QString &application, QObject *parent)
  QSettings_Adaptor(const QString &organization, const QString &application) : QSettings(organization, application)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(const QString &organization, const QString &application, QObject *parent)
  QSettings_Adaptor(const QString &organization, const QString &application, QObject *parent) : QSettings(organization, application, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent)
  QSettings_Adaptor(QSettings::Scope scope, const QString &organization) : QSettings(scope, organization)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent)
  QSettings_Adaptor(QSettings::Scope scope, const QString &organization, const QString &application) : QSettings(scope, organization, application)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent)
  QSettings_Adaptor(QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent) : QSettings(scope, organization, application, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(QSettings::Format format, QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent)
  QSettings_Adaptor(QSettings::Format format, QSettings::Scope scope, const QString &organization) : QSettings(format, scope, organization)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(QSettings::Format format, QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent)
  QSettings_Adaptor(QSettings::Format format, QSettings::Scope scope, const QString &organization, const QString &application) : QSettings(format, scope, organization, application)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(QSettings::Format format, QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent)
  QSettings_Adaptor(QSettings::Format format, QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent) : QSettings(format, scope, organization, application, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(const QString &fileName, QSettings::Format format, QObject *parent)
  QSettings_Adaptor(const QString &fileName, QSettings::Format format) : QSettings(fileName, format)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(const QString &fileName, QSettings::Format format, QObject *parent)
  QSettings_Adaptor(const QString &fileName, QSettings::Format format, QObject *parent) : QSettings(fileName, format, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(QObject *parent)
  QSettings_Adaptor() : QSettings()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(QObject *parent)
  QSettings_Adaptor(QObject *parent) : QSettings(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] int QSettings::receivers(const char *signal)
  int fp_QSettings_receivers_c1731 (const char *signal) const {
    return QSettings::receivers(signal);
  }

  //  [expose] QObject *QSettings::sender()
  QObject * fp_QSettings_sender_c0 () const {
    return QSettings::sender();
  }

  //  [adaptor impl] bool QSettings::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QSettings::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QSettings_Adaptor, bool, QObject *, QEvent *>(&QSettings_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QSettings::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QSettings::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QSettings::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QSettings_Adaptor, QChildEvent *>(&QSettings_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QSettings::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QSettings::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QSettings::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QSettings_Adaptor, QEvent *>(&QSettings_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QSettings::customEvent(arg1);
    }
  }

  //  [emitter impl] void QSettings::destroyed(QObject *)
  void emitter_QSettings_destroyed_1302(QObject *arg1)
  {
    emit QSettings::destroyed(arg1);
  }

  //  [adaptor impl] void QSettings::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QSettings::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QSettings_Adaptor, const char *>(&QSettings_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QSettings::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QSettings::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QSettings::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QSettings_Adaptor, bool, QEvent *>(&QSettings_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QSettings::event(_event);
    }
  }

  //  [adaptor impl] void QSettings::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QSettings::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QSettings_Adaptor, QTimerEvent *>(&QSettings_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QSettings::timerEvent(arg1);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QSettings_Adaptor::~QSettings_Adaptor() { }

//  Constructor QSettings::QSettings(const QString &organization, const QString &application, QObject *parent) (adaptor class)

static void _init_ctor_QSettings_Adaptor_5136 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("organization");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("application", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_2);
  decl->set_return_new<QSettings_Adaptor> ();
}

static void _call_ctor_QSettings_Adaptor_5136 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  QObject *arg3 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QSettings_Adaptor *> (new QSettings_Adaptor (arg1, arg2, arg3));
}


//  Constructor QSettings::QSettings(QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent) (adaptor class)

static void _init_ctor_QSettings_Adaptor_7016 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("scope");
  decl->add_arg<const qt_gsi::Converter<QSettings::Scope>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("organization");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("application", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_3);
  decl->set_return_new<QSettings_Adaptor> ();
}

static void _call_ctor_QSettings_Adaptor_7016 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSettings::Scope>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSettings::Scope>::target_type & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg3 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  QObject *arg4 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QSettings_Adaptor *> (new QSettings_Adaptor (qt_gsi::QtToCppAdaptor<QSettings::Scope>(arg1).cref(), arg2, arg3, arg4));
}


//  Constructor QSettings::QSettings(QSettings::Format format, QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent) (adaptor class)

static void _init_ctor_QSettings_Adaptor_9007 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QSettings::Format>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("scope");
  decl->add_arg<const qt_gsi::Converter<QSettings::Scope>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("organization");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("application", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_4);
  decl->set_return_new<QSettings_Adaptor> ();
}

static void _call_ctor_QSettings_Adaptor_9007 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSettings::Format>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSettings::Format>::target_type & >() (args, heap);
  const qt_gsi::Converter<QSettings::Scope>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QSettings::Scope>::target_type & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg4 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  QObject *arg5 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QSettings_Adaptor *> (new QSettings_Adaptor (qt_gsi::QtToCppAdaptor<QSettings::Format>(arg1).cref(), qt_gsi::QtToCppAdaptor<QSettings::Scope>(arg2).cref(), arg3, arg4, arg5));
}


//  Constructor QSettings::QSettings(const QString &fileName, QSettings::Format format, QObject *parent) (adaptor class)

static void _init_ctor_QSettings_Adaptor_5210 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const qt_gsi::Converter<QSettings::Format>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_2);
  decl->set_return_new<QSettings_Adaptor> ();
}

static void _call_ctor_QSettings_Adaptor_5210 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QSettings::Format>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QSettings::Format>::target_type & >() (args, heap);
  QObject *arg3 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QSettings_Adaptor *> (new QSettings_Adaptor (arg1, qt_gsi::QtToCppAdaptor<QSettings::Format>(arg2).cref(), arg3));
}


//  Constructor QSettings::QSettings(QObject *parent) (adaptor class)

static void _init_ctor_QSettings_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QSettings_Adaptor> ();
}

static void _call_ctor_QSettings_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QSettings_Adaptor *> (new QSettings_Adaptor (arg1));
}


// void QSettings::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSettings_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QSettings_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QSettings::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSettings_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSettings_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QSettings::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QSettings_Adaptor *)cls)->emitter_QSettings_destroyed_1302 (arg1);
}


// void QSettings::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSettings_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QSettings_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// bool QSettings::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSettings_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSettings_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QSettings::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSettings_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QSettings_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed int QSettings::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QSettings_Adaptor *)cls)->fp_QSettings_receivers_c1731 (arg1));
}


// exposed QObject *QSettings::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QSettings_Adaptor *)cls)->fp_QSettings_sender_c0 ());
}


// void QSettings::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSettings_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QSettings_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QSettings> &qtdecl_QSettings ();

static gsi::Methods methods_QSettings_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSettings::QSettings(const QString &organization, const QString &application, QObject *parent)\nThis method creates an object of class QSettings.", &_init_ctor_QSettings_Adaptor_5136, &_call_ctor_QSettings_Adaptor_5136);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSettings::QSettings(QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent)\nThis method creates an object of class QSettings.", &_init_ctor_QSettings_Adaptor_7016, &_call_ctor_QSettings_Adaptor_7016);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSettings::QSettings(QSettings::Format format, QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent)\nThis method creates an object of class QSettings.", &_init_ctor_QSettings_Adaptor_9007, &_call_ctor_QSettings_Adaptor_9007);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSettings::QSettings(const QString &fileName, QSettings::Format format, QObject *parent)\nThis method creates an object of class QSettings.", &_init_ctor_QSettings_Adaptor_5210, &_call_ctor_QSettings_Adaptor_5210);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSettings::QSettings(QObject *parent)\nThis method creates an object of class QSettings.", &_init_ctor_QSettings_Adaptor_1302, &_call_ctor_QSettings_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QSettings::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QSettings::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QSettings::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QSettings::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QSettings::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QSettings::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QSettings::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QSettings::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QSettings::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QSettings_Adaptor> decl_QSettings_Adaptor (qtdecl_QSettings (), "QtCore", "QSettings",
  methods_QSettings_Adaptor (),
  "@qt\n@brief Binding of QSettings");

}


//  Implementation of the enum wrapper class for QSettings::Format
namespace qt_gsi
{

static gsi::Enum<QSettings::Format> decl_QSettings_Format_Enum ("QtCore", "QSettings_Format",
    gsi::enum_const ("NativeFormat", QSettings::NativeFormat, "@brief Enum constant QSettings::NativeFormat") +
    gsi::enum_const ("IniFormat", QSettings::IniFormat, "@brief Enum constant QSettings::IniFormat") +
    gsi::enum_const ("InvalidFormat", QSettings::InvalidFormat, "@brief Enum constant QSettings::InvalidFormat") +
    gsi::enum_const ("CustomFormat1", QSettings::CustomFormat1, "@brief Enum constant QSettings::CustomFormat1") +
    gsi::enum_const ("CustomFormat2", QSettings::CustomFormat2, "@brief Enum constant QSettings::CustomFormat2") +
    gsi::enum_const ("CustomFormat3", QSettings::CustomFormat3, "@brief Enum constant QSettings::CustomFormat3") +
    gsi::enum_const ("CustomFormat4", QSettings::CustomFormat4, "@brief Enum constant QSettings::CustomFormat4") +
    gsi::enum_const ("CustomFormat5", QSettings::CustomFormat5, "@brief Enum constant QSettings::CustomFormat5") +
    gsi::enum_const ("CustomFormat6", QSettings::CustomFormat6, "@brief Enum constant QSettings::CustomFormat6") +
    gsi::enum_const ("CustomFormat7", QSettings::CustomFormat7, "@brief Enum constant QSettings::CustomFormat7") +
    gsi::enum_const ("CustomFormat8", QSettings::CustomFormat8, "@brief Enum constant QSettings::CustomFormat8") +
    gsi::enum_const ("CustomFormat9", QSettings::CustomFormat9, "@brief Enum constant QSettings::CustomFormat9") +
    gsi::enum_const ("CustomFormat10", QSettings::CustomFormat10, "@brief Enum constant QSettings::CustomFormat10") +
    gsi::enum_const ("CustomFormat11", QSettings::CustomFormat11, "@brief Enum constant QSettings::CustomFormat11") +
    gsi::enum_const ("CustomFormat12", QSettings::CustomFormat12, "@brief Enum constant QSettings::CustomFormat12") +
    gsi::enum_const ("CustomFormat13", QSettings::CustomFormat13, "@brief Enum constant QSettings::CustomFormat13") +
    gsi::enum_const ("CustomFormat14", QSettings::CustomFormat14, "@brief Enum constant QSettings::CustomFormat14") +
    gsi::enum_const ("CustomFormat15", QSettings::CustomFormat15, "@brief Enum constant QSettings::CustomFormat15") +
    gsi::enum_const ("CustomFormat16", QSettings::CustomFormat16, "@brief Enum constant QSettings::CustomFormat16"),
  "@qt\n@brief This class represents the QSettings::Format enum");

static gsi::QFlagsClass<QSettings::Format > decl_QSettings_Format_Enums ("QtCore", "QSettings_QFlags_Format",
  "@qt\n@brief This class represents the QFlags<QSettings::Format> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QSettings> inject_QSettings_Format_Enum_in_parent (decl_QSettings_Format_Enum.defs ());
static gsi::ClassExt<QSettings> decl_QSettings_Format_Enum_as_child (decl_QSettings_Format_Enum, "Format");
static gsi::ClassExt<QSettings> decl_QSettings_Format_Enums_as_child (decl_QSettings_Format_Enums, "QFlags_Format");

}


//  Implementation of the enum wrapper class for QSettings::Scope
namespace qt_gsi
{

static gsi::Enum<QSettings::Scope> decl_QSettings_Scope_Enum ("QtCore", "QSettings_Scope",
    gsi::enum_const ("UserScope", QSettings::UserScope, "@brief Enum constant QSettings::UserScope") +
    gsi::enum_const ("SystemScope", QSettings::SystemScope, "@brief Enum constant QSettings::SystemScope"),
  "@qt\n@brief This class represents the QSettings::Scope enum");

static gsi::QFlagsClass<QSettings::Scope > decl_QSettings_Scope_Enums ("QtCore", "QSettings_QFlags_Scope",
  "@qt\n@brief This class represents the QFlags<QSettings::Scope> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QSettings> inject_QSettings_Scope_Enum_in_parent (decl_QSettings_Scope_Enum.defs ());
static gsi::ClassExt<QSettings> decl_QSettings_Scope_Enum_as_child (decl_QSettings_Scope_Enum, "Scope");
static gsi::ClassExt<QSettings> decl_QSettings_Scope_Enums_as_child (decl_QSettings_Scope_Enums, "QFlags_Scope");

}


//  Implementation of the enum wrapper class for QSettings::Status
namespace qt_gsi
{

static gsi::Enum<QSettings::Status> decl_QSettings_Status_Enum ("QtCore", "QSettings_Status",
    gsi::enum_const ("NoError", QSettings::NoError, "@brief Enum constant QSettings::NoError") +
    gsi::enum_const ("AccessError", QSettings::AccessError, "@brief Enum constant QSettings::AccessError") +
    gsi::enum_const ("FormatError", QSettings::FormatError, "@brief Enum constant QSettings::FormatError"),
  "@qt\n@brief This class represents the QSettings::Status enum");

static gsi::QFlagsClass<QSettings::Status > decl_QSettings_Status_Enums ("QtCore", "QSettings_QFlags_Status",
  "@qt\n@brief This class represents the QFlags<QSettings::Status> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QSettings> inject_QSettings_Status_Enum_in_parent (decl_QSettings_Status_Enum.defs ());
static gsi::ClassExt<QSettings> decl_QSettings_Status_Enum_as_child (decl_QSettings_Status_Enum, "Status");
static gsi::ClassExt<QSettings> decl_QSettings_Status_Enums_as_child (decl_QSettings_Status_Enums, "QFlags_Status");

}

