#!/usr/bin/tclsh8.3

if { [ llength $argv ] != 2 } {
  puts "mkmebes <input> <output>"
  exit 1
}

set infile [ lindex $argv 0 ]
set outfile [ lindex $argv 1 ]

set input [ open $infile "r" ]
set txt [ read $input ]
close $input

set output [ open $outfile "w" ]

set fpos 0 

# produce a byte
proc byte { b } {
  global output
  global fpos
  incr fpos 1
  puts -nonewline $output [ binary format {c} $b ]
}
 
# produce a word
proc ushort { s } {
  global output
  global fpos
  incr fpos 2
  puts -nonewline $output [ binary format {S} $s ]
}
  
# produce a double word
proc uint { i } {
  global output
  global fpos
  incr fpos 4
  puts -nonewline $output [ binary format {I} $i ]
}

# produce a string
proc str { s } {
  global output
  global fpos
  if { [ string length $s ] % 1 == 1 } {
    set s "$s "
  }
  incr fpos [ string length $s ]
  puts -nonewline $output $s
}

# skip to next record
proc next_record { len } {
  global fpos
  while { $fpos%$len != 0 } {
    byte 0
  }
}

# produce header
proc mode5_header { dbu height cx cy month day year patname } {
  byte 3
  byte 1

  uint [ expr int(floor($dbu*4096*65536+0.5)) ]
  ushort $height

  uint $cx
  uint $cy

  ushort $month
  ushort $day
  ushort $year

  # data field 1
  ushort 6
  str $patname

  # data field 2
  # dummy table 
  uint 6
  uint 2 
  ushort 0
  uint 0 
  ushort 0

  # data field 3
  ushort 20
  str "Some information    "

  next_record 2048
}

# produce tail
proc mode5_tail {} {
  ushort 4
  next_record 2048
}

# produce a box figure data
proc box { x y w h } {
  ushort [ expr ($h-1)*64+16 ]
  ushort $w
  ushort $x
  ushort $y
}

# produce generic trapezoid figure data
proc trap { x y w h dx1 dx2 } {

  if { $dx1 == 0 && $dx2 == 0 } {

    box $x $y $w $h

  } elseif { $dx1 == $dx2 } {

    set x [ expr int(floor($x*16+0.5)) ]
    set w [ expr int(floor($w*16+0.5)) ]
    set dx1 [ expr int(floor($dx1*16+0.5)) ]
    ushort [ expr ($h-1)*0x40+17 ]
    ushort $w
    ushort $x
    ushort $y
    ushort [ expr $dx1&0xffff ]
    ushort [ expr (($dx1&0x003f0000)>>6)+(($x&0x1f0000)>>11)+(($w&0x1f0000)>>16) ]

  } elseif { $dx2 == 0 } {

    set x [ expr int(floor($x*16+0.5)) ]
    set w [ expr int(floor($w*16+0.5)) ]
    set dx1 [ expr int(floor($dx1*16+0.5)) ]
    ushort [ expr ($h-1)*0x40+18 ]
    ushort $w
    ushort $x
    ushort $y
    ushort [ expr $dx1&0xffff ]
    ushort [ expr (($dx1&0x003f0000)>>6)+(($x&0x1f0000)>>11)+(($w&0x1f0000)>>16) ]

  } elseif { $dx1 == 0 } {

    set x [ expr int(floor($x*16+0.5)) ]
    set w [ expr int(floor($w*16+0.5)) ]
    set dx2 [ expr int(floor($dx2*16+0.5)) ]
    ushort [ expr ($h-1)*0x40+19 ]
    ushort $w
    ushort $x
    ushort $y
    ushort [ expr $dx2&0xffff ]
    ushort [ expr (($dx2&0x003f0000)>>6)+(($x&0x1f0000)>>11)+(($w&0x1f0000)>>16) ]

  } else {

    set x [ expr int(floor($x*16+0.5)) ]
    set w [ expr int(floor($w*16+0.5)) ]
    set dx1 [ expr int(floor($dx1*16+0.5)) ]
    set dx2 [ expr int(floor($dx2*16+0.5)) ]
    ushort [ expr ($h-1)*0x40+20 ]
    ushort $w
    ushort $x
    ushort [ expr (($dx2&0x003f0000)>>6)+$y ]
    ushort [ expr $dx1&0xffff ]
    ushort [ expr $dx2&0xffff ]
    ushort [ expr (($dx1&0x003f0000)>>6)+(($x&0x1f0000)>>11)+(($w&0x1f0000)>>16) ]

  }
}

# evaluate the script

eval $txt


