
/*
  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein
*/

#include "dbMEBESReader.h"
#include "dbLoadLayoutOptions.h"
#include "layPlugin.h"
#include "layNativePlugin.h"
#include "layMEBESReaderPlugin.h"
#include "ui_MEBESReaderOptionPage.h"


namespace lay
{

// ---------------------------------------------------------------
//  MEBESReaderOptionPage definition and implementation

MEBESReaderOptionPage::MEBESReaderOptionPage (QWidget *parent)
  : StreamReaderOptionsPage (parent)
{
  mp_ui = new Ui::MEBESReaderOptionPage ();
  mp_ui->setupUi (this);
}

MEBESReaderOptionPage::~MEBESReaderOptionPage ()
{
  delete mp_ui;
  mp_ui = 0;
}

void 
MEBESReaderOptionPage::setup (const db::FormatSpecificReaderOptions *o, const db::Technology * /*tech*/)
{
  static const db::MEBESReaderOptions default_options;
  const db::MEBESReaderOptions *options = dynamic_cast<const db::MEBESReaderOptions *> (o);
  if (!options) {
    options = &default_options;
  }

  mp_ui->layer_map->set_layer_map (options->layer_map);
  mp_ui->read_all_cbx->setChecked (options->create_other_layers);

  mp_ui->invert_cbx->setChecked (options->invert);
  mp_ui->subresolution_cbx->setChecked (options->subresolution);
  mp_ui->num_stripes_per_cell_sb->setValue (options->num_stripes_per_cell);
  mp_ui->num_shapes_per_cell_sb->setValue (options->num_shapes_per_cell);
  mp_ui->data_layer_le->setText (tl::to_qstring (db::LayerProperties (options->data_layer, options->data_datatype, options->data_name).to_string ()));
  if (options->produce_boundary) {
    mp_ui->boundary_layer_le->setText (tl::to_qstring (db::LayerProperties (options->boundary_layer, options->boundary_datatype, options->boundary_name).to_string ()));
  } else {
    mp_ui->boundary_layer_le->setText (QString ());
  }
}

void 
MEBESReaderOptionPage::commit (db::FormatSpecificReaderOptions *o, const db::Technology * /*tech*/)
{
  db::MEBESReaderOptions *options = dynamic_cast<db::MEBESReaderOptions *> (o);
  if (options) {

    options->layer_map = mp_ui->layer_map->get_layer_map ();
    options->create_other_layers = mp_ui->read_all_cbx->isChecked ();

    options->invert = mp_ui->invert_cbx->isChecked ();
    options->subresolution = mp_ui->subresolution_cbx->isChecked ();
    options->num_stripes_per_cell = mp_ui->num_stripes_per_cell_sb->value ();
    options->num_shapes_per_cell = mp_ui->num_shapes_per_cell_sb->value ();

    db::LayerProperties data (options->data_layer, options->data_datatype, options->data_name);
    std::string data_str = tl::to_string (mp_ui->data_layer_le->text ());
    tl::Extractor ex (data_str.c_str ());
    data.read (ex);
    options->data_layer = data.layer;
    options->data_datatype = data.datatype;
    options->data_name = data.name;

    db::LayerProperties boundary (options->boundary_layer, options->boundary_datatype, options->boundary_name);
    std::string boundary_str = tl::to_string (mp_ui->boundary_layer_le->text ());
    ex = tl::Extractor (boundary_str.c_str ());
    if (ex.at_end ()) {

      options->produce_boundary = false;
      options->boundary_layer = 0;
      options->boundary_datatype = 0;
      options->boundary_name = std::string ();

    } else {

      boundary.read (ex);
      options->produce_boundary = true;
      options->boundary_layer = boundary.layer;
      options->boundary_datatype = boundary.datatype;
      options->boundary_name = boundary.name;

    }
  }
}

// ---------------------------------------------------------------
//  MEBESReaderPluginDeclaration definition and implementation

class MEBESReaderPluginDeclaration
  : public StreamReaderPluginDeclaration
{
public:
  MEBESReaderPluginDeclaration () 
    : StreamReaderPluginDeclaration (db::MEBESReaderOptions ().format_name ())
  {
    // .. nothing yet ..
  }

  StreamReaderOptionsPage *format_specific_options_page (QWidget *parent) const
  {
    return new MEBESReaderOptionPage (parent);
  }

  db::FormatSpecificReaderOptions *create_specific_options () const
  {
    return new db::MEBESReaderOptions ();
  }
};

static tl::RegisteredClass<lay::PluginDeclaration> plugin_decl (new lay::MEBESReaderPluginDeclaration (), 100000, "MEBESReader");

}





